-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_ResponseHeader_GetHeaderNumericByDataLookupId')
	EXEC('CREATE FUNCTION [dbo].[FNC_ResponseHeader_GetHeaderNumericByDataLookupId]() RETURNS bit AS BEGIN RETURN 0 END')
GO

-- =============================================
-- Author:		Dominic Contardi
-- Create date: 05/08/2019
-- Description:	Gets a numeric ResponseHeader by DataLookupId
-- Version:		1
-- =============================================
-- DPC TFS 126904: Created
-- =============================================
ALTER FUNCTION [dbo].[FNC_ResponseHeader_GetHeaderNumericByDataLookupId] (
	@ResponseId int,
	@DataLookupId int
) 
RETURNS nvarchar(255)
AS
BEGIN
RETURN (	SELECT TOP 1 Header_Numeric 
			FROM QMS_ResponseHeader response
			INNER JOIN QMS_AssessmentHeader assessment ON response.AssessmentHeaderID = assessment.AssessmentHeaderID
			WHERE response.ResponseID = @ResponseId
			AND assessment.DataLookupID = @DataLookupId
			AND response.RecordStatus < 201
			AND assessment.RecordStatus < 201
			AND assessment.DataTypeID = 9
			AND response.Header_Text IS NOT NULL
		)
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_ResponseQuestion_GetNumericAnswerByName')
	EXEC('CREATE FUNCTION [dbo].[FNC_ResponseQuestion_GetNumericAnswerByName]() RETURNS bit AS BEGIN RETURN 0 END')
GO
-- =============================================
-- Author:		Dominic Contardi
-- Create date: 05/08/2019
-- Description:	Gets a numeric ResponseQuestion by Name (Can use wildcards)
-- Version:		1
-- =============================================
-- DPC TFS 126904: Created
-- =============================================
ALTER FUNCTION [dbo].[FNC_ResponseQuestion_GetNumericAnswerByName](
	@ResponseId int, 
	@Question nvarchar(255)
)
RETURNS nvarchar(255)
AS 
BEGIN
	RETURN (
		SELECT TOP 1 response.Response_Numeric
		FROM QMS_ResponseQuestion response
		INNER JOIN QMS_AssessmentQuestion assessment ON response.AssessmentQuestionID = assessment.AssessmentQuestionID
		INNER JOIN QMS_QuestionPool question ON assessment.QuestionID = question.QuestionID
		WHERE response.ResponseID = @ResponseId
		AND question.Question LIKE @Question
		AND response.RecordStatus < 201
		AND assessment.RecordStatus < 201
		AND question.RecordStatus < 201
	)
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_Response_MultiCheckQuestion')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_Response_MultiCheckQuestion] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: Jon Edwards
-- Create date	: 10/01/2014
-- Description	: Returns data for Multi Check parent and child questions
-- Version		: 8
-- =============================================
-- JE TFS 8717		: amended filter to show archived questions if they have a response against them
-- JE TFS 13-1588	: added RecordStatus column
-- JE TFS 13-2555	: display Score after response when Score > 0 and return NoOfQuestionsToHide
-- JE TFS 13-43069	: Changed functionality when applying 'Suppress Blanks' setting.  The process now excludes questions 
--                    where there are null responses, but does not exclude null responses from included questions. The 
--                    score and qa flags are duplicated in every question response of a check and exlcusion may result in
--                    the score/qa flag being shown on the report.
-- JT TFS 125510	: Make sure response data is shown even if the related assessment is deleted or archived (by recordstatus).
-- NM TFS 83743		: Make sure child checks are correctly ordered in association with their parent check.
-- =============================================
ALTER PROCEDURE [dbo].[RPT_Response_MultiCheckQuestion]
	@UserID int
AS
BEGIN

--declare @UserID int
--select @UserID = 1

	DECLARE @SupressBlanks bit;
	SET @SupressBlanks = ISNULL(CAST(dbo.FNC_GetOptionValue(36) AS bit),0);

	IF NULLIF(object_id('tempdb..#tmpAllAssesmentQuestions'), 0) IS NOT NULL DROP TABLE #tmpAllAssesmentQuestions
	SELECT
		question.AssessmentID,
		sort.AssessmentQuestionID,
		sort.SortIndex,
		sort.QuestionNumber
	INTO #tmpAllAssesmentQuestions
	FROM dbo.FNC_AssessmentQuestion_Sort_Multi(@UserID) sort -- This is the most expensive bit of code.
	INNER JOIN QMS_AssessmentQuestion question
		ON sort.AssessmentQuestionID = question.AssessmentQuestionID;

	IF NULLIF(object_id('tempdb..#tmpShownAssessmentQuestions'), 0) IS NOT NULL DROP TABLE #tmpShownAssessmentQuestions
	SELECT responseQuestion.ResponseID, includedAssessmentQuestions.AssessmentQuestionID 
	INTO #tmpShownAssessmentQuestions
	FROM
	(
		SELECT assessmentQuestions.AssessmentQuestionID
		FROM #tmpAllAssesmentQuestions AS assessmentQuestions
		INNER JOIN QMS_ResponseQuestion
			ON QMS_ResponseQuestion.AssessmentQuestionID = assessmentQuestions.AssessmentQuestionID
		INNER JOIN TEMP_Selected
			ON QMS_ResponseQuestion.ResponseID = TEMP_Selected.SelectedID AND TEMP_Selected.UserID = @UserID
		INNER JOIN QMS_Response AS response
			ON response.ResponseID = TEMP_Selected.SelectedID
		WHERE
			response.ParentResponseGUID IS NOT NULL
			AND
			(
				(
					@SupressBlanks = 1
					AND
					(
						QMS_ResponseQuestion.Response_Text IS NOT NULL
						OR LEN(LTRIM(RTRIM(QMS_ResponseQuestion.Response_Text))) > 0
					)
				)
				OR
				(
					@SupressBlanks = 0
				)
			)
		GROUP BY assessmentQuestions.AssessmentQuestionID
	) AS includedAssessmentQuestions
	INNER JOIN QMS_ResponseQuestion AS responseQuestion
		ON responseQuestion.AssessmentQuestionID = includedAssessmentQuestions.AssessmentQuestionID
	INNER JOIN TEMP_Selected
		ON responseQuestion.ResponseID = TEMP_Selected.SelectedID
		AND TEMP_Selected.UserID = @UserID;

	-- Add headers for shown items if suppressing blanks.
	IF (@SupressBlanks = 1)
		INSERT #tmpShownAssessmentQuestions
		(
			ResponseID,
			AssessmentQuestionID
		)
		SELECT DISTINCT
			shown.ResponseID,
			questionChildren.AssessmentQuestionID
		FROM
		(
			SELECT	questions.AssessmentQuestionID,
			(
				SELECT '|' + convert(varchar(10), AssessmentQuestionID
			)
			FROM #tmpAllAssesmentQuestions
			WHERE
				QuestionNumber LIKE questions.QuestionNumber + '.%'
				AND AssessmentID = questions.AssessmentID FOR XML PATH('')) + '|' Children
			FROM #tmpAllAssesmentQuestions questions
		) AS questionChildren
		INNER JOIN #tmpShownAssessmentQuestions AS shown
			ON questionChildren.Children like '%|' + convert(varchar(10), shown.AssessmentQuestionID) + '|%' 
		WHERE
			NOT EXISTS
			(
				SELECT *
				FROM #tmpShownAssessmentQuestions
				WHERE
					ResponseID = shown.ResponseID
					AND AssessmentQuestionID = questionChildren.AssessmentQuestionID
			);

	--get Question data for parent and child checks
	SELECT
		QMS_ResponseQuestion.ResponseID,
		QMS_AssessmentQuestion.AssessmentQuestionID,
		AssessmentQuestion_Sort.QuestionNumber,
		QMS_QuestionPool.Question,
		APP_QuestionLevel.QuestionLevel,
		APP_QuestionLevel.ListIndex AS QuestionLevelSort,
		QMS_ResponseQuestion.Response_Text +
						CASE WHEN ISNULL(QMS_ResponseQuestion.Score, 0) = 0 THEN ''
								ELSE ' (' + CAST(QMS_ResponseQuestion.Score AS varchar(5)) + ')' END AS Response_Text, --include score after response when it is > 0
		QMS_ResponseQuestion.Recommended_QAFlagID,
		QMS_ResponseQuestion.QuestionComments,
		QMS_QuestionPool_Parent.Question AS ParentQuestion,
		APP_QAFlag.QAFlagBackColour,
		APP_QAFlag.QAFlagForeColour,
		QMS_ResponseQuestion.ResponseQuestionID,
		IsSectionHeaderRow = convert(bit, CASE WHEN NULLIF(QMS_AssessmentQuestion.DataTypeID, 0) IS NULL THEN 1 ELSE 0 END),
		TEMP_Selected.SelectedValue, --this indicates if question row is belongs to a parent or child check
		QMS_Response.Actual_Score,
		OverallFlag.QAFlag AS OverallFlag,
		OverallFlag.QAFlagBackColour AS OverallBackColour,
		QMS_Response.RecordStatus,
		--questions are in blocks of 5, the below calculates how many we need to hide
		CASE WHEN
		(
			ROUND(NumberOfChildChecks.NoOfChildChecks / 5, 0) * 5) < NumberOfChildChecks.NoOfChildChecks
			THEN (((ROUND(NumberOfChildChecks.NoOfChildChecks / 5, 0) * 5) + 5) - NumberOfChildChecks.NoOfChildChecks)
			ELSE ((ROUND(NumberOfChildChecks.NoOfChildChecks / 5, 0) * 5) - NumberOfChildChecks.NoOfChildChecks
		) END AS NoOfQuestionsToHide
	FROM	TEMP_Selected
	INNER JOIN QMS_Response
		ON TEMP_Selected.SelectedID = QMS_Response.ResponseID
	INNER JOIN APP_QAFlag AS OverallFlag
		ON QMS_Response.Actual_QAFlagID = OverallFlag.QAFlagID
	INNER JOIN QMS_ResponseQuestion
		ON TEMP_Selected.SelectedID = QMS_ResponseQuestion.ResponseID
	INNER JOIN QMS_AssessmentQuestion
		ON QMS_ResponseQuestion.AssessmentQuestionID = QMS_AssessmentQuestion.AssessmentQuestionID
	INNER JOIN #tmpShownAssessmentQuestions AS visibleQuestions
		ON visibleQuestions.AssessmentQuestionID = QMS_ResponseQuestion.AssessmentQuestionID
	INNER JOIN #tmpAllAssesmentQuestions AS AssessmentQuestion_Sort
		ON visibleQuestions.AssessmentQuestionID = AssessmentQuestion_Sort.AssessmentQuestionID
	INNER JOIN QMS_QuestionPool
		ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID
	LEFT OUTER JOIN APP_QAFlag
		ON QMS_ResponseQuestion.Recommended_QAFlagID = APP_QAFlag.QAFlagID
	LEFT OUTER JOIN QMS_AssessmentQuestion AS QMS_AssessmentQuestion_Parent
		ON QMS_AssessmentQuestion.ParentQuestionID = QMS_AssessmentQuestion_Parent.AssessmentQuestionID
	LEFT OUTER JOIN APP_QuestionLevel
		ON QMS_AssessmentQuestion.QuestionLevelID = APP_QuestionLevel.QuestionLevelID
	LEFT OUTER JOIN QMS_QuestionPool AS QMS_QuestionPool_Parent
		ON QMS_AssessmentQuestion_Parent.QuestionID = QMS_QuestionPool_Parent.QuestionID
	LEFT OUTER JOIN APP_SampleSummary
		ON QMS_AssessmentQuestion.SampleSummaryID = APP_SampleSummary.SampleSummaryID
	LEFT OUTER JOIN
	(
		SELECT
			SelectedValue AS ParentCheckID,
			COUNT(SelectedID) As NoOfChildChecks
		FROM TEMP_Selected
		WHERE UserID = @UserID
			AND SelectedValue IS NOT NULL
		GROUP BY SelectedValue
	) AS NumberOfChildChecks
		ON TEMP_Selected.SelectedValue = NumberOfChildChecks.ParentCheckID
WHERE
	TEMP_Selected.UserID = @UserID
	AND QMS_ResponseQuestion.RecordStatus < 201
	AND QMS_AssessmentQuestion.HideFromReports = 0
	AND	EXISTS
	(
		SELECT ResponseID
		FROM #tmpShownAssessmentQuestions
		WHERE
			ResponseID = QMS_ResponseQuestion.ResponseID
			AND AssessmentQuestionID = QMS_AssessmentQuestion.AssessmentQuestionID
	)
ORDER BY ISNULL(TEMP_Selected.SelectedValue, QMS_ResponseQuestion.ResponseID), QMS_ResponseQuestion.ResponseID, AssessmentQuestion_Sort.SortIndex;

END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_Response_FillSelectedFromPO')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_Response_FillSelectedFromPO] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 14/11/19
-- Description:	Fills TEMP_Selected with ResponseID's for checks to show on QC report grouped by PO
-- Version:		1
-- =============================================
-- JF TFS 139568: Special Fruit - Group QC Check report email alerts by PO Number
-- =============================================
ALTER PROCEDURE [dbo].[RPT_Response_FillSelectedFromPO] 
	@PO nvarchar(100),
	@AssessmentTypeID_LIST nvarchar(100) = NULL,
	@UserID int
AS
BEGIN
	SET NOCOUNT ON

	--Declare @PO nvarchar(100)='P1234567', @AssessmentTypeID_LIST nvarchar(100) = '2', @UserID int = 1

	--Clear temp selected
	DELETE FROM TEMP_Selected
	WHERE     (UserID = @UserID)

	SET NOCOUNT OFF

	INSERT INTO TEMP_Selected (SelectedID, UserID)
	SELECT     
		QMS_Response.ResponseID ,
		@UserID AS UserID
	FROM         
		QMS_ResponseHeader 
		inner join QMS_AssessmentHeader on  QMS_AssessmentHeader.AssessmentHeaderID = QMS_ResponseHeader.AssessmentHeaderID and QMS_AssessmentHeader.DataLookupID =5
		INNER JOIN	QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
		INNER JOIN	(SELECT     CAST(Token AS int) AS AssessmentTypeID
					 FROM          dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',') AS SplitString_AssessmentType
					) AS AssessmentType
					ON QMS_Response.AssessmentTypeID = AssessmentType.AssessmentTypeID
	WHERE     
		QMS_Response.ResponseStatus = 1 AND		
		dbo.FNC_Response_ShouldIncludeInDataWarehouse(QMS_Response.ResponseID) = 1 AND
		QMS_ResponseHeader.RecordStatus <201 AND
		QMS_ResponseHeader.Header_Text = @PO AND
		QMS_Response.AssessmentTypeID = AssessmentType.AssessmentTypeID 
END
GO



PRINT 'Database updated successfully!'
GO