-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_Response')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_Response] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: Markp
-- Create date	: 28/07/2008
-- Description	: Saves assessment response
-- Version		: 11
-- =============================================
-- Updated 23/08/2011 - Added AssessmentTypeID (and calculated default for it)
-- JT TFS 5665 - Include new @AQCResponseGUID parameter as OPTIONAL which populates the GUID column from QMS_SupplierResponse
-- JE TFS 6271 - updated to include optional param for Multi Checks' ParentResponseGUID and made other params optional
-- JE TFS 13-466: added RecordStatus param for AQC Multi Checks
-- JE TFS 13-1616: added missing RecordStatus parameter
-- SF TFS 7843 - updated to allow @ResponseID to be optional, use Scope_Identity() and return new Id in column ResponseID
--				 for Entity Framework in WebChecks
-- PH TFS 13-46981 : v8 - 05/05/2016 - Added @ClientID for WebChecks Web API use (for iOS App).  Reformatted and added semi-colons. Changed method of getting new id to MS recommended method.
-- JF tfs 64804 - make sure the new assessmenttype column HasBeenUsed is updated
-- SS TFS 13-133314 : Add guid as a parameter
-- SS TFS 13-133314 : Added null check on @Guid
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_Response]
	@ResponseID int = NULL,
	@AssessmentID int,
	@StartDate datetime,
	@EndDate datetime,
	@Comments nvarchar(2000) = NULL,
	@Recommended_Score int = NULL,
	@Recommended_QAFlagID int = NULL,
	@Actual_Score int = NULL,
	@Actual_QAFlagID int = NULL,
	@QuantityReceived int = NULL,
	@QuantityChecked int = NULL,
	@QuantityAccepted int = NULL,
	@QuantityRejected int = NULL,
	@QuantityReplaced int = NULL,
	@ResponseStatus int,
	@UserID int,
	@AssessmentTypeID int = NULL,
	@AQCResponseGUID uniqueidentifier = NULL,
	@ParentResponseGUID uniqueidentifier = NULL,
	@RecordStatus int = NULL,
	@ClientID int = NULL, 
	@GUID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON;

	IF NULLIF(@RecordStatus, 0) IS NULL 
		SET @RecordStatus = 2;
	 --only set to 150 for AQC Multi Check when a child check isn't included in Summary

	-- If not specified, use the default AssessmentTypeID from the Assessment table itself.
	IF NULLIF(@AssessmentTypeID, 0) IS NULL 
		BEGIN
			SELECT  @AssessmentTypeID = AssessmentTypeID
			FROM    QMS_Assessment
			WHERE   AssessmentID = @AssessmentID;
		END

	DECLARE @UTCOffset FLOAT
	SET @UTCOffset = DATEDIFF(mi, GETUTCDATE(), GETDATE()) / 60

	DECLARE @newId TABLE
	(
		ResponseID int
	);

	SET @Guid = ISNULL(@Guid, NEWID());

	IF (@GUID = CAST(0x0 as uniqueidentifier))
	BEGIN
		SET @GUID = NEWID()
	END

	IF ISNULL(@ResponseID, 0) = 0 --New record
		BEGIN
			INSERT INTO QMS_Response
			(
				AssessmentID,
				StartDate,
				EndDate,
				Comments,
				Recommended_Score,
				Recommended_QAFlagID,
				Actual_Score,
				Actual_QAFlagID,
				QuantityReceived, 
				QuantityChecked,
				QuantityAccepted,
				QuantityRejected,
				QuantityReplaced,
				ResponseStatus,
				UserID,
				UTCOffset,
				AssessmentTypeID, 
				AQCResponseGUID,
				ParentResponseGUID,
				RecordStatus,
				ClientID,
				GUID
			)
			OUTPUT INSERTED.ResponseID INTO @newId
			VALUES
			(
				@AssessmentID,
				@StartDate,
				@EndDate,
				@Comments,
				@Recommended_Score,
				@Recommended_QAFlagID,
				@Actual_Score,
				@Actual_QAFlagID,
				@QuantityReceived,
				@QuantityChecked,
				@QuantityAccepted,
				@QuantityRejected,
				@QuantityReplaced,
				@ResponseStatus,
				@UserID,
				@UTCOffset,
				@AssessmentTypeID,
				@AQCResponseGUID,
				@ParentResponseGUID,
				@RecordStatus,
				@ClientID,
				@GUID
			);
			--Get new ID
			SELECT  @ResponseID = ResponseID FROM @newId;
		END
	ELSE --Update record
		UPDATE    QMS_Response
		SET
			AssessmentID = @AssessmentID,
			EndDate = @EndDate,
			Comments = @Comments,
			Recommended_Score = @Recommended_Score,
			Recommended_QAFlagID = @Recommended_QAFlagID,
			Actual_Score = @Actual_Score,
			Actual_QAFlagID = @Actual_QAFlagID,
			QuantityReceived = @QuantityReceived,
			QuantityChecked = @QuantityChecked,
			QuantityAccepted = @QuantityAccepted,
			QuantityRejected = @QuantityRejected,
			QuantityReplaced = @QuantityReplaced,
			ResponseStatus = @ResponseStatus,
			UserID = @UserID,
			MachineName = HOST_NAME(),
			Updated = GETUTCDATE(),
			UTCOffset = @UTCOffset,
			AssessmentTypeID = @AssessmentTypeID,
			AQCResponseGUID = ISNULL(@AQCResponseGUID, AQCResponseGUID),
			ParentResponseGUID = ISNULL(@ParentResponseGUID, ParentResponseGUID),
			RecordStatus = ISNULL(@RecordStatus, RecordStatus),
			ClientID = @ClientID
		WHERE
			ResponseID = @ResponseID;

	UPDATE APP_AssessmentType set HasBeenUsed = 1 WHERE AssessmentTypeID =  @AssessmentTypeID and ISNULL(HasBeenUsed,0) <> 1
	
	SET NOCOUNT OFF;


	SELECT  @ResponseID AS ResponseID,
			GUID --return GUID to be used as ParentResponseGUID for Multi Checks
	FROM    QMS_Response
	WHERE	ResponseID = @ResponseID;
END
GO





PRINT 'Database updated successfully!'
GO

