-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_User_AdminList')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_User_AdminList] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 27/06/2008
-- Description:	Gets list of users for admin
-- Version:		9
-- =============================================
-- JE TFS 2677 added new UserLevel logic
-- MP 18/09/12 change to selection of avalable user level as not sure why QMS_User was included here
-- JT TFS 6623 added IsUserLockedOut column (based on logic in clsUserAdmin.IsUserLockedOut, and added SearchUserID
-- JT TFS 7115 Added begin/end and NOCOUNT options to see if they fixed slowdown.
-- JT TFS 8022 - Return GUID so that it can be passed to LogiXML
-- JT TFS 13-11810 - Include CustomerID in output.
-- AC TFS 1200 - Include Lookup_LocaleID in output
-- MP TFS 18442 - Return Inserted so it can be used by Intercom
-- DPC TFS 129303 - Use effective user level (group/user) when determining the level order
-- =============================================
ALTER PROCEDURE [dbo].[QRY_User_AdminList] 
	@UserID int,
	@Company nvarchar(255) = NULL,
	@SearchUserID int = NULL
AS
BEGIN

	SET NOCOUNT ON 
	-- temp table to hold user levels
	DECLARE @AvailableUserLevels TABLE
	(
		UserLevelID int,
		UserLevel nvarchar(50),
		LevelOrder int
	)
	-- Get Effective user level order of selected User (group user level overrides user level)
	DECLARE @LevelOrder int
	SELECT @LevelOrder = LevelOrder FROM APP_UserLevel WHERE UserLevelID = dbo.FNC_GetUserLevel(@UserID)

	IF @LevelOrder = 1
		-- insert available (i.e. lower) user levels into temp table then join on this in main query
		INSERT INTO @AvailableUserLevels (UserLevelID, UserLevel, LevelOrder)
		SELECT     UserLevelID, UserLevel, LevelOrder
		FROM         APP_UserLevel
		WHERE     (Hide = 0) AND (LevelOrder >= @LevelOrder)
	ELSE
		-- insert available (i.e. lower) user levels into temp table then join on this in main query
		INSERT INTO @AvailableUserLevels (UserLevelID, UserLevel, LevelOrder)
		SELECT     UserLevelID, UserLevel, LevelOrder
		FROM         APP_UserLevel
		WHERE     (Hide = 0) AND (LevelOrder > @LevelOrder)

	SET NOCOUNT OFF

	SELECT DISTINCT
		QMS_User.UserID, 
		QMS_User.FullName, 
		QMS_User.UserName, 
		QMS_User.Password, 
		QMS_User.Position, 
		QMS_User.Company, 
		QMS_User.EMail, 
		QMS_User.Mobile, 
		QMS_User.PIN, 
		QMS_User.LeftCompany, 
		QMS_User.UserLevel, 
		AvailableUserLevels.UserLevel AS Lookup_UserLevel, 
		QMS_User.LocaleID, 
		APP_CountryLocales.[Description] AS Lookup_LocaleID, 
		QMS_User.IsUserGroup, 
		QMS_User.ParentUserID, 
		Lookup_UserGroup.FullName AS Lookup_ParentUserID, 
		CAST(CASE	WHEN ISNULL(SupplierPermissions.NumPermissions, 0) > 1 THEN 0 
					WHEN ISNULL(SupplierPermissions.NumPermissions, 0) = 1 THEN SupplierID 
					ELSE NULL END AS int) AS SupplierID, 
		CAST(CASE	WHEN ISNULL(SupplierPermissions.NumPermissions, 0) > 1 THEN N'(Multiple)' 
					WHEN ISNULL(SupplierPermissions.NumPermissions, 0) = 1 THEN	ISNULL((	SELECT     SupplierName
																					FROM          PM_VW_Supplier
																					WHERE      (SupplierID = SupplierPermissions.SupplierID)), '(deleted supplier)')
					ELSE NULL END AS nvarchar) AS Lookup_SupplierID, 

		CAST(CASE	WHEN ISNULL(CustomerPermissions.NumPermissions, 0) > 1 THEN 0 
					WHEN ISNULL(CustomerPermissions.NumPermissions, 0) = 1 THEN CustomerID 
					ELSE NULL END AS int) AS CustomerID, 
		CAST(CASE	WHEN ISNULL(CustomerPermissions.NumPermissions, 0) > 1 THEN N'(Multiple)' 
					WHEN ISNULL(CustomerPermissions.NumPermissions, 0) = 1 THEN	ISNULL((	SELECT     CustomerName
																					FROM          PM_VW_Customer_Admin
																					WHERE      (CustomerID = CustomerPermissions.CustomerID)), '(deleted customer)') 
					ELSE NULL END AS nvarchar) AS Lookup_CustomerID, 
		CAST(OfficePermissions.NumPermissions AS nvarchar(100)) AS OfficeAccess, 
		CAST(MobilePermissions.NumPermissions AS nvarchar(100)) AS MobileAccess, 
		CAST(WebPermissions.NumPermissions AS nvarchar(100)) AS WebAccess, 
		CAST(SupplierPermissions.NumPermissions AS nvarchar(100)) AS SupplierAccess, 
		CAST(CustomerPermissions.NumPermissions AS nvarchar(100)) AS CustomerAccess, 
		CAST(LocationPermissions.NumPermissions AS nvarchar(100)) AS LocationAccess, 
		CAST(StockCodePermissions.NumPermissions AS nvarchar(100)) AS StockCodeAccess,
		CAST(CASE WHEN QMS_User.[Password] IS NULL THEN 1 ELSE 0 END as bit) Lookup_IsUserLockedOut,
		QMS_User.[GUID] AS Lookup_GUID,
		QMS_User.Inserted
	FROM         QMS_User INNER JOIN
						   @AvailableUserLevels AS AvailableUserLevels ON QMS_User.UserLevel = AvailableUserLevels.UserLevelID LEFT OUTER JOIN
							  (SELECT     UserID, FullName
								FROM          QMS_User AS User_Group
								WHERE      (RecordStatus < 201) AND (IsUserGroup = 1)) AS Lookup_UserGroup ON QMS_User.ParentUserID = Lookup_UserGroup.UserID LEFT OUTER JOIN
							  (SELECT     UserID, COUNT(UserPermissionID) AS NumPermissions
								FROM          QMS_UserPermissions AS StockCode_Permissions
								WHERE      (PermissionAllow = 1) AND (PermissionType = 104)
								GROUP BY UserID) AS StockCodePermissions ON QMS_User.UserID = StockCodePermissions.UserID LEFT OUTER JOIN
							  (SELECT     UserID, COUNT(UserPermissionID) AS NumPermissions
								FROM          QMS_UserPermissions AS Location_Permissions
								WHERE      (PermissionAllow = 1) AND (PermissionType = 103)
								GROUP BY UserID) AS LocationPermissions ON QMS_User.UserID = LocationPermissions.UserID LEFT OUTER JOIN
							  (SELECT     UserID, COUNT(UserPermissionID) AS NumPermissions, MIN(CAST(PermissionTitle AS int)) AS SupplierID
								FROM          QMS_UserPermissions AS Supplier_Permissions
								WHERE      (PermissionAllow = 1) AND (PermissionType = 101)
								GROUP BY UserID) AS SupplierPermissions ON QMS_User.UserID = SupplierPermissions.UserID LEFT OUTER JOIN
							  (SELECT     UserID, COUNT(UserPermissionID) AS NumPermissions, MIN(CAST(PermissionTitle AS int)) AS CustomerID
								FROM          QMS_UserPermissions AS Customer_Permissions
								WHERE      (PermissionAllow = 1) AND (PermissionType = 102)
								GROUP BY UserID) AS CustomerPermissions ON QMS_User.UserID = CustomerPermissions.UserID LEFT OUTER JOIN
							  (SELECT     Web_Permissions.UserID, COUNT(Web_Permissions.UserPermissionID) AS NumPermissions
								FROM          QMS_UserPermissions AS Web_Permissions INNER JOIN
													   APP_Menu AS Web_Menu ON CAST(Web_Permissions.PermissionTitle AS int) = Web_Menu.MenuID
								WHERE      (Web_Permissions.PermissionAllow = 1) AND (Web_Permissions.PermissionType = 0) AND (Web_Menu.AppID = 3)
								GROUP BY Web_Permissions.UserID) AS WebPermissions ON QMS_User.UserID = WebPermissions.UserID LEFT OUTER JOIN
							  (SELECT     Mobile_Permissions.UserID, COUNT(Mobile_Permissions.UserPermissionID) AS NumPermissions
								FROM          QMS_UserPermissions AS Mobile_Permissions INNER JOIN
													   APP_Menu AS Mobile_Menu ON CAST(Mobile_Permissions.PermissionTitle AS int) = Mobile_Menu.MenuID
								WHERE      (Mobile_Permissions.PermissionAllow = 1) AND (Mobile_Permissions.PermissionType = 0) AND (Mobile_Menu.AppID = 2)
								GROUP BY Mobile_Permissions.UserID) AS MobilePermissions ON QMS_User.UserID = MobilePermissions.UserID LEFT OUTER JOIN
							  (SELECT     Office_Permissions.UserID, COUNT(Office_Permissions.UserPermissionID) AS NumPermissions
								FROM          QMS_UserPermissions AS Office_Permissions INNER JOIN
													   APP_Menu AS Office_Menu ON CAST(Office_Permissions.PermissionTitle AS int) = Office_Menu.MenuID
								WHERE      (Office_Permissions.PermissionAllow = 1) AND (Office_Permissions.PermissionType = 0) AND (Office_Menu.AppID = 1)
								GROUP BY Office_Permissions.UserID) AS OfficePermissions ON QMS_User.UserID = OfficePermissions.UserID LEFT JOIN APP_CountryLocales ON
								QMS_User.LocaleID = APP_CountryLocales.CountryLocaleID
	WHERE     (QMS_User.RecordStatus < 201) 
	AND (QMS_User.Company = @Company OR @Company IS NULL)
	AND (QMS_User.UserID = @SearchUserID OR @SearchUserID IS NULL)
	ORDER BY QMS_User.IsUserGroup, QMS_User.FullName
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SP_RemoveOldMobileData')
	EXEC ('CREATE PROCEDURE [dbo].[SP_RemoveOldMobileData] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		jeremyf
-- Create date: 24/06/2019
-- Description:	Clear old data from mobile database
-- Version:		1
-- =============================================
-- JT TFS 121592: 
-- =============================================
ALTER PROCEDURE [dbo].[SP_RemoveOldMobileData] 
	@Password nvarchar(50)
AS

--***WARNING*** This procedure will clear data

IF NOT @Password = N'muddy'
	RETURN 0


	-- todo remove QMS_Responses and associated data? perhaps remove if older than a month or 2?
	-- delete orphaned guidance/attachments?

	/*
	QMS_Assessment --11
		QMS_AssessmentQuestion --10
			QMS_Guidance
				QMS_Attachment
			QMS_AssessmentSampleConstraint --2
			QMS_AssessmentQuestionConstraint --3
				QMS_Guidance
					QMS_Attachment
		QMS_AssessmentConstraint --6
			QMS_Guidance
				QMS_Attachment
		QMS_AssessmentTarget --7
		QMS_AssessmentFooter --8
		QMS_AssessmentTypeMulti --9
		QMS_AssessmentSpecHeader --5
			QMS_Attachment --12
			QMS_AssessmentSpecHeaderMulti --4
		QAS_Specification --1
		QMS_Guidance - not exclusive
			QMS_Attachment

	*/

	EXEC SYNC_Log_Save 'I', 'Preparing old data to be removed'

	DECLARE @DeleteAssessments Table ( AssessmentID INT );
	INSERT INTO @DeleteAssessments ( AssessmentID ) 
	select AssessmentID from qms_assessment where AssessmentStatusID not in (1,2,3) and Updated < DATEADD(dd,-14,GETDATE()) and AssessmentID not in (Select AssessmentID from QMS_Response GROUP BY AssessmentID)

	DECLARE @RemovedAssessmentQuestion TABLE (AssessmentQuestionID int);
	INSERT INTO @RemovedAssessmentQuestion ( AssessmentQuestionID ) 
	select AssessmentQuestionID from qms_assessmentquestion where AssessmentID in (select AssessmentID from @DeleteAssessments)

	DECLARE @RemovedSpecificationHeaders TABLE (AssessmentSpecHeaderID int);
	insert into @RemovedSpecificationHeaders (AssessmentSpecHeaderID)
	select AssessmentSpecHeaderID from QMS_AssessmentSpecHeader
	WHERE   (AssessmentID in  (select AssessmentID from @DeleteAssessments))

	--select COUNT(*) from @DeleteAssessments
	--select COUNT(*) from @RemovedAssessmentQuestion
	--select COUNT(*) from @RemovedSpecificationHeaders

	IF NULLIF(object_id('tempdb..#tmpGuidanceLink'), 0) IS NOT NULL DROP TABLE #tmpGuidanceLink;
	SELECT link_guidance.GuidanceID, link_guidance.AssessmentID, CASE WHEN a.AssessmentStatusID = 4 THEN 0 ELSE 1 END AS Available
	INTO #tmpGuidanceLink
	FROM QMS_Assessment a
	INNER JOIN (
	SELECT GuidanceID, AssessmentID FROM QMS_Assessment WHERE AssessmentID in (select AssessmentID from @DeleteAssessments)
	UNION	SELECT GuidanceID, AssessmentID FROM QMS_AssessmentQuestion WHERE AssessmentID in (select AssessmentID from @DeleteAssessments)
	UNION	SELECT GuidanceID, AssessmentID FROM QMS_AssessmentConstraint WHERE AssessmentID in (select AssessmentID from @DeleteAssessments)
	UNION	SELECT aqc.GuidanceID, AssessmentID FROM QMS_AssessmentQuestionConstraint aqc 
	INNER JOIN QMS_AssessmentQuestion aq ON aqc.AssessmentQuestionID = aq.AssessmentQuestionID
	WHERE AssessmentID in (select AssessmentID from @DeleteAssessments) --= @AssessmentID
	) AS link_guidance ON link_guidance.AssessmentID = a.AssessmentID;

	-- Remove Guidances which are already linked to another assessment from our candidate list. Those stay.
	DELETE #tmpGuidanceLink
	WHERE GuidanceID IN (
	SELECT GuidanceID FROM (
	SELECT GuidanceID, AssessmentID FROM QMS_Assessment WHERE (RecordStatus < 201 OR RecordStatus = 230) AND GuidanceID IN (SELECT GuidanceID FROM #tmpGuidanceLink WHERE GuidanceID IS NOT NULL)
	UNION	SELECT GuidanceID, AssessmentID FROM QMS_AssessmentQuestion WHERE (RecordStatus < 201 OR RecordStatus = 230) AND GuidanceID IN (SELECT GuidanceID FROM #tmpGuidanceLink WHERE GuidanceID IS NOT NULL)
	UNION	SELECT GuidanceID, AssessmentID FROM QMS_AssessmentConstraint WHERE (RecordStatus < 201 OR RecordStatus = 230) AND GuidanceID IN (SELECT GuidanceID FROM #tmpGuidanceLink WHERE GuidanceID IS NOT NULL)
	UNION	SELECT aqc.GuidanceID, AssessmentID FROM QMS_AssessmentQuestionConstraint aqc 
	INNER JOIN QMS_AssessmentQuestion aq ON aqc.AssessmentQuestionID = aq.AssessmentQuestionID 
	WHERE (aqc.RecordStatus < 201 OR aqc.RecordStatus = 230) AND aqc.GuidanceID IN (SELECT GuidanceID FROM #tmpGuidanceLink WHERE GuidanceID IS NOT NULL)
	) AS link_guidance
	WHERE link_guidance.AssessmentID not in (select AssessmentID from @DeleteAssessments)--<> @AssessmentID
	)

	-- Do we delete global Guidance? (have to ask Mark)
	-- If not, we remove those candidates.
	DELETE #tmpGuidanceLink
	WHERE GuidanceID IN (
	SELECT link.GuidanceID FROM #tmpGuidanceLink link
	INNER JOIN QMS_Guidance guidance ON guidance.GuidanceID = link.GuidanceID
	WHERE guidance.Global = 1
	);
	
	-- Actually remove the guidance.
	DECLARE @RemovedGuidance TABLE (GuidanceID int)
	insert into @RemovedGuidance (GuidanceID)
	select guidance.GuidanceID FROM QMS_Guidance guidance
	INNER JOIN #tmpGuidanceLink link ON guidance.GuidanceID = link.GuidanceID
	WHERE guidance.RecordStatus <> 201

	--select COUNT(*) from @RemovedGuidance
	--select count(*) from QMS_Guidance where GuidanceID in (select GuidanceID from @RemovedGuidance)
	--WHERE   AttachmentSourceID = 3 
	--AND		SourceObjectID IN (SELECT GuidanceID FROM @RemovedGuidance WHERE GuidanceID IS NOT NULL)

	EXEC SYNC_Log_Save 'I', 'Starting to remove old data'

	print 'deleting from guidance QMS_Attachment'

	-- NOTE: Do not null out the attachments or the storageGUIDs. They may be reinstated by another assessment being unarchived.
	delete from QMS_Attachment
	WHERE   AttachmentSourceID = 3 
	AND		SourceObjectID IN (SELECT GuidanceID FROM @RemovedGuidance WHERE GuidanceID IS NOT NULL)

	print 'deleting from QMS_Guidance'
	DELETE from QMS_Guidance where GuidanceID in (select GuidanceID from @RemovedGuidance)

	IF NULLIF(object_id('tempdb..#tmpGuidanceLink'), 0) IS NOT NULL DROP TABLE #tmpGuidanceLink;

	--1
	--DELETE QAS_Specification
	--WHERE AssessmentGUID = (SELECT GUID FROM QMS_Assessment WHERE AssessmentID in (select AssessmentID from @DeleteAssessments))--= @AssessmentID)

	--2
	print 'deleting from QMS_AssessmentSampleConstraint'
	delete
	FROM QMS_AssessmentSampleConstraint 
	WHERE AssessmentQuestionID IN (SELECT AssessmentQuestionID FROM @RemovedAssessmentQuestion WHERE AssessmentQuestionID IS NOT NULL)

	--3
	print 'deleting from QMS_AssessmentQuestionConstraint'
	delete from QMS_AssessmentQuestionConstraint
	WHERE AssessmentQuestionID IN (SELECT AssessmentQuestionID FROM @RemovedAssessmentQuestion)

	--4
	print 'deleting from QMS_AssessmentSpecHeaderMulti'
	delete from QMS_AssessmentSpecHeaderMulti
	where AssessmentSpecHeaderID in (select AssessmentSpecHeaderID from @RemovedSpecificationHeaders)

	--5
	print 'deleting from QMS_AssessmentSpecHeader'
	delete from QMS_AssessmentSpecHeader 
	where AssessmentSpecHeaderID in (select AssessmentSpecHeaderID from @RemovedSpecificationHeaders)

	--6
	print 'deleting from QMS_AssessmentConstraint'
	delete from QMS_AssessmentConstraint
	WHERE   (AssessmentID in  (select AssessmentID from @DeleteAssessments))

	--7
	print 'deleting from QMS_AssessmentTarget'
	delete from QMS_AssessmentTarget
	WHERE   (AssessmentID in  (select AssessmentID from @DeleteAssessments))

	--8
	print 'deleting from QMS_AssessmentFooter'
	delete from QMS_AssessmentFooter
	WHERE   (AssessmentID in  (select AssessmentID from @DeleteAssessments))

	--9
	print 'deleting from QMS_AssessmentTypeMulti'
	delete from QMS_AssessmentTypeMulti
	WHERE   (AssessmentID in  (select AssessmentID from @DeleteAssessments))

	--10
	print 'deleting from QMS_AssessmentQuestion'
	delete from QMS_AssessmentQuestion
	WHERE   (AssessmentID in  (select AssessmentID from @DeleteAssessments))

	--11
	print 'deleting from QMS_Assessment'
	delete from  QMS_Assessment
	WHERE   (AssessmentID in  (select AssessmentID from @DeleteAssessments))


	--12
	print 'deleting from spec QMS_Attachment'
	delete from QMS_Attachment
	WHERE   AttachmentSourceID = 4
	AND		SourceObjectID IN (SELECT AssessmentSpecHeaderID FROM @RemovedSpecificationHeaders WHERE AssessmentSpecHeaderID IS NOT NULL)

	print 'deleting from QMS_SupplierResponse'
	delete from QMS_SupplierResponse where enddate < DATEADD(month,-3,getdate())

	EXEC SYNC_Log_Save 'I', 'Finished removing old data'

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_ReportFilter_Response')
	EXEC('CREATE FUNCTION [dbo].[FNC_ReportFilter_Response]() RETURNS @x TABLE (y bit) AS BEGIN RETURN END')
GO
-- =============================================
-- Author:		Markp
-- Create date: 06/07/2010
-- Description:	Gets filtered responses
-- Version:		19
-- =============================================
-- JE TFS 3208 - added PT filter
-- JE TFS 4006 - added Supplier Site filter
-- JE TFS 4301 - added PO filter
-- JE TFS 4302 - added Lot Number filter
-- JE TFS 4303 - added Pallet Number filter
-- JE TFS 4304 - added Depot Date filter
-- JE TFS 5113 - added Primary Supplier filter
-- JT TFS 5138 - added Store
-- JT TFS 5394 - added Variety
-- JE TFS 5905 - updated to make use of Reporting Warehouse table
-- JT TFS 6743: Only use warehouse if RPT_Warehouse_Response contains rows.
-- JT TFS 6689: FNC_CanUserDataWareHouse takes UserID parameter.
-- JT TFS 6689: FNC_ReportFilter_Response takes UserID parameter.
-- JT TFS 7707: Added generic datalookup. Set APP_ReportFilter.DataLookupID to search response headers for this DatalookupID
-- JE TFS 8459: added dedicated AQC check filters
-- JE TFS 8469: added Check ID filter
-- JE TFS 8315: added provision for multi select items in header (e.g. Country of Origin)
-- JMF TFS6552 - can now match where the datalookup is just a text lookup (ie no sourceID)
-- JE TFS 13-11253: updated filtering by PO to pick up DataLookupID = 5 OR 47 as both are used for PO
-- JF TFS 129516 update stockcode segment region to use warehouse data if enabled
-- =============================================
ALTER FUNCTION [dbo].[FNC_ReportFilter_Response] 
(
	@ReportFilterID int,
	@FilterID int,
	@FilterText nvarchar(255),
	@DateFrom datetime,
	@DateTo datetime,
	@UserID int
)
RETURNS
@Response TABLE
(
	ResponseID int
)
AS

BEGIN

--get date reporting warehouse table last built
DECLARE @WarehouseBuildDate DATETIME
SET @WarehouseBuildDate = ( SELECT  Updated
                            FROM    APP_Config
                            WHERE   OptionID = 78
                          )

DECLARE @Filter_DataLookupID INT
SELECT  @Filter_DataLookupID = DataLookupID
FROM    APP_ReportFilter
WHERE   ReportFilterID = @ReportFilterID

IF @ReportFilterID = 1 --Supplier
    BEGIN
        IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
            AND @DateTo <= @WarehouseBuildDate --use warehouse table if built within specified date range
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  ResponseID
                    FROM    RPT_Warehouse_Response
                    WHERE   ( SupplierID = @FilterID )
                            AND ( EndDate BETWEEN @DateFrom AND @DateTo )
                            AND ( RecordStatus < 201 )
        ELSE
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  QMS_ResponseHeader.ResponseID
                    FROM    QMS_ResponseHeader
                            INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                            INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
                    WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                            AND ( QMS_AssessmentHeader.DataLookupID = 1 )
                            AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )
                            AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                                       AND    @DateTo )
                            AND ( QMS_Response.ResponseStatus = 1 )
                            AND ( QMS_Response.RecordStatus < 201 )
    END

IF @ReportFilterID = 2 --Stock code
    BEGIN
        IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
            AND @DateTo <= @WarehouseBuildDate --use warehouse table if built within specified date range
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  ResponseID
                    FROM    RPT_Warehouse_Response
                    WHERE   ( StockCodeID = @FilterID )
                            AND ( EndDate BETWEEN @DateFrom AND @DateTo )
                            AND ( RecordStatus < 201 )
        ELSE
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  FNC_ResponseHeader_StockCode.ResponseID
                    FROM    dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCode
                            INNER JOIN QMS_Response ON FNC_ResponseHeader_StockCode.ResponseID = QMS_Response.ResponseID
                    WHERE   ( FNC_ResponseHeader_StockCode.StockCodeID = @FilterID )
                            AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                                       AND    @DateTo )
                            AND ( QMS_Response.ResponseStatus = 1 )
                            AND ( QMS_Response.RecordStatus < 201 )
    END

IF @ReportFilterID = 3 --Stock area
    BEGIN
        IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
            AND @DateTo <= @WarehouseBuildDate --use warehouse table if built within specified date range
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  ResponseID
                    FROM    RPT_Warehouse_Response
                            INNER JOIN PM_VW_StockCode ON RPT_Warehouse_Response.StockCodeID = PM_VW_StockCode.StockCodeID
                    WHERE   ( PM_VW_StockCode.StockCodeArea = @FilterText )
                            AND ( EndDate BETWEEN @DateFrom AND @DateTo )
                            AND ( RPT_Warehouse_Response.RecordStatus < 201 )
        ELSE
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  FNC_ResponseHeader_StockCode.ResponseID
                    FROM    dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCode
                            INNER JOIN QMS_Response ON FNC_ResponseHeader_StockCode.ResponseID = QMS_Response.ResponseID
                            INNER JOIN PM_VW_StockCode ON FNC_ResponseHeader_StockCode.StockCodeID = PM_VW_StockCode.StockCodeID
                    WHERE   ( QMS_Response.EndDate BETWEEN @DateFrom
                                                   AND     @DateTo )
                            AND ( QMS_Response.ResponseStatus = 1 )
                            AND ( QMS_Response.RecordStatus < 201 )
                            AND ( PM_VW_StockCode.StockCodeArea = @FilterText )
    END

IF @ReportFilterID = 4 --Stock group
    BEGIN
        IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
            AND @DateTo <= @WarehouseBuildDate --use warehouse table if built within specified date range
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  ResponseID
                    FROM    RPT_Warehouse_Response
                            INNER JOIN PM_VW_StockCode ON RPT_Warehouse_Response.StockCodeID = PM_VW_StockCode.StockCodeID
                    WHERE   ( PM_VW_StockCode.StockCodeGroup = @FilterText )
                            AND ( EndDate BETWEEN @DateFrom AND @DateTo )
                            AND ( RPT_Warehouse_Response.RecordStatus < 201 )
        ELSE
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  FNC_ResponseHeader_StockCode.ResponseID
                    FROM    dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCode
                            INNER JOIN QMS_Response ON FNC_ResponseHeader_StockCode.ResponseID = QMS_Response.ResponseID
                            INNER JOIN PM_VW_StockCode ON FNC_ResponseHeader_StockCode.StockCodeID = PM_VW_StockCode.StockCodeID
                    WHERE   ( QMS_Response.EndDate BETWEEN @DateFrom
                                                   AND     @DateTo )
                            AND ( QMS_Response.ResponseStatus = 1 )
                            AND ( QMS_Response.RecordStatus < 201 )
                            AND ( PM_VW_StockCode.StockCodeGroup = @FilterText )
    END

IF @ReportFilterID = 5 --Stock sub-group
    BEGIN
        IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
            AND @DateTo <= @WarehouseBuildDate --use warehouse table if built within specified date range
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  ResponseID
                    FROM    RPT_Warehouse_Response
                            INNER JOIN PM_VW_StockCode ON RPT_Warehouse_Response.StockCodeID = PM_VW_StockCode.StockCodeID
                    WHERE   ( PM_VW_StockCode.StockCodeSubGroup = @FilterText )
                            AND ( EndDate BETWEEN @DateFrom AND @DateTo )
                            AND ( RPT_Warehouse_Response.RecordStatus < 201 )
        ELSE
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  FNC_ResponseHeader_StockCode.ResponseID
                    FROM    dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCode
                            INNER JOIN QMS_Response ON FNC_ResponseHeader_StockCode.ResponseID = QMS_Response.ResponseID
                            INNER JOIN PM_VW_StockCode ON FNC_ResponseHeader_StockCode.StockCodeID = PM_VW_StockCode.StockCodeID
                    WHERE   ( QMS_Response.EndDate BETWEEN @DateFrom
                                                   AND     @DateTo )
                            AND ( QMS_Response.ResponseStatus = 1 )
                            AND ( QMS_Response.RecordStatus < 201 )
                            AND ( PM_VW_StockCode.StockCodeSubGroup = @FilterText )
    END

IF @ReportFilterID = 6 --Location
    BEGIN
        IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
            AND @DateTo <= @WarehouseBuildDate --use warehouse table if built within specified date range
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  ResponseID
                    FROM    RPT_Warehouse_Response
                    WHERE   ( LocationID = @FilterID )
                            AND ( EndDate BETWEEN @DateFrom AND @DateTo )
                            AND ( RecordStatus < 201 )
        ELSE
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  QMS_ResponseHeader.ResponseID
                    FROM    QMS_ResponseHeader
                            INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                            INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
                    WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                            AND ( QMS_AssessmentHeader.DataLookupID = 4 )
                            AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )
                            AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                                       AND    @DateTo )
                            AND ( QMS_Response.ResponseStatus = 1 )
                            AND ( QMS_Response.RecordStatus < 201 )
    END

IF @ReportFilterID = 7 --National Buyer
    BEGIN
        IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
            AND @DateTo <= @WarehouseBuildDate --use warehouse table if built within specified date range
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  ResponseID
                    FROM    RPT_Warehouse_Response
                            INNER JOIN ( SELECT UserID ,
                                                CAST(PermissionTitle AS INT) AS StockCodeID
                                         FROM   QMS_UserPermissions AS UserPermissions
                                         WHERE  ( PermissionType = 104 )
                                                AND ( PermissionAllow = 1 )
                                       ) AS User_StockCode ON RPT_Warehouse_Response.StockCodeID = User_StockCode.StockCodeID
                    WHERE   ( User_StockCode.UserID = @FilterID )
                            AND ( EndDate BETWEEN @DateFrom AND @DateTo )
                            AND ( RecordStatus < 201 )
        ELSE
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  FNC_ResponseHeader_StockCode.ResponseID
                    FROM    dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCode
                            INNER JOIN QMS_Response ON FNC_ResponseHeader_StockCode.ResponseID = QMS_Response.ResponseID
                            INNER JOIN ( SELECT UserID ,
                                                CAST(PermissionTitle AS INT) AS StockCodeID
                                         FROM   QMS_UserPermissions AS UserPermissions
                                         WHERE  ( PermissionType = 104 )
                                                AND ( PermissionAllow = 1 )
                                       ) AS User_StockCode ON FNC_ResponseHeader_StockCode.StockCodeID = User_StockCode.StockCodeID
                    WHERE   ( QMS_Response.EndDate BETWEEN @DateFrom
                                                   AND     @DateTo )
                            AND ( QMS_Response.ResponseStatus = 1 )
                            AND ( QMS_Response.RecordStatus < 201 )
                            AND ( User_StockCode.UserID = @FilterID )
    END

IF @ReportFilterID = 8 --State Buyer
    BEGIN
        IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
            AND @DateTo <= @WarehouseBuildDate --use warehouse table if built within specified date range
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  RPT_Warehouse_Response.ResponseID
                    FROM    RPT_Warehouse_Response
                            INNER JOIN ( SELECT UserID ,
                                                CAST(PermissionTitle AS INT) AS StockCodeID
                                         FROM   QMS_UserPermissions AS UserPermissions
                                         WHERE  ( PermissionType = 104 )
                                                AND ( PermissionAllow = 1 )
                                       ) AS User_StockCode ON RPT_Warehouse_Response.StockCodeID = User_StockCode.StockCodeID
                            INNER JOIN ( SELECT QMS_ResponseHeader.ResponseID ,
                                                QMS_ResponseHeader.Header_SourceID AS LocationID
                                         FROM   QMS_ResponseHeader
                                                INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                                                INNER JOIN QMS_Response AS QMS_Response_1 ON QMS_ResponseHeader.ResponseID = QMS_Response_1.ResponseID
                                         WHERE  ( QMS_AssessmentHeader.DataTypeID = 9 )
                                                AND ( QMS_AssessmentHeader.DataLookupID = 4 )
                                                AND ( QMS_Response_1.EndDate BETWEEN @DateFrom
                                                              AND
                                                              @DateTo )
                                       ) AS Response_Location ON RPT_Warehouse_Response.ResponseID = Response_Location.ResponseID
                            INNER JOIN ( SELECT UserID ,
                                                CAST(PermissionTitle AS INT) AS LocationID
                                         FROM   QMS_UserPermissions
                                         WHERE  ( PermissionAllow = 1 )
                                                AND ( PermissionType = 103 )
                                       ) AS User_Location ON Response_Location.LocationID = User_Location.LocationID
                    WHERE   ( User_StockCode.UserID = @FilterID )
                            AND ( User_Location.UserID = @FilterID )
                            AND ( EndDate BETWEEN @DateFrom AND @DateTo )
                            AND ( RecordStatus < 201 )
        ELSE
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  QMS_Response.ResponseID
                    FROM    dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCode
                            INNER JOIN QMS_Response ON FNC_ResponseHeader_StockCode.ResponseID = QMS_Response.ResponseID
                            INNER JOIN ( SELECT UserID ,
                                                CAST(PermissionTitle AS INT) AS StockCodeID
                                         FROM   QMS_UserPermissions AS UserPermissions
                                         WHERE  ( PermissionType = 104 )
                                                AND ( PermissionAllow = 1 )
                                       ) AS User_StockCode ON FNC_ResponseHeader_StockCode.StockCodeID = User_StockCode.StockCodeID
                            INNER JOIN ( SELECT QMS_ResponseHeader.ResponseID ,
                                                QMS_ResponseHeader.Header_SourceID AS LocationID
                                         FROM   QMS_ResponseHeader
                                                INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                                                INNER JOIN QMS_Response AS QMS_Response_1 ON QMS_ResponseHeader.ResponseID = QMS_Response_1.ResponseID
                                         WHERE  ( QMS_AssessmentHeader.DataTypeID = 9 )
                                                AND ( QMS_AssessmentHeader.DataLookupID = 4 )
                                                AND ( QMS_Response_1.EndDate BETWEEN @DateFrom
                                                              AND
                                                              @DateTo )
                                       ) AS Response_Location ON QMS_Response.ResponseID = Response_Location.ResponseID
                            INNER JOIN ( SELECT UserID ,
                                                CAST(PermissionTitle AS INT) AS LocationID
                                         FROM   QMS_UserPermissions
                                         WHERE  ( PermissionAllow = 1 )
                                                AND ( PermissionType = 103 )
                                       ) AS User_Location ON Response_Location.LocationID = User_Location.LocationID
                    WHERE   ( QMS_Response.EndDate BETWEEN @DateFrom
                                                   AND     @DateTo )
                            AND ( QMS_Response.ResponseStatus = 1 )
                            AND ( QMS_Response.RecordStatus < 201 )
                            AND ( User_StockCode.UserID = @FilterID )
                            AND ( User_Location.UserID = @FilterID )
    END

IF @ReportFilterID = 9 --Harvest crew
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
            WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 29 )
                    AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

IF @ReportFilterID = 10 --Region
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT     DISTINCT
                    QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
                    LEFT OUTER JOIN PM_VW_Location ON QMS_ResponseHeader.Header_SourceID = PM_VW_Location.LocationID
            WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 4 )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )
                    AND ( PM_VW_Location.RegionID = @FilterID )
                    OR ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 34 )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )
                    AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )

IF @ReportFilterID = 11 --User
    BEGIN
        IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
            AND @DateTo <= @WarehouseBuildDate --use warehouse table if built within specified date range
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  ResponseID
                    FROM    RPT_Warehouse_Response
                    WHERE   ( UserID = @FilterID )
                            AND ( EndDate BETWEEN @DateFrom AND @DateTo )
                            AND ( RecordStatus < 201 )
        ELSE
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  ResponseID
                    FROM    QMS_Response
                    WHERE   ( EndDate BETWEEN @DateFrom AND @DateTo )
                            AND ( ResponseStatus = 1 )
                            AND ( RecordStatus < 201 )
                            AND ( UserID = @FilterID )
    END

--JE added in TFS 1945
IF @ReportFilterID = 12 --Customer
    BEGIN
        DECLARE @CustomerFilterMode TINYINT
        SELECT  @CustomerFilterMode = ISNULL(dbo.FNC_GetOptionValue(60), 0)
        IF @CustomerFilterMode = 0 --by header selection
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  QMS_ResponseHeader.ResponseID
                    FROM    QMS_ResponseHeader
                            INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                            INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
                    WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                            AND ( QMS_AssessmentHeader.DataLookupID = 3 )
                            AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )
                            AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                                       AND    @DateTo )
                            AND ( QMS_Response.ResponseStatus = 1 )
                            AND ( QMS_Response.RecordStatus < 201 )
        ELSE --by stock code
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  FNC_ResponseHeader_StockCode.ResponseID
                    FROM    dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCode
                            INNER JOIN QMS_Response ON FNC_ResponseHeader_StockCode.ResponseID = QMS_Response.ResponseID
                            INNER JOIN PM_VW_StockCode ON FNC_ResponseHeader_StockCode.StockCodeID = PM_VW_StockCode.StockCodeID
                    WHERE   ( QMS_Response.EndDate BETWEEN @DateFrom
                                                   AND     @DateTo )
                            AND ( QMS_Response.ResponseStatus = 1 )
                            AND ( QMS_Response.RecordStatus < 201 )
                            AND ( PM_VW_StockCode.CustomerID = @FilterID )
    END

--MP added for TFS 2072
IF @ReportFilterID = 13 --BU
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  FNC_ResponseHeader_StockCode.ResponseID
            FROM    dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCode
                    INNER JOIN QMS_Response ON FNC_ResponseHeader_StockCode.ResponseID = QMS_Response.ResponseID
                    INNER JOIN PM_VW_StockCode ON FNC_ResponseHeader_StockCode.StockCodeID = PM_VW_StockCode.StockCodeID
            WHERE   ( QMS_Response.EndDate BETWEEN @DateFrom
                                           AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )
                    AND ( PM_VW_StockCode.BusinessUnit = @FilterText )

IF @ReportFilterID = 14 --Business group
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  FNC_ResponseHeader_StockCode.ResponseID
            FROM    dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCode
                    INNER JOIN QMS_Response ON FNC_ResponseHeader_StockCode.ResponseID = QMS_Response.ResponseID
                    INNER JOIN PM_VW_StockCode ON FNC_ResponseHeader_StockCode.StockCodeID = PM_VW_StockCode.StockCodeID
            WHERE   ( QMS_Response.EndDate BETWEEN @DateFrom
                                           AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )
                    AND ( PM_VW_StockCode.BusinessGroup = @FilterText )

IF @ReportFilterID = 15 --Segment

	BEGIN
        IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
            AND @DateTo <= @WarehouseBuildDate --use warehouse table if built within specified date range
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  ResponseID
                    FROM    RPT_Warehouse_Response
                            INNER JOIN PM_VW_StockCode ON RPT_Warehouse_Response.StockCodeID = PM_VW_StockCode.StockCodeID
                    WHERE   ( PM_VW_StockCode.StockCodeSegment = @FilterText )
                            AND ( EndDate BETWEEN @DateFrom AND @DateTo )
                            AND ( RPT_Warehouse_Response.RecordStatus < 201 )
        ELSE
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  FNC_ResponseHeader_StockCode.ResponseID
                    FROM    dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCode
                            INNER JOIN QMS_Response ON FNC_ResponseHeader_StockCode.ResponseID = QMS_Response.ResponseID
                            INNER JOIN PM_VW_StockCode ON FNC_ResponseHeader_StockCode.StockCodeID = PM_VW_StockCode.StockCodeID
                    WHERE   ( QMS_Response.EndDate BETWEEN @DateFrom
                                                   AND     @DateTo )
                            AND ( QMS_Response.ResponseStatus = 1 )
                            AND ( QMS_Response.RecordStatus < 201 )
                            AND ( PM_VW_StockCode.StockCodeSegment = @FilterText )
    END
    --INSERT  INTO @Response
    --        ( ResponseID
    --        )
    --        SELECT  FNC_ResponseHeader_StockCode.ResponseID
    --        FROM    dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCode
    --                INNER JOIN QMS_Response ON FNC_ResponseHeader_StockCode.ResponseID = QMS_Response.ResponseID
    --                INNER JOIN PM_VW_StockCode ON FNC_ResponseHeader_StockCode.StockCodeID = PM_VW_StockCode.StockCodeID
    --        WHERE   ( QMS_Response.EndDate BETWEEN @DateFrom
    --                                       AND     @DateTo )
    --                AND ( QMS_Response.ResponseStatus = 1 )
    --                AND ( QMS_Response.RecordStatus < 201 )
    --                AND ( PM_VW_StockCode.StockCodeSegment = @FilterText )

--JE TFS 3208
IF @ReportFilterID = 16 --Product Technologist
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  FNC_ResponseHeader_StockCode.ResponseID
            FROM    dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCode
                    INNER JOIN QMS_Response ON FNC_ResponseHeader_StockCode.ResponseID = QMS_Response.ResponseID
                    INNER JOIN FNC_User_StockCodeList(@FilterID) AS User_StockCodeList ON FNC_ResponseHeader_StockCode.StockCodeID = User_StockCodeList.StockCodeID
            WHERE   ( QMS_Response.EndDate BETWEEN @DateFrom
                                           AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

--JE TFS 5113
IF @ReportFilterID = 17 --Primary Supplier
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT DISTINCT
                    QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN PM_VW_StockCodePack ON QMS_ResponseHeader.Header_SourceID = PM_VW_StockCodePack.StockCodeID
                    INNER JOIN PM_VW_Supplier ON PM_VW_StockCodePack.SupplierID = PM_VW_Supplier.SupplierID
            WHERE   ( QMS_AssessmentHeader.DataLookupID = 2 )
                    AND ( PM_VW_StockCodePack.PrimarySupplier = 1 )
                    AND ( PM_VW_Supplier.SupplierID = @FilterID )

--JE TFS 4006
IF @ReportFilterID = 18 --Supplier Site
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
            WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 53 )
                    AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

--JE TFS 4301
IF @ReportFilterID = 20 --PO
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
                    INNER JOIN PM_VW_Consignment ON QMS_ResponseHeader.Header_Text = PM_VW_Consignment.E_PO
            WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND (( QMS_AssessmentHeader.DataLookupID = 5 ) OR ( QMS_AssessmentHeader.DataLookupID = 47 )) --PO can reference two different lookups
                    AND ( PM_VW_Consignment.E_PO = @FilterText )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

--JE TFS 4303
IF @ReportFilterID = 21 --Pallet Number
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
                    INNER JOIN PM_VW_StockBatch ON QMS_ResponseHeader.Header_SourceID = PM_VW_StockBatch.StockBatchID
            WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 11 )
                    AND ( PM_VW_StockBatch.StockBatchID = @FilterID )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

--JE TFS 4304
IF @ReportFilterID = 22 --Depot Date
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
            WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 12 )
                    AND ( QMS_ResponseHeader.Header_Text = @FilterText )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

--JE TFS 4302
IF @ReportFilterID = 23 --Lot Number
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
                    INNER JOIN PM_VW_Delivery ON QMS_ResponseHeader.Header_SourceID = PM_VW_Delivery.DeliveryID
            WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 7 )
                    AND ( PM_VW_Delivery.DeliveryID = @FilterID )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

-- JT TFS 4927 : Store
IF @ReportFilterID = 24 -- Store
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
            WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 54 )
                    AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

-- JT TFS 5394 : Variety
IF @ReportFilterID = 25 -- Variety
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
            WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 55 )
                    AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

IF @ReportFilterID = 28 --Stock Code (AQC)
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
            WHERE   ( QMS_AssessmentHeader.AssessmentTypeID = 16 )
                    AND ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 2 )
                    AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

IF @ReportFilterID = 29 --Supplier (AQC)
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
            WHERE   ( QMS_AssessmentHeader.AssessmentTypeID = 16 )
                    AND ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 1 )
                    AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

IF @ReportFilterID = 30 --Location (AQC)
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
            WHERE   ( QMS_AssessmentHeader.AssessmentTypeID = 16 )
                    AND ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 4 )
                    AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

IF @ReportFilterID = 31 --Grower (AQC)
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
            WHERE   ( QMS_AssessmentHeader.AssessmentTypeID = 16 )
                    AND ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 29 )
                    AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

IF @ReportFilterID = 32 --Check ID
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_Response.ResponseID
            FROM    QMS_Response
            WHERE   ( QMS_Response.ResponseID = @FilterID )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

-- If the reportfilter added is just "look it up in the header, and translate reportfilterID to a datalookupID",
-- then populate APP_ReportFilter.DataLookupID and this section will be used automatically.
IF @Filter_DataLookupID IS NOT NULL
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
                    LEFT OUTER JOIN QMS_ResponseHeaderMulti ON QMS_ResponseHeader.ResponseHeaderID = QMS_ResponseHeaderMulti.ResponseHeaderID
            WHERE   ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )
                    AND ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = @Filter_DataLookupID )
--JE TFS 8315 - can now handle filtering multi select items in header
                    AND ( ( @FilterID = ( CASE WHEN QMS_ResponseHeader.Header_SourceID = -1
                                               THEN QMS_ResponseHeaderMulti.Multi_SourceID
                                               ELSE QMS_ResponseHeader.Header_SourceID
                                          END ) )
                          OR ( ISNULL(@FilterID, 0) < 1
                               AND @FilterText = ( CASE WHEN QMS_ResponseHeader.Header_Text = ''
                                                        THEN QMS_ResponseHeaderMulti.Multi_Text
                                                        ELSE QMS_ResponseHeader.Header_Text
                                                   END )
                             )
--(@FilterText = (CASE WHEN QMS_ResponseHeader.Header_Text = '' THEN QMS_ResponseHeaderMulti.Multi_Text  ELSE QMS_ResponseHeader.Header_Text END))
                        )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND NOT EXISTS ( SELECT ResponseID
                                     FROM   @Response
                                     WHERE  ResponseID = QMS_ResponseHeader.ResponseID ) -- Don't add reponseIDs twice.

RETURN
END

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_QuestionPool_ReportGroup')
	EXEC('CREATE FUNCTION [dbo].[FNC_QuestionPool_ReportGroup]() RETURNS @x TABLE (y bit) AS BEGIN RETURN END')
GO
-- =============================================
-- Author:		Jon Edwards
-- Create date: 30/10/2012
-- Description:	Gets report on and grouping text/IDs for Question Performance report
--		TEMP_Selected contains selected ReportOn options (e.g. Questions)
--		TEMP_ResponseHeader contains Responses within date range and filtered (if applied)
-- Version: 11
-- =============================================
-- JE TFS 5268: updated to handle Groups and Sub Groups with NULL or empty string values
-- JE TFS 5284: added ReportByCheck param so distinct questions are returned when param = 1
--				also moved sub query for Worst Check flag into this function
-- JT TFS 5453: Don't join on question table in sub-query for QAS Section to improve performance.
-- JT TFS 5975: Convert NULL QuestionGroup and QuestionSubGroup to empty strings before trying to link to WorstFlag table.
-- JE TFS 6768: added local variables to improve performance
-- JE TFS 8212: removed calls to FNC_QuestionPool_GetAssessmentSection in query and populate temp tables with results to improve performance
-- JE TFS 8212: added more table variables to further improve performance
-- JT TFS 13-1000: Constrain join between @AllAssessmentSections and @MinCheckID to match on ResponseID and QuestionID
-- JE TFS 13-2917: report using data warehouse where it is available
-- JF tfs 99998  - timeout - seperated queries from @LocReportOn IN (1,2)
-- =============================================
ALTER FUNCTION [dbo].[FNC_QuestionPool_ReportGroup]
(
	@UserId int,
	@GroupBy int,
	@ReportOn int,
	@ReportByCheck bit --0 = by check, 1 = by count
)
RETURNS @QuestionGrouping TABLE
(
	ResponseID int,
	ResponseQuestionID int,
	ReportOnText nvarchar (255),
	GroupByText nvarchar (255),
	QAFlag int --when reporting by check, get worst flag for each distinct question in check, otherwise this is just the flag for each question
)
AS
BEGIN

--declare @UserId int = 1, @GroupBy int = 0, @ReportOn int = 3, @ReportByCheck bit = 0

	--use local variables to combat performance issues caused by parameter sniffing
	DECLARE @LocUserID int, @LocGroupBy int, @LocReportOn int, @LocReportByCheck int
	SELECT @LocUserID = @UserID, @LocGroupBy = @GroupBy, @LocReportOn = @ReportOn, @LocReportByCheck = @ReportByCheck

	--get reporting warehouse config option
	DECLARE @UseDataWarehouse bit
	SET @UseDataWarehouse = dbo.FNC_CanUseDataWarehouse(@UserID)

	--table to hold Minimum Check ID for each Check NOTE: TEMP_ResponseHeader holds selected ResponseIDs, not header data
	DECLARE @MinCheckID TABLE(ResponseID int, QuestionID int, ResponseQuestionID int)
	--table to hold all Assessment Sections for selected checks
	DECLARE @AllAssessmentSections TABLE(ResponseID int, QuestionID int, ResponseQuestionID int, AssessmentSection nvarchar(255))
	--table to hold worst flag for each Question ID per check
	DECLARE @WorstFlagPerCheck TABLE(ResponseID int, QuestionID int, QuestionGroup nvarchar(100), QuestionSubGroup nvarchar(100), WorstFlag int)
	
	IF @UseDataWarehouse = 1  --use data warehouse
	BEGIN
		--fill Minimum Check IDs table
		INSERT INTO @MinCheckID(ResponseID, QuestionID, ResponseQuestionID)
		SELECT  RPT_Warehouse_ResponseQuestion.ResponseID, RPT_Warehouse_ResponseQuestion.QuestionID, MIN(RPT_Warehouse_ResponseQuestion.ResponseQuestionID) AS ResponseQuestionID
		FROM	TEMP_ResponseHeader INNER JOIN
					RPT_Warehouse_ResponseQuestion ON TEMP_ResponseHeader.AssessmentHeaderID = RPT_Warehouse_ResponseQuestion.ResponseID
		WHERE	(TEMP_ResponseHeader.UserID = @LocUserID)
		GROUP BY RPT_Warehouse_ResponseQuestion.ResponseID, RPT_Warehouse_ResponseQuestion.QuestionID
		
		--fill Assessment Sections table
		INSERT INTO @AllAssessmentSections(ResponseID, QuestionID, ResponseQuestionID, AssessmentSection)
		SELECT	TEMP_ResponseHeader.AssessmentHeaderID, RPT_Warehouse_ResponseQuestion.QuestionID, RPT_Warehouse_ResponseQuestion.ResponseQuestionID, 
					RPT_Warehouse_ResponseQuestion.AssessmentSection
		FROM	TEMP_ResponseHeader INNER JOIN
					RPT_Warehouse_ResponseQuestion ON TEMP_ResponseHeader.AssessmentHeaderID = RPT_Warehouse_ResponseQuestion.ResponseID
		WHERE	(TEMP_ResponseHeader.UserID = @LocUserID)	
		
		--fill Worst Flag Per Check table	
		INSERT INTO @WorstFlagPerCheck(ResponseID, QuestionID, QuestionGroup, QuestionSubGroup, WorstFlag)
		SELECT	RPT_Warehouse_ResponseQuestion.ResponseID, QMS_QuestionPool.QuestionID, QMS_QuestionPool.QuestionGroup,
					QMS_QuestionPool.QuestionSubGroup, MAX(RPT_Warehouse_ResponseQuestion.QAFlagID) AS WorstFlag
		FROM	TEMP_ResponseHeader INNER JOIN
					RPT_Warehouse_ResponseQuestion ON TEMP_ResponseHeader.AssessmentHeaderID = RPT_Warehouse_ResponseQuestion.ResponseID INNER JOIN
					QMS_QuestionPool ON RPT_Warehouse_ResponseQuestion.QuestionID = QMS_QuestionPool.QuestionID
		WHERE	(TEMP_ResponseHeader.UserID = @LocUserID)
		GROUP BY RPT_Warehouse_ResponseQuestion.ResponseID, QMS_QuestionPool.QuestionID, QMS_QuestionPool.QuestionGroup, QMS_QuestionPool.QuestionSubGroup		
	END
	ELSE --don't use data warehouse
	BEGIN
		--fill Minimum Check IDs table
		INSERT INTO @MinCheckID(ResponseID, QuestionID, ResponseQuestionID)
		SELECT     QMS_ResponseQuestion.ResponseID, QMS_QuestionPool.QuestionID, MIN(QMS_ResponseQuestion.ResponseQuestionID) AS ResponseQuestionID
		FROM         TEMP_ResponseHeader INNER JOIN
							  QMS_ResponseQuestion ON TEMP_ResponseHeader.AssessmentHeaderID = QMS_ResponseQuestion.ResponseID INNER JOIN
							  QMS_AssessmentQuestion ON QMS_ResponseQuestion.AssessmentQuestionID = QMS_AssessmentQuestion.AssessmentQuestionID INNER JOIN
							  QMS_QuestionPool ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID
		WHERE     (TEMP_ResponseHeader.UserID = @LocUserID)
		GROUP BY QMS_ResponseQuestion.ResponseID, QMS_QuestionPool.QuestionID
		
		--fill Assessment Sections table
		INSERT INTO @AllAssessmentSections(ResponseID, QuestionID, ResponseQuestionID, AssessmentSection)
		SELECT     TEMP_ResponseHeader.AssessmentHeaderID, QMS_QuestionPool.QuestionID, QMS_ResponseQuestion.ResponseQuestionID, 
							  dbo.FNC_QuestionPool_GetAssessmentSection(QMS_ResponseQuestion.ResponseQuestionID) AS Expr1
		FROM         TEMP_ResponseHeader INNER JOIN
							  QMS_ResponseQuestion ON TEMP_ResponseHeader.AssessmentHeaderID = QMS_ResponseQuestion.ResponseID INNER JOIN
							  QMS_AssessmentQuestion ON QMS_ResponseQuestion.AssessmentQuestionID = QMS_AssessmentQuestion.AssessmentQuestionID INNER JOIN
							  QMS_QuestionPool ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID
		WHERE     (TEMP_ResponseHeader.UserID = @LocUserID)		
		
		--fill Worst Flag Per Check table
		INSERT INTO @WorstFlagPerCheck(ResponseID, QuestionID, QuestionGroup, QuestionSubGroup, WorstFlag)
		SELECT     QMS_ResponseQuestion.ResponseID, QMS_QuestionPool.QuestionID, QMS_QuestionPool.QuestionGroup, QMS_QuestionPool.QuestionSubGroup, 
							  MAX(QMS_ResponseQuestion.Recommended_QAFlagID) AS WorstFlag
		FROM         TEMP_ResponseHeader INNER JOIN
							  QMS_ResponseQuestion ON TEMP_ResponseHeader.AssessmentHeaderID = QMS_ResponseQuestion.ResponseID INNER JOIN
							  QMS_AssessmentQuestion ON QMS_ResponseQuestion.AssessmentQuestionID = QMS_AssessmentQuestion.AssessmentQuestionID INNER JOIN
							  QMS_QuestionPool ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID
		WHERE     (TEMP_ResponseHeader.UserID = @LocUserID)
		GROUP BY QMS_ResponseQuestion.ResponseID, QMS_QuestionPool.QuestionID, QMS_QuestionPool.QuestionGroup, QMS_QuestionPool.QuestionSubGroup		
	END

	--table to hold minimum ResponseQuestionID's Assessment Section for each distinct Question in each Response (used to report by check on Questions grouped by Assessment Section)
	DECLARE @MinCheckIDAssessmentSection TABLE(ResponseID int, QuestionID int, ResponseQuestionID int, AssessmentSection nvarchar(255))
	INSERT INTO	@MinCheckIDAssessmentSection(ResponseID, QuestionID, ResponseQuestionID, AssessmentSection)
	SELECT	MinCheckID.ResponseID, MinCheckID.QuestionID, MinCheckID.ResponseQuestionID,
				AllAssessmentSections.AssessmentSection
	FROM	@AllAssessmentSections AS AllAssessmentSections INNER JOIN
				@MinCheckID AS MinCheckID ON AllAssessmentSections.ResponseID = MinCheckID.ResponseID
					AND AllAssessmentSections.QuestionID = MinCheckID.QuestionID


	--main report queries
	IF @LocReportOn IN (1) --Question Group 
	BEGIN
		IF @UseDataWarehouse = 1
		BEGIN
			INSERT INTO @QuestionGrouping (ResponseID, ResponseQuestionID, ReportOnText, GroupByText, QAFlag)
			SELECT DISTINCT	TEMP_ResponseHeader.AssessmentHeaderID,
								CASE WHEN @LocReportByCheck = 0 THEN RPT_Warehouse_ResponseQuestion.ResponseQuestionID ELSE NULL END, --when not reporting by check, return NULL so we can get distinct questions for each response
								TEMP_Selected.SelectedText,
								CASE WHEN @LocGroupBy = 1 THEN 
									(CASE WHEN QMS_QuestionPool.QuestionGroup IS NULL OR QMS_QuestionPool.QuestionGroup = '' THEN 'No Group'
												ELSE QMS_QuestionPool.QuestionGroup END)
									WHEN @LocGroupBy = 2 THEN
									(CASE WHEN QMS_QuestionPool.QuestionSubGroup IS NULL OR QMS_QuestionPool.QuestionSubGroup = '' THEN 'No Sub Group'
												ELSE QMS_QuestionPool.QuestionSubGroup END)
								ELSE NULL END, --return NULL as it's not possible to group Questions Groups or Sub Groups by Question
								CASE WHEN @LocReportByCheck = 1 THEN WorstFlagPerCheck.WorstFlag ELSE RPT_Warehouse_ResponseQuestion.QAFlagID END
			FROM	TEMP_ResponseHeader INNER JOIN
						RPT_Warehouse_ResponseQuestion ON TEMP_ResponseHeader.AssessmentHeaderID = RPT_Warehouse_ResponseQuestion.ResponseID INNER JOIN
						QMS_QuestionPool ON RPT_Warehouse_ResponseQuestion.QuestionID = QMS_QuestionPool.QuestionID INNER JOIN
						TEMP_Selected ON --(CASE WHEN @LocReportOn = 1 THEN --join correctly when No Group selected
											--	(
												CASE WHEN QuestionGroup IS NULL OR QuestionGroup = '' THEN 'No Group' ELSE QuestionGroup END
												--)
											--WHEN @LocReportOn = 2 THEN
											--	(CASE WHEN QuestionSubGroup IS NULL OR QuestionSubGroup = '' THEN 'No Sub Group' ELSE QuestionSubGroup END)
											--END) 
											= TEMP_Selected.SelectedText LEFT OUTER JOIN
						@WorstFlagPerCheck AS WorstFlagPerCheck ON TEMP_ResponseHeader.AssessmentHeaderID = WorstFlagPerCheck.ResponseID AND
							-- make sure that we take into account that (NULL = NULL) is false and does not return a row. Convert nulls to empty strings instead.
							ISNULL(QMS_QuestionPool.QuestionGroup, '') =
							ISNULL(WorstFlagPerCheck.QuestionGroup, '')
			WHERE	(TEMP_Selected.UserID = @LocUserID) AND (TEMP_ResponseHeader.UserID = @LocUserID)
		END
		ELSE
		BEGIN
			INSERT INTO @QuestionGrouping (ResponseID, ResponseQuestionID, ReportOnText, GroupByText, QAFlag)
			SELECT DISTINCT	TEMP_ResponseHeader.AssessmentHeaderID,
								CASE WHEN @LocReportByCheck = 0 THEN QMS_ResponseQuestion.ResponseQuestionID ELSE NULL END, --when not reporting by check, return NULL so we can get distinct questions for each response
								TEMP_Selected.SelectedText,
								CASE WHEN @LocGroupBy = 1 THEN 
									(CASE WHEN QMS_QuestionPool.QuestionGroup IS NULL OR QMS_QuestionPool.QuestionGroup = '' THEN 'No Group'
												ELSE QMS_QuestionPool.QuestionGroup END)
									WHEN @LocGroupBy = 2 THEN
									(CASE WHEN QMS_QuestionPool.QuestionSubGroup IS NULL OR QMS_QuestionPool.QuestionSubGroup = '' THEN 'No Sub Group'
												ELSE QMS_QuestionPool.QuestionSubGroup END)
								ELSE NULL END, --return NULL as it's not possible to group Questions Groups or Sub Groups by Question
								CASE WHEN @LocReportByCheck = 1 THEN WorstFlagPerCheck.WorstFlag ELSE QMS_ResponseQuestion.Recommended_QAFlagID END
			FROM	TEMP_ResponseHeader INNER JOIN
						QMS_ResponseQuestion ON TEMP_ResponseHeader.AssessmentHeaderID = QMS_ResponseQuestion.ResponseID INNER JOIN
						QMS_AssessmentQuestion ON QMS_ResponseQuestion.AssessmentQuestionID = QMS_AssessmentQuestion.AssessmentQuestionID INNER JOIN
						QMS_QuestionPool ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID INNER JOIN
						TEMP_Selected ON 
											--(CASE WHEN @LocReportOn = 1 THEN --join correctly when No Group selected
											--	(
												CASE WHEN QuestionGroup IS NULL OR QuestionGroup = '' THEN 'No Group' ELSE QuestionGroup END
											--	)
											--WHEN @LocReportOn = 2 THEN
											--	(CASE WHEN QuestionSubGroup IS NULL OR QuestionSubGroup = '' THEN 'No Sub Group' ELSE QuestionSubGroup END)
											--END) 
											= TEMP_Selected.SelectedText LEFT OUTER JOIN
						@WorstFlagPerCheck AS WorstFlagPerCheck ON TEMP_ResponseHeader.AssessmentHeaderID = WorstFlagPerCheck.ResponseID AND
							-- make sure that we take into account that (NULL = NULL) is false and does not return a row. Convert nulls to empty strings instead.
							ISNULL(QMS_QuestionPool.QuestionGroup, '') =
							ISNULL(WorstFlagPerCheck.QuestionGroup, '')
						WHERE	(TEMP_Selected.UserID = @LocUserID) AND (TEMP_ResponseHeader.UserID = @LocUserID)		
		END
	END
	ELSE IF @LocReportOn = 2 --question sub group
	BEGIN
		IF @UseDataWarehouse = 1
		BEGIN
			INSERT INTO @QuestionGrouping (ResponseID, ResponseQuestionID, ReportOnText, GroupByText, QAFlag)
			SELECT DISTINCT	TEMP_ResponseHeader.AssessmentHeaderID,
								CASE WHEN @LocReportByCheck = 0 THEN RPT_Warehouse_ResponseQuestion.ResponseQuestionID ELSE NULL END, --when not reporting by check, return NULL so we can get distinct questions for each response
								TEMP_Selected.SelectedText,
								CASE WHEN @LocGroupBy = 1 THEN 
									(CASE WHEN QMS_QuestionPool.QuestionGroup IS NULL OR QMS_QuestionPool.QuestionGroup = '' THEN 'No Group'
												ELSE QMS_QuestionPool.QuestionGroup END)
									WHEN @LocGroupBy = 2 THEN
									(CASE WHEN QMS_QuestionPool.QuestionSubGroup IS NULL OR QMS_QuestionPool.QuestionSubGroup = '' THEN 'No Sub Group'
												ELSE QMS_QuestionPool.QuestionSubGroup END)
								ELSE NULL END, --return NULL as it's not possible to group Questions Groups or Sub Groups by Question
								CASE WHEN @LocReportByCheck = 1 THEN WorstFlagPerCheck.WorstFlag ELSE RPT_Warehouse_ResponseQuestion.QAFlagID END
			FROM	TEMP_ResponseHeader INNER JOIN
						RPT_Warehouse_ResponseQuestion ON TEMP_ResponseHeader.AssessmentHeaderID = RPT_Warehouse_ResponseQuestion.ResponseID INNER JOIN
						QMS_QuestionPool ON RPT_Warehouse_ResponseQuestion.QuestionID = QMS_QuestionPool.QuestionID INNER JOIN
						TEMP_Selected ON --(CASE WHEN @LocReportOn = 1 THEN --join correctly when No Group selected
											--	(CASE WHEN QuestionGroup IS NULL OR QuestionGroup = '' THEN 'No Group' ELSE QuestionGroup END)
											--WHEN @LocReportOn = 2 THEN
											--	(
												CASE WHEN QuestionSubGroup IS NULL OR QuestionSubGroup = '' THEN 'No Sub Group' ELSE QuestionSubGroup END
											--	)
											--END) 
											= TEMP_Selected.SelectedText LEFT OUTER JOIN
						@WorstFlagPerCheck AS WorstFlagPerCheck ON TEMP_ResponseHeader.AssessmentHeaderID = WorstFlagPerCheck.ResponseID AND
							-- make sure that we take into account that (NULL = NULL) is false and does not return a row. Convert nulls to empty strings instead.
							ISNULL(QMS_QuestionPool.QuestionSubGroup , '') =
							ISNULL(WorstFlagPerCheck.QuestionSubGroup, '')
			WHERE	(TEMP_Selected.UserID = @LocUserID) AND (TEMP_ResponseHeader.UserID = @LocUserID)
		END
		ELSE
		BEGIN
			INSERT INTO @QuestionGrouping (ResponseID, ResponseQuestionID, ReportOnText, GroupByText, QAFlag)
			SELECT DISTINCT	TEMP_ResponseHeader.AssessmentHeaderID,
								CASE WHEN @LocReportByCheck = 0 THEN QMS_ResponseQuestion.ResponseQuestionID ELSE NULL END, --when not reporting by check, return NULL so we can get distinct questions for each response
								TEMP_Selected.SelectedText,
								CASE WHEN @LocGroupBy = 1 THEN 
									(CASE WHEN QMS_QuestionPool.QuestionGroup IS NULL OR QMS_QuestionPool.QuestionGroup = '' THEN 'No Group'
												ELSE QMS_QuestionPool.QuestionGroup END)
									WHEN @LocGroupBy = 2 THEN
									(CASE WHEN QMS_QuestionPool.QuestionSubGroup IS NULL OR QMS_QuestionPool.QuestionSubGroup = '' THEN 'No Sub Group'
												ELSE QMS_QuestionPool.QuestionSubGroup END)
								ELSE NULL END, --return NULL as it's not possible to group Questions Groups or Sub Groups by Question
								CASE WHEN @LocReportByCheck = 1 THEN WorstFlagPerCheck.WorstFlag ELSE QMS_ResponseQuestion.Recommended_QAFlagID END
			FROM	TEMP_ResponseHeader INNER JOIN
						QMS_ResponseQuestion ON TEMP_ResponseHeader.AssessmentHeaderID = QMS_ResponseQuestion.ResponseID INNER JOIN
						QMS_AssessmentQuestion ON QMS_ResponseQuestion.AssessmentQuestionID = QMS_AssessmentQuestion.AssessmentQuestionID INNER JOIN
						QMS_QuestionPool ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID INNER JOIN
						TEMP_Selected ON --(CASE WHEN @LocReportOn = 1 THEN --join correctly when No Group selected
											--	(CASE WHEN QuestionGroup IS NULL OR QuestionGroup = '' THEN 'No Group' ELSE QuestionGroup END)
											--WHEN @LocReportOn = 2 THEN
												--(
												CASE WHEN QuestionSubGroup IS NULL OR QuestionSubGroup = '' THEN 'No Sub Group' ELSE QuestionSubGroup END
												--)
											--END) 
											= TEMP_Selected.SelectedText LEFT OUTER JOIN
						@WorstFlagPerCheck AS WorstFlagPerCheck ON TEMP_ResponseHeader.AssessmentHeaderID = WorstFlagPerCheck.ResponseID AND
							-- make sure that we take into account that (NULL = NULL) is false and does not return a row. Convert nulls to empty strings instead.
							ISNULL(QMS_QuestionPool.QuestionSubGroup, '') =
							ISNULL(WorstFlagPerCheck.QuestionSubGroup, '')
						WHERE	(TEMP_Selected.UserID = @LocUserID) AND (TEMP_ResponseHeader.UserID = @LocUserID)		
		END
	END
	ELSE IF @LocReportOn = 3 --Question
	BEGIN
		IF @UseDataWarehouse = 1
		BEGIN
			INSERT INTO @QuestionGrouping (ResponseID, ResponseQuestionID, ReportOnText, GroupByText, QAFlag)
			SELECT DISTINCT	TEMP_ResponseHeader.AssessmentHeaderID,
								CASE WHEN @LocReportByCheck = 0 THEN RPT_Warehouse_ResponseQuestion.ResponseQuestionID ELSE MinCheckIDSection.ResponseQuestionID END,
								TEMP_Selected.SelectedText,
								CASE WHEN @LocGroupBy = 1 THEN
									(CASE WHEN QMS_QuestionPool.QuestionGroup IS NULL OR QMS_QuestionPool.QuestionGroup = '' THEN 'No Group'
												ELSE QMS_QuestionPool.QuestionGroup END)
									WHEN @LocGroupBy = 2 THEN
									(CASE WHEN QMS_QuestionPool.QuestionSubGroup IS NULL OR QMS_QuestionPool.QuestionSubGroup = '' THEN 'No Sub Group'
												ELSE QMS_QuestionPool.QuestionSubGroup END)
									WHEN @LocGroupBy = 4 THEN
									--call function to get Assessment Section for input ResponseQuestionID
									(CASE WHEN @LocReportByCheck = 1 THEN MinCheckIDSection.AssessmentSection
												ELSE CheckIDSection.AssessmentSection END)
									ELSE NULL END, --return NULL as grouping Question by Question doesn't make sense
								CASE WHEN @LocReportByCheck = 1 THEN WorstFlagPerCheck.WorstFlag ELSE RPT_Warehouse_ResponseQuestion.QAFlagID END
			FROM	TEMP_ResponseHeader INNER JOIN
						RPT_Warehouse_ResponseQuestion ON TEMP_ResponseHeader.AssessmentHeaderID = RPT_Warehouse_ResponseQuestion.ResponseID INNER JOIN
						QMS_QuestionPool ON RPT_Warehouse_ResponseQuestion.QuestionID = QMS_QuestionPool.QuestionID INNER JOIN
						TEMP_Selected ON QMS_QuestionPool.QuestionID = TEMP_Selected.SelectedID LEFT OUTER JOIN
						@WorstFlagPerCheck AS WorstFlagPerCheck ON TEMP_ResponseHeader.AssessmentHeaderID = WorstFlagPerCheck.ResponseID AND
							QMS_QuestionPool.QuestionID = WorstFlagPerCheck.QuestionID LEFT OUTER JOIN
						@MinCheckIDAssessmentSection AS MinCheckIDSection ON TEMP_ResponseHeader.AssessmentHeaderID = MinCheckIDSection.ResponseID AND
							QMS_QuestionPool.QuestionID = MinCheckIDSection.QuestionID LEFT OUTER JOIN
						@AllAssessmentSections AS CheckIDSection ON TEMP_ResponseHeader.AssessmentHeaderID = CheckIDSection.ResponseID AND
							QMS_QuestionPool.QuestionID = CheckIDSection.QuestionID
			WHERE	(TEMP_Selected.UserID = @LocUserID) AND (TEMP_ResponseHeader.UserID = @LocUserID) AND (QMS_QuestionPool.IsQuestionGroup = 0)
		END
		ELSE
		BEGIN
			INSERT INTO @QuestionGrouping (ResponseID, ResponseQuestionID, ReportOnText, GroupByText, QAFlag)
			SELECT DISTINCT	TEMP_ResponseHeader.AssessmentHeaderID,
								CASE WHEN @LocReportByCheck = 0 THEN QMS_ResponseQuestion.ResponseQuestionID ELSE MinCheckIDSection.ResponseQuestionID END,
								TEMP_Selected.SelectedText,
								CASE WHEN @LocGroupBy = 1 THEN
									(CASE WHEN QMS_QuestionPool.QuestionGroup IS NULL OR QMS_QuestionPool.QuestionGroup = '' THEN 'No Group'
												ELSE QMS_QuestionPool.QuestionGroup END)
									WHEN @LocGroupBy = 2 THEN
									(CASE WHEN QMS_QuestionPool.QuestionSubGroup IS NULL OR QMS_QuestionPool.QuestionSubGroup = '' THEN 'No Sub Group'
												ELSE QMS_QuestionPool.QuestionSubGroup END)
									WHEN @LocGroupBy = 4 THEN
									--call function to get Assessment Section for input ResponseQuestionID
									(CASE WHEN @LocReportByCheck = 1 THEN MinCheckIDSection.AssessmentSection
												ELSE CheckIDSection.AssessmentSection END)
									ELSE NULL END, --return NULL as grouping Question by Question doesn't make sense
								CASE WHEN @LocReportByCheck = 1 THEN WorstFlagPerCheck.WorstFlag ELSE QMS_ResponseQuestion.Recommended_QAFlagID END
			FROM	TEMP_ResponseHeader INNER JOIN
						QMS_ResponseQuestion ON TEMP_ResponseHeader.AssessmentHeaderID = QMS_ResponseQuestion.ResponseID INNER JOIN
						QMS_AssessmentQuestion ON QMS_ResponseQuestion.AssessmentQuestionID = QMS_AssessmentQuestion.AssessmentQuestionID INNER JOIN
						QMS_QuestionPool ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID INNER JOIN
						TEMP_Selected ON QMS_QuestionPool.QuestionID = TEMP_Selected.SelectedID LEFT OUTER JOIN
						@WorstFlagPerCheck AS WorstFlagPerCheck ON TEMP_ResponseHeader.AssessmentHeaderID = WorstFlagPerCheck.ResponseID AND
							QMS_QuestionPool.QuestionID = WorstFlagPerCheck.QuestionID LEFT OUTER JOIN
						@MinCheckIDAssessmentSection AS MinCheckIDSection ON TEMP_ResponseHeader.AssessmentHeaderID = MinCheckIDSection.ResponseID AND
							QMS_QuestionPool.QuestionID = MinCheckIDSection.QuestionID LEFT OUTER JOIN
						@AllAssessmentSections AS CheckIDSection ON TEMP_ResponseHeader.AssessmentHeaderID = CheckIDSection.ResponseID AND
							QMS_QuestionPool.QuestionID = CheckIDSection.QuestionID
			WHERE	(TEMP_Selected.UserID = @LocUserID) AND (TEMP_ResponseHeader.UserID = @LocUserID) AND (QMS_QuestionPool.IsQuestionGroup = 0)		
		END
	END
	ELSE IF @LocReportOn = 4 --Assessment Section
	BEGIN
		INSERT INTO @QuestionGrouping (ResponseID, ResponseQuestionID, ReportOnText, GroupByText, QAFlag)
		SELECT DISTINCT	TEMP_ResponseHeader.AssessmentHeaderID,
							CASE WHEN @LocReportByCheck = 0 THEN QMS_ResponseQuestion.ResponseQuestionID ELSE NULL END,
							TEMP_Selected.SelectedText,
							CASE WHEN @LocGroupBy = 1 THEN
								(CASE WHEN QMS_QuestionPool.QuestionGroup IS NULL OR QMS_QuestionPool.QuestionGroup = '' THEN 'No Group'
											ELSE QMS_QuestionPool.QuestionGroup END)
								WHEN @LocGroupBy = 2 THEN
								(CASE WHEN QMS_QuestionPool.QuestionSubGroup IS NULL OR QMS_QuestionPool.QuestionSubGroup = '' THEN 'No Sub Group'
											ELSE QMS_QuestionPool.QuestionSubGroup END)
								ELSE NULL END, --return NULL as grouping Assessment Section by itself or by Question doesn't make sense
							CASE WHEN @LocReportByCheck = 1 THEN WorstFlagPerCheck.WorstFlag ELSE QMS_ResponseQuestion.Recommended_QAFlagID END
		FROM	TEMP_ResponseHeader INNER JOIN
					QMS_ResponseQuestion ON TEMP_ResponseHeader.AssessmentHeaderID = QMS_ResponseQuestion.ResponseID INNER JOIN
					QMS_AssessmentQuestion ON QMS_ResponseQuestion.AssessmentQuestionID = QMS_AssessmentQuestion.AssessmentQuestionID INNER JOIN
					QMS_QuestionPool ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID INNER JOIN
					--get parent questions
					QMS_AssessmentQuestion AS SectionsAS ON QMS_AssessmentQuestion.ParentQuestionID = SectionsAS.AssessmentQuestionID INNER JOIN
					QMS_QuestionPool AS QuestionsAS ON SectionsAS.QuestionID = QuestionsAS.QuestionID INNER JOIN
					TEMP_Selected ON SectionsAS.QuestionID = TEMP_Selected.SelectedID LEFT OUTER JOIN
					@WorstFlagPerCheck AS WorstFlagPerCheck ON TEMP_ResponseHeader.AssessmentHeaderID = WorstFlagPerCheck.ResponseID AND
						--join on Assessment Section's Question ID
						QuestionsAS.QuestionID = WorstFlagPerCheck.QuestionID
		WHERE	(TEMP_Selected.UserID = @LocUserID) AND (TEMP_ResponseHeader.UserID = @LocUserID)
	END
RETURN
END

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Assessment_GetLastUpdate')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Assessment_GetLastUpdate] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 30/12/2011
-- Description:	Gets date/time of last assessment change
-- Version:		3
-- =============================================
-- Change to convert UTC time to local time
-- JF TFS 128865: check for changes in QMS_AssessmentSpecHeader too
-- =============================================
ALTER PROCEDURE [dbo].[QRY_Assessment_GetLastUpdate] 
	@AssessmentGUID uniqueidentifier
AS

--exec QRY_Assessment_GetLastUpdate 'F85F4EC1-3E9B-4F12-BA7C-B5E5C974E56A'
--declare @AssessmentGUID uniqueidentifier = 'F85F4EC1-3E9B-4F12-BA7C-B5E5C974E56A'
DECLARE @AssessmentID int, @Updated datetime, @TempUpdated datetime

SET NOCOUNT ON

SELECT     @AssessmentID = AssessmentID, @Updated = ISNULL(Updated, Inserted)
FROM         QMS_Assessment
WHERE     (GUID = @AssessmentGUID)

--Get AssessmentQuestion update
SELECT     @TempUpdated = MAX(ISNULL(Updated, Inserted))
FROM         QMS_AssessmentQuestion
WHERE     (AssessmentID = @AssessmentID)

IF @TempUpdated > @Updated
	SET @Updated = @TempUpdated

--Get AssessmentQuestionConstraint update
SELECT     @TempUpdated = MAX(ISNULL(QMS_AssessmentQuestionConstraint.Updated, QMS_AssessmentQuestionConstraint.Inserted))
FROM         QMS_AssessmentQuestionConstraint INNER JOIN
                      QMS_AssessmentQuestion ON QMS_AssessmentQuestionConstraint.AssessmentQuestionID = QMS_AssessmentQuestion.AssessmentQuestionID
WHERE     (QMS_AssessmentQuestion.AssessmentID = @AssessmentID)

IF @TempUpdated > @Updated
	SET @Updated = @TempUpdated

SELECT     @TempUpdated = MAX(ISNULL(QMS_AssessmentSpecHeader.Updated, QMS_AssessmentSpecHeader.Inserted))
FROM         QMS_AssessmentSpecHeader INNER JOIN
                      QMS_Assessment ON QMS_AssessmentSpecHeader.AssessmentID = QMS_Assessment.AssessmentID
WHERE     (QMS_Assessment.AssessmentID = @AssessmentID)

IF @TempUpdated > @Updated
	SET @Updated = @TempUpdated


SET NOCOUNT OFF

SELECT dbo.FNC_ConvertUTCDate(@Updated) AS LastUpdate
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_QuestionPool_ReportOnOptionsByAssessmentType')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_QuestionPool_ReportOnOptionsByAssessmentType] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jon Edwards
-- Create date: 23/10/2012
-- Description:	Used in Question Performance Report to return Report On options
-- Version: 3
-- =============================================
-- JE TFS 5268: now handles Groups and Sub Groups with NULL or empty string values
-- JF TFS 99998 - very slow - moved the assessment string function into a temp table
-- =============================================
ALTER PROCEDURE [dbo].[QRY_QuestionPool_ReportOnOptionsByAssessmentType]
	@AssessmentTypeID_LIST nvarchar(100),
	@ReportOn int
AS
BEGIN

--declare @AssessmentTypeID_LIST nvarchar(100) = '2,17', @ReportOn int = 2

	IF nullif(object_id('tempdb..#AssessmentTypes'), 0) IS NOT NULL DROP TABLE #AssessmentTypes
	CREATE TABLE #AssessmentTypes (
		AssessmentTypeID int
	)
	INSERT INTO #AssessmentTypes (AssessmentTypeID)
			SELECT CAST(Token AS int) AS AssessmentTypeID FROM dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',') AS SplitString_AssessmentType

	IF nullif(object_id('tempdb..#QuestionIDs'), 0) IS NOT NULL DROP TABLE #QuestionIDs
	CREATE TABLE #QuestionIDs (
		QuestionID int
	)

	--populate temp table with all QuestionIDs that are in selected assessments
	INSERT INTO #QuestionIDs (QuestionID)
	SELECT DISTINCT QMS_AssessmentQuestion.QuestionID
	FROM		
		QMS_AssessmentQuestion INNER JOIN
		QMS_Response ON QMS_AssessmentQuestion.AssessmentID = QMS_Response.AssessmentID
		INNER JOIN #AssessmentTypes as AssessmentTypes on AssessmentTypes.AssessmentTypeID = QMS_Response.AssessmentTypeID
	WHERE     
		(QMS_AssessmentQuestion.RecordStatus < 201) AND 
		(QMS_Response.RecordStatus < 201)
		--AND (QMS_Response.AssessmentTypeID IN (SELECT CAST(Token AS int) AS AssessmentTypeID
		--FROM dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',') AS SplitString_AssessmentType))

	IF @ReportOn = 1 --Question Group - if blanks or NULLs exist, display these as No Group
		SELECT * --use sub query so No Group always appears at top of list
		FROM (SELECT DISTINCT CASE WHEN QuestionGroup IS NULL OR QuestionGroup = '' THEN 'No Group' ELSE QuestionGroup END AS QuestionGroup
				FROM	QMS_QuestionPool
				WHERE	(RecordStatus < 201) AND (QuestionID IN (SELECT QuestionID FROM #QuestionIDs))) AS Groups
		ORDER BY CASE WHEN QuestionGroup = 'No Group' THEN 0 ELSE 1 END, QuestionGroup
	
	IF @ReportOn = 2 --Question Sub Group
		SELECT *
		FROM (SELECT DISTINCT CASE WHEN QuestionSubGroup IS NULL OR QuestionSubGroup = '' THEN 'No Sub Group' ELSE QuestionSubGroup END AS QuestionSubGroup,
					CASE WHEN QuestionGroup IS NULL OR QuestionGroup = '' THEN 'No Group' ELSE QuestionGroup END AS QuestionGroup
				FROM	QMS_QuestionPool
				WHERE	(RecordStatus < 201) AND (QuestionID IN (SELECT QuestionID FROM #QuestionIDs))) AS SubGroups
		ORDER BY CASE WHEN QuestionSubGroup = 'No Sub Group' THEN 0 ELSE 1 END, CASE WHEN QuestionGroup = 'No Group' THEN 0 ELSE 1 END,
					QuestionGroup, QuestionSubGroup
		
	IF @ReportOn = 3 --Question
		SELECT QuestionID, Question,
				CASE WHEN QuestionSubGroup IS NULL OR QuestionSubGroup = '' THEN 'No Sub Group' ELSE QuestionSubGroup END AS QuestionSubGroup,
				CASE WHEN QuestionGroup IS NULL OR QuestionGroup = '' THEN 'No Group' ELSE QuestionGroup END AS QuestionGroup
		FROM	QMS_QuestionPool
		WHERE	(RecordStatus < 201) AND (IsQuestionGroup = 0) AND
					(Question IS NOT NULL) AND (QuestionID IN (SELECT QuestionID FROM #QuestionIDs))
		ORDER BY CASE WHEN QuestionSubGroup = 'No Sub Group' THEN 0 ELSE 1 END, CASE WHEN QuestionGroup = 'No Group' THEN 0 ELSE 1 END,
					QuestionGroup, QuestionSubGroup, Question
		
	IF @ReportOn = 4 --Assessment Section
		SELECT QuestionID, Question
		FROM	QMS_QuestionPool
		WHERE	(RecordStatus < 201) AND (IsQuestionGroup = 1) AND
					(Question IS NOT NULL) AND (QuestionID IN (SELECT QuestionID FROM #QuestionIDs))
		ORDER BY Question

END
GO



PRINT 'Database updated successfully!'
GO

