-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO

IF NOT EXISTS (SELECT * FROM sys.columns WHERE Name = N'Rowversion' AND Object_ID = Object_ID (N'PM_Customer'))
	ALTER Table PM_Customer Add Rowversion timestamp
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Response_PagedDateRange')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Response_PagedDateRange] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:        Jonathan Toolan
-- Create date:    24/04/2019
-- Description:    Get a list of date ranges which contain about 500 responses each.
-- Version:        1
-- =============================================
-- JT TFS 13-128780 - Gets the relevant date portions.
-- =============================================
ALTER PROCEDURE QRY_Response_PagedDateRange
	@UserID int,
	@AssessmentTypeID int,
	@DateFrom datetime,
	@DateTo datetime
AS
BEGIN
SELECT PageNumber, count(*) 'Number', min(EndDate) 'From', max(EndDate) 'To'
FROM 
(	SELECT (ROW_NUMBER() OVER (ORDER BY EndDate DESC) - 1) / 500 as PageNumber, EndDate
	FROM QMS_Response
	WHERE EndDate BETWEEN @DateFrom AND @DateTo
	AND AssessmentTypeID = @AssessmentTypeID
) _
GROUP BY PageNumber
ORDER BY PageNumber ASC
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_ResponseHeader_FromDateRange')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_ResponseHeader_FromDateRange] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:         Jonathan Toolan
-- Create date:    24/04/2019
-- Description:    Get a list of responses of a particular type in a (small) date ranges.
-- Version:        1
-- =============================================
-- JT TFS 13-117992 - Created
-- =============================================
ALTER PROCEDURE QRY_ResponseHeader_FromDateRange
	@UserID int,
	@AssessmentTypeID int,
	@DateFrom datetime,
	@DateTo datetime
AS
BEGIN
	SELECT ResponseID, HeaderText, Header_Text --* -- Expand this list before releasing this code.
	FROM QMS_ResponseHeader header
	inner join QMS_AssessmentHeader a ON header.AssessmentHeaderID = a.AssessmentHeaderID
	WHERE header.ResponseID IN (
		SELECT list.ResponseID FROM dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) as list
		INNER JOIN QMS_Response content ON list.ResponseID = content.ResponseID
		WHERE content.AssessmentTypeID = @AssessmentTypeID
	)
END
GO


PRINT 'Database updated successfully!'
GO

