-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO

-- BEGIN DATA SCHEMA_QMS_AssessmentHeader_IsMultiCheckUnique
BEGIN TRY
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'QMS_AssessmentHeader' AND COLUMN_NAME = 'IsMultiCheckUnique')
BEGIN
	ALTER TABLE QMS_AssessmentHeader
	ADD IsMultiCheckUnique int NULL
END
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA SCHEMA_QMS_AssessmentHeader_IsMultiCheckUnique', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA SCHEMA_QMS_AssessmentHeader_IsMultiCheckUnique

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_CustomerPermissions_Any')
	EXEC('CREATE FUNCTION [dbo].[FNC_CustomerPermissions_Any]() RETURNS bit AS BEGIN RETURN 0 END')
GO
-- =============================================
-- Author:		Stu Stephenson
-- Create date: 08/05/2019
-- Description:	Function used to determine if user has any customer permissions
-- Version:		1
-- =============================================
-- SS TFS 13-123020 : Function that returns 1 if user has customer permissions or 0 if user does not have customer permissions
-- =============================================
ALTER FUNCTION [dbo].[FNC_CustomerPermissions_Any]	(@UserID int)
RETURNS int
AS
BEGIN
	DECLARE @_userID int = @UserID;
	
	RETURN 
	(
		SELECT CASE WHEN EXISTS 
		(
			SELECT UserPermissionID FROM QMS_UserPermissions
			WHERE UserID = @_userID
			AND PermissionType = 102
			AND PermissionAllow = 1
		)	THEN 1 ELSE 0 END
	)
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_FormatTimeWithUTC')
	EXEC('CREATE FUNCTION [dbo].[FNC_FormatTimeWithUTC]() RETURNS bit AS BEGIN RETURN 0 END')
GO
-- =============================================
-- Author:		Dominic Contardi
-- Create date: 08/05/2019
-- Description:	Return a formatted time with a UTC offset
-- Version:		1
-- =============================================
-- DPC TFS 127012: Return a formatted time with a UTC offset
 -- =============================================
ALTER FUNCTION [dbo].[FNC_FormatTimeWithUTC]
(
	@Datetime DATETIME,		
	@UTCOffset float
)
RETURNS NVARCHAR(20)
AS
BEGIN
	DECLARE @StringTime NVARCHAR(20)
	SET @UTCOffset = ISNULL(@UTCOffset, 0)
	IF @UTCOffset > 0
		SET @StringTime = REPLACE(dbo.FNC_FormatDateString(@Datetime, 'HH:MI (UTC+n hrs)'), 'n', @UTCOffset)
	ELSE IF @UTCOffset < 0
		SET @StringTime = REPLACE(dbo.FNC_FormatDateString(@Datetime, 'HH:MI (UTCn hrs)'), 'n', @UTCOffset)
	ELSE
		SET @StringTime = dbo.FNC_FormatDateString(@Datetime, 'HH:MI (UTC)')
	RETURN @StringTime
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_ComboSource_Country')
	EXEC ('CREATE PROCEDURE [dbo].[PM_ComboSource_Country] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================  
-- Author: Stu Stephenson  
-- Create date: 08/05/2019
-- Description: Gets a list of countries
-- Version: 2
-- =============================================  
-- SS TFS 13-123020: Created
-- SS TFS 13-123020: Converted row version to big int so that it can be compared with a big int value
-- =============================================  
ALTER PROCEDURE [dbo].[PM_ComboSource_Country]  
	@UserID int = 0,
	@TimeStamp bigint = 0,
	@PageSize int = 0,
	@DataLookupID int = NULL,
	@FirstSync bit = 0
AS
BEGIN
	-- Declare locals (avoid parameter sniffing)
	DECLARE @_userId int = @UserID;
	DECLARE @_timeStamp int = @TimeStamp;
	DECLARE @_pageSize int = @PageSize;
	DECLARE @_firstSync bit = @FirstSync;
	DECLARE @IsDeleted bit = 0

	IF (@_pageSize = 0)
	BEGIN
		SET @_pageSize = (SELECT COUNT(CountryID) FROM dbo.APP_Country);
	END
	BEGIN
		SELECT TOP (@_pageSize) WITH TIES
				@DataLookupID
					AS DataLookupID, --------------------------
				countries.CountryID
					AS ComboKey, --------------------------
				countries.CountryID
					AS SelectionKey, --------------------------
				countries.Country
					AS ComboValue, --------------------------
				CONVERT(bigint, countries.RowVersion)
					AS RowVersion, --------------------------
				@IsDeleted
					AS IsNowDeleted --------------------------
		FROM dbo.APP_Country AS countries
		WHERE 
			( -- First SYNC
				(
					@_timeStamp = 0
					OR @_firstSync = 1
				)
				AND
				(
					countries.RowVersion > @_timeStamp
				)
			)			
			OR -- Consecutive SYNC
			(
				(
					@_timeStamp > 0
					AND @_firstSync = 0
				)
				AND
				(
					countries.RowVersion > @_timeStamp
				)
			)		
		ORDER BY countries.RowVersion
	END
END
GO

--IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_ComboSource_Customer')
--	EXEC ('CREATE PROCEDURE [dbo].[PM_ComboSource_Customer] AS SELECT ''stub version, to be replaced''')
--GO
---- =============================================  
---- Author: Stu Stephenson  
---- Create date: 08/05/2019
---- Description: Gets a list of customers
---- Version: 2
---- =============================================  
---- SS TFS 13-123020: Created
---- SS TFS 13-123020: Converted row version to big int so that it can be compared with a big int value
---- =============================================  
--ALTER PROCEDURE [dbo].[PM_ComboSource_Customer]  
--	@UserID int = 0,
--	@TimeStamp bigint = 0,
--	@PageSize int = 0,
--	@DataLookupID int = NULL,
--	@FirstSync bit = 0
--AS
--BEGIN
--	-- Declare locals (avoid parameter sniffing)
--	DECLARE @_userId int = @UserID;
--	DECLARE @_timeStamp int = @TimeStamp;
--	DECLARE @_pageSize int = @PageSize;
--	DECLARE @_firstSync bit = @FirstSync;

--	DECLARE @anyCustomerPermissions bit = dbo.FNC_CustomerPermissions_Any(@_userId);

--	IF (@_pageSize = 0)
--	BEGIN
--		SET @_pageSize = (SELECT COUNT(CustomerID) FROM dbo.PM_VW_Customer);
--	END

--	-- All customers permitted ----------------------------------------------------------------------------------------
--	IF (@anyCustomerPermissions = 0)
--	BEGIN
--		SELECT	TOP (@_pageSize) WITH TIES
--				@DataLookupID
--					AS DataLookupID, --------------------------
--				customers.CustomerID
--					AS ComboKey, --------------------------
--				customers.CustomerID
--					AS SelectionKey, --------------------------
--				CASE WHEN
--				(
--					customers.RecordStatus < 201
--					AND customers.Hide = 0
--				)
--				THEN customers.CustomerName
--				ELSE NULL END
--					AS ComboValue, --------------------------
--				CONVERT(bigint, customers.RowVersion)
--					AS RowVersion, --------------------------
--				CAST
--				(
--					(
--						CASE WHEN
--						(
--							customers.RecordStatus > 200
--							OR customers.Hide = 1
--						)
--						THEN 1
--						ELSE 0 END
--					)
--					AS bit
--				) AS IsNowDeleted --------------------------
--		FROM dbo.PM_Customer AS customers
--		WHERE
--			( -- First SYNC
--				(
--					@_timeStamp = 0
--					OR @_firstSync = 1
--				)
--				AND
--				(
--					customers.RecordStatus < 201
--					AND customers.Hide = 0
--				)
--				AND
--				(
--					customers.RowVersion > @_timeStamp
--				)
--			)			
--			OR -- Consecutive SYNC
--			(
--				(
--					@_timeStamp > 0
--					AND @_firstSync = 0
--				)
--				AND
--				(
--					customers.RowVersion > @_timeStamp
--				)
--			)		
--		ORDER BY customers.RowVersion
--	END

--	-- Has customer permissions set ----------------------------------------------------------------------------------------
--	ELSE
--	BEGIN
--		SELECT	TOP (@_pageSize) WITH TIES
--				@DataLookupID
--					AS DataLookupID, --------------------------
--				customers.CustomerID
--					AS ComboKey, --------------------------
--				customers.CustomerID
--					AS SelectionKey, --------------------------
--				CASE WHEN
--				(
--					customers.RecordStatus < 201
--					AND customers.Hide = 0
--					AND customerPermission.PermissionAllow = 1
--				)
--				THEN customers.CustomerName
--				ELSE NULL END
--					AS ComboValue, --------------------------
--				dbo.FNC_GreatestBigInt
--				(
--					customers.RowVersion,
--					customerPermission.RowVersion
--				) AS RowVersion, --------------------------
--				CAST
--				(
--					(
--						CASE WHEN
--						(
--							customers.RecordStatus > 200
--							OR customers.Hide = 1
--							OR customerPermission.PermissionAllow = 0
--						)
--						THEN 1
--						ELSE 0 END
--					)
--					AS bit
--				) AS IsNowDeleted --------------------------
--		FROM dbo.PM_Customer AS customers
--		INNER JOIN dbo.QMS_UserPermissions as customerPermission -- PERMISSION (customer)
--			ON customerPermission.PermissionType = 102
--				AND customerPermission.UserID = @_userId
--				AND customerPermission.PermissionTitle = customers.CustomerID
--		WHERE 
--			( -- First SYNC
--				(
--					@_timeStamp = 0
--					OR @_firstSync = 1
--				)
--				AND
--				(
--					customers.RecordStatus < 201
--					AND customers.Hide = 0
--					AND customerPermission.PermissionAllow = 1
--				)
--				AND
--				(
--					customers.RowVersion > @_timeStamp
--					OR customerPermission.RowVersion > @_timeStamp
--				)
--			)
--			OR -- Consecutive SYNC
--			(
--				(
--					@_timeStamp > 0
--					AND @_firstSync = 0
--				)
--				AND
--				(
--					customers.RowVersion > @_timeStamp
--					AND customerPermission.RowVersion > @_timeStamp
--				)
--			)				
--		ORDER BY dbo.FNC_GreatestBigInt(customers.RowVersion, customerPermission.RowVersion)
--	END
--END
--GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_AssessmentHeader_List')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_AssessmentHeader_List] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 15/07/2008
-- Description:	Get the header information for specified type
-- Version:		3
-- =============================================
-- JE TFS 6559 - added VariableItem and Allow Copy cols
-- JF TFS 127522 - added IsMultiCheckUnique
-- =============================================
ALTER PROCEDURE [dbo].[QRY_AssessmentHeader_List] 
	@AssessmentTypeID int,
	@AssessmentID int = NULL
AS

SELECT     QMS_AssessmentHeader.AssessmentHeaderID, QMS_AssessmentHeader.HeaderText, QMS_AssessmentHeader.DataTypeID, 
                      QMS_AssessmentHeader.DataLookupID, APP_DataLookup.SourceObjectColumn, QMS_AssessmentHeader.CustomLookupID, 
                      QMS_AssessmentHeader.ResponseRequired, APP_DataLookup.DataTypeID AS Lookup_DataTypeID, QMS_AssessmentHeader.ClearForNewCheck, 
                      APP_DataLookup.IsCombo, QMS_AssessmentHeader.AllowMultiSelect, QMS_AssessmentHeader.AllowEdit, QMS_AssessmentHeader.VariableItem,
                      QMS_AssessmentHeader.AllowCopy
					  , QMS_AssessmentHeader.IsMultiCheckUnique
FROM         QMS_AssessmentHeader LEFT OUTER JOIN
                      APP_DataLookup ON QMS_AssessmentHeader.DataLookupID = APP_DataLookup.DataLookupID
WHERE     (QMS_AssessmentHeader.AssessmentTypeID = @AssessmentTypeID) AND (QMS_AssessmentHeader.RecordStatus < 201) AND 
                      (QMS_AssessmentHeader.Hide = 0) AND (@AssessmentID IS NULL) AND (QMS_AssessmentHeader.AssessmentID IS NULL) OR
                      (QMS_AssessmentHeader.AssessmentTypeID = @AssessmentTypeID) AND (QMS_AssessmentHeader.RecordStatus < 201) AND 
                      (QMS_AssessmentHeader.Hide = 0) AND (@AssessmentID IS NOT NULL) AND (QMS_AssessmentHeader.AssessmentID = @AssessmentID)
ORDER BY QMS_AssessmentHeader.ListIndex, QMS_AssessmentHeader.HeaderText
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_AssessmentHeader_VariableList')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_AssessmentHeader_VariableList] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jon Edwards
-- Create date: 03/04/2013
-- Description:	Gets variable header info for specified type (used for Multi checks)
-- Version:		3
-- =============================================
-- JE TFS 6292 - added AllowCopy column
-- TS TFS 26601 - added MustMatchParent column
-- JF TFS 127522 - added IsMultiCheckUnique
-- =============================================
ALTER PROCEDURE [dbo].[QRY_AssessmentHeader_VariableList]
	@AssessmentTypeID int
AS
BEGIN
	SELECT	'QMS_AssessmentHeader' AS DataSource, QMS_AssessmentHeader.AssessmentHeaderID AS AssessmentSourceID,
				CAST(QMS_AssessmentHeader.ListIndex AS nvarchar(20)) AS SortNumber, QMS_AssessmentHeader.HeaderText AS AttributeText,
				QMS_AssessmentHeader.DataTypeID, QMS_AssessmentHeader.DataLookupID, APP_DataLookup.SourceObjectColumn,
				QMS_AssessmentHeader.CustomLookupID, QMS_AssessmentHeader.ResponseRequired, APP_DataLookup.DataTypeID AS Lookup_DataTypeID,
				QMS_AssessmentHeader.ClearForNewCheck, APP_DataLookup.IsCombo, QMS_AssessmentHeader.AllowEdit, QMS_AssessmentHeader.AllowCopy, QMS_AssessmentHeader.MustMatchParent
				,QMS_AssessmentHeader.IsMultiCheckUnique
	FROM	QMS_AssessmentHeader LEFT OUTER JOIN
				APP_DataLookup ON QMS_AssessmentHeader.DataLookupID = APP_DataLookup.DataLookupID
	WHERE	(QMS_AssessmentHeader.AssessmentTypeID = @AssessmentTypeID) AND (QMS_AssessmentHeader.RecordStatus < 201) AND 
				(QMS_AssessmentHeader.Hide = 0) AND (QMS_AssessmentHeader.AssessmentID IS NULL) AND (VariableItem = 1)
	ORDER BY QMS_AssessmentHeader.ListIndex, QMS_AssessmentHeader.HeaderText
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_Response_Response')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_Response_Response] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 11/09/2008
-- Description:	gets response items for response report
-- Version:		8
-- =============================================
-- J.Toolan 22/3/2012: Added FilterApplied flag to indicate that a report filter
--					   is in place and should be honoured
-- JE TFS 3916 - added QA Flag Back/Fore colour columns
-- JE TFS 8287 - changed join to APP_QAFlag to LEFT so checks with no flag will still be included in report
-- JE TFS 13-6542: added AppID to main query output
-- JT TFS 13-11338: Change ActualQAFlag for reporting purposes if APP_Config option set.
-- DPC TFS 127012: Include time in Date Assessed field if APP_Config option set
-- =============================================
ALTER PROCEDURE [dbo].[RPT_Response_Response]
	@UserID int,
	@ShowCA bit = 0,
	@ShowGuidance bit = 0,
	@FilterApplied bit = 0, -- If set, query checks TEMP_ResponseFilter
	@AppID int = 0 --only set when alerts service is creating report (AppID = 4)
AS
BEGIN
	SET NOCOUNT ON
	--set Override QAFlag option
	DECLARE @OverrideQAFlag bit
	SET @OverrideQAFlag = CAST(ISNULL(dbo.FNC_GetOptionValue(74),0) AS bit)

	-- Set ShowTimeCompleted option
	DECLARE @ShowTimeCompleted bit = CAST(ISNULL(dbo.FNC_GetOptionValue(165),0) AS bit)

	--create temp table of QA Flag values to join on in main query
	IF nullif(object_id('tempdb..#tmpQAFlag'), 0) IS NOT NULL DROP TABLE #tmpQAFlag
	SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag,
			QAFlagBackColour, QAFlagForeColour
	INTO #tmpQAFlag
	FROM         APP_QAFlag

	SET NOCOUNT OFF

	SELECT	QMS_Response.ResponseID, QMS_Assessment.AssessmentName, QMS_Assessment.Version, QMS_Response.AssessmentTypeID, APP_AssessmentType.AssessmentType,
			QMS_Response.StartDate, QMS_Response.EndDate,
			CASE
				WHEN @ShowTimeCompleted = 1 THEN dbo.FNC_FormatTimeWithUTC(QMS_Response.EndDate, QMS_Response.UTCOffset)
				ELSE ''
			END AS EndTime, 
			QMS_Response.Comments, QMS_Response.Recommended_Score, QMS_Response.Recommended_QAFlagID, QMS_Response.Actual_Score, 
			QAFlag.QAFlagID AS Actual_QAFlagID, 
			QAFlag.QAFlag AS Actual_QAFlag, 
			QMS_User.FullName, QMS_User.EMail AS AssessorEmail, QMS_Response.Override_QAFlagID, 
			QAFlag_Override.QAFlag AS Override_QAFlag, @ShowCA AS ShowCA, CorrectiveAction.CATitle, CorrectiveAction.CAReason, CorrectiveAction.CARequired, CorrectiveAction.CAStatus, 
			CorrectiveAction.NotificationGroup, CorrectiveAction.PriorityLevel, CorrectiveAction.DateDeadline, @ShowGuidance AS ShowGuidance, QMS_Response.QuantityReceived, 
			QMS_Response.QuantityChecked, QMS_Response.QuantityAccepted, QMS_Response.QuantityRejected, ISNULL(dbo.FNC_GetOptionValue(15), N'0') AS HideQAScore, 
			QMS_Response.QuantityReplaced, QAFlag.QAFlagBackColour, QAFlag.QAFlagForeColour, @AppID AS AppID
	FROM         QMS_Assessment 
	INNER JOIN	QMS_Response ON QMS_Assessment.AssessmentID = QMS_Response.AssessmentID 
	INNER JOIN	TEMP_Selected ON QMS_Response.ResponseID = TEMP_Selected.SelectedID 
	INNER JOIN	APP_AssessmentType ON QMS_Response.AssessmentTypeID = APP_AssessmentType.AssessmentTypeID 
	LEFT OUTER JOIN	#tmpQAFlag AS QAFlag ON CASE WHEN @OverrideQAFlag = 0 THEN Actual_QAFlagID ELSE ISNULL(QMS_Response.Override_QAFlagID, QMS_Response.Actual_QAFlagID) END = QAFlag.QAFlagID 
	LEFT OUTER JOIN	#tmpQAFlag AS QAFlag_Override ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID 
	LEFT OUTER JOIN    (SELECT     QMS_CorrectiveAction.SourceObjectID AS ResponseID, QMS_CorrectiveAction.CATitle, QMS_CorrectiveAction.CAReason, QMS_CorrectiveAction.CARequired, 
													   APP_CorrectiveActionStatus.CAStatus, QMS_NotificationGroup.NotificationGroup, APP_PriorityLevel.PriorityLevel, QMS_CorrectiveAction.DateDeadline
								FROM          QMS_CorrectiveAction INNER JOIN
													   APP_CorrectiveActionStatus ON QMS_CorrectiveAction.CAStatusID = APP_CorrectiveActionStatus.CAStatusID LEFT OUTER JOIN
													   APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID LEFT OUTER JOIN
													   QMS_NotificationGroup ON QMS_CorrectiveAction.NotificationGroupID = QMS_NotificationGroup.NotificationGroupID
								WHERE      (QMS_CorrectiveAction.CASourceID = 1) AND (QMS_CorrectiveAction.RecordStatus < 201)) AS CorrectiveAction ON 
						  QMS_Response.ResponseID = CorrectiveAction.ResponseID 
	LEFT OUTER JOIN	QMS_User ON QMS_Response.UserID = QMS_User.UserID 
	WHERE     (TEMP_Selected.UserID = @UserID) AND (@FilterApplied = 0) OR
						  (TEMP_Selected.UserID = @UserID) AND (QMS_Response.ResponseID IN
							  (SELECT     ResponseID
								FROM          TEMP_ResponseFilter
								WHERE      (UserID = @UserID)))
	ORDER BY QMS_Response.StartDate, QMS_Assessment.AssessmentName

END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_AssessmentHeader')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_AssessmentHeader] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jonathan Toolan
-- Create date: Unknown
-- Description:	Imports an assessment header from web service data into mobile.
-- Version:		3
-- =============================================
-- JF TFS 127522 - added IsMultiCheckUnique
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_AssessmentHeader] 
	@AssessmentHeaderID int,
	@AssessmentTypeID int,
	@AssessmentID int,
	@HeaderText nvarchar(50),
	@DataTypeID int,
	@DataLookupID int,
	@CustomLookupID int,
	@ListIndex int,	
	@ResponseRequired bit,
	@Hide bit,
	@ClearForNewCheck bit,
	@HideFromReports bit,
	@AllowMultiSelect bit,
	@AllowEdit bit,
	@MatchRepeatCheck bit = 0,
	@AllowCopy bit = 0,
	@VariableItem BIT = NULL,
	@MustMatchParent bit = 0,
	@UserID int,
	@MachineName nvarchar(255),
	@RecordStatus tinyint,
	@Inserted datetime,
	@Updated datetime,
	@Deleted datetime,
	@GUID uniqueidentifier,
	@Created bigint,
	@IsMultiCheckUnique int = null,
	@RowVersion timestamp,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

IF @VariableItem IS NULL
	SET @VariableItem = 0

IF NOT EXISTS(SELECT AssessmentHeaderID FROM QMS_AssessmentHeader WHERE (AssessmentHeaderID = @AssessmentHeaderID))
BEGIN --Append record
	IF @RecordStatus < 201
	BEGIN
		SET IDENTITY_INSERT QMS_AssessmentHeader ON
		INSERT INTO QMS_AssessmentHeader (
				AssessmentHeaderID, AssessmentTypeID, AssessmentID, HeaderText, DataTypeID, DataLookupID, CustomLookupID, ListIndex, ResponseRequired, Hide, 
                ClearForNewCheck, HideFromReports, AllowMultiSelect, AllowEdit, MatchRepeatCheck, AllowCopy, VariableItem, 
				MustMatchParent,
				UserID, MachineName, RecordStatus, Inserted, 
                Updated, Deleted, GUID, IsMultiCheckUnique)
		VALUES     (	@AssessmentHeaderID,@AssessmentTypeID,@AssessmentID,@HeaderText,@DataTypeID,@DataLookupID,@CustomLookupID,@ListIndex,@ResponseRequired,@Hide,
						@ClearForNewCheck,@HideFromReports,@AllowMultiSelect,@AllowEdit,@MatchRepeatCheck,@AllowCopy,@VariableItem,
						@MustMatchParent,
						@UserID,@MachineName,@RecordStatus,@Inserted,@Updated,@Deleted,@GUID,@IsMultiCheckUnique)
		SET @InsertCount = @@rowcount
		SET IDENTITY_INSERT QMS_AssessmentHeader OFF
	END
END

ELSE
BEGIN --Update record
	UPDATE    QMS_AssessmentHeader
	SET              AssessmentTypeID = @AssessmentTypeID, AssessmentID = @AssessmentID, HeaderText = @HeaderText, DataTypeID = @DataTypeID, 
                      DataLookupID = @DataLookupID, CustomLookupID = @CustomLookupID, ListIndex = @ListIndex, ResponseRequired = @ResponseRequired, Hide = @Hide, 
                      ClearForNewCheck = @ClearForNewCheck, HideFromReports = @HideFromReports, AllowMultiSelect = @AllowMultiSelect, AllowEdit = @AllowEdit, 
                      MatchRepeatCheck = @MatchRepeatCheck, AllowCopy = @AllowCopy, VariableItem = @VariableItem, MustMatchParent = @MustMatchParent,
					  UserID = @UserID, MachineName = @MachineName, 
                      RecordStatus = @RecordStatus, Inserted = @Inserted, Updated = @Updated, Deleted = @Deleted
					  ,IsMultiCheckUnique=@IsMultiCheckUnique
	WHERE     (AssessmentHeaderID = @AssessmentHeaderID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Download_AssessmentHeader')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Download_AssessmentHeader] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 11/12/2008
-- Description:	Gets data to download for QMS_AssessmentHeader table
-- Version:		4
-- =============================================
-- JE TFS 7396 - added extra params for Sync process improvements
-- TS TFS 26601 - MustMtachPatient column added to query
-- JF TFS 127522 - added IsMultiCheckUnique
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Download_AssessmentHeader] 
	@LastReceived bigint,
	@GetRecordCountOnly bit = 0,
	@TotalRecordCount int OUTPUT
AS

SET @TotalRecordCount = (SELECT	COUNT(AssessmentHeaderID)
									FROM         QMS_AssessmentHeader
									WHERE     (RowVersion > @LastReceived) OR
														  (Created > @LastReceived) AND (RecordStatus < 201))

IF @GetRecordCountOnly = 0
	BEGIN
		SELECT        AssessmentHeaderID, AssessmentTypeID, AssessmentID, HeaderText, DataTypeID, DataLookupID, CustomLookupID, ListIndex, ResponseRequired, ClearForNewCheck, HideFromReports, AllowMultiSelect, 
                         AllowEdit, MatchRepeatCheck, AllowCopy, VariableItem, Hide, UserID, MachineName, RecordStatus, Inserted, Updated, Deleted, GUID, RowVersion, Created, MustMatchParent, IsMultiCheckUnique
FROM            QMS_AssessmentHeader
		WHERE     (RowVersion > @LastReceived) OR
							  (Created > @LastReceived) AND (RecordStatus < 201)
	END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_Response_Response')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_Response_Response] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 11/09/2008
-- Description:	gets response items for response report
-- Version:		8
-- =============================================
-- J.Toolan 22/3/2012: Added FilterApplied flag to indicate that a report filter
--					   is in place and should be honoured
-- JE TFS 3916 - added QA Flag Back/Fore colour columns
-- JE TFS 8287 - changed join to APP_QAFlag to LEFT so checks with no flag will still be included in report
-- JE TFS 13-6542: added AppID to main query output
-- JT TFS 13-11338: Change ActualQAFlag for reporting purposes if APP_Config option set.
-- DPC TFS 127012: Include time in Date Assessed field if APP_Config option set
-- DPC TFS 86715: Include flags to indicate if Quantities Accepted, Rejected and Replaced should appear on check report
-- =============================================
ALTER PROCEDURE [dbo].[RPT_Response_Response]
	@UserID int,
	@ShowCA bit = 0,
	@ShowGuidance bit = 0,
	@FilterApplied bit = 0, -- If set, query checks TEMP_ResponseFilter
	@AppID int = 0 --only set when alerts service is creating report (AppID = 4)
AS
BEGIN
	SET NOCOUNT ON

	-- SupressBlankResponses option
	DECLARE @SupressBlankResponses bit = CAST(ISNULL(dbo.FNC_GetOptionValue(36),0) AS bit)

	--set Override QAFlag option
	DECLARE @OverrideQAFlag bit = CAST(ISNULL(dbo.FNC_GetOptionValue(74),0) AS bit)

	-- Set ShowTimeCompleted option
	DECLARE @ShowTimeCompleted bit = CAST(ISNULL(dbo.FNC_GetOptionValue(165),0) AS bit)

	-- ShowQuantityAcceptedRejectedReplaced option
	DECLARE @ShowQuantityAcceptedRejectedReplaced bit = CAST(ISNULL(dbo.FNC_GetOptionValue(166),0) AS bit)

	--create temp table of QA Flag values to join on in main query
	IF nullif(object_id('tempdb..#tmpQAFlag'), 0) IS NOT NULL DROP TABLE #tmpQAFlag
	SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag,
			QAFlagBackColour, QAFlagForeColour
	INTO #tmpQAFlag
	FROM         APP_QAFlag

	SET NOCOUNT OFF

	SELECT	QMS_Response.ResponseID, QMS_Assessment.AssessmentName, QMS_Assessment.Version, QMS_Response.AssessmentTypeID, APP_AssessmentType.AssessmentType,
			QMS_Response.StartDate, QMS_Response.EndDate,
			CASE
				WHEN @ShowTimeCompleted = 1 THEN dbo.FNC_FormatTimeWithUTC(QMS_Response.EndDate, QMS_Response.UTCOffset)
				ELSE ''
			END AS EndTime, 
			QMS_Response.Comments, QMS_Response.Recommended_Score, QMS_Response.Recommended_QAFlagID, QMS_Response.Actual_Score, 
			QAFlag.QAFlagID AS Actual_QAFlagID, 
			QAFlag.QAFlag AS Actual_QAFlag, 
			QMS_User.FullName, QMS_User.EMail AS AssessorEmail, QMS_Response.Override_QAFlagID, 
			QAFlag_Override.QAFlag AS Override_QAFlag, @ShowCA AS ShowCA, CorrectiveAction.CATitle, CorrectiveAction.CAReason, CorrectiveAction.CARequired, CorrectiveAction.CAStatus, 
			CorrectiveAction.NotificationGroup, CorrectiveAction.PriorityLevel, CorrectiveAction.DateDeadline, @ShowGuidance AS ShowGuidance, QMS_Response.QuantityReceived, 
			QMS_Response.QuantityChecked, QMS_Response.QuantityAccepted, QMS_Response.QuantityRejected, ISNULL(dbo.FNC_GetOptionValue(15), N'0') AS HideQAScore, 
			QMS_Response.QuantityReplaced, QAFlag.QAFlagBackColour, QAFlag.QAFlagForeColour, @AppID AS AppID,			
			CAST(
				CASE
					WHEN @ShowQuantityAcceptedRejectedReplaced = 1 THEN dbo.FNC_Response_HasQuantityCheckedHeader(QMS_Response.ResponseID)
					ELSE 0
				END
			AS bit) AS ShowQuantityAcceptedRejectedReplaced,
			@SupressBlankResponses AS SupressBlankResponses
	FROM         QMS_Assessment 
	INNER JOIN	QMS_Response ON QMS_Assessment.AssessmentID = QMS_Response.AssessmentID 
	INNER JOIN	TEMP_Selected ON QMS_Response.ResponseID = TEMP_Selected.SelectedID 
	INNER JOIN	APP_AssessmentType ON QMS_Response.AssessmentTypeID = APP_AssessmentType.AssessmentTypeID 
	LEFT OUTER JOIN	#tmpQAFlag AS QAFlag ON CASE WHEN @OverrideQAFlag = 0 THEN Actual_QAFlagID ELSE ISNULL(QMS_Response.Override_QAFlagID, QMS_Response.Actual_QAFlagID) END = QAFlag.QAFlagID 
	LEFT OUTER JOIN	#tmpQAFlag AS QAFlag_Override ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID 
	LEFT OUTER JOIN    (SELECT     QMS_CorrectiveAction.SourceObjectID AS ResponseID, QMS_CorrectiveAction.CATitle, QMS_CorrectiveAction.CAReason, QMS_CorrectiveAction.CARequired, 
													   APP_CorrectiveActionStatus.CAStatus, QMS_NotificationGroup.NotificationGroup, APP_PriorityLevel.PriorityLevel, QMS_CorrectiveAction.DateDeadline
								FROM          QMS_CorrectiveAction INNER JOIN
													   APP_CorrectiveActionStatus ON QMS_CorrectiveAction.CAStatusID = APP_CorrectiveActionStatus.CAStatusID LEFT OUTER JOIN
													   APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID LEFT OUTER JOIN
													   QMS_NotificationGroup ON QMS_CorrectiveAction.NotificationGroupID = QMS_NotificationGroup.NotificationGroupID
								WHERE      (QMS_CorrectiveAction.CASourceID = 1) AND (QMS_CorrectiveAction.RecordStatus < 201)) AS CorrectiveAction ON 
						  QMS_Response.ResponseID = CorrectiveAction.ResponseID 
	LEFT OUTER JOIN	QMS_User ON QMS_Response.UserID = QMS_User.UserID 
	WHERE     (TEMP_Selected.UserID = @UserID) AND (@FilterApplied = 0) OR
						  (TEMP_Selected.UserID = @UserID) AND (QMS_Response.ResponseID IN
							  (SELECT     ResponseID
								FROM          TEMP_ResponseFilter
								WHERE      (UserID = @UserID)))
	ORDER BY QMS_Response.StartDate, QMS_Assessment.AssessmentName

END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_Response_HasQuantityCheckedHeader')
	EXEC('CREATE FUNCTION [dbo].[FNC_Response_HasQuantityCheckedHeader]() RETURNS bit AS BEGIN RETURN 0 END')
GO
-- =============================================
-- Author:		Dominic Contardi
-- Create date: 15/05/2019
-- Description:	Returns true if a check has a Quantity Checked header
-- Version:		1
-- =============================================
-- Returns true if a check has a Quantity Checked header
-- =============================================

ALTER FUNCTION FNC_Response_HasQuantityCheckedHeader
(
	@ResponseID int
)
RETURNS bit
AS
BEGIN
	RETURN (SELECT CASE WHEN COUNT(*) > 0 THEN 1 ELSE 0 END
	FROM QMS_ResponseHeader
	WHERE ResponseID = @ResponseID
	AND AssessmentHeaderID IN
		(SELECT AssessmentHeaderID FROM QMS_AssessmentHeader WHERE DataLookupID = 18 AND RecordStatus < 201))
END
GO


PRINT 'Database updated successfully!'
GO

