-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_BarcodeFormat')
	EXEC('CREATE FUNCTION [dbo].[FNC_BarcodeFormat]() RETURNS bit AS BEGIN RETURN 0 END')
GO
-- =============================================
-- Author:		JMF
-- Create date: 13/08/2018
-- Description:	Formats the barcode scanned in
-- version: 2
-- =============================================
-- jf TFS 104066 
-- =============================================
ALTER FUNCTION [dbo].[FNC_BarcodeFormat] 
(
	@Barcode nvarchar(50)
)
RETURNS nvarchar(50)
AS
BEGIN
	--select dbo.FNC_BarcodeFormat('1234567890123456781234')
	SET @Barcode = REPLACE(@Barcode,' ','')

	IF dbo.FNC_GetOptionValue(157) = 'EAN128' -- https://en.wikipedia.org/wiki/GS1-128


	BEGIN 
		SET @Barcode = REPLACE(@Barcode,'(','')
		SET @Barcode = REPLACE(@Barcode,')','')
		DECLARE @BarcodeDataLength int

		SELECT @BarcodeDataLength=18 --default for now

		IF LEN(@Barcode)>3
		BEGIN
			IF LEFT(@Barcode,3) = ']C1' --defines EAN128 barcode. Strip it out. May not be present if manually entered
				SET @Barcode = SUBSTRING(@Barcode,4,LEN(@Barcode)-3)
			
			--the next 2 digits specify barcode type and length. 00 = 18 characters of data but again, may not be present if manually entered 
			IF LEFT(@Barcode,2) = '00' and LEN(@Barcode)>=20 
				BEGIN
					SELECT @BarcodeDataLength = 18
					SET @Barcode = SUBSTRING(@Barcode,3,LEN(@Barcode)-2)
				END
			
			--code below not yet required to be supported
			--else IF LEFT(@Barcode,2) in ('01','02' ) and LEN(@Barcode)>=16 and LEN(@Barcode)<18 
			--	BEGIN
			--		SELECT @BarcodeDataLength = 14
			--		SET @Barcode = SUBSTRING(@Barcode,3,LEN(@Barcode)-2)
			--	END
			--else IF LEFT(@Barcode,2) in ('11','12','13','15','17' )  and LEN(@Barcode)>=8 and LEN(@Barcode)<14 
			--	BEGIN
			--		SELECT @BarcodeDataLength = 6
			--		SET @Barcode = SUBSTRING(@Barcode,3,LEN(@Barcode)-2)
			--	END

			IF len(@Barcode) > @BarcodeDataLength
				SET @Barcode = SUBSTRING(@Barcode,1,@BarcodeDataLength)
		END
	END
	
	RETURN @Barcode

END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_SupplierRef_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_SupplierRef_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 17/11/2008
-- Description:	Gets lookup of Supplier Ref used (AWB for Flamingo)
-- version:	4
-- =============================================
-- JF TFS 74073 - allow supplier ref to be picked up from goods intake barcode
-- MDS TFS 82742 - don't allow DateArrived parameter to be used if filter is not enabled
-- JF TFS 104066 GYFD - Allow Header To Work with Barcode Prefix
-- =============================================

ALTER PROCEDURE [dbo].[PM_QRY_SupplierRef_Combo] 
	@SupplierID int = 0,
	@DateArrived datetime = NULL,
	@Barcode nvarchar(50) = null
AS

if @Barcode IS NOT NULL and (SELECT Enabled FROM dbo.APP_DataLookupTrigger WHERE DataLookupID_Trigger = 11 AND DataLookupID_Update = 15) = 1
	SELECT    SupplierRef 
	FROM         dbo.PM_VW_Goodsintake 
	WHERE PM_VW_Goodsintake.Barcode =  dbo.FNC_BarcodeFormat(@Barcode)

else IF (@DateArrived IS NULL or 
		(@DateArrived IS NOT NULL and (SELECT Enabled FROM dbo.APP_DataLookupTrigger WHERE DataLookupID_Trigger = 11 AND DataLookupID_Update = 15) = 0))
	SELECT DISTINCT SupplierRef 
	FROM         dbo.PM_VW_GoodsIntake
	WHERE     (SupplierRef IS NOT NULL) AND (@SupplierID <= 0) OR
						  (SupplierRef IS NOT NULL) AND (@SupplierID > 0) AND (SupplierID = @SupplierID)
	ORDER BY SupplierRef

ELSE
	SELECT DISTINCT SupplierRef
	FROM         dbo.PM_VW_GoodsIntake
	WHERE     (SupplierRef IS NOT NULL) AND (@SupplierID <= 0) AND (dbo.FNC_TrimDate(DateArrived) = dbo.FNC_TrimDate(@DateArrived)) OR
						  (SupplierRef IS NOT NULL) AND (@SupplierID > 0) AND (SupplierID = @SupplierID) AND (dbo.FNC_TrimDate(DateArrived) 
						  = dbo.FNC_TrimDate(@DateArrived))
	ORDER BY SupplierRef
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_SupplierLotNo_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_SupplierLotNo_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 13/05/2009
-- Description:	Gets lookup of Supplier Lot no
-- version:2
-- =============================================
-- JF TFS 104066 GYFD - Allow Header To Work with Barcode Prefix
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_SupplierLotNo_Combo] 
	@Barcode nvarchar(50) = NULL
AS

DECLARE @GoodsIntakeID int
SELECT     @GoodsIntakeID = GoodsIntakeID
FROM         PM_VW_GoodsIntake
WHERE     (Barcode =  dbo.FNC_BarcodeFormat(@Barcode))

IF @GoodsIntakeID IS NOT NULL
	SELECT DISTINCT SupplierLotNo
	FROM         PM_VW_GoodsIntake
	WHERE     (SupplierLotNo IS NOT NULL) AND (GoodsIntakeID = @GoodsIntakeID)
	ORDER BY SupplierLotNo
	
ELSE
	SELECT DISTINCT SupplierLotNo
	FROM         PM_VW_GoodsIntake
	WHERE     (SupplierLotNo IS NOT NULL)
	ORDER BY SupplierLotNo
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Supplier_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Supplier_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: Markp
-- Create date	: 16/07/2008
-- Description	: Gets list of suppliers
-- Version		: 7
-- =============================================
-- JE TFS 3176: added AssessmentType param to check if we should hide hidden suppliers or not
-- JE TFS 13-2214: added check that DateArrived trigger is enabled before applying filter
-- PH TFS 13-41690: added IsInactive for showing hidden suppliers in red.
-- JF TFS 74073 - allow supplier to be picked up from goods intake supplier or PO data 
-- JF TFS 80479 - allow suppliers to be filtered from PO
-- JF TFS 104066 GYFD - Allow Header To Work with Barcode Prefix
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_Supplier_Combo] 
	@DateArrived datetime = NULL,
	@CaseEndBarcode nvarchar(100) = NULL,
	@UserID int = NULL,
	@AssessmentTypeID int = NULL,
	@Barcode nvarchar(50) = null,
	@ConsignmentID int = null
AS

--exec PM_QRY_Supplier_Combo null,null,1,10,null,164

IF @CaseEndBarcode IS NOT NULL --combo being accessed from an assessment, so hide hidden suppliers
	SELECT     SupplierID, SupplierName, Hide AS IsInactive
	FROM         dbo.PM_VW_Supplier
	WHERE     (SupplierID = dbo.FNC_CaseEndToSupplier(@CaseEndBarcode)) AND (Hide = 0)
	ORDER BY SupplierName

ELSE
BEGIN
	IF @DateArrived IS NULL OR (SELECT Enabled FROM APP_DataLookupTrigger WHERE DataLookupID_Trigger = 16 AND DataLookupID_Update = 1) = 0
	--DateArrived trigger disabled
	BEGIN
		IF @UserID IS NULL --combo not being accessed from an assessment, so show all suppliers
			SELECT     SupplierID, SupplierName, Hide AS IsInactive
			FROM         dbo.PM_VW_Supplier
			ORDER BY SupplierName
		ELSE IF @AssessmentTypeID IS NOT NULL --combo being accessed from an assessment, so hide hidden suppliers
			IF @Barcode IS NULL OR (SELECT Enabled FROM APP_DataLookupTrigger WHERE DataLookupID_Trigger = 11 AND DataLookupID_Update = 1) = 0
				
				IF @ConsignmentId IS NULL OR (SELECT Enabled FROM APP_DataLookupTrigger WHERE DataLookupID_Trigger = 5 AND DataLookupID_Update = 1) = 0
					SELECT     PM_VW_Supplier.SupplierID, PM_VW_Supplier.SupplierName, PM_VW_Supplier.Hide AS IsInactive
					FROM         dbo.PM_VW_Supplier INNER JOIN
										  dbo.FNC_User_SupplierList(@UserID) AS User_SupplierList ON PM_VW_Supplier.SupplierID = User_SupplierList.SupplierID
					WHERE (Hide = 0)
					ORDER BY PM_VW_Supplier.SupplierName
				else
					--get the list of suppliers from the PO
					SELECT     PM_VW_Supplier.SupplierID, PM_VW_Supplier.SupplierName, PM_VW_Supplier.Hide AS IsInactive
					FROM         dbo.PM_VW_Supplier INNER JOIN
										  dbo.FNC_User_SupplierList(@UserID) AS User_SupplierList ON PM_VW_Supplier.SupplierID = User_SupplierList.SupplierID
										  INNER JOIN PM_VW_Consignment on PM_VW_Consignment.supplierid = PM_VW_Supplier.SupplierID 
					WHERE (PM_VW_Supplier.Hide = 0) and PM_VW_Consignment.ConsignmentID = @ConsignmentID
					ORDER BY PM_VW_Supplier.SupplierName

			else
				--Either get the supplier from the PM_Consignment.SupplierID or GoodsIntake.SupplierID
				IF EXISTS(SELECT SupplierID FROM PM_VW_Goodsintake WHERE Barcode = dbo.FNC_BarcodeFormat(@Barcode) and SupplierID IS NOT NULL)
					SELECT     PM_VW_Supplier.SupplierID, PM_VW_Supplier.SupplierName, PM_VW_Supplier.Hide AS IsInactive
					FROM         dbo.PM_VW_Supplier INNER JOIN
						dbo.PM_vw_goodsintake ON dbo.PM_vw_goodsintake.supplierid = PM_VW_Supplier.SupplierID
						inner join dbo.FNC_User_SupplierList(@UserID) AS User_SupplierList ON PM_VW_Supplier.SupplierID = User_SupplierList.SupplierID
					WHERE (Hide = 0) and PM_vw_goodsintake.barcode = dbo.FNC_BarcodeFormat(@Barcode)
					ORDER BY PM_VW_Supplier.SupplierName
				ELSE
					SELECT     PM_VW_Supplier.SupplierID, PM_VW_Supplier.SupplierName, PM_VW_Supplier.Hide AS IsInactive
					FROM         dbo.PM_VW_Supplier INNER JOIN
										  dbo.FNC_User_SupplierList(@UserID) AS User_SupplierList ON PM_VW_Supplier.SupplierID = User_SupplierList.SupplierID
										  inner join dbo.PM_vw_Consignment  on pm_vw_consignment.supplierid = PM_VW_Supplier.supplierid
										  inner join dbo.PM_vw_ConsignmentItems  on pm_vw_consignmentitems.consignmentid = pm_vw_consignment.ConsignmentID 
										  inner join dbo.PM_vw_GoodsIntake on PM_vw_GoodsIntake.ConsignmentItemID = pm_vw_consignmentitems.ConsignmentItemID 
					WHERE (PM_VW_Supplier.Hide = 0) and PM_vw_goodsintake.barcode = dbo.FNC_BarcodeFormat(@Barcode)
					ORDER BY PM_VW_Supplier.SupplierName


		ELSE
			SELECT     PM_VW_Supplier.SupplierID, PM_VW_Supplier.SupplierName, PM_VW_Supplier.Hide AS IsInactive
			FROM         dbo.PM_VW_Supplier INNER JOIN
								  dbo.FNC_User_SupplierList(@UserID) AS User_SupplierList ON PM_VW_Supplier.SupplierID = User_SupplierList.SupplierID
			ORDER BY PM_VW_Supplier.SupplierName
	END
	ELSE --@DateArrived NOT NULL, so must be accessing combo from an assessment (DateArrived trigger also enabled)
		SELECT DISTINCT PM_VW_Supplier.SupplierID, PM_VW_Supplier.SupplierName, PM_VW_Supplier.Hide AS IsInactive
		FROM         dbo.PM_VW_Supplier INNER JOIN
							  PM_VW_GoodsIntake ON PM_VW_Supplier.SupplierID = PM_VW_GoodsIntake.SupplierID
		WHERE     (dbo.FNC_TrimDate(PM_VW_GoodsIntake.DateArrived) = dbo.FNC_TrimDate(@DateArrived)) AND (Hide = 0)
		ORDER BY PM_VW_Supplier.SupplierName
END

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_StockCode_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_StockCode_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 16/07/2008
-- Description:	Gets a stock code list
-- Version:		10 
-- =============================================
-- JE updated to filter list by Customer
-- JT TFS 3657 - updated to only return one query result.
-- MP TFS 3869 - updated to ensure customer filter only used when trigger enabled
-- JE TFS 4178 - added AssessmentTypeID param so we know when to filter out hidden Stock Codes
-- JT TFS 5902 - 13-Feb-2012 - Added searchText
-- JE TFS 13-11942: exclude stock type of Seed/Variety when accessed from Mobile
-- JF TFS 74073 - allow stockcode to be picked up from goods intake without PO data ie PalletStockCodeID. Also check APP_DataLookupTrigger table
-- JF TFS 80479 - allow stockcode list to be filtered from PO
-- JF TFS 104066 GYFD - Allow Header To Work with Barcode Prefix
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_StockCode_Combo]
	@CaseEndBarcode nvarchar(100) = NULL,
	@UserID int = NULL,
	@CustomerID int = NULL,
	@AssessmentTypeID int = NULL,
	@SearchText nvarchar(100) = NULL,
	@Barcode nvarchar(50) = null,
	@ConsignmentID int = null
AS


IF @ConsignmentID IS NOT NULL and (SELECT Enabled FROM APP_DataLookupTrigger WHERE DataLookupID_Trigger = 5 AND DataLookupID_Update = 2) = 1
	SELECT DISTINCT PM_VW_StockCode.StockCodeID, PM_VW_StockCode.DisplayText 
	FROM dbo.PM_VW_StockCode 
	INNER JOIN PM_VW_ConsignmentItems on  PM_VW_ConsignmentItems.StockCodeID = PM_VW_StockCode.StockCodeID 
	INNER JOIN	dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
	WHERE dbo.PM_VW_ConsignmentItems.ConsignmentID = @ConsignmentID

else IF @CaseEndBarcode IS NOT NULL --combo being accessed from an assessment, so hide hidden stock codes
BEGIN
	DECLARE @FilterStockCodeID int
	IF @CaseEndBarcode IS NOT NULL
		SET @FilterStockCodeID = dbo.FNC_CaseEndToStockCode(@CaseEndBarcode)
	ELSE
		SET @FilterStockCodeID = NULL

	SELECT     StockCodeID, DisplayText
	FROM         PM_VW_StockCode
	WHERE   ((StockCodeID = @FilterStockCodeID) AND (@FilterStockCodeID IS NOT NULL) 	OR		(@FilterStockCodeID IS NULL) AND (Hide = 0))
	AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
	AND (PM_VW_StockCode.StockTypeID <> 4)
	ORDER BY DisplayText
END
ELSE
BEGIN
	DECLARE @EnableCustomerFilter bit
	IF @CustomerID IS NOT NULL
		SELECT     @EnableCustomerFilter = Enabled
		FROM         dbo.APP_DataLookupTrigger
		WHERE     (DataLookupID_Update = 2) AND (DataLookupID_Trigger = 3)
	ELSE
		SET @EnableCustomerFilter = 0
		
	IF @UserID IS NULL AND @EnableCustomerFilter = 1 --combo not being accessed from an assessment, so show all stock codes
		SELECT		StockCodeID, DisplayText
		FROM         dbo.PM_VW_StockCode
		WHERE		CustomerID = @CustomerID
		AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
		ORDER BY DisplayText
		
	ELSE IF @UserID IS NOT NULL AND @EnableCustomerFilter = 0 AND @AssessmentTypeID IS NOT NULL --combo being accessed from an assessment, so hide hidden stock codes
		--Where is stockcode stored
		IF @Barcode is NOT NULL and (SELECT Enabled FROM dbo.APP_DataLookupTrigger WHERE DataLookupID_Trigger = 11 AND DataLookupID_Update = 2) = 1
			BEGIN
				SET @Barcode = dbo.FNC_BarcodeFormat(@Barcode)

				IF EXISTS(SELECT consignmentitemid FROM dbo.PM_VW_GoodsIntake WHERE Barcode = @Barcode and consignmentitemid IS NOT NULL)
					SELECT     DISTINCT dbo.PM_VW_StockCode.StockCodeID, DisplayText
					FROM         dbo.PM_VW_StockCode 
					INNER JOIN dbo.PM_VW_ConsignmentItems on dbo.PM_VW_ConsignmentItems.StockCodeID = dbo.PM_VW_StockCode.StockCodeID 
					INNER JOIN dbo.PM_vw_GoodsIntake ON dbo.PM_vw_GoodsIntake.ConsignmentItemID  = dbo.PM_VW_ConsignmentItems.ConsignmentItemID 
					WHERE   
					dbo.PM_vw_GoodsIntake.Barcode = @Barcode 
					ORDER BY DisplayText
				ELSE IF EXISTS(SELECT PalletStockCodeID FROM PM_VW_GoodsIntake WHERE Barcode = @Barcode and PalletStockCodeID IS NOT NULL)
					SELECT     DISTINCT StockCodeID, DisplayText
					FROM         dbo.PM_VW_StockCode INNER JOIN dbo.PM_vw_GoodsIntake ON dbo.PM_vw_GoodsIntake.PalletStockCodeID = dbo.PM_VW_StockCode.StockCodeID 
					WHERE   
					dbo.PM_vw_GoodsIntake.Barcode = @Barcode 
					ORDER BY DisplayText
				ELSE IF EXISTS(SELECT StockBatchID  FROM PM_VW_StockBatch WHERE Barcode = @Barcode)
					SELECT PM_VW_StockCode.StockCodeID, PM_VW_StockCode.DisplayText FROM dbo.PM_VW_StockBatch 
					INNER JOIN dbo.PM_VW_StockBatchItems ON PM_VW_StockBatchItems.StockBatchID  = PM_VW_StockBatch.StockBatchID
					INNER JOIN dbo.PM_VW_StockCode  ON PM_VW_StockCode.StockCodeID  = PM_VW_StockBatchItems.StockCodeID 
					INNER JOIN	dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
					WHERE dbo.PM_VW_StockBatch.Barcode = @Barcode
			END
		ELSE

			SELECT		PM_VW_StockCode.StockCodeID, PM_VW_StockCode.DisplayText
			FROM         dbo.PM_VW_StockCode INNER JOIN
							dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
			WHERE (Hide = 0)
			AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
			AND (PM_VW_StockCode.StockTypeID <> 4)
			ORDER BY PM_VW_StockCode.DisplayText

	ELSE IF @UserID IS NOT NULL AND @EnableCustomerFilter = 0 AND @AssessmentTypeID IS NULL --combo not being accessed from an assessment, so show all stock codes
		SELECT		PM_VW_StockCode.StockCodeID, PM_VW_StockCode.DisplayText
		FROM         dbo.PM_VW_StockCode INNER JOIN
						dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
		AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
		ORDER BY PM_VW_StockCode.DisplayText
		
	ELSE IF @UserID IS NOT NULL AND @EnableCustomerFilter = 1 AND @AssessmentTypeID IS NOT NULL --combo being accessed from an assessment, so hide hidden stock codes
		SELECT		PM_VW_StockCode.StockCodeID, PM_VW_StockCode.DisplayText
		FROM         dbo.PM_VW_StockCode INNER JOIN
						dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
		WHERE		(CustomerID = @CustomerID) AND (Hide = 0)
		AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
		AND (PM_VW_StockCode.StockTypeID <> 4)
		ORDER BY PM_VW_StockCode.DisplayText
	
	ELSE IF @UserID IS NOT NULL AND @EnableCustomerFilter = 1 AND @AssessmentTypeID IS NULL --combo not being accessed from an assessment, so show all stock codes
		SELECT		PM_VW_StockCode.StockCodeID, PM_VW_StockCode.DisplayText
		FROM         dbo.PM_VW_StockCode INNER JOIN
						dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
		WHERE		(CustomerID = @CustomerID)
		AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
		ORDER BY PM_VW_StockCode.DisplayText	
		
	ELSE
		SELECT     StockCodeID, DisplayText
		FROM         dbo.PM_VW_StockCode
		WHERE (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
		ORDER BY DisplayText
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_IntakeCountry_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_IntakeCountry_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		jeremy formby
-- Create date: 14/05/2018
-- Description:	Looks up intake country
-- Version:		2
-- =============================================
-- JMF TFS 96385 
-- JF TFS 104066 GYFD - Allow Header To Work with Barcode Prefix
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_IntakeCountry_Lookup]
	@Barcode nvarchar(100) = null
AS
BEGIN
	SELECT	APP_Country.CountryID,APP_Country.Country + ' ('   + APP_Country.ISOCode  + ')' as Country
	FROM	PM_VW_GoodsIntake INNER JOIN APP_Country on APP_Country.CountryID = PM_VW_GoodsIntake.CountryID 
	WHERE	PM_VW_GoodsIntake.Barcode = dbo.FNC_BarcodeFormat(@Barcode)
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_HarvestDate_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_HarvestDate_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 16/02/2010
-- Description:	Looks up the harvest date
-- Version:	2
-- =============================================
-- JF TFS 104066 GYFD - Allow Header To Work with Barcode Prefix
-- =============================================

ALTER PROCEDURE [dbo].[PM_QRY_HarvestDate_Lookup]
	@Barcode nvarchar(50) = NULL
AS

SELECT     HarvestDate
FROM         PM_VW_GoodsIntake
WHERE     (Barcode = dbo.FNC_BarcodeFormat(@Barcode))
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_HarvestCrew_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_HarvestCrew_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:	Markp
-- Create date: 16/01/2010
-- Description:	Harvest crew combo list
-- Version:	6
-- =============================================
-- JT TFS 7819: Changed unknown ID from -1 to -2
-- JMF 995 - use hiden flag if in mobile
-- JF TFS 74073 - allow harvest crew to be looked up from goods intake barcode. Reformatted code
-- JF TFS 104066 GYFD - Allow Header To Work with Barcode Prefix
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_HarvestCrew_Combo]
@SupplierID int = NULL,
@UserID int = NULL,
@AssessmentTypeID INT = null,
@Barcode nvarchar(50) = null

AS
if @Barcode IS NOT NULL and (SELECT Enabled FROM APP_DataLookupTrigger WHERE DataLookupID_Trigger = 11 AND DataLookupID_Update = 29) = 1
	SELECT     
		PM_VW_UserGroup.UserGroupID, 
		GroupName + CASE WHEN LEN(ISNULL(GroupCode,'')) > 0 THEN ' (' + GroupCode + ')' ELSE '' END AS GroupText
	FROM         dbo.PM_VW_UserGroup INNER JOIN dbo.PM_VW_Goodsintake on PM_VW_Goodsintake.usergroupid = PM_VW_UserGroup.usergroupid
	WHERE PM_VW_Goodsintake.Barcode = dbo.FNC_BarcodeFormat(@Barcode)

else if @SupplierID IS NULL
	SELECT     UserGroupID, GroupName + CASE WHEN LEN(ISNULL(GroupCode,'')) > 0 THEN ' (' + GroupCode + ')' ELSE '' END AS GroupText
	FROM         PM_VW_UserGroup
	WHERE     (GroupTypeID = 1) AND (SupplierID IS NULL OR
	SupplierID IN
	(SELECT     SupplierID
	FROM          dbo.FNC_User_SupplierList(@UserID) AS User_SupplierList))
	and (PM_VW_UserGroup.Hide=0 OR @AssessmentTypeID IS NULL )
	UNION
	SELECT -2 AS UserGroupID, N'Unknown/Other' AS GroupText
	ORDER BY GroupText

ELSE
	SELECT     UserGroupID, GroupName + CASE WHEN LEN(ISNULL(GroupCode, '')) > 0 THEN ' (' + GroupCode + ')' ELSE '' END AS GroupText
	FROM         PM_VW_UserGroup
	WHERE     (GroupTypeID = 1) AND (SupplierID IS NULL OR
	SupplierID = @SupplierID)
	and (PM_VW_UserGroup.Hide=0 OR @AssessmentTypeID IS NULL )
	UNION
	SELECT -2 AS UserGroupID, N'Unknown/Other' AS GroupText
	ORDER BY GroupText

GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_GoodsIntakeComments_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_GoodsIntakeComments_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 16/02/2010
-- Description:	Looks up the harvest date
-- version:2
-- =============================================
-- JF TFS 104066 GYFD - Allow Header To Work with Barcode Prefix
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_GoodsIntakeComments_Lookup]
	@Barcode nvarchar(50) = NULL
AS

SELECT     Comments
FROM         PM_VW_GoodsIntake
WHERE     (Barcode = dbo.FNC_BarcodeFormat(@Barcode))
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_DeliveryHaulier_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_DeliveryHaulier_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 16/02/2010
-- Description:	Get haulier for delivery
-- Version:	2
-- =============================================
-- JF TFS 74073 - pick up delivery haulier from Intake barcode
-- JF TFS 104066 GYFD - Allow Header To Work with Barcode Prefix
-- =============================================

ALTER PROCEDURE [dbo].[PM_QRY_DeliveryHaulier_Lookup] 
	@DeliveryID int = NULL,
	@Barcode nvarchar(50)=null
AS

IF @Barcode IS NULL
	SELECT     Haulier
	FROM         PM_VW_Delivery
	WHERE     (DeliveryID = @DeliveryID)
ELSE

	SELECT   DISTINCT  Haulier
	FROM         dbo.PM_VW_Delivery INNER JOIN dbo.PM_vw_GoodsIntake ON PM_vw_GoodsIntake.deliveryID = PM_VW_Delivery.DeliveryID 
	WHERE     (PM_vw_GoodsIntake.Barcode  = dbo.FNC_BarcodeFormat(@Barcode) and @Barcode IS NOT NULL)
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Consignment_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Consignment_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 16/07/2008
-- Description:	Gets list of consignments
-- Version:	3
-- =============================================
-- JF TFS 78132 -can use barcode
-- JF output integrated data
-- JF TFS 92518 - filter on Location if the trigger is enabled
-- JF TFS 92518 - format Consignment to cater for older, non integarated PO data using orderref or ConsignmentNo
-- JF TFS 104066 GYFD - Allow Header To Work with Barcode Prefix
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_Consignment_Combo]
	@SupplierID int = null,
	@Barcode nvarchar(50) =null,
	@LocationID INT=null
AS

	DECLARE @DownloadConsignmentDays int, @DateFrom datetime
	SET @DownloadConsignmentDays = ISNULL(dbo.FNC_GetOptionValue(101),0)
	
	IF @DownloadConsignmentDays = 0 
		SELECT @DateFrom = NULL
	ELSE
		SET @DateFrom = DATEADD(day,-@DownloadConsignmentDays,GETDATE())

	
	if exists(select * from APP_DataLookupTrigger where datalookupid_Trigger = 4 and DataLookupID_Update = 5 and enabled = 1)
		--filter PO based on Location
		SELECT  PM_VW_Consignment.ConsignmentID, E_PO AS Consignment
		FROM         PM_VW_Consignment 
		WHERE     (LocationID= @LocationID) and (DateRequired > @DateFrom OR DateRequired IS NULL or @DateFrom IS NULL)
		ORDER BY E_PO DESC

	ELSE if @Barcode IS NOT NULL
		BEGIN
			SELECT  DISTINCT   PM_VW_Consignment.ConsignmentID, ISNULL(E_PO,ISNULL(OrderRef, ConsignmentNo)) AS Consignment
			FROM         PM_VW_Consignment 
			INNER JOIN PM_VW_ConsignmentItems on PM_VW_Consignment.consignmentID = PM_VW_ConsignmentItems.consignmentID
			INNER JOIN PM_VW_GoodsIntake ON PM_VW_ConsignmentItems.consignmentitemID=PM_VW_GoodsIntake.consignmentitemid
			WHERE     (PM_VW_GoodsIntake.Barcode = dbo.FNC_BarcodeFormat(@Barcode))
			ORDER BY ISNULL(E_PO,ISNULL(OrderRef, ConsignmentNo)) DESC
		END

	ELSE --if exists(select * from APP_DataLookupTrigger where datalookupid_Trigger = 1 and DataLookupID_Update = 5 and enabled = 1)
		--filter PO based on supplier
		SELECT  ConsignmentID, ISNULL(E_PO,ISNULL(OrderRef, ConsignmentNo)) AS Consignment
		FROM         PM_VW_Consignment
		WHERE     
			(SupplierID = @SupplierID OR @SupplierID IS NULL) AND
			(DateRequired > @DateFrom OR DateRequired IS NULL or @DateFrom IS NULL)
		ORDER BY E_PO DESC
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_ArrivalItemCount_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_ArrivalItemCount_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 27/08/09
-- Description:	Lookup the Arrival quantity
-- Version:	4
-- Unit test:	PM_QRY_ArrivalItemCount_Lookup_TEST.sql
-- =============================================
-- JF TFS 92520 - Generic Integration -  Change Quantity Received lookup to read from PO data if intake data does not exist  
-- JF TFS 104066 GYFD - Allow Header To Work with Barcode Prefix
-- JF TFS 106098 - Entity framework error - The data reader has more than one field. Multiple fields are not valid for EDM primitive or enumeration types.
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_ArrivalItemCount_Lookup] 
	@GoodsIntakeID int = null,
	@Barcode nvarchar(50) = NULL,
	@ConsignmentItemID INT = null,
	@StockCodeID  INT = null,
	@ConsignmentID INT = null
AS

IF @Barcode IS NOT NULL 
	SELECT     ItemCount
	FROM         PM_VW_GoodsIntake
	WHERE     (Barcode = dbo.FNC_BarcodeFormat(@Barcode))
	
ELSE IF @ConsignmentItemID IS NOT NULL and exists(select * from APP_DataLookupTrigger where datalookupid_Trigger = 6 and DataLookupID_Update = 17 and enabled = 1)
	SELECT  QuantityReceived
	FROM PM_VW_ConsignmentItems
	WHERE ConsignmentItemID = @ConsignmentItemID

ELSE IF @StockCodeID IS NOT NULL and @ConsignmentID IS NOT NULL AND exists(select * from APP_DataLookupTrigger where datalookupid_Trigger = 2 and DataLookupID_Update = 17 and enabled = 1)
	SELECT  SUM(QuantityReceived) as QuantityReceived
	FROM PM_VW_ConsignmentItems
	WHERE ConsignmentID = @ConsignmentID and StockCodeID = @StockCodeID

ELSE IF @GoodsIntakeID IS NOT NULL
	SELECT     ItemCount
	FROM         PM_VW_GoodsIntake
	WHERE     (GoodsIntakeID = @GoodsIntakeID)
else
	Select null as ItemCount
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_ArrivalDate_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_ArrivalDate_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 20/02/2009
-- Description:	Looks up the arrival date for assessment header
-- Version:	2
-- =============================================
-- JF TFS 104066 GYFD - Allow Header To Work with Barcode Prefix
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_ArrivalDate_Lookup]
	@GoodsIntakeID int = NULL,
	@Barcode nvarchar(50) = NULL
AS

IF @GoodsIntakeID IS NULL AND @Barcode IS NOT NULL
	SELECT     @GoodsIntakeID = GoodsIntakeID
	FROM         PM_VW_GoodsIntake
	WHERE     (Barcode = dbo.FNC_BarcodeFormat(@Barcode))

IF @GoodsIntakeID IS NULL
	SELECT dbo.FNC_TrimDate(GETDATE())

ELSE
	SELECT     dbo.FNC_TrimDate(DateArrived)
	FROM         PM_VW_GoodsIntake
	WHERE     (GoodsIntakeID = @GoodsIntakeID)
GO




PRINT 'Database updated successfully!'
GO

