-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_ArrivalDate_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_ArrivalDate_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 20/02/2009
-- Description:	Looks up the arrival date for assessment header
-- Unit Tests:	~\GLQC\Main\Database\UnitTests\PM_QRY_ArrivalDate_Lookup_TEST.sql
-- Version:		2
-- =============================================
-- DPC TFS 13-92521: Adding fallback to consignment date required if intake data does not exist
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_ArrivalDate_Lookup]
	@GoodsIntakeID int = NULL,
	@Barcode nvarchar(50) = NULL,
	@ConsignmentID int = NULL
AS

IF @GoodsIntakeID IS NULL AND @Barcode IS NOT NULL
	SELECT	@GoodsIntakeID = GoodsIntakeID
	FROM	PM_VW_GoodsIntake
	WHERE	(Barcode = @Barcode)

IF EXISTS(
	SELECT	1
	FROM	PM_VW_GoodsIntake
	WHERE	(GoodsIntakeID = @GoodsIntakeID)
)
BEGIN
	SELECT	dbo.FNC_TrimDate(DateArrived)
	FROM	PM_VW_GoodsIntake
	WHERE	(GoodsIntakeID = @GoodsIntakeID)
	RETURN
END

IF EXISTS(
	SELECT	1
	FROM	PM_VW_Consignment
	WHERE	ConsignmentID = @ConsignmentID
)
BEGIN
	SELECT	dbo.FNC_TrimDate(DateRequired)
	FROM	PM_VW_Consignment
	WHERE	ConsignmentID = @ConsignmentID
	RETURN
END

SELECT dbo.FNC_TrimDate(GETDATE())

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'APP_Temp_ReportFilter')
	EXEC ('CREATE PROCEDURE [dbo].[APP_Temp_ReportFilter] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JToolan
-- Create date: 22/03/2012
-- Description:	Works out which ResponseIDs need to be put in the filter.
--              Can be used by any report.
-- Version:		24
-- =============================================
-- j.toolan 30-mar-2012: If @AssessmentTypeID_LIST is empty, then join all assessments
-- j.toolan 13 Apr 2012: Fixed bug with 2nd filter incorrectly clearing.
-- j.toolan 18 Apr 2012: Added Code to filter by stockcode where appropriate (renamed to ReportFilter)
-- JE 25 Apr 2012: made ReportFilterID1 optional, so can just filter by AssessmentType if necessary (TFS 3382)
-- j.toolan 6 July 2012: TFS 4013: Dynamic filtering added.
-- JE TFS 4740: removed GROUP BY for performance reasons
-- JE TFS 5037: corrected @ReportFilterID2 check as 2nd tier filter wasn't working
-- MP TFS 5289: changed date format used for custom filter functions
-- JT TFS 5396: changed code to allow commas in FilterTexts passed in as CSV. (replace "," with "&comma;" )
-- JT TFS 6689: FNC_CanUserDataWareHouse takes UserID parameter.
-- JT TFS 6689: FNC_ReportFilter_Response takes UserID parameter.
-- JT TFS 8117: Added offline filtering.
-- MP TFS 8227: Made temp table user specific and added performance logging
-- JE TFS 8274: Put result set of FNC_User_ResponseList into temp table before using it
-- JT TFS 13-667: Do not filter responses if the date range is too big.
-- JT TFS 13-1076: Search either QMS_Response or QMS_SupplierResponse, but not both.
-- JF TFS 2281 - if filter doesn't have a sourceid, this wasn't working
-- JT TFS 13-17467: Only include checks which are eligible candidates for the data warehouse.
-- JT TFS 13-38578: Convert SP to use QRY_User_ResponseList (rather than FNC_UserResponseList)
-- JT TFS 13-40008: 22/02/2016 - Added transaction IDs to response list generation, and extracted stockcode filtering
-- JT TFS 13-42222: 02/03/2016 - Added link to TokenUserID so that reports can be run simultaneously.
-- JF TFS 35438 - make sure we remove data which wouldn't show in the data warehouse - ie parent checks for Assessment type 5
-- jf TFS 90761 - Morrisons QC Office - Issue with reports not generating - removed the use of FNC_Response_ShouldIncludeInDataWarehouse dues to performance issues 
-- CJP TFS 87358 - Appending FilterText to TEMP_UserData table to ensure it is visible on report
-- jf TFS 102053 - increased GroupByText nvarchar(50) to GroupByText nvarchar(255)
-- =============================================
ALTER PROCEDURE [dbo].[APP_Temp_ReportFilter]
	@UserID int,
	@DateFrom datetime,
	@DateTo datetime,
	@AssessmentTypeID_LIST nvarchar(255),

	@ReportFilterID1 int = NULL,
	@FilterID_LIST nvarchar(4000),
	@FilterText_LIST nvarchar(4000),
	@ReportFilterID2 int = NULL,
	@FilterID2 int = NULL,
	@FilterText2 nvarchar(255) = NULL,
	
	@Offline bit = NULL,
	@SearchLocalChecksIfOffline bit = 1, -- Use QMS_Response even if offline (default)
	@TransactionID uniqueidentifier = NULL
AS
BEGIN
	SET NOCOUNT ON
	
	--//This can be removed when fixed properly
	--Insert the filter text into TEMP_UserData for retreival later
	DELETE FROM TEMP_UserData where @UserID=@UserID
	INSERT INTO TEMP_UserData (UserID, String1) VALUES (@UserID, CASE WHEN LEN(@FilterText_LIST)>100 THEN LEFT(@FilterText_LIST,97)+ '...' ELSE LEFT(@FilterText_LIST,100) END)
	--//End of fix
	
	EXEC SAVE_TEMP_Transaction @TransactionID, @UserID

	DECLARE @TokenUserID int;
	SELECT @TokenUserID = dbo.FNC_GetTempTransaction_TokenUserID(@TransactionID, @UserID)

	DECLARE @DateCalled DATETIME
	SET @DateCalled = GETDATE()	
	IF @Offline IS NULL SELECT @Offline = CASE WHEN db_name() = 'GreenlightQC_Mobile' THEN 1 ELSE 0 END
	
	DECLARE @SearchOffline bit -- if this is set, then we search in QMS_SupplierResponse.
	SELECT @SearchOffline  = CASE WHEN @Offline = 1 AND @SearchLocalChecksIfOffline = 0 THEN 1 ELSE 0 END
		
	-- Do not filter responses if the date range is not specified
	DECLARE @performResponseFiltering bit 
	SELECT @performResponseFiltering = CASE WHEN @DateFrom <= '1 Jan 2001' and datediff(year, @DateFrom, @DateTo) >= 10 THEN 0 ELSE 1 END
	
	DELETE TEMP_ResponseFilter WHERE UserID = @TokenUserID OR TransactionID = @TransactionID

	-- If the first criteria is empty, but the second is not, swap them over.
	IF (LEN(@FilterID_LIST) = 0 AND LEN(@FilterText_LIST) = 0 -- first criteria is empty?!
	AND @ReportFilterID2 IS NOT NULL AND (@FilterID2 IS NOT NULL OR @FilterText2 IS NOT NULL)) -- but the second is not...
	BEGIN -- The great fairness swaparoo! (in two steps)
		SELECT	@ReportFilterID1 = @ReportFilterID2,
				@FilterID_LIST = CONVERT(nvarchar(4000), @FilterID2),
				@FilterText_LIST = @FilterText2
				
		SELECT @ReportFilterID2 = NULL, @FilterID2 = NULL, @FilterText2 = NULL
	END

	-- Is the second question correctly formulated? You must have an id or a text (or both) but not neither.
	-- JE TFS 5037 - corrected this as it was always setting @ReportFilterID2 to NULL for filters with no ID (i.e. text only)
	IF @ReportFilterID2 IS NOT NULL AND (NULLIF(@FilterID2, 0) IS NULL) AND (LEN(ISNULL(@FilterText2, '')) = 0)
	BEGIN
		SET @ReportFilterID2 = NULL
	END

	DECLARE @FilterItem TABLE (pos int not null, id int, txt nvarchar(255))
	INSERT @FilterItem (pos, id, txt)
	
	-- tfs 2281 - if filter doesn't have a sourceidm this wasn't working
	SELECT 	ISNULL(a.Position, b.Position) pos, CONVERT(int, ISNULL(a.Token,0)) id, replace(b.Token, '&comma;', ',') txt
	FROM dbo.FNC_SplitString(@FilterID_LIST, ',') a
	FULL JOIN dbo.FNC_SplitString(@FilterText_LIST, ',') b on a.Position = b.Position

	DECLARE @AssessmentType TABLE (id int not null)
	INSERT @AssessmentType (id) 
	SELECT CONVERT(int, Token) FROM dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',')
	INNER JOIN APP_AssessmentType ON CONVERT(int, Token) = AssessmentTypeID 
	IF NOT EXISTS (SELECT * FROM @AssessmentType) 
	BEGIN -- if we tried to join, and got nothing, that means that this report wants all non-hidden types.
		INSERT @AssessmentType (id) SELECT AssessmentTypeID FROM APP_AssessmentType WHERE Hide = 0
	END

	-- Do some custom filtering if it is set up. This acts like "AND" (restricting results)
	DECLARE @CustomFilterFunction nvarchar(50)
	SET @CustomFilterFunction = NULL
	SELECT @CustomFilterFunction = APP_ReportFilter.FilterFunction 
	FROM APP_ReportFilter 
	WHERE ReportFilterID = @ReportFilterID1
	
	DECLARE @customSql nvarchar(1000)
	SET @customSql = NULL
	CREATE TABLE #tmpCustomFilter (UserID INT, ResponseID int, GroupByText nvarchar(255))

	DECLARE @FilteredResponse TABLE (id int not null)
	WHILE EXISTS (SELECT * FROM @FilterItem)
	BEGIN
		DECLARE @pos int, @FilterID int, @FilterText nvarchar(255)
		SELECT @pos = pos,  @FilterID = id, @FilterText = txt
		FROM @FilterItem
		WHERE pos = (SELECT MIN(pos) FROM @FilterItem)

		IF @performResponseFiltering = 1
		BEGIN
			-- either the custom function runs, *OR* the generic one, *OR* the offline one, but not more than one.
			IF @SearchOffline = 1
			BEGIN
				INSERT @FilteredResponse (id)
				SELECT ResponseID 
				FROM dbo.FNC_ReportFilter_Response_Offline(@ReportFilterID1, @FilterID, @FilterText, @DateFrom, @DateTo, @UserID)
			END
			ELSE IF @CustomFilterFunction IS NOT NULL
			BEGIN
				SELECT @customSql = 'INSERT #tmpCustomFilter (UserID, ResponseID, GroupByText) SELECT ' + convert(nvarchar(10), @TokenUserID) + ' AS UserID, ResponseID, GroupByText FROM dbo.[' + @CustomFilterFunction + ']' + 
									'(' + convert(nvarchar(10), @UserID) + ', ' +
									convert(nvarchar(30), @FilterID) + ', ' +
									'''' + convert(nvarchar(50), @FilterText) + ''', ' + 
									'''' + convert(nvarchar(30), @DateFrom, 13) + ''', ' +
									'''' + convert(nvarchar(30), @DateTo, 13) + ''');'
				
				PRINT @customSql
				
				IF @customSql IS NOT NULL
					EXECUTE (@customSql)
			END
			ELSE
			BEGIN
				INSERT @FilteredResponse (id)
				SELECT ResponseID 
				FROM dbo.FNC_ReportFilter_Response(@ReportFilterID1, @FilterID, @FilterText, @DateFrom, @DateTo, @UserID)
			END
		END
		
		DELETE @FilterItem WHERE pos = @pos
	END

	-- insert all our new custom filtered items (added to temp table in loop above)
	INSERT @FilteredResponse (id)
	SELECT ResponseID 
	FROM #tmpCustomFilter
	WHERE UserID = @TokenUserID

	-- If there is another filter, it acts as an "AND" (restricting results returned), not an "OR" (expanding results returned). 
	IF @ReportFilterID2 IS NOT NULL
	BEGIN 
		IF @performResponseFiltering = 1
		BEGIN
			DECLARE @SecondFilteredResponse TABLE (id int)
			
			SELECT @CustomFilterFunction = APP_ReportFilter.FilterFunction 
			FROM APP_ReportFilter 
			WHERE ReportFilterID = @ReportFilterID2
		
			IF @SearchOffline = 1
			BEGIN
				INSERT @SecondFilteredResponse (id)
				SELECT ResponseID 
				FROM dbo.FNC_ReportFilter_Response_Offline(@ReportFilterID2, @FilterID2, @FilterText2, @DateFrom, @DateTo, @UserID)
			END 
			ELSE IF @CustomFilterFunction IS NOT NULL
			BEGIN
				DELETE #tmpCustomFilter WHERE UserID = @TokenUserID --clear it out for second filter.
				
				SELECT @customSql = 'INSERT #tmpCustomFilter (UserID, ResponseID, GroupByText) SELECT ' + convert(nvarchar(10), @TokenUserID) + ' AS UserID, ResponseID, GroupByText FROM dbo.[' + @CustomFilterFunction + ']' + 
									'(' + convert(nvarchar(10), @UserID) + ', ' +
									convert(nvarchar(30), @FilterID2) + ', ' +
									'''' + convert(nvarchar(50), @FilterText2) + ''', ' + 
									'''' + convert(nvarchar(30), @DateFrom, 13) + ''', ' +
									'''' + convert(nvarchar(30), @DateTo, 13) + ''');'

				IF @customSql IS NOT NULL
					EXECUTE (@customSql)
				
				INSERT @SecondFilteredResponse (id)
				SELECT ResponseID FROM #tmpCustomFilter WHERE UserID = @TokenUserID
			END
			ELSE
			BEGIN
				INSERT @SecondFilteredResponse (id)
				SELECT ResponseID 
				FROM dbo.FNC_ReportFilter_Response (@ReportFilterID2, @FilterID2, @FilterText2, @DateFrom, @DateTo, @UserID)
			END
			
			DELETE @FilteredResponse 
			WHERE id NOT IN (
				SELECT id FROM @SecondFilteredResponse
			)
		END
	END

	-- Remove all responses which are not suitable candidates for the data warehouse
	-- JF - logic moved further down as @FilteredResponse is not used in all return paths
	--DELETE @FilteredResponse
	--WHERE dbo.FNC_Response_ShouldIncludeInDataWarehouse(id) = 0


	IF @performResponseFiltering = 1
	BEGIN
		IF @SearchOffline = 1
		BEGIN
			IF @ReportFilterID1 IS NOT NULL
				INSERT TEMP_ResponseFilter (UserID, ResponseID)
				SELECT @TokenUserID as UserID, r.ResponseID 
				FROM QMS_SupplierResponse r
				INNER JOIN @AssessmentType at ON r.AssessmentTypeID = at.id
				INNER JOIN @FilteredResponse fr ON fr.id = r.ResponseID
				WHERE EndDate BETWEEN @DateFrom AND @DateTo
				AND   r.ResponseID NOT IN (SELECT ResponseID FROM TEMP_ResponseFilter WHERE UserID = @TokenUserID)
				--AND dbo.FNC_Response_ShouldIncludeInDataWarehouse(r.ResponseID) = 1
				and (
					SELECT	CASE	WHEN APP_AssessmentType.AssessmentFormat NOT IN (5,6,7) THEN 1 -- Isn't multi-check at all - store it.
							WHEN APP_AssessmentType.AssessmentFormat = 5
								 AND  QMS_Response.ParentResponseGUID IS NOT NULL	THEN 1 -- Morrisons scenario - only store the child checks.
							WHEN APP_AssessmentType.AssessmentFormat = 6 
								 AND  QMS_Response.ParentResponseGUID IS NULL		THEN 1 -- barfoots scenario - only store the parent check.
							WHEN APP_AssessmentType.AssessmentFormat = 7			THEN 1 -- standard multi-check - store both child and parent. 
							ELSE 0 -- Reject it.
					END
					FROM	QMS_Response
					INNER JOIN APP_AssessmentType ON APP_AssessmentType.AssessmentTypeID = QMS_Response.AssessmentTypeID
					WHERE	QMS_Response.ResponseID = r.ResponseID
				) =1

				GROUP BY r.ResponseID
			ELSE
				INSERT TEMP_ResponseFilter (UserID, ResponseID)
				SELECT @TokenUserID as UserID, r.ResponseID 
				FROM QMS_SupplierResponse r 
				INNER JOIN @AssessmentType at ON r.AssessmentTypeID = at.id	
				WHERE EndDate BETWEEN @DateFrom AND @DateTo
				AND   r.ResponseID NOT IN (SELECT ResponseID FROM TEMP_ResponseFilter WHERE UserID = @TokenUserID)
				--AND dbo.FNC_Response_ShouldIncludeInDataWarehouse(r.ResponseID) = 1
				and (
					SELECT	CASE	WHEN APP_AssessmentType.AssessmentFormat NOT IN (5,6,7) THEN 1 -- Isn't multi-check at all - store it.
							WHEN APP_AssessmentType.AssessmentFormat = 5
								 AND  QMS_Response.ParentResponseGUID IS NOT NULL	THEN 1 -- Morrisons scenario - only store the child checks.
							WHEN APP_AssessmentType.AssessmentFormat = 6 
								 AND  QMS_Response.ParentResponseGUID IS NULL		THEN 1 -- barfoots scenario - only store the parent check.
							WHEN APP_AssessmentType.AssessmentFormat = 7			THEN 1 -- standard multi-check - store both child and parent. 
							ELSE 0 -- Reject it.
					END
					FROM	QMS_Response
					INNER JOIN APP_AssessmentType ON APP_AssessmentType.AssessmentTypeID = QMS_Response.AssessmentTypeID
					WHERE	QMS_Response.ResponseID = r.ResponseID
				) =1

				GROUP BY r.ResponseID
		END
		ELSE
		BEGIN
			--JE TFS 82774 - temp table of responses user can view (moved from direct access in query to improve performance)
			IF nullif(object_id('tempdb..#tmpUserResponses'), 0) IS NOT NULL DROP TABLE #tmpUserResponses
			CREATE TABLE #tmpUserResponses (UserID int, ResponseID int, ResponseStatus int, QAFlagID int)
			INSERT #tmpUserResponses (UserID, ResponseID, ResponseStatus, QAFlagID)
			EXEC QRY_User_ResponseList @UserID, @DateFrom, @DateTo
			
			IF @ReportFilterID1 IS NOT NULL
				-- Only return responses that the user is allowed to see, filter by Assessment Type, and use filter
				INSERT TEMP_ResponseFilter (UserID, ResponseID, TransactionID)
				SELECT @TokenUserID as UserID, rl.ResponseID, @TransactionID
				FROM #tmpUserResponses AS rl
				INNER JOIN QMS_Response r ON rl.ResponseID = r.ResponseID 
				INNER JOIN @AssessmentType at ON r.AssessmentTypeID = at.id
				INNER JOIN @FilteredResponse fr ON fr.id = r.ResponseID
				WHERE rl.UserID = @UserID
				--AND dbo.FNC_Response_ShouldIncludeInDataWarehouse(r.ResponseID) = 1
				and (
					SELECT	CASE	WHEN APP_AssessmentType.AssessmentFormat NOT IN (5,6,7) THEN 1 -- Isn't multi-check at all - store it.
							WHEN APP_AssessmentType.AssessmentFormat = 5
								 AND  QMS_Response.ParentResponseGUID IS NOT NULL	THEN 1 -- Morrisons scenario - only store the child checks.
							WHEN APP_AssessmentType.AssessmentFormat = 6 
								 AND  QMS_Response.ParentResponseGUID IS NULL		THEN 1 -- barfoots scenario - only store the parent check.
							WHEN APP_AssessmentType.AssessmentFormat = 7			THEN 1 -- standard multi-check - store both child and parent. 
							ELSE 0 -- Reject it.
					END
					FROM	QMS_Response
					INNER JOIN APP_AssessmentType ON APP_AssessmentType.AssessmentTypeID = QMS_Response.AssessmentTypeID
					WHERE	QMS_Response.ResponseID = r.ResponseID
				) =1

				GROUP BY rl.ResponseID
			
			IF @ReportFilterID1 IS NULL
				-- Only return responses that the user is allowed to see, but there has been no filter specified, so only filter by Assessment Type (if specified)
				INSERT TEMP_ResponseFilter (UserID, ResponseID, TransactionID)
				SELECT @TokenUserID as UserID, rl.ResponseID, @TransactionID
				FROM #tmpUserResponses AS rl
				INNER JOIN QMS_Response r ON rl.ResponseID = r.ResponseID 
				INNER JOIN @AssessmentType at ON r.AssessmentTypeID = at.id
				WHERE rl.UserID = @UserID	
				--AND dbo.FNC_Response_ShouldIncludeInDataWarehouse(r.ResponseID) = 1
				and (
					SELECT	CASE	WHEN APP_AssessmentType.AssessmentFormat NOT IN (5,6,7) THEN 1 -- Isn't multi-check at all - store it.
							WHEN APP_AssessmentType.AssessmentFormat = 5
								 AND  QMS_Response.ParentResponseGUID IS NOT NULL	THEN 1 -- Morrisons scenario - only store the child checks.
							WHEN APP_AssessmentType.AssessmentFormat = 6 
								 AND  QMS_Response.ParentResponseGUID IS NULL		THEN 1 -- barfoots scenario - only store the parent check.
							WHEN APP_AssessmentType.AssessmentFormat = 7			THEN 1 -- standard multi-check - store both child and parent. 
							ELSE 0 -- Reject it.
					END
					FROM	QMS_Response
					INNER JOIN APP_AssessmentType ON APP_AssessmentType.AssessmentTypeID = QMS_Response.AssessmentTypeID
					WHERE	QMS_Response.ResponseID = r.ResponseID
				) =1

				GROUP BY rl.ResponseID
			
			DROP TABLE #tmpUserResponses
		END

	END
	
	DECLARE @MonitorEnabled TINYINT
	SELECT @MonitorEnabled = ISNULL(dbo.FNC_GetOptionValue(92),0)

	IF @MonitorEnabled = 1 --Log filter to QMS_PerformanceLog
	BEGIN
		DECLARE @ReportString NVARCHAR(max)
		SET @ReportString = 'APP_Temp_ReportFilter '
		SET @ReportString = @ReportString + '@UserID = ' + CAST(@UserID AS NVARCHAR(10))
		SET @ReportString = @ReportString + ', @DateFrom = ' + CAST(@DateFrom AS NVARCHAR(11))
		SET @ReportString = @ReportString + ', @DateTo = ' + CAST(@DateTo AS NVARCHAR(11))
		SET @ReportString = @ReportString + ', @AssessmentTypeID_LIST = ' + CASE WHEN LEN(@AssessmentTypeID_LIST)=0 THEN 'NULL' ELSE @AssessmentTypeID_LIST END
		IF @ReportFilterID1>0
		BEGIN
			SET @ReportString = @ReportString + ', @ReportFilterID1 = ' + CAST(@ReportFilterID1 AS NVARCHAR(10))
			SET @ReportString = @ReportString + ', @FilterID_LIST = ' + CASE WHEN LEN(@FilterID_LIST)=0 THEN 'NULL' ELSE @FilterID_LIST END
			SET @ReportString = @ReportString + ', @FilterText_LIST = ' + CASE WHEN LEN(@FilterText_LIST)=0 THEN 'NULL' ELSE @FilterText_LIST END
		END
		IF @ReportFilterID2>0
		BEGIN
			SET @ReportString = @ReportString + ', @ReportFilterID2 = ' + CAST(@ReportFilterID2 AS NVARCHAR(10))
			SET @ReportString = @ReportString + ', @FilterID2 = ' + CAST(@FilterID2 AS NVARCHAR(10))
			SET @ReportString = @ReportString + ', @FilterText2 = ' + CASE WHEN LEN(@FilterText2)=0 THEN 'NULL' ELSE @FilterText2 END
		END
		SET @ReportString = @ReportString + ', @TransactionID = ' + CASE WHEN @TransactionID IS NULL THEN 'NULL' ELSE '''' + CAST(@TransactionID AS NVARCHAR(36)) + '''' END

		DECLARE @ResponseCount INT
		SELECT @ResponseCount = COUNT(ResponseID) FROM TEMP_ResponseFilter WHERE UserID = @TokenUserID
		
		INSERT INTO dbo.QMS_PerformanceLog
				( Action ,
				  StartTime ,
				  EndTime ,
				  RecordsAffected
				)
		VALUES  ( @ReportString ,
				  @DateCalled ,
				  GETDATE() ,
				  @ResponseCount
				  )
	END

	SET NOCOUNT OFF
END

GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PER_DeleteAllResponsePermissions')
	EXEC ('CREATE PROCEDURE [dbo].[PER_DeleteAllResponsePermissions] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Taj Sehdev
-- Create date: 31/07/2018
-- Description:	Delete all permissions for responses by user id
-- Versions: 1
-- =============================================
ALTER PROCEDURE PER_DeleteAllResponsePermissions
	-- Add the parameters for the stored procedure here
	@UserID int
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
	Delete from PER_Response_User where UserID = @UserID
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Country_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Country_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================    
-- Author:  Markp
-- Create date: 14/11/2008
-- Description: Gets country list for combo
-- Version:  5
-- =============================================
-- MP TFS 446: Added @AssessmentType parameter so can tell when combo is being called from Mobile
-- MartinP TFS 13-52882: 04/04/2017 - Added @UserID and links to dbo.FNC_ResourceString_User  - Also added @DoNotTranslate option
-- JT TFS 13-103929: 24/07/2018 - Added Barcode, which looks up from GoodsIntake if an enabled trigger exists between Barcode and Country of origin.
-- JF TFS 103929: barcode is lookupid 11
-- =============================================    
ALTER PROCEDURE [dbo].[QRY_Country_Combo]
	@SupplierID int = NULL,
	@AssessmentTypeID INT = NULL,
	@UserID INT = NULL,
	@DoNotTranslate AS BIT = 0,
	@Barcode nvarchar(50) = NULL
AS

DECLARE @FilterCountryID int
SET @FilterCountryID = NULL

-- Only check the goodsintake table if there is a trigger linking barcode to country of origin.

IF @Barcode IS NOT NULL 
AND EXISTS (SELECT * FROM APP_DataLookupTrigger 
			WHERE DataLookupID_Trigger = 11 
			AND DataLookupID_Update = 14 
			AND Enabled = 1)
BEGIN
	SELECT @FilterCountryID = CountryID
	FROM PM_VW_GoodsIntake
	WHERE Barcode = @Barcode;
END

-- If no match on above, try going down the supplier route.
IF @FilterCountryID IS NULL AND @SupplierID IS NOT NULL
BEGIN
	SELECT     @FilterCountryID = CountryID
	FROM         PM_VW_Supplier
	WHERE     (SupplierID = @SupplierID)
END

IF @FilterCountryID IS NULL
BEGIN
	IF @AssessmentTypeID IS NULL
	BEGIN
		SELECT     CountryID,
		CASE WHEN @DoNotTranslate = 0 THEN
			ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), Country)
		ELSE
			ISNULL(dbo.FNC_ResourceString_User(ResourceName, NULL), Country)
		END AS Country
		FROM         APP_Country
		ORDER BY Country
	END
	ELSE  --being called from mobile
	BEGIN
		SELECT    CountryID,
				CASE WHEN @DoNotTranslate = 0 THEN
					ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), Country)
				ELSE
					ISNULL(dbo.FNC_ResourceString_User(ResourceName, NULL), Country)
				END AS Country
		FROM         APP_Country
		UNION
		SELECT     CountryAliasID AS CountryID, CountryAlias AS Country
		FROM         QMS_CountryAlias
		WHERE     (RecordStatus < 201)
		ORDER BY Country
	END
END
ELSE
BEGIN
	SELECT	CountryID,
			CASE WHEN @DoNotTranslate = 0 THEN
				ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), Country)
			ELSE
				ISNULL(dbo.FNC_ResourceString_User(ResourceName, NULL), Country)
			END AS Country
	FROM         APP_Country
	WHERE     (CountryID = @FilterCountryID)
	ORDER BY Country;
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Intake_LookupText10')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Intake_LookupText10] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 24/8/2010
-- Description:	Get LookupText1 for intake record
-- Version:	1
-- =============================================
-- JF TFS 103929
-- =============================================

ALTER PROCEDURE [dbo].[PM_QRY_Intake_LookupText10] 
	@Barcode nvarchar(50)=null
AS

	SELECT     Distinct LookupText10
	FROM         dbo.PM_VW_Goodsintake
	WHERE     (Barcode  = @Barcode and @Barcode IS NOT NULL)

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Intake_LookupText9')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Intake_LookupText9] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 24/8/2010
-- Description:	Get LookupText1 for intake record
-- Version:	1
-- =============================================
-- JF TFS 103929
-- =============================================

ALTER PROCEDURE [dbo].[PM_QRY_Intake_LookupText9] 
	@Barcode nvarchar(50)=null
AS

	SELECT     Distinct LookupText9 
	FROM         dbo.PM_VW_Goodsintake
	WHERE     (Barcode  = @Barcode and @Barcode IS NOT NULL)

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Intake_LookupText8')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Intake_LookupText8] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 24/8/2010
-- Description:	Get LookupText1 for intake record
-- Version:	1
-- =============================================
-- JF TFS 103929
-- =============================================

ALTER PROCEDURE [dbo].[PM_QRY_Intake_LookupText8] 
	@Barcode nvarchar(50)=null
AS

	SELECT     Distinct LookupText8 
	FROM         dbo.PM_VW_Goodsintake
	WHERE     (Barcode  = @Barcode and @Barcode IS NOT NULL)

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Intake_LookupText7')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Intake_LookupText7] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 24/8/2010
-- Description:	Get LookupText1 for intake record
-- Version:	1
-- =============================================
-- JF TFS 103929
-- =============================================

ALTER PROCEDURE [dbo].[PM_QRY_Intake_LookupText7] 
	@Barcode nvarchar(50)=null
AS

	SELECT     Distinct LookupText7 
	FROM         dbo.PM_VW_Goodsintake
	WHERE     (Barcode  = @Barcode and @Barcode IS NOT NULL)

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Intake_LookupText6')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Intake_LookupText6] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 24/8/2010
-- Description:	Get LookupText1 for intake record
-- Version:	1
-- =============================================
-- JF TFS 103929
-- =============================================

ALTER PROCEDURE [dbo].[PM_QRY_Intake_LookupText6] 
	@Barcode nvarchar(50)=null
AS

	SELECT     Distinct LookupText6 
	FROM         dbo.PM_VW_Goodsintake
	WHERE     (Barcode  = @Barcode and @Barcode IS NOT NULL)

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Intake_LookupText5')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Intake_LookupText5] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 24/8/2010
-- Description:	Get LookupText1 for intake record
-- Version:	1
-- =============================================
-- JF TFS 103929
-- =============================================

ALTER PROCEDURE [dbo].[PM_QRY_Intake_LookupText5] 
	@Barcode nvarchar(50)=null
AS

	SELECT     Distinct LookupText5 
	FROM         dbo.PM_VW_Goodsintake
	WHERE     (Barcode  = @Barcode and @Barcode IS NOT NULL)

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Intake_LookupText4')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Intake_LookupText4] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 24/8/2010
-- Description:	Get LookupText1 for intake record
-- Version:	1
-- =============================================
-- JF TFS 103929
-- =============================================

ALTER PROCEDURE [dbo].[PM_QRY_Intake_LookupText4] 
	@Barcode nvarchar(50)=null
AS

	SELECT     Distinct LookupText4 
	FROM         dbo.PM_VW_Goodsintake
	WHERE     (Barcode  = @Barcode and @Barcode IS NOT NULL)

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Intake_LookupText3')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Intake_LookupText3] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 24/8/2010
-- Description:	Get LookupText1 for intake record
-- Version:	1
-- =============================================
-- JF TFS 103929
-- =============================================

ALTER PROCEDURE [dbo].[PM_QRY_Intake_LookupText3] 
	@Barcode nvarchar(50)=null
AS

	SELECT     Distinct LookupText3 
	FROM         dbo.PM_VW_Goodsintake
	WHERE     (Barcode  = @Barcode and @Barcode IS NOT NULL)

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Intake_LookupText2')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Intake_LookupText2] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 24/8/2010
-- Description:	Get LookupText1 for intake record
-- Version:	1
-- =============================================
-- JF TFS 103929
-- =============================================

ALTER PROCEDURE [dbo].[PM_QRY_Intake_LookupText2] 
	@Barcode nvarchar(50)=null
AS

	SELECT     Distinct LookupText2 
	FROM         dbo.PM_VW_Goodsintake
	WHERE     (Barcode  = @Barcode and @Barcode IS NOT NULL)

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Intake_LookupText1')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Intake_LookupText1] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 24/8/2010
-- Description:	Get LookupText1 for intake record
-- Version:	1
-- =============================================
-- JF TFS 103929
-- =============================================

ALTER PROCEDURE [dbo].[PM_QRY_Intake_LookupText1] 
	@Barcode nvarchar(50)=null
AS

	SELECT     Distinct LookupText1 
	FROM         dbo.PM_VW_Goodsintake
	WHERE     (Barcode  = @Barcode and @Barcode IS NOT NULL)

GO




PRINT 'Database updated successfully!'
GO

