-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO



	IF NOT EXISTS (SELECT * FROM sys.tables t INNER JOIN sys.columns c ON t.object_id = c.object_id WHERE t.name = 'APP_Config' AND c.name = 'IsEditable' )
	BEGIN 
		ALTER TABLE APP_Config 
			ADD IsEditable bit NULL CONSTRAINT DF_AppConfig_IsEditable DEFAULT (0)
	END
GO


IF NOT EXISTS (SELECT * FROM sys.tables WHERE name = N'APP_EULA')
BEGIN

CREATE TABLE [dbo].[APP_EULA](
	[EULAID] [int] IDENTITY(1,1) NOT NULL,
	[Version] [varchar](10) COLLATE Latin1_General_CI_AS NOT NULL,
	[Created] [datetime] NOT NULL,
PRIMARY KEY CLUSTERED 
(
	[EULAID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]

END

GO

SET IDENTITY_INSERT dbo.APP_EULA ON

IF NOT EXISTS (SELECT EULAID FROM APP_EULA WHERE EULAID = 1)
BEGIN
	INSERT INTO [dbo].[APP_EULA]
			   ([EULAID], [Version],[Created])
		 VALUES
			   (1,1,23-03-2018)
END

SET IDENTITY_INSERT dbo.APP_EULA OFF


-- BEGIN DATA Udpate 1st eula version to gdpr start date
BEGIN TRY
UPDATE APP_EULA
SET Created = Convert(datetime, '25-May-2018')
where EULAID = 1
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA Udpate 1st eula version to gdpr start date', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA Udpate 1st eula version to gdpr start date


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'QMS_User' AND COLUMN_NAME = 'EULAID')
BEGIN
	ALTER TABLE [QMS_User]
	ADD [EULAID] int null
END

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'QMS_User' AND COLUMN_NAME = 'EULADateAccepted')
BEGIN
	ALTER TABLE [QMS_User]
	ADD [EULADateAccepted] datetime null
END


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'UP_User_EULAAccepted')
	EXEC ('CREATE PROCEDURE [dbo].[UP_User_EULAAccepted] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Taj Sehdev
-- Create date: 20-03-2018
-- Description:	Update QMS User with EULA accepted for user
-- Version:		1
-- =============================================
-- TS TFS 95261: Created
-- =============================================
ALTER PROCEDURE UP_User_EULAAccepted
	-- Add the parameters for the stored procedure here
	@UserID int,
	@Accepted bit,
	@DateAccepted datetime
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
	IF (@Accepted = 1)
	BEGIN
		UPDATE QMS_User
		SET EULAID = (Select MAX(EULAID) FROM APP_EULA),
		EULADateAccepted = @DateAccepted
		WHERE UserID = @UserID
	END
END
GO


-- BEGIN DATA EnforceEULAAcceptance_95262

IF NOT EXISTS (
	SELECT ac.[Description]
	FROM dbo.APP_Config ac
	WHERE ac.OptionID = 153)
BEGIN
	SET IDENTITY_INSERT dbo.APP_Config ON
	INSERT INTO dbo.APP_Config (
		OptionID
		, OptionTitle		
		, [Description]		
		, [GUID]
		, Created
		, IsEditable
		, OptionValue
	)
	VALUES (
		153
		, 'EnforceEULAAcceptance'		
		, '1 = Prevent users logging in without having accepted the most recent EULA'
		, 'B5A5C872-C743-43C6-9E8B-9670B31D156C'
		, 1
		, 1
		, 0
	)
	SET IDENTITY_INSERT dbo.APP_Config OFF
END
GO
-- END DATA EnforceEULAAcceptance_95262



-- BEGIN [dbo].[QMS_Attachment_GreenlightStorageId]
IF COL_LENGTH('QMS_Attachment', 'GreenlightStorageId') IS NULL
BEGIN
	ALTER TABLE QMS_Attachment
	ADD GreenlightStorageId uniqueidentifier 
END
-- END [dbo].[QMS_Attachment_GreenlightStorageId]


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_Attachment')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_Attachment] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 01/09/2008
-- Description:	Saves attachment
-- Version:		9
-- =============================================
-- SF TFS 7843 - updated for Entity Framework
-- JT TFS 13-3861 - add ability to add temp attachments to an object. If they are left for 24 hours as temporary, then they will get removed.
                  -- and update SourceObjectId from zero to good value.
-- MartinP TFS 13 - 36259 - Changed the Update on QMS_Attachment to improve performance
-- PH TFS 13-56707: v6 20/09/2016 - Added functionality to update QMS_Response.HasAttachments
-- PH TFS 13-56707: v7 20/09/2016 - Add defensive code to capture SourceObjectID from update output
-- PH TFS 13-57025: v8 20/09/2016 - Make the previous version do what it should do.  Updates to OUPUT commands, did not include.
-- SS TFS 13-89602: v9 08/03/2018 - Added Greenlight storage id
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_Attachment]
	@AttachmentID int = NULL,
	@AttachmentSourceID int,
	@SourceObjectID int,
	@AttachmentTitle nvarchar(255),
	@AttachmentFileName nvarchar(100),
	@Attachment image,
	@AttachmentURL nvarchar(255),
	@UserID int,
	@IsTemp bit = 0,
	@GreenlightStorageId uniqueidentifier = null
AS

SET NOCOUNT ON;

-- remove (and empty out) old temp attachments
UPDATE QMS_Attachment 
SET RecordStatus = 201, Attachment = NULL, Updated = GETUTCDATE(), Deleted = GETUTCDATE()
WHERE AttachmentID IN (
	SELECT AttachmentID FROM (
		SELECT AttachmentID, DATALENGTH(Attachment) AS AttachmentLength
		FROM QMS_Attachment
		WHERE RecordStatus = 100						-- Only remove TEMP attachments
		AND Inserted < dateadd(hour, -24, getdate())	-- older than a day.
	) AS AttachmentTable
	WHERE AttachmentLength IS NOT NULL
)

DECLARE @update TABLE (AttachmentID int, AttachmentSourceID int, SourceObjectID int);

IF ISNULL(@AttachmentID,0)=0 --New record
BEGIN
	INSERT INTO QMS_Attachment	(AttachmentSourceID, SourceObjectID, AttachmentTitle, AttachmentFileName, Attachment, AttachmentURL, UserID, RecordStatus, GreenlightStorageId)
	OUTPUT
		INSERTED.AttachmentID,
		INSERTED.AttachmentSourceID,
		INSERTED.SourceObjectID
	INTO @update
	VALUES     (@AttachmentSourceID, @SourceObjectID, @AttachmentTitle, @AttachmentFileName, @Attachment, @AttachmentURL, @UserID, CASE WHEN @IsTemp = 1 THEN 100 ELSE 2 END, @GreenlightStorageId);

	--Get new ID
	SELECT @AttachmentID = AttachmentID FROM @update;
END
ELSE --Update record
BEGIN
	UPDATE      QMS_Attachment
	SET         AttachmentTitle = @AttachmentTitle, 
				AttachmentFileName = @AttachmentFileName, 
				Attachment = @Attachment, 
				AttachmentURL = @AttachmentURL,
				RecordStatus = CASE WHEN @IsTemp = 1 THEN 100 ELSE 2 END,
				SourceObjectID = CASE WHEN SourceObjectID = 0 THEN @SourceObjectID ELSE SourceObjectID END, -- Only change from zero to good value, not backwards.
				UserID = @UserID, 
				MachineName = HOST_NAME(), 
				Updated = GETUTCDATE(),
				GreenlightStorageId = @GreenlightStorageId
	OUTPUT
		INSERTED.AttachmentID,
		INSERTED.AttachmentSourceID,
		INSERTED.SourceObjectID
	INTO @update
	WHERE     (AttachmentID = @AttachmentID);
END

-- Update QMS_Response.HasAttachments
SELECT -- Re-assign parameters
	@AttachmentSourceID = AttachmentSourceID,
	@SourceObjectID = SourceObjectID
FROM @update

IF(@AttachmentSourceID = 1) -- Attachment source is a Response
BEGIN
	UPDATE QMS_Response
	SET
		HasAttachments = 1,
		Updated = GETUTCDATE()
	WHERE ResponseID = @SourceObjectID;
END

SET NOCOUNT OFF;

SELECT @AttachmentID as AttachmentID;
GO

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FNC_Response_StockCodeID]') AND xtype in (N'FN', N'IF', N'TF'))
     DROP FUNCTION [dbo].[FNC_Response_StockCodeID]
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_Response_StockCodeID')
	EXEC('CREATE FUNCTION [dbo].[FNC_Response_StockCodeID]() RETURNS TABLE AS RETURN (SELECT 1 y)')
GO
-- =============================================
-- Author:		MarkP, MartinP, TimC
-- Create date: 25/03/2009
-- Description:	Gets stock code id for response
-- Version:		8
-- =============================================
-- JT TFS 7830 - Also link through raw stockcode datalookup
-- JE TFS 8684 - added filter so deleted Header items are ignored
-- MP TFS 12720: Added check on ResponseID to mitigate duplicates
-- JF TFS 15314 - timeout issues - changed duplicate check to an outer join (Greencell had 100k records in @ResponseHeader)
-- TC TFS 87211 - Re-written to remove the wrapper and improve performance
-- JF TFS 95146 - updated to make sure we pick up the stockcodeid rather than the Consignmentitemid (and remove duplicates)
--                COPIED FROM FNC_ResponseHeader_StockCodeID FOR HOTFIX
-- TC TFS 95787 - Create new function with parameters to avoid parameter sniffing when using external parameters
-- MartinP TFS 13-13907 Made into single use function for use with CROSS APPLY
-- JT TFS 95841 - Merged into FNC_Response_StockCodeID (identical functionality)
-- =============================================
/*
    Example call:
    SELECT * FROM [dbo].[FNC_Response_StockCodeID](316)
*/
-- =============================================
ALTER FUNCTION [dbo].[FNC_Response_StockCodeID] 
(
	@ResponseID int
)
RETURNS TABLE
AS
RETURN 
SELECT	ResponseID, 
		StockCodeID
FROM (
		SELECT  R.ResponseID,
				ROW_NUMBER() OVER (
					PARTITION BY R.ResponseID 
					ORDER BY	CASE	WHEN AH.DataLookupID = 8	THEN 3		-- GoodsIntake (lowest precedence)
										WHEN AH.DataLookupID = 6	THEN 2		-- Consigment  
																	ELSE 1 END,	-- Stockcode or raw stockcode (highest precedence)
								AH.ListIndex,
								RH.ResponseHeaderID
				) AS row_order,
		CASE WHEN AH.DataLookupID in (6,8) THEN COALESCE(CI_Direct.StockCodeID, CI.StockCodeID) 
             ELSE RH.Header_SourceID END AS StockCodeID --make sure we only pick up the Header_SourceID when its a stockcodeid
      FROM QMS_Response R
      JOIN QMS_ResponseHeader RH ON R.ResponseID = RH.ResponseID
      JOIN QMS_AssessmentHeader AH ON RH.AssessmentHeaderID = AH.AssessmentHeaderID

          LEFT JOIN PM_VW_GoodsIntake GI ON RH.Header_SourceID = GI.GoodsIntakeID AND AH.DataLookupID = 8
                     LEFT OUTER JOIN PM_VW_ConsignmentItems CI ON GI.ConsignmentItemID = CI.ConsignmentItemID 
          LEFT JOIN PM_VW_ConsignmentItems CI_Direct ON CI_Direct.ConsignmentItemID = RH.Header_SourceID AND AH.DataLookupID = 6

     WHERE R.RecordStatus < 201
       AND RH.Header_SourceID IS NOT NULL
       AND AH.DataTypeID = 9
       AND AH.DataLookupID IN (2, 35, 6, 8) -- stockcode, raw stockcode, POitem (consignment item), intake
       AND AH.RecordStatus < 201
       AND R.ResponseId = @ResponseId
	) AS tmp
WHERE tmp.row_order = 1
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_Response_UserList')
	EXEC('CREATE FUNCTION [dbo].[FNC_Response_UserList]() RETURNS TABLE AS RETURN (SELECT 1 y)')
GO
-- =============================================
-- Author:		Markp
-- Create date: 16/09/2009
-- Description:	Gets all users that should be notified for a check
-- Version:		8
-- =============================================
-- JE updated 10/01/2012 - Added filter by Business Group
-- JT TFS 4194 - 14/08/2012 - when @StockCodeID is null, we don't want to filter out users with 
--							  stockcode/sub-group/business unit permissions
-- MP TFS 6422 - fix to handle supplier site permissions
-- JE TFS 8956: alerts no longer go to all Supplier users when no Supplier captured in header
-- TC Re-written to make more performant for larger data sets.
/*
    Example call:
    SELECT * FROM [dbo].[FNC_Response_UserList](336) ORDER BY UserId
*/
-- JT TFS 95216: suppliersite permissions being picked up in error
-- TC TFS 95787: Use new responseheader_stockcode function to prevent parameter sniffing.
-- JT TFS 95842: Use merged fnc_response_Stockcode function.
-- =============================================
ALTER FUNCTION [dbo].[FNC_Response_UserList] 
(
	@ResponseID int
)
RETURNS TABLE 
AS
RETURN
    SELECT DISTINCT U.UserId
      FROM QMS_User U
     WHERE 1=1
       
       --Get stock code from response header, consignment item and delivery item 
       AND (NOT EXISTS (SELECT * 
                         FROM VW_PermissionLink PL1 
                        WHERE U.UserID = PL1.UserID 
                          AND PL1.PermissionAllow = 1 
                          AND PL1.StockCodeID IS NOT NULL 
                          AND PL1.PermissionType IN (101,102,103,104,105,106) 
                          --Only do this if we have a stock code
                          AND (SELECT COUNT(*) 
                                 FROM dbo.FNC_Response_StockCodeID(@ResponseId) A 
                                ) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL2 
                          INNER JOIN dbo.FNC_Response_StockCodeID(@ResponseId) STK 
                               ON PL2.StockCodeID = STK.StockCodeID 
                               AND PL2.PermissionType = 104 --Stock Code Permission Type
                               AND PL2.UserID = U.UserID))
      
       --Get location from response header
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL3 
                         WHERE U.UserID = PL3.UserID 
                           AND PL3.PermissionAllow = 1 
                           AND PL3.LocationID IS NOT NULL 
                           AND PL3.PermissionType IN (1, 101,102,103,104,105,106) 
                           --Only do this if we have a location
                           AND (SELECT COUNT(*) 
                                  FROM dbo.FNC_ResponseHeader_LocationID() B 
                                 WHERE B.ResponseId = @ResponseId) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL4 
                          JOIN dbo.FNC_ResponseHeader_LocationID() LOC 
                               ON PL4.LocationID = LOC.LocationID 
                               AND LOC.ResponseId = @ResponseId 
                               AND PL4.PermissionType = 103 --Location Permission Type
                               AND PL4.UserID = U.UserID))
        
       --Get supplier from response header
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL5 
                         WHERE U.UserID = PL5.UserID 
                           AND PL5.PermissionAllow = 1 
                           AND PL5.SupplierID IS NOT NULL 
                           AND PL5.PermissionType IN (101,102,103,104,105,106))
                           --No restriction for Supplier to exist in the header to accomodate TFS 8956.
            --All Supplier users aren't notified when no Supplier captured
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL6 
                          JOIN dbo.FNC_ResponseHeader_SupplierID() SUP 
                               ON PL6.SupplierID = SUP.SupplierID 
                               AND SUP.ResponseId = @ResponseId 
                               AND PL6.PermissionType = 101 --Supplier Permission Type
                               AND PL6.UserID = U.UserID))
     
       --Get customer from response header
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL7 
                         WHERE U.UserID = PL7.UserID 
                           AND PL7.PermissionAllow = 1 
                           AND PL7.CustomerID IS NOT NULL 
                           AND PL7.PermissionType IN (101,102,103,104,105,106) 
                           --Only do this if we have a customer
                           AND (SELECT COUNT(*) 
                                  FROM dbo.FNC_ResponseHeader_CustomerID() D 
                                 WHERE D.ResponseId = @ResponseId) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL8 
                          JOIN dbo.FNC_ResponseHeader_CustomerID() CUS 
                               ON PL8.CustomerID = CUS.CustomerID 
                               AND CUS.ResponseId = @ResponseId 
                               AND PL8.PermissionType = 102 --Customer Permission Type
                               AND PL8.UserID = U.UserID))
      
       --Get supplier site from response header
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL9 
                         WHERE U.UserID = PL9.UserID 
                           AND PL9.PermissionAllow = 1 
                           AND PL9.LocationID IS NOT NULL 
                           AND PL9.PermissionType IN (101,102,103,104,105,106) 
                           --Only do this if we have a supplier
                           AND (SELECT COUNT(*) 
                                  FROM dbo.FNC_ResponseHeader_SupplierSiteID() E 
                                 WHERE E.ResponseId = @ResponseId) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL10 
                          JOIN dbo.FNC_ResponseHeader_SupplierSiteID() SUPS 
                               ON PL10.LocationID = SUPS.LocationID 
                               AND SUPS.ResponseId = @ResponseId 
                               AND PL10.PermissionType = 103 --Supplier Site Permission Type
                               AND PL10.UserID = U.UserID))
         
       --Get customer assigned to stock code
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL11 
                         WHERE U.UserID = PL11.UserID 
                           AND PL11.PermissionAllow = 1 
                           AND PL11.CustomerID IS NOT NULL 
                           --Only do this if we have a customer
                           AND (SELECT COUNT(*) 
                                  FROM dbo.FNC_ResponseHeader_CustomerID() F 
                                 WHERE F.ResponseId = @ResponseId) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL12 
                          JOIN PM_VW_StockCode SC1 
                               ON U.UserID = PL12.UserID 
                               AND PL12.PermissionType = 102 --Customer Permission Type (again)
                               AND PL12.CustomerID = SC1.CustomerID 
                               AND EXISTS(SELECT * 
                                            FROM dbo.FNC_Response_StockCodeID(@ResponseId) STK2 
                                           WHERE SC1.StockCodeID = STK2.StockCodeID 
                                            )))

       --accomodate TFS 2565 by joining to PM_VW_StockCode then onto FNC_ResponseHeader_StockCodeID function
       -----------------------------------------------------------------------------------------------------------------
       --Get Business Group from Stock Code
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL13 
                         WHERE U.UserID = PL13.UserID 
                           AND PL13.PermissionAllow = 1 
                           AND PL13.BusinessGroup IS NOT NULL 
                           --Only do this if we have a Business Group
                           AND (SELECT COUNT(*) 
                                  FROM dbo.FNC_Response_StockCodeID(@ResponseId) F 
                                 ) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL14 
                          INNER MERGE JOIN PM_VW_StockCode SC2 
                               ON U.UserID = PL14.UserID 
                               AND PL14.PermissionType = 106 --Business Group Permission Type
                               AND PL14.BusinessGroup = SC2.BusinessGroup 
                               AND EXISTS(SELECT * 
                                            FROM dbo.FNC_Response_StockCodeID(@ResponseId) STK3 
                                           WHERE SC2.StockCodeID = STK3.StockCodeID 
                                             )))
 
       --Get Stock Code Sub Group from Stock Code
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL15 
                         WHERE U.UserID = PL15.UserID 
                           AND PL15.PermissionAllow = 1 
                           AND PL15.StockCodeSubGroup IS NOT NULL 
                           --Only do this if we have a Stock Code Sub Group
                           AND (SELECT COUNT(*) 
                                  FROM dbo.FNC_Response_StockCodeID(@ResponseId) G 
                                 ) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL16 
                          JOIN PM_VW_StockCode SC3 
                               ON U.UserID = PL16.UserID 
                               AND PL16.PermissionType = 105 --Stock Code Sub Group Permission Type
                               AND PL16.StockCodeSubGroup = SC3.StockCodeSubGroup 
                               AND EXISTS (SELECT * 
                                             FROM dbo.FNC_Response_StockCodeID(@ResponseId) STK4 
                                            WHERE SC3.StockCodeID = STK4.StockCodeID 
                                              )))

       -----------------------------------------------------------------------------------------------------------------
       AND U.LeftCompany = 0
       AND U.RecordStatus < 201
GO


IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_ResponseHeader_StockCodeID_ResponseId')
	EXEC('DROP FUNCTION [dbo].[FNC_ResponseHeader_StockCodeID_ResponseId]')
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_ArrivalItemCount_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_ArrivalItemCount_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 27/08/09
-- Description:	Lookup the Arrival quantity
-- Version:	2
-- Unit test:	PM_QRY_ArrivalItemCount_Lookup_TEST.sql
-- =============================================
-- JF TFS 92520 - Generic Integration -  Change Quantity Received lookup to read from PO data if intake data does not exist  
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_ArrivalItemCount_Lookup] 
	@GoodsIntakeID int = null,
	@Barcode nvarchar(50) = NULL,
	@ConsignmentItemID INT = null,
	@StockCodeID  INT = null,
	@ConsignmentID INT = null
AS

IF @Barcode IS NOT NULL 
	SELECT     ItemCount
	FROM         PM_VW_GoodsIntake
	WHERE     (Barcode = @Barcode)
	
ELSE IF @ConsignmentItemID IS NOT NULL and exists(select * from APP_DataLookupTrigger where datalookupid_Trigger = 6 and DataLookupID_Update = 17 and enabled = 1)
	SELECT  QuantityReceived
	FROM PM_VW_ConsignmentItems
	WHERE ConsignmentItemID = @ConsignmentItemID

ELSE IF @StockCodeID IS NOT NULL and @ConsignmentID IS NOT NULL AND exists(select * from APP_DataLookupTrigger where datalookupid_Trigger = 2 and DataLookupID_Update = 17 and enabled = 1)
	SELECT  SUM(QuantityReceived) as QuantityReceived
	FROM PM_VW_ConsignmentItems
	WHERE ConsignmentID = @ConsignmentID and StockCodeID = @StockCodeID

ELSE IF @GoodsIntakeID IS NOT NULL
	SELECT     ItemCount
	FROM         PM_VW_GoodsIntake
	WHERE     (GoodsIntakeID = @GoodsIntakeID)
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Attachment_List')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Attachment_List] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================  
-- Author:  Markp  
-- Create date: 01/09/2008  
-- Description: Gets all attachments for selected assessment response  
-- Version:  6  
-- =============================================  
-- JE TFS 6272 - returns Child Check Attachments if using Multi Checks  
-- MP CAS-24522-Q0B8J9 - fix to prevent blank attachments from making the CA screen raise an error  
-- JT TFS-13-3861: Return IsTemp to front end, and hide temp attachments which are empty.  
-- JT TFS 13-75874: Show attachments for a response even if it contains child attachments, but hide duplicates.  
-- SS TFS 13-89512: GreenlightStorageId included in select statements
-- =============================================  
ALTER PROCEDURE [dbo].[QRY_Attachment_List]   
 @SourceID int,  
 @SourceObjectID int,  
 @UserID int = 0  
AS  
BEGIN  
 IF @SourceID = 1 --Assessment Response Attachment  
 BEGIN  
  --get ParentResponseGUID for ResponseID passed in  
  DECLARE @ParentResponseGUID uniqueidentifier  
  SELECT @ParentResponseGUID = GUID  
  FROM QMS_Response  
  WHERE ResponseID = @SourceObjectID  
  
  --temp table to hold Child Check ResponseIDs  
  IF NULLIF(object_id('tempdb..#tmpChildChecks'), 0) IS NOT NULL DROP TABLE #tmpChildChecks  
  CREATE TABLE #tmpChildChecks (ResponseID int)  
  --get all Child Checks for above GUID  
  INSERT #tmpChildChecks (ResponseID)  
  SELECT ResponseID  
  FROM QMS_Response  
  WHERE ParentResponseGUID = @ParentResponseGUID  
   
  -- We need to eliminate duplicates. Sometimes a parent check will have a copy of a child check's attachment after an approval.  
  IF NULLIF(object_id('tempdb..#tmpAttachments'), 0) IS NOT NULL DROP TABLE #tmpAttachments  
  SELECT AttachmentID,   
    GETCHECKSUM(Attachment) AS AttachmentCheckSum,   
    AttachmentFileName, RecordStatus, UserID,   
    convert(bit, 0) AS HasChildDuplicate,  
    CASE WHEN SourceObjectID = @SourceObjectID THEN 1 ELSE 0 END AS IsParentAttachment  
  INTO #tmpAttachments  
  FROM QMS_Attachment  
  WHERE AttachmentSourceID = @SourceID  
  AND (  
   SourceObjectID = @SourceObjectID   
   OR  
   SourceObjectID IN (SELECT ResponseID FROM #tmpChildChecks)  
  )  
  
  UPDATE parent  
  SET HasChildDuplicate = 1  
  FROM #tmpAttachments AS parent  
  WHERE EXISTS ( SELECT * FROM #tmpAttachments AS child   
      WHERE parent.AttachmentFileName = child.AttachmentFileName  
      AND parent.AttachmentCheckSum = child.AttachmentCheckSum  
      AND parent.AttachmentID <> child.AttachmentID)  
  AND parent.IsParentAttachment = 1  
    
  --get Child Check count  
  DECLARE @ChildCheckCount int  
  SELECT @ChildCheckCount = COUNT(ResponseID) FROM #tmpChildChecks  
    
  SELECT     AttachmentID, AttachmentSourceID, SourceObjectID, AttachmentTitle, AttachmentFileName, Attachment, AttachmentURL, IsTemp = convert(bit, CASE WHEN RecordStatus = 100 OR SourceObjectID = 0 THEN 1 ELSE 0 END), GreenlightStorageId
  FROM         QMS_Attachment  
  WHERE   AttachmentID IN 
  (  
   SELECT AttachmentID FROM #tmpAttachments  
   WHERE HasChildDuplicate = 0  
   AND (RecordStatus < 100 OR (RecordStatus = 100 AND UserID = @UserID))  
  )  
  
 END  
 ELSE  
 BEGIN  
	SELECT AttachmentID, AttachmentSourceID, SourceObjectID, AttachmentTitle, AttachmentFileName, Attachment, AttachmentURL, IsTemp = convert(bit, CASE WHEN RecordStatus = 100 OR SourceObjectID = 0 THEN 1 ELSE 0 END), GreenlightStorageId
	FROM QMS_Attachment  
	WHERE (RecordStatus < 100 OR (RecordStatus = 100 AND UserID = @UserID))   
	AND (AttachmentSourceID = @SourceID)   
	AND (SourceObjectID = @SourceObjectID)  
 END  
END  
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_User_EULA')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_User_EULA] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Taj Sehdev
-- Create date: 20-03-2018
-- Description:	Get User's EULA Status
-- Version:		1
-- =============================================
-- TS TFS 95261: Created
-- =============================================
ALTER PROCEDURE QRY_User_EULA
	-- Add the parameters for the stored procedure here
	@UserID int
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
	SELECT EULAID, EULADateAccepted
	FROM QMS_User
	WHERE UserID = @UserID
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_Response_AttachmentImages')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_Response_AttachmentImages] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================    
-- Author:  Markp    
-- Create date: 12/03/2009    
-- Description: Gets attachment data for check images    
-- Version:  6
-- =============================================    
-- MP TFS 5658 - added images linked to corrective actions    
-- MartinP TFS 13-45992 - Removed CROSS JOIN by splitting out into temporary tables  
-- MartinP TFS 13- 72418 - Added ORDER BY QMS_Attachment.Inserted DESC to final select statement   
-- MartinP TFS 13 - 72826 - Corrected ORDER BY Statement to sort by ASC (default behaviour of ORDER BY)  
-- SS TFS 13-96838 - GreenlightStorageId returned in select statement
-- =============================================    
ALTER PROCEDURE [dbo].[RPT_Response_AttachmentImages]     
 @UserID int     
AS    
BEGIN    
    
 SET NOCOUNT ON    
    
 DECLARE @ResponseCATable TABLE (ResponseID INT, CorrectiveActionID INT)    
    
 INSERT INTO @ResponseCATable (ResponseID, CorrectiveActionID)    
  SELECT SelectedID,NULL     
  FROM TEMP_Selected    
  WHERE UserID = @UserID    
    
 UPDATE    ResponseCATable    
 SET          CorrectiveActionID = QMS_CorrectiveAction.CorrectiveActionID    
 FROM         QMS_CorrectiveAction     
     INNER JOIN @ResponseCATable AS ResponseCATable ON QMS_CorrectiveAction.SourceObjectID = ResponseCATable.ResponseID    
 WHERE     (QMS_CorrectiveAction.CASourceID = 1)     
    
 DECLARE @ResponseAttachTable TABLE (ResponseID INT, AttachmentID INT)    
 INSERT INTO @ResponseAttachTable (ResponseID,AttachmentID)    
 SELECT ResponseCATable.ResponseID, AttachmentID    
 FROM @ResponseCATable AS ResponseCATable    
 INNER JOIN QMS_Attachment ON ResponseCATable.ResponseID = QMS_Attachment.SourceObjectID    
 WHERE      (QMS_Attachment.AttachmentSourceID = 1)     
    AND (QMS_Attachment.RecordStatus < 201)     
    AND (QMS_Attachment.AttachmentFileName IS NOT NULL)     
    AND (LOWER(RIGHT(QMS_Attachment.AttachmentFileName, 3)) IN ('jpg', 'bmp', 'gif', 'png'))     
    AND (QMS_Attachment.SourceObjectID = ResponseCATable.ResponseID)    
       
 INSERT INTO @ResponseAttachTable (ResponseID,AttachmentID)    
 SELECT ResponseCATable.ResponseID, AttachmentID    
 FROM @ResponseCATable AS ResponseCATable    
 INNER JOIN QMS_Attachment ON ResponseCATable.ResponseID = QMS_Attachment.SourceObjectID    
    AND (QMS_Attachment.AttachmentSourceID = 2)     
    AND (QMS_Attachment.RecordStatus < 201)    
    AND (QMS_Attachment.AttachmentFileName IS NOT NULL)     
    AND (LOWER(RIGHT(QMS_Attachment.AttachmentFileName, 3)) IN ('jpg', 'bmp', 'gif', 'png'))     
    AND (QMS_Attachment.SourceObjectID = ResponseCATable.CorrectiveActionID)    
    
 SET NOCOUNT OFF    
    
 SELECT     ResponseAttachTable.ResponseID,    
      QMS_Attachment.AttachmentTitle,     
      QMS_Attachment.AttachmentFileName,     
      QMS_Attachment.Attachment,      
      QMS_Attachment.AttachmentURL,
	  QMS_Attachment.GreenlightStorageId
 FROM @ResponseAttachTable AS ResponseAttachTable    
 INNER JOIN QMS_Attachment ON ResponseAttachTable.AttachmentID = QMS_Attachment.AttachmentID  
 ORDER BY QMS_Attachment.Inserted     
END    
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_Response_ResponseQuestion_CAImages')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_Response_ResponseQuestion_CAImages] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================  
-- Author:  Jonathan Toolan  
-- Create date: 12/12/2012  
-- Description: Gets attachment data for response question check images  
-- Version:  3  
-- JE TFS 5846: CAs now returned even if they don't have an image attachment  
-- SS TFS 13-96839: GreenlightStorageId returned in select statement
-- =============================================  
ALTER PROCEDURE [dbo].[RPT_Response_ResponseQuestion_CAImages]   
 @UserID int  
AS  
BEGIN -- declare @UserID int = 1  
 SELECT QMS_ResponseQuestion.ResponseID,  
   QMS_CorrectiveAction.SourceObjectID AS ResponseQuestionID,   
   Attachments.AttachmentTitle,   
   Attachments.AttachmentFileName,   
   Attachments.Attachment,   
   Attachments.AttachmentURL,  
   Attachments.GreenlightStorageId,
   QMS_CorrectiveAction.CorrectiveActionID,  
   dbo.FNC_GetCorrectiveActionIncrement(QMS_CorrectiveAction.CorrectiveActionID) as CARef,  
   QMS_CorrectiveAction.CAReason,   
   QMS_CorrectiveAction.CARequired,   
   QMS_CorrectiveAction.CAStatusID,  
   ISNULL(dbo.FNC_ResourceString_User(APP_CorrectiveActionStatus.ResourceName, @UserID), APP_CorrectiveActionStatus.CAStatus) AS CAStatus  
 FROM QMS_ResponseQuestion  
 INNER JOIN QMS_CorrectiveAction ON QMS_ResponseQuestion.ResponseQuestionID = QMS_CorrectiveAction.SourceObjectID AND QMS_CorrectiveAction.CASourceID = 2 --eCorrectiveActionSource.AssessmentQuestion  
 INNER JOIN TEMP_Selected ON QMS_ResponseQuestion.ResponseID = TEMP_Selected.SelectedID AND TEMP_Selected.UserID = @UserID  
 LEFT OUTER JOIN APP_CorrectiveActionStatus ON QMS_CorrectiveAction.CAStatusID = APP_CorrectiveActionStatus.CAStatusID  
 LEFT OUTER JOIN (SELECT AttachmentTitle, AttachmentFileName, Attachment, AttachmentURL, SourceObjectID, AttachmentSourceID, GreenlightStorageId
      FROM QMS_Attachment --sub query to get attachments  
      WHERE (QMS_Attachment.AttachmentFileName IS NOT NULL)   
         AND  (LOWER(RIGHT(QMS_Attachment.AttachmentFileName, 3)) IN ('jpg', 'bmp', 'gif', 'png'))) AS Attachments  
    ON QMS_CorrectiveAction.CorrectiveActionID = Attachments.SourceObjectID AND Attachments.AttachmentSourceID = 2 -- eAttachmentSource.CorrectiveAction  
 WHERE QMS_ResponseQuestion.RecordStatus < 201  
 AND  QMS_CorrectiveAction.RecordStatus < 201  
 ORDER BY QMS_ResponseQuestion.ResponseID,   
    Attachments.SourceObjectID  
END  
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_ResponseSummary_Attachments')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_ResponseSummary_Attachments] AS SELECT ''stub version, to be replaced''')
GO

-- =============================================  
-- Author:  Adam C  
-- Create date: 20/02/15  
-- Description: Gets attachment data for QC summary report  
-- Version:  3 
-- =============================================  
-- JT TFS 79337 - Add MaxAttachmentsAllowed variable to make later changes easier.  
-- SS TFS 89593 - GreenlightStorageId is returned within query
-- =============================================  
ALTER PROCEDURE [dbo].[RPT_ResponseSummary_Attachments]  
(  
 @UserID INTEGER  
)   
AS  
BEGIN  
 SET NOCOUNT ON  
  
 DECLARE @MaxAttachmentsAllowed int   
 SELECT @MaxAttachmentsAllowed = dbo.FNC_GetOptionValue(148) -- ResponseSummaryMaxAttachments  
 -- Note: The unspecified default value is also hard-coded in QCSummaryReportController.cs for display purposes only.  
 IF @MaxAttachmentsAllowed IS NULL SET @MaxAttachmentsAllowed = 20  
 IF @MaxAttachmentsAllowed < 0 SET @MaxAttachmentsAllowed = 0  
  
 DECLARE @AttachmentCount INTEGER   
 SELECT @AttachmentCount = ( SELECT COUNT(AttachmentID) FROM QMS_Attachment   
        WHERE SourceObjectID IN (SELECT SelectedID FROM TEMP_Selected   
              WHERE UserID = @UserID)   
        AND QMS_Attachment.RecordStatus < 100)  
  
 DECLARE @Attachments TABLE (  
  RowNumber INTEGER,   
  SourceObjectID INTEGER,   
  AttachmentTitle NVARCHAR(MAX),   
  AttachmentFileName NVARCHAR(MAX),   
  Attachment IMAGE,   
  AttachmentID INTEGER,   
  OriginalRow BIT,
  GreenlightStorageId uniqueidentifier
 )  
 INSERT INTO @Attachments  
 SELECT TOP (@MaxAttachmentsAllowed)   
      ROW_NUMBER() OVER (ORDER BY APP_AssessmentType.ListIndex, QMS_Assessment.AssessmentName, QMS_Response.EndDate) AS RowNumber,  
      SourceObjectID,   
      AttachmentTitle,   
      AttachmentFileName,   
      Attachment,  
      AttachmentID,  
      1,
	  GreenlightStorageId
 FROM QMS_Attachment  
 INNER JOIN QMS_Response ON QMS_Response.ResponseID = QMS_Attachment.SourceObjectID  
 INNER JOIN QMS_Assessment ON QMS_Assessment.AssessmentID = QMS_Response.AssessmentID   
 INNER JOIN APP_AssessmentType ON APP_AssessmentType.AssessmentTypeID = QMS_Assessment.AssessmentTypeID  
 WHERE SourceObjectID IN ( SELECT SelectedID FROM TEMP_Selected   
        WHERE UserID = @UserID)  
        AND QMS_Attachment.RecordStatus < 100  
 ORDER BY APP_AssessmentType.ListIndex, QMS_Assessment.AssessmentName, QMS_Response.EndDate  
  
 -- So that two attachments are next to each other.  
 UPDATE @Attachments  
 SET RowNumber = RowNumber - 1, OriginalRow = 0  
 WHERE RowNumber % 2 = 0  
  
 SET NOCOUNT OFF  
  
 SELECT A1.SourceObjectID AS A1SourceObjectID,   
     A1.AttachmentTitle AS A1AttachmentTitle,   
     A1.AttachmentFileName AS A1AttachmentFileName,   
     A1.Attachment AS A1Attachment,
	 A1.GreenlightStorageId As A1GreenlightStorageId,
     CASE WHEN A1.AttachmentID IS NULL THEN NULL  
     ELSE 'Check No: ' + CAST(A1.SourceObjectID AS NVARCHAR(255)) + ' - ' + A1.AttachmentFileName  
     END AS A1Title,  
     A2.SourceObjectID AS A2SourceObjectID,   
     A2.AttachmentTitle AS A2AttachmentTitle,   
     A2.AttachmentFileName AS A2AttachmentFileName,   
     A2.Attachment AS A2Attachment,  
	 A2.GreenlightStorageId AS A2GreenlightStorageId,
     CASE WHEN A2.AttachmentID IS NULL THEN NULL  
     ELSE 'Check No: ' + CAST(A2.SourceObjectID AS NVARCHAR(255)) + ' - ' + A2.AttachmentFileName  
     END AS A2Title,  
     @AttachmentCount AS FullAttachmentCount,  
     @MaxAttachmentsAllowed AS MaxAttachmentsAllowed  
 FROM @Attachments A1   
 LEFT JOIN @Attachments A2 ON A1.RowNumber = A2.RowNumber AND A1.AttachmentID <> A2.AttachmentID  
 WHERE A1.OriginalRow = 1  
  
END   
GO




PRINT 'Database updated successfully!'
GO

