-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO


-- BEGIN DATA PM_ConsignmentItems_QuantityReceived 
BEGIN TRY
IF not EXISTS(SELECT * FROM   INFORMATION_SCHEMA.COLUMNS WHERE  TABLE_NAME = 'PM_ConsignmentItems' AND COLUMN_NAME = 'QuantityReceived') 
	BEGIN
		alter table PM_ConsignmentItems add QuantityReceived real
	END

END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA PM_ConsignmentItems_QuantityReceived ', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA PM_ConsignmentItems_QuantityReceived 



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'PM_VW_ConsignmentItems')
	EXEC ('CREATE VIEW [dbo].[PM_VW_ConsignmentItems] AS SELECT 1 as ''stub version, to be replaced''')
GO
--===================================================
-- Author:		Unknown
-- Create date:	1 Jan 2010
-- Description:	View consignments from PM_ConsignmentItems
-- Version:		5
-- ===================================================
-- JF: Added DateRequired column
-- JF: Added E_POItem column
-- jf tfs 19430 - added GUID, RowVersion, Hide, RecordStatus, VersionNo, Created, Updated for sync purposes
-- jf tfs 29101 - added itemstatus
-- jf tfs 92515 - added QuantityReceived
-- ===================================================
ALTER VIEW [dbo].[PM_VW_ConsignmentItems]
AS
SELECT        ConsignmentItemID, ConsignmentID, StockCodeID, Quantity, QuantityAccepted, UnitPrice, UnitQuantity, UnitStockCodeID, DepotDate, Comments, DateRequired, E_POItem, GUID, Hide, RecordStatus, 
                         VersionNo,   ItemStatus,QuantityReceived
FROM            dbo.PM_ConsignmentItems
WHERE        (Hide = 0) AND (RecordStatus < 201)
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_ResponseHeader_StockCodeID_ResponseId')
	EXEC('CREATE FUNCTION [dbo].[FNC_ResponseHeader_StockCodeID_ResponseId]() RETURNS TABLE AS RETURN (SELECT 1 y)')
GO
-- =============================================
-- Author:		Markp
-- Create date: 25/03/2009
-- Description:	Gets stock code id for responses
-- Version:		8
-- =============================================
-- JT TFS 7830 - Also link through raw stockcode datalookup
-- JE TFS 8684 - added filter so deleted Header items are ignored
-- MP TFS 12720: Added check on ResponseID to mitigate duplicates
-- JF TFS 15314 - timeout issues - changed duplicate check to an outer join (Greencell had 100k records in @ResponseHeader)
-- TC TFS 87211 - Re-written to remove the wrapper and improve performance
-- JF TFS 95146 - updated to make sure we pick up the stockcodeid rather than the Consignmentitemid (and remove duplicates)
--                COPIED FROM FNC_ResponseHeader_StockCodeID FOR HOTFIX
-- TC TFS 95787 - Create new function with parameters to avoid parameter sniffing when using external parameters 
-- =============================================
/*
    Example call:
    SELECT * FROM [dbo].[FNC_ResponseHeader_StockCodeID_ResponseId](316)
*/
-- =============================================
ALTER FUNCTION [dbo].[FNC_ResponseHeader_StockCodeID_ResponseId](@ResponseId int)
RETURNS TABLE
AS
RETURN 
SELECT	ResponseID, 
		StockCodeID
FROM (
		SELECT  R.ResponseID,
				ROW_NUMBER() OVER (
					PARTITION BY R.ResponseID 
					ORDER BY	CASE	WHEN AH.DataLookupID = 8	THEN 3		-- GoodsIntake (lowest precedence)
										WHEN AH.DataLookupID = 6	THEN 2		-- Consigment  
																	ELSE 1 END,	-- Stockcode or raw stockcode (highest precedence)
								AH.ListIndex,
								RH.ResponseHeaderID
				) AS row_order,
		CASE WHEN AH.DataLookupID in (6,8) THEN COALESCE(CI_Direct.StockCodeID, CI.StockCodeID) 
             ELSE RH.Header_SourceID END AS StockCodeID --make sure we only pick up the Header_SourceID when its a stockcodeid
      FROM QMS_Response R
      JOIN QMS_ResponseHeader RH ON R.ResponseID = RH.ResponseID
      JOIN QMS_AssessmentHeader AH ON RH.AssessmentHeaderID = AH.AssessmentHeaderID

          LEFT JOIN PM_VW_GoodsIntake GI ON RH.Header_SourceID = GI.GoodsIntakeID AND AH.DataLookupID = 8
                     LEFT OUTER JOIN PM_VW_ConsignmentItems CI ON GI.ConsignmentItemID = CI.ConsignmentItemID 
          LEFT JOIN PM_VW_ConsignmentItems CI_Direct ON CI_Direct.ConsignmentItemID = RH.Header_SourceID AND AH.DataLookupID = 6

     WHERE R.RecordStatus < 201
       AND RH.Header_SourceID IS NOT NULL
       AND AH.DataTypeID = 9
       AND AH.DataLookupID IN (2, 35, 6, 8) -- stockcode, raw stockcode, POitem (consignment item), intake
       AND AH.RecordStatus < 201
       AND R.ResponseId = @ResponseId
	) AS tmp
WHERE tmp.row_order = 1
GO



IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_ResponseHeader_StockCodeID')
	EXEC('DROP FUNCTION [dbo].[FNC_ResponseHeader_StockCodeID]')
GO
-- =============================================
-- Author:		Markp
-- Create date: 25/03/2009
-- Description:	Gets stock code id for responses
-- Version:		7
-- =============================================
-- JT TFS 7830 - Also link through raw stockcode datalookup
-- JE TFS 8684 - added filter so deleted Header items are ignored
-- MP TFS 12720: Added check on ResponseID to mitigate duplicates
-- JF TFS 15314 - timeout issues - changed duplicate check to an outer join (Greencell had 100k records in @ResponseHeader)
-- TC TFS 87211 - Re-written to remove the wrapper and improve performance
-- JF TFS 95146 - updated to make sure we pick up the stockcodeid rather than the Consignmentitemid (and remove duplicates)
-- =============================================
/*
    Example call:
    SELECT * FROM [dbo].[FNC_ResponseHeader_StockCodeID]()
*/
-- =============================================
CREATE FUNCTION [dbo].[FNC_ResponseHeader_StockCodeID]()
RETURNS TABLE
AS
RETURN 
SELECT	ResponseID, 
		StockCodeID
FROM (
		SELECT  R.ResponseID,
				ROW_NUMBER() OVER (
					PARTITION BY R.ResponseID 
					ORDER BY	CASE	WHEN AH.DataLookupID = 8	THEN 3		-- GoodsIntake (lowest precedence)
										WHEN AH.DataLookupID = 6	THEN 2		-- Consigment  
																	ELSE 1 END,	-- Stockcode or raw stockcode (highest precedence)
								AH.ListIndex,
								RH.ResponseHeaderID
				) AS row_order,
		CASE WHEN AH.DataLookupID in (6,8) THEN COALESCE(CI_Direct.StockCodeID, CI.StockCodeID) 
             ELSE RH.Header_SourceID END AS StockCodeID --make sure we only pick up the Header_SourceID when its a stockcodeid
      FROM QMS_Response R
      JOIN QMS_ResponseHeader RH ON R.ResponseID = RH.ResponseID
      JOIN QMS_AssessmentHeader AH ON RH.AssessmentHeaderID = AH.AssessmentHeaderID

          LEFT JOIN PM_VW_GoodsIntake GI ON RH.Header_SourceID = GI.GoodsIntakeID AND AH.DataLookupID = 8
                     LEFT OUTER JOIN PM_VW_ConsignmentItems CI ON GI.ConsignmentItemID = CI.ConsignmentItemID 
          LEFT JOIN PM_VW_ConsignmentItems CI_Direct ON CI_Direct.ConsignmentItemID = RH.Header_SourceID AND AH.DataLookupID = 6

     WHERE R.RecordStatus < 201
       AND RH.Header_SourceID IS NOT NULL
       AND AH.DataTypeID = 9
       AND AH.DataLookupID IN (2, 35, 6, 8) -- stockcode, raw stockcode, POitem (consignment item), intake
       AND AH.RecordStatus < 201

	) AS tmp
WHERE tmp.row_order = 1
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_Response_UserList')
	EXEC('CREATE FUNCTION [dbo].[FNC_Response_UserList]() RETURNS TABLE AS RETURN (SELECT 1 y)')
GO
-- =============================================
-- Author:		Markp
-- Create date: 16/09/2009
-- Description:	Gets all users that should be notified for a check
-- Version:		7
-- =============================================
-- JE updated 10/01/2012 - Added filter by Business Group
-- JT TFS 4194 - 14/08/2012 - when @StockCodeID is null, we don't want to filter out users with 
--							  stockcode/sub-group/business unit permissions
-- MP TFS 6422 - fix to handle supplier site permissions
-- JE TFS 8956: alerts no longer go to all Supplier users when no Supplier captured in header
-- TC Re-written to make more performant for larger data sets.
/*
    Example call:
    SELECT * FROM [dbo].[FNC_Response_UserList](336) ORDER BY UserId
*/
-- JT TFS 95216: suppliersite permissions being picked up in error
-- TC TFS 95787: Use new responseheader_stockcode function to prevent parameter sniffing.
-- =============================================
ALTER FUNCTION [dbo].[FNC_Response_UserList] 
(
	@ResponseID int
)
RETURNS TABLE 
AS
RETURN
    SELECT DISTINCT U.UserId
      FROM QMS_User U
     WHERE 1=1
       
       --Get stock code from response header, consignment item and delivery item 
       AND (NOT EXISTS (SELECT * 
                         FROM VW_PermissionLink PL1 
                        WHERE U.UserID = PL1.UserID 
                          AND PL1.PermissionAllow = 1 
                          AND PL1.StockCodeID IS NOT NULL 
                          AND PL1.PermissionType IN (101,102,103,104,105,106) 
                          --Only do this if we have a stock code
                          AND (SELECT COUNT(*) 
                                 FROM dbo.FNC_ResponseHeader_StockCodeID_ResponseId(@ResponseId) A 
                                --WHERE A.ResponseId = @ResponseId
                                ) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL2 
                          INNER JOIN dbo.FNC_ResponseHeader_StockCodeID_ResponseId(@ResponseId) STK 
                               ON PL2.StockCodeID = STK.StockCodeID 
                               --AND STK.ResponseId = @ResponseId 
                               AND PL2.PermissionType = 104 --Stock Code Permission Type
                               AND PL2.UserID = U.UserID))
      
       --Get location from response header
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL3 
                         WHERE U.UserID = PL3.UserID 
                           AND PL3.PermissionAllow = 1 
                           AND PL3.LocationID IS NOT NULL 
                           AND PL3.PermissionType IN (1, 101,102,103,104,105,106) 
                           --Only do this if we have a location
                           AND (SELECT COUNT(*) 
                                  FROM dbo.FNC_ResponseHeader_LocationID() B 
                                 WHERE B.ResponseId = @ResponseId) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL4 
                          JOIN dbo.FNC_ResponseHeader_LocationID() LOC 
                               ON PL4.LocationID = LOC.LocationID 
                               AND LOC.ResponseId = @ResponseId 
                               AND PL4.PermissionType = 103 --Location Permission Type
                               AND PL4.UserID = U.UserID))
        
       --Get supplier from response header
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL5 
                         WHERE U.UserID = PL5.UserID 
                           AND PL5.PermissionAllow = 1 
                           AND PL5.SupplierID IS NOT NULL 
                           AND PL5.PermissionType IN (101,102,103,104,105,106))
                           --No restriction for Supplier to exist in the header to accomodate TFS 8956.
                           --All Supplier users aren't notified when no Supplier captured
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL6 
                          JOIN dbo.FNC_ResponseHeader_SupplierID() SUP 
                               ON PL6.SupplierID = SUP.SupplierID 
                               AND SUP.ResponseId = @ResponseId 
                               AND PL6.PermissionType = 101 --Supplier Permission Type
                               AND PL6.UserID = U.UserID))
     
       --Get customer from response header
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL7 
                         WHERE U.UserID = PL7.UserID 
                           AND PL7.PermissionAllow = 1 
                           AND PL7.CustomerID IS NOT NULL 
                           AND PL7.PermissionType IN (101,102,103,104,105,106) 
                           --Only do this if we have a customer
                           AND (SELECT COUNT(*) 
                                  FROM dbo.FNC_ResponseHeader_CustomerID() D 
                                 WHERE D.ResponseId = @ResponseId) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL8 
                          JOIN dbo.FNC_ResponseHeader_CustomerID() CUS 
                               ON PL8.CustomerID = CUS.CustomerID 
                               AND CUS.ResponseId = @ResponseId 
                               AND PL8.PermissionType = 102 --Customer Permission Type
                               AND PL8.UserID = U.UserID))
      
       --Get supplier site from response header
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL9 
                         WHERE U.UserID = PL9.UserID 
                           AND PL9.PermissionAllow = 1 
                           AND PL9.LocationID IS NOT NULL 
                           AND PL9.PermissionType IN (101,102,103,104,105,106) 
                           --Only do this if we have a supplier
                           AND (SELECT COUNT(*) 
                                  FROM dbo.FNC_ResponseHeader_SupplierSiteID() E 
                                 WHERE E.ResponseId = @ResponseId) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL10 
                          JOIN dbo.FNC_ResponseHeader_SupplierSiteID() SUPS 
                               ON PL10.LocationID = SUPS.LocationID 
                               AND SUPS.ResponseId = @ResponseId 
                               AND PL10.PermissionType = 103 --Supplier Site Permission Type
                               AND PL10.UserID = U.UserID))
         
       --Get customer assigned to stock code
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL11 
                         WHERE U.UserID = PL11.UserID 
                           AND PL11.PermissionAllow = 1 
                           AND PL11.CustomerID IS NOT NULL 
                           --Only do this if we have a customer
                           AND (SELECT COUNT(*) 
                                  FROM dbo.FNC_ResponseHeader_CustomerID() F 
                                 WHERE F.ResponseId = @ResponseId) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL12 
                          JOIN PM_VW_StockCode SC1 
                               ON U.UserID = PL12.UserID 
                               AND PL12.PermissionType = 102 --Customer Permission Type (again)
                               AND PL12.CustomerID = SC1.CustomerID 
                               AND EXISTS(SELECT * 
                                            FROM dbo.FNC_ResponseHeader_StockCodeID_ResponseId(@ResponseId) STK2 
                                           WHERE SC1.StockCodeID = STK2.StockCodeID 
                                            --AND STK2.ResponseId = @ResponseId
                                            )))

       --accomodate TFS 2565 by joining to PM_VW_StockCode then onto FNC_ResponseHeader_StockCodeID function
       -----------------------------------------------------------------------------------------------------------------
       --Get Business Group from Stock Code
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL13 
                         WHERE U.UserID = PL13.UserID 
                           AND PL13.PermissionAllow = 1 
                           AND PL13.BusinessGroup IS NOT NULL 
                           --Only do this if we have a Business Group
                           AND (SELECT COUNT(*) 
                                  FROM dbo.FNC_ResponseHeader_StockCodeID_ResponseId(@ResponseId) F 
                                 --WHERE F.ResponseId = @ResponseId
                                 ) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL14 
                          INNER MERGE JOIN PM_VW_StockCode SC2 
                               ON U.UserID = PL14.UserID 
                               AND PL14.PermissionType = 106 --Business Group Permission Type
                               AND PL14.BusinessGroup = SC2.BusinessGroup 
                               AND EXISTS(SELECT * 
                                            FROM dbo.FNC_ResponseHeader_StockCodeID_ResponseId(@ResponseId) STK3 
                                           WHERE SC2.StockCodeID = STK3.StockCodeID 
                                             --AND STK3.ResponseId = @ResponseId
                                             )))
 
       --Get Stock Code Sub Group from Stock Code
       AND (NOT EXISTS (SELECT * 
                          FROM VW_PermissionLink PL15 
                         WHERE U.UserID = PL15.UserID 
                           AND PL15.PermissionAllow = 1 
                           AND PL15.StockCodeSubGroup IS NOT NULL 
                           --Only do this if we have a Stock Code Sub Group
                           AND (SELECT COUNT(*) 
                                  FROM dbo.FNC_ResponseHeader_StockCodeID_ResponseId(@ResponseId) G 
                                 --WHERE G.ResponseId = @ResponseId
                                 ) > 0)
             OR EXISTS (SELECT * 
                          FROM VW_PermissionLink PL16 
                          JOIN PM_VW_StockCode SC3 
                               ON U.UserID = PL16.UserID 
                               AND PL16.PermissionType = 105 --Stock Code Sub Group Permission Type
                               AND PL16.StockCodeSubGroup = SC3.StockCodeSubGroup 
                               AND EXISTS (SELECT * 
                                             FROM dbo.FNC_ResponseHeader_StockCodeID_ResponseId(@ResponseId) STK4 
                                            WHERE SC3.StockCodeID = STK4.StockCodeID 
                                              --AND STK4.ResponseId = @ResponseId
                                              )))

       -----------------------------------------------------------------------------------------------------------------
       AND U.LeftCompany = 0
       AND U.RecordStatus < 201

GO




IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_StripCharacters')
	EXEC('CREATE FUNCTION [dbo].[FNC_StripCharacters]() RETURNS bit AS BEGIN RETURN 0 END')
GO
-- =============================================
-- Author:		jeremy formby
-- Create date: 21/2/2018
-- Description:	Can remove characters from a string using a patern match. EG:
-- Alphabetic only:--SELECT dbo.FNC_StripCharacters('a1!s2@d3#f4$', '^a-z')
-- Numeric only:--SELECT dbo.FNC_StripCharacters('a1!s2@d3#f4$', '^0-9')
-- Alphanumeric only:--SELECT dbo.FNC_StripCharacters('a1!s2@d3#f4$', '^a-z0-9')
-- Non-alphanumeric:--SELECT dbo.FNC_StripCharacters('a1!s2@d3#f4$', 'a-z0-9')
-- Version:		1
-- =============================================
-- JF TFS 82326: initial version
-- =============================================
ALTER FUNCTION [dbo].[FNC_StripCharacters]
(
    @String NVARCHAR(MAX), 
    @MatchExpression VARCHAR(255)
)
RETURNS NVARCHAR(MAX)
AS
BEGIN
    SET @MatchExpression =  '%['+@MatchExpression+']%'

    WHILE PatIndex(@MatchExpression, @String) > 0
        SET @String = Stuff(@String, PatIndex(@MatchExpression, @String), 1, '')

    RETURN @String

END
GO







IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_ConsignmentItems')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_ConsignmentItems] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		jmf	
-- Create date: 21/4/15
-- Description:	Updates mobile data from the sync
-- Version:		8
-- =============================================
-- jf TFS 19430 added @VersionNo
--jf TFS 23605 - make sure no date conversions happen
-- jf tfs 29101 - add itemstatus
-- PH TFS 13-46056 : v4 16/05/2016 - Added @DateRequiredAsText and @DepotDateAsText to work around unwanted XML UTC offset conversions.  As prescribed by Mark Powell.
-- PH TFS 13-46056 : v5 16/05/2016 - Reformatted code to make more understandable and inserted semi-colons to make forward compatible added dbo schema prefix.
-- PH TFS 13-46056 : v6 25/05/2016 - Fixed the Markleville and WaterFord Township (48327) bugs by specifying all nvarchar lengths on new parameters.
-- JF TFS 70104 - make sure all the PO items fields are imported - specifically @E_UOM
-- jf tfs 92515 - added QuantityReceived
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_PM_ConsignmentItems] 
	@ConsignmentItemID int,
	@ConsignmentID int,
	@StockCodeID int,
	@Quantity real,
	@UnitStockCodeID int,
	@UnitQuantity real,
	@QuantityAccepted real,
	@DepotDate datetime,
	@DepotDateAsText nvarchar(50) = NULL,
	@UnitPrice money,
	@Comments nvarchar(1000) = NULL,
	@DateRequired DATETIME = NULL,
	@DateRequiredAsText nvarchar(50) = NULL,
	@E_POItem NVARCHAR(20) = NULL,
	@Hide BIT = NULL,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@VersionNo INT,
	@ItemStatus INT,
	
	@E_UOM nvarchar(10)=null,
	@CurrencyID INT=null,
	@Discount money=null,
	@VAT money=null,
	@ItemAccepted BIT=null,
	@PalletLabels int=null,
	@E_UOM_OTHER nvarchar(10)=null,
	@LocationID INT=null,
	@Source tinyint=null,
	@QuantityReceived real = null,

	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

IF @DepotDateAsText IS NOT NULL
	SET @DepotDate = @DepotDateAsText;
ELSE
	SET @DepotDate = dbo.FNC_ConvertServerDate(@DepotDate);

IF @DateRequiredAsText IS NOT NULL
	SET @DateRequired = @DateRequiredAsText;
ELSE
	SET @DateRequired = dbo.FNC_ConvertServerDate(@DateRequired);

IF @Hide  IS NULL
	SET @Hide = 0;

IF NOT EXISTS(SELECT * FROM dbo.PM_ConsignmentItems WHERE (ConsignmentItemID = @ConsignmentItemID))
BEGIN --Append record
	IF @RecordStatus < 201 AND EXISTS(SELECT ConsignmentID FROM dbo.PM_Consignment WHERE (ConsignmentID = @ConsignmentID))
	BEGIN
		INSERT INTO dbo.PM_ConsignmentItems
        (
			ConsignmentItemID,
			ConsignmentID,
			StockCodeID,
			Quantity,
			UnitStockCodeID,
			UnitQuantity,
			QuantityAccepted,
			DepotDate,
			UnitPrice,
			Comments,
			DateRequired,
			E_POItem,
			Hide,
			RecordStatus,
			GUID,
			VersionNo,
			ItemStatus,

			E_UOM ,
			CurrencyID ,
			Discount ,
			VAT ,
			ItemAccepted ,
			PalletLabels ,
			E_UOM_OTHER ,
			LocationID ,
			Source,
			QuantityReceived

		)
		VALUES
		(
			@ConsignmentItemID,
			@ConsignmentID,
			@StockCodeID,
			@Quantity,
			@UnitStockCodeID,
			@UnitQuantity,
			@QuantityAccepted,
			@DepotDate,
			@UnitPrice,
			@Comments,
			@DateRequired,
			@E_POItem,
			@Hide,
			@RecordStatus,
			@GUID,
			@VersionNo,
			@ItemStatus,

			@E_UOM ,
			@CurrencyID ,
			@Discount ,
			@VAT ,
			@ItemAccepted ,
			@PalletLabels ,
			@E_UOM_OTHER ,
			@LocationID ,
			@Source,
			@QuantityReceived 

		);

		SET @InsertCount = @@rowcount;
	END
END

ELSE
BEGIN --Update record
	UPDATE	dbo.PM_ConsignmentItems
	SET
		StockCodeID = @StockCodeID,
		Quantity = @Quantity,
		UnitStockCodeID = @UnitStockCodeID,
		UnitQuantity = @UnitQuantity,
		QuantityAccepted = @QuantityAccepted,
		DepotDate = @DepotDate,
		UnitPrice = @UnitPrice,
		Comments = @Comments,
		DateRequired = @DateRequired,
		E_POItem = @E_POItem,
		Hide = @Hide,
		RecordStatus = @RecordStatus,
		VersionNo=@VersionNo,
		ItemStatus=@ItemStatus,

		E_UOM=@E_UOM ,
		CurrencyID=@CurrencyID ,
		Discount=@Discount ,
		VAT=@VAT ,
		ItemAccepted=@ItemAccepted ,
		PalletLabels=@PalletLabels ,
		E_UOM_OTHER=@E_UOM_OTHER ,
		LocationID=@LocationID ,
		Source =@Source,
		QuantityReceived=@QuantityReceived 

	WHERE	ConsignmentItemID = @ConsignmentItemID;

	SET @UpdateCount = @@rowcount;
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint);
ELSE
	SET @ReceivedAnchor = @Created;

GO





IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_UserPermissions')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_UserPermissions] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 02/07/2008
-- Description:	Saves or deletes user permissions
-- Version:		9
-- =============================================
-- JT TFS 13-1791: Lookup UserPermissionID if not specified, and convert AppID to PermissionType.
-- JT TFS 13-4134: Added permissions for add/edit/delete for menu items added for mobile (AppID = 2).
-- JT TFS 13-4012: Added code to remove favourites of children as well as current user.
-- JE TFS 13-12638: update QMS_CorrectiveActionUser when permissions have been changed
-- JE TFS 13-13177: update Assigned column in QMS_CorrectiveActionUser
-- JT TFS 13-15105: Only update corrective action user list when datapermissions are changed, not favourites or menu permissions.
-- JT TFS 13-16507: Bug where assigned user can also see CA through permissions - row duplicated.
-- JT TFS 13-94569: Do not apply Add/Edit/Delete to the Exit menu, or any menu without a parent.
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_UserPermissions]
	@UserID int,
	@UserPermissionID int,
	@PermissionType int,
	@PermissionTitle nvarchar(255),
	@PermissionAllow bit,
	@ChangedBy int = NULL -- UserID of user who is changing this entry.
AS
BEGIN
	SET NOCOUNT ON
	IF @ChangedBy IS NULL SET @ChangedBy = @UserID

	-- If PermissionType is an AppID, then change it to be a PermissionType
	IF @PermissionType IN (0,1,2,3)
	BEGIN
		SELECT @PermissionType = 
			CASE	WHEN EXISTS (	SELECT * FROM APP_Menu 
									WHERE MenuID = convert(int, @PermissionTitle)
									AND ParentID IS NULL) 
					THEN 0 ELSE 1 END
		
		-- Remove any other permissions which link to this userpermission (favourites, homepage, reportfavourites)
		IF @PermissionAllow = 0
		BEGIN
			UPDATE QMS_UserPermissions
			SET PermissionAllow = 0,
				Updated = getutcdate(),
				Deleted = getutcdate(),
				Changed_UserID = @ChangedBy
			WHERE PermissionType IN (4, 20, 21)
			AND PermissionTitle = @PermissionTitle
			AND (	UserID = @UserID 
					OR 
					UserID IN (	SELECT UserID FROM QMS_User children
								WHERE ParentUserID = @UserID)
			)
			AND PermissionAllow <> 0 -- only update if it would change from 1 to 0.
		END
		
		-- Do a menu item check for mobile permissions (only on leaf items)
		IF EXISTS (SELECT * FROM APP_Menu 
					WHERE MenuID = convert(int, @PermissionTitle)
					AND ParentID IS NOT NULL
					AND AppID = 2)
		AND NOT EXISTS (SELECT * FROM APP_Menu
						WHERE ParentID = convert(int, @PermissionTitle)
						AND AppID = 2)
		BEGIN
			-- Ensure that three child permissions exist: add/edit/delete
			UPDATE QMS_UserPermissions
			SET PermissionAllow = @PermissionAllow,
				Updated = getutcdate(),
				Deleted = CASE WHEN @PermissionAllow = 0 THEN getutcdate() ELSE Deleted END,
				Changed_UserID = @ChangedBy
			WHERE PermissionType IN (11,12, 13)
			AND PermissionTitle = @PermissionTitle
			AND UserID = @UserID
			AND PermissionAllow <> @PermissionAllow
			
			INSERT QMS_UserPermissions (UserID, PermissionType, PermissionTitle, PermissionAllow, Changed_UserID)
			SELECT @UserID, PermissionType, @PermissionTitle, @PermissionAllow, @ChangedBy 
			FROM (SELECT 11 PermissionType UNION SELECT 12 UNION SELECT 13) as t
			WHERE NOT EXISTS (
				SELECT * FROM QMS_UserPermissions
				WHERE PermissionType = t.PermissionType
				AND PermissionTitle = @PermissionTitle
				AND UserID = @UserID
			)
		END
	END

	-- Modify this actual permission.
	IF @UserPermissionID = 0
	BEGIN
		-- Treat zero and one permissiontypes as identical.
		DECLARE @SearchType int
		SELECT @SearchType = CASE WHEN @PermissionType IN (0,1) THEN 0 ELSE @PermissionType END

		SELECT @UserPermissionID = UserPermissionID
		FROM QMS_UserPermissions
		WHERE UserID = @UserID 
		AND CASE WHEN PermissionType IN (0,1) THEN 0 ELSE PermissionType END = @SearchType 
		AND PermissionTitle = @PermissionTitle;
	END

	IF ISNULL(@UserPermissionID,0)=0 --New permission
	BEGIN
		DECLARE @UserPermissions TABLE( UserPermissionID int);

		INSERT INTO QMS_UserPermissions
					(UserID, PermissionType, PermissionTitle, PermissionAllow, Changed_UserID)
		OUTPUT INSERTED.UserPermissionID 
			INTO @UserPermissions 
		VALUES     (@UserID,@PermissionType,@PermissionTitle,@PermissionAllow, @ChangedBy)
		
		--Get new UserPermissionID
		SELECT     @UserPermissionID = MAX(UserPermissionID)
		FROM         @UserPermissions
	END
	ELSE
	BEGIN
		UPDATE  QMS_UserPermissions
		SET     PermissionType = @PermissionType, 
				PermissionTitle = @PermissionTitle, 
				PermissionAllow = @PermissionAllow, 
				Updated = GETUTCDATE(),
				-- only change deleted if allow is set to false.
				Deleted = CASE WHEN @PermissionAllow = 0 THEN getutcdate() ELSE Deleted END,
				Changed_UserID = @ChangedBy
		WHERE     (UserPermissionID = @UserPermissionID)
	END

	-- Only data permissions will change corrective action visibilities.
	IF @PermissionType >= 100
	BEGIN
		EXEC SAVE_CorrectiveActionUser_ByUser @UserID = @UserID
	END

	SET NOCOUNT OFF

	SELECT @UserPermissionID
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Consignment_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Consignment_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 16/07/2008
-- Description:	Gets list of consignments
-- Version:	3
-- =============================================
-- JF TFS 78132 -can use barcode
-- JF output integrated data
-- JF TFS 92518 - filter on Location if the trigger is enabled
-- JF TFS 92518 - format Consignment to cater for older, non integarated PO data using orderref or ConsignmentNo
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_Consignment_Combo]
	@SupplierID int = null,
	@Barcode nvarchar(50) =null,
	@LocationID INT=null
AS

	DECLARE @DownloadConsignmentDays int, @DateFrom datetime
	SET @DownloadConsignmentDays = ISNULL(dbo.FNC_GetOptionValue(101),0)
	
	IF @DownloadConsignmentDays = 0 
		SELECT @DateFrom = NULL
	ELSE
		SET @DateFrom = DATEADD(day,-@DownloadConsignmentDays,GETDATE())

	
	if exists(select * from APP_DataLookupTrigger where datalookupid_Trigger = 4 and DataLookupID_Update = 5 and enabled = 1)
		--filter PO based on Location
		SELECT  PM_VW_Consignment.ConsignmentID, E_PO AS Consignment
		FROM         PM_VW_Consignment 
		WHERE     (LocationID= @LocationID) and (DateRequired > @DateFrom OR DateRequired IS NULL or @DateFrom IS NULL)
		ORDER BY E_PO DESC

	ELSE if @Barcode IS NOT NULL
		SELECT  DISTINCT   PM_VW_Consignment.ConsignmentID, ISNULL(E_PO,ISNULL(OrderRef, ConsignmentNo)) AS Consignment
		FROM         PM_VW_Consignment 
		INNER JOIN PM_VW_ConsignmentItems on PM_VW_Consignment.consignmentID = PM_VW_ConsignmentItems.consignmentID
		INNER JOIN PM_VW_GoodsIntake ON PM_VW_ConsignmentItems.consignmentitemID=PM_VW_GoodsIntake.consignmentitemid
		WHERE     (PM_VW_GoodsIntake.Barcode = @Barcode)
		ORDER BY ISNULL(E_PO,ISNULL(OrderRef, ConsignmentNo)) DESC

	ELSE --if exists(select * from APP_DataLookupTrigger where datalookupid_Trigger = 1 and DataLookupID_Update = 5 and enabled = 1)
		--filter PO based on supplier
		SELECT  ConsignmentID, ISNULL(E_PO,ISNULL(OrderRef, ConsignmentNo)) AS Consignment
		FROM         PM_VW_Consignment
		WHERE     
			(SupplierID = @SupplierID OR @SupplierID IS NULL) AND
			(DateRequired > @DateFrom OR DateRequired IS NULL or @DateFrom IS NULL)
		ORDER BY E_PO DESC
GO



-- BEGIN DATA IX_QMS_ResponseHeader_ResponseID_Header_Text_94396
BEGIN TRY
	IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id=OBJECT_ID(N'[dbo].[QMS_ResponseHeader]') and name='IX_QMS_ResponseHeader_ResponseID_Header_Text')
	BEGIN 
		CREATE NONCLUSTERED INDEX [IX_QMS_ResponseHeader_ResponseID_Header_Text] ON [dbo].[QMS_ResponseHeader] 
			(	[ResponseID],
				[Header_Text],
				[RecordStatus])
		INCLUDE 
			([AssessmentHeaderID])
	END
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA IX_QMS_ResponseHeader_ResponseID_Header_Text_94396', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA IX_QMS_ResponseHeader_ResponseID_Header_Text_94396



-- BEGIN DATA FNC_ResponseHeader_Stockcode_Indexes_95146
BEGIN TRY
--replaces existing
IF EXISTS (SELECT * FROM sys.indexes WHERE name = N'IX_GoodsIntake_RecordStatus') DROP INDEX [IX_GoodsIntake_RecordStatus] ON [dbo].[PM_GoodsIntake]
CREATE NONCLUSTERED INDEX [IX_GoodsIntake_RecordStatus]
ON [dbo].[PM_GoodsIntake] ([RecordStatus])
INCLUDE ([GoodsIntakeID],[ConsignmentItemID])

--replaces existing
IF EXISTS (SELECT * FROM sys.indexes WHERE name = N'IX_QMS_ResponseHeader_AssessmentHeaderID') DROP INDEX [IX_QMS_ResponseHeader_AssessmentHeaderID] ON [dbo].[QMS_ResponseHeader]
CREATE NONCLUSTERED INDEX [IX_QMS_ResponseHeader_AssessmentHeaderID]
ON [dbo].[QMS_ResponseHeader] ([AssessmentHeaderID],[Header_SourceID])
INCLUDE ([ResponseID])

--new index (checked against LIVE)
IF EXISTS (SELECT * FROM sys.indexes WHERE name = N'IX_QMS_Response_RecordStatus') DROP INDEX [IX_QMS_Response_RecordStatus] ON [dbo].[QMS_Response]
CREATE NONCLUSTERED INDEX [IX_QMS_Response_RecordStatus] ON [dbo].[QMS_Response] ([RecordStatus])
INCLUDE ([ResponseID],[EndDate])

--new index (checked against LIVE)
IF EXISTS (SELECT * FROM sys.indexes WHERE name = N'IX_PM_ConsignmentItems_HideRecordStatus') DROP INDEX [IX_PM_ConsignmentItems_HideRecordStatus] ON [dbo].[PM_ConsignmentItems]
CREATE NONCLUSTERED INDEX [IX_PM_ConsignmentItems_HideRecordStatus] ON [dbo].[PM_ConsignmentItems] ([Hide],[RecordStatus])
INCLUDE ([ConsignmentItemID],[StockCodeID])
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA FNC_ResponseHeader_Stockcode_Indexes_95146', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA FNC_ResponseHeader_Stockcode_Indexes_95146

-- BEGIN DATA GoodsIntake_Index_95216
BEGIN TRY
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE name = N'IX_PM_GoodsIntake_ConsignmentItemIDRecordStatus') 
	CREATE NONCLUSTERED INDEX [IX_PM_GoodsIntake_ConsignmentItemIDRecordStatus] 
		ON [dbo].[PM_GoodsIntake] ([ConsignmentItemID],[RecordStatus])
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA GoodsIntake_Index_95216', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA GoodsIntake_Index_95216


PRINT 'Database updated successfully!'
GO

