-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'PM_VW_Consignment')
	EXEC ('CREATE VIEW [dbo].[PM_VW_Consignment] AS SELECT 1 as ''stub version, to be replaced''')
GO
-- ===================================================
-- Author:		Unknown
-- Create date:	1 Jan 2010
-- Description:	View consignments from PM_Consignment
-- Version:		8
-- ===================================================
-- JT TFS 4405: Added E_POType column
-- JF: Added Comments column
-- MP TFS 2798: Added CustomerID column
-- jf tfs 19129 - added Text1, Text2, Hide
-- jf tfs 22919 - add text3,4 and country
-- JF tfs 80479 - remove consignmentNo as no longer used in the lookups. Update, re added it but with logic to remove errors if consid>6 chars
-- ===================================================
ALTER VIEW [dbo].[PM_VW_Consignment]
AS
SELECT        
	ConsignmentID, 
	--LEFT('000000', 6 - LEN(CAST(ConsignmentID AS nvarchar))) + CAST(ConsignmentID AS nvarchar) AS ConsignmentNo, 
	CASE	WHEN LEN(CAST(ConsignmentID AS nvarchar)) > 6 
			THEN CAST(ConsignmentID AS nvarchar)
			ELSE LEFT('000000', 6 - LEN(CAST(ConsignmentID AS nvarchar))) + CAST(ConsignmentID AS nvarchar) END
	AS ConsignmentNo, 
	SupplierID, 
	OrderRef, 
	OrderDate, 
	DateRequired, 
	E_PO, 
	LocationID, 
    OrderStatus, 
	WatchList, 
	E_POType, 
	Comments, 
	CustomerID, 
	Text1, 
	Text2, 
	Text3, 
	Text4,
	CountryCode , 
	Hide, 
	GUID, 
	RowVersion, 
	Created, 
	RecordStatus, 
	Updated
FROM            
	dbo.PM_Consignment
WHERE        
	(OrderStatus > 1) AND 
	(Hide = 0) AND 
	(RecordStatus < 201)



GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_ConsignmentItem_Quantity_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_ConsignmentItem_Quantity_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Taj Sehdev	
-- Create date: 16/12/15
-- Description:	Trigger for quantity ordered by consignment item and stock code
-- Version:		2 
-- =============================================
-- tfs 13- 33338
-- JF TFS 80479 - allow quantity to be pulled from PO and stockcode. If multiples, the sum it
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_ConsignmentItem_Quantity_Lookup] 
	-- Add the parameters for the stored procedure here
	@ConsignmentID int = NULL,
	@ConsignmentItemID int = NULL,
	@StockCodeID int = NULL
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	SELECT    SUM( Quantity) as Quantity
	FROM         PM_VW_ConsignmentItems
	WHERE     
		(StockCodeID = @StockCodeID AND ConsignmentID = @ConsignmentID and @ConsignmentItemID IS NULL) 
		OR 
		(ConsignmentItemID = @ConsignmentItemID)
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Consignment_HeaderLookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Consignment_HeaderLookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 22/07/2008
-- Description:	View of consignments for finding data in assessments
-- version 2
-- =============================================
-- JF tfs 80479 - Update generic sp to return E_PO rather than ConsignmentNo
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_Consignment_HeaderLookup] 

AS

SELECT     PM_VW_Supplier.SupplierID AS Lookup_SupplierID, PM_VW_Supplier.SupplierCode AS [Supplier code], 
                      PM_VW_Supplier.SupplierName AS [Supplier name], PM_VW_Consignment.ConsignmentID AS Lookup_ConsignmentID, 
                      PM_VW_Consignment.E_PO AS PO, PM_VW_Consignment.OrderRef AS [Order ref], 
                      PM_VW_Consignment.OrderDate AS [Order date], PM_VW_ConsignmentItems.ConsignmentItemID AS Lookup_ConsignmentItemID, 
                      PM_VW_StockCode.StockCodeID AS Lookup_StockCodeID, PM_VW_StockCode.StockCode AS [Stock code], 
                      PM_VW_StockCode.Description AS [Stock code desc.], PM_VW_ConsignmentItems.Quantity AS [Qty. ordered], 
                      CAST(CASE WHEN Assessed.ConsignmentItemID IS NULL THEN 0 ELSE 1 END AS bit) AS [Assessed?]
FROM         PM_VW_Consignment INNER JOIN
                      PM_VW_Supplier ON PM_VW_Consignment.SupplierID = PM_VW_Supplier.SupplierID INNER JOIN
                      PM_VW_ConsignmentItems ON PM_VW_Consignment.ConsignmentID = PM_VW_ConsignmentItems.ConsignmentID INNER JOIN
                      PM_VW_StockCode ON PM_VW_ConsignmentItems.StockCodeID = PM_VW_StockCode.StockCodeID LEFT OUTER JOIN
                          (SELECT DISTINCT QMS_ResponseHeader.Header_SourceID AS ConsignmentItemID
                            FROM          QMS_ResponseHeader INNER JOIN
                                                   QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                            WHERE      (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 6) AND 
                                                   (QMS_ResponseHeader.Header_SourceID IS NOT NULL)) AS Assessed ON 
                      PM_VW_ConsignmentItems.ConsignmentItemID = Assessed.ConsignmentItemID
WHERE     (PM_VW_Consignment.OrderDate > DATEADD(day, - 60, GETDATE()))
ORDER BY Lookup_ConsignmentID DESC, [Stock code]
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Consignment_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Consignment_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 16/07/2008
-- Description:	Gets list of consignments
-- version:		3
-- =============================================
-- JF tfs 80479 - Update generic unused sp to return E_PO rather than ISNULL(OrderRef, ConsignmentNo) to use as a generic integration SP
-- JF TFS 78132 -can use barcode
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_Consignment_Combo]
	@SupplierID int = null,
	@AssessmentTypeID int = null,
	@UserID int = null,
	@Barcode nvarchar(50) =null
AS

--old code for reference:
--SELECT     ConsignmentID, ISNULL(OrderRef, ConsignmentNo) AS Consignment
--FROM         PM_VW_Consignment
--WHERE     (SupplierID = @SupplierID) OR
--                      (@SupplierID = 0)
--ORDER BY ISNULL(OrderRef, ConsignmentNo) DESC

--limit the number of consignments using the config setting:
DECLARE @DownloadConsignmentDays int, @DateFrom datetime
SET @DownloadConsignmentDays = ISNULL(dbo.FNC_GetOptionValue(101),0);
SET @DateFrom = DATEADD(day,-@DownloadConsignmentDays,GETDATE());

if @Barcode IS NOT NULL
	SELECT  DISTINCT   PM_VW_Consignment.ConsignmentID, E_PO AS Consignment
	FROM         dbo.PM_VW_Consignment 
	INNER JOIN dbo.PM_VW_ConsignmentItems on PM_VW_Consignment.consignmentID = PM_VW_ConsignmentItems.consignmentID
	INNER JOIN dbo.PM_VW_GoodsIntake ON PM_VW_ConsignmentItems.consignmentitemID=PM_VW_GoodsIntake.consignmentitemid
	WHERE     (PM_VW_GoodsIntake.Barcode = @Barcode)
	ORDER BY E_PO DESC
ELSE
	SELECT     
		ConsignmentID, 
		E_PO AS Consignment
	FROM         dbo.PM_VW_Consignment
	WHERE     
		(SupplierID = @SupplierID OR ISNULL(@SupplierID,0) = 0)
		and 
		(DateRequired > @DateFrom or DateRequired IS NULL)
	ORDER BY E_PO DESC

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Supplier_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Supplier_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: Markp
-- Create date	: 16/07/2008
-- Description	: Gets list of suppliers
-- Version		: 6
-- =============================================
-- JE TFS 3176: added AssessmentType param to check if we should hide hidden suppliers or not
-- JE TFS 13-2214: added check that DateArrived trigger is enabled before applying filter
-- PH TFS 13-41690: added IsInactive for showing hidden suppliers in red.
-- JF TFS 74073 - allow supplier to be picked up from goods intake supplier or PO data 
-- JF TFS 80479 - allow suppliers to be filtered from PO
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_Supplier_Combo] 
	@DateArrived datetime = NULL,
	@CaseEndBarcode nvarchar(100) = NULL,
	@UserID int = NULL,
	@AssessmentTypeID int = NULL,
	@Barcode nvarchar(50) = null,
	@ConsignmentID int = null
AS

--exec PM_QRY_Supplier_Combo null,null,1,10,null,164

IF @CaseEndBarcode IS NOT NULL --combo being accessed from an assessment, so hide hidden suppliers
	SELECT     SupplierID, SupplierName, Hide AS IsInactive
	FROM         dbo.PM_VW_Supplier
	WHERE     (SupplierID = dbo.FNC_CaseEndToSupplier(@CaseEndBarcode)) AND (Hide = 0)
	ORDER BY SupplierName

ELSE
BEGIN
	IF @DateArrived IS NULL OR (SELECT Enabled FROM APP_DataLookupTrigger WHERE DataLookupID_Trigger = 16 AND DataLookupID_Update = 1) = 0
	--DateArrived trigger disabled
	BEGIN
		IF @UserID IS NULL --combo not being accessed from an assessment, so show all suppliers
			SELECT     SupplierID, SupplierName, Hide AS IsInactive
			FROM         dbo.PM_VW_Supplier
			ORDER BY SupplierName
		ELSE IF @AssessmentTypeID IS NOT NULL --combo being accessed from an assessment, so hide hidden suppliers
			IF @Barcode IS NULL OR (SELECT Enabled FROM APP_DataLookupTrigger WHERE DataLookupID_Trigger = 11 AND DataLookupID_Update = 1) = 0
				
				IF @ConsignmentId IS NULL OR (SELECT Enabled FROM APP_DataLookupTrigger WHERE DataLookupID_Trigger = 5 AND DataLookupID_Update = 1) = 0
					SELECT     PM_VW_Supplier.SupplierID, PM_VW_Supplier.SupplierName, PM_VW_Supplier.Hide AS IsInactive
					FROM         dbo.PM_VW_Supplier INNER JOIN
										  dbo.FNC_User_SupplierList(@UserID) AS User_SupplierList ON PM_VW_Supplier.SupplierID = User_SupplierList.SupplierID
					WHERE (Hide = 0)
					ORDER BY PM_VW_Supplier.SupplierName
				else
					--get the list of suppliers from the PO
					SELECT     PM_VW_Supplier.SupplierID, PM_VW_Supplier.SupplierName, PM_VW_Supplier.Hide AS IsInactive
					FROM         dbo.PM_VW_Supplier INNER JOIN
										  dbo.FNC_User_SupplierList(@UserID) AS User_SupplierList ON PM_VW_Supplier.SupplierID = User_SupplierList.SupplierID
										  INNER JOIN PM_VW_Consignment on PM_VW_Consignment.supplierid = PM_VW_Supplier.SupplierID 
					WHERE (PM_VW_Supplier.Hide = 0) and PM_VW_Consignment.ConsignmentID = @ConsignmentID
					ORDER BY PM_VW_Supplier.SupplierName

			else
				--Either get the supplier from the PM_Consignment.SupplierID or GoodsIntake.SupplierID
				IF EXISTS(SELECT SupplierID FROM PM_VW_Goodsintake WHERE Barcode = @Barcode and SupplierID IS NOT NULL)
					SELECT     PM_VW_Supplier.SupplierID, PM_VW_Supplier.SupplierName, PM_VW_Supplier.Hide AS IsInactive
					FROM         dbo.PM_VW_Supplier INNER JOIN
						dbo.PM_vw_goodsintake ON dbo.PM_vw_goodsintake.supplierid = PM_VW_Supplier.SupplierID
						inner join dbo.FNC_User_SupplierList(@UserID) AS User_SupplierList ON PM_VW_Supplier.SupplierID = User_SupplierList.SupplierID
					WHERE (Hide = 0) and PM_vw_goodsintake.barcode = @barcode
					ORDER BY PM_VW_Supplier.SupplierName
				ELSE
					SELECT     PM_VW_Supplier.SupplierID, PM_VW_Supplier.SupplierName, PM_VW_Supplier.Hide AS IsInactive
					FROM         dbo.PM_VW_Supplier INNER JOIN
										  dbo.FNC_User_SupplierList(@UserID) AS User_SupplierList ON PM_VW_Supplier.SupplierID = User_SupplierList.SupplierID
										  inner join dbo.PM_vw_Consignment  on pm_vw_consignment.supplierid = PM_VW_Supplier.supplierid
										  inner join dbo.PM_vw_ConsignmentItems  on pm_vw_consignmentitems.consignmentid = pm_vw_consignment.ConsignmentID 
										  inner join dbo.PM_vw_GoodsIntake on PM_vw_GoodsIntake.ConsignmentItemID = pm_vw_consignmentitems.ConsignmentItemID 
					WHERE (PM_VW_Supplier.Hide = 0) and PM_vw_goodsintake.barcode = @barcode
					ORDER BY PM_VW_Supplier.SupplierName


		ELSE
			SELECT     PM_VW_Supplier.SupplierID, PM_VW_Supplier.SupplierName, PM_VW_Supplier.Hide AS IsInactive
			FROM         dbo.PM_VW_Supplier INNER JOIN
								  dbo.FNC_User_SupplierList(@UserID) AS User_SupplierList ON PM_VW_Supplier.SupplierID = User_SupplierList.SupplierID
			ORDER BY PM_VW_Supplier.SupplierName
	END
	ELSE --@DateArrived NOT NULL, so must be accessing combo from an assessment (DateArrived trigger also enabled)
		SELECT DISTINCT PM_VW_Supplier.SupplierID, PM_VW_Supplier.SupplierName, PM_VW_Supplier.Hide AS IsInactive
		FROM         dbo.PM_VW_Supplier INNER JOIN
							  PM_VW_GoodsIntake ON PM_VW_Supplier.SupplierID = PM_VW_GoodsIntake.SupplierID
		WHERE     (dbo.FNC_TrimDate(PM_VW_GoodsIntake.DateArrived) = dbo.FNC_TrimDate(@DateArrived)) AND (Hide = 0)
		ORDER BY PM_VW_Supplier.SupplierName
END

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_StockCode_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_StockCode_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 16/07/2008
-- Description:	Gets a stock code list
-- Version:		9 
-- =============================================
-- JE updated to filter list by Customer
-- JT TFS 3657 - updated to only return one query result.
-- MP TFS 3869 - updated to ensure customer filter only used when trigger enabled
-- JE TFS 4178 - added AssessmentTypeID param so we know when to filter out hidden Stock Codes
-- JT TFS 5902 - 13-Feb-2012 - Added searchText
-- JE TFS 13-11942: exclude stock type of Seed/Variety when accessed from Mobile
-- JF TFS 74073 - allow stockcode to be picked up from goods intake without PO data ie PalletStockCodeID. Also check APP_DataLookupTrigger table
-- JF TFS 80479 - allow stockcode list to be filtered from PO
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_StockCode_Combo]
	@CaseEndBarcode nvarchar(100) = NULL,
	@UserID int = NULL,
	@CustomerID int = NULL,
	@AssessmentTypeID int = NULL,
	@SearchText nvarchar(100) = NULL,
	@Barcode nvarchar(50) = null,
	@ConsignmentID int = null
AS


IF @ConsignmentID IS NOT NULL and (SELECT Enabled FROM APP_DataLookupTrigger WHERE DataLookupID_Trigger = 5 AND DataLookupID_Update = 2) = 1
	SELECT DISTINCT PM_VW_StockCode.StockCodeID, PM_VW_StockCode.DisplayText 
	FROM dbo.PM_VW_StockCode 
	INNER JOIN PM_VW_ConsignmentItems on  PM_VW_ConsignmentItems.StockCodeID = PM_VW_StockCode.StockCodeID 
	INNER JOIN	dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
	WHERE dbo.PM_VW_ConsignmentItems.ConsignmentID = @ConsignmentID

else IF @CaseEndBarcode IS NOT NULL --combo being accessed from an assessment, so hide hidden stock codes
BEGIN
	DECLARE @FilterStockCodeID int
	IF @CaseEndBarcode IS NOT NULL
		SET @FilterStockCodeID = dbo.FNC_CaseEndToStockCode(@CaseEndBarcode)
	ELSE
		SET @FilterStockCodeID = NULL

	SELECT     StockCodeID, DisplayText
	FROM         PM_VW_StockCode
	WHERE   ((StockCodeID = @FilterStockCodeID) AND (@FilterStockCodeID IS NOT NULL) 	OR		(@FilterStockCodeID IS NULL) AND (Hide = 0))
	AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
	AND (PM_VW_StockCode.StockTypeID <> 4)
	ORDER BY DisplayText
END
ELSE
BEGIN
	DECLARE @EnableCustomerFilter bit
	IF @CustomerID IS NOT NULL
		SELECT     @EnableCustomerFilter = Enabled
		FROM         dbo.APP_DataLookupTrigger
		WHERE     (DataLookupID_Update = 2) AND (DataLookupID_Trigger = 3)
	ELSE
		SET @EnableCustomerFilter = 0
		
	IF @UserID IS NULL AND @EnableCustomerFilter = 1 --combo not being accessed from an assessment, so show all stock codes
		SELECT		StockCodeID, DisplayText
		FROM         dbo.PM_VW_StockCode
		WHERE		CustomerID = @CustomerID
		AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
		ORDER BY DisplayText
		
	ELSE IF @UserID IS NOT NULL AND @EnableCustomerFilter = 0 AND @AssessmentTypeID IS NOT NULL --combo being accessed from an assessment, so hide hidden stock codes
		--Where is stockcode stored
		IF @Barcode is NOT NULL and (SELECT Enabled FROM dbo.APP_DataLookupTrigger WHERE DataLookupID_Trigger = 11 AND DataLookupID_Update = 2) = 1
			BEGIN
				IF EXISTS(SELECT consignmentitemid FROM dbo.PM_VW_GoodsIntake WHERE Barcode = @Barcode and consignmentitemid IS NOT NULL)
					SELECT     DISTINCT dbo.PM_VW_StockCode.StockCodeID, DisplayText
					FROM         dbo.PM_VW_StockCode 
					INNER JOIN dbo.PM_VW_ConsignmentItems on dbo.PM_VW_ConsignmentItems.StockCodeID = dbo.PM_VW_StockCode.StockCodeID 
					INNER JOIN dbo.PM_vw_GoodsIntake ON dbo.PM_vw_GoodsIntake.ConsignmentItemID  = dbo.PM_VW_ConsignmentItems.ConsignmentItemID 
					WHERE   
					dbo.PM_vw_GoodsIntake.Barcode = @Barcode 
					ORDER BY DisplayText
				ELSE IF EXISTS(SELECT PalletStockCodeID FROM PM_VW_GoodsIntake WHERE Barcode = @Barcode and PalletStockCodeID IS NOT NULL)
					SELECT     DISTINCT StockCodeID, DisplayText
					FROM         dbo.PM_VW_StockCode INNER JOIN dbo.PM_vw_GoodsIntake ON dbo.PM_vw_GoodsIntake.PalletStockCodeID = dbo.PM_VW_StockCode.StockCodeID 
					WHERE   
					dbo.PM_vw_GoodsIntake.Barcode = @Barcode 
					ORDER BY DisplayText
				ELSE IF EXISTS(SELECT StockBatchID  FROM PM_VW_StockBatch WHERE Barcode = @Barcode)
					SELECT PM_VW_StockCode.StockCodeID, PM_VW_StockCode.DisplayText FROM dbo.PM_VW_StockBatch 
					INNER JOIN dbo.PM_VW_StockBatchItems ON PM_VW_StockBatchItems.StockBatchID  = PM_VW_StockBatch.StockBatchID
					INNER JOIN dbo.PM_VW_StockCode  ON PM_VW_StockCode.StockCodeID  = PM_VW_StockBatchItems.StockCodeID 
					INNER JOIN	dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
					WHERE dbo.PM_VW_StockBatch.Barcode = @Barcode
			END
		ELSE

			SELECT		PM_VW_StockCode.StockCodeID, PM_VW_StockCode.DisplayText
			FROM         dbo.PM_VW_StockCode INNER JOIN
							dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
			WHERE (Hide = 0)
			AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
			AND (PM_VW_StockCode.StockTypeID <> 4)
			ORDER BY PM_VW_StockCode.DisplayText

	ELSE IF @UserID IS NOT NULL AND @EnableCustomerFilter = 0 AND @AssessmentTypeID IS NULL --combo not being accessed from an assessment, so show all stock codes
		SELECT		PM_VW_StockCode.StockCodeID, PM_VW_StockCode.DisplayText
		FROM         dbo.PM_VW_StockCode INNER JOIN
						dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
		AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
		ORDER BY PM_VW_StockCode.DisplayText
		
	ELSE IF @UserID IS NOT NULL AND @EnableCustomerFilter = 1 AND @AssessmentTypeID IS NOT NULL --combo being accessed from an assessment, so hide hidden stock codes
		SELECT		PM_VW_StockCode.StockCodeID, PM_VW_StockCode.DisplayText
		FROM         dbo.PM_VW_StockCode INNER JOIN
						dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
		WHERE		(CustomerID = @CustomerID) AND (Hide = 0)
		AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
		AND (PM_VW_StockCode.StockTypeID <> 4)
		ORDER BY PM_VW_StockCode.DisplayText
	
	ELSE IF @UserID IS NOT NULL AND @EnableCustomerFilter = 1 AND @AssessmentTypeID IS NULL --combo not being accessed from an assessment, so show all stock codes
		SELECT		PM_VW_StockCode.StockCodeID, PM_VW_StockCode.DisplayText
		FROM         dbo.PM_VW_StockCode INNER JOIN
						dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
		WHERE		(CustomerID = @CustomerID)
		AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
		ORDER BY PM_VW_StockCode.DisplayText	
		
	ELSE
		SELECT     StockCodeID, DisplayText
		FROM         dbo.PM_VW_StockCode
		WHERE (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
		ORDER BY DisplayText
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_ResourceLocale')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_ResourceLocale] AS SELECT ''stub version, to be replaced''')
GO


ALTER PROCEDURE [dbo].[SYNC_Import_ResourceLocale] 
	@ResourceLocaleID int,
	@ResourceID int,
	@CountryLocaleID int,
	@ResourceString nvarchar(255),
	@Updated datetime,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

IF NOT EXISTS(SELECT * FROM APP_ResourceLocale WHERE (ResourceLocaleID = @ResourceLocaleID))
BEGIN --Append record
	IF EXISTS(SELECT ResouceID FROM APP_Resource WHERE (ResouceID = @ResourceID)) 
	BEGIN
		SET IDENTITY_INSERT APP_ResourceLocale ON
		INSERT INTO APP_ResourceLocale
						  (ResourceLocaleID, ResourceID, CountryLocaleID, ResourceString, Updated, GUID)
		VALUES     (@ResourceLocaleID,@ResourceID,@CountryLocaleID,@ResourceString,@Updated,@GUID)
		SET @InsertCount = @@rowcount
		SET IDENTITY_INSERT APP_ResourceLocale OFF
	END
END

ELSE
BEGIN --Update record
	UPDATE    APP_ResourceLocale
	SET              ResourceID = @ResourceID, CountryLocaleID = @CountryLocaleID, ResourceString = @ResourceString, Updated = @Updated
	WHERE     (ResourceLocaleID = @ResourceLocaleID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_ResponseSummary_Attachments')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_ResponseSummary_Attachments] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Adam C
-- Create date: 20/02/15
-- Description:	Gets attachment data for QC summary report
-- Version:		2
-- =============================================
-- JT TFS 79337 - Add MaxAttachmentsAllowed variable to make later changes easier.
-- =============================================
ALTER PROCEDURE dbo.RPT_ResponseSummary_Attachments
(
	@UserID INTEGER
) 
AS
BEGIN
	SET NOCOUNT ON

	DECLARE @MaxAttachmentsAllowed int 
	SELECT @MaxAttachmentsAllowed = dbo.FNC_GetOptionValue(148) -- ResponseSummaryMaxAttachments
	-- Note: The unspecified default value is also hard-coded in QCSummaryReportController.cs for display purposes only.
	IF @MaxAttachmentsAllowed IS NULL SET @MaxAttachmentsAllowed = 20
	IF @MaxAttachmentsAllowed < 0 SET @MaxAttachmentsAllowed = 0

	DECLARE @AttachmentCount INTEGER 
	SELECT @AttachmentCount = (	SELECT COUNT(AttachmentID) FROM QMS_Attachment 
								WHERE SourceObjectID IN (SELECT SelectedID FROM TEMP_Selected 
														WHERE UserID = @UserID) 
								AND QMS_Attachment.RecordStatus < 100)

	DECLARE @Attachments TABLE (
		RowNumber INTEGER, 
		SourceObjectID INTEGER, 
		AttachmentTitle NVARCHAR(MAX), 
		AttachmentFileName NVARCHAR(MAX), 
		Attachment IMAGE, 
		AttachmentID INTEGER, 
		OriginalRow BIT
	)
	INSERT INTO @Attachments
	SELECT TOP (@MaxAttachmentsAllowed) 
				  ROW_NUMBER() OVER (ORDER BY APP_AssessmentType.ListIndex, QMS_Assessment.AssessmentName, QMS_Response.EndDate) AS RowNumber,
				  SourceObjectID, 
				  AttachmentTitle, 
				  AttachmentFileName, 
				  Attachment,
				  AttachmentID,
				  1
	FROM QMS_Attachment
	INNER JOIN QMS_Response ON QMS_Response.ResponseID = QMS_Attachment.SourceObjectID
	INNER JOIN QMS_Assessment ON QMS_Assessment.AssessmentID = QMS_Response.AssessmentID 
	INNER JOIN APP_AssessmentType ON APP_AssessmentType.AssessmentTypeID = QMS_Assessment.AssessmentTypeID
	WHERE SourceObjectID IN (	SELECT SelectedID FROM TEMP_Selected 
								WHERE UserID = @UserID)
								AND QMS_Attachment.RecordStatus < 100
	ORDER BY APP_AssessmentType.ListIndex, QMS_Assessment.AssessmentName, QMS_Response.EndDate

	-- So that two attachments are next to each other.
	UPDATE @Attachments
	SET RowNumber = RowNumber - 1, OriginalRow = 0
	WHERE RowNumber % 2 = 0

	SET NOCOUNT OFF

	SELECT A1.SourceObjectID AS A1SourceObjectID, 
		   A1.AttachmentTitle AS A1AttachmentTitle, 
		   A1.AttachmentFileName AS A1AttachmentFileName, 
		   A1.Attachment AS A1Attachment,
		   CASE WHEN A1.AttachmentID IS NULL THEN NULL
		   ELSE 'Check No: ' + CAST(A1.SourceObjectID AS NVARCHAR(255)) + ' - ' + A1.AttachmentFileName
		   END AS A1Title,
		   A2.SourceObjectID AS A2SourceObjectID, 
		   A2.AttachmentTitle AS A2AttachmentTitle, 
		   A2.AttachmentFileName AS A2AttachmentFileName, 
		   A2.Attachment AS A2Attachment,
		   CASE WHEN A2.AttachmentID IS NULL THEN NULL
		   ELSE 'Check No: ' + CAST(A2.SourceObjectID AS NVARCHAR(255)) + ' - ' + A2.AttachmentFileName
		   END AS A2Title,
		   @AttachmentCount AS FullAttachmentCount,
		   @MaxAttachmentsAllowed AS MaxAttachmentsAllowed
	FROM @Attachments A1 
	LEFT JOIN @Attachments A2 ON A1.RowNumber = A2.RowNumber AND A1.AttachmentID <> A2.AttachmentID
	WHERE A1.OriginalRow = 1

END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Response_PreviousList')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Response_PreviousList] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 28/07/2008
-- Description:	Gets list of previous responses
-- Version:		26
-- =============================================
-- Jonathan Toolan: 25-Aug-2011 AssessmentTypeID linked from Response, not Assessment.
-- Jonathan Toolan: 26-Mar-2012 Location Added.
-- Jonathan Toolan: TFS 3211 Multiple AssessmentTypeID_LIST
-- JE TFS 6272 - added Child Check/Top Level Check functionality
-- JT TFS 7346 - Added AssessmentID filter parameter.
-- JT TFS 7989 - Added ExportSetupTable to this SP as an example, so that custom SPs can copy and modify more easily.
-- JT TFS 8130 - ShowOutstanding to switch between "outstanding" mode and "completed" mode.
-- JT TFS 8578 - Added generic filtering if applied.
-- JE TFS 13-466: added provision for AQC Multi assessment format
-- JT TFS 13-612: Added DisplayMode parameter to show multi-check children (default) or parents.
-- JE TFS 13-1621: amended setting of @multiCheckDisplay so parent checks only are shown when isViewQCChecksScreen
-- JE TFS 13-2537: amended so that 3:isQCActionsScreen shows Parent checks only
-- JF TFS 2880 - Ensure that Child checks are available in Office Web - View QC Checks. 
				--Basically if the Multicheck contains a Summary column, then I would expect the Parent check to be referenced/displayed in ALL views
				--If no Summary Column (majority of multicheck customers) - then the Child check should be referenced/displayed in ALL views
-- TFS 2955		Navigate to Tasks > QC Actions for an assessment type of Active Quality Chain,Expected outcome: I am expecting to see the Parent checks here, Actual outcome: I am seeing the Child Checks
-- JE TFS 13-9699: only show non-Approved child checks for AQC assessment type
-- JE TFS 13-11892: output column indicating what sort of multi check response  is (i.e. parent or child) for AQC
-- JE TFS 13-12540: AQC Multi Check shows parent checks only for Previous tab
-- MP TFS 13-12735: Added logic to check for AQC approval config setting
-- jf 13042 - AQC may not be multicheck so allow for it
-- PH TFS 13-15140:  Added 'IsWebChecks' column to determine whether the Response is authorised to be edited using WebChecks front end (permission derived from APP_Menu with ParentID = 233)
-- jf tfs 16880 -- removed inner joins to FNC_User_ResponseList and used TEMP_selected instead - UBE Check view performance for user with 2000+ stock code permissions
				-- took resource string calcs out of nexted select and put in main output query (QAFlagID, ResourceName,QAFlag)
-- PH TFS 13-34304:		Reformatted and refactored QRY_Response_PreviousList to make more sense, perform better and be forward compatible
-- PH TFS 13-34304:		Reformatted to close up gaps
-- SS TFS 13-33017: When AssessmentTypeID = 16, AQC_FNC_ResponseHeader is now used instead of FNC_ResponseHeader
-- JT TFS 13-82047: Extract SP for shelf life to improve performance.
-- =============================================
ALTER PROCEDURE [dbo].[QRY_Response_PreviousList]
--DECLARE
    @AssessmentTypeID INT = NULL ,
    @AssessmentTypeID_LIST NVARCHAR(255) = NULL ,
    @DateFrom DATETIME ,
    @DateTo DATETIME ,
    @UserID INT ,
    @AssessmentID INT = NULL ,
    @ShowOutstanding BIT = 0 , -- 0: show completed checks only, 1: show outstanding checks only, NULL: show all checks regardless of ResponseStatus.
    @IsFilterApplied BIT = 0 ,
    @DisplayMode INT = NULL	
		-- 0 or NULL: not specified.
		-- 1:isPreviousChecksScreen
		-- 2:isViewQCChecksScreen
		-- 3:isQCActionsScreen
		-- 4:isQCCheckReport

		--SELECT  @AssessmentTypeID = 6,  @DateFrom = '1 Aug 2017 00:00:00',  @DateTo = '15 Sep 2017 23:59:59',  @UserID = 1,  @ShowOutstanding = 1,  @DisplayMode = 1
AS 
BEGIN
    SET NOCOUNT ON
--exec QRY_Response_PreviousList @AssessmentTypeID=13,@AssessmentTypeID_LIST=default,@DateFrom='2015-02-19 00:00:00',@DateTo='2015-03-19 23:59:59',@UserID=100,@AssessmentID=default,@ShowOutstanding=NULL,@IsFilterApplied=0,@DisplayMode=2    
-- If (isPreviousChecksScreen), then show parent checks (1), otherwise show children (2).
-- @multiCheckDisplay should match return value from dbo.FNC_Response_IsMultiCheck.

--FNC_Response_IsMultiCheck results
--0 -- Isn't multi-check at all.
--1 -- Is a parent multi-check
--2 -- Is a child multi-check
																				
        

--get Assessment Format
    DECLARE @AssessmentFormat int;
    SELECT  @AssessmentFormat = AssessmentFormat
    FROM    APP_AssessmentType
    WHERE   AssessmentTypeID = @AssessmentTypeID;


	DECLARE @multiCheckDisplay int;
    SELECT  @multiCheckDisplay = CASE WHEN ISNULL(@DisplayMode, 0) IN ( 1 ) 
									THEN  1    --show parent checks only for previouschecks screen
									WHEN @AssessmentFormat = 6 THEN 1
									ELSE 2
								END;
									
	DECLARE @AQCApproval bit;
	SELECT @AQCApproval = ISNULL(dbo.FNC_GetOptionValue(120),0);

    IF (@AssessmentTypeID_LIST IS NULL)
	BEGIN 
        SET @AssessmentTypeID_LIST = CONVERT(NVARCHAR, @AssessmentTypeID);
	END

--Clear temp table
    DELETE  FROM TEMP_Selected
    WHERE   ( UserID = @UserID );

--Fill temp table
    IF (@IsFilterApplied = 0)
    BEGIN
        INSERT INTO TEMP_Selected
			(
				SelectedID,
				UserID
			)
		SELECT	QMS_Response.ResponseID,
				@UserID AS UserID
		FROM	QMS_Response
		INNER JOIN	dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList
						ON QMS_Response.ResponseID = User_ResponseList.ResponseID
		INNER JOIN	dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',') AS SplitString
			ON QMS_Response.AssessmentTypeID = SplitString.Token;
    END
    ELSE 
    BEGIN
        INSERT INTO TEMP_Selected
                (
					SelectedID,
					UserID
				)
		SELECT	ResponseID,
				@UserID AS UserID
		FROM	TEMP_ResponseFilter
		WHERE	(UserID = @UserID);

    END

    SET NOCOUNT OFF

    IF (@AssessmentTypeID_LIST = '2') -- Arrival check -------------------------------------------------------------------------------------------------------------------------------------
    BEGIN
        SELECT	QMS_Response.ResponseID,
				Attachments.NumAttachments,
				QMS_Assessment.AssessmentName,
				ResponseHeader.Supplier,
				ResponseHeader.StockCode, 
                ResponseHeader.Location,
				QMS_Response.StartDate,
				QMS_Response.EndDate,
				QMS_Response.Actual_Score,
				QMS_Response.Actual_QAFlagID,
				ISNULL(dbo.FNC_ResourceString_User(QAFlag.ResourceName, @UserID), QAFlag.QAFlag) as QAFlag,
                QMS_Response.Override_QAFlagID, 
				ISNULL(dbo.FNC_ResourceString_User(QAFlag_Override.ResourceName, @UserID),
				QAFlag_Override.QAFlag) as Override_QAFlag,
				QMS_Response.Offline_ResponseID, 
                CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
				dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck,
				QMS_User.FullName
		FROM    QMS_Response
		INNER JOIN	TEMP_Selected
					ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
					AND TEMP_Selected.UserID = @UserID
		INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
		INNER JOIN	QMS_User
				ON QMS_Response.UserID = QMS_User.UserID
		LEFT OUTER JOIN dbo.FNC_ResponseHeader() AS ResponseHeader
				ON QMS_Response.ResponseID = ResponseHeader.ResponseID
		LEFT OUTER JOIN
                    (
						SELECT	SourceObjectID AS ResponseID, COUNT(AttachmentID) AS NumAttachments
						FROM	QMS_Attachment
						WHERE	AttachmentSourceID = 1
								AND RecordStatus < 201
						GROUP BY SourceObjectID
					) AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID
		LEFT OUTER JOIN
                    (
						SELECT	QAFlagID, ResourceName,QAFlag
						FROM	APP_QAFlag
					) AS QAFlag_Override
					ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
		LEFT OUTER JOIN
                    (
						SELECT	QAFlagID, ResourceName,QAFlag
						FROM	APP_QAFlag AS APP_QAFlag_1
					) AS QAFlag
					ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
		WHERE	
			(
				QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)
				AND 
				(
					@AssessmentID = QMS_Response.AssessmentID
					OR @AssessmentID IS NULL
				)
				AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)
			)
			AND 
			(
				@ShowOutstanding IS NULL
				OR
				(
					@ShowOutstanding = 1
					AND QMS_Response.ResponseStatus = 0
				)
				OR
				(
					@ShowOutstanding = 0
					AND QMS_Response.ResponseStatus <> 0
				)
			)    
		ORDER BY QMS_Response.EndDate DESC;
    END
    ELSE
	BEGIN 
        IF (@AssessmentTypeID_LIST IN ( '3', '4', '5' )) -- Online/Label/Dispatch -------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
            SELECT	QMS_Response.ResponseID,
					Attachments.NumAttachments,
					ResponseHeader.Customer,
					ResponseHeader.StockCode,
					ResponseHeader.Location, 
					ResponseHeader.DepotDate AS [Depot date],
					QMS_Assessment.AssessmentName,
					QMS_Response.StartDate,
					QMS_Response.EndDate, 
					QMS_Response.Actual_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag.ResourceName, @UserID), QAFlag.QAFlag) AS QAFlag,
					QMS_Response.Override_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag_Override.ResourceName, @UserID), QAFlag_Override.QAFlag) AS Override_QAFlag,
					QMS_Response.Offline_ResponseID,
					CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
					dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck, 
					QMS_User.FullName
			FROM	QMS_Response
			INNER JOIN	TEMP_Selected
				ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
				AND TEMP_Selected.UserID = @UserID
			INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
			INNER JOIN	QMS_User
				ON QMS_Response.UserID = QMS_User.UserID
			LEFT OUTER JOIN	dbo.FNC_ResponseHeader() AS ResponseHeader
				ON QMS_Response.ResponseID = ResponseHeader.ResponseID
			LEFT OUTER JOIN
                    (
						SELECT	SourceObjectID AS ResponseID,
								COUNT(AttachmentID) AS NumAttachments
						FROM	QMS_Attachment
						WHERE   AttachmentSourceID = 1
								AND RecordStatus < 201
						GROUP BY SourceObjectID
					) AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID
			LEFT OUTER JOIN
                    (
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag_Override
					ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
			LEFT OUTER JOIN
                    (
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag
					ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
			WHERE
				(
					QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)
					AND
					(
						@AssessmentID = QMS_Response.AssessmentID
						OR @AssessmentID IS NULL
					)
					AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)
				)
				AND
				(
					@ShowOutstanding IS NULL
					OR
					(
						@ShowOutstanding = 1
						AND	QMS_Response.ResponseStatus = 0
					)
					OR
					(
						@ShowOutstanding = 0
						AND QMS_Response.ResponseStatus <> 0
					)
				)
			ORDER BY QMS_Response.EndDate DESC;
        END
        ELSE IF (@AssessmentTypeID_LIST = '6') -- Shelf life -------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
			--SELECT 
			--		UserID = @UserID, 
			--		AssessmentID = @AssessmentID,
			--		AssessmentTypeID_LIST = @AssessmentTypeID_LIST,
			--		ShowOutstanding = @ShowOutstanding,
			--		multiCheckDisplay = @multiCheckDisplay

		     EXEC QRY_Response_PreviousList_ShelfLife 
					@UserID = @UserID, 
					@AssessmentID = @AssessmentID,
					@AssessmentTypeID_LIST = @AssessmentTypeID_LIST,
					@ShowOutstanding = @ShowOutstanding,
					@multiCheckDisplay = @multiCheckDisplay
        END

		ELSE IF (@AssessmentTypeID_LIST = '16') --Active Quality Chain -------------------------------------------------------------------------------------------------------------------------------------
        BEGIN
            SELECT	QMS_Response.ResponseID,
					Attachments.NumAttachments,
					ResponseHeader.Customer,
					ResponseHeader.StockCode,
					ResponseHeader.Location, 
					ResponseHeader.AssessmentSubType AS [Test type],
					ResponseHeader.DepotDate AS [Depot date],
					QMS_Assessment.AssessmentName,
					QMS_Response.StartDate, 
					QMS_Response.EndDate,
					QMS_Response.Actual_QAFlagID,
					ISNULL(dbo.FNC_ResourceString_User(QAFlag.ResourceName, @UserID), QAFlag.QAFlag) AS QAFlag,
					QMS_Response.Override_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag_Override.ResourceName, @UserID),
					QAFlag_Override.QAFlag) AS Override_QAFlag,
					QMS_Response.Offline_ResponseID,
					CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
					dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck, 
					QMS_User.FullName, CAST(CASE WHEN @AQCApproval = 1 THEN ISNULL(dbo.FNC_Response_IsApproved(QMS_Response.ResponseID), 0) ELSE 1 END AS BIT) AS IsApproved,
					ISNULL(dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID), 0) AS MultiCheckLevel
			FROM	QMS_Response
			INNER JOIN	TEMP_Selected
				ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
				AND TEMP_Selected.UserID = @UserID
			INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
			INNER JOIN	QMS_User ON QMS_Response.UserID = QMS_User.UserID
			LEFT OUTER JOIN	dbo.AQC_FNC_ResponseHeader() AS ResponseHeader
				ON QMS_Response.ResponseID = ResponseHeader.ResponseID
				
			LEFT OUTER JOIN
					(
						SELECT	SourceObjectID AS ResponseID,
								COUNT(AttachmentID) AS NumAttachments

						FROM	QMS_Attachment

						WHERE	AttachmentSourceID = 1
								AND RecordStatus < 201

						GROUP BY SourceObjectID
					) AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID 
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag_Override
					ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
					
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								ResourceName,
								QAFlag

						FROM	APP_QAFlag
					) AS QAFlag
					ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
			WHERE
				(
					QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)
					AND
					(
						(
							@multiCheckDisplay = 1
							AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) = 1
						)
						OR
						(
							@multiCheckDisplay = 2
							AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (1,2)
						)
						OR dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) = 0
					)
					AND
					(
						@AssessmentID = QMS_Response.AssessmentID
						OR @AssessmentID IS NULL
					)
				)
				AND
				(
					@ShowOutstanding IS NULL
					OR
					(
						@ShowOutstanding = 1
						AND QMS_Response.ResponseStatus = 0
					)
					OR
					(
						@ShowOutstanding = 0
						AND QMS_Response.ResponseStatus <> 0
					)
				)
			ORDER BY QMS_Response.EndDate DESC;
        END
        ELSE 
        BEGIN -------------------------------------------------------------------------------------------------------------------------------------
            SELECT	QMS_Response.ResponseID,
					Attachments.NumAttachments,
					QMS_Assessment.AssessmentName,
					ResponseHeader.Location,
					QMS_Response.StartDate, 
					QMS_Response.EndDate,
					QMS_Response.Actual_Score,
					QMS_Response.Actual_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag.ResourceName, @UserID), QAFlag.QAFlag) AS QAFlag, 							  
					QMS_Response.Override_QAFlagID, 
					ISNULL(dbo.FNC_ResourceString_User(QAFlag_Override.ResourceName, @UserID), QAFlag_Override.QAFlag) AS Override_QAFlag,
					QMS_Response.Offline_ResponseID,
					CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) 
					= 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
					dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck,
					QMS_User.FullName
			FROM	QMS_Response
			INNER JOIN	TEMP_Selected
				ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
				AND TEMP_Selected.UserID = @UserID
			INNER JOIN	QMS_Assessment
				ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
			INNER JOIN	QMS_User
				ON QMS_Response.UserID = QMS_User.UserID
			LEFT OUTER JOIN
					(
						SELECT	SourceObjectID AS ResponseID,
								COUNT(AttachmentID) AS NumAttachments
						FROM	QMS_Attachment
						WHERE	AttachmentSourceID = 1
								AND RecordStatus < 201
						GROUP BY SourceObjectID
					) AS Attachments
					ON QMS_Response.ResponseID = Attachments.ResponseID
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								ResourceName,
								QAFlag
						FROM	APP_QAFlag
					) AS QAFlag_Override
					ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
			LEFT OUTER JOIN
					(
						SELECT	QAFlagID,
								QAFlag,ResourceName 
						FROM	APP_QAFlag
					) AS QAFlag
					ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
			LEFT OUTER JOIN	dbo.FNC_ResponseHeader() AS ResponseHeader
					ON QMS_Response.ResponseID = ResponseHeader.ResponseID
			WHERE
				(
					QMS_Response.AssessmentTypeID IN
							(
								SELECT	CONVERT(INT, Token) AS Expr1
								FROM	dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',')
							)
					AND
					(
						@AssessmentID = QMS_Response.AssessmentID OR
						@AssessmentID IS NULL
					)
					AND
					(
						dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)
					) 
				)
				AND
				(
					@ShowOutstanding IS NULL
					OR
					(
						@ShowOutstanding = 1
						AND QMS_Response.ResponseStatus = 0
					)
					OR
					(
						@ShowOutstanding = 0
						AND QMS_Response.ResponseStatus <> 0
					)
				)
			ORDER BY QMS_Response.EndDate DESC;
        END
	END

--get list of columns that need to be hidden in Excel export
--NOTE:		tableindex is important, and zero based. This export table is table 1 because it's the second table returned in the dataset
--		FixedColumns: These are returned in the main body. These should be fixed. Leave this as NULL to use default ones specified by front end.
--		StaticColumns: These are displayed underneath the compact text in the grid, and do not move, but are specific for each customer.
--		CyclicColumns: If this contains the word "REMAINING_COLUMNS", then it will also include any columns not specified in Fixed or Static.
-- NOTE:	leabing static and cyclic columns NULL will use first two columns not in the default fixed columns as "static", and other columns not in either fixed or static as "cyclic"
    SELECT	1 AS TableIndex,
            CONVERT(BIT, 1) AS ExportSetupTable ,
            'Portrait/Landscape' AS Orientation ,
            'n/a' AS SheetName ,
            'n/a' AS HiddenColumns ,
            'n/a' AS FixedColumns ,
            'n/a' AS StaticColumns ,
            'n/a' AS CyclicColumns
    UNION

    SELECT  0 ,
            0 ,
            'Portrait' ,
            'View Checks' ,
            NULL ,
            NULL ,
            'Location,FullName' ,
            'REMAINING_COLUMNS'
    ORDER BY TableIndex ASC

END
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Response_PreviousList_ShelfLife')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Response_PreviousList_ShelfLife] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jonathan Toolan
-- Create date: 28/07/2017
-- Description:	Gets list of previous responses for shelf life.
-- Version:		1
-- =============================================
-- JT TFS 82047 - Extract and re-write shelf-life code to improve performance. FNC_ResponseHeader does not handle unbounded queries well.
-- =============================================
ALTER PROCEDURE dbo.QRY_Response_PreviousList_ShelfLife
    @UserID INT ,
    @AssessmentID INT = NULL ,
    @AssessmentTypeID_LIST NVARCHAR(255) = NULL ,
    @ShowOutstanding BIT = 0 , -- 0: show completed checks only, 1: show outstanding checks only, NULL: show all checks regardless of ResponseStatus.
	@multiCheckDisplay int
AS
BEGIN
	--SELECT @UserID = 1,	@AssessmentID = NULL, @AssessmentTypeID_LIST = '6', @ShowOutstanding = 1, @multiCheckDisplay = 1

	SET NOCOUNT ON

	IF NULLIF(object_id('tempdb..#tmpQAFlag'), 0) IS NOT NULL DROP TABLE #tmpQAFlag;
	SELECT QAFlagID, ISNULL(dbo.FNC_ResourceString_User(QAFlag.ResourceName, @UserID), QAFlag.QAFlag) AS QAFlag
	INTO #tmpQAFlag
	FROM APP_QAFlag AS QAFlag;

	IF NULLIF(object_id('tempdb..#tmpResult'), 0) IS NOT NULL DROP TABLE #tmpResult;
	SELECT	QMS_Response.ResponseID,
			QMS_Assessment.AssessmentName, QMS_Response.StartDate, 
			QMS_Response.EndDate, QMS_Response.Actual_QAFlagID,
			QAFlag.QAFlag AS QAFlag,
			QMS_Response.Override_QAFlagID,
			QAFlag_Override.QAFlag AS Override_QAFlag,
			QMS_Response.Offline_ResponseID,
			CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete,
			dbo.FNC_AssessmentType_IsWebCheck(QMS_Response.AssessmentTypeID) AS IsWebCheck, 
			QMS_User.FullName
	INTO #tmpResult
	FROM	QMS_Response
	INNER JOIN	TEMP_Selected
		ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
		AND TEMP_Selected.UserID = @UserID
	INNER JOIN	QMS_Assessment
		ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID
	INNER JOIN	QMS_User
		ON QMS_Response.UserID = QMS_User.UserID
	LEFT OUTER JOIN #tmpQAFlag AS QAFlag_Override
			ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID
	LEFT OUTER JOIN #tmpQAFlag AS QAFlag
			ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
	WHERE
		(
			QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)
			AND
			(
				@AssessmentID = QMS_Response.AssessmentID
				OR @AssessmentID IS NULL
			)
			AND dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)
		)
		AND
		(
			@ShowOutstanding IS NULL
			OR
			(
				@ShowOutstanding = 1
				AND QMS_Response.ResponseStatus = 0
			)
			OR
			(
				@ShowOutstanding = 0
				AND QMS_Response.ResponseStatus <> 0
			)
		)
	ORDER BY QMS_Response.EndDate DESC;

	-- This bit is what is taking all the time.
	IF NULLIF(object_id('tempdb..#tmpHeader'), 0) IS NOT NULL DROP TABLE #tmpHeader;
	SELECT	ResponseHeader.ResponseID,  
			ResponseHeader.Customer,
			ResponseHeader.StockCode,
			ResponseHeader.Location, 
			ResponseHeader.AssessmentSubType AS [Test type],
			ResponseHeader.DepotDate AS [Depot date]
	INTO #tmpHeader
	FROM dbo.FNC_ResponseHeader() ResponseHeader
	WHERE ResponseHeader.ResponseID IN (SELECT ResponseID FROM #tmpResult)


	IF NULLIF(object_id('tempdb..#tmpAttachment'), 0) IS NOT NULL DROP TABLE #tmpAttachment;
	SELECT	SourceObjectID AS ResponseID,
			COUNT(AttachmentID) AS NumAttachments
	INTO #tmpAttachment
	FROM	QMS_Attachment
	WHERE	AttachmentSourceID = 1
			AND RecordStatus < 201
	AND SourceObjectID IN (SELECT ResponseID FROM #tmpResult)
	GROUP BY SourceObjectID

	SET NOCOUNT OFF

	SELECT	result.ResponseID,
			Attachments.NumAttachments,
			ResponseHeader.Customer,
			ResponseHeader.StockCode,
			ResponseHeader.Location, 
			ResponseHeader.[Test type],
			ResponseHeader.[Depot date],
			result.AssessmentName, result.StartDate, 
			result.EndDate, result.Actual_QAFlagID,
			result.QAFlag,
			result.Override_QAFlagID,
			result.Override_QAFlag,
			result.Offline_ResponseID,
			result.Complete,
			result.IsWebCheck, 
			result.FullName
	FROM #tmpResult result
	LEFT OUTER JOIN #tmpAttachment Attachments ON result.ResponseID = Attachments.ResponseID
	LEFT OUTER JOIN #tmpHeader ResponseHeader ON result.ResponseID = ResponseHeader.ResponseID

END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'UP_NotificationSetup_NotificationSent')
	EXEC ('CREATE PROCEDURE [dbo].[UP_NotificationSetup_NotificationSent] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 14/10/2008
-- Description:	Updates notification setup when a new alert sent
-- Version:		2
-- =============================================
-- JT TFS 83153 - Allow resetting of LastSent for testing purposes
-- =============================================
ALTER PROCEDURE UP_NotificationSetup_NotificationSent 
	@NotificationSetupID int,
	@LastSent datetime = NULL
AS

UPDATE    QMS_NotificationSetup
SET              LastSent = ISNULL(@LastSent, GETDATE())
WHERE     (NotificationSetupID = @NotificationSetupID)
GO




PRINT 'Database updated successfully!'
GO

