-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO

-- BEGIN DATA QMS_SupplierResponse_ConsignmentItemID_81359
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'QMS_SupplierResponse' AND COLUMN_NAME = 'ConsignmentItemID')
BEGIN
	ALTER TABLE dbo.QMS_SupplierResponse ADD ConsignmentItemID int NULL
END
GO
-- END DATA QMS_SupplierResponse_ConsignmentItemID_81359

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_SupplierResponse')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_SupplierResponse] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 23/12/2009
-- Description:	Imports individual row into QMS_SupplierResponse table on GreenlightQC_Mobile
-- Version:		2
-- =============================================
-- JT TFS 81301 - Add ConsignmentItemID to column list to import
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_SupplierResponse] 
	@ResponseID int,
	@SupplierID int,
	@StockCodeID int,
	@LocationID int,
	@EndDate datetime,
	@ArrivalDate datetime,
	@QuantityReceived int,
	@QuantityChecked int,
	@QuantityAccepted int,
	@QuantityRejected int,
	@QAFlagID int,
	@RedResponses nvarchar(1000),
	@Comments nvarchar(2000),
	@AssessmentTypeID int = NULL,
	@AssessmentID int = NULL,
	@ConsignmentID int = NULL,
	@ConsignmentItemID int = NULL,
	@DUDate datetime = NULL,
	@RecordStatus tinyint,
	@Updated datetime,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@Barcode nvarchar(max),
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS
BEGIN
	SET @EndDate = dbo.FNC_ConvertServerDate(@EndDate)
	SET @ArrivalDate = dbo.FNC_ConvertServerDate(@ArrivalDate)
	SET @DUDate = dbo.FNC_ConvertServerDate(@DUDate)

	IF NOT EXISTS(SELECT * FROM QMS_SupplierResponse WHERE (ResponseID = @ResponseID))
	BEGIN --Append record
		IF @RecordStatus < 201
		BEGIN
			--SET IDENTITY_INSERT QMS_SupplierResponse ON
			INSERT INTO QMS_SupplierResponse
						  (ResponseID, SupplierID, StockCodeID, LocationID, EndDate, ArrivalDate, QuantityReceived, QuantityChecked, QuantityAccepted, QuantityRejected, QAFlagID, 
						  RedResponses, Comments, AssessmentTypeID, AssessmentID, DUDate, ConsignmentID, RecordStatus, Updated, GUID, Barcode, ConsignmentItemID)
			VALUES     (@ResponseID, @SupplierID, @StockCodeID, @LocationID, @EndDate, @ArrivalDate, @QuantityReceived, @QuantityChecked, @QuantityAccepted, @QuantityRejected, @QAFlagID,
						@RedResponses, @Comments, @AssessmentTypeID, @AssessmentID, @DUDate, @ConsignmentID, @RecordStatus, @Updated, @GUID, @Barcode, @ConsignmentItemID)
			SET @InsertCount = @@rowcount
			--SET IDENTITY_INSERT QMS_SupplierResponse OFF
		END
	END

	ELSE
	BEGIN --Update record
		UPDATE    QMS_SupplierResponse
		SET              SupplierID = @SupplierID, StockCodeID = @StockCodeID, LocationID = @LocationID, EndDate = @EndDate, ArrivalDate = @ArrivalDate, 
						  QuantityReceived = @QuantityReceived, QuantityChecked = @QuantityChecked, QuantityAccepted = @QuantityAccepted, QuantityRejected = @QuantityRejected, 
						  QAFlagID = @QAFlagID, RedResponses = @RedResponses, Comments = @Comments, AssessmentTypeID = @AssessmentTypeID, 
						  AssessmentID = @AssessmentID, DUDate = @DUDate, ConsignmentID = @ConsignmentID, RecordStatus = @RecordStatus, Updated = @Updated, Barcode = @Barcode,
						  ConsignmentItemID = @ConsignmentItemID
		WHERE     (ResponseID = @ResponseID)
		SET @UpdateCount = @@rowcount
	END

	IF CAST(@RowVersion AS bigint) > @Created
		SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
	ELSE
		SET @ReceivedAnchor = @Created
END
GO


PRINT 'Database updated successfully!'
GO

