-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Menu')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Menu] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: Markp
-- Create date	: 26/06/2008
-- Description	: Gets menu structure for specified application
-- Version		: 3
-- =============================================
-- PH TFS 13-60735 : v2 14/11/2016 - include new translations logic.
-- JT TFS 13-74870 : v3 1/8/2017 - Include the batch check form if the config option BatchCheckAssessmentTypeId is set.
-- =============================================
ALTER PROCEDURE [dbo].[QRY_Menu] 
	@AppID int,
	@UserID int = NULL
AS
BEGIN

	SET NOCOUNT ON;
	DECLARE @AlwaysInclude TABLE (MenuID int, AppID int)
	IF NULLIF(dbo.FNC_GetOptionValue(144), 0) IS NOT NULL -- BatchCheckAssessmentTypeId
		INSERT @AlwaysInclude (MenuID, AppID)
		SELECT MenuID, AppID FROM APP_Menu
		WHERE MenuAction LIKE 'Greenlight.QC.Mobile.exe;frmBatchCheck%'
	SET NOCOUNT OFF;

	SELECT
		MenuID,
		MenuIndex,
		ParentID,
		ISNULL(ISNULL(dbo.FNC_ResourceString(menu.ResourceKeyID, @UserID), dbo.FNC_ResourceString_User(menu.ResourceName, @UserID)),  Description) AS Description,
		ResourceName,
		IconName,
		SeperatorBefore,
		MenuAction
	FROM	APP_Menu AS menu
	WHERE	AppID = @AppID 
	AND		(
		Visible = 1
		OR
		EXISTS (SELECT * FROM @AlwaysInclude WHERE MenuID = menu.MenuID AND AppID = @AppID)
	)
	ORDER BY CASE WHEN @AppID = 3 THEN MenuIndex ELSE ParentID END, MenuIndex;
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_AssessmentType_HasAssessments_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_AssessmentType_HasAssessments_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Stu Stephenson
-- Create date: 07/08/2017
-- Description:	Gets data to fill Assessment Type combo. Assessment Type will show if it has any assessments against it.
-- Version: 1
-- =============================================
-- SS TFS 13-73654: SP Created
-- =============================================
ALTER PROCEDURE [dbo].[QRY_AssessmentType_HasAssessments_Combo] 
	@UserID int = NULL
AS
SELECT
	at.AssessmentTypeID,
	ISNULL(dbo.FNC_ResourceString_User(at.ResourceName, @UserID), at.AssessmentType) AS AssessmentType
FROM APP_AssessmentType at
WHERE AssessmentTypeID IN 
(
	SELECT
		a.AssessmentTypeID
	FROM QMS_Assessment a
	WHERE a.AssessmentStatusID <> 4
	AND a.RecordStatus < 201
	UNION ALL
	SELECT
		atm.AssessmentTypeID
	FROM QMS_AssessmentTypeMulti atm
	WHERE atm.RecordStatus < 201
)
ORDER BY at.ListIndex
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QAS_RPT_Specification_HeaderSub')
	EXEC ('CREATE PROCEDURE [dbo].[QAS_RPT_Specification_HeaderSub] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jon Edwards
-- Create date: 05/02/2013
-- Description:	Returns header data for QAS report
-- Version:		4
-- =============================================
-- JT TFS 13-53793: 15/08/2016 - Link to master assessment specheader on Sys_AssSpecHeaderID
-- UK TFS 75641: 10/07/2017 - Headers not filled in via integration are now hidden
-- JT TFS 78848: 3/8/2017 - Pictures now show on QAS.
-- =============================================
ALTER PROCEDURE dbo.QAS_RPT_Specification_HeaderSub 
	@AssessmentID INT
AS
--get master AssessmentID for @AssessmentID if @AssessmentID is a temp spec
DECLARE @MasterAssessmentID AS int

SELECT	@MasterAssessmentID = MAX(QMS_Assessment_Master.AssessmentID)
FROM	QMS_Assessment AS QMS_Assessment_Master INNER JOIN
			QMS_Assessment AS QMS_Assessment_Temp ON QMS_Assessment_Master.Sys_AssessmentID = QMS_Assessment_Temp.Sys_AssessmentID
WHERE	(QMS_Assessment_Master.TempSpec = 0) AND (QMS_Assessment_Master.AssessmentStatusID = 3) AND
			(QMS_Assessment_Temp.AssessmentID = @AssessmentID) AND (QMS_Assessment_Temp.TempSpec = 1)

--get attachments for assessment
DECLARE @Attachment_Table TABLE (AssessmentSpecHeaderID int, AttachmentTitle nvarchar(255), Attachment image)

INSERT INTO @Attachment_Table (AssessmentSpecHeaderID, AttachmentTitle, Attachment)
SELECT	SourceObjectID AS AssessmentSpecHeaderID, AttachmentTitle, Attachment
FROM	QMS_Attachment
WHERE	(AttachmentSourceID = 4) AND (QMS_Attachment.RecordStatus < 201) AND (SourceObjectID IN
                          (SELECT     AssessmentSpecHeaderID --get attachments for master assessment too (only applies if running report for temp spec)
                            FROM          QMS_AssessmentSpecHeader
                            WHERE      (AssessmentID = @AssessmentID)))

IF @MasterAssessmentID IS NOT NULL --temp spec, so add temp spec attachments too
BEGIN
	INSERT INTO @Attachment_Table (AssessmentSpecHeaderID, AttachmentTitle, Attachment)
	SELECT	Temp.AssessmentSpecHeaderID, AttachmentTitle, Attachment
	FROM	QMS_Attachment INNER JOIN
				QMS_AssessmentSpecHeader ON QMS_Attachment.SourceObjectID = QMS_AssessmentSpecHeader.AssessmentSpecHeaderID INNER JOIN
				QMS_AssessmentSpecHeader AS Temp ON QMS_AssessmentSpecHeader.Sys_AssSpecHeaderID = Temp.Sys_AssSpecHeaderID
	WHERE	(AttachmentSourceID = 4) AND (QMS_Attachment.RecordStatus < 201) AND
				(QMS_AssessmentSpecHeader.AssessmentID = @MasterAssessmentID) AND (Temp.AssessmentID = @AssessmentID) AND
					(Temp.AssessmentSpecHeaderID NOT IN (SELECT AssessmentSpecHeaderID
														 FROM	@Attachment_Table))
END														 

--create table variable to store Multi-Text (note: don't use temp table as this introduces problems with collation)
DECLARE @MultiHeader TABLE (AssessmentSpecHeaderID int, Multi_Text nvarchar(1000))

INSERT INTO @MultiHeader (AssessmentSpecHeaderID, Multi_Text)
SELECT	SpecHeader.AssessmentSpecHeaderID,
		--if over 1000 chars, limit length so SP doesn't fail
		CASE WHEN LEN(Multi_Text_String) > 1000 THEN LEFT(Multi_Text_String, 997) + '...' ELSE Multi_Text_String END AS Multi_Text
FROM	(
	SELECT	SpecHeader.AssessmentSpecHeaderID,
			dbo.FNC_UnescapeXMLPath (substring(
			(	SELECT ', ' + QMS_AssessmentSpecHeaderMulti.Multi_Text
						FROM	QMS_AssessmentSpecHeaderMulti WHERE SpecHeader.AssessmentSpecHeaderID = QMS_AssessmentSpecHeaderMulti.AssessmentSpecHeaderID
						AND		(Multi_SourceID > -1)
						AND		NULLIF(Multi_Text, '') IS NOT NULL
						AND		RecordStatus < 201
						FOR XML PATH('')), 3, 99999)) [Multi_Text_String]
	 FROM QMS_AssessmentSpecHeader SpecHeader 
	 WHERE	(SpecHeader.AssessmentID = @AssessmentID) 
) AS [SpecHeader]
WHERE Multi_Text_String IS NOT NULL


IF NULLIF(object_id('tempdb..#TempQMS_AssessmentHeader'), 0) IS NOT NULL DROP TABLE #TempQMS_AssessmentHeader;
--main query to return dataset for report
SELECT QMS_AssessmentSpecHeader.AssessmentID,
	   QMS_SpecificationHeader.HeaderTitle,
	  QMS_AssessmentSpecHeader.Spec_SourceID,
	   CASE WHEN QMS_AssessmentSpecHeader.Spec_SourceID = -1 THEN MultiHeader.Multi_Text ELSE QMS_AssessmentSpecHeader.Spec_Text END AS Spec_Text,
	   QMS_SpecificationHeader.DataTypeID,
	   Attachment.AttachmentTitle, 
	   Attachment.Attachment,
	   QMS_SpecificationHeader.ListIndex
INTO #TempQMS_AssessmentHeader
FROM QMS_AssessmentSpecHeader
	INNER JOIN QMS_SpecificationHeader ON QMS_AssessmentSpecHeader.SpecificationHeaderID = QMS_SpecificationHeader.SpecificationHeaderID
	LEFT OUTER JOIN @Attachment_Table AS Attachment ON QMS_AssessmentSpecHeader.AssessmentSpecHeaderID = Attachment.AssessmentSpecHeaderID 
	LEFT OUTER JOIN @MultiHeader AS MultiHeader ON QMS_AssessmentSpecHeader.AssessmentSpecHeaderID = MultiHeader.AssessmentSpecHeaderID
WHERE (QMS_AssessmentSpecHeader.AssessmentID = @AssessmentID)
	AND (QMS_AssessmentSpecHeader.RecordStatus < 201)
	AND (QMS_AssessmentSpecHeader.NotApplicable = 0) 
	AND (QMS_SpecificationHeader.HideFromReports = 0)
	AND (QMS_SpecificationHeader.RecordStatus < 201)
	AND (QMS_SpecificationHeader.DataTypeID < 11) 
	OR --filters for attachment data 
		(QMS_AssessmentSpecHeader.AssessmentID = @AssessmentID)
	AND (QMS_AssessmentSpecHeader.RecordStatus < 201)
	AND (QMS_SpecificationHeader.HideFromReports = 0)
	AND (QMS_SpecificationHeader.RecordStatus < 201)
	AND (QMS_SpecificationHeader.DataTypeID = 11)
	AND (Attachment.Attachment IS NOT NULL)				  

--Temp table used to filter result set so that only non-empty spec_text is shown
SELECT #TempQMS_AssessmentHeader.AssessmentID,
	#TempQMS_AssessmentHeader.HeaderTitle,
	#TempQMS_AssessmentHeader.Spec_SourceID,
	#TempQMS_AssessmentHeader.Spec_Text,
	#TempQMS_AssessmentHeader.DataTypeID,
	#TempQMS_AssessmentHeader.AttachmentTitle,
	#TempQMS_AssessmentHeader.Attachment
FROM #TempQMS_AssessmentHeader
WHERE (#TempQMS_AssessmentHeader.Spec_Text IS NOT NULL 
	  OR #TempQMS_AssessmentHeader.Spec_Text <> '')
OR #TempQMS_AssessmentHeader.Attachment IS NOT NULL
ORDER BY #TempQMS_AssessmentHeader.ListIndex

GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_BatchCheck_PendingList')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_BatchCheck_PendingList] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 4/8/17
-- Description:	Gets a list of available batch checks
-- Version:		2
-- =============================================
-- JF TFS 79208 - initial version
-- JT TFS 80487 - Create a base-generic version.
-- =============================================
ALTER PROCEDURE [dbo].[QRY_BatchCheck_PendingList]
	@AssessmentTypeID int = NULL,
	@UserID int = 0,
	@ENV_CMP nvarchar(100) = NULL -- @ENV parameters are autopopulated by batch check form.
AS
	-- get the default location from the windows variable
	DECLARE @DefaultLocationCode nvarchar(50)='', @DefaultLocationID INT=null
	SELECT @DefaultLocationCode = ISNULL(@ENV_CMP, '')
	SELECT @DefaultLocationID = LocationID FROM PM_VW_Location WHERE LocationCode = @DefaultLocationCode
	
	SELECT	PM_VW_ConsignmentItems.ConsignmentItemID as Lookup_ConsignmentItemId_Key, --used to get unique header data
			CAST(0 AS bit) AS [Select],
			PM_VW_Location.DisplayText as [Location],
			PM_VW_Location.LocationID as Lookup_LocationID,
			PM_VW_Supplier.DisplayText as SupplierName,
			PM_VW_Supplier.SupplierID as Lookup_SupplierID,
			PM_VW_StockCode.DisplayText as StockCode,
			PM_VW_StockCode.StockCodeID as Lookup_StockCodeID
	FROM PM_VW_ConsignmentItems 
	INNER JOIN PM_VW_Consignment on  PM_VW_ConsignmentItems.ConsignmentID = PM_VW_consignment.ConsignmentID 
	INNER JOIN PM_VW_Location ON PM_VW_Location.Locationid = PM_VW_consignment.Locationid 
	INNER JOIN PM_VW_Supplier on PM_VW_Supplier.SupplierID = PM_VW_consignment.SupplierID 
	INNER JOIN PM_VW_StockCode on PM_VW_ConsignmentItems.StockCodeID = PM_VW_StockCode.StockCodeID

	WHERE 
			(PM_VW_Location.LocationID =  @DefaultLocationID OR @DefaultLocationID IS NULL) 
		AND (PM_VW_ConsignmentItems.DateRequired >= getdate()) 
		AND (PM_VW_ConsignmentItems.DepotDate  <= getdate())

	ORDER BY PM_VW_Supplier.suppliername, PM_VW_StockCode.DisplayText
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_BatchCheck_TempHeader')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_BatchCheck_TempHeader] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 8/8/17
-- Description:	Inserts records into TEMP_ResponseHeader to await SaveResponse method
-- Version: 	2
-- =============================================
-- JF TFS 80361 - initial version
-- JT TFS 80383 - Create generic version, populating SupplierID, LocationID, StockCodeID and ConsignmentItemID
-- =============================================
ALTER PROCEDURE [dbo].[QRY_BatchCheck_TempHeader]
	@AssessmentTypeID int,
	@UserID int,
	@SupplierID int = NULL,
	@LocationID int = NULL,
	@StockCodeID int = NULL,
	@ConsignmentItemID int = NULL
AS
BEGIN

	DECLARE @SupplierText nvarchar(255); SELECT @SupplierText = DisplayText FROM PM_VW_Supplier WHERE SupplierID = @SupplierID;
	DECLARE @LocationText nvarchar(255); SELECT @LocationText = DisplayText FROM PM_VW_Location WHERE LocationID = @LocationID;
	DECLARE @StockCodeText nvarchar(255); SELECT @StockCodeText = DisplayText FROM PM_VW_StockCode WHERE StockCodeID = @StockCodeID;

	DECLARE @ConsignmentItemText nvarchar(255); 
	SELECT     @ConsignmentItemText = PM_VW_StockCode.DisplayText  
	FROM         PM_VW_ConsignmentItems 
	INNER JOIN  PM_VW_StockCode ON PM_VW_ConsignmentItems.StockCodeID = PM_VW_StockCode.StockCodeID  
	WHERE    PM_VW_ConsignmentItems.ConsignmentItemID = @ConsignmentItemID 

	DECLARE @HeaderMapping TABLE (
		DataLookupID int,
		DisplayText nvarchar(255),
		SourceID int
	)
	-- SELECT * FROM APP_DataLookup to add new items
	INSERT @HeaderMapping (DataLookupID, DisplayText, SourceID)
	VALUES	(1, @SupplierText, @SupplierID),
			(2, @StockCodeText, @StockCodeID),
			(4, @LocationText, @LocationID),
			(6, @ConsignmentItemText, @ConsignmentItemID)

	DECLARE @Table_Batch TABLE (
		AssessmentHeaderID int,
		Header_Text nvarchar(100),
		Header_SourceID INT,
		Header_ResponseText nvarchar(100),
		SourceObjectID INT
	)

	INSERT INTO @Table_Batch (AssessmentHeaderID, Header_Text, Header_SourceID, Header_ResponseText, SourceObjectID)
	SELECT header.AssessmentHeaderID, header.HeaderText, mapping.SourceID, mapping.DisplayText, mapping.SourceID
	FROM QMS_AssessmentHeader header
	INNER JOIN @HeaderMapping mapping ON header.DataLookupID = mapping.DataLookupID
	WHERE header.AssessmentTypeID = @AssessmentTypeID
	AND header.DataTypeID = 9 -- system (data) lookup
	AND header.RecordStatus < 201
	AND mapping.SourceID IS NOT NULL

	-- Populate TEMP_ResponseHeader
	DELETE FROM TEMP_ResponseHeader where UserID = @UserID;

	INSERT INTO TEMP_ResponseHeader (UserID, AssessmentHeaderID, Header_SourceID, Header_Text, AssessmentTargetTypeID, SourceObjectID)
	SELECT 
		@UserID as UserID, 
		AssessmentHeaderID,
		Header_SourceID,   
		Header_ResponseText,
		null, 
		Header_SourceID   
	FROM @Table_Batch 

	SELECT 
		TEMP_ResponseHeader.*,
		DataTypeID,
		DataLookupID,
		CustomLookupID,
		null as Lookup_DataTypeID,
		Header_SourceID as Response,
		Header_Text as ResponseText,
		ClearForNewCheck,
		HeaderText as SourceObjectID  
	FROM TEMP_ResponseHeader INNER JOIN QMS_AssessmentHeader on QMS_AssessmentHeader.AssessmentHeaderID = TEMP_ResponseHeader.AssessmentHeaderID 
	WHERE TEMP_ResponseHeader.UserID = @UserID
END
GO



PRINT 'Database updated successfully!'
GO

