-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_ResponseHeader_StockCodeIdByResponseId')
	EXEC('CREATE FUNCTION [dbo].[FNC_ResponseHeader_StockCodeIdByResponseId]() RETURNS bit AS BEGIN RETURN 0 END')
GO
-- =============================================
-- Author:		Markp
-- Create date: 25/03/2009
-- Description:	Gets stockcodeid for individual response
-- Version:		5
-- =============================================
-- JT TFS 7830 - Also link through raw stockcode datalookup
-- JE TFS 8684 - added filter so deleted Header items are ignored
-- MP TFS 12720: Added check on ResponseID to mitigate duplicates
-- JF TFS 15314 - timeout issues - changed duplicate check to an outer join (Greencell had 100k records in @ResponseHeader)
-- JT TFS 78355 - Get StockcodeID by reponseID
-- =============================================
ALTER FUNCTION [dbo].[FNC_ResponseHeader_StockCodeIdByResponseId] 
(
	@ResponseId int
)
RETURNS int
AS
BEGIN
	--Add header where stock code selected
	
	RETURN (
		SELECT TOP 1 StockCodeId FROM (
			SELECT     1 AS Source, QMS_Response.ResponseID, QMS_ResponseHeader.Header_SourceID AS StockCodeId
			FROM        QMS_Response 
			INNER JOIN	QMS_ResponseHeader ON QMS_Response.ResponseID = QMS_ResponseHeader.ResponseID 
			INNER JOIN	QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
			WHERE     (QMS_Response.RecordStatus < 201) 
			AND		(QMS_AssessmentHeader.RecordStatus < 201)
			AND		(QMS_ResponseHeader.Header_SourceID IS NOT NULL) 
			AND		(QMS_AssessmentHeader.DataTypeID = 9) 
			AND		(QMS_AssessmentHeader.DataLookupID IN (2, 35)) 
			AND QMS_Response.ResponseID = @ResponseId

			--Add consignment item headers
			UNION ALL
			SELECT  2,  QMS_Response.ResponseID, PM_VW_ConsignmentItems.StockCodeID
			FROM         QMS_Response INNER JOIN
							  QMS_ResponseHeader ON QMS_Response.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
							  QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
							  PM_VW_ConsignmentItems ON QMS_ResponseHeader.Header_SourceID = PM_VW_ConsignmentItems.ConsignmentItemID
			WHERE	(QMS_Response.RecordStatus < 201) 
			AND		(QMS_AssessmentHeader.RecordStatus < 201) 
			AND		(QMS_AssessmentHeader.DataTypeID = 9) 
			AND		(QMS_AssessmentHeader.DataLookupID = 6) 
			AND QMS_Response.ResponseID = @ResponseId
	
			--Add delivery item headers
			UNION ALL
			SELECT  3,   QMS_Response.ResponseID, PM_VW_ConsignmentItems.StockCodeID
			FROM         QMS_Response INNER JOIN
							  QMS_ResponseHeader ON QMS_Response.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
							  QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
							  PM_VW_GoodsIntake ON QMS_ResponseHeader.Header_SourceID = PM_VW_GoodsIntake.GoodsIntakeID INNER JOIN
							  PM_VW_ConsignmentItems ON PM_VW_GoodsIntake.ConsignmentItemID = PM_VW_ConsignmentItems.ConsignmentItemID
			WHERE   (QMS_Response.RecordStatus < 201) 
			AND		(QMS_AssessmentHeader.RecordStatus < 201) 
			AND		(QMS_AssessmentHeader.DataTypeID = 9) 
			AND		(QMS_AssessmentHeader.DataLookupID = 8) 
			AND QMS_Response.ResponseID = @ResponseId
		) as _
		WHERE _.StockCodeId > 0
		ORDER BY Source
	)
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_ResponseQuestion_GetFirstAnswerByName')
	EXEC('CREATE FUNCTION [dbo].[FNC_ResponseQuestion_GetFirstAnswerByName]() RETURNS bit AS BEGIN RETURN 0 END')
GO
-- =============================================
-- Author:		Jonathan Toolan
-- Create date: 26/07/2017
-- Description:	Gets a ResponseQuestion by Name (Can use wildcards)
-- Version:		1
-- =============================================
-- JT TFS 77689: Created
-- =============================================
ALTER FUNCTION dbo.FNC_ResponseQuestion_GetFirstAnswerByName(
	@ResponseId int, 
	@Question nvarchar(255)
)
RETURNS nvarchar(255)
AS 
BEGIN
	RETURN (
		SELECT TOP 1 response.Response_Text
		FROM QMS_ResponseQuestion response
		INNER JOIN QMS_AssessmentQuestion assessment ON response.AssessmentQuestionID = assessment.AssessmentQuestionID
		INNER JOIN QMS_QuestionPool question ON assessment.QuestionID = question.QuestionID
		WHERE response.ResponseID = @ResponseId
		AND question.Question LIKE @Question
		AND response.RecordStatus < 201
		AND assessment.RecordStatus < 201
		AND question.RecordStatus < 201
	)
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Attachment_List')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Attachment_List] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 01/09/2008
-- Description:	Gets all attachments for selected assessment response
-- Version:		5
-- =============================================
-- JE TFS 6272 - returns Child Check Attachments if using Multi Checks
-- MP CAS-24522-Q0B8J9 - fix to prevent blank attachments from making the CA screen raise an error
-- JT TFS-13-3861: Return IsTemp to front end, and hide temp attachments which are empty.
-- JT TFS 13-75874: Show attachments for a response even if it contains child attachments, but hide duplicates.
-- =============================================
ALTER PROCEDURE QRY_Attachment_List 
	@SourceID int,
	@SourceObjectID int,
	@UserID int = 0
AS
BEGIN
	IF @SourceID = 1 --Assessment Response Attachment
	BEGIN
		--get ParentResponseGUID for ResponseID passed in
		DECLARE @ParentResponseGUID uniqueidentifier
		SELECT	@ParentResponseGUID = GUID
		FROM	QMS_Response
		WHERE	ResponseID = @SourceObjectID

		--temp table to hold Child Check ResponseIDs
		IF NULLIF(object_id('tempdb..#tmpChildChecks'), 0) IS NOT NULL DROP TABLE #tmpChildChecks
		CREATE TABLE #tmpChildChecks (ResponseID int)
		--get all Child Checks for above GUID
		INSERT	#tmpChildChecks (ResponseID)
		SELECT	ResponseID
		FROM	QMS_Response
		WHERE	ParentResponseGUID = @ParentResponseGUID
	
		-- We need to eliminate duplicates. Sometimes a parent check will have a copy of a child check's attachment after an approval.
		IF NULLIF(object_id('tempdb..#tmpAttachments'), 0) IS NOT NULL DROP TABLE #tmpAttachments
		SELECT	AttachmentID, 
				GETCHECKSUM(Attachment) AS AttachmentCheckSum, 
				AttachmentFileName, RecordStatus, UserID, 
				convert(bit, 0) AS HasChildDuplicate,
				CASE WHEN SourceObjectID = @SourceObjectID THEN 1 ELSE 0 END AS IsParentAttachment
		INTO #tmpAttachments
		FROM QMS_Attachment
		WHERE AttachmentSourceID = @SourceID
		AND (
			SourceObjectID = @SourceObjectID 
			OR
			SourceObjectID IN (SELECT ResponseID FROM #tmpChildChecks)
		)

		UPDATE parent
		SET HasChildDuplicate = 1
		FROM #tmpAttachments AS parent
		WHERE EXISTS (	SELECT * FROM #tmpAttachments AS child 
						WHERE parent.AttachmentFileName = child.AttachmentFileName
						AND parent.AttachmentCheckSum = child.AttachmentCheckSum
						AND parent.AttachmentID <> child.AttachmentID)
		AND parent.IsParentAttachment = 1
		
		--get Child Check count
		DECLARE @ChildCheckCount int
		SELECT @ChildCheckCount = COUNT(ResponseID) FROM #tmpChildChecks
		
		SELECT     AttachmentID, AttachmentSourceID, SourceObjectID, AttachmentTitle, AttachmentFileName, Attachment, AttachmentURL, IsTemp = convert(bit, CASE WHEN RecordStatus = 100 OR SourceObjectID = 0 THEN 1 ELSE 0 END)
		FROM         QMS_Attachment
		WHERE   AttachmentID IN (
			SELECT AttachmentID FROM #tmpAttachments
			WHERE HasChildDuplicate = 0
			AND (RecordStatus < 100 OR (RecordStatus = 100 AND UserID = @UserID))
		)

	END
	ELSE
	BEGIN
		SELECT     AttachmentID, AttachmentSourceID, SourceObjectID, AttachmentTitle, AttachmentFileName, Attachment, AttachmentURL, IsTemp = convert(bit, CASE WHEN RecordStatus = 100 OR SourceObjectID = 0 THEN 1 ELSE 0 END)
		FROM         QMS_Attachment
		WHERE     (RecordStatus < 100 OR (RecordStatus = 100 AND UserID = @UserID)) 
		AND			(AttachmentSourceID = @SourceID) 
		AND			(SourceObjectID = @SourceObjectID)

	END
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_ResponseHeader_GetByDataLookupId')
	EXEC('CREATE FUNCTION [dbo].[FNC_ResponseHeader_GetByDataLookupId]() RETURNS bit AS BEGIN RETURN 0 END')
GO
-- =============================================
-- Author:		Jonathan Toolan
-- Create date: 26/07/2017
-- Description:	Gets a ResponseHeader by DataLookupID (System Lookup)
-- Version:		1
-- =============================================
-- JT TFS 77689: Created
-- =============================================
ALTER FUNCTION dbo.FNC_ResponseHeader_GetByDataLookupId (
	@ResponseId int,
	@DataLookupId int
) 
RETURNS int
AS
BEGIN
RETURN (	SELECT TOP 1 Header_SourceID 
			FROM QMS_ResponseHeader response
			INNER JOIN QMS_AssessmentHeader assessment ON response.AssessmentHeaderID = assessment.AssessmentHeaderID
			WHERE response.ResponseID = @ResponseId
			AND assessment.DataLookupID = @DataLookupId
			AND response.RecordStatus < 201
			AND assessment.RecordStatus < 201
			AND response.Header_SourceID IS NOT NULL
			AND assessment.DataTypeID = 9
		)
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_ResponseHeader_GetTextByDataLookupId')
	EXEC('CREATE FUNCTION [dbo].[FNC_ResponseHeader_GetTextByDataLookupId]() RETURNS bit AS BEGIN RETURN 0 END')
GO
-- =============================================
-- Author:		Jonathan Toolan
-- Create date: 26/07/2017
-- Description:	Gets a ResponseHeader by DataLookupID (System Lookup)
-- Version:		1
-- =============================================
-- JT TFS 77689: Created
-- =============================================
ALTER FUNCTION dbo.FNC_ResponseHeader_GetTextByDataLookupId (
	@ResponseId int,
	@DataLookupId int
) 
RETURNS nvarchar(255)
AS
BEGIN
RETURN (	SELECT TOP 1 Header_Text 
			FROM QMS_ResponseHeader response
			INNER JOIN QMS_AssessmentHeader assessment ON response.AssessmentHeaderID = assessment.AssessmentHeaderID
			WHERE response.ResponseID = @ResponseId
			AND assessment.DataLookupID = @DataLookupId
			AND response.RecordStatus < 201
			AND assessment.RecordStatus < 201
			AND assessment.DataTypeID = 9
			AND response.Header_Text IS NOT NULL
		)
END
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_Notification')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_Notification] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 07/10/2008
-- Description:	Creates notification
-- Version:		2
-- =============================================
-- JT TFS 13-77527: 19 Jul 2017 - Modified to return NotificationID added to table.
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_Notification] 
	@SendFrom nvarchar(255) = NULL,
	@SendTo nvarchar(2000),
	@SendCC nvarchar(2000) = NULL,
	@Subject nvarchar(255),
	@MessageBody nvarchar(4000) = NULL,
	@AttachmentTitle nvarchar(255) = NULL,
	@Attachment image = NULL
AS
BEGIN
	INSERT INTO QMS_Notification (SendFrom, SendTo, SendCC, Subject, MessageBody, AttachmentTitle, Attachment)
	OUTPUT INSERTED.NotificationID
	VALUES     (@SendFrom, @SendTo, @SendCC, @Subject, @MessageBody, @AttachmentTitle, @Attachment)
END
GO



PRINT 'Database updated successfully!'
GO

