-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_ResponseAction_NotificationPending')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_ResponseAction_NotificationPending] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 7/5/2013
-- Description:	Gets list of pending response actions
-- Version:		4
-- =============================================
-- MP TFS 6695, 6736: Fix to handle void actions
-- JT TFS 13-75544: Link on assessment type to determine date restriction on email alerts.
-- =============================================
ALTER PROCEDURE QRY_ResponseAction_NotificationPending 
AS

DECLARE @FilterCheckAlertsOlderThan INT = dbo.FNC_GetOptionValue(140)   

SELECT     QMS_ResponseAction.ResponseID, QMS_ResponseAction.ResponseActionID, QMS_ResponseAction.NotificationGroupID, QMS_ResponseAction.NotifySupplier, 
                      QMS_ResponseAction.NotifyAssessor
FROM         QMS_ResponseAction INNER JOIN
                      QMS_Response ON QMS_ResponseAction.ResponseID = QMS_Response.ResponseID
INNER JOIN APP_AssessmentType ON QMS_Response.AssessmentTypeID = APP_AssessmentType.AssessmentTypeID
WHERE   (QMS_ResponseAction.NotificationSent = 0) 
AND		(QMS_ResponseAction.RecordStatus < 201) 
AND		(QMS_ResponseAction.Inserted > DATEADD(day, - ISNULL(APP_AssessmentType.FilterCheckAlertsOlderThan, @FilterCheckAlertsOlderThan), GETDATE())) 
AND (	ISNULL(QMS_ResponseAction.NotificationGroupID, 0) > 0 
		OR
        ISNULL(QMS_ResponseAction.NotifySupplier, 0) = 1 
		OR
        ISNULL(QMS_ResponseAction.NotifyAssessor, 0) = 1
) 
OR
	(QMS_ResponseAction.NotificationSent = 0) 
AND (QMS_ResponseAction.RecordStatus < 201) 
AND (QMS_ResponseAction.Inserted > DATEADD(day, - ISNULL(APP_AssessmentType.FilterCheckAlertsOlderThan, @FilterCheckAlertsOlderThan), GETDATE())) 
AND (QMS_ResponseAction.QAActionID = 9) 
AND (QMS_Response.NotificationSent = 1)
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_StockBatchItems')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_StockBatchItems] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		jf
-- Create date: 11/2/15
-- Description:	Imort StockBatchItems
-- Version:		3
-- =============================================
-- jf 11/2/15 - added @TotalQuantity
-- jf tfs 20519- - check if PM_StockBatch exists before inserting to avoid foreign key errors
-- JF TFS 75828 - Make sure we insert the imported StockItemID
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_PM_StockBatchItems] 
	@StockItemID int, 
	@StockBatchID INt, 
	@StockCodeID int, 
	@SupplierID int, 
	@UseByDate datetime, 
	@RecordStatus tinyint, 
	@Source tinyint, 
	@Updated datetime,  
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@TotalQuantity decimal(18,2),

	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

IF NOT EXISTS(SELECT StockItemID FROM PM_StockBatchItems WHERE (StockItemID = @StockItemID))
BEGIN --Append record
	IF @RecordStatus < 201 and EXISTS(SELECT StockBatchID FROM PM_StockBatch WHERE (StockBatchID  = @StockBatchID))
	BEGIN
		set identity_insert dbo.PM_StockBatchItems on
		INSERT INTO dbo.PM_StockBatchItems
						(StockItemID , StockBatchID, StockCodeID, SupplierID, UseByDate, RecordStatus, Source, Updated, GUID, TotalQuantity )
                      --(StockBatchID, BatchType, LocationID, Barcode, BatchRef, QAStatus, DateAdded, DateClosed, ExpiryDate, Closed, RecordStatus, GUID)
		VALUES     (@StockItemID,@StockBatchID,@StockCodeID,@SupplierID,@UseByDate,@RecordStatus,@Source,@Updated,@GUID,@TotalQuantity)
		SET @InsertCount = @@rowcount
		set identity_insert dbo.PM_StockBatchItems off
	END
END

ELSE
BEGIN --Update record
	UPDATE    PM_StockBatchItems
	SET              StockBatchID=@StockBatchID, StockCodeID=@StockCodeID, SupplierID=@SupplierID, UseByDate=@UseByDate, RecordStatus=@RecordStatus, Source=@Source, Updated=@Updated, TotalQuantity=@TotalQuantity
	WHERE     (StockItemID = @StockItemID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'UP_Response_AddAttachmentsFromResponse')
	EXEC ('CREATE PROCEDURE [dbo].[UP_Response_AddAttachmentsFromResponse] AS SELECT ''stub version, to be replaced''')
GO
-- =======================================  
-- Author:		Jonathan Toolan
-- Create date: 10/07/2017  
-- Description: Copies attachments from one (child) check
-- Version:		2
-- =======================================  
-- JT TFS 13-32586: Copy attachments directly linked to a child check to a newly created parent check.
-- =======================================  
ALTER PROCEDURE UP_Response_AddAttachmentsFromResponse
	@UserID int,
	@ResponseID int,
	@SourceResponseID int
AS
BEGIN
	-- this is all the attachments that are currently linked to the response we want to copy from.
	IF NULLIF(object_id('tempdb..#tmpSource'), 0) IS NOT NULL DROP TABLE #tmpSource;
	SELECT AttachmentID, AttachmentFileName, GETCHECKSUM(Attachment) as AttachmentChecksum
	INTO #tmpSource
	FROM QMS_Attachment
	WHERE AttachmentSourceID = 1
	AND RecordStatus < 100 -- we do not want temp attachments to be copied.
	AND SourceObjectID = @SourceResponseID;

	-- this is all the attachments that are currently linked to this response (directly).
	IF NULLIF(object_id('tempdb..#tmpDestination'), 0) IS NOT NULL DROP TABLE #tmpDestination;
	SELECT AttachmentID, AttachmentFileName, GETCHECKSUM(Attachment) as AttachmentChecksum
	INTO #tmpDestination
	FROM QMS_Attachment
	WHERE AttachmentSourceID = 1
	AND RecordStatus < 100 -- we do not want temp attachments to be copied.
	AND SourceObjectID = @ResponseID;

	-- Insert the missing attachments.
	INSERT QMS_Attachment(AttachmentSourceID, SourceObjectID, AttachmentTitle, AttachmentFileName, Attachment, AttachmentURL, UserID, MachineName, RecordStatus)
	SELECT AttachmentSourceID, @ResponseID, AttachmentTitle, a.AttachmentFileName, Attachment, AttachmentURL, @UserID, MachineName, RecordStatus
	FROM #tmpSource s
	INNER JOIN QMS_Attachment a ON s.AttachmentID = a.AttachmentID
	WHERE NOT EXISTS (	SELECT * FROM #tmpDestination d 
						WHERE d.AttachmentFileName = s.AttachmentFileName
						AND d.AttachmentChecksum = s.AttachmentChecksum)

END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_DeliveryHaulier_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_DeliveryHaulier_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 16/02/2010
-- Description:	Get haulier for delivery
-- Version:	2
-- =============================================
-- JF TFS 74073 - pick up delivery haulier from Intake barcode
-- =============================================

ALTER PROCEDURE [dbo].[PM_QRY_DeliveryHaulier_Lookup] 
	@DeliveryID int = NULL,
	@Barcode nvarchar(50)=null
AS

IF @Barcode IS NULL
	SELECT     Haulier
	FROM         PM_VW_Delivery
	WHERE     (DeliveryID = @DeliveryID)
ELSE

	SELECT   DISTINCT  Haulier
	FROM         dbo.PM_VW_Delivery INNER JOIN dbo.PM_vw_GoodsIntake ON PM_vw_GoodsIntake.deliveryID = PM_VW_Delivery.DeliveryID 
	WHERE     (PM_vw_GoodsIntake.Barcode  = @Barcode and @Barcode IS NOT NULL)
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_GoodsIntake_EText1_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_GoodsIntake_EText1_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JMF
-- Create date: 14/06/2017
-- Description:	Goods Intake E_Text1 data
-- Version:	1
-- =============================================
-- JF TFS 74072 - generic lookup for E_text1 from barcode scan
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_GoodsIntake_EText1_Combo] 
	@Barcode nvarchar(50) = null
AS

SELECT   DISTINCT  PM_VW_GoodsIntake.E_Text1
FROM         PM_VW_GoodsIntake 
WHERE     (PM_VW_GoodsIntake.Barcode = @Barcode)

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_HarvestCrew_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_HarvestCrew_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:	Markp
-- Create date: 16/01/2010
-- Description:	Harvest crew combo list
-- Version:	5
-- =============================================
-- JT TFS 7819: Changed unknown ID from -1 to -2
-- JMF 995 - use hiden flag if in mobile
-- JF TFS 74073 - allow harvest crew to be looked up from goods intake barcode. Reformatted code
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_HarvestCrew_Combo]
@SupplierID int = NULL,
@UserID int = NULL,
@AssessmentTypeID INT = null,
@Barcode nvarchar(50) = null

AS
if @Barcode IS NOT NULL and (SELECT Enabled FROM APP_DataLookupTrigger WHERE DataLookupID_Trigger = 11 AND DataLookupID_Update = 29) = 1
	SELECT     
		PM_VW_UserGroup.UserGroupID, 
		GroupName + CASE WHEN LEN(ISNULL(GroupCode,'')) > 0 THEN ' (' + GroupCode + ')' ELSE '' END AS GroupText
	FROM         dbo.PM_VW_UserGroup INNER JOIN dbo.PM_VW_Goodsintake on PM_VW_Goodsintake.usergroupid = PM_VW_UserGroup.usergroupid
	WHERE PM_VW_Goodsintake.Barcode = @Barcode

else if @SupplierID IS NULL
	SELECT     UserGroupID, GroupName + CASE WHEN LEN(ISNULL(GroupCode,'')) > 0 THEN ' (' + GroupCode + ')' ELSE '' END AS GroupText
	FROM         PM_VW_UserGroup
	WHERE     (GroupTypeID = 1) AND (SupplierID IS NULL OR
	SupplierID IN
	(SELECT     SupplierID
	FROM          dbo.FNC_User_SupplierList(@UserID) AS User_SupplierList))
	and (PM_VW_UserGroup.Hide=0 OR @AssessmentTypeID IS NULL )
	UNION
	SELECT -2 AS UserGroupID, N'Unknown/Other' AS GroupText
	ORDER BY GroupText

ELSE
	SELECT     UserGroupID, GroupName + CASE WHEN LEN(ISNULL(GroupCode, '')) > 0 THEN ' (' + GroupCode + ')' ELSE '' END AS GroupText
	FROM         PM_VW_UserGroup
	WHERE     (GroupTypeID = 1) AND (SupplierID IS NULL OR
	SupplierID = @SupplierID)
	and (PM_VW_UserGroup.Hide=0 OR @AssessmentTypeID IS NULL )
	UNION
	SELECT -2 AS UserGroupID, N'Unknown/Other' AS GroupText
	ORDER BY GroupText

GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_StockCode_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_StockCode_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 16/07/2008
-- Description:	Gets a stock code list
-- Version:		8
-- =============================================
-- JE updated to filter list by Customer
-- JT TFS 3657 - updated to only return one query result.
-- MP TFS 3869 - updated to ensure customer filter only used when trigger enabled
-- JE TFS 4178 - added AssessmentTypeID param so we know when to filter out hidden Stock Codes
-- JT TFS 5902 - 13-Feb-2012 - Added searchText
-- JE TFS 13-11942: exclude stock type of Seed/Variety when accessed from Mobile
-- JF TFS 74073 - allow stockcode to be picked up from goods intake without PO data ie PalletStockCodeID. Also check APP_DataLookupTrigger table
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_StockCode_Combo]
	@CaseEndBarcode nvarchar(100) = NULL,
	@UserID int = NULL,
	@CustomerID int = NULL,
	@AssessmentTypeID int = NULL,
	@SearchText nvarchar(100) = NULL,
	@Barcode nvarchar(50) = null
AS



IF @CaseEndBarcode IS NOT NULL --combo being accessed from an assessment, so hide hidden stock codes
BEGIN
	DECLARE @FilterStockCodeID int
	IF @CaseEndBarcode IS NOT NULL
		SET @FilterStockCodeID = dbo.FNC_CaseEndToStockCode(@CaseEndBarcode)
	ELSE
		SET @FilterStockCodeID = NULL

	SELECT     StockCodeID, DisplayText
	FROM         PM_VW_StockCode
	WHERE   ((StockCodeID = @FilterStockCodeID) AND (@FilterStockCodeID IS NOT NULL) 	OR		(@FilterStockCodeID IS NULL) AND (Hide = 0))
	AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
	AND (PM_VW_StockCode.StockTypeID <> 4)
	ORDER BY DisplayText
END
ELSE
BEGIN
	DECLARE @EnableCustomerFilter bit
	IF @CustomerID IS NOT NULL
		SELECT     @EnableCustomerFilter = Enabled
		FROM         dbo.APP_DataLookupTrigger
		WHERE     (DataLookupID_Update = 2) AND (DataLookupID_Trigger = 3)
	ELSE
		SET @EnableCustomerFilter = 0
		
	IF @UserID IS NULL AND @EnableCustomerFilter = 1 --combo not being accessed from an assessment, so show all stock codes
		SELECT		StockCodeID, DisplayText
		FROM         dbo.PM_VW_StockCode
		WHERE		CustomerID = @CustomerID
		AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
		ORDER BY DisplayText
		
	ELSE IF @UserID IS NOT NULL AND @EnableCustomerFilter = 0 AND @AssessmentTypeID IS NOT NULL --combo being accessed from an assessment, so hide hidden stock codes
		--Where is stockcode stored
		IF @Barcode is NOT NULL and (SELECT Enabled FROM dbo.APP_DataLookupTrigger WHERE DataLookupID_Trigger = 11 AND DataLookupID_Update = 2) = 1
			BEGIN
				IF EXISTS(SELECT consignmentitemid FROM dbo.PM_VW_GoodsIntake WHERE Barcode = @Barcode and consignmentitemid IS NOT NULL)
					SELECT     DISTINCT dbo.PM_VW_StockCode.StockCodeID, DisplayText
					FROM         dbo.PM_VW_StockCode 
					INNER JOIN dbo.PM_VW_ConsignmentItems on dbo.PM_VW_ConsignmentItems.StockCodeID = dbo.PM_VW_StockCode.StockCodeID 
					INNER JOIN dbo.PM_vw_GoodsIntake ON dbo.PM_vw_GoodsIntake.ConsignmentItemID  = dbo.PM_VW_ConsignmentItems.ConsignmentItemID 
					WHERE   
					dbo.PM_vw_GoodsIntake.Barcode = @Barcode 
					ORDER BY DisplayText
				ELSE IF EXISTS(SELECT PalletStockCodeID FROM PM_VW_GoodsIntake WHERE Barcode = @Barcode and PalletStockCodeID IS NOT NULL)
					SELECT     DISTINCT StockCodeID, DisplayText
					FROM         dbo.PM_VW_StockCode INNER JOIN dbo.PM_vw_GoodsIntake ON dbo.PM_vw_GoodsIntake.PalletStockCodeID = dbo.PM_VW_StockCode.StockCodeID 
					WHERE   
					dbo.PM_vw_GoodsIntake.Barcode = @Barcode 
					ORDER BY DisplayText
				ELSE IF EXISTS(SELECT StockBatchID  FROM PM_VW_StockBatch WHERE Barcode = @Barcode)
					SELECT PM_VW_StockCode.StockCodeID, PM_VW_StockCode.DisplayText FROM dbo.PM_VW_StockBatch 
					INNER JOIN dbo.PM_VW_StockBatchItems ON PM_VW_StockBatchItems.StockBatchID  = PM_VW_StockBatch.StockBatchID
					INNER JOIN dbo.PM_VW_StockCode  ON PM_VW_StockCode.StockCodeID  = PM_VW_StockBatchItems.StockCodeID 
					INNER JOIN	dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
					WHERE dbo.PM_VW_StockBatch.Barcode = @Barcode
			END
		ELSE

			SELECT		PM_VW_StockCode.StockCodeID, PM_VW_StockCode.DisplayText
			FROM         dbo.PM_VW_StockCode INNER JOIN
							dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
			WHERE (Hide = 0)
			AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
			AND (PM_VW_StockCode.StockTypeID <> 4)
			ORDER BY PM_VW_StockCode.DisplayText

	ELSE IF @UserID IS NOT NULL AND @EnableCustomerFilter = 0 AND @AssessmentTypeID IS NULL --combo not being accessed from an assessment, so show all stock codes
		SELECT		PM_VW_StockCode.StockCodeID, PM_VW_StockCode.DisplayText
		FROM         dbo.PM_VW_StockCode INNER JOIN
						dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
		AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
		ORDER BY PM_VW_StockCode.DisplayText
		
	ELSE IF @UserID IS NOT NULL AND @EnableCustomerFilter = 1 AND @AssessmentTypeID IS NOT NULL --combo being accessed from an assessment, so hide hidden stock codes
		SELECT		PM_VW_StockCode.StockCodeID, PM_VW_StockCode.DisplayText
		FROM         dbo.PM_VW_StockCode INNER JOIN
						dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
		WHERE		(CustomerID = @CustomerID) AND (Hide = 0)
		AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
		AND (PM_VW_StockCode.StockTypeID <> 4)
		ORDER BY PM_VW_StockCode.DisplayText
	
	ELSE IF @UserID IS NOT NULL AND @EnableCustomerFilter = 1 AND @AssessmentTypeID IS NULL --combo not being accessed from an assessment, so show all stock codes
		SELECT		PM_VW_StockCode.StockCodeID, PM_VW_StockCode.DisplayText
		FROM         dbo.PM_VW_StockCode INNER JOIN
						dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
		WHERE		(CustomerID = @CustomerID)
		AND (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
		ORDER BY PM_VW_StockCode.DisplayText	
		
	ELSE
		SELECT     StockCodeID, DisplayText
		FROM         dbo.PM_VW_StockCode
		WHERE (@SearchText IS NULL OR [Description] LIKE @SearchText OR StockCode LIKE @SearchText)
		ORDER BY DisplayText
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_Supplier_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_Supplier_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: Markp
-- Create date	: 16/07/2008
-- Description	: Gets list of suppliers
-- Version		: 5
-- =============================================
-- JE TFS 3176: added AssessmentType param to check if we should hide hidden suppliers or not
-- JE TFS 13-2214: added check that DateArrived trigger is enabled before applying filter
-- PH TFS 13-41690: added IsInactive for showing hidden suppliers in red.
-- JF TFS 74073 - allow supplier to be picked up from goods intake supplier or PO data 
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_Supplier_Combo] 
	@DateArrived datetime = NULL,
	@CaseEndBarcode nvarchar(100) = NULL,
	@UserID int = NULL,
	@AssessmentTypeID int = NULL,
	@Barcode nvarchar(50) = null
AS

IF @CaseEndBarcode IS NOT NULL --combo being accessed from an assessment, so hide hidden suppliers
	SELECT     SupplierID, SupplierName, Hide AS IsInactive
	FROM         dbo.PM_VW_Supplier
	WHERE     (SupplierID = dbo.FNC_CaseEndToSupplier(@CaseEndBarcode)) AND (Hide = 0)
	ORDER BY SupplierName

ELSE
BEGIN
	IF @DateArrived IS NULL OR (SELECT Enabled FROM APP_DataLookupTrigger WHERE DataLookupID_Trigger = 16 AND DataLookupID_Update = 1) = 0
	--DateArrived trigger disabled
	BEGIN
		IF @UserID IS NULL --combo not being accessed from an assessment, so show all suppliers
			SELECT     SupplierID, SupplierName, Hide AS IsInactive
			FROM         dbo.PM_VW_Supplier
			ORDER BY SupplierName
		ELSE IF @AssessmentTypeID IS NOT NULL --combo being accessed from an assessment, so hide hidden suppliers
			IF @Barcode IS NULL OR (SELECT Enabled FROM dbo.APP_DataLookupTrigger WHERE DataLookupID_Trigger = 11 AND DataLookupID_Update = 1) = 0
				SELECT     PM_VW_Supplier.SupplierID, PM_VW_Supplier.SupplierName, PM_VW_Supplier.Hide AS IsInactive
				FROM         dbo.PM_VW_Supplier INNER JOIN
									  dbo.FNC_User_SupplierList(@UserID) AS User_SupplierList ON PM_VW_Supplier.SupplierID = User_SupplierList.SupplierID
				WHERE (Hide = 0)
				ORDER BY PM_VW_Supplier.SupplierName
			else
				--Either get the supplier from the PM_Consignment.SupplierID or GoodsIntake.SupplierID
				IF EXISTS(SELECT SupplierID FROM dbo.PM_vw_Goodsintake WHERE Barcode = @Barcode and SupplierID IS NOT NULL)
					SELECT     PM_VW_Supplier.SupplierID, PM_VW_Supplier.SupplierName, PM_VW_Supplier.Hide AS IsInactive
					FROM         dbo.PM_VW_Supplier INNER JOIN
						dbo.PM_vw_goodsintake ON dbo.PM_vw_goodsintake.supplierid = PM_VW_Supplier.SupplierID
						inner join dbo.FNC_User_SupplierList(@UserID) AS User_SupplierList ON PM_VW_Supplier.SupplierID = User_SupplierList.SupplierID
					WHERE (Hide = 0) and PM_vw_goodsintake.barcode = @barcode
					ORDER BY PM_VW_Supplier.SupplierName
				ELSE
					SELECT     PM_VW_Supplier.SupplierID, PM_VW_Supplier.SupplierName, PM_VW_Supplier.Hide AS IsInactive
					FROM         dbo.PM_VW_Supplier INNER JOIN
										  dbo.FNC_User_SupplierList(@UserID) AS User_SupplierList ON PM_VW_Supplier.SupplierID = User_SupplierList.SupplierID
										  inner join dbo.PM_vw_Consignment  on pm_vw_consignment.supplierid = PM_VW_Supplier.supplierid
										  inner join dbo.PM_vw_ConsignmentItems  on pm_vw_consignmentitems.consignmentid = pm_vw_consignment.ConsignmentID 
										  inner join dbo.PM_vw_GoodsIntake on PM_vw_GoodsIntake.ConsignmentItemID = pm_vw_consignmentitems.ConsignmentItemID 
					WHERE (PM_VW_Supplier.Hide = 0) and PM_vw_goodsintake.barcode = @barcode
					ORDER BY PM_VW_Supplier.SupplierName


		ELSE
			SELECT     PM_VW_Supplier.SupplierID, PM_VW_Supplier.SupplierName, PM_VW_Supplier.Hide AS IsInactive
			FROM         dbo.PM_VW_Supplier INNER JOIN
								  dbo.FNC_User_SupplierList(@UserID) AS User_SupplierList ON PM_VW_Supplier.SupplierID = User_SupplierList.SupplierID
			ORDER BY PM_VW_Supplier.SupplierName
	END
	ELSE --@DateArrived NOT NULL, so must be accessing combo from an assessment (DateArrived trigger also enabled)
		SELECT DISTINCT PM_VW_Supplier.SupplierID, PM_VW_Supplier.SupplierName, PM_VW_Supplier.Hide AS IsInactive
		FROM         dbo.PM_VW_Supplier INNER JOIN
							  PM_VW_GoodsIntake ON PM_VW_Supplier.SupplierID = PM_VW_GoodsIntake.SupplierID
		WHERE     (dbo.FNC_TrimDate(PM_VW_GoodsIntake.DateArrived) = dbo.FNC_TrimDate(@DateArrived)) AND (Hide = 0)
		ORDER BY PM_VW_Supplier.SupplierName
END

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_SupplierRef_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_SupplierRef_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 17/11/2008
-- Description:	Gets lookup of Supplier Ref used (AWB for Flamingo)
-- version:	2
-- =============================================
-- JF TFS 74073 - allow supplier ref to be picked up from goods intake barcode
-- =============================================

ALTER PROCEDURE [dbo].[PM_QRY_SupplierRef_Combo] 
	@SupplierID int = 0,
	@DateArrived datetime = NULL,
	@Barcode nvarchar(50) = null
AS

if @Barcode IS NOT NULL and (SELECT Enabled FROM dbo.APP_DataLookupTrigger WHERE DataLookupID_Trigger = 11 AND DataLookupID_Update = 15) = 1
	SELECT    SupplierRef 
	FROM         dbo.PM_VW_Goodsintake 
	WHERE PM_VW_Goodsintake.Barcode = @Barcode

else IF @DateArrived IS NULL
	SELECT DISTINCT SupplierRef
	FROM         dbo.PM_VW_GoodsIntake
	WHERE     (SupplierRef IS NOT NULL) AND (@SupplierID <= 0) OR
						  (SupplierRef IS NOT NULL) AND (@SupplierID > 0) AND (SupplierID = @SupplierID)
	ORDER BY SupplierRef

ELSE
	SELECT DISTINCT SupplierRef
	FROM         dbo.PM_VW_GoodsIntake
	WHERE     (SupplierRef IS NOT NULL) AND (@SupplierID <= 0) AND (dbo.FNC_TrimDate(DateArrived) = dbo.FNC_TrimDate(@DateArrived)) OR
						  (SupplierRef IS NOT NULL) AND (@SupplierID > 0) AND (SupplierID = @SupplierID) AND (dbo.FNC_TrimDate(DateArrived) 
						  = dbo.FNC_TrimDate(@DateArrived))
	ORDER BY SupplierRef
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QAS_RPT_Specification_HeaderSub')
	EXEC ('CREATE PROCEDURE [dbo].[QAS_RPT_Specification_HeaderSub] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jon Edwards
-- Create date: 05/02/2013
-- Description:	Returns header data for QAS report
-- Version:		3
-- =============================================
-- JT TFS 13-53793: 15/08/2016 - Link to master assessment specheader on Sys_AssSpecHeaderID
-- UK TFS 75641: 10/07/2017 - Headers not filled in via integration are now hidden
-- =============================================
ALTER PROCEDURE dbo.QAS_RPT_Specification_HeaderSub 
	@AssessmentID INT
AS
--get master AssessmentID for @AssessmentID if @AssessmentID is a temp spec
DECLARE @MasterAssessmentID AS int

SELECT	@MasterAssessmentID = MAX(QMS_Assessment_Master.AssessmentID)
FROM	QMS_Assessment AS QMS_Assessment_Master INNER JOIN
			QMS_Assessment AS QMS_Assessment_Temp ON QMS_Assessment_Master.Sys_AssessmentID = QMS_Assessment_Temp.Sys_AssessmentID
WHERE	(QMS_Assessment_Master.TempSpec = 0) AND (QMS_Assessment_Master.AssessmentStatusID = 3) AND
			(QMS_Assessment_Temp.AssessmentID = @AssessmentID) AND (QMS_Assessment_Temp.TempSpec = 1)

--get attachments for assessment
DECLARE @Attachment_Table TABLE (AssessmentSpecHeaderID int, AttachmentTitle nvarchar(255), Attachment image)

INSERT INTO @Attachment_Table (AssessmentSpecHeaderID, AttachmentTitle, Attachment)
SELECT	SourceObjectID AS AssessmentSpecHeaderID, AttachmentTitle, Attachment
FROM	QMS_Attachment
WHERE	(AttachmentSourceID = 4) AND (QMS_Attachment.RecordStatus < 201) AND (SourceObjectID IN
                          (SELECT     AssessmentSpecHeaderID --get attachments for master assessment too (only applies if running report for temp spec)
                            FROM          QMS_AssessmentSpecHeader
                            WHERE      (AssessmentID = @AssessmentID)))

IF @MasterAssessmentID IS NOT NULL --temp spec, so add temp spec attachments too
BEGIN
	INSERT INTO @Attachment_Table (AssessmentSpecHeaderID, AttachmentTitle, Attachment)
	SELECT	Temp.AssessmentSpecHeaderID, AttachmentTitle, Attachment
	FROM	QMS_Attachment INNER JOIN
				QMS_AssessmentSpecHeader ON QMS_Attachment.SourceObjectID = QMS_AssessmentSpecHeader.AssessmentSpecHeaderID INNER JOIN
				QMS_AssessmentSpecHeader AS Temp ON QMS_AssessmentSpecHeader.Sys_AssSpecHeaderID = Temp.Sys_AssSpecHeaderID
	WHERE	(AttachmentSourceID = 4) AND (QMS_Attachment.RecordStatus < 201) AND
				(QMS_AssessmentSpecHeader.AssessmentID = @MasterAssessmentID) AND (Temp.AssessmentID = @AssessmentID) AND
					(Temp.AssessmentSpecHeaderID NOT IN (SELECT AssessmentSpecHeaderID
														 FROM	@Attachment_Table))
END														 

--create table variable to store Multi-Text (note: don't use temp table as this introduces problems with collation)
DECLARE @MultiHeader TABLE (AssessmentSpecHeaderID int, Multi_Text nvarchar(1000))

INSERT INTO @MultiHeader (AssessmentSpecHeaderID, Multi_Text)
SELECT	SpecHeader.AssessmentSpecHeaderID,
		--if over 1000 chars, limit length so SP doesn't fail
		CASE WHEN LEN(Multi_Text_String) > 1000 THEN LEFT(Multi_Text_String, 997) + '...' ELSE Multi_Text_String END AS Multi_Text
FROM	(
	SELECT	SpecHeader.AssessmentSpecHeaderID,
			dbo.FNC_UnescapeXMLPath (substring(
			(	SELECT ', ' + QMS_AssessmentSpecHeaderMulti.Multi_Text
						FROM	QMS_AssessmentSpecHeaderMulti WHERE SpecHeader.AssessmentSpecHeaderID = QMS_AssessmentSpecHeaderMulti.AssessmentSpecHeaderID
						AND		(Multi_SourceID > -1)
						AND		NULLIF(Multi_Text, '') IS NOT NULL
						AND		RecordStatus < 201
						FOR XML PATH('')), 3, 99999)) [Multi_Text_String]
	 FROM QMS_AssessmentSpecHeader SpecHeader 
	 WHERE	(SpecHeader.AssessmentID = @AssessmentID) 
) AS [SpecHeader]
WHERE Multi_Text_String IS NOT NULL


IF NULLIF(object_id('tempdb..#TempQMS_AssessmentHeader'), 0) IS NOT NULL DROP TABLE #TempQMS_AssessmentHeader;
--main query to return dataset for report
SELECT QMS_AssessmentSpecHeader.AssessmentID,
	   QMS_SpecificationHeader.HeaderTitle,
	   QMS_AssessmentSpecHeader.Spec_SourceID,
	   CASE WHEN QMS_AssessmentSpecHeader.Spec_SourceID = -1 THEN MultiHeader.Multi_Text ELSE QMS_AssessmentSpecHeader.Spec_Text END AS Spec_Text,
	   QMS_SpecificationHeader.DataTypeID,
	   Attachment.AttachmentTitle, 
	   Attachment.Attachment,
	   QMS_SpecificationHeader.ListIndex
INTO #TempQMS_AssessmentHeader
FROM QMS_AssessmentSpecHeader
	INNER JOIN QMS_SpecificationHeader ON QMS_AssessmentSpecHeader.SpecificationHeaderID = QMS_SpecificationHeader.SpecificationHeaderID
	LEFT OUTER JOIN @Attachment_Table AS Attachment ON QMS_AssessmentSpecHeader.AssessmentSpecHeaderID = Attachment.AssessmentSpecHeaderID 
	LEFT OUTER JOIN @MultiHeader AS MultiHeader ON QMS_AssessmentSpecHeader.AssessmentSpecHeaderID = MultiHeader.AssessmentSpecHeaderID
WHERE (QMS_AssessmentSpecHeader.AssessmentID = @AssessmentID)
	AND (QMS_AssessmentSpecHeader.RecordStatus < 201)
	AND (QMS_AssessmentSpecHeader.NotApplicable = 0) 
	AND (QMS_SpecificationHeader.HideFromReports = 0)
	AND (QMS_SpecificationHeader.RecordStatus < 201)
	AND (QMS_SpecificationHeader.DataTypeID < 11) 
	OR --filters for attachment data 
		(QMS_AssessmentSpecHeader.AssessmentID = @AssessmentID)
	AND (QMS_AssessmentSpecHeader.RecordStatus < 201)
	AND (QMS_SpecificationHeader.HideFromReports = 0)
	AND (QMS_SpecificationHeader.RecordStatus < 201)
	AND (QMS_SpecificationHeader.DataTypeID = 11)
	AND (Attachment.Attachment IS NOT NULL)				  

--Temp table used to filter result set so that only non-empty spec_text is shown
SELECT #TempQMS_AssessmentHeader.AssessmentID,
	#TempQMS_AssessmentHeader.HeaderTitle,
	#TempQMS_AssessmentHeader.Spec_SourceID,
	#TempQMS_AssessmentHeader.Spec_Text,
	#TempQMS_AssessmentHeader.DataTypeID,
	#TempQMS_AssessmentHeader.AttachmentTitle,
	#TempQMS_AssessmentHeader.Attachment
FROM #TempQMS_AssessmentHeader
WHERE (#TempQMS_AssessmentHeader.Spec_Text IS NOT NULL 
	  OR #TempQMS_AssessmentHeader.Spec_Text <> '')
ORDER BY #TempQMS_AssessmentHeader.ListIndex
GO




PRINT 'Database updated successfully!'
GO

