-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_ResponseHeader_GetHeaderText')
	EXEC('CREATE FUNCTION [dbo].[FNC_ResponseHeader_GetHeaderText]() RETURNS bit AS BEGIN RETURN 0 END')
GO
  -- =============================================  
-- Author:  Martin Pendlebury  
-- Create date: 28/04/2017  
-- Description: Returns Header_Text for a specific header based on ResponseID and AssessmentHeaderText   
-- Version:  1  
-- =============================================  
-- MartinP TFS 13-71941: Created  
-- =============================================  
ALTER FUNCTION FNC_ResponseHeader_GetHeaderText(@ResponseID int, @HeaderText NVARCHAR(255))  
RETURNS NVARCHAR(255)  
AS  
BEGIN  
RETURN (
	SELECT Header_Text FROM QMS_ResponseHeader
	INNER JOIN QMS_AssessmentHeader ON QMS_AssessmentHeader.AssessmentHeaderID = QMS_ResponseHeader.AssessmentHeaderID
	WHERE ResponseID = @ResponseID 
	AND QMS_AssessmentHeader.HeaderText  = @HeaderText
)  
END  
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_CorrectiveAction')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_CorrectiveAction] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 01/08/2008
-- Description:	Saves corrective action
-- Version:		16
-- =============================================
-- j.toolan 21 Feb 2012: Added ReminderDate
-- j.toolan  7 Mar 2012: Reset NotifcationSent on 6 if AssignSupplierID set (only if status changes)
-- MP TFS 5873 - Made sure SourceObjectID updated so that correct links to response created
-- JE TFS 7087 - added CorrectiveActionTypeID to UPDATE statement
-- JE TFS 7877 - corrected resetting of NotifcationSent for Completed alerts
-- JE TFS 7836 - updated to save LocationID CA is assigned
-- JT TFS 13-7950 - Make sure that if CorrectiveActionTypeID is specified, and CorrectiveActionEscalationID is NOT, then set it.
-- JE TFS 13-12635: call new SAVE_CorrectiveActionUser SP to save permissions data to QMS_CorrectiveActionUser table
-- MP TFS 13-15377: excluded call to new SAVE_CorrectiveActionUser SP for mobile
-- AC TFS 6335: Changes the escalation if the corrective action type or notification user group is changed
-- PH TFS 13-19579: 06/05/2015 - Made compatible with WebChecks service/EF.  @CorrectiveActionID must have default (null or zero) because stripped out by EF when adding record and @CorrectiveActionID must be returned AS CorrectiveActionID.
-- PH TFS 13-21031: 10/06/2015 - Got rid of code smell that may have been causing bug.  New CorrectiveActionID obtained OUTPUT INSERTED.CorrectiveActionID INTO @caIdTable
-- PH TFS 13-23902: 15/07/2015 - SourceObjectID is nullable, so parameter should not be mandatory when saving an Ad Hoc corrective action
-- JT TFS 13-59936: 25/04/2017 - Allow 100 characters for CATitle (to reflect underlying table)
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_CorrectiveAction]
	@CorrectiveActionID int = NULL,
	@CASourceID int,
	@SourceObjectID int = NULL,
	@CATitle nvarchar(100),
	@CASubTitle nvarchar(50),
	@CAReason nvarchar(1000),
	@CARequired nvarchar(1000),
	@CAStatusID int,
	@CorrectiveActionTypeID int,
	@CorrectiveActionEscalationID int,
	@NotificationGroupID int,
	@AssignUserID int,
	@DateOccurred datetime,
	@PriorityLevelID int,
	@DateLogged datetime,
	@DateDeadline datetime,
	@ActionTaken nvarchar(1000),
	@Comments nvarchar(1000),
	@DateCompleted datetime,
	@Completed_UserID int,
	@Completed_MachineName nvarchar(50),
	@DateSignedOff datetime,
	@SignOff_UserID int,
	@SignOff_MachineName nvarchar(50),
	@UserID int,
	@AssignSupplierID int,
	@ReminderDate datetime,
	@ReminderSent bit = NULL, -- This is not saved currently.
	@LocationID int
AS
BEGIN
	SET NOCOUNT ON

	-- BUG 7950 SP FIX
	SELECT @LocationID = NULLIF(@LocationID, 0) -- Do not allow zero for LocationID. It stops first new CA alert going out.

	DECLARE @DefaultCorrectiveActionEscalationID int
	SELECT @DefaultCorrectiveActionEscalationID = CorrectiveActionEscalationID 
	FROM QMS_CorrectiveActionEscalation 
	WHERE CorrectiveActionTypeID = @CorrectiveActionTypeID
	AND ListIndex = (	SELECT min(ListIndex) FROM QMS_CorrectiveActionEscalation 
						WHERE CorrectiveActionTypeID = @CorrectiveActionTypeID)
	-- END BUG 7950 fix

	IF ISNULL(@CorrectiveActionID,0)=0 --New record
	BEGIN
		DECLARE @caIdTable TABLE (CorrectiveActionID int)

		INSERT INTO QMS_CorrectiveAction
						  (CASourceID, SourceObjectID, CATitle, CASubTitle, CAReason, CARequired, CAStatusID, CorrectiveActionTypeID, CorrectiveActionEscalationID, NotificationGroupID, 
						  AssignUserID, DateOccurred, PriorityLevelID, DateLogged, DateDeadline, Logged_UserID, Logged_MachineName, ActionTaken, Comments, DateCompleted, 
						  Completed_UserID, Completed_MachineName, AssignSupplierID, ReminderDate, LocationID)
				OUTPUT INSERTED.CorrectiveActionID INTO @caIdTable
		VALUES     (@CASourceID,@SourceObjectID,@CATitle,@CASubTitle,@CAReason,@CARequired,@CAStatusID,@CorrectiveActionTypeID,
					ISNULL(@CorrectiveActionEscalationID, @DefaultCorrectiveActionEscalationID),
					@NotificationGroupID,@AssignUserID,@DateOccurred,@PriorityLevelID,@DateLogged,@DateDeadline,@UserID,
						   HOST_NAME(),@ActionTaken,@Comments,@DateCompleted,@Completed_UserID,@Completed_MachineName,@AssignSupplierID, @ReminderDate, @LocationID)
	                      
		--Get new ID
		SELECT     @CorrectiveActionID = MAX(CorrectiveActionID)
		FROM         @caIdTable
	END
	ELSE --Update record
	BEGIN
		DECLARE @originalCAStatusID int
		SELECT	@originalCAStatusID = CAStatusID 
		FROM	QMS_CorrectiveAction
		WHERE	CorrectiveActionID = @CorrectiveActionID
		
		DECLARE @originalCorrectiveActionTypeID int
		DECLARE @originalNotificationGroupID int
		
		SELECT	@originalCorrectiveActionTypeID = CorrectiveActionTypeID, @originalNotificationGroupID = NotificationGroupID
		FROM	QMS_CorrectiveAction
		WHERE	CorrectiveActionID = @CorrectiveActionID
		
		-- Only update the escalation if the corrective action type or the notification user group has changed
		IF (@originalCorrectiveActionTypeID <> @CorrectiveActionTypeID OR @originalNotificationGroupID <> @NotificationGroupID)
		BEGIN
			SET @CorrectiveActionEscalationID = NULL
			SELECT @CorrectiveActionEscalationID = CorrectiveActionEscalationID
			FROM QMS_CorrectiveActionEscalation
			WHERE CorrectiveActionTypeId = @CorrectiveActionTypeId
			AND NotificationGroupId = @NotificationGroupId
		END

		UPDATE    QMS_CorrectiveAction
		SET              SourceObjectID = @SourceObjectID, CATitle = @CATitle, CASubTitle = @CASubTitle, CAReason = @CAReason, CARequired = @CARequired, 
							  CAStatusID = @CAStatusID, CorrectiveActionTypeID = @CorrectiveActionTypeID, NotificationGroupID = @NotificationGroupID, AssignUserID = @AssignUserID, DateOccurred = @DateOccurred, 
							  PriorityLevelID = @PriorityLevelID, DateDeadline = @DateDeadline, ActionTaken = @ActionTaken, Comments = @Comments, DateCompleted = @DateCompleted, 
							  Completed_UserID = @Completed_UserID, Completed_MachineName = @Completed_MachineName, DateSignedOff = @DateSignedOff, 
							  SignOff_UserID = @SignOff_UserID, SignOff_MachineName = @SignOff_MachineName, 
							  RecordStatus = CASE WHEN RecordStatus = 30 THEN 20 ELSE RecordStatus END, Updated = GETUTCDATE(), AssignSupplierID = @AssignSupplierID, 
							  ReminderDate = @ReminderDate, LocationID = @LocationID, CorrectiveActionEscalationID = @CorrectiveActionEscalationID
		WHERE     (CorrectiveActionID = @CorrectiveActionID)

		-- Only update notification flag if the status has changed.
		IF (@originalCAStatusID <> @CAStatusID)
		BEGIN
				--get Failure_NotificationGroupID for current CA escalation
			DECLARE @Failure_NotificationGroupID int 
			SELECT     @Failure_NotificationGroupID = Failure_NotificationGroupID
			FROM         QMS_CorrectiveActionEscalation
			WHERE     (CorrectiveActionEscalationID = @CorrectiveActionEscalationID)

			--if CA being set to Complete and a Failure_NotificationGroup has been set, reset NotificationGroup flag
			IF @CAStatusID = 4 --AND @Failure_NotificationGroupID IS NOT NULL --removed for TFS 7877 as this stops Completed alerts firing when no Failure_NotificationGroupID set
			BEGIN
				UPDATE	QMS_CorrectiveAction
				SET		NotificationSent = 0
				WHERE	(CorrectiveActionID = @CorrectiveActionID)
			END
			
				--if CA being set to Signed-off and AssignSupplierID has been set, reset NotificationGroup flag
			IF @CAStatusID IN (5, 6) AND @AssignSupplierID IS NOT NULL
			BEGIN
				UPDATE	QMS_CorrectiveAction
				SET		NotificationSent = 0
				WHERE	(CorrectiveActionID = @CorrectiveActionID)
			END
		END
	END
	SET NOCOUNT OFF

	--save data for CA to QMS_CorrectiveActionUser (should handle both new and updated CAs as @CorrectiveActionID is set either way)
    IF DB_NAME() LIKE 'GreenlightQC_Mobile%'
        BEGIN --Add current user to current corrective action
            IF NOT EXISTS ( SELECT  CorrectiveActionID
                            FROM    dbo.QMS_CorrectiveActionUser
                            WHERE   UserID = @UserID
                                    AND CorrectiveActionID = @CorrectiveActionID )
                INSERT  INTO dbo.QMS_CorrectiveActionUser
                        ( CorrectiveActionID, UserID )
                VALUES  ( @CorrectiveActionID, -- CorrectiveActionID - int
                          @UserID -- UserID - int
                          )
        END
    ELSE
        EXEC SAVE_CorrectiveActionUser @CorrectiveActionID
	

	SELECT @CorrectiveActionID AS CorrectiveActionID
END
GO



IF NOT EXISTS (SELECT * FROM sys.columns WHERE Name = N'LookupText1' AND Object_ID = Object_ID (N'PM_GoodsIntake'))
BEGIN
	ALTER Table PM_GoodsIntake Add LookupText1 nvarchar(100)
	ALTER Table PM_GoodsIntake Add LookupText2 nvarchar(100)
	ALTER Table PM_GoodsIntake Add LookupText3 nvarchar(100)
	ALTER Table PM_GoodsIntake Add LookupText4 nvarchar(100)
	ALTER Table PM_GoodsIntake Add LookupText5 nvarchar(100)
	ALTER Table PM_GoodsIntake Add LookupText6 nvarchar(100)
	ALTER Table PM_GoodsIntake Add LookupText7 nvarchar(100)
	ALTER Table PM_GoodsIntake Add LookupText8 nvarchar(100)
	ALTER Table PM_GoodsIntake Add LookupText9 nvarchar(100)
	ALTER Table PM_GoodsIntake Add LookupText10 nvarchar(100)
END
GO

/****** Object:  View [dbo].[PM_VW_GoodsIntake]    Script Date: 03/05/2017 14:18:40 ******/
SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

--=============================================
-- Author:		Unknown
-- Create date: 29/06/2010
-- Description:	Gets header informaton for PM_GoodsIntake
-- Version:		11
-- =============================================
-- JT TFS 4286: 9-Aug-2012: Added PalletID
-- JF: Added ArrivalTemp and Certified
-- MP TFS 2798: Added Updated column
-- jf TFS 19129 - added PalletStockCodeID
-- jf TFS 29162 - added storeID
-- jf tfs 32575 - add @CountryID and @Alias
-- JF TFS 53109 - Added CustomerID
-- JF TFS 71972 - Added 10 lookup columns
--=============================================
ALTER VIEW [dbo].[PM_VW_GoodsIntake]
AS
SELECT        GoodsIntakeID, SupplierID, ConsignmentItemID, LocationID, UserGroupID, ItemCount, UnitQuantity, PalletNo, HarvestDate, DeliveryID, DateArrived, SupplierRef, SupplierLotNo, Barcode, Comments, E_Text1, 
                         E_Text2, UnitStockCodeID, OriginalBarcode, E_Numeric1, E_DateTime1, PalletID, ArrivalTemp, Certified, Updated, NetWeight, PalletStockCodeID, RowVersion, Created, RecordStatus, E_Numeric3, E_Numeric2, 
                         GUID, StoreID, CountryID, Alias, CustomerID, LookupText1, LookupText2, LookupText3, LookupText4, LookupText5, LookupText6, LookupText7, LookupText8, LookupText9, LookupText10
FROM            PM_GoodsIntake
WHERE  (RecordStatus < 201)

GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_GoodsIntake')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_GoodsIntake] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		unknown
-- Create date: 18/12/2008
-- Description:	imports data into the mobile PM_GoodsIntake table
-- Version:		7
-- =============================================
-- jf tfs 18253 - added @PalletStockCodeID
-- jf tfs 29101 - added storeid
-- jf TFS 23605 - make sure no date conversions happen
-- jf tfs 32575 - add @CountryID and @Alias
-- JF TFS 53109 - Added CustomerID
-- JF TFS 71972 - Added 10 lookup columns
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_PM_GoodsIntake] 
	@GoodsIntakeID int,
	@SupplierID int,
	@ConsignmentItemID int,
	@LocationID int,
	@ItemCount real,
	@UnitQuantity int,
	@PalletNo int,
	@NetWeight real = NULL,
	@DeliveryID int,
	@DateArrived datetime,
	@SupplierRef nvarchar(50),
	@Barcode nvarchar(50),
	@OriginalBarcode nvarchar(50) = NULL,
	@UserGroupID int,
	@HarvestDate datetime,
	@SupplierLotNo nvarchar(50),
	@Comments nvarchar(255),
	@UnitStockCodeID int = NULL,
	@E_Text1 nvarchar(50) = NULL,
	@E_Text2 nvarchar(50) = NULL,
	@E_Numeric1 int = NULL,
	@E_Numeric2 int = NULL,
	@E_DateTime1 datetime = NULL,
	@PalletID INT = NULL,
	@Certified BIT = NULL,
	@ArrivalTemp REAL = NULL,
	@E_Numeric3 REAL = NULL,
	@Updated DATETIME = NULL,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@PalletStockCodeID int,
	@StoreID int = null,
	@CountryID int = NULL,
	@Alias nvarchar(50) = NULL,
	@CustomerID int = null,
	@LookupText1 nvarchar(100) = NULL, 
	@LookupText2 nvarchar(100) = NULL, 
	@LookupText3 nvarchar(100) = NULL, 
	@LookupText4 nvarchar(100) = NULL, 
	@LookupText5 nvarchar(100) = NULL, 
	@LookupText6 nvarchar(100) = NULL, 
	@LookupText7 nvarchar(100) = NULL, 
	@LookupText8 nvarchar(100) = NULL, 
	@LookupText9 nvarchar(100) = NULL, 
	@LookupText10 nvarchar(100) = NULL,

	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

SET @DateArrived = dbo.FNC_ConvertServerDate(@DateArrived)
SET @HarvestDate = dbo.FNC_ConvertServerDate(@HarvestDate)
SET @E_DateTime1 = dbo.FNC_ConvertServerDate(@E_DateTime1)

IF @Certified IS NULL
	SET @Certified = 0
	
IF NOT EXISTS(SELECT * FROM dbo.PM_GoodsIntake WHERE (GoodsIntakeID = @GoodsIntakeID))
BEGIN --Append record
	IF @RecordStatus < 201 AND EXISTS(SELECT ConsignmentID FROM dbo.PM_ConsignmentItems WHERE (ConsignmentItemID = @ConsignmentItemID))
	BEGIN
		INSERT INTO dbo.PM_GoodsIntake
                      (GoodsIntakeID, SupplierID, ConsignmentItemID, LocationID, ItemCount, UnitQuantity, PalletNo, NetWeight, DeliveryID, DateArrived, SupplierRef, SupplierLotNo, Comments, 
                      UserGroupID, HarvestDate, Barcode, UnitStockCodeID, OriginalBarcode, E_Text1, E_Text2, E_Numeric1, E_Numeric2, E_DateTime1, PalletID, Certified, ArrivalTemp, 
                      E_Numeric3, Updated, RecordStatus, GUID,PalletStockCodeID,StoreID, CountryID, Alias, CustomerID,LookupText1, LookupText2, LookupText3, LookupText4, LookupText5, LookupText6, LookupText7, LookupText8, LookupText9, LookupText10)
		VALUES     (@GoodsIntakeID,@SupplierID,@ConsignmentItemID,@LocationID,@ItemCount,@UnitQuantity,@PalletNo,@Netweight,@DeliveryID,@DateArrived,@SupplierRef,@SupplierLotNo,@Comments,@UserGroupID,@HarvestDate,@Barcode,@UnitStockCodeID,@OriginalBarcode,@E_Text1,@E_Text2,@E_Numeric1,@E_Numeric2,@E_DateTime1,@PalletID,@Certified,@ArrivalTemp,@E_Numeric3,@Updated,@RecordStatus,@GUID,@PalletStockCodeID,@StoreID, @CountryID, @Alias, @CustomerID,@LookupText1, @LookupText2, @LookupText3, @LookupText4, @LookupText5, @LookupText6, @LookupText7, @LookupText8, @LookupText9, @LookupText10)
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    dbo.PM_GoodsIntake
	SET              SupplierID = @SupplierID, ConsignmentItemID = @ConsignmentItemID, LocationID = @LocationID, DeliveryID = @DeliveryID, ItemCount = @ItemCount, 
                      UnitQuantity = @UnitQuantity, PalletNo = @PalletNo, NetWeight = @Netweight, DateArrived = @DateArrived, SupplierRef = @SupplierRef, Barcode = @Barcode, 
                      SupplierLotNo = @SupplierLotNo, Comments = @Comments, UserGroupID = @UserGroupID, HarvestDate = @HarvestDate, UnitStockCodeID = @UnitStockCodeID, 
                      OriginalBarcode = @OriginalBarcode, E_Text1 = @E_Text1, E_Text2 = @E_Text2, E_Numeric1 = @E_Numeric1, E_Numeric2 = @E_Numeric2, 
                      E_DateTime1 = @E_DateTime1, PalletID = @PalletID, Certified = @Certified, ArrivalTemp = @ArrivalTemp, E_Numeric3 = @E_Numeric3, Updated = @Updated, 
                      RecordStatus = @RecordStatus, PalletStockCodeID=@PalletStockCodeID,StoreID=@StoreID,CountryID=@CountryID,Alias=@Alias,
					  CustomerID=@CustomerID,
					  LookupText1=@LookupText1, 
					  LookupText2=@LookupText2, 
					  LookupText3=@LookupText3, 
					  LookupText4=@LookupText4, 
					  LookupText5=@LookupText5, 
					  LookupText6=@LookupText6, 
					  LookupText7=@LookupText7, 
					  LookupText8=@LookupText8, 
					  LookupText9=@LookupText9, 
					  LookupText10=@LookupText10
	WHERE     (GoodsIntakeID = @GoodsIntakeID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_AssessmentQuestionConstraint_AdminList')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_AssessmentQuestionConstraint_AdminList] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 10/07/2008
-- Description:	Gets the constraints for specified question
-- Version:		7
-- =============================================
-- JT TFS 4084: 11 July 2012: QAFlag lookup uses resource.
-- JT TFS 5831: 24 Jan 2013: Look up date type for constraints grid.
-- JT TFS 7002: Standardised a DisplayText for constraints for ease of human readability (and display on grid).
-- JT TFS 7065: Collation specified for column Lookup_DisplayText (required for SQL2005)
-- JT TFS 7267: Constraint data type for system lookups now uses underlying data type.
-- JE TFS 13-2923: added ShowHiddenSubQuestions column
-- UK TFS 71207: values produced by the Lookup_DisplayText column are surrounded with square bracket 
-- =============================================
ALTER PROCEDURE [dbo].[QRY_AssessmentQuestionConstraint_AdminList] 
	@AssessmentQuestionID int,
	@UserID int = NULL
AS
BEGIN
	-- Test data: DECLARE @AssessmentQuestionID int, @UserID int SELECT @AssessmentQuestionID = 1472, @UserID = NULL

	SET NOCOUNT ON
	IF nullif(object_id('tempdb..#tmpQAFlag'), 0) IS NOT NULL DROP TABLE #tmpQAFlag
	SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
	INTO #tmpQAFlag
	FROM         APP_QAFlag
	
	IF nullif(object_id('tempdb..#tmpDateLookup'), 0) IS NOT NULL DROP TABLE #tmpDateLookup
	CREATE TABLE #tmpDateLookup (DataLookupID int, DataLookup nvarchar(50))
	INSERT #tmpDateLookup (DataLookupID, DataLookup)
	EXEC QRY_DataLookup_DateType
	
	SET NOCOUNT OFF

	SELECT	QMS_AssessmentQuestionConstraint.QuestionConstraintID, QMS_AssessmentQuestionConstraint.AssessmentQuestionID, 
			QMS_AssessmentQuestionConstraint.Constraint_Text, QMS_AssessmentQuestionConstraint.Constraint_Text_LeftChars, 
			QMS_AssessmentQuestionConstraint.Constraint_Boolean, QMS_AssessmentQuestionConstraint.Constraint_Date_Min, 
			QMS_AssessmentQuestionConstraint.Constraint_Date_Max, QMS_AssessmentQuestionConstraint.Constraint_Date_TypeID, 
			DateLookup.DataLookup AS Lookup_Constraint_Date_TypeID,
			QMS_AssessmentQuestionConstraint.Constraint_Date_MinValue, QMS_AssessmentQuestionConstraint.Constraint_Date_MaxValue, 
			QMS_AssessmentQuestionConstraint.Constraint_Numeric_Min, QMS_AssessmentQuestionConstraint.Constraint_Numeric_Max,
			QMS_AssessmentQuestionConstraint.Constraint_Formula_Min, QMS_AssessmentQuestionConstraint.Constraint_Formula_Max,
			QMS_AssessmentQuestionConstraint.Constraint_SourceID, AssessmentQuestionConstraint_Source.SourceObject AS Lookup_Constraint_SourceID, 
			QMS_AssessmentQuestionConstraint.QAFlagID, 
			qaflag.QAFlag AS Lookup_QAFlagID, 
			QMS_AssessmentQuestionConstraint.Score, 
			QMS_AssessmentQuestionConstraint.GuidanceID, QMS_Guidance.GuidanceDesc AS Lookup_GuidanceID, QMS_AssessmentQuestionConstraint.ShortGuidance, 
			QMS_AssessmentQuestionConstraint.CorrectiveActionTypeID, QMS_CorrectiveActionType.CorrectiveActionType AS Lookup_CorrectiveActionTypeID,

			ISNULL(
		CASE	WHEN ConstraintDataType.DataTypeID IN (1, 6) THEN Constraint_Text 
				WHEN ConstraintDataType.DataTypeID IN (2) THEN CASE WHEN Constraint_Boolean = 0 THEN '[[[No]]]' ELSE '[[[Yes]]]' END
				WHEN ConstraintDataType.DataTypeID IN (3,4,5) THEN 
					CASE	WHEN coalesce(Constraint_Date_MinValue, Constraint_Date_MaxValue) IS NOT NULL 
								THEN isnull(convert(varchar(30), Constraint_Date_MinValue), '[[[no lower limit]]]') + ' - ' + isnull(convert(varchar(30), Constraint_Date_MaxValue), '[[[no upper limit]]]') + ' [[[days from]]] ' + DateLookup.DataLookup
							WHEN coalesce(Constraint_Date_Min, Constraint_Date_Max) IS NOT NULL 
								THEN '[[[From]]] ' + convert(varchar(30), Constraint_Date_Min, 106) + ' [[[to]]] ' + convert(varchar(30), Constraint_Date_Max, 106)
								ELSE DateLookup.DataLookup
					END
				WHEN ConstraintDataType.DataTypeID IN (7,8) THEN isnull(convert(varchar(30), Constraint_Numeric_Min), '([[[no lower limit]]])') + ' [[[to]]] ' + isnull(convert(varchar(30), Constraint_Numeric_Max), '([[[no upper limit]]])')
				WHEN ConstraintDataType.DataTypeID IN (9,10) THEN AssessmentQuestionConstraint_Source.SourceObject
				WHEN ConstraintDataType.DataTypeID IN (11) THEN '' -- image
				WHEN ConstraintDataType.DataTypeID IN (12) THEN AssessmentQuestionConstraint_Source.SourceObject
				ELSE '[[[no match]]]'
		END, '') COLLATE Latin1_General_CI_AS as 'Lookup_DisplayText',
		ConstraintDataType.DataTypeID, QMS_AssessmentQuestionConstraint.ShowHiddenSubQuestions
		
	FROM         QMS_AssessmentQuestionConstraint 
	INNER JOIN QMS_AssessmentQuestion ON QMS_AssessmentQuestionConstraint.AssessmentQuestionID = QMS_AssessmentQuestion.AssessmentQuestionID 
	INNER JOIN (
		SELECT	system_question.AssessmentQuestionID, 
				DataTypeID = CASE	WHEN system_question.DataTypeID IN (9,10) AND system_lookup.DataTypeID IS NOT NULL
									THEN system_lookup.DataTypeID
									ELSE system_question.DataTypeID END
		FROM QMS_AssessmentQuestion system_question
		LEFT OUTER JOIN APP_DataLookup system_lookup ON system_lookup.DataLookupID = system_question.DataLookupID
	) AS ConstraintDataType ON ConstraintDataType.AssessmentQuestionID = QMS_AssessmentQuestion.AssessmentQuestionID
	LEFT OUTER JOIN	QMS_CorrectiveActionType ON QMS_AssessmentQuestionConstraint.CorrectiveActionTypeID = QMS_CorrectiveActionType.CorrectiveActionTypeID 
	LEFT OUTER JOIN	QMS_Guidance ON QMS_AssessmentQuestionConstraint.GuidanceID = QMS_Guidance.GuidanceID 
	LEFT OUTER JOIN	#tmpQAFlag qaflag ON QMS_AssessmentQuestionConstraint.QAFlagID = qaflag.QAFlagID 
	LEFT OUTER JOIN	dbo.FNC_AssessmentQuestionConstraint_Source(@AssessmentQuestionID) AS AssessmentQuestionConstraint_Source ON QMS_AssessmentQuestionConstraint.Constraint_SourceID = AssessmentQuestionConstraint_Source.SourceObjectID
	LEFT OUTER JOIN #tmpDateLookup DateLookup ON DateLookup.DataLookupID = QMS_AssessmentQuestionConstraint.Constraint_Date_TypeID
	WHERE   (QMS_AssessmentQuestionConstraint.AssessmentQuestionID = @AssessmentQuestionID) 
	AND		(QMS_AssessmentQuestionConstraint.RecordStatus < 201)


END

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'UP_Response_SetCompany')
	EXEC ('CREATE PROCEDURE [dbo].[UP_Response_SetCompany] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		j.toolan
-- Create date: 4 July 2012
-- Description:	Update response table to ensure that the CompanyID is set based on region.
-- Version:		3
-- =============================================
-- TFS 4021: j.toolan: 4 July 2012: Created
-- Markp 26/07/12: Changed to use Location lookup rather than region
-- JT TFS 13-72293: Update CompanyID based on UserID if config option is set to 'user'
-- =============================================
ALTER PROCEDURE UP_Response_SetCompany
AS

/* The QMS_Response.CompanyID value will be set WHERE CompanyID IS NULL, 
	ResponseStatus = 1, RecordStatus < 100 (100 is temp value set while 
	a sync is in progress) and NotificationSent = 0
 
	The CompanyID can be looked up by seeing if a region system lookup 
	value has been captured in QMS_ResponseHeader and looking up CompanyID 
	for that region.  If no region is in the header, CompanyID will remain as NULL.

	We have added functionality so that option 139 should be set to location (the default) or user.
	If it is set to user, then the Response will log the company for a user. 
	WARNING: It matches on Company Name.
*/

DECLARE @companyBasedOn nvarchar(100);
SELECT @companyBasedOn = LOWER(dbo.FNC_GetOptionValue(139)) -- ResponseCompanyBase

IF @companyBasedOn = 'user'
BEGIN
	UPDATE	QMS_Response
	SET     CompanyID = QMS_Company.CompanyID
	FROM	QMS_Response INNER JOIN
				QMS_User ON QMS_Response.UserID = QMS_User.UserID INNER JOIN
				QMS_Company ON QMS_User.Company = QMS_Company.CompanyName
	WHERE	(QMS_Response.CompanyID IS NULL)
			AND (QMS_Response.ResponseStatus = 1)
			AND (QMS_Response.RecordStatus < 100) 
			AND (QMS_Company.CompanyName IS NOT NULL)
END
ELSE
BEGIN
	UPDATE    QMS_Response
	SET              CompanyID = PM_VW_Region.CompanyID
	FROM         QMS_Response INNER JOIN
						  QMS_ResponseHeader ON QMS_Response.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
						  PM_VW_Location ON QMS_ResponseHeader.Header_SourceID = PM_VW_Location.LocationID INNER JOIN
						  PM_VW_Region ON PM_VW_Location.RegionID = PM_VW_Region.RegionID
	WHERE     (QMS_ResponseHeader.AssessmentHeaderID IN
							  (SELECT     AssessmentHeaderID
								FROM          QMS_AssessmentHeader
								WHERE      (DataLookupID = 4))) AND (QMS_Response.CompanyID IS NULL) AND (QMS_Response.ResponseStatus = 1) AND (QMS_Response.RecordStatus < 100) 
						  AND (QMS_Response.NotificationSent = 0) AND (PM_VW_Region.CompanyID IS NOT NULL)
END
GO


PRINT 'Database updated successfully!'
GO

