-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO


UPDATE    SYNC_ClientAnchor
SET              LastReceived = NULL
WHERE TableName = 'APP_Country'
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SP_User_Unlock')
	EXEC ('CREATE PROCEDURE [dbo].[SP_User_Unlock] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================  
-- Author:  Markp  
-- Create date: 18/09/2013  
-- Description: Procedure to reinstate a user account  
-- Version:  6  
-- =============================================  
-- PH TFS 13-66609 : v3 14/02/2017 - Added HashType logic to password reactivation.  
-- PH TFS 13-66609 : v4 14/02/2017 - Made password a bcrypt hash for Muddy user.  
-- PH TFS 13-66609 : v5 21/02/2017 - Refrain from using bcrypt hash for Muddy user until bcrypt enabled.  
-- MartinP TFS 13-70968 : v6 12/04/2017 - Skip looking up previous password if muddy account passed in
-- =============================================  
ALTER PROCEDURE [dbo].[SP_User_Unlock]  
 @Username NVARCHAR(255),  
 @FullName NVARCHAR(255)  
AS  
BEGIN  
 DECLARE @UserID INT;  
  
 SELECT @UserID = MAX(UserID) FROM dbo.QMS_User WHERE UserName = @Username;  
  
 IF @UserID IS NULL  
 BEGIN  
  SELECT 'Username not found!' AS [Result];  
  RETURN -1;  
 END  
  
 DECLARE @Password NVARCHAR(255);  
 DECLARE @HashType int;  
  
  --Support expect the muddy password to reset to default, and must always set the password back to the password in keepass.
 IF @UserID <> 1
 BEGIN
	 SELECT @Password =  
	  Password FROM dbo.QMS_UserPassword  
	  WHERE UserID = @UserID AND ExpiryDate > GETDATE()  
	  ORDER BY Password DESC;  
  END
  
 SELECT @HashType =  
  HashType FROM dbo.QMS_UserPassword  
  WHERE UserID = @UserID AND ExpiryDate > GETDATE()  
  ORDER BY Password DESC;  
  
 IF @UserID = 1 AND @Password IS NULL  
 BEGIN  
  DECLARE @hashTypeConfig int;  
  SET @hashTypeConfig = dbo.FNC_GetOptionValue(61);  
  
  IF (@hashTypeConfig = 3)  
  BEGIN  
   SET @Password = N'$2a$13$8LIExEUuilfQ0f86I1kqV.eaa0FBkwcXIS7HkSxc.IRZoSKGuAo5i';  
   SET @HashType = 3;  
  END  
  ELSE  
  BEGIN  
   SET @Password = N'E1A2F3931A22B9A3235E880DF6FD0137';  
   SET @HashType = 0;  
  END  
  
  PRINT 'Using default muddy password - This MUST BE MADE SECURE from the password in Keepass';  
 END  
  
 UPDATE  dbo.QMS_User  
 SET     FullName = @FullName ,  
   LeftCompany = 0 ,  
   RecordStatus = 20 ,  
   Updated = GETDATE() ,  
   Password = @Password,  
   HashType = @HashType  
 WHERE   UserID = @UserID;  
  
 IF @@ROWCOUNT<=0  
 BEGIN  
  SELECT 'Failed to unlock user!' AS [Result];  
  RETURN -1;  
 END  
 ELSE  
 BEGIN  
  IF @Password IS NULL  
   SELECT 'User successfully unlocked! You will need to reissue a password' AS [Result];  
  ELSE  
   SELECT 'User successfully unlocked!' AS [Result];  
  RETURN 0;  
 END  
END  
GO


-- BEGIN DATA DATA_AddResourceNameToAppCountry
BEGIN TRY
IF NOT EXISTS (SELECT * FROM sys.columns WHERE Name = N'ResourceName' AND Object_ID = Object_ID (N'APP_Country'))
BEGIN
	ALTER TABLE APP_Country
	ADD ResourceName NVARCHAR (255)
END

END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA AddResourceNameToAppCountry', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA DATA_AddResourceNameToAppCountry



-- BEGIN DATA MOBILE_SCHEMA_Add PM_ConsignmentItems_E_UOM
BEGIN TRY



IF NOT EXISTS
(
	SELECT *
	FROM sys.columns 
	WHERE Name      = N'E_UOM'
    AND Object_ID = Object_ID(N'PM_ConsignmentItems')
)
BEGIN
    ALTER TABLE [dbo].[PM_ConsignmentItems]
	ADD 
	E_UOM nvarchar(10)
END

IF NOT EXISTS
(
	SELECT *
	FROM sys.columns 
	WHERE Name      = N'CurrencyID'
    AND Object_ID = Object_ID(N'PM_ConsignmentItems')
)
BEGIN
    ALTER TABLE [dbo].[PM_ConsignmentItems]
	ADD 
	CurrencyID INT,
	Discount money,
	VAT money,
	ItemAccepted BIT,
	PalletLabels int,
	E_UOM_OTHER nvarchar(10),
	LocationID INT,
	Source tinyint
END





END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA MOBILE_SCHEMA_Add PM_ConsignmentItems_E_UOM', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA MOBILE_SCHEMA_Add PM_ConsignmentItems_E_UOM


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_ConsignmentItems')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_ConsignmentItems] AS SELECT ''stub version, to be replaced''')
GO

-- =============================================
-- Author:		jmf	
-- Create date: 21/4/15
-- Description:	Updates mobile data from the sync
-- Version:		7
-- =============================================
-- jf TFS 19430 added @VersionNo
--jf TFS 23605 - make sure no date conversions happen
-- jf tfs 29101 - add itemstatus
-- PH TFS 13-46056 : v4 16/05/2016 - Added @DateRequiredAsText and @DepotDateAsText to work around unwanted XML UTC offset conversions.  As prescribed by Mark Powell.
-- PH TFS 13-46056 : v5 16/05/2016 - Reformatted code to make more understandable and inserted semi-colons to make forward compatible added dbo schema prefix.
-- PH TFS 13-46056 : v6 25/05/2016 - Fixed the Markleville and WaterFord Township (48327) bugs by specifying all nvarchar lengths on new parameters.
-- JF TFS 70104 - make sure all the PO items fields are imported - specifically @E_UOM
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_PM_ConsignmentItems] 
	@ConsignmentItemID int,
	@ConsignmentID int,
	@StockCodeID int,
	@Quantity real,
	@UnitStockCodeID int,
	@UnitQuantity real,
	@QuantityAccepted real,
	@DepotDate datetime,
	@DepotDateAsText nvarchar(50) = NULL,
	@UnitPrice money,
	@Comments nvarchar(1000) = NULL,
	@DateRequired DATETIME = NULL,
	@DateRequiredAsText nvarchar(50) = NULL,
	@E_POItem NVARCHAR(20) = NULL,
	@Hide BIT = NULL,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@VersionNo INT,
	@ItemStatus INT,
	
	@E_UOM nvarchar(10)=null,
	@CurrencyID INT=null,
	@Discount money=null,
	@VAT money=null,
	@ItemAccepted BIT=null,
	@PalletLabels int=null,
	@E_UOM_OTHER nvarchar(10)=null,
	@LocationID INT=null,
	@Source tinyint=null,

	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

IF @DepotDateAsText IS NOT NULL
	SET @DepotDate = @DepotDateAsText;
ELSE
	SET @DepotDate = dbo.FNC_ConvertServerDate(@DepotDate);

IF @DateRequiredAsText IS NOT NULL
	SET @DateRequired = @DateRequiredAsText;
ELSE
	SET @DateRequired = dbo.FNC_ConvertServerDate(@DateRequired);

IF @Hide  IS NULL
	SET @Hide = 0;

IF NOT EXISTS(SELECT * FROM dbo.PM_ConsignmentItems WHERE (ConsignmentItemID = @ConsignmentItemID))
BEGIN --Append record
	IF @RecordStatus < 201 AND EXISTS(SELECT ConsignmentID FROM dbo.PM_Consignment WHERE (ConsignmentID = @ConsignmentID))
	BEGIN
		INSERT INTO dbo.PM_ConsignmentItems
        (
			ConsignmentItemID,
			ConsignmentID,
			StockCodeID,
			Quantity,
			UnitStockCodeID,
			UnitQuantity,
			QuantityAccepted,
			DepotDate,
			UnitPrice,
			Comments,
			DateRequired,
			E_POItem,
			Hide,
			RecordStatus,
			GUID,
			VersionNo,
			ItemStatus,

			E_UOM ,
			CurrencyID ,
			Discount ,
			VAT ,
			ItemAccepted ,
			PalletLabels ,
			E_UOM_OTHER ,
			LocationID ,
			Source

		)
		VALUES
		(
			@ConsignmentItemID,
			@ConsignmentID,
			@StockCodeID,
			@Quantity,
			@UnitStockCodeID,
			@UnitQuantity,
			@QuantityAccepted,
			@DepotDate,
			@UnitPrice,
			@Comments,
			@DateRequired,
			@E_POItem,
			@Hide,
			@RecordStatus,
			@GUID,
			@VersionNo,
			@ItemStatus,

			@E_UOM ,
			@CurrencyID ,
			@Discount ,
			@VAT ,
			@ItemAccepted ,
			@PalletLabels ,
			@E_UOM_OTHER ,
			@LocationID ,
			@Source 

		);

		SET @InsertCount = @@rowcount;
	END
END

ELSE
BEGIN --Update record
	UPDATE	dbo.PM_ConsignmentItems
	SET
		StockCodeID = @StockCodeID,
		Quantity = @Quantity,
		UnitStockCodeID = @UnitStockCodeID,
		UnitQuantity = @UnitQuantity,
		QuantityAccepted = @QuantityAccepted,
		DepotDate = @DepotDate,
		UnitPrice = @UnitPrice,
		Comments = @Comments,
		DateRequired = @DateRequired,
		E_POItem = @E_POItem,
		Hide = @Hide,
		RecordStatus = @RecordStatus,
		VersionNo=@VersionNo,
		ItemStatus=@ItemStatus,

		E_UOM=@E_UOM ,
		CurrencyID=@CurrencyID ,
		Discount=@Discount ,
		VAT=@VAT ,
		ItemAccepted=@ItemAccepted ,
		PalletLabels=@PalletLabels ,
		E_UOM_OTHER=@E_UOM_OTHER ,
		LocationID=@LocationID ,
		Source =@Source 

	WHERE	ConsignmentItemID = @ConsignmentItemID;

	SET @UpdateCount = @@rowcount;
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint);
ELSE
	SET @ReceivedAnchor = @Created;




IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_User')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_User] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: Markp
-- Create date	: 30/06/2008
-- Description	: Adds and edits user details
-- Version		: 12
-- =============================================
-- J.Toolan 13 Feb 2012: Stopped code from adding more than one username
-- J.Toolan 8 Mar 2012: Added SHA2 password field to update/insert
-- MarkP 1 Jun 2012: Made sure UserPermissions.Updated is set
-- JToolan 12 Jun 2012: TFS 3905 - Stopped Password resetting on NULL entry.
-- JT TFS 6629 - Use UP_User_Password to write passwords.
-- JT TFS 13-11261 - Add new admin users to the AdminAlerts group (ignore existing users).
-- JT TFS 13-11810 - User can have their CustomerID changed when only one specified.
-- JT TFS 13-17956 - Creating a user or updating and changing the supplier should trigger a corrective action rebuild.
-- JT TFS 13-21321 - Only trigger a ca rebuild on new user or change to any one of userlevel, usergroup, supplier, customer or LeftCompany
-- PH TFS 13-66014 : v11 03/02/2017 - Remove extraneous password parameters and add HashType parameter
-- PH TFS 13-68676 : v12 13/03/2017 - Took into account that Password and HashType parameters will not be included if user's password not changed.  HashType column is also now only set by dbo.UP_User_Password.
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_User] 
	@UserID int,
	@FullName nvarchar(255),
	@UserName nvarchar(255),
	@Password nvarchar(255) = NULL,
	@Position nvarchar(255),
	@Company nvarchar(255),
	@EMail nvarchar(100),
	@Mobile nvarchar(50),
	@PIN nvarchar(10),
	@LeftCompany bit,
	@UserLevel int,
	@LocaleID int,
	@IsUserGroup bit,
	@ParentUserID int,
	@SupplierID int = NULL,
	@CustomerID int = NULL,
	@HashType int = NULL
AS
BEGIN 
	SET NOCOUNT ON

	-- Find out if a CA rebuild is required or not (it's a very expensive operation)
	-- only trigger on new user, or change to any one of userlevel, usergroup, supplier, customer or LeftCompany
	DECLARE @IsCARebuildRequired bit
	BEGIN
		DECLARE @originalSupplier TABLE (SupplierID int)
		INSERT @originalSupplier (SupplierID)
		SELECT  CAST(PermissionTitle AS int)
		FROM         QMS_UserPermissions
		WHERE	(PermissionType = 101) 
		AND		(PermissionAllow = 1)
		AND		(UserID = @UserID)

		DECLARE @originalCustomer TABLE (CustomerID int)
		INSERT @originalCustomer (CustomerID)
		SELECT  CAST(PermissionTitle AS int)
		FROM         QMS_UserPermissions
		WHERE	(PermissionType = 102) 
		AND		(PermissionAllow = 1)
		AND		(UserID = @UserID)

		DECLARE @originalParentUserID int, @originalUserLevel int, @originalLeftCompany bit
		SELECT @originalParentUserID = ParentUserID, @originalUserLevel = UserLevel, @originalLeftCompany = LeftCompany
		FROM QMS_User
		WHERE UserID = @UserID

		DECLARE @originalSupplierID int 
		SELECT @originalSupplierID = CASE	WHEN (SELECT count(*) FROM @originalSupplier) > 1 THEN -1
											ELSE (SELECT TOP 1 SupplierID FROM @originalSupplier) END

		DECLARE @originalCustomerID int 
		SELECT @originalCustomerID = CASE	WHEN (SELECT count(*) FROM @originalCustomer) > 1 THEN -1
											ELSE (SELECT TOP 1 CustomerID FROM @originalCustomer) END

		SELECT @IsCARebuildRequired = CASE	WHEN ISNULL(@UserID,0) = 0 THEN 1 -- yes for new users.
											WHEN ISNULL(@SupplierID, 0) <> ISNULL(@originalSupplierID, 0) THEN 1
											WHEN ISNULL(@CustomerID, 0) <> ISNULL(@originalCustomerID, 0) THEN 1
											WHEN ISNULL(@ParentUserID, 0) <> ISNULL(@originalParentUserID, 0) THEN 1
											WHEN ISNULL(@UserLevel, 0) <> ISNULL(@originalUserLevel, 0) THEN 1
											WHEN ISNULL(@LeftCompany, 0) <> ISNULL(@originalLeftCompany, 0) THEN 1
											ELSE 0 END
	END

	IF ISNULL(@UserID,0)=0 --New user
	BEGIN
		IF NOT EXISTS (SELECT * FROM QMS_User WHERE RecordStatus < 201 AND UserName = @UserName COLLATE Latin1_General_ci_ai)
		BEGIN
			INSERT INTO QMS_User
			(
				FullName,
				UserName,
				Position,
				EMail,
				Mobile,
				PIN,
				LeftCompany,
				UserLevel,
				LocaleID,
				IsUserGroup,
				ParentUserID,
				Company
			)
			VALUES
			(
				@FullName,
				@UserName,
				@Position,
				@EMail,
				@Mobile,
				@PIN,
				@LeftCompany,
				@UserLevel,
				@LocaleID,
				@IsUserGroup,
				@ParentUserID,
				@Company
			)
			--Get new UserID
			SELECT @UserID = SCOPE_IDENTITY()
		
			EXEC UP_User_Password @UserName, @Password, @HashType

			-- INSERT INTO ADMIN NOTIFICATION GROUP 11261

			DECLARE @NotificationGroupID int
			SELECT @NotificationGroupID = NotificationGroupID
			FROM QMS_NotificationGroup WHERE Sys_Group = 'AdminAlerts'

			INSERT QMS_NotificationGroupUser (NotificationGroupID, UserID, RecordStatus)
			SELECT @NotificationGroupID, UserID, 2
			FROM QMS_User 
			WHERE dbo.FNC_GetUserLevel(UserID) = 1 
			AND RecordStatus < 201
			AND UserID = @UserID
			AND NOT EXISTS (SELECT * FROM QMS_NotificationGroupUser 
							WHERE NotificationGroupID = @NotificationGroupID 
							AND UserID = QMS_User.UserID
							AND RecordStatus < 201)

			-- END INSERT INTO ADMIN NOTIFICATION GROUP 11261

		END
	END
	ELSE --Update user
	BEGIN
	-- Don't change the username to an existing other username. It violates the single username principle of logging in.
		IF EXISTS (SELECT * FROM QMS_User WHERE RecordStatus < 201 AND UserName = @UserName COLLATE Latin1_General_ci_ai AND UserID <> @UserID)
		BEGIN
			SET @UserID = 0 -- This should cause the save procedure to fail.
		END
		ELSE
		BEGIN -- Username is still unique on all undeleted records.
			--JE - update passwords table (TFS 973)
			IF @Password IS NOT NULL
			BEGIN
				EXEC UP_User_Password @UserName, @Password, @HashType
			END

			UPDATE    QMS_User
			SET
				FullName = @FullName,
				UserName = @UserName,
				Position = @Position,
				EMail = @EMail,
				Mobile = @Mobile,
				PIN = @PIN,
				LeftCompany = @LeftCompany,
				UserLevel = @UserLevel,
				LocaleID = @LocaleID,
				IsUserGroup = @IsUserGroup,
				ParentUserID = @ParentUserID,
				Company = @Company,
				Updated = GETUTCDATE()
			WHERE UserID = @UserID;
		END
	END

	DECLARE @PermissionID int = NULL
	IF ISNULL(@SupplierID,0) > 0 AND ISNULL(@UserID,0) > 0
	BEGIN --Setup linked supplier
		SELECT     @PermissionID = MAX(UserPermissionID)
		FROM         QMS_UserPermissions
		WHERE     (PermissionType = 101) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) = @SupplierID)
		IF ISNULL(@PermissionID,0)=0 --Add permission
		BEGIN
			INSERT INTO QMS_UserPermissions (UserID, PermissionType, PermissionTitle, PermissionAllow)
			VALUES     (@UserID, 101,@SupplierID, 1)
		END
		ELSE
		BEGIN
			UPDATE	QMS_UserPermissions
			SET		PermissionAllow = 1, Updated = GETUTCDATE()
			WHERE	(UserPermissionID = @PermissionID) AND (PermissionAllow = 0)
		END
	
		--Remove any existing permissions
		UPDATE  QMS_UserPermissions
		SET		PermissionAllow = 0, Updated = GETUTCDATE()
		WHERE   (PermissionType = 101) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) <> @SupplierID) AND (PermissionAllow = 1)
	END


	-- Setup CustomerID Link
	SET @PermissionID = NULL -- in case it has a previous value
	IF ISNULL(@CustomerID,0) > 0 AND ISNULL(@UserID,0) > 0
	BEGIN --Setup linked customer
		SELECT     @PermissionID = MAX(UserPermissionID)
		FROM         QMS_UserPermissions
		WHERE     (PermissionType = 102) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) = @CustomerID)
		IF ISNULL(@PermissionID,0)=0 --Add permission
		BEGIN
			INSERT INTO QMS_UserPermissions (UserID, PermissionType, PermissionTitle, PermissionAllow)
			VALUES     (@UserID, 102,@CustomerID, 1)
		END
		ELSE
		BEGIN
			UPDATE	QMS_UserPermissions
			SET		PermissionAllow = 1, Updated = GETUTCDATE()
			WHERE	(UserPermissionID = @PermissionID) AND (PermissionAllow = 0)
		END
	
		--Remove any existing permissions
		UPDATE  QMS_UserPermissions
		SET		PermissionAllow = 0, Updated = GETUTCDATE()
		WHERE   (PermissionType = 102) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) <> @CustomerID) AND (PermissionAllow = 1)
	END

	IF @IsCARebuildRequired = 1
		EXEC SAVE_CorrectiveActionUser_ByUser @UserID

	SET NOCOUNT OFF

	SELECT @UserID
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_PriorityLevel_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_PriorityLevel_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================  
-- Author:  Markp  
-- Create date: 09/07/2008  
-- Description: Gets list of priority levels to fill combo  
-- Version: 3 
-- =============================================  
-- jf tfs 1202 - get test from language strings
-- MartinP TFS 13-52882: 03/04/2017 - Add option to not translate strings - @DoNotTranslate
-- =============================================  
ALTER PROCEDURE [dbo].[QRY_PriorityLevel_Combo]   
 @UserID as int,
 @DoNotTranslate AS BIT = 0
   
AS  
SELECT     PriorityLevelID, 
CASE WHEN @DoNotTranslate = 0 THEN
	ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), PriorityLevel)
ELSE
	ISNULL(dbo.FNC_ResourceString_User(ResourceName, NULL), PriorityLevel)
 END as PriorityLevel  
FROM         APP_PriorityLevel  
ORDER BY ListIndex  
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Country_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Country_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================    
-- Author:  Markp    
-- Create date: 14/11/2008    
-- Description: Gets country list for combo    
-- Version:  3    
-- =============================================    
-- MP TFS 446: Added @AssessmentType parameter so can tell when combo is being called from Mobile  
-- MartinP TFS 13-52882: 04/04/2017 - Added @UserID and links to dbo.FNC_ResourceString_User  - Also added @DoNotTranslate option
-- =============================================    
    
ALTER PROCEDURE [dbo].[QRY_Country_Combo]     
 @SupplierID int = NULL,    
 @AssessmentTypeID INT = NULL,  
 @UserID INT = NULL,
 @DoNotTranslate AS BIT = 0    
AS    
     
DECLARE @FilterCountryID int    
SET @FilterCountryID = NULL    
    
IF @SupplierID IS NOT NULL    
 SELECT     @FilterCountryID = CountryID    
 FROM         PM_VW_Supplier    
 WHERE     (SupplierID = @SupplierID)    
    
IF @FilterCountryID IS NULL    
 IF @AssessmentTypeID IS NULL    
  SELECT     CountryID, 
  CASE WHEN @DoNotTranslate = 0 THEN
	ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), Country)
  ELSE
	ISNULL(dbo.FNC_ResourceString_User(ResourceName, NULL), Country)
  END AS Country    
  FROM         APP_Country    
  ORDER BY Country    
 ELSE  --being called from mobile    
  SELECT     CountryID, 
    CASE WHEN @DoNotTranslate = 0 THEN
	ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), Country)
  ELSE
	ISNULL(dbo.FNC_ResourceString_User(ResourceName, NULL), Country)
  END AS Country        
  FROM         APP_Country    
  UNION     
  SELECT     CountryAliasID AS CountryID, CountryAlias AS Country    
  FROM         QMS_CountryAlias    
  WHERE     (RecordStatus < 201)    
  ORDER BY Country    
ELSE    
 SELECT     CountryID, 
     CASE WHEN @DoNotTranslate = 0 THEN
	ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), Country)
  ELSE
	ISNULL(dbo.FNC_ResourceString_User(ResourceName, NULL), Country)
  END AS Country     
 FROM         APP_Country    
 WHERE     (CountryID = @FilterCountryID)    
 ORDER BY Country 
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_Country')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_Country] AS SELECT ''stub version, to be replaced''')
GO
-- ===================================================
-- Author:		Jonathan Toolan
-- Create date:	11 Apr 2017
-- Description:	[insert description here]
-- Version:		1
-- ===================================================
-- ===================================================
ALTER PROCEDURE [dbo].[SYNC_Import_Country] 
	@CountryID int,
	@Country nvarchar(255),
	@Updated datetime,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@ResourceName nvarchar(255),
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

IF NOT EXISTS(SELECT * FROM APP_Country WHERE (CountryID = @CountryID))
BEGIN --Append record
	INSERT INTO APP_Country
                      (CountryID, Country, Updated, GUID, ResourceName)
	VALUES     (@CountryID,@Country,@Updated,@GUID,@ResourceName)
	SET @InsertCount = @@rowcount
END

ELSE
BEGIN --Update record
	UPDATE    APP_Country
	SET              Country = @Country, Updated = @Updated, ResourceName = @ResourceName
	WHERE     (CountryID = @CountryID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO



PRINT 'Database updated successfully!'
GO

