-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_User')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_User] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: Markp
-- Create date	: 30/06/2008
-- Description	: Adds and edits user details
-- Version		: 12
-- =============================================
-- J.Toolan 13 Feb 2012: Stopped code from adding more than one username
-- J.Toolan 8 Mar 2012: Added SHA2 password field to update/insert
-- MarkP 1 Jun 2012: Made sure UserPermissions.Updated is set
-- JToolan 12 Jun 2012: TFS 3905 - Stopped Password resetting on NULL entry.
-- JT TFS 6629 - Use UP_User_Password to write passwords.
-- JT TFS 13-11261 - Add new admin users to the AdminAlerts group (ignore existing users).
-- JT TFS 13-11810 - User can have their CustomerID changed when only one specified.
-- JT TFS 13-17956 - Creating a user or updating and changing the supplier should trigger a corrective action rebuild.
-- JT TFS 13-21321 - Only trigger a ca rebuild on new user or change to any one of userlevel, usergroup, supplier, customer or LeftCompany
-- PH TFS 13-66014 : v11 03/02/2017 - Remove extraneous password parameters and add HashType parameter
-- PH TFS 13-68676 : v12 13/03/2017 - Took into account that Password and HashType parameters will not be included if user's password not changed.  HashType column is also now only set by dbo.UP_User_Password.
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_User] 
	@UserID int,
	@FullName nvarchar(255),
	@UserName nvarchar(255),
	@Password nvarchar(255) = NULL,
	@Position nvarchar(255),
	@Company nvarchar(255),
	@EMail nvarchar(100),
	@Mobile nvarchar(50),
	@PIN nvarchar(10),
	@LeftCompany bit,
	@UserLevel int,
	@LocaleID int,
	@IsUserGroup bit,
	@ParentUserID int,
	@SupplierID int = NULL,
	@CustomerID int = NULL,
	@HashType int = NULL
AS
BEGIN 
	SET NOCOUNT ON

	-- Find out if a CA rebuild is required or not (it's a very expensive operation)
	-- only trigger on new user, or change to any one of userlevel, usergroup, supplier, customer or LeftCompany
	DECLARE @IsCARebuildRequired bit
	BEGIN
		DECLARE @originalSupplier TABLE (SupplierID int)
		INSERT @originalSupplier (SupplierID)
		SELECT  CAST(PermissionTitle AS int)
		FROM         QMS_UserPermissions
		WHERE	(PermissionType = 101) 
		AND		(PermissionAllow = 1)
		AND		(UserID = @UserID)

		DECLARE @originalCustomer TABLE (CustomerID int)
		INSERT @originalCustomer (CustomerID)
		SELECT  CAST(PermissionTitle AS int)
		FROM         QMS_UserPermissions
		WHERE	(PermissionType = 102) 
		AND		(PermissionAllow = 1)
		AND		(UserID = @UserID)

		DECLARE @originalParentUserID int, @originalUserLevel int, @originalLeftCompany bit
		SELECT @originalParentUserID = ParentUserID, @originalUserLevel = UserLevel, @originalLeftCompany = LeftCompany
		FROM QMS_User
		WHERE UserID = @UserID

		DECLARE @originalSupplierID int 
		SELECT @originalSupplierID = CASE	WHEN (SELECT count(*) FROM @originalSupplier) > 1 THEN -1
											ELSE (SELECT TOP 1 SupplierID FROM @originalSupplier) END

		DECLARE @originalCustomerID int 
		SELECT @originalCustomerID = CASE	WHEN (SELECT count(*) FROM @originalCustomer) > 1 THEN -1
											ELSE (SELECT TOP 1 CustomerID FROM @originalCustomer) END

		SELECT @IsCARebuildRequired = CASE	WHEN ISNULL(@UserID,0) = 0 THEN 1 -- yes for new users.
											WHEN ISNULL(@SupplierID, 0) <> ISNULL(@originalSupplierID, 0) THEN 1
											WHEN ISNULL(@CustomerID, 0) <> ISNULL(@originalCustomerID, 0) THEN 1
											WHEN ISNULL(@ParentUserID, 0) <> ISNULL(@originalParentUserID, 0) THEN 1
											WHEN ISNULL(@UserLevel, 0) <> ISNULL(@originalUserLevel, 0) THEN 1
											WHEN ISNULL(@LeftCompany, 0) <> ISNULL(@originalLeftCompany, 0) THEN 1
											ELSE 0 END
	END

	IF ISNULL(@UserID,0)=0 --New user
	BEGIN
		IF NOT EXISTS (SELECT * FROM QMS_User WHERE RecordStatus < 201 AND UserName = @UserName COLLATE Latin1_General_ci_ai)
		BEGIN
			INSERT INTO QMS_User
			(
				FullName,
				UserName,
				Position,
				EMail,
				Mobile,
				PIN,
				LeftCompany,
				UserLevel,
				LocaleID,
				IsUserGroup,
				ParentUserID,
				Company
			)
			VALUES
			(
				@FullName,
				@UserName,
				@Position,
				@EMail,
				@Mobile,
				@PIN,
				@LeftCompany,
				@UserLevel,
				@LocaleID,
				@IsUserGroup,
				@ParentUserID,
				@Company
			)
			--Get new UserID
			SELECT @UserID = SCOPE_IDENTITY()
		
			EXEC UP_User_Password @UserName, @Password, @HashType

			-- INSERT INTO ADMIN NOTIFICATION GROUP 11261

			DECLARE @NotificationGroupID int
			SELECT @NotificationGroupID = NotificationGroupID
			FROM QMS_NotificationGroup WHERE Sys_Group = 'AdminAlerts'

			INSERT QMS_NotificationGroupUser (NotificationGroupID, UserID, RecordStatus)
			SELECT @NotificationGroupID, UserID, 2
			FROM QMS_User 
			WHERE dbo.FNC_GetUserLevel(UserID) = 1 
			AND RecordStatus < 201
			AND UserID = @UserID
			AND NOT EXISTS (SELECT * FROM QMS_NotificationGroupUser 
							WHERE NotificationGroupID = @NotificationGroupID 
							AND UserID = QMS_User.UserID
							AND RecordStatus < 201)

			-- END INSERT INTO ADMIN NOTIFICATION GROUP 11261

		END
	END
	ELSE --Update user
	BEGIN
	-- Don't change the username to an existing other username. It violates the single username principle of logging in.
		IF EXISTS (SELECT * FROM QMS_User WHERE RecordStatus < 201 AND UserName = @UserName COLLATE Latin1_General_ci_ai AND UserID <> @UserID)
		BEGIN
			SET @UserID = 0 -- This should cause the save procedure to fail.
		END
		ELSE
		BEGIN -- Username is still unique on all undeleted records.
			--JE - update passwords table (TFS 973)
			IF @Password IS NOT NULL
			BEGIN
				EXEC UP_User_Password @UserName, @Password, @HashType
			END

			UPDATE    QMS_User
			SET
				FullName = @FullName,
				UserName = @UserName,
				Position = @Position,
				EMail = @EMail,
				Mobile = @Mobile,
				PIN = @PIN,
				LeftCompany = @LeftCompany,
				UserLevel = @UserLevel,
				LocaleID = @LocaleID,
				IsUserGroup = @IsUserGroup,
				ParentUserID = @ParentUserID,
				Company = @Company,
				Updated = GETUTCDATE()
			WHERE UserID = @UserID;
		END
	END

	DECLARE @PermissionID int = NULL
	IF ISNULL(@SupplierID,0) > 0 AND ISNULL(@UserID,0) > 0
	BEGIN --Setup linked supplier
		SELECT     @PermissionID = MAX(UserPermissionID)
		FROM         QMS_UserPermissions
		WHERE     (PermissionType = 101) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) = @SupplierID)
		IF ISNULL(@PermissionID,0)=0 --Add permission
		BEGIN
			INSERT INTO QMS_UserPermissions (UserID, PermissionType, PermissionTitle, PermissionAllow)
			VALUES     (@UserID, 101,@SupplierID, 1)
		END
		ELSE
		BEGIN
			UPDATE	QMS_UserPermissions
			SET		PermissionAllow = 1, Updated = GETUTCDATE()
			WHERE	(UserPermissionID = @PermissionID) AND (PermissionAllow = 0)
		END
	
		--Remove any existing permissions
		UPDATE  QMS_UserPermissions
		SET		PermissionAllow = 0, Updated = GETUTCDATE()
		WHERE   (PermissionType = 101) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) <> @SupplierID) AND (PermissionAllow = 1)
	END


	-- Setup CustomerID Link
	SET @PermissionID = NULL -- in case it has a previous value
	IF ISNULL(@CustomerID,0) > 0 AND ISNULL(@UserID,0) > 0
	BEGIN --Setup linked customer
		SELECT     @PermissionID = MAX(UserPermissionID)
		FROM         QMS_UserPermissions
		WHERE     (PermissionType = 102) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) = @CustomerID)
		IF ISNULL(@PermissionID,0)=0 --Add permission
		BEGIN
			INSERT INTO QMS_UserPermissions (UserID, PermissionType, PermissionTitle, PermissionAllow)
			VALUES     (@UserID, 102,@CustomerID, 1)
		END
		ELSE
		BEGIN
			UPDATE	QMS_UserPermissions
			SET		PermissionAllow = 1, Updated = GETUTCDATE()
			WHERE	(UserPermissionID = @PermissionID) AND (PermissionAllow = 0)
		END
	
		--Remove any existing permissions
		UPDATE  QMS_UserPermissions
		SET		PermissionAllow = 0, Updated = GETUTCDATE()
		WHERE   (PermissionType = 102) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) <> @CustomerID) AND (PermissionAllow = 1)
	END

	IF @IsCARebuildRequired = 1
		EXEC SAVE_CorrectiveActionUser_ByUser @UserID

	SET NOCOUNT OFF

	SELECT @UserID
END
GO





PRINT 'Database updated successfully!'
GO

