-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON

GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO



-- BEGIN DATA DATA_GENERIC_PM_GoodsIntake_CustomerID
BEGIN TRY
IF NOT EXISTS(SELECT * FROM sys.columns WHERE Name = N'CustomerID' AND Object_ID = Object_ID(N'PM_GoodsIntake'))

alter table dbo.PM_GoodsIntake add
	CustomerID int
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA_GENERIC_PM_GoodsIntake_CustomerID', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA DATA_GENERIC_PM_GoodsIntake_CustomerID

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'PM_VW_GoodsIntake')
	EXEC ('CREATE VIEW [dbo].[PM_VW_GoodsIntake] AS SELECT 1 as ''stub version, to be replaced''')
GO
--=============================================
-- Author:		Unknown
-- Create date: 29/06/2010
-- Description:	Gets header informaton for PM_GoodsIntake
-- Version:		10
-- =============================================
-- JT TFS 4286: 9-Aug-2012: Added PalletID
-- JF: Added ArrivalTemp and Certified
-- MP TFS 2798: Added Updated column
-- jf TFS 19129 - added PalletStockCodeID
-- jf TFS 29162 - added storeID
-- jf tfs 32575 - add @CountryID and @Alias
-- JF TFS 53109 - Added CustomerID
--=============================================
ALTER VIEW [dbo].[PM_VW_GoodsIntake]
AS
SELECT GoodsIntakeID, SupplierID, ConsignmentItemID, LocationID, UserGroupID, ItemCount, UnitQuantity, PalletNo, HarvestDate, DeliveryID, DateArrived, SupplierRef, SupplierLotNo, Barcode, Comments, E_Text1, E_Text2, 
                  UnitStockCodeID, OriginalBarcode, E_Numeric1, E_DateTime1, PalletID, ArrivalTemp, Certified, Updated, NetWeight, PalletStockCodeID, RowVersion, Created, RecordStatus, E_Numeric3, E_Numeric2, GUID, StoreID, 
                  CountryID, Alias, CustomerID
FROM     dbo.PM_GoodsIntake
WHERE  (RecordStatus < 201)



GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_GoodsIntake')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_GoodsIntake] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		unknown
-- Create date: 18/12/2008
-- Description:	imports data into the mobile PM_GoodsIntake table
-- Version:		6
-- =============================================
-- jf tfs 18253 - added @PalletStockCodeID
-- jf tfs 29101 - added storeid
-- jf TFS 23605 - make sure no date conversions happen
-- jf tfs 32575 - add @CountryID and @Alias
-- JF TFS 53109 - Added CustomerID
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_PM_GoodsIntake] 
	@GoodsIntakeID int,
	@SupplierID int,
	@ConsignmentItemID int,
	@LocationID int,
	@ItemCount real,
	@UnitQuantity int,
	@PalletNo int,
	@NetWeight real = NULL,
	@DeliveryID int,
	@DateArrived datetime,
	@SupplierRef nvarchar(50),
	@Barcode nvarchar(50),
	@OriginalBarcode nvarchar(50) = NULL,
	@UserGroupID int,
	@HarvestDate datetime,
	@SupplierLotNo nvarchar(50),
	@Comments nvarchar(255),
	@UnitStockCodeID int = NULL,
	@E_Text1 nvarchar(50) = NULL,
	@E_Text2 nvarchar(50) = NULL,
	@E_Numeric1 int = NULL,
	@E_Numeric2 int = NULL,
	@E_DateTime1 datetime = NULL,
	@PalletID INT = NULL,
	@Certified BIT = NULL,
	@ArrivalTemp REAL = NULL,
	@E_Numeric3 REAL = NULL,
	@Updated DATETIME = NULL,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@PalletStockCodeID int,
	@StoreID int = null,
	@CountryID int = NULL,
	@Alias nvarchar(50) = NULL,
	@CustomerID int = null,

	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

SET @DateArrived = dbo.FNC_ConvertServerDate(@DateArrived)
SET @HarvestDate = dbo.FNC_ConvertServerDate(@HarvestDate)
SET @E_DateTime1 = dbo.FNC_ConvertServerDate(@E_DateTime1)

IF @Certified IS NULL
	SET @Certified = 0
	
IF NOT EXISTS(SELECT * FROM dbo.PM_GoodsIntake WHERE (GoodsIntakeID = @GoodsIntakeID))
BEGIN --Append record
	IF @RecordStatus < 201 AND EXISTS(SELECT ConsignmentID FROM dbo.PM_ConsignmentItems WHERE (ConsignmentItemID = @ConsignmentItemID))
	BEGIN
		INSERT INTO dbo.PM_GoodsIntake
                      (GoodsIntakeID, SupplierID, ConsignmentItemID, LocationID, ItemCount, UnitQuantity, PalletNo, NetWeight, DeliveryID, DateArrived, SupplierRef, SupplierLotNo, Comments, 
                      UserGroupID, HarvestDate, Barcode, UnitStockCodeID, OriginalBarcode, E_Text1, E_Text2, E_Numeric1, E_Numeric2, E_DateTime1, PalletID, Certified, ArrivalTemp, 
                      E_Numeric3, Updated, RecordStatus, GUID,PalletStockCodeID,StoreID, CountryID, Alias, CustomerID)
		VALUES     (@GoodsIntakeID,@SupplierID,@ConsignmentItemID,@LocationID,@ItemCount,@UnitQuantity,@PalletNo,@Netweight,@DeliveryID,@DateArrived,@SupplierRef,@SupplierLotNo,@Comments,@UserGroupID,@HarvestDate,@Barcode,@UnitStockCodeID,@OriginalBarcode,@E_Text1,@E_Text2,@E_Numeric1,@E_Numeric2,@E_DateTime1,@PalletID,@Certified,@ArrivalTemp,@E_Numeric3,@Updated,@RecordStatus,@GUID,@PalletStockCodeID,@StoreID, @CountryID, @Alias, @CustomerID)
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    dbo.PM_GoodsIntake
	SET              SupplierID = @SupplierID, ConsignmentItemID = @ConsignmentItemID, LocationID = @LocationID, DeliveryID = @DeliveryID, ItemCount = @ItemCount, 
                      UnitQuantity = @UnitQuantity, PalletNo = @PalletNo, NetWeight = @Netweight, DateArrived = @DateArrived, SupplierRef = @SupplierRef, Barcode = @Barcode, 
                      SupplierLotNo = @SupplierLotNo, Comments = @Comments, UserGroupID = @UserGroupID, HarvestDate = @HarvestDate, UnitStockCodeID = @UnitStockCodeID, 
                      OriginalBarcode = @OriginalBarcode, E_Text1 = @E_Text1, E_Text2 = @E_Text2, E_Numeric1 = @E_Numeric1, E_Numeric2 = @E_Numeric2, 
                      E_DateTime1 = @E_DateTime1, PalletID = @PalletID, Certified = @Certified, ArrivalTemp = @ArrivalTemp, E_Numeric3 = @E_Numeric3, Updated = @Updated, 
                      RecordStatus = @RecordStatus, PalletStockCodeID=@PalletStockCodeID,StoreID=@StoreID,CountryID=@CountryID,Alias=@Alias,
					  CustomerID=@CustomerID
	WHERE     (GoodsIntakeID = @GoodsIntakeID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_Specification_ConstraintGuidance')
	EXEC('CREATE FUNCTION [dbo].[FNC_Specification_ConstraintGuidance]() RETURNS @x TABLE (y bit) AS BEGIN RETURN END')
GO
-- =============================================
-- Author:		Markp
-- Create date: 07/05/2010
-- Description:	Gets guidance images for assessment constraints
-- Version:		7
-- =============================================
-- JE TFS 6012 - added lookup of images from master spec to display for temp specs
-- JE TFS 6582 - updated so that if a question's guidance contains master and temp attachments, only show temp for that question
-- JE TFS 6582 - (comment by JT + incremented version number) Updated cursor so it returns same columns regardless of path.
-- JE TFS 6727 - altered TempFlag sub-query to use COUNT rather than IS NULL so multiple attachments to one question handled correctly
--					and ensured sub-query is only counting Temp Spec attachments.
-- JT TFS 13-47832: 27/06/2016 - Put cursor results in a table and get the results from the table, rather than swapping the cursor definition
-- JT TFS 13-53793: 12/08/2016 - Ordering of results affects output for temp specs. Add ordering clause to cursor.
-- =============================================
ALTER FUNCTION dbo.FNC_Specification_ConstraintGuidance 
(
	@AssessmentID int
)
RETURNS @Table_Guidance TABLE 
(
	AssessmentQuestionID int,
	IndexNo tinyint,
	GreenTemp bit,
	Green_AttachmentID int,
	AmberTemp bit,
	Amber_AttachmentID int,
	RedTemp bit,
	Red_AttachmentID int
)
AS
BEGIN

--uncomment for debugging
--declare @AssessmentID int
--set @AssessmentID = 59084 --58604
--declare @Table_Guidance TABLE 
--(
--	AssessmentQuestionID int,
--	IndexNo tinyint,
--	GreenTemp bit,
--	Green_AttachmentID int,
--	AmberTemp bit,
--	Amber_AttachmentID int,
--	RedTemp bit,
--	Red_AttachmentID int
--)
	
	DECLARE @AQ TABLE (
		AssessmentID int,
		AssessmentQuestionID int,
		Sys_AssessmentQuestionID int
	)
	INSERT @AQ (AssessmentID, AssessmentQuestionID, Sys_AssessmentQuestionID)
	SELECT @AssessmentID, AssessmentQuestionID, Sys_AssessmentQuestionID 
	FROM QMS_AssessmentQuestion
	WHERE AssessmentID = @AssessmentID
	AND RecordStatus < 201


	DECLARE @Guidance TABLE (
		AssessmentQuestionID int,
		QAFlagID int,
		GreenTempFlag int,
		GreenTitle int,
		AmberTempFlag int,
		AmberTitle int,
		RedTempFlag int,
		RedTitle int
	)

	--get master AssessmentID for @AssessmentID if @AssessmentID is a temp spec
	DECLARE @MasterAssessmentID as int

	SELECT	@MasterAssessmentID = MAX(QMS_Assessment_Master.AssessmentID)
	FROM	QMS_Assessment AS QMS_Assessment_Master 
	INNER JOIN	QMS_Assessment AS QMS_Assessment_Temp ON QMS_Assessment_Master.Sys_AssessmentID = QMS_Assessment_Temp.Sys_AssessmentID
	WHERE	(QMS_Assessment_Master.TempSpec = 0) AND (QMS_Assessment_Master.AssessmentStatusID = 3) AND
				(QMS_Assessment_Temp.AssessmentID = @AssessmentID) AND (QMS_Assessment_Temp.TempSpec = 1)

	DECLARE @MasterAQ TABLE (
		AssessmentID int,
		AssessmentQuestionID int,
		Sys_AssessmentQuestionID int
	)
	INSERT @MasterAQ (AssessmentID, AssessmentQuestionID, Sys_AssessmentQuestionID)
	SELECT @MasterAssessmentID, AssessmentQuestionID, Sys_AssessmentQuestionID 
	FROM QMS_AssessmentQuestion
	WHERE AssessmentID = @MasterAssessmentID
	AND RecordStatus < 201


	DECLARE @fldAssessmentQuestionID int, @fldQAFlagID int, @fldGreenTempFlag bit, @fldGreenAttachmentID int, @fldAmberTempFlag bit,
				@fldAmberAttachmentID int, @fldRedTempFlag bit, @fldRedAttachmentID int

	IF @MasterAssessmentID IS NULL --don't need to look up Guidance for temp spec
		INSERT @Guidance (AssessmentQuestionID, QAFlagID, GreenTempFlag, GreenTitle, AmberTempFlag, AmberTitle, RedTempFlag, RedTitle)
		SELECT  QMS_AssessmentQuestionConstraint.AssessmentQuestionID, 
				QMS_AssessmentQuestionConstraint.QAFlagID, 
						  0 AS GreenTempFlag,
						  CASE WHEN QAFlagID = 1 THEN QMS_Attachment.AttachmentID ELSE NULL END AS GreenTitle, 
						  0 AS AmberTempFlag,
						  CASE WHEN QAFlagID = 2 THEN QMS_Attachment.AttachmentID ELSE NULL END AS AmberTitle, 
						  0 AS RedTempFlag,
						  CASE WHEN QAFlagID = 3 THEN QMS_Attachment.AttachmentID ELSE NULL END AS RedTitle
		FROM         QMS_Guidance AS Constraint_GuidanceAttachment 
		INNER JOIN	QMS_AssessmentQuestionConstraint ON Constraint_GuidanceAttachment.GuidanceID = QMS_AssessmentQuestionConstraint.GuidanceID 
		INNER JOIN	QMS_Attachment ON Constraint_GuidanceAttachment.GuidanceID = QMS_Attachment.SourceObjectID 
		INNER JOIN	@AQ as QMS_AssessmentQuestion ON QMS_AssessmentQuestionConstraint.AssessmentQuestionID = QMS_AssessmentQuestion.AssessmentQuestionID
		WHERE   (QMS_AssessmentQuestionConstraint.RecordStatus < 201) 
		AND		(QMS_Attachment.AttachmentSourceID = 3) 
		AND		(QMS_AssessmentQuestion.AssessmentID = @AssessmentID) 
		AND		(QMS_Attachment.RecordStatus < 201) 
		AND		(Constraint_GuidanceAttachment.RecordStatus < 201)
	
	ELSE --look up Guidance for temp spec from master
		INSERT @Guidance (AssessmentQuestionID, QAFlagID, GreenTempFlag, GreenTitle, AmberTempFlag, AmberTitle, RedTempFlag, RedTitle)
		SELECT Attachments.AssessmentQuestionID, Attachments.QAFlagID,
				CASE WHEN Attachments.QAFlagID = 1 THEN TempSpec_Attachment ELSE NULL END AS GreenTempFlag, --set flag to say if a Green Temp attachment is present or not
				CASE WHEN Attachments.QAFlagID = 1 THEN AttachmentID ELSE NULL END AS GreenTitle,
				CASE WHEN Attachments.QAFlagID = 2 THEN TempSpec_Attachment ELSE NULL END AS AmberTempFlag,
				CASE WHEN Attachments.QAFlagID = 2 THEN AttachmentID ELSE NULL END AS AmberTitle,
				CASE WHEN Attachments.QAFlagID = 3 THEN TempSpec_Attachment ELSE NULL END AS RedTempFlag,
				CASE WHEN Attachments.QAFlagID = 3 THEN AttachmentID ELSE NULL END AS RedTitle
		FROM (SELECT QMS_AssessmentQuestion_Master.Sys_AssessmentQuestionID AS AssessmentQuestionID, --use Sys_AssessmentQuestionID as this will be the same for master and temp assessments
						QMS_AssessmentQuestionConstraint_Master.QAFlagID, MasterAttachments.AttachmentID, 0 AS TempSpec_Attachment
				FROM	QMS_AssessmentQuestionConstraint AS QMS_AssessmentQuestionConstraint_Master
							INNER JOIN @MasterAQ AS QMS_AssessmentQuestion_Master
								ON QMS_AssessmentQuestionConstraint_Master.AssessmentQuestionID = QMS_AssessmentQuestion_Master.AssessmentQuestionID
							LEFT OUTER JOIN	QMS_Attachment AS MasterAttachments ON QMS_AssessmentQuestionConstraint_Master.GuidanceID = MasterAttachments.SourceObjectID
				WHERE	(QMS_AssessmentQuestionConstraint_Master.RecordStatus < 201)
							AND (MasterAttachments.AttachmentSourceID = 3)
							AND (QMS_AssessmentQuestion_Master.AssessmentID = @MasterAssessmentID)
							AND (MasterAttachments.RecordStatus < 201)
				UNION --two separate queries - one for master attachments, one for temp spec attachments
			  SELECT QMS_AssessmentQuestion_Temp.Sys_AssessmentQuestionID AS AssessmentQuestionID,
						QMS_AssessmentQuestionConstraint_Temp.QAFlagID,	TempAttachments.AttachmentID, 1 AS TempSpec_Attachment
				FROM	QMS_AssessmentQuestionConstraint AS QMS_AssessmentQuestionConstraint_Temp
							INNER JOIN @AQ AS QMS_AssessmentQuestion_Temp
								ON QMS_AssessmentQuestionConstraint_Temp.AssessmentQuestionID = QMS_AssessmentQuestion_Temp.AssessmentQuestionID
							LEFT OUTER JOIN	QMS_Attachment AS TempAttachments ON QMS_AssessmentQuestionConstraint_Temp.GuidanceID = TempAttachments.SourceObjectID
				WHERE	(QMS_AssessmentQuestionConstraint_Temp.RecordStatus < 201)
							AND (TempAttachments.AttachmentSourceID = 3)
							AND (QMS_AssessmentQuestion_Temp.AssessmentID = @AssessmentID)
							AND (TempAttachments.RecordStatus < 201)) AS Attachments
				ORDER BY GreenTempFlag DESC, AmberTempFlag DESC, RedTempFlag DESC


	DECLARE Guidance_cursor CURSOR FAST_FORWARD FOR 
	SELECT AssessmentQuestionID, QAFlagID, GreenTempFlag, GreenTitle, AmberTempFlag, AmberTitle, RedTempFlag, RedTitle FROM @Guidance
	ORDER BY GreenTempFlag DESC, AmberTempFlag DESC, RedTempFlag DESC;

	OPEN Guidance_cursor
	FETCH NEXT FROM Guidance_cursor INTO @fldAssessmentQuestionID, @fldQAFlagID, @fldGreenTempFlag, @fldGreenAttachmentID, @fldAmberTempFlag,
											@fldAmberAttachmentID, @fldRedTempFlag, @fldRedAttachmentID
	WHILE @@FETCH_STATUS = 0
	BEGIN 
		IF EXISTS(SELECT AssessmentQuestionID FROM @Table_Guidance WHERE (AssessmentQuestionID = @fldAssessmentQuestionID))
		BEGIN
			DECLARE @UpdateIndex tinyint, @MaxIndex tinyint
			SELECT @MaxIndex = ISNULL(MAX(IndexNo),0) FROM @Table_Guidance WHERE (AssessmentQuestionID = @fldAssessmentQuestionID)
			IF @fldQAFlagID = 1 --Green
			BEGIN
				IF @fldGreenTempFlag = 1 --insert Temp Spec attachments first as these take priority over master spec attachments
				BEGIN
					SELECT @UpdateIndex = MIN(IndexNo) FROM @Table_Guidance WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND Green_AttachmentID IS NULL)
					IF @UpdateIndex IS NULL
						INSERT INTO @Table_Guidance(AssessmentQuestionID, IndexNo, GreenTemp, Green_AttachmentID) VALUES (@fldAssessmentQuestionID, @MaxIndex + 1 , @fldGreenTempFlag, @fldGreenAttachmentID)
					ELSE
						UPDATE @Table_Guidance SET GreenTemp = @fldGreenTempFlag, Green_AttachmentID = @fldGreenAttachmentID WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND IndexNo = @UpdateIndex)
				END
				--if no temp green attachment has already been inserted for this question, insert master attachments
				IF @fldGreenTempFlag = 0 AND (SELECT COUNT(Green_AttachmentID) FROM @Table_Guidance WHERE AssessmentQuestionID = @fldAssessmentQuestionID AND GreenTemp = 1) = 0
				BEGIN
					SELECT @UpdateIndex = MIN(IndexNo) FROM @Table_Guidance WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND Green_AttachmentID IS NULL)
					IF @UpdateIndex IS NULL
						INSERT INTO @Table_Guidance(AssessmentQuestionID, IndexNo, GreenTemp, Green_AttachmentID) VALUES (@fldAssessmentQuestionID, @MaxIndex + 1 , @fldGreenTempFlag, @fldGreenAttachmentID)
					ELSE
						UPDATE @Table_Guidance SET GreenTemp = @fldGreenTempFlag, Green_AttachmentID = @fldGreenAttachmentID WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND IndexNo = @UpdateIndex)					
				END
			END
			IF @fldQAFlagID = 2 --Amber
			BEGIN
				IF @fldAmberTempFlag = 1 --insert Temp Spec attachments first as these take priority over master spec attachments
				BEGIN
					SELECT @UpdateIndex = MIN(IndexNo) FROM @Table_Guidance WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND Amber_AttachmentID IS NULL)
					IF @UpdateIndex IS NULL
						INSERT INTO @Table_Guidance(AssessmentQuestionID, IndexNo, AmberTemp, Amber_AttachmentID) VALUES (@fldAssessmentQuestionID, @MaxIndex + 1 , @fldAmberTempFlag, @fldAmberAttachmentID)
					ELSE
						UPDATE @Table_Guidance SET AmberTemp = @fldAmberTempFlag, Amber_AttachmentID = @fldAmberAttachmentID WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND IndexNo = @UpdateIndex)
				END
				--if no temp amber attachment has already been inserted for this question, insert master attachments
				IF @fldAmberTempFlag = 0 AND (SELECT COUNT(Amber_AttachmentID) FROM @Table_Guidance WHERE AssessmentQuestionID = @fldAssessmentQuestionID AND AmberTemp = 1) = 0
				BEGIN
					SELECT @UpdateIndex = MIN(IndexNo) FROM @Table_Guidance WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND Amber_AttachmentID IS NULL)
					IF @UpdateIndex IS NULL
						INSERT INTO @Table_Guidance(AssessmentQuestionID, IndexNo, AmberTemp, Amber_AttachmentID) VALUES (@fldAssessmentQuestionID, @MaxIndex + 1 , @fldAmberTempFlag, @fldAmberAttachmentID)
					ELSE
						UPDATE @Table_Guidance SET AmberTemp = @fldAmberTempFlag, Amber_AttachmentID = @fldAmberAttachmentID WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND IndexNo = @UpdateIndex)					
				END				
			END
			IF @fldQAFlagID = 3 --Red
			BEGIN
				IF @fldRedTempFlag = 1 --insert Temp Spec attachments first as these take priority over master spec attachments
				BEGIN
					SELECT @UpdateIndex = MIN(IndexNo) FROM @Table_Guidance WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND Red_AttachmentID IS NULL)
					IF @UpdateIndex IS NULL
						INSERT INTO @Table_Guidance(AssessmentQuestionID, IndexNo, RedTemp, Red_AttachmentID) VALUES (@fldAssessmentQuestionID, @MaxIndex + 1 , @fldRedTempFlag, @fldRedAttachmentID)
					ELSE
						UPDATE @Table_Guidance SET RedTemp = @fldRedTempFlag, Red_AttachmentID = @fldRedAttachmentID WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND IndexNo = @UpdateIndex)
				END
				--if no temp red attachment has already been inserted for this question, insert master attachments
				IF @fldRedTempFlag = 0 AND (SELECT COUNT(Red_AttachmentID) FROM @Table_Guidance WHERE AssessmentQuestionID = @fldAssessmentQuestionID AND RedTemp = 1) = 0
				BEGIN
					SELECT @UpdateIndex = MIN(IndexNo) FROM @Table_Guidance WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND Red_AttachmentID IS NULL)
					IF @UpdateIndex IS NULL
						INSERT INTO @Table_Guidance(AssessmentQuestionID, IndexNo, RedTemp, Red_AttachmentID) VALUES (@fldAssessmentQuestionID, @MaxIndex + 1 , @fldRedTempFlag, @fldRedAttachmentID)
					ELSE
						UPDATE @Table_Guidance SET RedTemp = @fldRedTempFlag, Red_AttachmentID = @fldRedAttachmentID WHERE (AssessmentQuestionID = @fldAssessmentQuestionID AND IndexNo = @UpdateIndex)					
				END	
			END
		END
		ELSE
			INSERT INTO @Table_Guidance(AssessmentQuestionID, IndexNo, GreenTemp, Green_AttachmentID, AmberTemp, Amber_AttachmentID, RedTemp, Red_AttachmentID)
			VALUES (@fldAssessmentQuestionID, 1, @fldGreenTempFlag, @fldGreenAttachmentID, @fldAmberTempFlag, @fldAmberAttachmentID, @fldRedTempFlag, @fldRedAttachmentID)

		FETCH NEXT FROM Guidance_cursor INTO @fldAssessmentQuestionID, @fldQAFlagID, @fldGreenTempFlag, @fldGreenAttachmentID, @fldAmberTempFlag,
												@fldAmberAttachmentID, @fldRedTempFlag, @fldRedAttachmentID
	END

	CLOSE Guidance_cursor
	DEALLOCATE Guidance_cursor

	RETURN
END
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_User_GetUserLevel')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_User_GetUserLevel] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 27/04/2010
-- Description:	Procedure to get user level
-- Version:		3
-- =============================================
-- j.toolan - 29-Feb-2012 Uses the authoritative function.
-- s.ford 6865: 19..08.2012 Added UserLevelDescription field
-- JT TFS 13-53153: 09/08/2016 - Modified column name from UserLevel to UserLevelId
-- =============================================
ALTER PROCEDURE QRY_User_GetUserLevel 
	@UserID int
AS
BEGIN -- TEST DATA: DECLARE @UserID int = 362
	DECLARE @UserLevelId AS int
	
	SELECT @UserLevelId = dbo.FNC_GetUserLevel(@UserID)
	
	SELECT @UserLevelId AS UserLevelId,
		   [UserLevel] AS UserLevelDescription
	FROM   [dbo].[APP_UserLevel]
	WHERE  @UserLevelId = UserLevelID
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QAS_RPT_Specification_HeaderSub')
	EXEC ('CREATE PROCEDURE [dbo].[QAS_RPT_Specification_HeaderSub] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jon Edwards
-- Create date: 05/02/2013
-- Description:	Returns header data for QAS report
-- Version:		2
-- =============================================
-- JT TFS 13-53793: 15/08/2016 - Link to master assessment specheader on Sys_AssSpecHeaderID
-- =============================================
ALTER PROCEDURE dbo.QAS_RPT_Specification_HeaderSub 
	@AssessmentID int
AS

--get master AssessmentID for @AssessmentID if @AssessmentID is a temp spec
DECLARE @MasterAssessmentID as int

SELECT	@MasterAssessmentID = MAX(QMS_Assessment_Master.AssessmentID)
FROM	QMS_Assessment AS QMS_Assessment_Master INNER JOIN
			QMS_Assessment AS QMS_Assessment_Temp ON QMS_Assessment_Master.Sys_AssessmentID = QMS_Assessment_Temp.Sys_AssessmentID
WHERE	(QMS_Assessment_Master.TempSpec = 0) AND (QMS_Assessment_Master.AssessmentStatusID = 3) AND
			(QMS_Assessment_Temp.AssessmentID = @AssessmentID) AND (QMS_Assessment_Temp.TempSpec = 1)

--get attachments for assessment
DECLARE @Attachment_Table TABLE (AssessmentSpecHeaderID int, AttachmentTitle nvarchar(255), Attachment image)

INSERT INTO @Attachment_Table (AssessmentSpecHeaderID, AttachmentTitle, Attachment)
SELECT	SourceObjectID AS AssessmentSpecHeaderID, AttachmentTitle, Attachment
FROM	QMS_Attachment
WHERE	(AttachmentSourceID = 4) AND (QMS_Attachment.RecordStatus < 201) AND (SourceObjectID IN
                          (SELECT     AssessmentSpecHeaderID --get attachments for master assessment too (only applies if running report for temp spec)
                            FROM          QMS_AssessmentSpecHeader
                            WHERE      (AssessmentID = @AssessmentID)))

IF @MasterAssessmentID IS NOT NULL --temp spec, so add temp spec attachments too
BEGIN
	INSERT INTO @Attachment_Table (AssessmentSpecHeaderID, AttachmentTitle, Attachment)
	SELECT	Temp.AssessmentSpecHeaderID, AttachmentTitle, Attachment
	FROM	QMS_Attachment INNER JOIN
				QMS_AssessmentSpecHeader ON QMS_Attachment.SourceObjectID = QMS_AssessmentSpecHeader.AssessmentSpecHeaderID INNER JOIN
				QMS_AssessmentSpecHeader AS Temp ON QMS_AssessmentSpecHeader.Sys_AssSpecHeaderID = Temp.Sys_AssSpecHeaderID
	WHERE	(AttachmentSourceID = 4) AND (QMS_Attachment.RecordStatus < 201) AND
				(QMS_AssessmentSpecHeader.AssessmentID = @MasterAssessmentID) AND (Temp.AssessmentID = @AssessmentID) AND
					(Temp.AssessmentSpecHeaderID NOT IN (SELECT AssessmentSpecHeaderID
														 FROM	@Attachment_Table))
END														 

--create table variable to store Multi-Text (note: don't use temp table as this introduces problems with collation)
DECLARE @MultiHeader TABLE (AssessmentSpecHeaderID int, Multi_Text nvarchar(1000))

INSERT INTO @MultiHeader (AssessmentSpecHeaderID, Multi_Text)
SELECT	SpecHeader.AssessmentSpecHeaderID,
		--if over 1000 chars, limit length so SP doesn't fail
		CASE WHEN LEN(Multi_Text_String) > 1000 THEN LEFT(Multi_Text_String, 997) + '...' ELSE Multi_Text_String END AS Multi_Text
FROM	(
	SELECT	SpecHeader.AssessmentSpecHeaderID,
			dbo.FNC_UnescapeXMLPath (substring(
			(	SELECT ', ' + QMS_AssessmentSpecHeaderMulti.Multi_Text
						FROM	QMS_AssessmentSpecHeaderMulti WHERE SpecHeader.AssessmentSpecHeaderID = QMS_AssessmentSpecHeaderMulti.AssessmentSpecHeaderID
						AND		(Multi_SourceID > -1)
						AND		NULLIF(Multi_Text, '') IS NOT NULL
						AND		RecordStatus < 201
						FOR XML PATH('')), 3, 99999)) [Multi_Text_String]
	 FROM QMS_AssessmentSpecHeader SpecHeader 
	 WHERE	(SpecHeader.AssessmentID = @AssessmentID) 
) AS [SpecHeader]
WHERE Multi_Text_String IS NOT NULL

--main query to return dataset for report
SELECT     QMS_AssessmentSpecHeader.AssessmentID, QMS_SpecificationHeader.HeaderTitle,
					--show Multi_Text when header is a multi response
					CASE WHEN QMS_AssessmentSpecHeader.Spec_SourceID = -1 THEN MultiHeader.Multi_Text ELSE QMS_AssessmentSpecHeader.Spec_Text END AS Spec_Text, 
					QMS_SpecificationHeader.DataTypeID, Attachment.AttachmentTitle, Attachment.Attachment
FROM         QMS_AssessmentSpecHeader INNER JOIN
					  QMS_SpecificationHeader ON QMS_AssessmentSpecHeader.SpecificationHeaderID = QMS_SpecificationHeader.SpecificationHeaderID LEFT OUTER JOIN
					  @Attachment_Table AS Attachment ON QMS_AssessmentSpecHeader.AssessmentSpecHeaderID = Attachment.AssessmentSpecHeaderID LEFT OUTER JOIN
					  @MultiHeader AS MultiHeader ON QMS_AssessmentSpecHeader.AssessmentSpecHeaderID = MultiHeader.AssessmentSpecHeaderID
WHERE     (QMS_AssessmentSpecHeader.AssessmentID = @AssessmentID) AND (QMS_AssessmentSpecHeader.RecordStatus < 201) AND 
					  (QMS_AssessmentSpecHeader.NotApplicable = 0) AND (QMS_SpecificationHeader.HideFromReports = 0) AND 
					  (QMS_SpecificationHeader.RecordStatus < 201) AND (QMS_SpecificationHeader.DataTypeID < 11)
					  OR --filters for attachment data
					  (QMS_AssessmentSpecHeader.AssessmentID = @AssessmentID) AND (QMS_AssessmentSpecHeader.RecordStatus < 201) AND 
					  (QMS_SpecificationHeader.HideFromReports = 0) AND (QMS_SpecificationHeader.RecordStatus < 201) AND 
					  (QMS_SpecificationHeader.DataTypeID = 11) AND (Attachment.Attachment IS NOT NULL)
ORDER BY QMS_SpecificationHeader.ListIndex
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_AssessmentQuestion_GetGuidance')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_AssessmentQuestion_GetGuidance] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 16/03/2010
-- version: 3
-- Description:	Gets the guidance detail for the selected assessment question
--==============================================
-- TFS 10889 - Mobile guidance should be reordered in Guidance popup
-- SS TFS 13-53805: Removed join within constraint guidance which joined on created date (created is not always unique AND was causing multiple images to show when they shouldn't have)
-- =============================================
ALTER PROCEDURE [dbo].[QRY_AssessmentQuestion_GetGuidance] 
	@AssessmentQuestionID int
AS
--Constraint guidance
SELECT     ISNULL(QMS_CustomLookupItem.LookupText, APP_QAFlag.QAFlag) AS Title,
CAST(NULL AS image) AS AttachmentImage, Constraint_Guidance.Attachment, 
                      QMS_AssessmentQuestionConstraint.ShortGuidance, 
                      Constraint_Guidance.GuidanceDesc, Constraint_Guidance.GuidanceString, Constraint_Guidance.GuidanceURL, QMS_AssessmentQuestionConstraint.QAFlagID, Constraint_Guidance.GuidanceID			
FROM         APP_QAFlag RIGHT OUTER JOIN
                      QMS_AssessmentQuestionConstraint ON APP_QAFlag.QAFlagID = QMS_AssessmentQuestionConstraint.QAFlagID LEFT OUTER JOIN
                          (SELECT     QMS_Guidance.GuidanceID, QMS_Guidance.GuidanceDesc, QMS_Guidance.GuidanceString, QMS_Guidance.GuidanceURL, 
                                                   Attachments.Attachment									   
                            FROM      QMS_Guidance 
							LEFT OUTER JOIN (SELECT guidance.Sys_GuidanceID, Attachment_Linked.AttachmentID 
											 FROM (	SELECT Sys_GuidanceID, AttachmentID, row 
														FROM (	SELECT	guidance.Sys_GuidanceID, attachment.AttachmentID,
																		ROW_NUMBER() OVER (PARTITION BY Sys_GuidanceID ORDER BY attachment.Created DESC, attachment.AttachmentID DESC) as row
																FROM QMS_Guidance guidance
																INNER JOIN QMS_Attachment attachment ON guidance.GuidanceID = attachment.SourceObjectID AND attachment.AttachmentSourceID = 3
																WHERE guidance.RecordStatus < 201
																AND attachment.RecordStatus < 201
															  ) AS GuidanceAttachment
														WHERE row = 1
													  ) AS LastGuidanceAttachment										 
											 INNER JOIN  QMS_Attachment AS Attachment_Linked ON LastGuidanceAttachment.AttachmentID = Attachment_Linked.AttachmentID 
											 INNER JOIN  QMS_Guidance AS Guidance ON LastGuidanceAttachment.Sys_GuidanceID = Guidance.Sys_GuidanceID 
											 AND Attachment_Linked.SourceObjectID = Guidance.GuidanceID
                                             WHERE (Attachment_Linked.AttachmentSourceID = 3) AND (Attachment_Linked.RecordStatus < 201)
											) AS Linked_Attachments ON QMS_Guidance.Sys_GuidanceID = Linked_Attachments.Sys_GuidanceID 
							LEFT OUTER JOIN ( SELECT     SourceObjectID AS GuidanceID, AttachmentTitle, Attachment, AttachmentFileName
											  FROM          QMS_Attachment
											  WHERE      (AttachmentSourceID = 3) AND (RecordStatus < 201)
											) AS Attachments ON QMS_Guidance.GuidanceID = Attachments.GuidanceID
                            WHERE      (QMS_Guidance.RecordStatus < 201) AND (QMS_Guidance.Hide = 0)) AS Constraint_Guidance ON QMS_AssessmentQuestionConstraint.GuidanceID = Constraint_Guidance.GuidanceID 
							LEFT OUTER JOIN QMS_CustomLookupItem ON QMS_AssessmentQuestionConstraint.Constraint_SourceID = QMS_CustomLookupItem.CustomLookupItemID
WHERE     (ISNULL(LEN(QMS_AssessmentQuestionConstraint.ShortGuidance), 0) > 0) 
AND (QMS_AssessmentQuestionConstraint.AssessmentQuestionID = @AssessmentQuestionID) 
AND (QMS_AssessmentQuestionConstraint.RecordStatus < 201)
OR  (QMS_AssessmentQuestionConstraint.AssessmentQuestionID = @AssessmentQuestionID) 
AND (QMS_AssessmentQuestionConstraint.RecordStatus < 201)
AND (Constraint_Guidance.GuidanceID IS NOT NULL)
ORDER BY QMS_AssessmentQuestionConstraint.QAFlagID

--Question guidance
SELECT     QMS_QuestionPool.Question AS Title, CAST(NULL AS image) AS AttachmentImage, Question_Guidance.Attachment, Question_Guidance.AttachmentFileName, Question_Guidance.AttachmentTitle, 
                      QMS_AssessmentQuestion.ShortGuidance, Question_Guidance.GuidanceDesc, Question_Guidance.GuidanceString, Question_Guidance.GuidanceURL, 
                      CAST(NULL AS int) AS QAFlagID
FROM         QMS_AssessmentQuestion INNER JOIN
                      QMS_QuestionPool ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID LEFT OUTER JOIN
                          (SELECT     QMS_Guidance.GuidanceID, QMS_Guidance.GuidanceDesc, QMS_Guidance.GuidanceString, QMS_Guidance.GuidanceURL, 
                                                   Attachments.AttachmentTitle, Attachments.Attachment, Attachments.AttachmentFileName
                            FROM          QMS_Guidance LEFT OUTER JOIN
                                                       (SELECT     SourceObjectID AS GuidanceID, AttachmentTitle, Attachment, AttachmentFileName
                                                         FROM          QMS_Attachment
                                                         WHERE      (AttachmentSourceID = 3) AND (RecordStatus < 201)) AS Attachments ON 
                                                   QMS_Guidance.GuidanceID = Attachments.GuidanceID
                            WHERE      (QMS_Guidance.RecordStatus < 201) AND (QMS_Guidance.Hide = 0)) AS Question_Guidance ON 
                      QMS_AssessmentQuestion.GuidanceID = Question_Guidance.GuidanceID
WHERE     (QMS_AssessmentQuestion.AssessmentQuestionID = @AssessmentQuestionID) AND (ISNULL(LEN(QMS_AssessmentQuestion.ShortGuidance), 0) 
                      > 0) OR
                      (QMS_AssessmentQuestion.AssessmentQuestionID = @AssessmentQuestionID) AND (Question_Guidance.GuidanceID IS NOT NULL)



GO



PRINT 'Database updated successfully!'
GO
