-- =============================================
-- Author:		Jeremy Formby
-- Create date: 3/05/2016
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO


-- BEGIN DATA Update_APP_AssessmentType_HasBeenUsed_49596
BEGIN TRY
-- Update_APP_AssessmentType_HasBeenUsed_49596
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME='APP_AssessmentType' and COLUMN_NAME='HasBeenUsed')
BEGIN
	ALTER TABLE dbo.APP_AssessmentType
		ADD HasBeenUsed bit NOT NULL DEFAULT 0;
END
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA Update_APP_AssessmentType_HasBeenUsed_49596', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA Update_APP_AssessmentType_HasBeenUsed_49596


-- BEGIN DATA Add_Column_APP_AssessmentType_IsWebChecksEnabled_49596
BEGIN TRY
-- Add_Column_APP_AssessmentType_HasBeenUsed_49596
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME='APP_AssessmentType' and COLUMN_NAME='IsWebChecksEnabled')
BEGIN
	ALTER TABLE dbo.APP_AssessmentType
		ADD IsWebChecksEnabled bit NOT NULL DEFAULT 0;
END
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA Add_Column_APP_AssessmentType_HasBeenUsed_49596', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA Add_Column_APP_AssessmentType_HasBeenUsed_49596

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'VW_PermissionLink')
	EXEC ('CREATE VIEW [dbo].[VW_PermissionLink] AS SELECT 1 as ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		J.Toolan
-- Create date: 14/08/2012
-- Description:	Adds columns for links to specific types, based on PermissionType
-- Version:		2
-- =============================================
-- PH TFS 13-48729 : v2 09/06/2016 - Reformatted to make more readable and added semi colon for forward compatibility.
-- =============================================
ALTER VIEW [dbo].[VW_PermissionLink]
AS
SELECT
	UserPermissionID,
	UserID,
	PermissionType,
	PermissionTitle,
	PermissionAllow,
	Updated,
	GUID,
	RowVersion,
	Created,
	CASE WHEN PermissionType IN (0, 1, 2, 11, 12, 13) THEN CONVERT(int, PermissionTitle) END AS MenuID,
	CASE WHEN PermissionType = 101 THEN CONVERT(int, PermissionTitle) END AS SupplierID,
	CASE WHEN PermissionType = 102 THEN CONVERT(int, PermissionTitle) END AS CustomerID,
	CASE WHEN PermissionType = 103 THEN CONVERT(int, PermissionTitle) END AS LocationID,
	CASE WHEN PermissionType = 104 THEN CONVERT(int, PermissionTitle) END AS StockCodeID,
	CASE WHEN PermissionType = 105 THEN PermissionTitle END AS StockCodeSubGroup,
	CASE WHEN PermissionType = 106 THEN PermissionTitle END AS BusinessGroup
FROM	QMS_UserPermissions
WHERE	PermissionAllow = 1;

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QAS_QRY_Assessment_AdminList')
	EXEC ('CREATE PROCEDURE [dbo].[QAS_QRY_Assessment_AdminList] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 08/02/2013
-- Description:	Gets data for generic QAS dashboard view
-- Version:		19
-- =============================================
-- JT TFS 5985: Added IsTempSpec and IsPrimarySupplier
-- JT TFS 8534: Added HasLinkedSites
-- JT TFS 8578: Added generic filtering if applied.
-- JT TFS 9015: Shelved assessments are always hidden from the QAS Dashboard (AssessmentStatusID of 2).
-- JT TFS 13-1729: Added StockCodeSubGroup to output display (because of filter, we are no longer able to set it from front end).
-- JT TFS 13-1729: Added Individual AssessmentID selection to update single items.
-- JT TFS 13-2453: Added SignOff_Comments
-- JT TFS 13-2914: Added SourceAssessmentID.
-- JT TFS 13-2944: Link to temp-spec-supplier now ignores deleted entries.
-- JT TFS 13-10124: Include PrimaryUserGroupID from QMS_SupplierPermission table in output.
-- JT TFS 13-10128: Send for Sign Off allowed if user is PrimarySupplier
-- JT TFS 13-11547: QAS Owner for UserGroup needs to be displayed.
-- JT TFS 13-26550: Remove parameter sniffing.
-- JT TFS 13-26550: Refactoring for consistent speed.
-- JT TFS 13-27253: IsQASOwnerValid entry looked up from PM_VW_StockCodePack
-- PH TFS 13-33041: Reformatted to make more understandable and semi-colons added.
-- MartinP TFS 13-37372: Re-ordered the fill of primary Supplier with the TempSpec Supplier so that it was not overwrritten by the primary Supplier
-- SS TFS 13-48470: Changed @UserID int = 1 to @UserID int
-- =============================================
ALTER PROCEDURE [dbo].[QAS_QRY_Assessment_AdminList]
	@UserID int,
	@StockCodeSubGroup nvarchar(100) = NULL,
	@IsFilterApplied bit = 1,
	@AssessmentID int = NULL
AS

SET NOCOUNT ON;

-- This date is used to check if the QAS Owner is still valid.
DECLARE @today DATETIME = convert(varchar(30), getdate(), 106);

-- avoid parameter sniffing
DECLARE @pUserID int,
		@pStockCodeSubGroup nvarchar(100),
		@pAssessmentID int,
		@pIsFilterApplied bit;
SELECT	@pUserID = @UserID,
		@pStockCodeSubGroup = @StockCodeSubGroup,
		@pAssessmentID = @AssessmentID,
		@pIsFilterApplied = @IsFilterApplied;

DECLARE @TEMP_Selected TABLE (SelectedID int, UserID int);

DELETE TEMP_Selected WHERE UserID = @pUserID;
IF @pAssessmentID IS NOT NULL
BEGIN
	INSERT	@TEMP_Selected
	(
		SelectedID,
		UserID
	)
	SELECT
		SourceObjectID,
		@pUserID
	FROM	QMS_AssessmentTarget
	WHERE	AssessmentID = @pAssessmentID;

	SET @pIsFilterApplied = 1;
END
ELSE IF @pIsFilterApplied = 1
BEGIN
	INSERT	@TEMP_Selected
	(
		SelectedID,
		UserID
	)
	SELECT
		StockCodeID,
		@pUserID
	FROM	TEMP_StockCodeFilter
	WHERE	UserID = @pUserID;
END
ELSE
BEGIN
	INSERT	@TEMP_Selected
	(
		SelectedID,
		UserID
	)
	SELECT
		StockCodeID,
		@pUserID
	FROM	PM_VW_StockCode
	WHERE	StockCodeSubGroup = @pStockCodeSubGroup;
END

DECLARE @tmpResult TABLE (
	[StockCodeID] [int] NOT NULL,
	[Description] [nvarchar](255) NOT NULL,
	[StockCode] [nvarchar](50) NULL,
	[TempSpecSupplier] [nvarchar](1000) NULL,
	[PrimarySupplier] [nvarchar](1000) NULL,
	[AssessmentID] [int] NOT NULL,
	[AssessmentName] [nvarchar](100) NULL,
	[Version] [nvarchar](20) NULL,
	[CheckedOutUserID] [int] NULL,
	[CheckedOutBy] [nvarchar](255) NULL,
	[AssessmentStatus] [nvarchar](50) NULL,
	[Active] [bit] NOT NULL,
	[IsTempSpec] [bit] NULL,
	[IsPrimarySupplier] [bit] NULL,
	[HasLinkedSites] [bit] NULL,
	[StockCodeSubGroup] [nvarchar](100) NULL,
	[SignOff_Comments] [nvarchar](255) NULL,
	[PreviousAssessmentID] [int] NULL,
	[SourceAssessmentID] [int] NULL,
	[PriorAssessmentDisplayText] [nvarchar](150) NULL,
	[PrimaryUserGroupID] [int] NULL,
	[PrimaryUserGroup] [nvarchar](255) NULL,
	[PrimarySupplierID] [int] NULL,
	[AssessmentGUID] [uniqueidentifier] NOT NULL,
	[IsQASOwnerValid] [bit] NOT NULL
)

--IF NULLIF(object_id('tempdb..@tmpResult'), 0) IS NOT NULL DROP TABLE @tmpResult
INSERT	@tmpResult
SELECT  dbo.PM_VW_StockCode.StockCodeID, 
		dbo.PM_VW_StockCode.Description,
		dbo.PM_VW_StockCode.StockCode,
		TempSpecSupplier = CONVERT(nvarchar(1000), NULL), -- do not show in final results.
		PrimarySupplier = CONVERT(nvarchar(1000), NULL), --CASE WHEN TempSpec_Supplier.SupplierID IS NULL THEN PrimarySupplier.SupplierName ELSE TempSpec_Supplier.SupplierName + N'*' END AS , 
		dbo.QMS_Assessment.AssessmentID,
		dbo.QMS_Assessment.AssessmentName, 
		dbo.QMS_Assessment.Version, 
		CheckedOutUserID = CONVERT(int, NULL),--CurrentCheckOut.UserID AS CheckedOutUserID,
		CheckedOutBy = CONVERT(nvarchar(255), NULL), --CurrentCheckOut.FullName AS CheckedOutBy, 
		dbo.APP_AssessmentStatus.AssessmentStatus, 
		dbo.APP_AssessmentStatus.Active,
		IsTempSpec = CONVERT(bit, 0), --convert(bit, CASE WHEN TempSpec_Supplier.AssessmentID IS NULL THEN 0 ELSE 1 END) AS IsTempSpec,
		IsPrimarySupplier = CONVERT(bit, 0),
		HasLinkedSites = CONVERT(bit, 0), /* convert(bit, CASE WHEN EXISTS (	SELECT 1 FROM PM_VW_StockCodeLocation
															INNER JOIN PM_VW_Location ON PM_VW_StockCodeLocation.LocationID = PM_VW_Location.LocationID
															WHERE PM_VW_StockCodeLocation.StockCodeID = PM_VW_StockCode.StockCodeID) THEN 1 ELSE 0 END), */
		dbo.PM_VW_StockCode.StockCodeSubGroup,
		dbo.QMS_Assessment.SignOff_Comments,
		dbo.QMS_Assessment.PreviousAssessmentID,
		dbo.QMS_Assessment.SourceAssessmentID,
		PriorAssessmentDisplayText = CONVERT(nvarchar(150), NULL),
		PrimaryUserGroupID = CONVERT(int, null), --PrimarySupplier.UserGroupID AS PrimaryUserGroupID,
		PrimaryUserGroup = CONVERT(nvarchar(255), null), --(SELECT TOP 1 FullName FROM QMS_User WHERE UserID = PrimarySupplier.UserGroupID) as PrimaryUserGroup

		PrimarySupplierID = CONVERT(int, NULL), -- Do not show in final results.
		dbo.QMS_Assessment.GUID AS AssessmentGUID, -- Do not show in final results.
		IsQASOwnerValid = CONVERT(bit, 0) -- This is set later if there is an entry in PM_VW_StockCodePack
FROM	dbo.QMS_AssessmentTarget 
INNER JOIN	dbo.QMS_Assessment
	ON dbo.QMS_AssessmentTarget.AssessmentID = dbo.QMS_Assessment.AssessmentID 
INNER JOIN	dbo.APP_AssessmentStatus
	ON dbo.QMS_Assessment.AssessmentStatusID = dbo.APP_AssessmentStatus.AssessmentStatusID 
INNER JOIN	dbo.FNC_User_StockCodeList(@pUserID) AS User_StockCodeList 
INNER JOIN	dbo.PM_VW_StockCode
	ON User_StockCodeList.StockCodeID = dbo.PM_VW_StockCode.StockCodeID 
	ON dbo.QMS_AssessmentTarget.SourceObjectID = dbo.PM_VW_StockCode.StockCodeID
INNER JOIN @TEMP_Selected AS TEMP_Selected
	ON TEMP_Selected.SelectedID = dbo.PM_VW_StockCode.StockCodeID
	AND TEMP_Selected.UserID = @pUserID
INNER JOIN	dbo.QAS_AssessmentType
	ON dbo.QMS_Assessment.AssessmentTypeID = dbo.QAS_AssessmentType.AssessmentTypeID 

WHERE
	(
		dbo.PM_VW_StockCode.StockCodeSubGroup = @pStockCodeSubGroup
		OR @pIsFilterApplied = 1
	)
	AND dbo.PM_VW_StockCode.Hide = 0
	AND dbo.APP_AssessmentStatus.AssessmentVisible = 1
	AND dbo.QMS_Assessment.AssessmentTargetTypeID = 1
	AND dbo.QMS_Assessment.RecordStatus < 201
	AND dbo.QMS_AssessmentTarget.RecordStatus < 201
	AND dbo.QAS_AssessmentType.Hide = 0
	AND dbo.QMS_Assessment.AssessmentStatusID <> 2 -- Hide shelved assessments
	AND	
	(
		@pAssessmentID IS NULL
		OR dbo.QMS_Assessment.AssessmentID = @pAssessmentID
	);

UPDATE result
SET PrimaryUserGroupID = PrimarySupplier.UserGroupID,
	PrimarySupplierID = PrimarySupplier.SupplierID
FROM @tmpResult result
INNER JOIN 
(
	SELECT
		dbo.QMS_SupplierPermissions.PermissionSourceID AS StockCodeID,
		dbo.QMS_SupplierPermissions.SupplierID,
		dbo.QMS_SupplierPermissions.UserGroupID
	FROM	dbo.QMS_SupplierPermissions 
	WHERE
		dbo.QMS_SupplierPermissions.PermissionType = 1
		AND dbo.QMS_SupplierPermissions.PermissionAllow = 1
) AS PrimarySupplier 
	ON	result.StockCodeID = PrimarySupplier.StockCodeID;

-- If the PrimaryUserGroup is set to a non-deleted user, then that's a valid owner.
UPDATE result
SET PrimaryUserGroup = [user].FullName,
	IsQASOwnerValid = CASE WHEN [user].RecordStatus < 201 THEN 1 ELSE result.IsQASOwnerValid END
FROM @tmpResult result
INNER JOIN QMS_User AS [user]
	ON result.PrimaryUserGroupID = [user].UserID;

UPDATE result
SET PrimarySupplier = PrimarySupplier.SupplierName
FROM @tmpResult result
INNER JOIN dbo.PM_VW_Supplier AS PrimarySupplier
	ON PrimarySupplier.SupplierID = result.PrimarySupplierID;


UPDATE result
SET IsTempSpec = 1,
	PrimarySupplier = assessmentspecheader.Spec_Text + N'*'
FROM @tmpResult result
INNER JOIN	dbo.QMS_AssessmentSpecHeader AS assessmentspecheader
	ON assessmentspecheader.AssessmentID = result.AssessmentID 
INNER JOIN  dbo.QMS_SpecificationHeader AS specheader
	ON specheader.SpecificationHeaderID = assessmentspecheader.SpecificationHeaderID
WHERE
	specheader.Sys_SpecHeader = N'TempSpec_Supplier'
	AND specheader.RecordStatus < 201
	AND assessmentspecheader.RecordStatus < 201;



UPDATE result
SET 	CheckedOutUserID = CurrentCheckOut.UserID,
		CheckedOutBy = CurrentCheckOut.FullName
FROM @tmpResult result
INNER JOIN 
(
	SELECT
		dbo.VW_RecordLock_Current.RowGUID,
		dbo.VW_RecordLock_Current.UserID,
		dbo.QMS_User.FullName
	FROM          dbo.VW_RecordLock_Current 
	INNER JOIN	dbo.QMS_User
		ON dbo.VW_RecordLock_Current.UserID = dbo.QMS_User.UserID
	WHERE	dbo.VW_RecordLock_Current.ObjectName = N'QMS_Assessment'
) AS CurrentCheckOut 
	ON	result.AssessmentGUID = CurrentCheckOut.RowGUID;

UPDATE result
SET PriorAssessmentDisplayText = assessment.AssessmentName  + ' v' + assessment.[Version]
FROM @tmpResult result
INNER JOIN dbo.QMS_Assessment AS assessment
	ON assessment.AssessmentID = ISNULL(result.SourceAssessmentID, result.PreviousAssessmentID);

UPDATE result
SET HasLinkedSites = 1
FROM @tmpResult as result
INNER JOIN PM_VW_StockCodeLocation
	ON PM_VW_StockCodeLocation.StockCodeID = result.StockCodeID
INNER JOIN PM_VW_Location
	ON PM_VW_StockCodeLocation.LocationID = PM_VW_Location.LocationID;

-- NOTE: DateFrom and DateTo are whole dates, and a DateTo of 16th will be valid for entire day of the 16th.
UPDATE result
SET IsQASOwnerValid = 1
FROM @tmpResult as result
INNER JOIN PM_VW_StockCodePack pack
	ON result.StockCodeID = pack.StockCodeID
	AND result.PrimarySupplierID = pack.SupplierID
WHERE
	(
		pack.DateFrom IS NULL
		OR @today >= pack.DateFrom
	)
	AND
	(
		pack.DateTo IS NULL
		OR @today <= pack.DateTo
	);

SET NOCOUNT OFF;

SELECT
	StockCodeID,
	[Description],
	StockCode,
	PrimarySupplier, 
	AssessmentID,
	AssessmentName,
	[Version], 
	CheckedOutUserID,
	CheckedOutBy, 
	AssessmentStatus,
	Active,
	IsTempSpec,
	IsPrimarySupplier,
	HasLinkedSites, 
	StockCodeSubGroup,
	SignOff_Comments,
	PreviousAssessmentID,
	SourceAssessmentID,
	PriorAssessmentDisplayText,
	PrimaryUserGroupID,
	PrimaryUserGroup,
	IsQASOwnerValid
FROM @tmpResult AS result
ORDER BY [Description];

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_User_ResponseList')
	EXEC('CREATE FUNCTION [dbo].[FNC_User_ResponseList]() RETURNS @x TABLE (y bit) AS BEGIN RETURN END')
GO
-- =============================================
-- Author:		Markp
-- Create date: 17/08/2009
-- Description:	Returns list of responses that user can access
-- Version: 	14
-- =============================================
-- JT TFS 4194 - 14/08/2012 - When stock code is restricted, this now returns checks where no stock code is specified in the header.
-- JE TFS 4622 - returns QAFlagID based on ReportQAFlag config setting
-- JT TFS 5801 - performance improvements
-- JE TFS 5905 - updated to make use of Reporting Warehouse table
-- MP TFS 6031 - changed non-admin filter to ensure that temp checks are not included
-- MP TFS 6152 - fix to handle supplier site permissions
-- JT TFS 6689 - FNC_CanUserDataWareHouse takes UserID parameter.
-- JT TFS 7612 - Void checks visibility is controlled by UserSetting for specific reports.
-- JE TFS 13-3570: added PRIMARY KEY to @Table_StockCode to improve performance
-- MP TFS 13-12783: fixed issue with ambiguous Location permission linking
-- jf tfs 16880 - UBE Check view performance for user with 2000+ stock code permissions - added lots of filters for updates like ISNULL(UnfilteredResponse.CustomerID,0) <> ISNULL(PM_VW_StockCode.CustomerID,0)
-- MP TFS 23409 - Added conditions in the CanUseWarehouse block so that Suppliers (userlevel=9) use supplier site code and non supplier (userlevel<>9) use locations
-- SS TFS 13-49452: Added logic so that when a client is using datawarehousing, if they are filtering on today's date, the warehouse is used for all dates up to today's date AND then today's date data
-- is worked out without the warehouse being used. This prevents timeouts FROM happening.
-- =============================================
ALTER FUNCTION [dbo].[FNC_User_ResponseList]
(
	@UserID int,
	@DateFrom datetime,
	@DateTo datetime
)
RETURNS 
@Response TABLE 
(
	ResponseID int,
	ResponseStatus tinyint,
	QAFlagID int
)
AS
BEGIN

--declare @UserID int, @DateFrom datetime,	@DateTo datetime
--select @UserID = 836, @DateFrom = '1 Jun 2013 00:00:00',  @DateTo = '21 May 2014 23:59:59'

	DECLARE @UnfilteredResponse TABLE (
		ResponseID int PRIMARY KEY,
		ResponseStatus tinyint,
		LocationID int NULL,
		CustomerID int NULL,
		SupplierID int NULL,
		StockCodeID int NULL,
		QAFlagID int NULL
	)

	DECLARE @UnfilteredResponseTodaysDate TABLE (
		ResponseID int PRIMARY KEY,
		ResponseStatus tinyint,
		LocationID int NULL,
		CustomerID int NULL,
		SupplierID int NULL,
		StockCodeID int NULL,
		QAFlagID int NULL
	)

	--get date reporting warehouse table last built
	DECLARE @WarehouseBuildDate datetime
	SET @WarehouseBuildDate = (SELECT Updated FROM APP_Config WHERE OptionID = 78)

	DECLARE @UserSettingDisplayVoids bit 
	SET @UserSettingDisplayVoids = ISNULL(cast(dbo.FNC_GetUserSetting(@UserID, 'DisplayVoidChecks') as bit), 0)

	-- Lookup user level
	DECLARE @UserLevel int, @RecordStatus tinyint
	SELECT     @UserLevel = ISNULL(UserLevel,0)
	FROM         QMS_User
	WHERE     (UserID = @UserID)
	IF @UserSettingDisplayVoids = 1 -- Include all recordstatuses when we set a report to do the same by setting the User Setting.
		SET @RecordStatus = 255 -- maximum possible. 
	ELSE IF @UserLevel = 1  --Admin can always see hidden/void checks.
		SET @RecordStatus = 201
	ELSE
		SET @RecordStatus = 100

	-- Permissions that this user has.
	DECLARE @PermissionLink TABLE (
		UserID int, SupplierID int, CustomerID int, LocationID int, StockCodeID int, 
		StockCodeSubGroup nvarchar(100), BusinessGroup nvarchar(100)
	)
	INSERT INTO	@PermissionLink (UserID, SupplierID, CustomerID, LocationID, StockCodeID, StockCodeSubGroup, BusinessGroup)
	SELECT	UserID, SupplierID, CustomerID, LocationID, StockCodeID, StockCodeSubGroup, BusinessGroup
	FROM	VW_PermissionLink PermissionLink
	WHERE	PermissionLink.PermissionAllow = 1 AND PermissionLink.PermissionType IN (101,102,103,104,105,106) AND UserID = @UserID

	DECLARE @Table_StockCode TABLE (
		StockCodeID int PRIMARY KEY
	)
	
	--check for permissions in three levels of hierarchy: Business Group, Sub Group, Stock Code, and translate to StockCodeID
	INSERT INTO @Table_StockCode (StockCodeID)
	SELECT		StockCodeID
	FROM        PM_VW_StockCode
	WHERE		BusinessGroup IN (SELECT BusinessGroup FROM @PermissionLink WHERE BusinessGroup IS NOT NULL)
	
	INSERT INTO @Table_StockCode (StockCodeID)
	SELECT		StockCodeID
	FROM        PM_VW_StockCode
	WHERE		StockCodeSubGroup IN (SELECT StockCodeSubGroup FROM @PermissionLink WHERE StockCodeSubGroup IS NOT NULL)
	
	INSERT INTO @Table_StockCode (StockCodeID)
	SELECT		StockCodeID
	FROM        PM_VW_StockCode
	WHERE		StockCodeID IN (SELECT StockCodeID FROM @PermissionLink WHERE StockCodeID IS NOT NULL)

	BEGIN
	IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1 AND @DateTo <= @WarehouseBuildDate
		BEGIN
			INSERT INTO	@UnfilteredResponse (ResponseID, ResponseStatus, QAFlagID)
			SELECT		RPT_Warehouse_Response.ResponseID, QMS_Response.ResponseStatus, RPT_Warehouse_Response.QAFlagID --Actual or Override QAFlag setting checked when building warehouse table
			FROM		RPT_Warehouse_Response INNER JOIN
							QMS_Response ON RPT_Warehouse_Response.ResponseID = QMS_Response.ResponseID
			WHERE		(QMS_Response.RecordStatus < @RecordStatus) AND (RPT_Warehouse_Response.EndDate BETWEEN @DateFrom AND @DateTo)
				
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel = 9)
				UPDATE	UnfilteredResponse
				SET	LocationID = RPT_Warehouse_Response.SupplierSiteID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
				WHERE ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(RPT_Warehouse_Response.SupplierSiteID,0)
 
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel <> 9)
				UPDATE	UnfilteredResponse
				SET	LocationID = RPT_Warehouse_Response.LocationID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
				WHERE ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(RPT_Warehouse_Response.LocationID,0)

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
				UPDATE	UnfilteredResponse
				SET		SupplierID = RPT_Warehouse_Response.SupplierID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
				WHERE ISNULL(UnfilteredResponse.SupplierID,0) <> ISNULL(RPT_Warehouse_Response.SupplierID,0)
				
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE CustomerID IS NOT NULL) 
				UPDATE	UnfilteredResponse
				SET		CustomerID = PM_VW_StockCode.CustomerID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID INNER JOIN
							PM_VW_StockCode ON RPT_Warehouse_Response.StockCodeID = PM_VW_StockCode.StockCodeID
				WHERE ISNULL(UnfilteredResponse.CustomerID,0) <> ISNULL(PM_VW_StockCode.CustomerID,0)

			IF EXISTS (SELECT StockCodeID FROM @Table_StockCode)
				UPDATE	UnfilteredResponse
				SET		StockCodeID = RPT_Warehouse_Response.StockCodeID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
			END
			
	--Logic for inserting today's date data into @UnfilteredResponse so that the datawarehouse can still be used when the user filters on today's date
	ELSE IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
		BEGIN
			DECLARE @override bit 
			SET @override = CAST(ISNULL(dbo.FNC_GetOptionValue(74),0) AS bit)
			
			INSERT INTO @UnfilteredResponseTodaysDate (ResponseID, ResponseStatus, QAFlagID) 
			SELECT ResponseID, ResponseStatus,
					--check config value to use Actual or Override QAFlagID
					CASE WHEN @override = 0 THEN Actual_QAFlagID ELSE ISNULL(Override_QAFlagID, Actual_QAFlagID) END AS QAFlagID
			FROM	QMS_Response
			WHERE	(RecordStatus < @RecordStatus) 
			AND (Uploaded BETWEEN @WarehouseBuildDate AND @DateTo)

	--Logic for getting incomplete checks before today's date
			INSERT INTO @UnfilteredResponseTodaysDate (ResponseID, ResponseStatus, QAFlagID) 
			SELECT ResponseID, ResponseStatus,
					--check config value to use Actual or Override QAFlagID
					CASE WHEN @override = 0 THEN Actual_QAFlagID ELSE ISNULL(Override_QAFlagID, Actual_QAFlagID) END AS QAFlagID
			FROM	QMS_Response
			WHERE	(RecordStatus < @RecordStatus) 
			AND (EndDate BETWEEN @DateFrom AND @DateTo)
			AND ResponseStatus = 0
			AND ResponseID  NOT IN (SELECT UnfilteredResponseTodaysDate.ResponseID FROM @UnfilteredResponseTodaysDate UnfilteredResponseTodaysDate
							WHERE UnfilteredResponseTodaysDate.ResponseID = UnfilteredResponseTodaysDate.ResponseID) 

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel = 9)
				UPDATE	UnfilteredResponseTodaysDate
				SET		LocationID = Location.LocationID
				FROM	@UnfilteredResponseTodaysDate UnfilteredResponseTodaysDate INNER JOIN
							QMS_ResponseHeader ON UnfilteredResponseTodaysDate.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
							QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
							PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
				WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 53) and
				ISNULL(UnfilteredResponseTodaysDate.LocationID,0) <> ISNULL(Location.LocationID,0)

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel <> 9)
				UPDATE	UnfilteredResponseTodaysDate
				SET		LocationID = Location.LocationID
				FROM	@UnfilteredResponseTodaysDate UnfilteredResponseTodaysDate INNER JOIN
							QMS_ResponseHeader ON UnfilteredResponseTodaysDate.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
							QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
							PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
				WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 4) and 
				ISNULL(UnfilteredResponseTodaysDate.LocationID,0) <> ISNULL(Location.LocationID,0)

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
				UPDATE	UnfilteredResponseTodaysDate
				SET		SupplierID = QMS_ResponseHeader.Header_SourceID
				FROM	@UnfilteredResponseTodaysDate UnfilteredResponseTodaysDate INNER JOIN
							QMS_ResponseHeader ON UnfilteredResponseTodaysDate.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
							QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
				WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 1) AND
				ISNULL(UnfilteredResponseTodaysDate.SupplierID,0) <> ISNULL(QMS_ResponseHeader.Header_SourceID,0)
				
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE CustomerID IS NOT NULL) 
				UPDATE	UnfilteredResponseTodaysDate
				SET		CustomerID = PM_VW_StockCode.CustomerID
				FROM	@UnfilteredResponseTodaysDate UnfilteredResponseTodaysDate INNER JOIN
							dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponseTodaysDate.ResponseID = HeaderStockCode.ResponseID INNER JOIN
							PM_VW_StockCode ON PM_VW_StockCode.StockCodeID = HeaderStockCode.StockCodeID
				WHERE ISNULL(UnfilteredResponseTodaysDate.CustomerID,0) <> ISNULL(PM_VW_StockCode.CustomerID,0)

			IF EXISTS (SELECT StockCodeID FROM @Table_StockCode)
				UPDATE	UnfilteredResponseTodaysDate
				SET		StockCodeID = HeaderStockCode.StockCodeID
				FROM	@UnfilteredResponseTodaysDate UnfilteredResponseTodaysDate INNER JOIN
							dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponseTodaysDate.ResponseID = HeaderStockCode.ResponseID
				WHERE ISNULL(UnfilteredResponseTodaysDate.StockCodeID,0) <> ISNULL(HeaderStockCode.StockCodeID,0)

			INSERT INTO	@UnfilteredResponse (ResponseID, ResponseStatus, QAFlagID)
			SELECT		RPT_Warehouse_Response.ResponseID, QMS_Response.ResponseStatus, RPT_Warehouse_Response.QAFlagID --Actual or Override QAFlag setting checked when building warehouse table
			FROM		RPT_Warehouse_Response 
			INNER JOIN  QMS_Response ON RPT_Warehouse_Response.ResponseID = QMS_Response.ResponseID
			WHERE		(QMS_Response.RecordStatus < @RecordStatus) 
			AND (RPT_Warehouse_Response.EndDate BETWEEN @DateFrom AND @WarehouseBuildDate)
			AND NOT EXISTS (SELECT UnfilteredResponseTodaysDate.ResponseID FROM @UnfilteredResponseTodaysDate UnfilteredResponseTodaysDate
							WHERE UnfilteredResponseTodaysDate.ResponseID = RPT_Warehouse_Response.ResponseID)
				
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel = 9)
				UPDATE	UnfilteredResponse
				SET	LocationID = RPT_Warehouse_Response.SupplierSiteID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
				WHERE ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(RPT_Warehouse_Response.SupplierSiteID,0)
 
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel <> 9)
				UPDATE	UnfilteredResponse
				SET	LocationID = RPT_Warehouse_Response.LocationID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
				WHERE ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(RPT_Warehouse_Response.LocationID,0)

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
				UPDATE	UnfilteredResponse
				SET		SupplierID = RPT_Warehouse_Response.SupplierID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
				WHERE ISNULL(UnfilteredResponse.SupplierID,0) <> ISNULL(RPT_Warehouse_Response.SupplierID,0)
				
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE CustomerID IS NOT NULL) 
				UPDATE	UnfilteredResponse
				SET		CustomerID = PM_VW_StockCode.CustomerID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID INNER JOIN
							PM_VW_StockCode ON RPT_Warehouse_Response.StockCodeID = PM_VW_StockCode.StockCodeID
				WHERE ISNULL(UnfilteredResponse.CustomerID,0) <> ISNULL(PM_VW_StockCode.CustomerID,0)

			IF EXISTS (SELECT StockCodeID FROM @Table_StockCode)
				UPDATE	UnfilteredResponse
				SET		StockCodeID = RPT_Warehouse_Response.StockCodeID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID

			INSERT INTO @UnfilteredResponse(ResponseID, ResponseStatus, LocationID, CustomerID, SupplierID, StockCodeID, QAFlagID)
			SELECT ResponseID, ResponseStatus, LocationID, CustomerID, SupplierID, StockCodeID, QAFlagID FROM @UnfilteredResponseTodaysDate
		END
	ELSE --don't use warehouse table
		BEGIN
			DECLARE @OverrideOption bit 
			SET @OverrideOption = CAST(ISNULL(dbo.FNC_GetOptionValue(74),0) AS bit)
			
			INSERT INTO @UnfilteredResponse (ResponseID, ResponseStatus, QAFlagID)
			SELECT ResponseID, ResponseStatus,
					--check config value to use Actual or Override QAFlagID
					CASE WHEN @OverrideOption = 0 THEN Actual_QAFlagID ELSE ISNULL(Override_QAFlagID, Actual_QAFlagID) END AS QAFlagID
			FROM	QMS_Response
			WHERE	(RecordStatus < @RecordStatus) AND (EndDate BETWEEN @DateFrom AND @DateTo)
			
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel = 9)
				UPDATE	UnfilteredResponse
				SET		LocationID = Location.LocationID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							QMS_ResponseHeader ON UnfilteredResponse.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
							QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
							PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
				WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 53) and
				ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(Location.LocationID,0)

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel <> 9)
				UPDATE	UnfilteredResponse
				SET		LocationID = Location.LocationID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							QMS_ResponseHeader ON UnfilteredResponse.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
							QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
							PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
				WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 4) and 
				ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(Location.LocationID,0)

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
				UPDATE	UnfilteredResponse
				SET		SupplierID = QMS_ResponseHeader.Header_SourceID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							QMS_ResponseHeader ON UnfilteredResponse.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
							QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
				WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 1) AND
				ISNULL(UnfilteredResponse.SupplierID,0) <> ISNULL(QMS_ResponseHeader.Header_SourceID,0)
				
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE CustomerID IS NOT NULL) 
				UPDATE	UnfilteredResponse
				SET		CustomerID = PM_VW_StockCode.CustomerID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponse.ResponseID = HeaderStockCode.ResponseID INNER JOIN
							PM_VW_StockCode ON PM_VW_StockCode.StockCodeID = HeaderStockCode.StockCodeID
				WHERE ISNULL(UnfilteredResponse.CustomerID,0) <> ISNULL(PM_VW_StockCode.CustomerID,0)

			IF EXISTS (SELECT StockCodeID FROM @Table_StockCode)
				UPDATE	UnfilteredResponse
				SET		StockCodeID = HeaderStockCode.StockCodeID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponse.ResponseID = HeaderStockCode.ResponseID
				WHERE ISNULL(UnfilteredResponse.StockCodeID,0) <> ISNULL(HeaderStockCode.StockCodeID,0)
		END
	END

	-- Only return responses which match the filter specified, or for which we do not have a filter.
	-- This means that admin users (any user with no permissions set) can see all responses.
	INSERT INTO @Response (ResponseID, ResponseStatus, QAFlagID)
	SELECT	ResponseID, ResponseStatus, QAFlagID
	FROM	@UnfilteredResponse UnfilteredResponse
	WHERE (	NOT EXISTS (SELECT LocationID FROM @PermissionLink WHERE LocationID IS NOT NULL)
		OR	LocationID IN (SELECT LocationID FROM @PermissionLink WHERE LocationID IS NOT NULL) )
	AND (	NOT EXISTS (SELECT SupplierID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
		OR	SupplierID IN (SELECT SupplierID FROM @PermissionLink WHERE SupplierID IS NOT NULL) )
	AND (	NOT EXISTS (SELECT CustomerID FROM @PermissionLink WHERE CustomerID IS NOT NULL)
		OR	CustomerID IN (SELECT CustomerID FROM @PermissionLink WHERE CustomerID IS NOT NULL) )
	AND (	StockCodeID IS NULL -- Allow unlinked stockcode responses
		OR	NOT EXISTS (SELECT StockCodeID FROM @Table_StockCode)
		OR	StockCodeID IN (SELECT StockCodeID FROM @Table_StockCode) )
	
	RETURN
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_Response_ResponseQuestion')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_Response_ResponseQuestion] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 11/09/2008
-- Description:	Gets all question responses for response report
-- Version:		11
-- =============================================
-- MarkP: TFS bug 4233
-- Jeremyf: TFS 5058
-- JE TFS 5458/5459: added ListSamplesOnReport option col and SampleSummary col
-- JT TFS 4929: added ResponseQuestionID to output so that sub-report for images can be linked to it
-- JT TFS 6580 - Use new multi-sort function (for performance)
-- JT TFS 7010 - Show section headers when suppress blanks is true.
-- JT TFS 7920 - DataTypeID null or zero means header.
-- JE TFS 8717 - amended filter to show archived questions if they have a response against them
-- JT TFS 13-33004: 14/06/2016 - Treat empty strings as Blanks, rather than just NULL entries.
-- =============================================
ALTER PROCEDURE RPT_Response_ResponseQuestion
	@UserID int,
	@ShowCA bit = 0,
	@ShowGuidance bit = 0
AS

DECLARE @SupressBlanks bit
SET @SupressBlanks = ISNULL(CAST(dbo.FNC_GetOptionValue(36) AS bit),0)

IF NULLIF(object_id('tempdb..#tmpAllAssesmentQuestions'), 0) IS NOT NULL DROP TABLE #tmpAllAssesmentQuestions
SELECT question.AssessmentID, sort.AssessmentQuestionID, sort.SortIndex, sort.QuestionNumber
INTO #tmpAllAssesmentQuestions
FROM dbo.FNC_AssessmentQuestion_Sort_Multi(@UserID) sort -- This is the most expensive bit of code.
INNER JOIN QMS_AssessmentQuestion question ON sort.AssessmentQuestionID = question.AssessmentQuestionID 

IF NULLIF(object_id('tempdb..#tmpShownAssessmentQuestions'), 0) IS NOT NULL DROP TABLE #tmpShownAssessmentQuestions
SELECT QMS_ResponseQuestion.ResponseID, assessment_questions.AssessmentQuestionID 
INTO #tmpShownAssessmentQuestions
FROM #tmpAllAssesmentQuestions assessment_questions
INNER JOIN QMS_ResponseQuestion ON QMS_ResponseQuestion.AssessmentQuestionID = assessment_questions.AssessmentQuestionID
INNER JOIN TEMP_Selected ON QMS_ResponseQuestion.ResponseID = TEMP_Selected.SelectedID AND TEMP_Selected.UserID = @UserID
WHERE (
			(@SupressBlanks = 1 AND NULLIF(QMS_ResponseQuestion.Response_Text, '') IS NOT NULL)
	OR
			(@SupressBlanks = 0) 
)

-- Add headers for shown items if suppressing blanks.
IF (@SupressBlanks = 1)
	INSERT #tmpShownAssessmentQuestions (ResponseID, AssessmentQuestionID)
	SELECT DISTINCT shown.ResponseID, question_children.AssessmentQuestionID
	FROM (	SELECT	questions.AssessmentQuestionID, 
					(	SELECT '|' + convert(varchar(10), AssessmentQuestionID) 
						FROM #tmpAllAssesmentQuestions 
						WHERE QuestionNumber LIKE questions.QuestionNumber + '.%' 
						AND AssessmentID = questions.AssessmentID FOR XML PATH('')) + '|' Children
			FROM #tmpAllAssesmentQuestions questions) as question_children
	INNER JOIN #tmpShownAssessmentQuestions as shown ON question_children.Children like '%|' + convert(varchar(10), shown.AssessmentQuestionID) + '|%' 
	WHERE NOT EXISTS (SELECT * FROM #tmpShownAssessmentQuestions WHERE ResponseID = shown.ResponseID AND AssessmentQuestionID = question_children.AssessmentQuestionID)


SELECT     QMS_ResponseQuestion.ResponseID, AssessmentQuestion_Sort.QuestionNumber, QMS_QuestionPool.Question, APP_QuestionLevel.QuestionLevel, 
                      APP_QuestionLevel.ListIndex AS QuestionLevelSort, QMS_QuestionPool.Sys_Question, QMS_ResponseQuestion.Response_Text, 
                      QMS_ResponseQuestion.Response_Boolean, QMS_ResponseQuestion.Response_Date, QMS_ResponseQuestion.Response_Numeric, 
                      QMS_ResponseQuestion.Response_SourceID, ROUND(QMS_ResponseQuestion.Score, 1) AS Score, QMS_ResponseQuestion.Recommended_QAFlagID, 
                      QMS_ResponseQuestion.QuestionComments, CASE WHEN QMS_AssessmentQuestion.ResponseIsScore = 1 THEN ISNULL(QMS_ResponseQuestion.Score, 0) 
                      ELSE 0 END AS ResponseScore, @ShowCA AS ShowCA, CAST(CASE WHEN CorrectiveAction.ResponseQuestionID IS NULL THEN 0 ELSE 1 END AS bit) AS HasCA, 
                      CorrectiveAction.CorrectiveActionID, CorrectiveAction.CATitle, CorrectiveAction.CAReason, CorrectiveAction.CARequired, CorrectiveAction.CAStatus, 
                      CorrectiveAction.NotificationGroup, CorrectiveAction.PriorityLevel, CorrectiveAction.DateDeadline, @ShowGuidance AS ShowGuidance, 
                      CAST(CASE WHEN QMS_Guidance.GuidanceString IS NULL THEN CASE WHEN QMS_AssessmentQuestion.ShortGuidance IS NULL 
                      THEN 0 ELSE 1 END ELSE 1 END AS bit) AS HasGuidance, QMS_Guidance.GuidanceString, QMS_AssessmentQuestion.ShortGuidance, 
                      RedConstraints.Constraint_Score_Min AS LevelScoreMinRed, RedConstraints.Constraint_Score_Max AS LevelScoreMaxRed, 
                      RedConstraints.GuidanceString AS LevelGuidance, CAST(CASE WHEN RedConstraints.GuidanceString IS NULL THEN 0 ELSE 1 END AS bit) AS HasLevelGuidance, 
                      ISNULL(dbo.FNC_GetOptionValue(15), N'0') AS HideQAScore, QMS_AssessmentQuestion.ScoreCalculationID, 
                      AmberConstraints.Constraint_Score_Min AS LevelScoreMinAmber, AmberConstraints.Constraint_Score_Max AS LevelScoreMaxAmber, 
                      QMS_AssessmentQuestion.HasSamples, QMS_AssessmentQuestion.SampleSummaryID, SampleSummary.MinSample, SampleSummary.MaxSample, 
                      SampleSummary.AvgSample, SampleSummary.NumSample, SampleSummary.SumSample, SampleSummary.SampleList, 
                      QMS_QuestionPool_Parent.Question AS ParentQuestion, APP_QAFlag.QAFlagBackColour, APP_QAFlag.QAFlagForeColour,
                      QMS_AssessmentQuestion.ListSamplesOnReport AS ShowSamples, APP_SampleSummary.SampleSummary,
		QMS_ResponseQuestion.ResponseQuestionID,
		IsSectionHeaderRow = convert(bit, CASE WHEN NULLIF(QMS_AssessmentQuestion.DataTypeID, 0) IS NULL THEN 1 ELSE 0 END)
FROM         (SELECT     QMS_CorrectiveAction.SourceObjectID AS ResponseQuestionID, QMS_CorrectiveAction.CorrectiveActionID, QMS_CorrectiveAction.CATitle, 
                                              QMS_CorrectiveAction.CAReason, QMS_CorrectiveAction.CARequired, ISNULL(dbo.FNC_ResourceString_User(APP_CorrectiveActionStatus.ResourceName, 
            @UserID), APP_CorrectiveActionStatus.CAStatus) AS CAStatus, QMS_NotificationGroup.NotificationGroup, APP_PriorityLevel.PriorityLevel, 
                 QMS_CorrectiveAction.DateDeadline
         FROM          QMS_CorrectiveAction INNER JOIN
                                              APP_CorrectiveActionStatus ON QMS_CorrectiveAction.CAStatusID = APP_CorrectiveActionStatus.CAStatusID LEFT OUTER JOIN
                                              APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID LEFT OUTER JOIN
                                              QMS_NotificationGroup ON QMS_CorrectiveAction.NotificationGroupID = QMS_NotificationGroup.NotificationGroupID
                       WHERE      (QMS_CorrectiveAction.CASourceID = 2) AND (QMS_CorrectiveAction.RecordStatus < 201)) AS CorrectiveAction RIGHT OUTER JOIN
                      dbo.FNC_ResponseQuestion_SampleSummary(@UserID) AS SampleSummary RIGHT OUTER JOIN
                      QMS_ResponseQuestion INNER JOIN
                      QMS_AssessmentQuestion ON QMS_ResponseQuestion.AssessmentQuestionID = QMS_AssessmentQuestion.AssessmentQuestionID INNER JOIN
                      TEMP_Selected ON QMS_ResponseQuestion.ResponseID = TEMP_Selected.SelectedID INNER JOIN
                      #tmpAllAssesmentQuestions AS AssessmentQuestion_Sort ON 
                      QMS_AssessmentQuestion.AssessmentQuestionID = AssessmentQuestion_Sort.AssessmentQuestionID INNER JOIN
                      QMS_QuestionPool ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID LEFT OUTER JOIN
                      APP_QAFlag ON QMS_ResponseQuestion.Recommended_QAFlagID = APP_QAFlag.QAFlagID ON 
                      SampleSummary.ResponseQuestionID = QMS_ResponseQuestion.ResponseQuestionID LEFT OUTER JOIN
                      QMS_AssessmentQuestion AS QMS_AssessmentQuestion_Parent ON 
                      QMS_AssessmentQuestion.ParentQuestionID = QMS_AssessmentQuestion_Parent.AssessmentQuestionID LEFT OUTER JOIN
                          (SELECT     QMS_AssessmentConstraint_1.AssessmentID, APP_AssessmentConstraintType_1.QuestionLevelID, 
                                                   MIN(QMS_AssessmentConstraint_1.Constraint_Score_Min) AS Constraint_Score_Min, MAX(QMS_AssessmentConstraint_1.Constraint_Score_Max) 
                                                   AS Constraint_Score_Max
                            FROM          APP_AssessmentConstraintType AS APP_AssessmentConstraintType_1 INNER JOIN
                                                   QMS_AssessmentConstraint AS QMS_AssessmentConstraint_1 ON 
                                                   APP_AssessmentConstraintType_1.AssessmentConstraintTypeID = QMS_AssessmentConstraint_1.AssessmentConstraintTypeID
                            WHERE      (QMS_AssessmentConstraint_1.RecordStatus < 201) AND (QMS_AssessmentConstraint_1.QAFlagID = 2)
                            GROUP BY APP_AssessmentConstraintType_1.QuestionLevelID, QMS_AssessmentConstraint_1.AssessmentID) AS AmberConstraints ON 
                      QMS_AssessmentQuestion.AssessmentID = AmberConstraints.AssessmentID AND 
                      QMS_AssessmentQuestion.QuestionLevelID = AmberConstraints.QuestionLevelID LEFT OUTER JOIN
                      APP_QuestionLevel ON QMS_AssessmentQuestion.QuestionLevelID = APP_QuestionLevel.QuestionLevelID LEFT OUTER JOIN
                          (SELECT     QMS_AssessmentConstraint.AssessmentID, APP_QuestionLevel_1.QuestionLevelID, APP_QuestionLevel_1.QuestionLevel, 
                                                   APP_QuestionLevel_1.ListIndex, MIN(QMS_AssessmentConstraint.Constraint_Score_Min) AS Constraint_Score_Min, 
                                                   MAX(QMS_AssessmentConstraint.Constraint_Score_Max) AS Constraint_Score_Max, QMS_Guidance_1.GuidanceString
  FROM          APP_QuestionLevel AS APP_QuestionLevel_1 INNER JOIN
                                                   APP_AssessmentConstraintType ON APP_QuestionLevel_1.QuestionLevelID = APP_AssessmentConstraintType.QuestionLevelID INNER JOIN
                                                   QMS_AssessmentConstraint ON 
                  APP_AssessmentConstraintType.AssessmentConstraintTypeID = QMS_AssessmentConstraint.AssessmentConstraintTypeID LEFT OUTER JOIN
                                                   QMS_Guidance AS QMS_Guidance_1 ON QMS_AssessmentConstraint.GuidanceID = QMS_Guidance_1.GuidanceID
                            WHERE      (QMS_AssessmentConstraint.RecordStatus < 201) AND (QMS_AssessmentConstraint.QAFlagID = 3)
                            GROUP BY APP_QuestionLevel_1.QuestionLevelID, APP_QuestionLevel_1.QuestionLevel, APP_QuestionLevel_1.ListIndex, 
                                                   QMS_AssessmentConstraint.AssessmentID, QMS_Guidance_1.GuidanceString) AS RedConstraints ON 
                      QMS_AssessmentQuestion.QuestionLevelID = RedConstraints.QuestionLevelID AND 
                      QMS_AssessmentQuestion.AssessmentID = RedConstraints.AssessmentID LEFT OUTER JOIN
                      QMS_Guidance ON QMS_AssessmentQuestion.GuidanceID = QMS_Guidance.GuidanceID ON 
                      CorrectiveAction.ResponseQuestionID = QMS_ResponseQuestion.ResponseQuestionID LEFT OUTER JOIN
                      QMS_QuestionPool AS QMS_QuestionPool_Parent ON QMS_AssessmentQuestion_Parent.QuestionID = QMS_QuestionPool_Parent.QuestionID LEFT OUTER JOIN
                      APP_SampleSummary ON QMS_AssessmentQuestion.SampleSummaryID = APP_SampleSummary.SampleSummaryID
WHERE	(TEMP_Selected.UserID = @UserID) 
AND		(QMS_ResponseQuestion.RecordStatus < 201)
AND		((QMS_AssessmentQuestion.RecordStatus = 202 AND QMS_ResponseQuestion.Response_Text IS NOT NULL) --show archived questions if they have a Response against them
			OR
		 (QMS_AssessmentQuestion.RecordStatus < 201))
AND		(QMS_AssessmentQuestion.HideFromReports = 0)
AND		EXISTS (SELECT * FROM #tmpShownAssessmentQuestions WHERE ResponseID = QMS_ResponseQuestion.ResponseID AND AssessmentQuestionID = QMS_AssessmentQuestion.AssessmentQuestionID)
ORDER BY QMS_ResponseQuestion.ResponseID, AssessmentQuestion_Sort.SortIndex
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_AssessmentType_Flag_HasBeenUsed')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_AssessmentType_Flag_HasBeenUsed] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: MBS\Phil.Harding
-- Create date	: 14/06/2016
-- Description	: Sets HasBeenUsed flag on all assessment types that have been used.  This should be used when the HasBeenUsed column is added to APP_AssessmentType. 
-- Version		: 3
-- =============================================
-- PH TFS 13-49601 : v1 14/06/2016 - Created
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_AssessmentType_Flag_HasBeenUsed]
AS
BEGIN
	
	DECLARE @assessmentTypeStatus TABLE (
		AssessmentTypeID int,
		HasBeenUsed bit
	)

	--Initialise status table to none being active
	INSERT INTO @assessmentTypeStatus
	(
		AssessmentTypeID,
		HasBeenUsed
	)
	SELECT AssessmentTypeID, 0 AS HasBeenUsed
	FROM APP_AssessmentType;

	--Update table for used assessment types
	UPDATE @assessmentTypeStatus
	SET
		HasBeenUsed = 1
	FROM
	(
		SELECT APP_AssessmentType.AssessmentTypeID
		FROM APP_AssessmentType
		INNER JOIN QMS_Response
			ON QMS_Response.AssessmentTypeID = APP_AssessmentType.AssessmentTypeID
		GROUP BY APP_AssessmentType.AssessmentTypeID
	) AS used
	WHERE [@assessmentTypeStatus].AssessmentTypeID = used.AssessmentTypeID

	--Update APP_AssessmentType where flag has changed.
	UPDATE APP_AssessmentType
	SET
		HasBeenUsed = ats.HasBeenUsed
	FROM @assessmentTypeStatus AS ats
	WHERE ats.HasBeenUsed <> APP_AssessmentType.HasBeenUsed;

END

UPDATE APP_AssessmentType SET HasBeenUsed = 0;

UPDATE APP_AssessmentType
	SET
		HasBeenUsed = 1
	FROM
	(
		SELECT APP_AssessmentType.AssessmentTypeID
		FROM APP_AssessmentType
		INNER JOIN QMS_Response
			ON QMS_Response.AssessmentTypeID = APP_AssessmentType.AssessmentTypeID
		GROUP BY APP_AssessmentType.AssessmentTypeID
	) AS used
	WHERE APP_AssessmentType.AssessmentTypeID = used.AssessmentTypeID
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_AssessmentType_Flag_IsWebChecksEnabled')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_AssessmentType_Flag_IsWebChecksEnabled] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		: MBS\Phil.Harding
-- Create date	: 14/06/2016
-- Description	: Sets IsWebChecksEnabled flag on all assessment types that are WebChecks Enabled.  This should be used when the IsWebChecksEnabled column is added to APP_AssessmentType. This superceeds to use of FNC_AssessmentType_IsWebCheck to calculate on the fly.
-- Version		: 1
-- =============================================
-- PH TFS 13-49646 : v1 14/06/2016 - Created
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_AssessmentType_Flag_IsWebChecksEnabled]
AS
BEGIN
	
	DECLARE @assessmentTypeStatus TABLE (
		AssessmentTypeID int,
		IsWebChecksEnabled bit
	)

	--Initialise status table
	INSERT INTO @assessmentTypeStatus
	(
		AssessmentTypeID,
		IsWebChecksEnabled
	)
	SELECT AssessmentTypeID, [dbo].[FNC_AssessmentType_IsWebCheck](AssessmentTypeID) AS IsWebChecksEnabled
	FROM APP_AssessmentType;

	--Update APP_AssessmentType where flag has changed.
	UPDATE APP_AssessmentType
	SET
		IsWebChecksEnabled = ats.IsWebChecksEnabled
	FROM @assessmentTypeStatus AS ats
	WHERE ats.IsWebChecksEnabled <> APP_AssessmentType.IsWebChecksEnabled;

END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_User_ResponseList')
	EXEC('CREATE FUNCTION [dbo].[FNC_User_ResponseList]() RETURNS @x TABLE (y bit) AS BEGIN RETURN END')
GO
-- =============================================
-- Author:		Markp
-- Create date: 17/08/2009
-- Description:	Returns list of responses that user can access
-- Version: 	15
-- =============================================
-- JT TFS 4194 - 14/08/2012 - When stock code is restricted, this now returns checks where no stock code is specified in the header.
-- JE TFS 4622 - returns QAFlagID based on ReportQAFlag config setting
-- JT TFS 5801 - performance improvements
-- JE TFS 5905 - updated to make use of Reporting Warehouse table
-- MP TFS 6031 - changed non-admin filter to ensure that temp checks are not included
-- MP TFS 6152 - fix to handle supplier site permissions
-- JT TFS 6689 - FNC_CanUserDataWareHouse takes UserID parameter.
-- JT TFS 7612 - Void checks visibility is controlled by UserSetting for specific reports.
-- JE TFS 13-3570: added PRIMARY KEY to @Table_StockCode to improve performance
-- MP TFS 13-12783: fixed issue with ambiguous Location permission linking
-- jf tfs 16880 - UBE Check view performance for user with 2000+ stock code permissions - added lots of filters for updates like ISNULL(UnfilteredResponse.CustomerID,0) <> ISNULL(PM_VW_StockCode.CustomerID,0)
-- MP TFS 23409 - Added conditions in the CanUseWarehouse block so that Suppliers (userlevel=9) use supplier site code and non supplier (userlevel<>9) use locations
-- SS TFS 13-49452: Added logic so that when a client is using datawarehousing, if they are filtering on today's date, the warehouse is used for all dates up to today's date AND then today's date data
-- is worked out without the warehouse being used. This prevents timeouts FROM happening.
-- SS TFS 13-49897: Added ISNULL(Uploaded, EndDate) so that EndDate will be used if Uploaded contains a NULL Value
-- =============================================
ALTER FUNCTION [dbo].[FNC_User_ResponseList]
(
	@UserID int,
	@DateFrom datetime,
	@DateTo datetime
)
RETURNS 
@Response TABLE 
(
	ResponseID int,
	ResponseStatus tinyint,
	QAFlagID int
)
AS
BEGIN

--declare @UserID int, @DateFrom datetime,	@DateTo datetime
--select @UserID = 836, @DateFrom = '1 Jun 2013 00:00:00',  @DateTo = '21 May 2014 23:59:59'

	DECLARE @UnfilteredResponse TABLE (
		ResponseID int PRIMARY KEY,
		ResponseStatus tinyint,
		LocationID int NULL,
		CustomerID int NULL,
		SupplierID int NULL,
		StockCodeID int NULL,
		QAFlagID int NULL
	)

	DECLARE @UnfilteredResponseTodaysDate TABLE (
		ResponseID int PRIMARY KEY,
		ResponseStatus tinyint,
		LocationID int NULL,
		CustomerID int NULL,
		SupplierID int NULL,
		StockCodeID int NULL,
		QAFlagID int NULL
	)

	--get date reporting warehouse table last built
	DECLARE @WarehouseBuildDate datetime
	SET @WarehouseBuildDate = (SELECT Updated FROM APP_Config WHERE OptionID = 78)

	DECLARE @UserSettingDisplayVoids bit 
	SET @UserSettingDisplayVoids = ISNULL(cast(dbo.FNC_GetUserSetting(@UserID, 'DisplayVoidChecks') as bit), 0)

	-- Lookup user level
	DECLARE @UserLevel int, @RecordStatus tinyint
	SELECT     @UserLevel = ISNULL(UserLevel,0)
	FROM         QMS_User
	WHERE     (UserID = @UserID)
	IF @UserSettingDisplayVoids = 1 -- Include all recordstatuses when we set a report to do the same by setting the User Setting.
		SET @RecordStatus = 255 -- maximum possible. 
	ELSE IF @UserLevel = 1  --Admin can always see hidden/void checks.
		SET @RecordStatus = 201
	ELSE
		SET @RecordStatus = 100

	-- Permissions that this user has.
	DECLARE @PermissionLink TABLE (
		UserID int, SupplierID int, CustomerID int, LocationID int, StockCodeID int, 
		StockCodeSubGroup nvarchar(100), BusinessGroup nvarchar(100)
	)
	INSERT INTO	@PermissionLink (UserID, SupplierID, CustomerID, LocationID, StockCodeID, StockCodeSubGroup, BusinessGroup)
	SELECT	UserID, SupplierID, CustomerID, LocationID, StockCodeID, StockCodeSubGroup, BusinessGroup
	FROM	VW_PermissionLink PermissionLink
	WHERE	PermissionLink.PermissionAllow = 1 AND PermissionLink.PermissionType IN (101,102,103,104,105,106) AND UserID = @UserID

	DECLARE @Table_StockCode TABLE (
		StockCodeID int PRIMARY KEY
	)
	
	--check for permissions in three levels of hierarchy: Business Group, Sub Group, Stock Code, and translate to StockCodeID
	INSERT INTO @Table_StockCode (StockCodeID)
	SELECT		StockCodeID
	FROM        PM_VW_StockCode
	WHERE		BusinessGroup IN (SELECT BusinessGroup FROM @PermissionLink WHERE BusinessGroup IS NOT NULL)
	
	INSERT INTO @Table_StockCode (StockCodeID)
	SELECT		StockCodeID
	FROM        PM_VW_StockCode
	WHERE		StockCodeSubGroup IN (SELECT StockCodeSubGroup FROM @PermissionLink WHERE StockCodeSubGroup IS NOT NULL)
	
	INSERT INTO @Table_StockCode (StockCodeID)
	SELECT		StockCodeID
	FROM        PM_VW_StockCode
	WHERE		StockCodeID IN (SELECT StockCodeID FROM @PermissionLink WHERE StockCodeID IS NOT NULL)

	BEGIN
	IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1 AND @DateTo <= @WarehouseBuildDate
		BEGIN
			INSERT INTO	@UnfilteredResponse (ResponseID, ResponseStatus, QAFlagID)
			SELECT		RPT_Warehouse_Response.ResponseID, QMS_Response.ResponseStatus, RPT_Warehouse_Response.QAFlagID --Actual or Override QAFlag setting checked when building warehouse table
			FROM		RPT_Warehouse_Response INNER JOIN
							QMS_Response ON RPT_Warehouse_Response.ResponseID = QMS_Response.ResponseID
			WHERE		(QMS_Response.RecordStatus < @RecordStatus) AND (RPT_Warehouse_Response.EndDate BETWEEN @DateFrom AND @DateTo)
				
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel = 9)
				UPDATE	UnfilteredResponse
				SET	LocationID = RPT_Warehouse_Response.SupplierSiteID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
				WHERE ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(RPT_Warehouse_Response.SupplierSiteID,0)
 
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel <> 9)
				UPDATE	UnfilteredResponse
				SET	LocationID = RPT_Warehouse_Response.LocationID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
				WHERE ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(RPT_Warehouse_Response.LocationID,0)

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
				UPDATE	UnfilteredResponse
				SET		SupplierID = RPT_Warehouse_Response.SupplierID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
				WHERE ISNULL(UnfilteredResponse.SupplierID,0) <> ISNULL(RPT_Warehouse_Response.SupplierID,0)
				
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE CustomerID IS NOT NULL) 
				UPDATE	UnfilteredResponse
				SET		CustomerID = PM_VW_StockCode.CustomerID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID INNER JOIN
							PM_VW_StockCode ON RPT_Warehouse_Response.StockCodeID = PM_VW_StockCode.StockCodeID
				WHERE ISNULL(UnfilteredResponse.CustomerID,0) <> ISNULL(PM_VW_StockCode.CustomerID,0)

			IF EXISTS (SELECT StockCodeID FROM @Table_StockCode)
				UPDATE	UnfilteredResponse
				SET		StockCodeID = RPT_Warehouse_Response.StockCodeID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
			END
			
	--Logic for inserting today's date data into @UnfilteredResponse so that the datawarehouse can still be used when the user filters on today's date
	ELSE IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
		BEGIN
			DECLARE @override bit 
			SET @override = CAST(ISNULL(dbo.FNC_GetOptionValue(74),0) AS bit)
			
			INSERT INTO @UnfilteredResponseTodaysDate (ResponseID, ResponseStatus, QAFlagID) 
			SELECT ResponseID, ResponseStatus,
					--check config value to use Actual or Override QAFlagID
					CASE WHEN @override = 0 THEN Actual_QAFlagID ELSE ISNULL(Override_QAFlagID, Actual_QAFlagID) END AS QAFlagID
			FROM	QMS_Response
			WHERE	(RecordStatus < @RecordStatus) 
			AND ISNULL(Uploaded,EndDate) BETWEEN @WarehouseBuildDate AND @DateTo

	--Logic for getting incomplete checks before today's date
			INSERT INTO @UnfilteredResponseTodaysDate (ResponseID, ResponseStatus, QAFlagID) 
			SELECT ResponseID, ResponseStatus,
					--check config value to use Actual or Override QAFlagID
					CASE WHEN @override = 0 THEN Actual_QAFlagID ELSE ISNULL(Override_QAFlagID, Actual_QAFlagID) END AS QAFlagID
			FROM	QMS_Response
			WHERE	(RecordStatus < @RecordStatus) 
			AND (EndDate BETWEEN @DateFrom AND @DateTo)
			AND ResponseStatus = 0
			AND ResponseID  NOT IN (SELECT UnfilteredResponseTodaysDate.ResponseID FROM @UnfilteredResponseTodaysDate UnfilteredResponseTodaysDate
							WHERE UnfilteredResponseTodaysDate.ResponseID = UnfilteredResponseTodaysDate.ResponseID) 

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel = 9)
				UPDATE	UnfilteredResponseTodaysDate
				SET		LocationID = Location.LocationID
				FROM	@UnfilteredResponseTodaysDate UnfilteredResponseTodaysDate INNER JOIN
							QMS_ResponseHeader ON UnfilteredResponseTodaysDate.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
							QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
							PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
				WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 53) and
				ISNULL(UnfilteredResponseTodaysDate.LocationID,0) <> ISNULL(Location.LocationID,0)

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel <> 9)
				UPDATE	UnfilteredResponseTodaysDate
				SET		LocationID = Location.LocationID
				FROM	@UnfilteredResponseTodaysDate UnfilteredResponseTodaysDate INNER JOIN
							QMS_ResponseHeader ON UnfilteredResponseTodaysDate.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
							QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
							PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
				WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 4) and 
				ISNULL(UnfilteredResponseTodaysDate.LocationID,0) <> ISNULL(Location.LocationID,0)

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
				UPDATE	UnfilteredResponseTodaysDate
				SET		SupplierID = QMS_ResponseHeader.Header_SourceID
				FROM	@UnfilteredResponseTodaysDate UnfilteredResponseTodaysDate INNER JOIN
							QMS_ResponseHeader ON UnfilteredResponseTodaysDate.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
							QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
				WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 1) AND
				ISNULL(UnfilteredResponseTodaysDate.SupplierID,0) <> ISNULL(QMS_ResponseHeader.Header_SourceID,0)
				
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE CustomerID IS NOT NULL) 
				UPDATE	UnfilteredResponseTodaysDate
				SET		CustomerID = PM_VW_StockCode.CustomerID
				FROM	@UnfilteredResponseTodaysDate UnfilteredResponseTodaysDate INNER JOIN
							dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponseTodaysDate.ResponseID = HeaderStockCode.ResponseID INNER JOIN
							PM_VW_StockCode ON PM_VW_StockCode.StockCodeID = HeaderStockCode.StockCodeID
				WHERE ISNULL(UnfilteredResponseTodaysDate.CustomerID,0) <> ISNULL(PM_VW_StockCode.CustomerID,0)

			IF EXISTS (SELECT StockCodeID FROM @Table_StockCode)
				UPDATE	UnfilteredResponseTodaysDate
				SET		StockCodeID = HeaderStockCode.StockCodeID
				FROM	@UnfilteredResponseTodaysDate UnfilteredResponseTodaysDate INNER JOIN
							dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponseTodaysDate.ResponseID = HeaderStockCode.ResponseID
				WHERE ISNULL(UnfilteredResponseTodaysDate.StockCodeID,0) <> ISNULL(HeaderStockCode.StockCodeID,0)

			INSERT INTO	@UnfilteredResponse (ResponseID, ResponseStatus, QAFlagID)
			SELECT		RPT_Warehouse_Response.ResponseID, QMS_Response.ResponseStatus, RPT_Warehouse_Response.QAFlagID --Actual or Override QAFlag setting checked when building warehouse table
			FROM		RPT_Warehouse_Response 
			INNER JOIN  QMS_Response ON RPT_Warehouse_Response.ResponseID = QMS_Response.ResponseID
			WHERE		(QMS_Response.RecordStatus < @RecordStatus) 
			AND (RPT_Warehouse_Response.EndDate BETWEEN @DateFrom AND @WarehouseBuildDate)
			AND NOT EXISTS (SELECT UnfilteredResponseTodaysDate.ResponseID FROM @UnfilteredResponseTodaysDate UnfilteredResponseTodaysDate
							WHERE UnfilteredResponseTodaysDate.ResponseID = RPT_Warehouse_Response.ResponseID)
				
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel = 9)
				UPDATE	UnfilteredResponse
				SET	LocationID = RPT_Warehouse_Response.SupplierSiteID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
				WHERE ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(RPT_Warehouse_Response.SupplierSiteID,0)
 
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel <> 9)
				UPDATE	UnfilteredResponse
				SET	LocationID = RPT_Warehouse_Response.LocationID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
				WHERE ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(RPT_Warehouse_Response.LocationID,0)

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
				UPDATE	UnfilteredResponse
				SET		SupplierID = RPT_Warehouse_Response.SupplierID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
				WHERE ISNULL(UnfilteredResponse.SupplierID,0) <> ISNULL(RPT_Warehouse_Response.SupplierID,0)
				
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE CustomerID IS NOT NULL) 
				UPDATE	UnfilteredResponse
				SET		CustomerID = PM_VW_StockCode.CustomerID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID INNER JOIN
							PM_VW_StockCode ON RPT_Warehouse_Response.StockCodeID = PM_VW_StockCode.StockCodeID
				WHERE ISNULL(UnfilteredResponse.CustomerID,0) <> ISNULL(PM_VW_StockCode.CustomerID,0)

			IF EXISTS (SELECT StockCodeID FROM @Table_StockCode)
				UPDATE	UnfilteredResponse
				SET		StockCodeID = RPT_Warehouse_Response.StockCodeID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID

			INSERT INTO @UnfilteredResponse(ResponseID, ResponseStatus, LocationID, CustomerID, SupplierID, StockCodeID, QAFlagID)
			SELECT ResponseID, ResponseStatus, LocationID, CustomerID, SupplierID, StockCodeID, QAFlagID FROM @UnfilteredResponseTodaysDate
		END
	ELSE --don't use warehouse table
		BEGIN
			DECLARE @OverrideOption bit 
			SET @OverrideOption = CAST(ISNULL(dbo.FNC_GetOptionValue(74),0) AS bit)
			
			INSERT INTO @UnfilteredResponse (ResponseID, ResponseStatus, QAFlagID)
			SELECT ResponseID, ResponseStatus,
					--check config value to use Actual or Override QAFlagID
					CASE WHEN @OverrideOption = 0 THEN Actual_QAFlagID ELSE ISNULL(Override_QAFlagID, Actual_QAFlagID) END AS QAFlagID
			FROM	QMS_Response
			WHERE	(RecordStatus < @RecordStatus) AND (EndDate BETWEEN @DateFrom AND @DateTo)
			
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel = 9)
				UPDATE	UnfilteredResponse
				SET		LocationID = Location.LocationID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							QMS_ResponseHeader ON UnfilteredResponse.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
							QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
							PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
				WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 53) and
				ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(Location.LocationID,0)

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel <> 9)
				UPDATE	UnfilteredResponse
				SET		LocationID = Location.LocationID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							QMS_ResponseHeader ON UnfilteredResponse.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
							QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
							PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
				WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 4) and 
				ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(Location.LocationID,0)

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
				UPDATE	UnfilteredResponse
				SET		SupplierID = QMS_ResponseHeader.Header_SourceID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							QMS_ResponseHeader ON UnfilteredResponse.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
							QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
				WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 1) AND
				ISNULL(UnfilteredResponse.SupplierID,0) <> ISNULL(QMS_ResponseHeader.Header_SourceID,0)
				
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE CustomerID IS NOT NULL) 
				UPDATE	UnfilteredResponse
				SET		CustomerID = PM_VW_StockCode.CustomerID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponse.ResponseID = HeaderStockCode.ResponseID INNER JOIN
							PM_VW_StockCode ON PM_VW_StockCode.StockCodeID = HeaderStockCode.StockCodeID
				WHERE ISNULL(UnfilteredResponse.CustomerID,0) <> ISNULL(PM_VW_StockCode.CustomerID,0)

			IF EXISTS (SELECT StockCodeID FROM @Table_StockCode)
				UPDATE	UnfilteredResponse
				SET		StockCodeID = HeaderStockCode.StockCodeID
				FROM	@UnfilteredResponse UnfilteredResponse INNER JOIN
							dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponse.ResponseID = HeaderStockCode.ResponseID
				WHERE ISNULL(UnfilteredResponse.StockCodeID,0) <> ISNULL(HeaderStockCode.StockCodeID,0)
		END
	END

	-- Only return responses which match the filter specified, or for which we do not have a filter.
	-- This means that admin users (any user with no permissions set) can see all responses.
	INSERT INTO @Response (ResponseID, ResponseStatus, QAFlagID)
	SELECT	ResponseID, ResponseStatus, QAFlagID
	FROM	@UnfilteredResponse UnfilteredResponse
	WHERE (	NOT EXISTS (SELECT LocationID FROM @PermissionLink WHERE LocationID IS NOT NULL)
		OR	LocationID IN (SELECT LocationID FROM @PermissionLink WHERE LocationID IS NOT NULL) )
	AND (	NOT EXISTS (SELECT SupplierID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
		OR	SupplierID IN (SELECT SupplierID FROM @PermissionLink WHERE SupplierID IS NOT NULL) )
	AND (	NOT EXISTS (SELECT CustomerID FROM @PermissionLink WHERE CustomerID IS NOT NULL)
		OR	CustomerID IN (SELECT CustomerID FROM @PermissionLink WHERE CustomerID IS NOT NULL) )
	AND (	StockCodeID IS NULL -- Allow unlinked stockcode responses
		OR	NOT EXISTS (SELECT StockCodeID FROM @Table_StockCode)
		OR	StockCodeID IN (SELECT StockCodeID FROM @Table_StockCode) )
	
	RETURN
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_TEMP_ResponseHeader_PreviousAQCResponse')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_TEMP_ResponseHeader_PreviousAQCResponse] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 27/10/2011
-- Description:	Lookup previous Supplier (AQC) checks with matching supplier, DU date and product
-- Version:		6
-- =============================================
-- JE TFS 3971 - updated conversion of @DUDateString
-- JT TFS 5665 - QMS_SupplierResponse.GUID as a new column  hidden from the view in Mobile
-- MP TFS 6437 - Added Arrival date lookup and match
-- MP TFS 8014 - Made sure only DUDate is used to match when captured, otherwise use ArrivalDate
-- SS TFS 13-49766: Added functionality so that AQC can match on extra criteria such as, Location when linking to an assessment
-- =============================================
ALTER PROCEDURE [dbo].[QRY_TEMP_ResponseHeader_PreviousAQCResponse] 
	@UserID int, 
	@AssessmentID int 
AS
BEGIN

SET NOCOUNT ON

DECLARE @PotentialMatches TABLE (
		CheckDate dateTime NULL,
		QAFlagID int NULL,
		QAFlag nvarchar (100) NULL,
		StockCode nvarchar (510) NULL,
		LocationName nvarchar (510) NULL,
		RedResponses nvarchar (2000) NULL,
		Comments nvarchar (4000) NULL,
		ResponseID int NULL,
		SupplierResponseGuid uniqueIdentifier,
		ExtraAQCColumn1 int NULL
		--ExtraAQCColumn2 nvarchar (225) NULL,
		--ExtraAQCColumn3 nvarchar (225) NULL,
		--ExtraAQCColumn4 nvarchar (225) NULL
	)
--Get config AQC match values
DECLARE @AQCMatchOn nvarchar(255)
SET @AQCMatchOn = (SELECT OptionValue FROM APP_Config WHERE OptionID = 134)

IF NULLIF(object_id('tempdb..#tmpAQCLink'), 0) IS NOT NULL DROP TABLE #tmpAQCLink;
SELECT * INTO #tmpAQCLink FROM dbo.FNC_SplitString(@AQCMatchOn, ',')

DECLARE @SupplierID int, @DUDateString nvarchar(20), @DUDate DATETIME, @ArrivalDateString nvarchar(20), @ArrivalDate DATETIME

--Lookup Supplier
SELECT     @SupplierID = TEMP_ResponseHeader.Header_SourceID
FROM       TEMP_ResponseHeader 
INNER JOIN QMS_AssessmentHeader ON TEMP_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
WHERE     (TEMP_ResponseHeader.UserID = @UserID) AND (QMS_AssessmentHeader.DataLookupID = 1)

--Lookup DU Date
SELECT     @DUDateString = TEMP_ResponseHeader.Header_Text
FROM       TEMP_ResponseHeader 
INNER JOIN QMS_AssessmentHeader ON TEMP_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
WHERE     (TEMP_ResponseHeader.UserID = @UserID) 
AND		  (QMS_AssessmentHeader.DataLookupID = 39)

IF @DUDateString IS NOT NULL
	SELECT @DUDate = dbo.FNC_TrimDate(CONVERT(datetime, @DUDateString))
	
--Lookup Arrival Date
SELECT     @ArrivalDateString = TEMP_ResponseHeader.Header_Text
FROM       TEMP_ResponseHeader 
INNER JOIN QMS_AssessmentHeader ON TEMP_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
WHERE     (TEMP_ResponseHeader.UserID = @UserID) AND (QMS_AssessmentHeader.DataLookupID = 16)

IF @ArrivalDateString IS NOT NULL AND @DUDate IS NULL --only set arrival date when DU date is not known
	SELECT @ArrivalDate = dbo.FNC_TrimDate(CONVERT(datetime, @ArrivalDateString))

INSERT INTO @PotentialMatches
		(
		CheckDate,
		QAFlagID,
		QAFlag,
		StockCode,
		LocationName,
		RedResponses,
		Comments,
		ResponseID,
		SupplierResponseGuid,
		ExtraAQCColumn1
		)
SELECT QMS_SupplierResponse.EndDate AS CheckDate, 
	   QAFlag.QAFlagID AS Lookup_QAFlagID,
	   QAFlag.QAFlag, PM_VW_StockCode.Description AS StockCode, 
       PM_VW_Location.LocationName, 
	   QMS_SupplierResponse.RedResponses, 
	   QMS_SupplierResponse.Comments, 
	   QMS_SupplierResponse.ResponseID, 
       QMS_SupplierResponse.GUID, 
	   PM_VW_Location.LocationID
FROM   QMS_SupplierResponse 
LEFT OUTER JOIN	(SELECT QAFlagID, 
						ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag FROM APP_QAFlag) AS QAFlag ON QMS_SupplierResponse.QAFlagID = QAFlag.QAFlagID 
LEFT OUTER JOIN PM_VW_Location ON QMS_SupplierResponse.LocationID = PM_VW_Location.LocationID 
LEFT OUTER JOIN PM_VW_StockCode ON QMS_SupplierResponse.StockCodeID = PM_VW_StockCode.StockCodeID
WHERE     
(QMS_SupplierResponse.RecordStatus < 201) 
AND (QMS_SupplierResponse.AssessmentID = @AssessmentID)
AND (QMS_SupplierResponse.SupplierID = @SupplierID) 
AND (QMS_SupplierResponse.AssessmentTypeID = 16)
AND (dbo.FNC_TrimDate(QMS_SupplierResponse.DUDate) = @DUDate OR @DUDate IS NULL) 
AND (dbo.FNC_TrimDate(QMS_SupplierResponse.ArrivalDate) = @ArrivalDate OR @ArrivalDate IS NULL)

-- Check if we're matching on location
IF EXISTS (SELECT * FROM #tmpAQCLink WHERE Token = 'Location')
BEGIN
	DECLARE @LocationID int
	SELECT		@LocationID = Header_SourceID FROM TEMP_ResponseHeader
	INNER JOIN	QMS_AssessmentHeader ON TEMP_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
	WHERE		(TEMP_ResponseHeader.UserID = @UserID) 
	AND			(QMS_AssessmentHeader.DataLookupID = 4)

	DELETE @PotentialMatches
	WHERE ExtraAQCColumn1 IS NULL 
	OR ExtraAQCColumn1 <> @LocationID
END

SET NOCOUNT OFF

SELECT  CheckDate,
		QAFlagID,
		QAFlag,
		StockCode,
		LocationName,
		RedResponses,
		Comments,
		ResponseID,
		SupplierResponseGuid
FROM @PotentialMatches
ORDER BY CheckDate DESC;
END
GO


PRINT 'Database updated successfully!'
GO
