-- =============================================
-- Author:		Jeremy Formby
-- Create date: 10/07/2015
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO


IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_ResponseHeader')
	DROP Function dbo.FNC_ResponseHeader 
GO


-- =============================================
-- Author:                            Markp
-- Create date: 17/03/2009
-- Description:	Gets response header data for views
-- Version:		5
-- =============================================
-- tfs4354 - get the lowest DataLookupID for the stock code as there may be duplicates within an assessment (2,6 etc) 
-- JT TFS 13-19030: Move lookup of lowest DataLookupID into main query to prevent timeouts on rugby farms mobile.
-- JF tfs33017 - Investigate why no AQC Checks appearing on Previous Check screen - change to function type
-- JT TFS 13-38954: Convert back to inline function (from multi-statement function)
-- JT TFS 13-39583: 25/01/2016 - Revert to version 3 to prevent timeouts.
-- =============================================

create FUNCTION dbo.FNC_ResponseHeader 
(              
)
RETURNS TABLE 
AS
RETURN 
(
	SELECT  ResponseID, 
			MAX(Supplier) AS Supplier, 
			(SELECT TOP 1 StockCode FROM VW_ResponseHeader_SourceLookup WHERE ResponseID = rh.ResponseID AND StockCode IS NOT NULL ORDER BY DataLookupID) StockCode,
			MAX(Location) AS Location, MAX(Consignment) AS Consignment, 
			MAX(ConsignmentItem) AS ConsignmentItem, MAX(Delivery) AS Delivery, MAX(DeliveryItem) AS DeliveryItem, MAX(SupplierRef) AS SupplierRef, 
			MAX(ArrivalDate) AS ArrivalDate, MAX(QuantityReceived) AS QuantityReceived, MAX(QuantityChecked) AS QuantityChecked, 
			MAX(Customer) AS Customer, MAX(AssessmentSubType) AS AssessmentSubType, MAX(DepotDate) AS DepotDate, MAX(CountryOfOrigin) AS CountryOfOrigin, 
			MAX(HarvestCrew) AS HarvestCrew
	FROM    VW_ResponseHeader_SourceLookup as rh
	GROUP BY rh.ResponseID
)
GO



PRINT 'Data migration tasks...'

PRINT 'Database updated successfully!'
GO
