-- =============================================
-- Author:		Jeremy Formby
-- Create date: 10/07/2015
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO



PRINT 'Sorting tables...'
-- BEGIN DATA STRUCT_PM_GoodsIntake_CountryID
BEGIN TRY
IF NOT EXISTS (SELECT * FROM sys.tables t INNER JOIN sys.columns c ON t.object_id = c.object_id WHERE t.name = 'PM_GoodsIntake' AND c.name = 'CountryID' )

	alter table PM_GoodsIntake add
		CountryID INT NULL,
		Alias nvarchar(50) null
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA STRUCT_PM_GoodsIntake_CountryID', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA STRUCT_PM_GoodsIntake_CountryID

PRINT 'Sorting indexes...'

PRINT 'Sorting Views...'

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'PM_VW_GoodsIntake')
	EXEC ('CREATE VIEW [dbo].[PM_VW_GoodsIntake] AS SELECT 1 as ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Unknown
-- Create date: 29/06/2010
-- Description:	Gets header informaton for PM_GoodsIntake
-- Version:		9
-- =============================================
-- JT TFS 4286: 9-Aug-2012: Added PalletID
-- JF: Added ArrivalTemp and Certified
-- MP TFS 2798: Added Updated column
-- jf TFS 19129 - added PalletStockCodeID
-- jf TFS 29162 - added storeID
-- jf tfs 32575 - add @CountryID and @Alias
-- =============================================
ALTER VIEW [dbo].[PM_VW_GoodsIntake]
AS
SELECT        GoodsIntakeID, SupplierID, ConsignmentItemID, LocationID, UserGroupID, ItemCount, UnitQuantity, PalletNo, HarvestDate, DeliveryID, DateArrived, SupplierRef, SupplierLotNo, Barcode, Comments, E_Text1, 
                         E_Text2, UnitStockCodeID, OriginalBarcode, E_Numeric1, E_DateTime1, PalletID, ArrivalTemp, Certified, Updated, NetWeight, PalletStockCodeID, RowVersion, Created, RecordStatus, E_Numeric3, E_Numeric2, 
                         GUID,StoreID,CountryID,Alias
FROM            dbo.PM_GoodsIntake
WHERE        (RecordStatus < 201)



GO

PRINT 'Sorting User Defined Functions...'

-- BEGIN [dbo].[FNC_ResponseHeader_StockCodeID_Selected]
IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FNC_ResponseHeader_StockCodeID_Selected]') AND xtype in (N'FN', N'IF', N'TF'))
BEGIN TRY
	     DROP FUNCTION [dbo].[FNC_ResponseHeader_StockCodeID_Selected]
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DROP FNC_ResponseHeader_StockCodeID_Selected', ERROR_MESSAGE()
	FROM #tmpScriptName
	
END CATCH
GO
-- =============================================
-- Author:		Markp
-- Create date: 05/08/2009
-- Description:	Gets stock code id for responses
-- Version:		4
-- =============================================
-- JT TFS 7830 - Also link through raw stockcode datalookup
-- JT TFS 13-11718 - Remove double counting bug when linking stockcode to response from temp_selected table.
-- JT TFS 13-38811 - Convert function to not be multi-value table function
-- =============================================
CREATE FUNCTION dbo.FNC_ResponseHeader_StockCodeID_Selected 
(
	@UserID int
)
RETURNS TABLE
AS
RETURN (
	SELECT ResponseID, StockCodeID FROM (
		SELECT row_number() OVER (PARTITION BY ResponseID ORDER BY ListIndex) as row, ResponseID, StockCodeID FROM (
			SELECT     QMS_ResponseHeader.ResponseID, QMS_ResponseHeader.Header_SourceID StockCodeID, 1 AS ListIndex
			FROM         QMS_ResponseHeader INNER JOIN
							  QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
							  TEMP_Selected ON QMS_ResponseHeader.ResponseID = TEMP_Selected.SelectedID
			WHERE     (QMS_ResponseHeader.Header_SourceID IS NOT NULL) AND (QMS_AssessmentHeader.DataTypeID = 9) AND 
							  (QMS_AssessmentHeader.DataLookupID IN (2, 35)) AND (TEMP_Selected.UserID = @UserID)

			union all

			SELECT     QMS_ResponseHeader.ResponseID, PM_VW_ConsignmentItems.StockCodeID, 2
			FROM         QMS_ResponseHeader INNER JOIN
							  QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
							  PM_VW_ConsignmentItems ON QMS_ResponseHeader.Header_SourceID = PM_VW_ConsignmentItems.ConsignmentItemID INNER JOIN
							  TEMP_Selected ON QMS_ResponseHeader.ResponseID = TEMP_Selected.SelectedID
			WHERE     (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 6) AND (TEMP_Selected.UserID = @UserID)

			union all

			SELECT     QMS_ResponseHeader.ResponseID, PM_VW_ConsignmentItems.StockCodeID, 3
			FROM         QMS_ResponseHeader INNER JOIN
							  QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
							  PM_VW_GoodsIntake ON QMS_ResponseHeader.Header_SourceID = PM_VW_GoodsIntake.GoodsIntakeID INNER JOIN
							  PM_VW_ConsignmentItems ON PM_VW_GoodsIntake.ConsignmentItemID = PM_VW_ConsignmentItems.ConsignmentItemID INNER JOIN
							  TEMP_Selected ON QMS_ResponseHeader.ResponseID = TEMP_Selected.SelectedID
			WHERE     (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 8) AND (TEMP_Selected.UserID = @UserID)
		) as result
	) as result_with_rows
	WHERE row = 1
)
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[FNC_ResponseHeader_StockCodeID_Selected]') AND xtype in (N'FN', N'IF', N'TF'))
	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName, ErrorMessage)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Failed to create [dbo].[FNC_ResponseHeader_StockCodeID_Selected]', ERROR_MESSAGE()
	FROM #tmpScriptName
GO
-- END [dbo].[FNC_ResponseHeader_StockCodeID_Selected]




PRINT 'Sorting Stored Procedures...'

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'APP_Temp_ReportFilter')
	EXEC ('CREATE PROCEDURE [dbo].[APP_Temp_ReportFilter] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JToolan
-- Create date: 22/03/2012
-- Description:	Works out which ResponseIDs need to be put in the filter.
--              Can be used by any report.
-- Version:		19
-- =============================================
-- j.toolan 30-mar-2012: If @AssessmentTypeID_LIST is empty, then join all assessments
-- j.toolan 13 Apr 2012: Fixed bug with 2nd filter incorrectly clearing.
-- j.toolan 18 Apr 2012: Added Code to filter by stockcode where appropriate (renamed to ReportFilter)
-- JE 25 Apr 2012: made ReportFilterID1 optional, so can just filter by AssessmentType if necessary (TFS 3382)
-- j.toolan 6 July 2012: TFS 4013: Dynamic filtering added.
-- JE TFS 4740: removed GROUP BY for performance reasons
-- JE TFS 5037: corrected @ReportFilterID2 check as 2nd tier filter wasn't working
-- MP TFS 5289: changed date format used for custom filter functions
-- JT TFS 5396: changed code to allow commas in FilterTexts passed in as CSV. (replace "," with "&comma;" )
-- JT TFS 6689: FNC_CanUserDataWareHouse takes UserID parameter.
-- JT TFS 6689: FNC_ReportFilter_Response takes UserID parameter.
-- JT TFS 8117: Added offline filtering.
-- MP TFS 8227: Made temp table user specific and added performance logging
-- JE TFS 8274: Put result set of FNC_User_ResponseList into temp table before using it
-- JT TFS 13-667: Do not filter responses if the date range is too big.
-- JT TFS 13-1076: Search either QMS_Response or QMS_SupplierResponse, but not both.
-- JF TFS 2281 - if filter doesn't have a sourceid, this wasn't working
-- JT TFS 13-17467: Only include checks which are eligible candidates for the data warehouse.
-- JT TFS 13-38578: Convert SP to use QRY_User_ResponseList (rather than FNC_UserResponseList)
-- =============================================
ALTER PROCEDURE [dbo].[APP_Temp_ReportFilter]
	@UserID int,
	@DateFrom datetime,
	@DateTo datetime,
	@AssessmentTypeID_LIST nvarchar(255),

	@ReportFilterID1 int = NULL,
	@FilterID_LIST nvarchar(4000),
	@FilterText_LIST nvarchar(4000),
	@ReportFilterID2 int = NULL,
	@FilterID2 int = NULL,
	@FilterText2 nvarchar(255) = NULL,
	
	@Offline bit = NULL,
	@SearchLocalChecksIfOffline bit = 1 -- Use QMS_Response even if offline (default)
AS
BEGIN
	SET NOCOUNT ON
	
	DECLARE @DateCalled DATETIME
	SET @DateCalled = GETDATE()	
	IF @Offline IS NULL SELECT @Offline = CASE WHEN db_name() = 'GreenlightQC_Mobile' THEN 1 ELSE 0 END
	
	DECLARE @SearchOffline bit -- if this is set, then we search in QMS_SupplierResponse.
	SELECT @SearchOffline  = CASE WHEN @Offline = 1 AND @SearchLocalChecksIfOffline = 0 THEN 1 ELSE 0 END
		
	-- Do not filter responses if the date range is not specified
	DECLARE @performResponseFiltering bit 
	SELECT @performResponseFiltering = CASE WHEN @DateFrom <= '1 Jan 2001' and datediff(year, @DateFrom, @DateTo) >= 10 THEN 0 ELSE 1 END
	
	DELETE TEMP_ResponseFilter WHERE UserID = @UserID
	DELETE TEMP_StockCodeFilter WHERE UserID = @UserID

	-- If the first criteria is empty, but the second is not, swap them over.
	IF (LEN(@FilterID_LIST) = 0 AND LEN(@FilterText_LIST) = 0 -- first criteria is empty?!
	AND @ReportFilterID2 IS NOT NULL AND (@FilterID2 IS NOT NULL OR @FilterText2 IS NOT NULL)) -- but the second is not...
	BEGIN -- The great fairness swaparoo! (in two steps)
		SELECT	@ReportFilterID1 = @ReportFilterID2,
				@FilterID_LIST = CONVERT(nvarchar(4000), @FilterID2),
				@FilterText_LIST = @FilterText2
				
		SELECT @ReportFilterID2 = NULL, @FilterID2 = NULL, @FilterText2 = NULL
	END

	-- Is the second question correctly formulated? You must have an id or a text (or both) but not neither.
	-- JE TFS 5037 - corrected this as it was always setting @ReportFilterID2 to NULL for filters with no ID (i.e. text only)
	IF @ReportFilterID2 IS NOT NULL AND (NULLIF(@FilterID2, 0) IS NULL) AND (LEN(ISNULL(@FilterText2, '')) = 0)
	BEGIN
		SET @ReportFilterID2 = NULL
	END

	DECLARE @FilterItem TABLE (pos int not null, id int, txt nvarchar(255))
	INSERT @FilterItem (pos, id, txt)
	
	-- tfs 2281 - if filter doesn't have a sourceidm this wasn't working
	SELECT 	ISNULL(a.Position, b.Position) pos, CONVERT(int, ISNULL(a.Token,0)) id, replace(b.Token, '&comma;', ',') txt
	FROM dbo.FNC_SplitString(@FilterID_LIST, ',') a
	FULL JOIN dbo.FNC_SplitString(@FilterText_LIST, ',') b on a.Position = b.Position

	DECLARE @AssessmentType TABLE (id int not null)
	INSERT @AssessmentType (id) 
	SELECT CONVERT(int, Token) FROM dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',')
	INNER JOIN APP_AssessmentType ON CONVERT(int, Token) = AssessmentTypeID 
	IF NOT EXISTS (SELECT * FROM @AssessmentType) 
	BEGIN -- if we tried to join, and got nothing, that means that this report wants all non-hidden types.
		INSERT @AssessmentType (id) SELECT AssessmentTypeID FROM APP_AssessmentType WHERE Hide = 0
	END

	-- Do some custom filtering if it is set up. This acts like "AND" (restricting results)
	DECLARE @CustomFilterFunction nvarchar(50)
	SET @CustomFilterFunction = NULL
	SELECT @CustomFilterFunction = APP_ReportFilter.FilterFunction 
	FROM APP_ReportFilter 
	WHERE ReportFilterID = @ReportFilterID1
	
	DECLARE @customSql nvarchar(1000)
	SET @customSql = NULL
	CREATE TABLE #tmpCustomFilter (UserID INT, ResponseID int, GroupByText nvarchar(50))

	DECLARE @FilteredStockCode TABLE (id int not null)
	DECLARE @FilteredResponse TABLE (id int not null)
	WHILE EXISTS (SELECT * FROM @FilterItem)
	BEGIN
		DECLARE @pos int, @FilterID int, @FilterText nvarchar(255)
		SELECT @pos = pos,  @FilterID = id, @FilterText = txt
		FROM @FilterItem
		WHERE pos = (SELECT MIN(pos) FROM @FilterItem)

		IF @performResponseFiltering = 1
		BEGIN
			-- either the custom function runs, *OR* the generic one, *OR* the offline one, but not more than one.
			IF @SearchOffline = 1
			BEGIN
				INSERT @FilteredResponse (id)
				SELECT ResponseID 
				FROM dbo.FNC_ReportFilter_Response_Offline(@ReportFilterID1, @FilterID, @FilterText, @DateFrom, @DateTo, @UserID)
			END
			ELSE IF @CustomFilterFunction IS NOT NULL
			BEGIN
				SELECT @customSql = 'INSERT #tmpCustomFilter (UserID, ResponseID, GroupByText) SELECT ' + convert(nvarchar(10), @UserID) + ' AS UserID, ResponseID, GroupByText FROM dbo.[' + @CustomFilterFunction + ']' + 
									'(' + convert(nvarchar(10), @UserID) + ', ' +
									convert(nvarchar(30), @FilterID) + ', ' +
									'''' + convert(nvarchar(50), @FilterText) + ''', ' + 
									'''' + convert(nvarchar(30), @DateFrom, 13) + ''', ' +
									'''' + convert(nvarchar(30), @DateTo, 13) + ''');'
				
				PRINT @customSql
				
				IF @customSql IS NOT NULL
					EXECUTE (@customSql)
			END
			ELSE
			BEGIN
				INSERT @FilteredResponse (id)
				SELECT ResponseID 
				FROM dbo.FNC_ReportFilter_Response(@ReportFilterID1, @FilterID, @FilterText, @DateFrom, @DateTo, @UserID)
			END
		END
		
		INSERT @FilteredStockCode (id)
		SELECT StockCodeID
		FROM dbo.FNC_ReportFilter_StockCode(@ReportFilterID1, @FilterID, @FilterText, @DateFrom, @DateTo)
		
		DELETE @FilterItem WHERE pos = @pos
	END

	-- insert all our new custom filtered items (added to temp table in loop above)
	INSERT @FilteredResponse (id)
	SELECT ResponseID 
	FROM #tmpCustomFilter
	WHERE UserID = @UserID

	-- If there is another filter, it acts as an "AND" (restricting results returned), not an "OR" (expanding results returned). 
	IF @ReportFilterID2 IS NOT NULL
	BEGIN 
		IF @performResponseFiltering = 1
		BEGIN
			DECLARE @SecondFilteredResponse TABLE (id int)
			
			SELECT @CustomFilterFunction = APP_ReportFilter.FilterFunction 
			FROM APP_ReportFilter 
			WHERE ReportFilterID = @ReportFilterID2
		
			IF @SearchOffline = 1
			BEGIN
				INSERT @SecondFilteredResponse (id)
				SELECT ResponseID 
				FROM dbo.FNC_ReportFilter_Response_Offline(@ReportFilterID2, @FilterID2, @FilterText2, @DateFrom, @DateTo, @UserID)
			END 
			ELSE IF @CustomFilterFunction IS NOT NULL
			BEGIN
				DELETE #tmpCustomFilter WHERE UserID = @UserID --clear it out for second filter.
				
				SELECT @customSql = 'INSERT #tmpCustomFilter (UserID, ResponseID, GroupByText) SELECT ' + convert(nvarchar(10), @UserID) + ' AS UserID, ResponseID, GroupByText FROM dbo.[' + @CustomFilterFunction + ']' + 
									'(' + convert(nvarchar(10), @UserID) + ', ' +
									convert(nvarchar(30), @FilterID2) + ', ' +
									'''' + convert(nvarchar(50), @FilterText2) + ''', ' + 
									'''' + convert(nvarchar(30), @DateFrom, 13) + ''', ' +
									'''' + convert(nvarchar(30), @DateTo, 13) + ''');'

				IF @customSql IS NOT NULL
					EXECUTE (@customSql)
				
				INSERT @SecondFilteredResponse (id)
				SELECT ResponseID FROM #tmpCustomFilter WHERE UserID = @UserID
			END
			ELSE
			BEGIN
				INSERT @SecondFilteredResponse (id)
				SELECT ResponseID 
				FROM dbo.FNC_ReportFilter_Response (@ReportFilterID2, @FilterID2, @FilterText2, @DateFrom, @DateTo, @UserID)
			END
			
			DELETE @FilteredResponse 
			WHERE id NOT IN (
				SELECT id FROM @SecondFilteredResponse
			)
		END
		
		DELETE @FilteredStockCode 
		WHERE id NOT IN (
			SELECT StockCodeID 
			FROM dbo.FNC_ReportFilter_StockCode (@ReportFilterID2, @FilterID2, @FilterText2, @DateFrom, @DateTo)
		)
	END

	-- Remove all responses which are not suitable candidates for the data warehouse
	DELETE @FilteredResponse
	WHERE dbo.FNC_Response_ShouldIncludeInDataWarehouse(id) = 0


	IF @performResponseFiltering = 1
	BEGIN
		IF @SearchOffline = 1
		BEGIN
			IF @ReportFilterID1 IS NOT NULL
				INSERT TEMP_ResponseFilter (UserID, ResponseID)
				SELECT @UserID as UserID, r.ResponseID 
				FROM QMS_SupplierResponse r
				INNER JOIN @AssessmentType at ON r.AssessmentTypeID = at.id
				INNER JOIN @FilteredResponse fr ON fr.id = r.ResponseID
				WHERE EndDate BETWEEN @DateFrom AND @DateTo
				AND   r.ResponseID NOT IN (SELECT ResponseID FROM TEMP_ResponseFilter WHERE UserID = @UserID)
				GROUP BY r.ResponseID
			ELSE
				INSERT TEMP_ResponseFilter (UserID, ResponseID)
				SELECT @UserID as UserID, r.ResponseID 
				FROM QMS_SupplierResponse r 
				INNER JOIN @AssessmentType at ON r.AssessmentTypeID = at.id	
				WHERE EndDate BETWEEN @DateFrom AND @DateTo
				AND   r.ResponseID NOT IN (SELECT ResponseID FROM TEMP_ResponseFilter WHERE UserID = @UserID)
				GROUP BY r.ResponseID
		END
		ELSE
		BEGIN
			--JE TFS 82774 - temp table of responses user can view (moved from direct access in query to improve performance)
			IF nullif(object_id('tempdb..#tmpUserResponses'), 0) IS NOT NULL DROP TABLE #tmpUserResponses
			CREATE TABLE #tmpUserResponses (UserID int, ResponseID int, ResponseStatus int, QAFlagID int)
			INSERT #tmpUserResponses (UserID, ResponseID, ResponseStatus, QAFlagID)
			EXEC QRY_User_ResponseList @UserID, @DateFrom, @DateTo

			IF @ReportFilterID1 IS NOT NULL
				-- Only return responses that the user is allowed to see, filter by Assessment Type, and use filter
				INSERT TEMP_ResponseFilter (UserID, ResponseID)
				SELECT @UserID as UserID, rl.ResponseID
				FROM #tmpUserResponses AS rl
				INNER JOIN QMS_Response r ON rl.ResponseID = r.ResponseID 
				INNER JOIN @AssessmentType at ON r.AssessmentTypeID = at.id
				INNER JOIN @FilteredResponse fr ON fr.id = r.ResponseID
				WHERE rl.UserID = @UserID
				GROUP BY rl.ResponseID
			
			IF @ReportFilterID1 IS NULL
				-- Only return responses that the user is allowed to see, but there has been no filter specified, so only filter by Assessment Type (if specified)
				INSERT TEMP_ResponseFilter (UserID, ResponseID)
				SELECT @UserID as UserID, rl.ResponseID
				FROM #tmpUserResponses AS rl
				INNER JOIN QMS_Response r ON rl.ResponseID = r.ResponseID 
				INNER JOIN @AssessmentType at ON r.AssessmentTypeID = at.id
				WHERE rl.UserID = @UserID	
				GROUP BY rl.ResponseID
			
			DROP TABLE #tmpUserResponses
		END

	END
	-- Only return stock codes that the user is allowed to see
	INSERT TEMP_StockCodeFilter (UserID, StockCodeID)
	SELECT @UserID as UserID, fs.id
	FROM @FilteredStockCode fs 
	INNER JOIN FNC_User_StockCodeList(@UserID) sl ON fs.id = sl.StockCodeID 
	--GROUP BY fs.id --removed in TFS 4740 as this was slowing the query down a LOT on JS UAT
	
	DECLARE @MonitorEnabled TINYINT
	SELECT @MonitorEnabled = ISNULL(dbo.FNC_GetOptionValue(92),0)

	IF @MonitorEnabled = 1 --Log filter to QMS_PerformanceLog
	BEGIN
		DECLARE @ReportString NVARCHAR(max)
		SET @ReportString = 'APP_Temp_ReportFilter '
		SET @ReportString = @ReportString + '@UserID = ' + CAST(@UserID AS NVARCHAR(10))
		SET @ReportString = @ReportString + ', @DateFrom = ' + CAST(@DateFrom AS NVARCHAR(11))
		SET @ReportString = @ReportString + ', @DateTo = ' + CAST(@DateTo AS NVARCHAR(11))
		SET @ReportString = @ReportString + ', @AssessmentTypeID_LIST = ' + CASE WHEN LEN(@AssessmentTypeID_LIST)=0 THEN 'NULL' ELSE @AssessmentTypeID_LIST END
		IF @ReportFilterID1>0
		BEGIN
			SET @ReportString = @ReportString + ', @ReportFilterID1 = ' + CAST(@ReportFilterID1 AS NVARCHAR(10))
			SET @ReportString = @ReportString + ', @FilterID_LIST = ' + CASE WHEN LEN(@FilterID_LIST)=0 THEN 'NULL' ELSE @FilterID_LIST END
			SET @ReportString = @ReportString + ', @FilterText_LIST = ' + CASE WHEN LEN(@FilterText_LIST)=0 THEN 'NULL' ELSE @FilterText_LIST END
		END
		IF @ReportFilterID2>0
		BEGIN
			SET @ReportString = @ReportString + ', @ReportFilterID2 = ' + CAST(@ReportFilterID2 AS NVARCHAR(10))
			SET @ReportString = @ReportString + ', @FilterID2 = ' + CAST(@FilterID2 AS NVARCHAR(10))
			SET @ReportString = @ReportString + ', @FilterText2 = ' + CASE WHEN LEN(@FilterText2)=0 THEN 'NULL' ELSE @FilterText2 END
		END
		
		DECLARE @ResponseCount INT
		SELECT @ResponseCount = COUNT(ResponseID) FROM TEMP_ResponseFilter WHERE UserID = @UserID
		
		INSERT INTO dbo.QMS_PerformanceLog
				( Action ,
				  StartTime ,
				  EndTime ,
				  RecordsAffected
				)
		VALUES  ( @ReportString ,
				  @DateCalled ,
				  GETDATE() ,
				  @ResponseCount
				  )
	END

	SET NOCOUNT OFF
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'APP_TEMP_ReportGroupBy_Response')
	EXEC ('CREATE PROCEDURE [dbo].[APP_TEMP_ReportGroupBy_Response] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JToolan
-- Create date: 22/03/2012
-- Description:	Works out the ResponseIDs need to be put in the filter. Created for GroupBy Custom Functions
--              Can be used by any report.
-- Version:		8
-- =============================================
-- JT TFS 5358 - Created
-- JE TFS 5363 - updated to include GroupByHeader
-- JT TFS 5546 - Updated to include custom GroupByHeaders
-- JT TFS 6139 - Increased size of individual result, to account for extra long stockcode descriptions.
-- JT TFS 8117 - Added Offline grouping
-- MP TFS 8227 - made temp tables user specific
-- JT TFS 13-1076: Search either QMS_Response or QMS_SupplierResponse, but not both.
-- JT TFS 13-38578: Only update #tmpGroupBy temp table if there's a change to the data.
-- =============================================
ALTER PROCEDURE APP_TEMP_ReportGroupBy_Response
	@UserID int,
	@DateFrom datetime,							-- Required for GroupBy functions.
	@DateTo datetime,							-- Required for GroupBy functions.
	@GroupByFilterList nvarchar(255),			-- ReportFilterIDs that we want to group by, in order.
	@IsFilterApplied bit = 1,					-- Do we use the values from previous filter, or generate our own list from the extra parameters below:
	@AssessmentTypeID_LIST nvarchar(255) = NULL,--(only used if @IsFilterApplied = 0)
	@Offline bit = NULL,						-- Do we include offline (QMS_SupplierResponse) checks?
	@SearchLocalChecksIfOffline bit = 1			-- Use QMS_Response even if offline (default)
AS
BEGIN
	SET NOCOUNT ON

	-- If they didn't specify the offline flag, then try to work it out.
	IF @Offline IS NULL SELECT @Offline = CASE WHEN db_name() = 'GreenlightQC_Mobile' THEN 1 ELSE 0 END
	
	DECLARE @SearchOffline bit -- if this is set, then we search in QMS_SupplierResponse.
	SELECT @SearchOffline  = CASE WHEN @Offline = 1 AND @SearchLocalChecksIfOffline = 0 THEN 1 ELSE 0 END
	
	-- Table to hold the final groupby information which will be built up along the way.
	IF NULLIF(object_id('tempdb..#tmpGroupBy'), 0) IS NOT NULL DROP TABLE #tmpGroupBy
	CREATE TABLE #tmpGroupBy (
		UserID INT,
		ResponseID int,
		GroupByText nvarchar(3750), -- note: dates and integers should be converted into a sortable format.
		GroupByHeader nvarchar(100)
	)


	-- Table to hold the function names which we are going to call to populate the group by information, and the order we apply them in.
	DECLARE @GroupByFunction TABLE (
		GroupByID int,
		GroupByFunction nvarchar(100),
		GroupByHeader nvarchar(100),
		ListIndex int
	)
	INSERT @GroupByFunction (GroupByID, GroupByFunction, GroupByHeader, ListIndex)
	SELECT	convert(int, splitString.Token) as GroupByID, 
			APP_ReportFilter.FilterFunction,
			ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), ReportFilter) AS GroupByHeader,
			splitString.Position 
	FROM dbo.FNC_SplitString(@GroupByFilterList, ',') as splitString
	LEFT OUTER JOIN APP_ReportFilter ON APP_ReportFilter.ReportFilterID = convert(int, splitString.Token)
    WHERE isnumeric(splitString.Token) = 1 
    ORDER BY splitString.Position 
	
	-- Which responses do we need to filter on, anyway?
	IF (@IsFilterApplied = 1)
	BEGIN
		INSERT #tmpGroupBy (UserID, ResponseID) SELECT @UserID AS UserID, ResponseID FROM TEMP_ResponseFilter WHERE UserID = @UserID GROUP BY ResponseID
	END
	ELSE
	BEGIN
		-- Run a generic filter ourselves (the front end should perhaps do this)
		DECLARE @TempUserID int 
		SET @TempUserID = @UserID
		EXEC APP_Temp_ReportFilter @TempUserID, @DateFrom, @DateTo, @AssessmentTypeID_LIST, NULL, NULL, NULL, @Offline, @SearchLocalChecksIfOffline
		INSERT #tmpGroupBy (UserID, ResponseID) SELECT @UserID AS UserID, ResponseID FROM TEMP_ResponseFilter WHERE UserID = @TempUserID
	END
	
	IF NULLIF(object_id('tempdb..#tmpSingleGroupResult'), 0) IS NOT NULL DROP TABLE #tmpSingleGroupResult
	-- Do some custom grouping if it is set up. This acts like comma seperating results. i.e. Group by BusinessGroup, Department
	CREATE TABLE #tmpSingleGroupResult (
		UserID INT,
		ResponseID int,
		GroupByText nvarchar(255)
	)
	-- remember temp_selected, and set it back to how it was when we started.
	IF NULLIF(object_id('tempdb..#tmpOldSelected'), 0) IS NOT NULL DROP TABLE #tmpOldSelected
	SELECT UserID, SelectedID, SelectedText, SelectedValue INTO #tmpOldSelected FROM TEMP_Selected WHERE UserID = @UserID
	DELETE TEMP_Selected WHERE UserID = @UserID
	INSERT TEMP_Selected (SelectedID, UserID) 
	SELECT ResponseID, @UserID FROM #tmpGroupBy WHERE UserID = @UserID GROUP BY ResponseID
	
	WHILE EXISTS (SELECT * FROM @GroupByFunction)
	BEGIN
		DECLARE @index int, @groupFunction nvarchar(100), @groupByID int, @groupByHeader nvarchar(100), @customSql nvarchar(1000)
		SELECT	@index = min(ListIndex)
		FROM @GroupByFunction
		
		SELECT 	@groupByID = GroupByID,
				@groupByHeader = GroupByHeader,
				@groupFunction = GroupByFunction,
				@customSql = NULL
		FROM @GroupByFunction
		WHERE ListIndex = @index
	
		-- either the custom function runs, *OR* the generic, *OR* the offline, but not more than one.
		IF @SearchOffline = 1
		BEGIN
			INSERT #tmpSingleGroupResult (UserID, ResponseID, GroupByText)
			SELECT @UserID AS UserID, ResponseID, GroupByText FROM dbo.FNC_ReportGrouping_Response_Offline(@UserID, @groupByID)
			WHERE ResponseID NOT IN (SELECT ResponseID FROM #tmpSingleGroupResult WHERE UserID = @UserID)
		END 
		ELSE IF @groupFunction IS NOT NULL
		BEGIN
			SELECT @customSql = 'INSERT #tmpSingleGroupResult (UserID, ResponseID, GroupByText) SELECT ' + convert(nvarchar(10), @UserID) + ', ResponseID, GroupByText FROM dbo.[' + @groupFunction + ']' + 
								'(' + convert(nvarchar(10), @UserID) + ', NULL, NULL, NULL, NULL);' 
			
			IF @customSql IS NOT NULL
				EXECUTE (@customSql)
		END
		ELSE
		BEGIN
			INSERT #tmpSingleGroupResult (UserID, ResponseID, GroupByText)
			SELECT @UserID AS UserID, ResponseID, GroupByText FROM dbo.FNC_ReportGrouping_Response(@UserID, @groupByID)
		END
		
		UPDATE tmp
		SET tmp.GroupByText = CASE WHEN tmp.GroupByText IS NULL THEN '' ELSE tmp.GroupByText + '|' END + ISNULL(single.GroupByText, ''),
			tmp.GroupByHeader = CASE WHEN tmp.GroupByHeader IS NULL THEN '' ELSE tmp.GroupByHeader + '|' END + ISNULL(@GroupByHeader, '')
		FROM #tmpGroupBy tmp
		INNER JOIN #tmpSingleGroupResult single ON tmp.ResponseID = single.ResponseID AND tmp.UserID = single.UserID

		INSERT #tmpGroupBy (UserID, ResponseID, GroupByText, GroupByHeader)
		SELECT @UserID AS UserID, single.ResponseID, ISNULL(single.GroupByText, ''), ISNULL(@GroupByHeader, '')
		FROM #tmpSingleGroupResult single
		WHERE NOT EXISTS (SELECT ResponseID FROM #tmpGroupBy WHERE ResponseID = single.ResponseID AND UserID = single.UserID)
	
		DELETE #tmpSingleGroupResult -- Yes, the whole table.
		DELETE @GroupByFunction WHERE ListIndex = @index
	END	
	
	-- Set TEMP_selected back to how it was:
	DELETE TEMP_Selected WHERE UserID = @UserID
	INSERT TEMP_Selected (UserID, SelectedID, SelectedText, SelectedValue) SELECT UserID, SelectedID, SelectedText, SelectedValue FROM #tmpOldSelected
	IF NULLIF(object_id('tempdb..#tmpOldSelected'), 0) IS NOT NULL DROP TABLE #tmpOldSelected

	-- Finally, update the groupby table in a swift pincer-like motion (quickly, that is).
	DELETE TEMP_ResponseGroupBy WHERE UserID = @UserID
	
	SET NOCOUNT OFF
	INSERT TEMP_ResponseGroupBy (UserID, ResponseID, GroupByHeader, GroupByText)
	SELECT @UserID, ResponseID, GroupByHeader, GroupByText FROM #tmpGroupBy WHERE UserID = @UserID
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_SupplierProfile_SubQuestions')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_SupplierProfile_SubQuestions] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 15/12/2009
-- Description:	Top problems for supplier profile
-- Version:		5
-- =============================================
-- JE TFS 4111: includes Amber checks if Amber set to be rejection
-- JE TFS 4770: 
-- jf tfs 8470: Make relevant changes to RPT_SupplierProfile_SubQuestions so that Question Levels are not returned when ShowQuestionLevelOnReports = 0
-- JF tfs 8706
-- JT TFS 13-38811: Enclose APP_QAFlag in table variable to get speed improvements.
-- =============================================
ALTER PROCEDURE RPT_SupplierProfile_SubQuestions
	@UserID int,
	@Offline bit=0
AS
BEGIN
	--exec RPT_SupplierProfile_SubQuestions 1,0
	DECLARE @ShowQuestionLevelOnReports BIT
	SET @ShowQuestionLevelOnReports = CAST(ISNULL(dbo.FNC_GetOptionValue(109),0) AS bit)

	IF @Offline = 0
	BEGIN
		SET NOCOUNT ON

		DECLARE @tmpRejectFlags TABLE (	QAFlagID int )
		INSERT @tmpRejectFlags (QAFlagID) SELECT QAFlagID FROM APP_QAFlag WHERE IsRejection = 1

		DECLARE @Question TABLE (ResponseID int, Question nvarchar(255), QAFlagID int)
		--Fill red questions to temp table
		--TFS 4770: include QAFlag too, so we can display Amber and Red Rejected
		INSERT INTO @Question (ResponseID, Question, QAFlagID)
		SELECT     QMS_Response.ResponseID, QMS_QuestionPool.Question, flags.QAFlagID
		FROM         QMS_AssessmentQuestion 
		INNER JOIN	QMS_QuestionPool ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID 
		INNER JOIN	QMS_Response ON QMS_AssessmentQuestion.AssessmentID = QMS_Response.AssessmentID 
		INNER JOIN	QMS_ResponseQuestion ON QMS_Response.ResponseID = QMS_ResponseQuestion.ResponseID 
										AND 	QMS_AssessmentQuestion.AssessmentQuestionID = QMS_ResponseQuestion.AssessmentQuestionID 
		INNER JOIN TEMP_Selected ON TEMP_Selected.UserID = @UserID AND QMS_Response.ResponseID = TEMP_Selected.SelectedID 
		INNER JOIN	@tmpRejectFlags flags ON QMS_ResponseQuestion.Recommended_QAFlagID = flags.QAFlagID
	
		IF @ShowQuestionLevelOnReports = 1
			--Fill red question levels
			INSERT INTO @Question (ResponseID, Question, QAFlagID)
			SELECT     ResponseSummary.ResponseID, APP_QuestionLevel.QuestionLevel + ' Defects', APP_QAFlag.QAFlagID
			FROM         APP_AssessmentConstraintType INNER JOIN
								  APP_QuestionLevel ON APP_AssessmentConstraintType.QuestionLevelID = APP_QuestionLevel.QuestionLevelID INNER JOIN
								  QMS_AssessmentConstraint ON 
								  APP_AssessmentConstraintType.AssessmentConstraintTypeID = QMS_AssessmentConstraint.AssessmentConstraintTypeID INNER JOIN
									  (SELECT     QMS_ResponseQuestion.ResponseID, QMS_AssessmentQuestion.AssessmentID, QMS_AssessmentQuestion.QuestionLevelID, 
															   SUM(QMS_ResponseQuestion.Score) AS LevelScore
										FROM          QMS_ResponseQuestion INNER JOIN
															   QMS_Response ON QMS_ResponseQuestion.ResponseID = QMS_Response.ResponseID INNER JOIN
															   QMS_AssessmentQuestion ON QMS_ResponseQuestion.AssessmentQuestionID = QMS_AssessmentQuestion.AssessmentQuestionID INNER JOIN
															   TEMP_Selected ON QMS_Response.ResponseID = TEMP_Selected.SelectedID
										WHERE      (QMS_ResponseQuestion.RecordStatus < 201) AND (TEMP_Selected.UserID = @UserID)
										GROUP BY QMS_ResponseQuestion.ResponseID, QMS_AssessmentQuestion.AssessmentID, QMS_AssessmentQuestion.QuestionLevelID
										HAVING      (SUM(QMS_ResponseQuestion.Score) IS NOT NULL)) AS ResponseSummary ON 
								  QMS_AssessmentConstraint.AssessmentID = ResponseSummary.AssessmentID AND 
								  APP_AssessmentConstraintType.QuestionLevelID = ResponseSummary.QuestionLevelID INNER JOIN
								  APP_QAFlag ON QMS_AssessmentConstraint.QAFlagID = APP_QAFlag.QAFlagID
			WHERE     (QMS_AssessmentConstraint.RecordStatus < 201) AND (QMS_AssessmentConstraint.Constraint_Score_Min IS NOT NULL) AND 
								  (QMS_AssessmentConstraint.Constraint_Score_Max IS NOT NULL) AND (ResponseSummary.LevelScore >= QMS_AssessmentConstraint.Constraint_Score_Min) AND 
								  (ResponseSummary.LevelScore <= QMS_AssessmentConstraint.Constraint_Score_Max) AND (APP_QAFlag.IsRejection = 1) OR
								  (QMS_AssessmentConstraint.RecordStatus < 201) AND (QMS_AssessmentConstraint.Constraint_Score_Min IS NULL) AND 
								  (QMS_AssessmentConstraint.Constraint_Score_Max IS NOT NULL) AND (ResponseSummary.LevelScore <= QMS_AssessmentConstraint.Constraint_Score_Max) AND 
								  (APP_QAFlag.IsRejection = 1) OR
								  (QMS_AssessmentConstraint.RecordStatus < 201) AND (QMS_AssessmentConstraint.Constraint_Score_Min IS NOT NULL) AND 
								  (QMS_AssessmentConstraint.Constraint_Score_Max IS NULL) AND (ResponseSummary.LevelScore >= QMS_AssessmentConstraint.Constraint_Score_Min) AND 
								  (APP_QAFlag.IsRejection = 1)

		SET NOCOUNT OFF

		SELECT     TOP (10) Response_Question.Question, PM_VW_StockCode.DisplayText AS StockCode, COUNT(QMS_Response.ResponseID) AS NumChecks, 
						  SUM(QMS_Response.QuantityAccepted) AS QuantityAccepted,
						  SUM(CASE WHEN Response_Question.QAFlagID = 2 THEN QMS_Response.QuantityRejected ELSE 0 END) AS AmberRejected,
						  SUM(CASE WHEN Response_Question.QAFlagID = 3 THEN QMS_Response.QuantityRejected ELSE 0 END) AS RedRejected,
						  SUM(TEMP_Selected.SelectedValue * QMS_Response.QuantityRejected) AS RejectedValue
		FROM         QMS_Response 
		INNER JOIN	dbo.FNC_ResponseHeader_StockCodeID_Selected(@UserID) AS ResponseHeader_StockCodeID ON QMS_Response.ResponseID = ResponseHeader_StockCodeID.ResponseID 
		INNER JOIN	PM_VW_StockCode ON ResponseHeader_StockCodeID.StockCodeID = PM_VW_StockCode.StockCodeID 
		INNER JOIN	TEMP_Selected ON QMS_Response.ResponseID = TEMP_Selected.SelectedID 
		INNER JOIN	@Question AS Response_Question ON QMS_Response.ResponseID = Response_Question.ResponseID
		WHERE     (TEMP_Selected.UserID = @UserID)
		GROUP BY PM_VW_StockCode.DisplayText, Response_Question.Question--, QuantityRejected
		ORDER BY COUNT(QMS_Response.ResponseID) DESC, sum(QuantityRejected) DESC, Question
	END
	ELSE
	SELECT     TOP (10) QMS_QuestionPool.Question, PM_VW_StockCode.DisplayText AS StockCode, COUNT(QMS_SupplierResponseQuestion.ResponseQuestionID) 
						  AS NumChecks, SUM(QMS_SupplierResponse.QuantityAccepted) AS QuantityAccepted,
						  SUM(CASE WHEN APP_QAFlag.QAFlagID = 2 THEN QMS_SupplierResponse.QuantityRejected ELSE 0 END) AS AmberRejected,
						  SUM(CASE WHEN APP_QAFlag.QAFlagID = 3 THEN QMS_SupplierResponse.QuantityRejected ELSE 0 END) AS RedRejected,
						  SUM(TEMP_Selected.SelectedValue * QMS_SupplierResponse.QuantityRejected) AS RejectedValue
	FROM         QMS_SupplierResponseQuestion INNER JOIN
						  QMS_QuestionPool ON QMS_SupplierResponseQuestion.QuestionID = QMS_QuestionPool.QuestionID INNER JOIN
						  QMS_SupplierResponse ON QMS_SupplierResponseQuestion.ResponseID = QMS_SupplierResponse.ResponseID INNER JOIN
						  PM_VW_StockCode ON QMS_SupplierResponse.StockCodeID = PM_VW_StockCode.StockCodeID INNER JOIN
						  TEMP_Selected ON QMS_SupplierResponse.ResponseID = TEMP_Selected.SelectedID INNER JOIN
						  APP_QAFlag ON QMS_SupplierResponseQuestion.QAFlagID = APP_QAFlag.QAFlagID
	WHERE     (TEMP_Selected.UserID = @UserID) AND (APP_QAFlag.IsRejection = 1)
	GROUP BY QMS_QuestionPool.Question, PM_VW_StockCode.DisplayText, QuantityRejected
	ORDER BY NumChecks DESC, QuantityRejected DESC, QMS_QuestionPool.Question
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_User_ResponseList')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_User_ResponseList] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jonathan Toolan
-- Create date: 08/01/2015
-- Description:	Returns list of responses that user can access
-- Version: 	2
-- =============================================
-- JT TFS 13-38264 - Duplicate functionality from FNC_User_ResponseList but using temp tables for performance gains.
-- JT TFS 13-38264 - Include UserID in output.
-- =============================================
ALTER PROCEDURE [dbo].[QRY_User_ResponseList]
	@UserID int,
	@DateFrom datetime,
	@DateTo datetime
AS
BEGIN

--declare @UserID int, @DateFrom datetime,	@DateTo datetime
--select @UserID = 836, @DateFrom = '1 Jun 2013 00:00:00',  @DateTo = '21 May 2014 23:59:59'

	IF NULLIF(object_id('tempdb..#UnfilteredResponse'), 0) IS NOT NULL DROP TABLE #UnfilteredResponse
	CREATE TABLE #UnfilteredResponse (
		ResponseID int PRIMARY KEY,
		ResponseStatus tinyint,
		LocationID int NULL,
		CustomerID int NULL,
		SupplierID int NULL,
		StockCodeID int NULL,
		QAFlagID int NULL
	)

	--get date reporting warehouse table last built
	DECLARE @WarehouseBuildDate datetime
	SET @WarehouseBuildDate = (SELECT Updated FROM APP_Config WHERE OptionID = 78)

	DECLARE @UserSettingDisplayVoids bit 
	SET @UserSettingDisplayVoids = ISNULL(cast(dbo.FNC_GetUserSetting(@UserID, 'DisplayVoidChecks') as bit), 0)

	-- Lookup user level
	DECLARE @UserLevel int, @RecordStatus tinyint
	SELECT     @UserLevel = ISNULL(UserLevel,0)
	FROM         QMS_User
	WHERE     (UserID = @UserID)
	IF @UserSettingDisplayVoids = 1 -- Include all recordstatuses when we set a report to do the same by setting the User Setting.
		SET @RecordStatus = 255 -- maximum possible. 
	ELSE IF @UserLevel = 1  --Admin can always see hidden/void checks.
		SET @RecordStatus = 201
	ELSE
		SET @RecordStatus = 100

	-- Permissions that this user has.
	DECLARE @PermissionLink TABLE (
		UserID int, SupplierID int, CustomerID int, LocationID int, StockCodeID int, 
		StockCodeSubGroup nvarchar(100), BusinessGroup nvarchar(100)
	)
	INSERT INTO	@PermissionLink (UserID, SupplierID, CustomerID, LocationID, StockCodeID, StockCodeSubGroup, BusinessGroup)
	SELECT	UserID, SupplierID, CustomerID, LocationID, StockCodeID, StockCodeSubGroup, BusinessGroup
	FROM	VW_PermissionLink PermissionLink
	WHERE	PermissionLink.PermissionAllow = 1 AND PermissionLink.PermissionType IN (101,102,103,104,105,106) AND UserID = @UserID

	DECLARE @Table_StockCode TABLE (
		StockCodeID int PRIMARY KEY
	)
	
	--check for permissions in three levels of hierarchy: Business Group, Sub Group, Stock Code, and translate to StockCodeID
	INSERT INTO @Table_StockCode (StockCodeID)
	SELECT		StockCodeID
	FROM        PM_VW_StockCode
	WHERE		BusinessGroup IN (SELECT BusinessGroup FROM @PermissionLink WHERE BusinessGroup IS NOT NULL)
	
	INSERT INTO @Table_StockCode (StockCodeID)
	SELECT		StockCodeID
	FROM        PM_VW_StockCode
	WHERE		StockCodeSubGroup IN (SELECT StockCodeSubGroup FROM @PermissionLink WHERE StockCodeSubGroup IS NOT NULL)
	
	INSERT INTO @Table_StockCode (StockCodeID)
	SELECT		StockCodeID
	FROM        PM_VW_StockCode
	WHERE		StockCodeID IN (SELECT StockCodeID FROM @PermissionLink WHERE StockCodeID IS NOT NULL)

	BEGIN
	IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1 AND @DateTo <= @WarehouseBuildDate --use warehouse table if built within specified date range
		BEGIN
			INSERT INTO	#UnfilteredResponse (ResponseID, ResponseStatus, QAFlagID)
			SELECT		RPT_Warehouse_Response.ResponseID, QMS_Response.ResponseStatus, RPT_Warehouse_Response.QAFlagID --Actual or Override QAFlag setting checked when building warehouse table
			FROM		RPT_Warehouse_Response INNER JOIN
							QMS_Response ON RPT_Warehouse_Response.ResponseID = QMS_Response.ResponseID
			WHERE		(QMS_Response.RecordStatus < @RecordStatus) AND (RPT_Warehouse_Response.EndDate BETWEEN @DateFrom AND @DateTo)
				
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel = 9)
				UPDATE	UnfilteredResponse
				SET	LocationID = RPT_Warehouse_Response.SupplierSiteID
				FROM	#UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
				WHERE ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(RPT_Warehouse_Response.SupplierSiteID,0)
 
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel <> 9)
				UPDATE	UnfilteredResponse
				SET	LocationID = RPT_Warehouse_Response.LocationID
				FROM	#UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
				WHERE ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(RPT_Warehouse_Response.LocationID,0)

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
				UPDATE	UnfilteredResponse
				SET		SupplierID = RPT_Warehouse_Response.SupplierID
				FROM	#UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
				WHERE ISNULL(UnfilteredResponse.SupplierID,0) <> ISNULL(RPT_Warehouse_Response.SupplierID,0)
				
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE CustomerID IS NOT NULL) 
				UPDATE	UnfilteredResponse
				SET		CustomerID = PM_VW_StockCode.CustomerID
				FROM	#UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID INNER JOIN
							PM_VW_StockCode ON RPT_Warehouse_Response.StockCodeID = PM_VW_StockCode.StockCodeID
				WHERE ISNULL(UnfilteredResponse.CustomerID,0) <> ISNULL(PM_VW_StockCode.CustomerID,0)

			IF EXISTS (SELECT StockCodeID FROM @Table_StockCode)
				UPDATE	UnfilteredResponse
				SET		StockCodeID = RPT_Warehouse_Response.StockCodeID
				FROM	#UnfilteredResponse UnfilteredResponse INNER JOIN
							RPT_Warehouse_Response ON UnfilteredResponse.ResponseID = RPT_Warehouse_Response.ResponseID
		END
	ELSE --don't use warehouse table
		BEGIN
			DECLARE @override bit 
			SET @override = CAST(ISNULL(dbo.FNC_GetOptionValue(74),0) AS bit)
			
			INSERT INTO #UnfilteredResponse (ResponseID, ResponseStatus, QAFlagID)
			SELECT ResponseID, ResponseStatus,
					--check config value to use Actual or Override QAFlagID
					CASE WHEN @override = 0 THEN Actual_QAFlagID ELSE ISNULL(Override_QAFlagID, Actual_QAFlagID) END AS QAFlagID
			FROM	QMS_Response
			WHERE	(RecordStatus < @RecordStatus) AND (EndDate BETWEEN @DateFrom AND @DateTo)
			
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel = 9)
				UPDATE	UnfilteredResponse
				SET		LocationID = Location.LocationID
				FROM	#UnfilteredResponse UnfilteredResponse INNER JOIN
							QMS_ResponseHeader ON UnfilteredResponse.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
							QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
							PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
				WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 53) and
				ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(Location.LocationID,0)

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE LocationID IS NOT NULL) AND (@UserLevel <> 9)
				UPDATE	UnfilteredResponse
				SET		LocationID = Location.LocationID
				FROM	#UnfilteredResponse UnfilteredResponse INNER JOIN
							QMS_ResponseHeader ON UnfilteredResponse.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
							QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
							PM_VW_Location AS Location ON QMS_ResponseHeader.Header_SourceID = Location.LocationID
				WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 4) and 
				ISNULL(UnfilteredResponse.LocationID,0) <> ISNULL(Location.LocationID,0)

			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE SupplierID IS NOT NULL)
				UPDATE	UnfilteredResponse
				SET		SupplierID = QMS_ResponseHeader.Header_SourceID
				FROM	#UnfilteredResponse UnfilteredResponse INNER JOIN
							QMS_ResponseHeader ON UnfilteredResponse.ResponseID = QMS_ResponseHeader.ResponseID INNER JOIN
							QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
				WHERE   (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 1) AND
				ISNULL(UnfilteredResponse.SupplierID,0) <> ISNULL(QMS_ResponseHeader.Header_SourceID,0)
				
			IF EXISTS (SELECT UserID FROM @PermissionLink WHERE CustomerID IS NOT NULL) 
				UPDATE	UnfilteredResponse
				SET		CustomerID = PM_VW_StockCode.CustomerID
				FROM	#UnfilteredResponse UnfilteredResponse INNER JOIN
							dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponse.ResponseID = HeaderStockCode.ResponseID INNER JOIN
							PM_VW_StockCode ON PM_VW_StockCode.StockCodeID = HeaderStockCode.StockCodeID
				WHERE ISNULL(UnfilteredResponse.CustomerID,0) <> ISNULL(PM_VW_StockCode.CustomerID,0)

			IF EXISTS (SELECT StockCodeID FROM @Table_StockCode)
				UPDATE	UnfilteredResponse
				SET		StockCodeID = HeaderStockCode.StockCodeID
				FROM	#UnfilteredResponse UnfilteredResponse INNER JOIN
							dbo.FNC_ResponseHeader_StockCodeID() HeaderStockCode ON UnfilteredResponse.ResponseID = HeaderStockCode.ResponseID
				where ISNULL(UnfilteredResponse.StockCodeID,0) <> ISNULL(HeaderStockCode.StockCodeID,0)
		END
	END


	DECLARE @HasLocations  bit; 	SELECT @HasLocations  = CASE WHEN EXISTS (SELECT LocationID  FROM @PermissionLink WHERE LocationID  IS NOT NULL) THEN 1 ELSE 0 END
	DECLARE @HasCustomers  bit; 	SELECT @HasCustomers  = CASE WHEN EXISTS (SELECT CustomerID  FROM @PermissionLink WHERE CustomerID  IS NOT NULL) THEN 1 ELSE 0 END
	DECLARE @HasSuppliers  bit; 	SELECT @HasSuppliers  = CASE WHEN EXISTS (SELECT SupplierID  FROM @PermissionLink WHERE SupplierID  IS NOT NULL) THEN 1 ELSE 0 END
	DECLARE @HasStockcodes bit;		SELECT @HasStockcodes = CASE WHEN EXISTS (SELECT StockCodeID FROM @Table_StockCode) THEN 1 ELSE 0 END


	-- Only return responses which match the filter specified, or for which we do not have a filter.
	-- This means that admin users (any user with no permissions set) can see all responses.
	SELECT	@UserID UserID, ResponseID, ResponseStatus, QAFlagID
	FROM	#UnfilteredResponse UnfilteredResponse
	WHERE (	NOT @HasLocations = 1
		OR	LocationID IN (SELECT LocationID FROM @PermissionLink WHERE LocationID IS NOT NULL) )
	AND (	NOT @HasSuppliers = 1
		OR	SupplierID IN (SELECT SupplierID FROM @PermissionLink WHERE SupplierID IS NOT NULL) )
	AND (	NOT @HasCustomers = 1
		OR	CustomerID IN (SELECT CustomerID FROM @PermissionLink WHERE CustomerID IS NOT NULL) )
	AND (	StockCodeID IS NULL -- Allow unlinked stockcode responses
		OR	NOT @HasStockcodes = 1
		OR	StockCodeID IN (SELECT StockCodeID FROM @Table_StockCode) )
	
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_StockCode_RawMaterialCombo')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_StockCode_RawMaterialCombo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Taj Sehdev
-- Create date: 06/01/2015
-- Description:	Sp for data lookup of Raw Material
-- Version: 1
-- =============================================
-- Tfs 13-37822
-- =============================================
ALTER PROCEDURE PM_QRY_StockCode_RawMaterialCombo
	-- Add the parameters for the stored procedure here
	@UserID int = NULL,
	@StockCodeID int = NULL
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
	IF @StockCodeID IS NOT NULL 
	BEGIN
		SELECT		StockCode.StockCodeID as RawMaterialStockCodeID, StockCode.DisplayText
		FROM		PM_VW_StockCode StockCode
		WHERE	StockCode.StockTypeID = 1
		AND		StockCode.Hide = 0
		AND		StockCode.ParentStockCodeID = @StockCodeID
		ORDER BY StockCode.DisplayText
	END
	ELSE
	BEGIN
		SELECT		StockCode.StockCodeID as RawMaterialStockCodeID, StockCode.DisplayText
		FROM		PM_VW_StockCode StockCode
		INNER JOIN	dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON StockCode.StockCodeID = User_StockCode.StockCodeID
		WHERE	StockCode.StockTypeID = 1
		AND		StockCode.Hide = 0
		ORDER BY StockCode.DisplayText
	END
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'PM_QRY_ConsignmentItem_Quantity_Lookup')
	EXEC ('CREATE PROCEDURE [dbo].[PM_QRY_ConsignmentItem_Quantity_Lookup] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Taj Sehdev	
-- Create date: 16/12/15
-- Description:	Trigger for quantity ordered by consignment item and stock code
-- version: 2
-- tfs 13- 33338
-- jf 20/1/16 - just updated to re deploy
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_ConsignmentItem_Quantity_Lookup] 
	-- Add the parameters for the stored procedure here
	@ConsignmentID int = NULL,
	@ConsignmentItemID int = NULL,
	@StockCodeID int = NULL
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for procedure here
SELECT     Quantity
FROM         PM_VW_ConsignmentItems
WHERE     (StockCodeID = @StockCodeID) AND (ConsignmentID = @ConsignmentID) AND (ConsignmentItemID = @ConsignmentItemID)
END
GO


PRINT 'Sorting sync procedures...'

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_GoodsIntake')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_GoodsIntake] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		unknown
-- Create date: 18/12/2008
-- Description:	imports data into the mobile PM_GoodsIntake table
-- Version:		5
-- =============================================
-- jf tfs 18253 - added @PalletStockCodeID
-- jf tfs 29101 - added storeid
-- jf TFS 23605 - make sure no date conversions happen
-- jf tfs 32575 - add @CountryID and @Alias
-- =============================================

ALTER PROCEDURE [dbo].[SYNC_Import_PM_GoodsIntake] 
	@GoodsIntakeID int,
	@SupplierID int,
	@ConsignmentItemID int,
	@LocationID int,
	@ItemCount real,
	@UnitQuantity int,
	@PalletNo int,
	@NetWeight real = NULL,
	@DeliveryID int,
	@DateArrived datetime,
	@SupplierRef nvarchar(50),
	@Barcode nvarchar(50),
	@OriginalBarcode nvarchar(50) = NULL,
	@UserGroupID int,
	@HarvestDate datetime,
	@SupplierLotNo nvarchar(50),
	@Comments nvarchar(255),
	@UnitStockCodeID int = NULL,
	@E_Text1 nvarchar(50) = NULL,
	@E_Text2 nvarchar(50) = NULL,
	@E_Numeric1 int = NULL,
	@E_Numeric2 int = NULL,
	@E_DateTime1 datetime = NULL,
	@PalletID INT = NULL,
	@Certified BIT = NULL,
	@ArrivalTemp REAL = NULL,
	@E_Numeric3 REAL = NULL,
	@Updated DATETIME = NULL,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@PalletStockCodeID int,
	@StoreID int = null,
	@CountryID int = NULL,
	@Alias nvarchar(50) = NULL,

	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

SET @DateArrived = dbo.FNC_ConvertServerDate(@DateArrived)
SET @HarvestDate = dbo.FNC_ConvertServerDate(@HarvestDate)
SET @E_DateTime1 = dbo.FNC_ConvertServerDate(@E_DateTime1)

IF @Certified IS NULL
	SET @Certified = 0
	
IF NOT EXISTS(SELECT * FROM PM_GoodsIntake WHERE (GoodsIntakeID = @GoodsIntakeID))
BEGIN --Append record
	IF @RecordStatus < 201 AND EXISTS(SELECT ConsignmentID FROM PM_ConsignmentItems WHERE (ConsignmentItemID = @ConsignmentItemID))
	BEGIN
		INSERT INTO PM_GoodsIntake
                      (GoodsIntakeID, SupplierID, ConsignmentItemID, LocationID, ItemCount, UnitQuantity, PalletNo, NetWeight, DeliveryID, DateArrived, SupplierRef, SupplierLotNo, Comments, 
                      UserGroupID, HarvestDate, Barcode, UnitStockCodeID, OriginalBarcode, E_Text1, E_Text2, E_Numeric1, E_Numeric2, E_DateTime1, PalletID, Certified, ArrivalTemp, 
                      E_Numeric3, Updated, RecordStatus, GUID,PalletStockCodeID,StoreID, CountryID, Alias)
		VALUES     (@GoodsIntakeID,@SupplierID,@ConsignmentItemID,@LocationID,@ItemCount,@UnitQuantity,@PalletNo,@Netweight,@DeliveryID,@DateArrived,@SupplierRef,@SupplierLotNo,@Comments,@UserGroupID,@HarvestDate,@Barcode,@UnitStockCodeID,@OriginalBarcode,@E_Text1,@E_Text2,@E_Numeric1,@E_Numeric2,@E_DateTime1,@PalletID,@Certified,@ArrivalTemp,@E_Numeric3,@Updated,@RecordStatus,@GUID,@PalletStockCodeID,@StoreID, @CountryID, @Alias)
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    PM_GoodsIntake
	SET              SupplierID = @SupplierID, ConsignmentItemID = @ConsignmentItemID, LocationID = @LocationID, DeliveryID = @DeliveryID, ItemCount = @ItemCount, 
                      UnitQuantity = @UnitQuantity, PalletNo = @PalletNo, NetWeight = @Netweight, DateArrived = @DateArrived, SupplierRef = @SupplierRef, Barcode = @Barcode, 
                      SupplierLotNo = @SupplierLotNo, Comments = @Comments, UserGroupID = @UserGroupID, HarvestDate = @HarvestDate, UnitStockCodeID = @UnitStockCodeID, 
                      OriginalBarcode = @OriginalBarcode, E_Text1 = @E_Text1, E_Text2 = @E_Text2, E_Numeric1 = @E_Numeric1, E_Numeric2 = @E_Numeric2, 
                      E_DateTime1 = @E_DateTime1, PalletID = @PalletID, Certified = @Certified, ArrivalTemp = @ArrivalTemp, E_Numeric3 = @E_Numeric3, Updated = @Updated, 
                      RecordStatus = @RecordStatus, PalletStockCodeID=@PalletStockCodeID,StoreID=@StoreID,CountryID=@CountryID,Alias=@Alias
	WHERE     (GoodsIntakeID = @GoodsIntakeID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO


PRINT 'Data migration tasks...'

PRINT 'Database updated successfully!'
GO
