-- =============================================
-- Author:		Jeremy Formby
-- Create date: 10/07/2015
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO



PRINT 'Sorting tables...'

-- BEGIN DATA MOBILE_Index_PM_GoodsIntake
BEGIN TRY
IF NOT EXISTS (SELECT * FROM dbo.sysindexes WHERE id=OBJECT_ID(N'[dbo].[PM_GoodsIntake]') and name='IX_GoodIntake_Barcode')
	CREATE NONCLUSTERED INDEX IX_GoodIntake_Barcode ON PM_GoodsIntake ([Barcode])

END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA MOBILE_Index_PM_GoodsIntake'
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA MOBILE_Index_PM_GoodsIntake

-- BEGIN DATA MOBILE_PM_Consignment

BEGIN TRY
--this is to update mobile database as they are different from office
IF NOT EXISTS (SELECT * FROM sys.tables t INNER JOIN sys.columns c ON t.object_id = c.object_id WHERE t.name = 'PM_Consignment' AND c.name = 'Text3' )

	alter table PM_Consignment add
		Text3 nvarchar(100),
		Text4 nvarchar(100),
		CountryCode  nvarchar(100)

		  
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA PM_Consignment'
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA MOBILE_PM_Consignment


PRINT 'Sorting indexes...'


PRINT 'Sorting Views...'

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'PM_VW_Consignment')
	EXEC ('CREATE VIEW [dbo].[PM_VW_Consignment] AS SELECT 1 as ''stub version, to be replaced''')
GO
-- ===================================================
-- Author:		Unknown
-- Create date:	1 Jan 2010
-- Description:	View consignments from PM_Consignment
-- Version:		6
-- ===================================================
-- JT TFS 4405: Added E_POType column
-- JF: Added Comments column
-- MP TFS 2798: Added CustomerID column
-- jf tfs 19129 - added Text1, Text2, Hide
-- jf tfs 22919 - add text3,4 and country
-- ===================================================
ALTER VIEW [dbo].[PM_VW_Consignment]
AS
SELECT        ConsignmentID, LEFT('000000', 6 - LEN(CAST(ConsignmentID AS nvarchar))) + CAST(ConsignmentID AS nvarchar) AS ConsignmentNo, SupplierID, OrderRef, OrderDate, DateRequired, E_PO, LocationID, 
                         OrderStatus, WatchList, E_POType, Comments, CustomerID, Text1, Text2, Text3, Text4,CountryCode , Hide, GUID, RowVersion, Created, RecordStatus, Updated
FROM            dbo.PM_Consignment
WHERE        (OrderStatus > 1) AND (Hide = 0) AND (RecordStatus < 201)

GO


PRINT 'Sorting User Defined Functions...'

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_TrimCaseEndBarCode')
	EXEC('CREATE FUNCTION [dbo].[FNC_TrimCaseEndBarCode]() RETURNS bit AS BEGIN RETURN 0 END')
GO
-- =============================================
-- Author:		MBS\Phil.Harding
-- Create date: 20/07/2015
-- Description:	Trims brackets, check characters, date code, etc from CaseEndBarcode to produce resolved version
-- Version:		1
-- =============================================
-- PH TFS 13-24218 20/07/2015: Refactoring - Added because logic used in more than one Function
-- =============================================
ALTER FUNCTION [dbo].[FNC_TrimCaseEndBarcode] 
(
	@CaseEndBarcode nvarchar(100)
)
RETURNS nvarchar(100)
AS
BEGIN
	DECLARE @SupplierID int
	--Remove any brackets from barcode
	SET @CaseEndBarcode = REPLACE(@CaseEndBarcode,'(','')
	SET @CaseEndBarcode = REPLACE(@CaseEndBarcode,')','')
	--Trim barcode if check characters exist at start/end
	IF LEN(@CaseEndBarcode) > 3
	BEGIN
		IF LEFT(@CaseEndBarcode,3) = ']C1'
			SET @CaseEndBarcode = SUBSTRING(@CaseEndBarcode,4,LEN(@CaseEndBarcode)-3)
		SET @CaseEndBarcode = SUBSTRING(@CaseEndBarcode,4,LEN(@CaseEndBarcode))
	END
	--Remove last 8 characters as contains date code and check digit
	IF LEN(@CaseEndBarcode) > 6 SET @CaseEndBarcode = SUBSTRING(@CaseEndBarcode, 0, LEN(@CaseEndBarcode) - 7)
	
	RETURN @CaseEndBarcode
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_CaseEndToSupplier')
	EXEC('CREATE FUNCTION [dbo].[FNC_CaseEndToSupplier]() RETURNS bit AS BEGIN RETURN 0 END')
GO
-- =============================================
-- Author:		Markp
-- Create date: 16/11/2009
-- Description:	Gets SupplierID from Case end barcode
-- Version:		3
-- JT TFS 5403 - 21/11/2012: Stopped substring error on bad lengths
-- =============================================
-- PH TFS 13-24218 20/07/2015: Refactoring - Implemented FNC_TrimCaseEndBarCode because logic used in more than one Function
-- =============================================

ALTER FUNCTION [dbo].[FNC_CaseEndToSupplier] 
(
	@CaseEndBarcode nvarchar(100)
)
RETURNS int
AS
BEGIN
	DECLARE @SupplierID int

	--Trim/resolve barcode
	SET @CaseEndBarcode = dbo.FNC_TrimCaseEndBarcode(@CaseEndBarcode)
	
	--Select stock code with matching TUC code
	SELECT     @SupplierID = SupplierID
	FROM         PM_VW_StockCodePack
	WHERE     (CaseEndBarcode = @CaseEndBarcode)
	--Return Supplier ID
	RETURN @SupplierID
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_CaseEndToStockCodePack')
	EXEC('CREATE FUNCTION [dbo].[FNC_CaseEndToStockCodePack]() RETURNS bit AS BEGIN RETURN 0 END')
GO
-- =============================================
-- Author:		Markp
-- Create date: 17/11/2009
-- Description:	Gets StockCodePackID from Case end barcode
-- Version:		2
-- =============================================
-- PH TFS 13-24218 20/07/2015: Refactoring - Implemented FNC_TrimCaseEndBarCode because logic used in more than one Function
-- =============================================

ALTER FUNCTION [dbo].[FNC_CaseEndToStockCodePack] 
(
	@CaseEndBarcode nvarchar(100)
)
RETURNS int
AS
BEGIN
	DECLARE @StockCodePackID int

	--Trim/resolve barcode
	SET @CaseEndBarcode = dbo.FNC_TrimCaseEndBarcode(@CaseEndBarcode)
	
	--Select stock code with matching TUC code
	SELECT     @StockCodePackID = StockCodePackID
	FROM         PM_VW_StockCodePack
	WHERE     (CaseEndBarcode = @CaseEndBarcode)
	--Return stock code ID
	RETURN @StockCodePackID
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_CaseEndToStockCode')
	EXEC('CREATE FUNCTION [dbo].[FNC_CaseEndToStockCode]() RETURNS bit AS BEGIN RETURN 0 END')
GO
-- =============================================
-- Author		:	Markp
-- Create date	:	02/04/2009
-- Description	:	Gets StockCodeID from Case end barcode
-- Version		:	2
-- =============================================
-- PH TFS 13-24218 20/07/2015: Refactoring - Implemented FNC_TrimCaseEndBarCode because logic used in more than one Function
-- =============================================

ALTER FUNCTION [dbo].[FNC_CaseEndToStockCode] 
(
	@CaseEndBarcode nvarchar(100)
)
RETURNS int
AS
BEGIN
	DECLARE @StockCodeID int

	--Trim/resolve barcode
	SET @CaseEndBarcode = dbo.FNC_TrimCaseEndBarcode(@CaseEndBarcode)
	
	--Select stock code with matching TUC code
	SELECT     @StockCodeID = StockCodeID
	FROM         PM_VW_StockCodePack
	WHERE     (CaseEndBarcode = @CaseEndBarcode)
	--Return stock code ID
	RETURN @StockCodeID
END
GO


PRINT 'Sorting Stored Procedures...'


PRINT 'Sorting sync procedures...'

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_Delivery')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_Delivery] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		jmf	
-- Create date: 21/4/15
-- Description:	Updates mobile data from the sync
-- Version:		2
-- =============================================
--jf TFS 23605 - make sure no date conversions happen
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_PM_Delivery] 
	@DeliveryID int,
	@LocationID int,
	@SupplierID int,
	@LorryNo int,
	@Haulier nvarchar(50),
	@LorryReg nvarchar(20),
	@Driver nvarchar(50),
	@DispatchDate datetime,
	@ArrivalDate datetime,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

SET @DispatchDate = dbo.FNC_ConvertServerDate(@DispatchDate)
SET @ArrivalDate = dbo.FNC_ConvertServerDate(@ArrivalDate)

IF NOT EXISTS(SELECT * FROM PM_Delivery WHERE (DeliveryID = @DeliveryID))
BEGIN --Append record
	IF @RecordStatus < 201
	BEGIN
		INSERT INTO PM_Delivery
                      (DeliveryID, LocationID, SupplierID, LorryNo, Haulier, LorryReg, Driver, DispatchDate, ArrivalDate, RecordStatus, GUID)
		VALUES     (@DeliveryID,@LocationID,@SupplierID,@LorryNo,@Haulier,@LorryReg,@Driver,@DispatchDate,@ArrivalDate,@RecordStatus,@GUID)
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    PM_Delivery
	SET              SupplierID = @SupplierID, LorryNo = @LorryNo, Haulier = @Haulier, LorryReg = @LorryReg, Driver = @Driver, DispatchDate = @DispatchDate, 
                      ArrivalDate = @ArrivalDate, RecordStatus = @RecordStatus
	WHERE     (DeliveryID = @DeliveryID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_StockBatchItems')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_StockBatchItems] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		jf
-- Create date: 11/2/15
-- Description:	Imort StockBatchItems
-- Version:		3
-- =============================================
-- jf 11/2/15 - added @TotalQuantity
-- jf tfs 20519- - check if PM_StockBatch exists before inserting to avoid foreign key errors
--jf TFS 23605 - make sure no date conversions happen
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_PM_StockBatchItems] 
	@StockItemID int, 
	@StockBatchID INt, 
	@StockCodeID int, 
	@SupplierID int, 
	@UseByDate datetime, 
	@RecordStatus tinyint, 
	@Source tinyint, 
	@Updated datetime,  
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@TotalQuantity decimal(18,2),

	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

SET @UseByDate = dbo.FNC_ConvertServerDate(@UseByDate)

IF NOT EXISTS(SELECT StockItemID FROM PM_StockBatchItems WHERE (StockItemID = @StockItemID))
BEGIN --Append record
	IF @RecordStatus < 201 and EXISTS(SELECT StockBatchID FROM PM_StockBatch WHERE (StockBatchID  = @StockBatchID))
	BEGIN
		INSERT INTO PM_StockBatchItems
						(StockBatchID, StockCodeID, SupplierID, UseByDate, RecordStatus, Source, Updated, GUID, TotalQuantity )
                      --(StockBatchID, BatchType, LocationID, Barcode, BatchRef, QAStatus, DateAdded, DateClosed, ExpiryDate, Closed, RecordStatus, GUID)
		VALUES     (@StockBatchID,@StockCodeID,@SupplierID,@UseByDate,@RecordStatus,@Source,@Updated,@GUID,@TotalQuantity)
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    PM_StockBatchItems
	SET              StockBatchID=@StockBatchID, StockCodeID=@StockCodeID, SupplierID=@SupplierID, UseByDate=@UseByDate, RecordStatus=@RecordStatus, Source=@Source, Updated=@Updated, TotalQuantity=@TotalQuantity
	WHERE     (StockItemID = @StockItemID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_StockBatch')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_StockBatch] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		jmf	
-- Create date: 21/4/15
-- Description:	Updates mobile data from the sync
-- Version:		1
-- =============================================
--jf TFS 23605 - make sure no date conversions happen
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_PM_StockBatch] 
	@StockBatchID int,
	@BatchType tinyint,
	@LocationID int,
	@Barcode nvarchar(50),
	@BatchRef nvarchar(50),
	@QAStatus int,
	@DateAdded DATETIME = NULL,
	@DateClosed DATETIME = NULL,
	@Closed bit,
	@ExpiryDate DATETIME = NULL,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

SET @DateAdded = dbo.FNC_ConvertServerDate(@DateAdded)
SET @DateClosed = dbo.FNC_ConvertServerDate(@DateClosed)
SET @ExpiryDate = dbo.FNC_ConvertServerDate(@ExpiryDate)

IF NOT EXISTS(SELECT * FROM PM_StockBatch WHERE (StockBatchID = @StockBatchID))
BEGIN --Append record
	IF @RecordStatus < 201
	BEGIN
		INSERT INTO PM_StockBatch
                      (StockBatchID, BatchType, LocationID, Barcode, BatchRef, QAStatus, DateAdded, DateClosed, ExpiryDate, Closed, RecordStatus, GUID)
		VALUES     (@StockBatchID,@BatchType,@LocationID,@Barcode,@BatchRef,@QAStatus,@DateAdded,@DateClosed,@ExpiryDate,@Closed,@RecordStatus,@GUID)
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    PM_StockBatch
	SET              LocationID = @LocationID, Barcode = @Barcode, BatchRef = @BatchRef, QAStatus = @QAStatus, DateAdded = @DateAdded, DateClosed = @DateClosed, 
                      ExpiryDate = @ExpiryDate, Closed = @Closed, RecordStatus = @RecordStatus
	WHERE     (StockBatchID = @StockBatchID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_ConsignmentItems')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_ConsignmentItems] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		jmf	
-- Create date: 21/4/15
-- Description:	Updates mobile data from the sync
-- Version:		2
-- =============================================
-- jf TFS 19430 added @VersionNo
--jf TFS 23605 - make sure no date conversions happen
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_PM_ConsignmentItems] 
	@ConsignmentItemID int,
	@ConsignmentID int,
	@StockCodeID int,
	@Quantity real,
	@UnitStockCodeID int,
	@UnitQuantity real,
	@QuantityAccepted real,
	@DepotDate datetime,
	@UnitPrice money,
	@Comments nvarchar(1000) = NULL,
	@DateRequired DATETIME = NULL,
	@E_POItem NVARCHAR(20) = NULL,
	@Hide BIT = NULL,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@VersionNo INT,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

SET @DepotDate = dbo.FNC_ConvertServerDate(@DepotDate)
SET @DateRequired = dbo.FNC_ConvertServerDate(@DateRequired)

IF @Hide  IS NULL
	SET @Hide = 0

IF NOT EXISTS(SELECT * FROM PM_ConsignmentItems WHERE (ConsignmentItemID = @ConsignmentItemID))
BEGIN --Append record
	IF @RecordStatus < 201 AND EXISTS(SELECT ConsignmentID FROM PM_Consignment WHERE (ConsignmentID = @ConsignmentID))
	BEGIN
		INSERT INTO PM_ConsignmentItems
                      (ConsignmentItemID, ConsignmentID, StockCodeID, Quantity, UnitStockCodeID, UnitQuantity, QuantityAccepted, DepotDate, UnitPrice, Comments, DateRequired, 
                      E_POItem, Hide, RecordStatus, GUID,VersionNo)
		VALUES     (@ConsignmentItemID,@ConsignmentID,@StockCodeID,@Quantity,@UnitStockCodeID,@UnitQuantity,@QuantityAccepted,@DepotDate,@UnitPrice,@Comments,@DateRequired,@E_POItem,@Hide,@RecordStatus,@GUID,@VersionNo)
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    PM_ConsignmentItems
	SET              StockCodeID = @StockCodeID, Quantity = @Quantity, UnitStockCodeID = @UnitStockCodeID, UnitQuantity = @UnitQuantity, QuantityAccepted = @QuantityAccepted, 
                      DepotDate = @DepotDate, UnitPrice = @UnitPrice, Comments = @Comments, DateRequired = @DateRequired, E_POItem = @E_POItem, Hide = @Hide, 
                      RecordStatus = @RecordStatus, VersionNo=@VersionNo
	WHERE     (ConsignmentItemID = @ConsignmentItemID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_GoodsIntake')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_GoodsIntake] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		unknows
-- Create date: 18/12/2008
-- Description:	imports data
-- Version:		3
-- =============================================
-- jf tfs 18253 - added @PalletStockCodeID
--jf TFS 23605 - make sure no date conversions happen
-- =============================================

ALTER PROCEDURE [dbo].[SYNC_Import_PM_GoodsIntake] 
	@GoodsIntakeID int,
	@SupplierID int,
	@ConsignmentItemID int,
	@LocationID int,
	@ItemCount real,
	@UnitQuantity int,
	@PalletNo int,
	@NetWeight real = NULL,
	@DeliveryID int,
	@DateArrived datetime,
	@SupplierRef nvarchar(50),
	@Barcode nvarchar(50),
	@OriginalBarcode nvarchar(50) = NULL,
	@UserGroupID int,
	@HarvestDate datetime,
	@SupplierLotNo nvarchar(50),
	@Comments nvarchar(255),
	@UnitStockCodeID int = NULL,
	@E_Text1 nvarchar(50) = NULL,
	@E_Text2 nvarchar(50) = NULL,
	@E_Numeric1 int = NULL,
	@E_Numeric2 int = NULL,
	@E_DateTime1 datetime = NULL,
	@PalletID INT = NULL,
	@Certified BIT = NULL,
	@ArrivalTemp REAL = NULL,
	@E_Numeric3 REAL = NULL,
	@Updated DATETIME = NULL,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@PalletStockCodeID int,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

SET @DateArrived = dbo.FNC_ConvertServerDate(@DateArrived)
SET @HarvestDate = dbo.FNC_ConvertServerDate(@HarvestDate)
SET @E_DateTime1 = dbo.FNC_ConvertServerDate(@E_DateTime1)

IF @Certified IS NULL
	SET @Certified = 0
	
IF NOT EXISTS(SELECT * FROM PM_GoodsIntake WHERE (GoodsIntakeID = @GoodsIntakeID))
BEGIN --Append record
	IF @RecordStatus < 201 AND EXISTS(SELECT ConsignmentID FROM PM_ConsignmentItems WHERE (ConsignmentItemID = @ConsignmentItemID))
	BEGIN
		INSERT INTO PM_GoodsIntake
                      (GoodsIntakeID, SupplierID, ConsignmentItemID, LocationID, ItemCount, UnitQuantity, PalletNo, NetWeight, DeliveryID, DateArrived, SupplierRef, SupplierLotNo, Comments, 
                      UserGroupID, HarvestDate, Barcode, UnitStockCodeID, OriginalBarcode, E_Text1, E_Text2, E_Numeric1, E_Numeric2, E_DateTime1, PalletID, Certified, ArrivalTemp, 
                      E_Numeric3, Updated, RecordStatus, GUID,PalletStockCodeID)
		VALUES     (@GoodsIntakeID,@SupplierID,@ConsignmentItemID,@LocationID,@ItemCount,@UnitQuantity,@PalletNo,@Netweight,@DeliveryID,@DateArrived,@SupplierRef,@SupplierLotNo,@Comments,@UserGroupID,@HarvestDate,@Barcode,@UnitStockCodeID,@OriginalBarcode,@E_Text1,@E_Text2,@E_Numeric1,@E_Numeric2,@E_DateTime1,@PalletID,@Certified,@ArrivalTemp,@E_Numeric3,@Updated,@RecordStatus,@GUID,@PalletStockCodeID)
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    PM_GoodsIntake
	SET              SupplierID = @SupplierID, ConsignmentItemID = @ConsignmentItemID, LocationID = @LocationID, DeliveryID = @DeliveryID, ItemCount = @ItemCount, 
                      UnitQuantity = @UnitQuantity, PalletNo = @PalletNo, NetWeight = @Netweight, DateArrived = @DateArrived, SupplierRef = @SupplierRef, Barcode = @Barcode, 
                      SupplierLotNo = @SupplierLotNo, Comments = @Comments, UserGroupID = @UserGroupID, HarvestDate = @HarvestDate, UnitStockCodeID = @UnitStockCodeID, 
                      OriginalBarcode = @OriginalBarcode, E_Text1 = @E_Text1, E_Text2 = @E_Text2, E_Numeric1 = @E_Numeric1, E_Numeric2 = @E_Numeric2, 
                      E_DateTime1 = @E_DateTime1, PalletID = @PalletID, Certified = @Certified, ArrivalTemp = @ArrivalTemp, E_Numeric3 = @E_Numeric3, Updated = @Updated, 
                      RecordStatus = @RecordStatus, PalletStockCodeID=@PalletStockCodeID
	WHERE     (GoodsIntakeID = @GoodsIntakeID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_Consignment')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_Consignment] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		jmf	
-- Create date: 21/4/15
-- Description:	Updates mobile data from the sync
-- Version:		2
-- =============================================
-- jf TFS 18595 added text1 and text2 to the import
--jf tfs 22919 added text 3,4 and countrycode
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_PM_Consignment] 
	@ConsignmentID int,
	@SupplierID int,
	@OrderRef nvarchar(50),
	@OrderDate datetime,
	@DateRequired datetime,
	@E_PO nvarchar(50),
	@LocationID int,
	@OrderStatus int,
	@WatchList nvarchar(1),
	@E_POType NVARCHAR(10) = NULL,
	@Comments NVARCHAR(1000) = NULL,
	@CustomerID INT = NULL,
	@Hide BIT = NULL,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@Text1  nvarchar(100),
	@Text2 nvarchar(100),
	@Text3 nvarchar(100),
	@Text4 nvarchar(100),
	@CountryCode nvarchar(100),

	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

SET @OrderDate = dbo.FNC_ConvertServerDate(@OrderDate)
SET @DateRequired = dbo.FNC_ConvertServerDate(@DateRequired)

IF @Hide IS NULL
	SET @Hide=0

IF NOT EXISTS(SELECT * FROM PM_Consignment WHERE (ConsignmentID = @ConsignmentID))
BEGIN --Append record
	IF @RecordStatus < 201 AND EXISTS(SELECT SupplierID FROM PM_Supplier WHERE (SupplierID = @SupplierID) OR @SupplierID IS NULL)
	BEGIN
		INSERT INTO PM_Consignment
                      (ConsignmentID, SupplierID, OrderRef, OrderDate, DateRequired, E_PO, LocationID, OrderStatus, WatchList, E_POType, Comments, CustomerID, Hide, RecordStatus, 
                      GUID,Text1,Text2,Text3,Text4,CountryCode)
		VALUES     (@ConsignmentID,@SupplierID,@OrderRef,@OrderDate,@DateRequired,@E_PO,@LocationID,@OrderStatus,@WatchList,@E_POType,@Comments,@CustomerID,@Hide,@RecordStatus,@GUID, @Text1,@Text2,@Text3,@Text4,@CountryCode )
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    PM_Consignment
	SET              SupplierID = @SupplierID, OrderRef = @OrderRef, OrderDate = @OrderDate, DateRequired = @DateRequired, E_PO = @E_PO, LocationID = @LocationID, 
                      OrderStatus = @OrderStatus, WatchList = @WatchList, E_POType = @E_POType, Comments = @Comments, CustomerID = @CustomerID, Hide = @Hide, 
                      RecordStatus = @RecordStatus,
					  Text1 = @Text1 , Text2 = @Text2 ,Text3 = @Text3,Text4 = @Text4,CountryCode = @CountryCode

	WHERE     (ConsignmentID = @ConsignmentID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_CorrectiveAction')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_CorrectiveAction] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 01/08/2008
-- Description:	Saves corrective action
-- Version:		15
-- =============================================
-- j.toolan 21 Feb 2012: Added ReminderDate
-- j.toolan  7 Mar 2012: Reset NotifcationSent on 6 if AssignSupplierID set (only if status changes)
-- MP TFS 5873 - Made sure SourceObjectID updated so that correct links to response created
-- JE TFS 7087 - added CorrectiveActionTypeID to UPDATE statement
-- JE TFS 7877 - corrected resetting of NotifcationSent for Completed alerts
-- JE TFS 7836 - updated to save LocationID CA is assigned
-- JT TFS 13-7950 - Make sure that if CorrectiveActionTypeID is specified, and CorrectiveActionEscalationID is NOT, then set it.
-- JE TFS 13-12635: call new SAVE_CorrectiveActionUser SP to save permissions data to QMS_CorrectiveActionUser table
-- MP TFS 13-15377: excluded call to new SAVE_CorrectiveActionUser SP for mobile
-- AC TFS 6335: Changes the escalation if the corrective action type or notification user group is changed
-- PH TFS 13-19579: 06/05/2015 - Made compatible with WebChecks service/EF.  @CorrectiveActionID must have default (null or zero) because stripped out by EF when adding record and @CorrectiveActionID must be returned AS CorrectiveActionID.
-- PH TFS 13-21031: 10/06/2015 - Got rid of code smell that may have been causing bug.  New CorrectiveActionID obtained OUTPUT INSERTED.CorrectiveActionID INTO @caIdTable
-- PH TFS 13-23902: 15/07/2015 - SourceObjectID is nullable, so parameter should not be mandatory when saving an Ad Hoc corrective action
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_CorrectiveAction]
	@CorrectiveActionID int = NULL,
	@CASourceID int,
	@SourceObjectID int = NULL,
	@CATitle nvarchar(50),
	@CASubTitle nvarchar(50),
	@CAReason nvarchar(1000),
	@CARequired nvarchar(1000),
	@CAStatusID int,
	@CorrectiveActionTypeID int,
	@CorrectiveActionEscalationID int,
	@NotificationGroupID int,
	@AssignUserID int,
	@DateOccurred datetime,
	@PriorityLevelID int,
	@DateLogged datetime,
	@DateDeadline datetime,
	@ActionTaken nvarchar(1000),
	@Comments nvarchar(1000),
	@DateCompleted datetime,
	@Completed_UserID int,
	@Completed_MachineName nvarchar(50),
	@DateSignedOff datetime,
	@SignOff_UserID int,
	@SignOff_MachineName nvarchar(50),
	@UserID int,
	@AssignSupplierID int,
	@ReminderDate datetime,
	@ReminderSent bit = NULL, -- This is not saved currently.
	@LocationID int
AS
BEGIN
	SET NOCOUNT ON

	-- BUG 7950 SP FIX
	SELECT @LocationID = NULLIF(@LocationID, 0) -- Do not allow zero for LocationID. It stops first new CA alert going out.

	DECLARE @DefaultCorrectiveActionEscalationID int
	SELECT @DefaultCorrectiveActionEscalationID = CorrectiveActionEscalationID 
	FROM QMS_CorrectiveActionEscalation 
	WHERE CorrectiveActionTypeID = @CorrectiveActionTypeID
	AND ListIndex = (	SELECT min(ListIndex) FROM QMS_CorrectiveActionEscalation 
						WHERE CorrectiveActionTypeID = @CorrectiveActionTypeID)
	-- END BUG 7950 fix

	IF ISNULL(@CorrectiveActionID,0)=0 --New record
	BEGIN
		DECLARE @caIdTable TABLE (CorrectiveActionID int)

		INSERT INTO QMS_CorrectiveAction
						  (CASourceID, SourceObjectID, CATitle, CASubTitle, CAReason, CARequired, CAStatusID, CorrectiveActionTypeID, CorrectiveActionEscalationID, NotificationGroupID, 
						  AssignUserID, DateOccurred, PriorityLevelID, DateLogged, DateDeadline, Logged_UserID, Logged_MachineName, ActionTaken, Comments, DateCompleted, 
						  Completed_UserID, Completed_MachineName, AssignSupplierID, ReminderDate, LocationID)
				OUTPUT INSERTED.CorrectiveActionID INTO @caIdTable
		VALUES     (@CASourceID,@SourceObjectID,@CATitle,@CASubTitle,@CAReason,@CARequired,@CAStatusID,@CorrectiveActionTypeID,
					ISNULL(@CorrectiveActionEscalationID, @DefaultCorrectiveActionEscalationID),
					@NotificationGroupID,@AssignUserID,@DateOccurred,@PriorityLevelID,@DateLogged,@DateDeadline,@UserID,
						   HOST_NAME(),@ActionTaken,@Comments,@DateCompleted,@Completed_UserID,@Completed_MachineName,@AssignSupplierID, @ReminderDate, @LocationID)
	                      
		--Get new ID
		SELECT     @CorrectiveActionID = MAX(CorrectiveActionID)
		FROM         @caIdTable
	END
	ELSE --Update record
	BEGIN
		DECLARE @originalCAStatusID int
		SELECT	@originalCAStatusID = CAStatusID 
		FROM	QMS_CorrectiveAction
		WHERE	CorrectiveActionID = @CorrectiveActionID
		
		DECLARE @originalCorrectiveActionTypeID int
		DECLARE @originalNotificationGroupID int
		
		SELECT	@originalCorrectiveActionTypeID = CorrectiveActionTypeID, @originalNotificationGroupID = NotificationGroupID
		FROM	QMS_CorrectiveAction
		WHERE	CorrectiveActionID = @CorrectiveActionID
		
		-- Only update the escalation if the corrective action type or the notification user group has changed
		IF (@originalCorrectiveActionTypeID <> @CorrectiveActionTypeID OR @originalNotificationGroupID <> @NotificationGroupID)
		BEGIN
			SET @CorrectiveActionEscalationID = NULL
			SELECT @CorrectiveActionEscalationID = CorrectiveActionEscalationID
			FROM QMS_CorrectiveActionEscalation
			WHERE CorrectiveActionTypeId = @CorrectiveActionTypeId
			AND NotificationGroupId = @NotificationGroupId
		END

		UPDATE    QMS_CorrectiveAction
		SET              SourceObjectID = @SourceObjectID, CATitle = @CATitle, CASubTitle = @CASubTitle, CAReason = @CAReason, CARequired = @CARequired, 
							  CAStatusID = @CAStatusID, CorrectiveActionTypeID = @CorrectiveActionTypeID, NotificationGroupID = @NotificationGroupID, AssignUserID = @AssignUserID, DateOccurred = @DateOccurred, 
							  PriorityLevelID = @PriorityLevelID, DateDeadline = @DateDeadline, ActionTaken = @ActionTaken, Comments = @Comments, DateCompleted = @DateCompleted, 
							  Completed_UserID = @Completed_UserID, Completed_MachineName = @Completed_MachineName, DateSignedOff = @DateSignedOff, 
							  SignOff_UserID = @SignOff_UserID, SignOff_MachineName = @SignOff_MachineName, 
							  RecordStatus = CASE WHEN RecordStatus = 30 THEN 20 ELSE RecordStatus END, Updated = GETUTCDATE(), AssignSupplierID = @AssignSupplierID, 
							  ReminderDate = @ReminderDate, LocationID = @LocationID, CorrectiveActionEscalationID = @CorrectiveActionEscalationID
		WHERE     (CorrectiveActionID = @CorrectiveActionID)

		-- Only update notification flag if the status has changed.
		IF (@originalCAStatusID <> @CAStatusID)
		BEGIN
				--get Failure_NotificationGroupID for current CA escalation
			DECLARE @Failure_NotificationGroupID int 
			SELECT     @Failure_NotificationGroupID = Failure_NotificationGroupID
			FROM         QMS_CorrectiveActionEscalation
			WHERE     (CorrectiveActionEscalationID = @CorrectiveActionEscalationID)

			--if CA being set to Complete and a Failure_NotificationGroup has been set, reset NotificationGroup flag
			IF @CAStatusID = 4 --AND @Failure_NotificationGroupID IS NOT NULL --removed for TFS 7877 as this stops Completed alerts firing when no Failure_NotificationGroupID set
			BEGIN
				UPDATE	QMS_CorrectiveAction
				SET		NotificationSent = 0
				WHERE	(CorrectiveActionID = @CorrectiveActionID)
			END
			
				--if CA being set to Signed-off and AssignSupplierID has been set, reset NotificationGroup flag
			IF @CAStatusID IN (5, 6) AND @AssignSupplierID IS NOT NULL
			BEGIN
				UPDATE	QMS_CorrectiveAction
				SET		NotificationSent = 0
				WHERE	(CorrectiveActionID = @CorrectiveActionID)
			END
		END
	END
	SET NOCOUNT OFF

	--save data for CA to QMS_CorrectiveActionUser (should handle both new and updated CAs as @CorrectiveActionID is set either way)
    IF DB_NAME() LIKE 'GreenlightQC_Mobile%'
        BEGIN --Add current user to current corrective action
            IF NOT EXISTS ( SELECT  CorrectiveActionID
                            FROM    dbo.QMS_CorrectiveActionUser
                            WHERE   UserID = @UserID
                                    AND CorrectiveActionID = @CorrectiveActionID )
                INSERT  INTO dbo.QMS_CorrectiveActionUser
                        ( CorrectiveActionID, UserID )
                VALUES  ( @CorrectiveActionID, -- CorrectiveActionID - int
                          @UserID -- UserID - int
                          )
        END
    ELSE
        EXEC SAVE_CorrectiveActionUser @CorrectiveActionID
	

	SELECT @CorrectiveActionID AS CorrectiveActionID
END

GO



PRINT 'Data migration tasks...'

PRINT 'Database updated successfully!'
GO
