-- =============================================
-- Author:		Jeremy Formby
-- Create date: 27/05/2015
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO



PRINT 'Sorting tables...'


PRINT 'Sorting indexes...'


PRINT 'Sorting Views...'


PRINT 'Sorting User Defined Functions...'


PRINT 'Sorting Stored Procedures...'

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_AssessmentQuestion_List')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_AssessmentQuestion_List] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 22/07/2008
-- Description:	Gets list of questions for specified assessment
-- Version: 7
-- =============================================
-- JE TFS 5069 - added DataLookupDataTypeID column
-- JE TFS 6268 - added DataSource column
-- JE TFS 6892 - added Numeric Min and Max columns (used in MCC)
-- JE TFS 13-6548: added DisplayWarning column
-- JE TFS 13-9479: LEFT OUTER JOIN to APP_QuestionLevel so NULL QuestionLevelID records aren't filtered out
-- JF tfs 20297 - Prevent the question responses from copying if Allow copy = false (return CopyRepeatCheck)
-- =============================================
ALTER PROCEDURE [dbo].[QRY_AssessmentQuestion_List] 
	@AssessmentID int
AS

SELECT     'QMS_AssessmentQuestion' AS DataSource, QMS_AssessmentQuestion.AssessmentQuestionID, FNC_AssessmentQuestion_Sort.QuestionNumber AS SortNumber,
				QMS_QuestionPool.Question, QMS_AssessmentQuestion.ParentQuestionID, FNC_AssessmentQuestion_Sort.QuestionLevel,
				QMS_AssessmentQuestion.DataTypeID, QMS_AssessmentQuestion.DataLookupID, QMS_AssessmentQuestion.CustomLookupID, QMS_AssessmentQuestion.QuestionLevelID,
				APP_QuestionLevel.DisplayWarning,
				QMS_AssessmentQuestion.GuidanceID, QMS_AssessmentQuestion.ShortGuidance, QMS_AssessmentQuestion.HasSamples, 
				QMS_AssessmentQuestion.ResponseRequired, QMS_AssessmentQuestion.ScoreCalculationID, QMS_AssessmentQuestion.Hide, QMS_QuestionPool.Sys_Question, 
				QMS_AssessmentQuestion.ResponseFormula, QMS_AssessmentQuestion.ScoreFormula, QMS_AssessmentQuestion.Sample_DataTypeID, 
				QMS_AssessmentQuestion.InstrumentID, QMS_AssessmentQuestion.SampleSummaryID, QMS_AssessmentQuestion.LookupAssessmentQuestionID,
				QMS_AssessmentQuestion.LookupSampleSet,
				(SELECT		DataTypeID --TFS 5069
					FROM		APP_DataLookup
					WHERE	(DataLookupID = QMS_AssessmentQuestion.DataLookupID)) AS DataLookupDataTypeID,
				QMS_AssessmentQuestion.Acceptable_Numeric_Min, QMS_AssessmentQuestion.Acceptable_Numeric_Max,QMS_QuestionPool.CopyRepeatCheck
FROM         QMS_AssessmentQuestion INNER JOIN
                      dbo.FNC_AssessmentQuestion_Sort(@AssessmentID) AS FNC_AssessmentQuestion_Sort ON 
                      QMS_AssessmentQuestion.AssessmentQuestionID = FNC_AssessmentQuestion_Sort.AssessmentQuestionID INNER JOIN
                      QMS_QuestionPool ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID LEFT OUTER JOIN
					  APP_QuestionLevel ON QMS_AssessmentQuestion.QuestionLevelID = APP_QuestionLevel.QuestionLevelID
WHERE     (QMS_AssessmentQuestion.AssessmentID = @AssessmentID) AND (QMS_AssessmentQuestion.RecordStatus < 201) AND (QMS_QuestionPool.RecordStatus < 201)
ORDER BY FNC_AssessmentQuestion_Sort.SortIndex1, FNC_AssessmentQuestion_Sort.SortIndex2, FNC_AssessmentQuestion_Sort.SortIndex3, 
                      FNC_AssessmentQuestion_Sort.SortIndex4

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SP_ClearAllData_Mobile')
	EXEC ('CREATE PROCEDURE [dbo].[SP_ClearAllData_Mobile] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 16/09/2008
-- Description:	Procedure to clear all Mobile specific data and reset ID's
-- Version:		2
-- =============================================
ALTER PROCEDURE [dbo].[SP_ClearAllData_Mobile] 
	@Password nvarchar(50)
AS

--***WARNING*** This procedure will clear all data

IF NOT @Password = N'muddy'
	RETURN 0

--Sync tables - no identity columns

PRINT 'SYNC_ClientGuid'
DELETE FROM SYNC_ClientGuid

PRINT 'SYNC_ClientAnchor'
DELETE FROM SYNC_ClientAnchor

PRINT 'SYNC_OfflineSpec'
DELETE FROM SYNC_OfflineSpec

PRINT 'SYNC_OfflineSpecStockCode'
DELETE FROM SYNC_OfflineSpecStockCode
DBCC CHECKIDENT ('SYNC_OfflineSpecStockCode', RESEED, 1)

PRINT 'SYNC_Config'
DELETE FROM SYNC_Config

PRINT 'SYNC_Log'
DELETE FROM SYNC_Log
DBCC CHECKIDENT ('SYNC_Log', RESEED, 1)

--Produce Manager tables - no identity columns

PRINT 'PM_StockCodeLocation'
DELETE FROM PM_StockCodeLocation

PRINT 'PM_Consignment'
DELETE FROM PM_Consignment

PRINT 'PM_ConsignmentItems'
DELETE FROM PM_ConsignmentItems

PRINT 'PM_Delivery'
DELETE FROM PM_Delivery

PRINT 'PM_GoodsIntake'
DELETE FROM PM_GoodsIntake

PRINT 'PM_Location'
DELETE FROM PM_Location

PRINT 'PM_ProductionJob'
DELETE FROM PM_ProductionJob

PRINT 'PM_ProductionJobLine'
DELETE FROM PM_ProductionJobLine

PRINT 'PM_StockCodePack'
DELETE FROM PM_StockCodePack

PRINT 'PM_StockCodeMix'
DELETE FROM PM_StockCodeMix

PRINT 'PM_StockCode'
DELETE FROM PM_StockCode

PRINT 'PM_Supplier'
DELETE FROM PM_Supplier

PRINT 'PM_Customer'
DELETE FROM PM_Customer

PRINT 'PM_UserGroup'
DELETE FROM PM_UserGroup

PRINT 'PM_Region'
DELETE FROM PM_Region

PRINT 'PM_StockBatch'
DELETE FROM PM_StockBatch

PRINT 'PM_StockBatchSource'
DELETE FROM PM_StockBatchSource

--Delete all questions as system questions will not be deleted in main clear-out

PRINT 'QMS_QuestionPool'
DELETE FROM QMS_QuestionPool
DBCC CHECKIDENT ('QMS_QuestionPool', RESEED, 1)
GO



IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SP_ClearAllData')
	EXEC ('CREATE PROCEDURE [dbo].[SP_ClearAllData] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 16/09/2008
-- Description:	Procedure to clear all data and reset ID's
-- Version:		2
-- =============================================
ALTER PROCEDURE [dbo].[SP_ClearAllData] 
	@Password nvarchar(50)
AS

--***WARNING*** This procedure will clear all data

IF NOT @Password = N'muddy'
	RETURN 0

--Temp tables
PRINT 'Clear temp tables'
DELETE FROM TEMP_ResponseHeader
DELETE FROM TEMP_Selected
DELETE FROM TEMP_SelectedItem

--Unreferences tables

PRINT 'QMS_UserPermissions'
DELETE FROM QMS_UserPermissions
DBCC CHECKIDENT ('QMS_UserPermissions', RESEED, 1)

PRINT 'QMS_UserLog'
DELETE FROM QMS_UserLog
DBCC CHECKIDENT ('QMS_UserLog', RESEED, 1)

PRINT 'QMS_UserPassword'
DELETE FROM QMS_UserPassword
DBCC CHECKIDENT ('QMS_UserPassword', RESEED, 1)

PRINT 'QMS_UserFailedLogins'
DELETE FROM QMS_UserFailedLogins
DBCC CHECKIDENT ('QMS_UserFailedLogins', RESEED, 1)

PRINT 'QMS_Task'
DELETE FROM QMS_Task
DBCC CHECKIDENT ('QMS_Task', RESEED, 1)

PRINT 'QMS_RecordLock'
DELETE FROM QMS_RecordLock
DBCC CHECKIDENT ('QMS_RecordLock', RESEED, 1)

PRINT 'QMS_Notification'
DELETE FROM QMS_Notification
DBCC CHECKIDENT ('QMS_Notification', RESEED, 1)

PRINT 'QMS_ErrorLog'
DELETE FROM QMS_ErrorLog
DBCC CHECKIDENT ('QMS_ErrorLog', RESEED, 1)

PRINT 'QMS_Attachment'
DELETE FROM QMS_Attachment
DBCC CHECKIDENT ('QMS_Attachment', RESEED, 1)

PRINT 'QMS_CountryRegion'
DELETE FROM QMS_CountryRegion
DBCC CHECKIDENT ('QMS_CountryRegion', RESEED, 1)

PRINT 'QMS_CountryAlias'
DELETE FROM QMS_CountryAlias
--Set high reseed value because it is used with country lookup
DBCC CHECKIDENT ('QMS_CountryAlias', RESEED, 1000)

PRINT 'QMS_CustomReport'
DELETE FROM QMS_CustomReport
DBCC CHECKIDENT ('QMS_CustomReport', RESEED, 1)

PRINT 'QMS_CustomAlert'
DELETE FROM QMS_CustomAlert
DBCC CHECKIDENT ('QMS_CustomAlert', RESEED, 1)

--Responses

PRINT 'QMS_ResponseQuestionSample'
DELETE FROM QMS_ResponseQuestionSample
DBCC CHECKIDENT ('QMS_ResponseQuestionSample', RESEED, 1)

PRINT 'QMS_ResponseQuestion'
DELETE FROM QMS_ResponseQuestion
DBCC CHECKIDENT ('QMS_ResponseQuestion', RESEED, 1)

PRINT 'QMS_ResponseHeaderMulti'
DELETE FROM QMS_ResponseHeaderMulti
DBCC CHECKIDENT ('QMS_ResponseHeaderMulti', RESEED, 1)

PRINT 'QMS_ResponseHeader'
DELETE FROM QMS_ResponseHeader
DBCC CHECKIDENT ('QMS_ResponseHeader', RESEED, 1)

PRINT 'QMS_ResponseAction'
DELETE FROM QMS_ResponseAction
DBCC CHECKIDENT ('QMS_ResponseAction', RESEED, 1)

PRINT 'QMS_Response'
DELETE FROM QMS_Response
DBCC CHECKIDENT ('QMS_Response', RESEED, 1)

PRINT 'QMS_SupplierResponseQuestion'
DELETE FROM QMS_SupplierResponseQuestion

PRINT 'QMS_SupplierResponse'
DELETE FROM QMS_SupplierResponse

--Assessments

PRINT 'QMS_AssessmentTarget'
DELETE FROM QMS_AssessmentTarget
DBCC CHECKIDENT ('QMS_AssessmentTarget', RESEED, 1)

PRINT 'QMS_AssessmentSchedule'
DELETE FROM QMS_AssessmentSchedule
DBCC CHECKIDENT ('QMS_AssessmentSchedule', RESEED, 1)

PRINT 'QMS_AssessmentSampleConstraint'
DELETE FROM QMS_AssessmentSampleConstraint
DBCC CHECKIDENT ('QMS_AssessmentSampleConstraint', RESEED, 1)

PRINT 'QMS_AssessmentQuestionConstraint'
DELETE FROM QMS_AssessmentQuestionConstraint
DBCC CHECKIDENT ('QMS_AssessmentQuestionConstraint', RESEED, 1)

PRINT 'QMS_AssessmentQuestion'
DELETE FROM QMS_AssessmentQuestion
DBCC CHECKIDENT ('QMS_AssessmentQuestion', RESEED, 1)

PRINT 'QMS_AssessmentHeader'
DELETE FROM QMS_AssessmentHeader
DBCC CHECKIDENT ('QMS_AssessmentHeader', RESEED, 1)

PRINT 'QMS_AssessmentConstraint'
DELETE FROM QMS_AssessmentConstraint
DBCC CHECKIDENT ('QMS_AssessmentConstraint', RESEED, 1)

PRINT 'QMS_AssessmentSpecHeader'
DELETE FROM QMS_AssessmentSpecHeader
DBCC CHECKIDENT ('QMS_AssessmentSpecHeader', RESEED, 1)

PRINT 'QMS_Assessment'
DELETE FROM QMS_Assessment
DBCC CHECKIDENT ('QMS_Assessment', RESEED, 1)

--Corrective actions

PRINT 'QMS_AssessmentTypeCAType'
DELETE FROM QMS_AssessmentTypeCAType
DBCC CHECKIDENT ('QMS_AssessmentTypeCAType', RESEED, 1)

PRINT 'QMS_CorrectiveActionEscalation'
DELETE FROM QMS_CorrectiveActionEscalation
DBCC CHECKIDENT ('QMS_CorrectiveActionEscalation', RESEED, 1)

PRINT 'QMS_CorrectiveActionType'
DELETE FROM QMS_CorrectiveActionType
DBCC CHECKIDENT ('QMS_CorrectiveActionType', RESEED, 1)

PRINT 'QMS_CorrectiveAction'
DELETE FROM QMS_CorrectiveAction
DBCC CHECKIDENT ('QMS_CorrectiveAction', RESEED, 1)

--Lookup data

PRINT 'QMS_NotificationSetup'
DELETE FROM QMS_NotificationSetup
DBCC CHECKIDENT ('QMS_NotificationSetup', RESEED, 1)

PRINT 'QMS_NotificationGroupUser'
DELETE FROM QMS_NotificationGroupUser
DBCC CHECKIDENT ('QMS_NotificationGroupUser', RESEED, 1)

PRINT 'QMS_NotificationGroup'
DELETE FROM QMS_NotificationGroup
DBCC CHECKIDENT ('QMS_NotificationGroup', RESEED, 1)

PRINT 'QMS_User'
DELETE FROM QMS_User
WHERE     (UserID <> 1)
DBCC CHECKIDENT ('QMS_User', RESEED, 2)

PRINT 'QMS_CustomLookupItem'
DELETE FROM QMS_CustomLookupItem
DBCC CHECKIDENT ('QMS_CustomLookupItem', RESEED, 1)

PRINT 'QMS_CustomLookup'
DELETE FROM QMS_CustomLookup
DBCC CHECKIDENT ('QMS_CustomLookup', RESEED, 1)

PRINT 'QMS_QuestionPool'
DELETE FROM QMS_QuestionPool WHERE Sys_Question IS NULL
DECLARE @MaxQuestionID int
SELECT @MaxQuestionID=ISNULL(MAX(QuestionID),0)+1 FROM QMS_QuestionPool
DBCC CHECKIDENT ('QMS_QuestionPool', RESEED, @MaxQuestionID)
UPDATE QMS_QuestionPool SET Created = 1

PRINT 'QMS_Guidance'
DELETE FROM QMS_Guidance
DBCC CHECKIDENT ('QMS_Guidance', RESEED, 1)

PRINT 'QMS_Hotsheet'
DELETE FROM QMS_Hotsheet
DBCC CHECKIDENT ('QMS_Hotsheet', RESEED, 1)

PRINT 'QMS_SpecificationHeader'
DELETE FROM QMS_SpecificationHeader
DBCC CHECKIDENT ('QMS_SpecificationHeader', RESEED, 1)

PRINT 'QMS_CustomResource'
DELETE FROM QMS_CustomResource
DBCC CHECKIDENT ('QMS_CustomResource', RESEED, 1)
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Company_AdminList')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Company_AdminList] AS SELECT ''stub version, to be replaced''')
GO
-- ===================================================
-- Author:		Jonathan Toolan
-- Create date:	28 Jun 2012
-- Description:	Get the list of Companies for admin purposes
-- Version:		2
-- ===================================================
-- JT TFS 7835 - Added IsDefault
-- ===================================================
ALTER PROCEDURE QRY_Company_AdminList
	@UserID int = NULL,
	@ShowHidden bit = 1
AS
BEGIN
	SELECT CompanyID, CompanyName, Hide, QMS_Attachment.AttachmentID, QMS_Attachment.AttachmentFileName as 'Filename', IsDefault
	FROM QMS_Company
	LEFT OUTER JOIN QMS_Attachment	ON	QMS_Company.CompanyID = QMS_Attachment.SourceObjectID 
									AND QMS_Attachment.AttachmentSourceID = 5 -- Company Logo
									AND QMS_Attachment.RecordStatus < 201
	WHERE QMS_Company.RecordStatus < 201
	AND (ISNULL(@ShowHidden, 1) = 1 OR Hide = 0)
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_PerformanceSummary_Chart')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_PerformanceSummary_Chart] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 09/04/2009
-- Description:	Gets data for performance summary report graph
-- version:		4
-- =============================================
-- jmf TFS 6839 - The Bar chart should show red amber and green results (currently only shows red)
-- JT TFS 7316 - Bar chart no longer rounds to integer values
-- JT TFS 13-10520 - Bar chart can report percentages for volumes (but not score)
-- =============================================
ALTER PROCEDURE dbo.RPT_PerformanceSummary_Chart 
	@UserID int,
	@GroupBy int,
	@SortBy int,
	@SortHighToLow bit = 1
AS
BEGIN
	SET NOCOUNT ON
	DECLARE @Mode char(1)
	SELECT @Mode = CASE WHEN @SortBy IN (4,5,8,9,12,13) THEN 'V'
						ELSE 'C' END

	SET NOCOUNT OFF

	SELECT     TOP (30) 
		GroupByText, 
		ChartData, 
		@SortBy AS SortBy, 

		CASE @Mode 
			WHEN 'V' THEN
				CASE WHEN ISNULL(VolumeReceived,0) > 0 THEN (100.0 * VolumeGreen) / VolumeReceived ELSE 0.0 END
			ELSE
				CASE WHEN ISNULL(numchecks,0) > 0 THEN (100.0 * NumGreen) / NumChecks ELSE 0.0 END
		END	AS Green,

		CASE @Mode 
			WHEN 'V' THEN
				CASE WHEN ISNULL(VolumeReceived,0) > 0 THEN (100.0 * VolumeAmber) / VolumeReceived ELSE 0.0 END
			ELSE
				CASE WHEN ISNULL(numchecks,0) > 0 THEN (100.0 * NumAmber) / NumChecks ELSE 0.0 END
		END	AS Amber,

		CASE @Mode 
			WHEN 'V' THEN
				CASE WHEN ISNULL(VolumeReceived,0) > 0 THEN (100.0 * VolumeRed) / VolumeReceived ELSE 0.0 END
			ELSE
				CASE WHEN ISNULL(numchecks,0) > 0 THEN (100.0 * NumRed) / NumChecks ELSE 0.0 END
		END	AS Red
	FROM         dbo.FNC_PerformanceReport(@UserID, @GroupBy, @SortBy) AS PerformanceReport
	ORDER BY CASE WHEN @SortHighToLow = 1 THEN 0 - SortIndex ELSE SortIndex END, CASE WHEN @SortHighToLow = 1 THEN 0 - SortIndex2 ELSE SortIndex2 END, 
						  GroupByText
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_QuestionResponse_RemoveSelected')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_QuestionResponse_RemoveSelected] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Adam C
-- Create date: 26/02/15
-- Description:	Further filters down the TEMP_Selected for the
--				question response report so the max allowed count 
--				check is more accurate
-- Version:		2
-- =============================================
-- JT TFS 13-17901: 1 Jun 2015 - Don't remove responses which don't have any recommended flags at all.
-- =============================================
ALTER PROCEDURE RPT_QuestionResponse_RemoveSelected
(
	@UserID INTEGER,
    @ShowGreen BIT,
	@ShowAmber BIT,
	@ShowRed BIT,
	@AssessmentType INTEGER
) 
AS
BEGIN

	DECLARE @ValidSelectedID TABLE (SelectedID INTEGER)
	INSERT INTO @ValidSelectedID
	SELECT DISTINCT SelectedID FROM TEMP_Selected 
	INNER JOIN QMS_Response ON TEMP_Selected.SelectedID = QMS_Response.ResponseID 
	INNER JOIN QMS_Assessment ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID 
	INNER JOIN QMS_ResponseQuestion ON QMS_ResponseQuestion.ResponseID = QMS_Response.ResponseID
	WHERE TEMP_Selected.UserID = @UserID
	AND (QMS_ResponseQuestion.Response_Text IS NOT NULL)
	AND (	(@ShowGreen = 1 AND QMS_ResponseQuestion.Recommended_QAFlagID = 1)
		OR	(@ShowAmber = 1 AND QMS_ResponseQuestion.Recommended_QAFlagID = 2)
		OR	(@ShowRed = 1   AND QMS_ResponseQuestion.Recommended_QAFlagID = 3)
		OR	(@ShowGreen = 1 AND @ShowAmber = 1 AND @ShowRed = 1) -- Ensure logic for inlcuding responses is the same as in RPT_QuestionResponse.
	)
	AND QMS_Assessment.AssessmentTypeId = @AssessmentType

	DELETE FROM TEMP_Selected
	WHERE UserID = @UserID
	AND NOT EXISTS (SELECT SelectedID FROM @ValidSelectedID VS WHERE VS.SelectedID = TEMP_Selected.SelectedID)

END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_User')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_User] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 30/06/2008
-- Description:	Adds and edits user details
-- Version:		10
-- =============================================
-- J.Toolan 13 Feb 2012: Stopped code from adding more than one username
-- J.Toolan 8 Mar 2012: Added SHA2 password field to update/insert
-- MarkP 1 Jun 2012: Made sure UserPermissions.Updated is set
-- JToolan 12 Jun 2012: TFS 3905 - Stopped Password resetting on NULL entry.
-- JT TFS 6629 - Use UP_User_Password to write passwords.
-- JT TFS 13-11261 - Add new admin users to the AdminAlerts group (ignore existing users).
-- JT TFS 13-11810 - User can have their CustomerID changed when only one specified.
-- JT TFS 13-17956 - Creating a user or updating and changing the supplier should trigger a corrective action rebuild.
-- JT TFS 13-21321 - Only trigger a ca rebuild on new user or change to any one of userlevel, usergroup, supplier, customer or LeftCompany
-- =============================================
ALTER PROCEDURE dbo.SAVE_User 
	@UserID int,
	@FullName nvarchar(255),
	@UserName nvarchar(255),
	@Password nvarchar(255) = NULL,
	@Position nvarchar(255),
	@Company nvarchar(255),
	@EMail nvarchar(100),
	@Mobile nvarchar(50),
	@PIN nvarchar(10),
	@LeftCompany bit,
	@UserLevel int,
	@LocaleID int,
	@IsUserGroup bit,
	@ParentUserID int,
	@SupplierID int = NULL,
	@CustomerID int = NULL,
	@Password_MD5 nvarchar(255) = NULL,
	@Password_SHA2 nvarchar(255) = NULL
AS
BEGIN 
	SET NOCOUNT ON

	-- Find out if a CA rebuild is required or not (it's a very expensive operation)
	-- only trigger on new user, or change to any one of userlevel, usergroup, supplier, customer or LeftCompany
	DECLARE @IsCARebuildRequired bit
	BEGIN
		DECLARE @originalSupplier TABLE (SupplierID int)
		INSERT @originalSupplier (SupplierID)
		SELECT  CAST(PermissionTitle AS int)
		FROM         QMS_UserPermissions
		WHERE	(PermissionType = 101) 
		AND		(PermissionAllow = 1)
		AND		(UserID = @UserID)

		DECLARE @originalCustomer TABLE (CustomerID int)
		INSERT @originalCustomer (CustomerID)
		SELECT  CAST(PermissionTitle AS int)
		FROM         QMS_UserPermissions
		WHERE	(PermissionType = 102) 
		AND		(PermissionAllow = 1)
		AND		(UserID = @UserID)

		DECLARE @originalParentUserID int, @originalUserLevel int, @originalLeftCompany bit
		SELECT @originalParentUserID = ParentUserID, @originalUserLevel = UserLevel, @originalLeftCompany = LeftCompany
		FROM QMS_User
		WHERE UserID = @UserID

		DECLARE @originalSupplierID int 
		SELECT @originalSupplierID = CASE	WHEN (SELECT count(*) FROM @originalSupplier) > 1 THEN -1
											ELSE (SELECT TOP 1 SupplierID FROM @originalSupplier) END

		DECLARE @originalCustomerID int 
		SELECT @originalCustomerID = CASE	WHEN (SELECT count(*) FROM @originalCustomer) > 1 THEN -1
											ELSE (SELECT TOP 1 CustomerID FROM @originalCustomer) END

		SELECT @IsCARebuildRequired = CASE	WHEN ISNULL(@UserID,0) = 0 THEN 1 -- yes for new users.
											WHEN ISNULL(@SupplierID, 0) <> ISNULL(@originalSupplierID, 0) THEN 1
											WHEN ISNULL(@CustomerID, 0) <> ISNULL(@originalCustomerID, 0) THEN 1
											WHEN ISNULL(@ParentUserID, 0) <> ISNULL(@originalParentUserID, 0) THEN 1
											WHEN ISNULL(@UserLevel, 0) <> ISNULL(@originalUserLevel, 0) THEN 1
											WHEN ISNULL(@LeftCompany, 0) <> ISNULL(@originalLeftCompany, 0) THEN 1
											ELSE 0 END
	END

	IF ISNULL(@UserID,0)=0 --New user
	BEGIN
		IF NOT EXISTS (SELECT * FROM QMS_User WHERE RecordStatus < 201 AND UserName = @UserName COLLATE Latin1_General_ci_ai)
		BEGIN
			INSERT INTO QMS_User(FullName,	UserName,	Position,	EMail,	Mobile,		PIN,	LeftCompany,	UserLevel,	LocaleID,	IsUserGroup,	ParentUserID,	Company)
			VALUES				(@FullName,	@UserName,	@Position,	@EMail,	@Mobile,	@PIN,	@LeftCompany,	@UserLevel,	@LocaleID,	@IsUserGroup,	@ParentUserID,	@Company)
			--Get new UserID
			SELECT @UserID = SCOPE_IDENTITY()
		
			EXEC UP_User_Password @UserName, @Password, @Password_MD5, @Password_SHA2

			-- INSERT INTO ADMIN NOTIFICATION GROUP 11261

			DECLARE @NotificationGroupID int
			SELECT @NotificationGroupID = NotificationGroupID
			FROM QMS_NotificationGroup WHERE Sys_Group = 'AdminAlerts'

			INSERT QMS_NotificationGroupUser (NotificationGroupID, UserID, RecordStatus)
			SELECT @NotificationGroupID, UserID, 2
			FROM QMS_User 
			WHERE dbo.FNC_GetUserLevel(UserID) = 1 
			AND RecordStatus < 201
			AND UserID = @UserID
			AND NOT EXISTS (SELECT * FROM QMS_NotificationGroupUser 
							WHERE NotificationGroupID = @NotificationGroupID 
							AND UserID = QMS_User.UserID
							AND RecordStatus < 201)

			-- END INSERT INTO ADMIN NOTIFICATION GROUP 11261

		END
	END
	ELSE --Update user
	BEGIN
	-- Don't change the username to an existing other username. It violates the single username principle of logging in.
		IF EXISTS (SELECT * FROM QMS_User WHERE RecordStatus < 201 AND UserName = @UserName COLLATE Latin1_General_ci_ai AND UserID <> @UserID)
		BEGIN
			SET @UserID = 0 -- This should cause the save procedure to fail.
		END
		ELSE
		BEGIN -- Username is still unique on all undeleted records.
			--JE - update passwords table (TFS 973)
			IF @Password IS NOT NULL
			BEGIN
				EXEC UP_User_Password @UserName, @Password, @Password_MD5, @Password_SHA2
			END

			UPDATE    QMS_User
			SET			FullName = @FullName, UserName = @UserName, Position = @Position, EMail = @EMail, Mobile = @Mobile, PIN = @PIN, 
						LeftCompany = @LeftCompany, UserLevel = @UserLevel, LocaleID = @LocaleID, IsUserGroup = @IsUserGroup, ParentUserID = @ParentUserID, 
						Company = @Company, Updated = GETUTCDATE()
			WHERE     (UserID = @UserID)
		END
	END

	DECLARE @PermissionID int = NULL
	IF ISNULL(@SupplierID,0) > 0 AND ISNULL(@UserID,0) > 0
	BEGIN --Setup linked supplier
		SELECT     @PermissionID = MAX(UserPermissionID)
		FROM         QMS_UserPermissions
		WHERE     (PermissionType = 101) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) = @SupplierID)
		IF ISNULL(@PermissionID,0)=0 --Add permission
		BEGIN
			INSERT INTO QMS_UserPermissions (UserID, PermissionType, PermissionTitle, PermissionAllow)
			VALUES     (@UserID, 101,@SupplierID, 1)
		END
		ELSE
		BEGIN
			UPDATE	QMS_UserPermissions
			SET		PermissionAllow = 1, Updated = GETUTCDATE()
			WHERE	(UserPermissionID = @PermissionID) AND (PermissionAllow = 0)
		END
	
		--Remove any existing permissions
		UPDATE  QMS_UserPermissions
		SET		PermissionAllow = 0, Updated = GETUTCDATE()
		WHERE   (PermissionType = 101) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) <> @SupplierID) AND (PermissionAllow = 1)
	END


	-- Setup CustomerID Link
	SET @PermissionID = NULL -- in case it has a previous value
	IF ISNULL(@CustomerID,0) > 0 AND ISNULL(@UserID,0) > 0
	BEGIN --Setup linked customer
		SELECT     @PermissionID = MAX(UserPermissionID)
		FROM         QMS_UserPermissions
		WHERE     (PermissionType = 102) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) = @CustomerID)
		IF ISNULL(@PermissionID,0)=0 --Add permission
		BEGIN
			INSERT INTO QMS_UserPermissions (UserID, PermissionType, PermissionTitle, PermissionAllow)
			VALUES     (@UserID, 102,@CustomerID, 1)
		END
		ELSE
		BEGIN
			UPDATE	QMS_UserPermissions
			SET		PermissionAllow = 1, Updated = GETUTCDATE()
			WHERE	(UserPermissionID = @PermissionID) AND (PermissionAllow = 0)
		END
	
		--Remove any existing permissions
		UPDATE  QMS_UserPermissions
		SET		PermissionAllow = 0, Updated = GETUTCDATE()
		WHERE   (PermissionType = 102) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) <> @CustomerID) AND (PermissionAllow = 1)
	END

	IF @IsCARebuildRequired = 1
		EXEC SAVE_CorrectiveActionUser_ByUser @UserID

	SET NOCOUNT OFF

	SELECT @UserID
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_CorrectiveActionUser_ByUser')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_CorrectiveActionUser_ByUser] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jonathan Toolan
-- Create date: 12/03/2015
-- Description:	Saves CA user data to QMS_CorrectiveActionUser by UserID
-- Version:		3
-- =============================================
-- JT TFS 13-16507: Created.
-- JT TFS 13-21321: Performance improvements for JS
-- JT TFS 13-21483: Performance improvements for JS (Parameter sniffing exclusion)
-- =============================================
ALTER PROCEDURE SAVE_CorrectiveActionUser_ByUser
	@UserID int
AS
BEGIN
SET NOCOUNT ON

	DECLARE @iUserID int; SET @iUserID = @UserID; -- Parameter sniffing exclusion

	IF nullif(object_id('tempdb..#tmpCorrectiveActionUser'), 0) IS NOT NULL DROP TABLE #tmpCorrectiveActionUser
	IF nullif(object_id('tempdb..#tmpRecentCAs'), 0) IS NOT NULL DROP TABLE #tmpRecentCAs
	IF nullif(object_id('tempdb..#tmpOlderCAs'), 0) IS NOT NULL DROP TABLE #tmpOlderCAs
	IF nullif(object_id('tempdb..#tmpToInsert'), 0) IS NOT NULL DROP TABLE #tmpToInsert
	
	CREATE TABLE #tmpCorrectiveActionUser (
		CorrectiveActionID int,
		Assigned bit
	)
	CREATE TABLE #tmpToInsert (
		CorrectiveActionId int, 
		UserID int, 
		Assigned bit
	)

	-- We want #tmpCorrectiveActionUser to contain exactly what QMS_CorrectiveAction should eventually contain.
	INSERT INTO #tmpCorrectiveActionUser(CorrectiveActionID, Assigned)
	SELECT CorrectiveActionID, 1
	FROM dbo.FNC_GENERATE_CorrectiveAction_AssignUsers()
	WHERE UserID = @iUserID 

	-- get all the function results into a temp table for performance reasons (takes 50 seconds on JS live otherwise).
	SELECT userlist.CorrectiveActionID, 0 as Assigned
	INTO #tmpRecentCAs
	FROM dbo.FNC_GENERATE_User_CorrectiveActionList(@iUserID, 1) as userlist

	SELECT CorrectiveActionID, 0 AS Assigned
	INTO #tmpOlderCAs
	FROM dbo.FNC_GENERATE_User_CorrectiveActionList(@iUserID, 0) as userlist

	INSERT INTO #tmpCorrectiveActionUser (CorrectiveActionID, Assigned)
	SELECT CorrectiveActionID, Assigned 
	FROM #tmpRecentCAs ca
	WHERE ca.CorrectiveActionID NOT IN (SELECT CorrectiveActionID FROM #tmpCorrectiveActionUser)

	INSERT INTO #tmpCorrectiveActionUser (CorrectiveActionID, Assigned)
	SELECT CorrectiveActionID, Assigned 
	FROM #tmpOlderCAs ca
	WHERE ca.CorrectiveActionID NOT IN (SELECT CorrectiveActionID FROM #tmpCorrectiveActionUser)


	-- UPDATE EXISTING
	UPDATE QMS_CorrectiveActionUser
	SET Assigned = CAUser.Assigned,
		Updated = GETUTCDATE()
	FROM QMS_CorrectiveActionUser
	INNER JOIN #tmpCorrectiveActionUser as CAUser ON QMS_CorrectiveActionUser.CorrectiveActionID = CAUser.CorrectiveActionID 
													AND QMS_CorrectiveActionUser.UserID = @iUserID
	WHERE QMS_CorrectiveActionUser.Assigned <> CAUser.Assigned


	-- INSERT MISSING
	INSERT #tmpToInsert (CorrectiveActionID, UserID, Assigned)
	SELECT CAUser.CorrectiveActionID, @iUserID, CAUser.Assigned 
	FROM #tmpCorrectiveActionUser AS CAUser
	LEFT OUTER JOIN QMS_CorrectiveActionUser ON QMS_CorrectiveActionUser.CorrectiveActionID = CAUser.CorrectiveActionID 
											AND QMS_CorrectiveActionUser.UserID = @iUserID
	WHERE  QMS_CorrectiveActionUser.UserID IS NULL

	INSERT QMS_CorrectiveActionUser (CorrectiveActionID, UserID, Assigned)
	SELECT CorrectiveActionID, UserID, Assigned 
	FROM #tmpToInsert 


	-- DELETE REMOVED ONES
	DELETE QMS_CorrectiveActionUser
	WHERE UserID = @iUserID
	AND CorrectiveActionID NOT IN (SELECT CorrectiveActionID FROM #tmpCorrectiveActionUser)

	DROP TABLE #tmpCorrectiveActionUser
	DROP TABLE #tmpToInsert 
	DROP TABLE #tmpRecentCAs
	DROP TABLE #tmpOlderCAs

	SET NOCOUNT OFF

END
GO



PRINT 'Sorting sync procedures...'


PRINT 'Data migration tasks...'

PRINT 'Database updated successfully!'
GO
