-- =============================================
-- Author:		Jeremy Formby
-- Create date: 1/05/2015
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO



PRINT 'Sorting tables...'


PRINT 'Sorting indexes...'


PRINT 'Sorting Views...'


PRINT 'Sorting User Defined Functions...'


PRINT 'Sorting Stored Procedures...'

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Assessment_GetFormulaReplacements')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Assessment_GetFormulaReplacements] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jonathan Toolan
-- Create date: 15/05/2015
-- Description:	Gets formula replacement names for Assessment Headers
-- Version:		1
-- =============================================
-- JT TFS 13-15561 : Created
-- =============================================
ALTER PROCEDURE QRY_Assessment_GetFormulaReplacements
	@UserID int,
	@AssessmentID int,
	@AssessmentTypeID int
AS
BEGIN
	SELECT	'[Header(' + convert(varchar(10), master_header.AssessmentHeaderID) + ')]' OriginalHeader,
			(	SELECT  TOP 1 '[Header(' + convert(varchar(10), AssessmentHeaderID) + ')]' 
				FROM QMS_AssessmentHeader 
				WHERE HeaderText = master_header.HeaderText 
				AND AssessmentTypeID = @AssessmentTypeID
				ORDER BY AssessmentHeaderID) ReplacementHeader
	FROM QMS_AssessmentHeader master_header
	WHERE master_header.AssessmentTypeID = (SELECT AssessmentTypeID FROM QMS_Assessment WHERE AssessmentID = @AssessmentID)
END
GO



PRINT 'Sorting sync procedures...'

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_StockBatchItems')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_StockBatchItems] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		jf
-- Create date: 11/2/15
-- Description:	Imort StockBatchItems
-- Version:		2
-- =============================================
-- jf 11/2/15 - added @TotalQuantity
-- jf tfs 20519- - check if PM_StockBatch exists before inserting to avoid foreign key errors
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_PM_StockBatchItems] 
	@StockItemID int, 
	@StockBatchID INt, 
	@StockCodeID int, 
	@SupplierID int, 
	@UseByDate datetime, 
	@RecordStatus tinyint, 
	@Source tinyint, 
	@Updated datetime,  
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@TotalQuantity decimal(18,2),

	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

IF NOT EXISTS(SELECT StockItemID FROM PM_StockBatchItems WHERE (StockItemID = @StockItemID))
BEGIN --Append record
	IF @RecordStatus < 201 and EXISTS(SELECT StockBatchID FROM PM_StockBatch WHERE (StockBatchID  = @StockBatchID))
	BEGIN
		INSERT INTO PM_StockBatchItems
						(StockBatchID, StockCodeID, SupplierID, UseByDate, RecordStatus, Source, Updated, GUID, TotalQuantity )
                      --(StockBatchID, BatchType, LocationID, Barcode, BatchRef, QAStatus, DateAdded, DateClosed, ExpiryDate, Closed, RecordStatus, GUID)
		VALUES     (@StockBatchID,@StockCodeID,@SupplierID,@UseByDate,@RecordStatus,@Source,@Updated,@GUID,@TotalQuantity)
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    PM_StockBatchItems
	SET              StockBatchID=@StockBatchID, StockCodeID=@StockCodeID, SupplierID=@SupplierID, UseByDate=@UseByDate, RecordStatus=@RecordStatus, Source=@Source, Updated=@Updated, TotalQuantity=@TotalQuantity
	WHERE     (StockItemID = @StockItemID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO


PRINT 'Data migration tasks...'

PRINT 'Database updated successfully!'
GO
