-- =============================================
-- Author:		Jeremy Formby
-- Create date: 1/05/2015
-- Version:		1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_ResponseSummary_FillSelected')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_ResponseSummary_FillSelected] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 14/10/08
-- Description:	Fills TEMP_Selected with AssessmentID for checks to show on QC Summary report
-- Version:		9
-- =============================================
-- Jonathan Toolan: 25-Aug-2011 AssessmentTypeID linked from Response, not Assessment.
-- MarkP: 04-May-2012 Added @AlertPeriod parameter
-- JE TFS 4853: changed filtering to new method
-- JT TFS 6689: Added DataWarehouse code.
-- MP TFS 8278: Removed tables APP_QAFlag and QMS_Assessment from statements as not required
-- JE TFS 13-3050: replaced CROSS JOIN with LEFT JOIN in main query as this didn't work correctly when @AssessmentTypeID_LIST = NULL
-- JT TFS 13-12688: Log ResponseIDs to DEBUG tables to determine source of issues with daily reports.
-- JT TFS 13-17467: Only include multicheck items which are suitable for adding to the data warehouse.
-- =============================================
ALTER PROCEDURE [dbo].[RPT_ResponseSummary_FillSelected] 
	@DateFrom datetime,
	@DateTo datetime,
	@AssessmentTypeID_LIST nvarchar(100) = NULL,
	@AssessmentID int = NULL,
	@AlertPeriod tinyint = NULL,
	@UserID int,
	@FilterApplied bit = 0 -- If set, query checks TEMP_ResponseFilter
AS
BEGIN
	SET NOCOUNT ON

	--test params
	--declare @AssessmentTypeID_LIST nvarchar(100) = NULL,  @DateFrom datetime = '9 Jun 2014 02:00:00',  @DateTo datetime = '10 Jun 2014 23:59:59', 
	--		@AlertPeriod tinyint = 2,  @UserID int = 311, @FilterApplied bit = 0, @AssessmentID int = 1124

	DECLARE @UseDataWarehouse bit
	SET @UseDataWarehouse = dbo.FNC_CanUseDataWarehouse(@UserID)

	--get config value for Override QAFlag
	DECLARE @OverrideFlag bit
	SET @OverrideFlag = CAST(ISNULL(dbo.FNC_GetOptionValue(74),0) AS bit)

	--Clear temp selected
	DELETE FROM TEMP_Selected
	WHERE     (UserID = @UserID)

	DECLARE @Table_Response TABLE (ResponseID int)
	IF ISNULL(@AlertPeriod,0) IN (2,5,6,7) --Hourly, Daily, Weekday, Weekend alerts - filter by uploaded time
	BEGIN
		INSERT INTO @Table_Response (ResponseID)
		SELECT     User_ResponseList.ResponseID
		FROM         dbo.FNC_User_ResponseList(@UserID, DATEADD(day, - 1, @DateFrom), @DateTo) AS User_ResponseList 
		INNER JOIN	QMS_Response ON User_ResponseList.ResponseID = QMS_Response.ResponseID
		WHERE	(User_ResponseList.ResponseStatus = 1) 
		AND		dbo.FNC_Response_ShouldIncludeInDataWarehouse(User_ResponseList.ResponseID) = 1
		AND (
				((QMS_Response.Uploaded IS NULL) AND (QMS_Response.EndDate BETWEEN @DateFrom AND @DateTo)) 
			OR	(QMS_Response.Uploaded BETWEEN @DateFrom AND @DateTo)
		)
	END
	ELSE
	BEGIN
		INSERT INTO @Table_Response (ResponseID)
		SELECT     User_ResponseList.ResponseID
		FROM         dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) as User_ResponseList
		WHERE     (User_ResponseList.ResponseStatus = 1)
		AND		dbo.FNC_Response_ShouldIncludeInDataWarehouse(User_ResponseList.ResponseID) = 1
	END

	SET NOCOUNT OFF

	IF (@UseDataWarehouse = 1)
	BEGIN
		--Insert into temp selected
		INSERT INTO TEMP_Selected
							  (SelectedID, UserID)
		SELECT DISTINCT RPT_Warehouse_Response.ResponseID, @UserID AS UserID
		FROM         RPT_Warehouse_Response 
		INNER JOIN	@Table_Response AS User_ResponseList ON RPT_Warehouse_Response.ResponseID = User_ResponseList.ResponseID 
		INNER JOIN	TEMP_SelectedItem ON RPT_Warehouse_Response.QAFlagID = TEMP_SelectedItem.SelectedItemID 
		LEFT OUTER JOIN	(	SELECT     CAST(Token AS int) AS AssessmentTypeID
						FROM          dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',') AS SplitString_AssessmentType) AS AssessmentType
					ON RPT_Warehouse_Response.AssessmentTypeID = AssessmentType.AssessmentTypeID
		WHERE	(	@FilterApplied = 0 OR RPT_Warehouse_Response.ResponseID IN (SELECT ResponseID FROM TEMP_ResponseFilter WHERE UserID = @UserID))
		AND	(
				(@AssessmentID IS NULL) 
			AND (RPT_Warehouse_Response.AssessmentTypeID = AssessmentType.AssessmentTypeID) 
			AND (TEMP_SelectedItem.UserID = @UserID) 
			AND	(@AssessmentTypeID_LIST IS NOT NULL) 
			OR
				(@AssessmentID IS NULL) 
			AND	(TEMP_SelectedItem.UserID = @UserID) 
			AND (@AssessmentTypeID_LIST IS NULL) 
			OR
				(@AssessmentID IS NOT NULL) 
			AND (TEMP_SelectedItem.UserID = @UserID) 
			AND (RPT_Warehouse_Response.AssessmentID = @AssessmentID)
		)
	END
	ELSE
	BEGIN
		--Insert into temp selected
		INSERT INTO TEMP_Selected
							  (SelectedID, UserID)
		SELECT DISTINCT QMS_Response.ResponseID, @UserID AS UserID
		FROM         QMS_Response 
		INNER JOIN	@Table_Response AS User_ResponseList ON QMS_Response.ResponseID = User_ResponseList.ResponseID 
		INNER JOIN	TEMP_SelectedItem ON  --check config value to join on Actual or Override QAFlagID
						  (CASE WHEN @OverrideFlag = 0 THEN Actual_QAFlagID ELSE ISNULL(Override_QAFlagID, Actual_QAFlagID) END) = TEMP_SelectedItem.SelectedItemID 
		LEFT OUTER JOIN	(	SELECT     CAST(Token AS int) AS AssessmentTypeID
						FROM          dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',') AS SplitString_AssessmentType) AS AssessmentType
					ON QMS_Response.AssessmentTypeID = AssessmentType.AssessmentTypeID
		WHERE	(	@FilterApplied = 0 OR QMS_Response.ResponseID IN (SELECT ResponseID FROM TEMP_ResponseFilter WHERE UserID = @UserID))
		AND	(
				(@AssessmentID IS NULL) 
			AND (QMS_Response.AssessmentTypeID = AssessmentType.AssessmentTypeID) 
			AND (TEMP_SelectedItem.UserID = @UserID) 
			AND	(@AssessmentTypeID_LIST IS NOT NULL) 
			OR
				(@AssessmentID IS NULL) 
			AND	(TEMP_SelectedItem.UserID = @UserID) 
			AND (@AssessmentTypeID_LIST IS NULL) 
			OR
				(@AssessmentID IS NOT NULL) 
			AND (TEMP_SelectedItem.UserID = @UserID) 
			AND (dbo.QMS_Response.AssessmentID = @AssessmentID)
		)
	END

END
GO


PRINT 'Sorting tables...'

-- BEGIN STRUCTURE_APP_AssessmentType_AQCLink
IF NOT EXISTS (SELECT * FROM sys.tables t INNER JOIN sys.columns c ON t.object_id = c.object_id WHERE t.name = 'APP_AssessmentType' AND c.name = 'CanLinkAQC' )
BEGIN TRY
	ALTER TABLE dbo.APP_AssessmentType ADD
		CanLinkAQC bit NOT NULL CONSTRAINT DF_APP_AssessmentType_CanLinkAQC DEFAULT 0

END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Add CanLinkAQC to APP_AssessmentType table'
	FROM #tmpScriptName
	
END CATCH
GO
-- END STRUCTURE_APP_AssessmentType_AQCLink


IF NOT EXISTS (SELECT * FROM sys.tables t INNER JOIN sys.columns c ON t.object_id = c.object_id WHERE t.name = 'PM_Consignment' AND c.name = 'Text1' )
BEGIN TRY
	alter table PM_Consignment add
		Text1 nvarchar(100),
		Text2 nvarchar(100)


END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Add Text1,Text1 to PM_Consignment table'
	FROM #tmpScriptName

END CATCH
GO

-- BEGIN DATA PM_Consignment
BEGIN TRY
--this is to update mobile database as they are different from office
IF NOT EXISTS (SELECT * FROM sys.tables t INNER JOIN sys.columns c ON t.object_id = c.object_id WHERE t.name = 'PM_Consignment' AND c.name = 'Updated' )

	alter table PM_Consignment add
		Updated datetime constraint DF_PM_ConsignmentHeader_Updated default (getutcdate()),
		Created bigint constraint DF_PM_Consignment_Created default (@@dbts+(1)),
		RowVersion timestamp not null


		  
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA PM_Consignment'
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA PM_Consignment


-- BEGIN DATA  PM_ConsignmentItems_VersionNo
BEGIN TRY
IF NOT EXISTS (SELECT * FROM sys.tables t INNER JOIN sys.columns c ON t.object_id = c.object_id WHERE t.name = 'PM_ConsignmentItems' AND c.name = 'VersionNo' )

	alter table PM_ConsignmentItems add
		VersionNo int null
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA  PM_ConsignmentItems_VersionNo'
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA  PM_ConsignmentItems_VersionNo



IF NOT EXISTS (SELECT * FROM sys.tables t INNER JOIN sys.columns c ON t.object_id = c.object_id WHERE t.name = 'PM_GoodsIntake' AND c.name = 'PalletStockCodeID' )
BEGIN TRY
	alter table PM_GoodsIntake add
		PalletStockCodeID int


END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Add PalletStockCodeID to PM_GoodsIntake table'
	FROM #tmpScriptName
	
END CATCH
GO

-- BEGIN DATA PM_GoodsIntake
BEGIN TRY
--this is to update mobile database as they are different from office
IF NOT EXISTS (SELECT * FROM sys.tables t INNER JOIN sys.columns c ON t.object_id = c.object_id WHERE t.name = 'PM_GoodsIntake' AND c.name = 'Rowversion' )

	alter table PM_GoodsIntake add
		Created bigint constraint DF_PM_GoodsIntake_Created default (@@dbts+(1)),
		RowVersion timestamp not null

				  
END TRY 
BEGIN CATCH

	INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'DATA Struct PM_GoodsIntake'
	FROM #tmpScriptName
	
END CATCH
GO
-- END DATA PM_GoodsIntake

PRINT 'Sorting indexes...'

PRINT 'Sorting Views...'

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'PM_VW_Consignment')
	EXEC ('CREATE VIEW [dbo].[PM_VW_Consignment] AS SELECT 1 as ''stub version, to be replaced''')
GO
-- ===================================================
-- Author:		Unknown
-- Create date:	1 Jan 2010
-- Description:	View consignments from PM_Consignment
-- Version:		5
-- ===================================================
-- JT TFS 4405: Added E_POType column
-- JF: Added Comments column
-- MP TFS 2798: Added CustomerID column
-- jf tfs 19129 - added Text1, Text2, Hide
-- ===================================================
ALTER VIEW dbo.PM_VW_Consignment
AS
SELECT        ConsignmentID, LEFT('000000', 6 - LEN(CAST(ConsignmentID AS nvarchar))) + CAST(ConsignmentID AS nvarchar) AS ConsignmentNo, SupplierID, OrderRef, OrderDate, DateRequired, E_PO, LocationID, 
                         OrderStatus, WatchList, E_POType, Comments, CustomerID, Text1, Text2, Hide, GUID, RowVersion, Created, RecordStatus, Updated
FROM            dbo.PM_Consignment
WHERE        (OrderStatus > 1) AND (Hide = 0) AND (RecordStatus < 201)
GO





IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.VIEWS WHERE TABLE_NAME = 'PM_VW_GoodsIntake')
	EXEC ('CREATE VIEW [dbo].[PM_VW_GoodsIntake] AS SELECT 1 as ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Unknown
-- Create date: 29/06/2010
-- Description:	Gets header informaton for PM_GoodsIntake
-- Version:		7
-- =============================================
-- JT TFS 4286: 9-Aug-2012: Added PalletID
-- JF: Added ArrivalTemp and Certified
-- MP TFS 2798: Added Updated column
-- jf TFS 19129 - added PalletStockCodeID
-- =============================================
ALTER VIEW dbo.PM_VW_GoodsIntake
AS
SELECT        GoodsIntakeID, SupplierID, ConsignmentItemID, LocationID, UserGroupID, ItemCount, UnitQuantity, PalletNo, HarvestDate, DeliveryID, DateArrived, SupplierRef, SupplierLotNo, Barcode, Comments, E_Text1, 
                         E_Text2, UnitStockCodeID, OriginalBarcode, E_Numeric1, E_DateTime1, PalletID, ArrivalTemp, Certified, Updated, NetWeight, PalletStockCodeID, RowVersion, Created, RecordStatus, E_Numeric3, E_Numeric2, 
                         GUID
FROM            dbo.PM_GoodsIntake
WHERE        (RecordStatus < 201)
GO




PRINT 'Sorting User Defined Functions...'
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_ResponseHeader')
	EXEC('DROP FUNCTION [dbo].[FNC_ResponseHeader]')
GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_ResponseHeader')
	EXEC('CREATE FUNCTION [dbo].[FNC_ResponseHeader]() RETURNS TABLE AS RETURN (SELECT 1 y)')
GO
-- =============================================
-- Author:		Markp
-- Create date: 17/03/2009
-- Description:	Gets response header data for views
-- Version:		3
-- =============================================
-- tfs4354 - get the lowest DataLookupID for the stock code as there may be duplicates within an assessment (2,6 etc) 
-- JT TFS 13-19030: Move lookup of lowest DataLookupID into main query to prevent timeouts on rugby farms mobile.
-- =============================================
ALTER FUNCTION dbo.FNC_ResponseHeader 
(	
)
RETURNS TABLE 
AS
RETURN 
(
	SELECT	ResponseID, MAX(Supplier) AS Supplier, 
			(SELECT TOP 1 StockCode FROM VW_ResponseHeader_SourceLookup WHERE ResponseID = rh.ResponseID AND StockCode IS NOT NULL ORDER BY DataLookupID) StockCode,
			MAX(Location) AS Location, MAX(Consignment) AS Consignment, 
			MAX(ConsignmentItem) AS ConsignmentItem, MAX(Delivery) AS Delivery, MAX(DeliveryItem) AS DeliveryItem, MAX(SupplierRef) AS SupplierRef, 
			MAX(ArrivalDate) AS ArrivalDate, MAX(QuantityReceived) AS QuantityReceived, MAX(QuantityChecked) AS QuantityChecked, 
			MAX(Customer) AS Customer, MAX(AssessmentSubType) AS AssessmentSubType, MAX(DepotDate) AS DepotDate, MAX(CountryOfOrigin) AS CountryOfOrigin, 
			MAX(HarvestCrew) AS HarvestCrew
	FROM	VW_ResponseHeader_SourceLookup as rh
	GROUP BY rh.ResponseID
)
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'FNC_Response_ShouldIncludeInDataWarehouse')
	EXEC('CREATE FUNCTION [dbo].[FNC_Response_ShouldIncludeInDataWarehouse]() RETURNS bit AS BEGIN RETURN 0 END')
GO
-- =============================================
-- Author:		Jonathan Toolan
-- Create date: 29/04/2015
-- Description:	Determines whether a response should be stored in the warehouse and visible on reports.
-- Version:		1
-- =============================================
-- JT TFS 13-612: Created
-- =============================================
ALTER FUNCTION dbo.FNC_Response_ShouldIncludeInDataWarehouse(@ResponseID int)
	RETURNS tinyint
AS
BEGIN
-- AssessmentFormat stored in eAssessmentFormat (QC.Common.SystemGlobals)
--        MultipleReportPerChild = 5
--        MultipleReportPerTopLevel = 6
--        AQCMultiSummary = 7

RETURN (SELECT	CASE	WHEN APP_AssessmentType.AssessmentFormat NOT IN (5,6,7) THEN 1 -- Isn't multi-check at all - store it.
						WHEN APP_AssessmentType.AssessmentFormat = 5
						     AND  QMS_Response.ParentResponseGUID IS NOT NULL	THEN 1 -- Morrisons scenario - only store the child checks.
						WHEN APP_AssessmentType.AssessmentFormat = 6 
							 AND  QMS_Response.ParentResponseGUID IS NULL		THEN 1 -- barfoots scenario - only store the parent check.
						WHEN APP_AssessmentType.AssessmentFormat = 7			THEN 1 -- standard multi-check - store both child and parent. 
						ELSE 0 -- Reject it.
				END
		FROM	QMS_Response
		INNER JOIN APP_AssessmentType ON APP_AssessmentType.AssessmentTypeID = QMS_Response.AssessmentTypeID
		WHERE	QMS_Response.ResponseID = @ResponseID)
END
GO


PRINT 'Sorting Stored Procedures...'

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_AssessmentType_ReportCombo')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_AssessmentType_ReportCombo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 11/10/2011
-- Description:	Gets data to fill assessment type combo for reporting
-- Version: 3
-- =============================================
-- jf tfs 19351 - German Translation - QC Actions screen, not everything is translated
-- JT TFS 13-19995 - Query performance improved by extracting translation lookups from main query.
-- =============================================
ALTER PROCEDURE [dbo].[QRY_AssessmentType_ReportCombo] 
	@UserID int = null
AS
BEGIN
	SET NOCOUNT ON
	
	IF NULLIF(object_id('tempdb..#tmpAssessmentType'), 0) IS NOT NULL DROP TABLE #tmpAssessmentType
	CREATE TABLE #tmpAssessmentType (
		AssessmentTypeID int,
		AssessmentType nvarchar(255),
		ListIndex int
	)
	INSERT #tmpAssessmentType (AssessmentTypeID, AssessmentType, ListIndex)
	SELECT	APP_AssessmentType.AssessmentTypeID, 
			ISNULL(dbo.FNC_ResourceString_User(APP_AssessmentType.ResourceName, @UserID), APP_AssessmentType.AssessmentType) AS AssessmentType,
			APP_AssessmentType.ListIndex
	FROM APP_AssessmentType 

	SET NOCOUNT OFF

	SELECT     APP_AssessmentType.AssessmentTypeID, APP_AssessmentType.AssessmentType
	FROM         #tmpAssessmentType as APP_AssessmentType 
	INNER JOIN	QMS_Response ON APP_AssessmentType.AssessmentTypeID = QMS_Response.AssessmentTypeID
	WHERE     (QMS_Response.ResponseStatus = 1)
	GROUP BY APP_AssessmentType.AssessmentTypeID, APP_AssessmentType.AssessmentType, APP_AssessmentType.ListIndex
	ORDER BY APP_AssessmentType.ListIndex

END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_AssessmentType_GetDetail')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_AssessmentType_GetDetail] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jonathan Toolan
-- Create date: 31/04/2015
-- Description:	Gets data about an assessment type
-- Version:		1
-- =============================================
-- TFS 13-13429: Created. Used in clsAssessmentType (settings section).
-- =============================================
ALTER PROCEDURE dbo.QRY_AssessmentType_GetDetail
	@UserID int = NULL,
	@AssessmentTypeID int = NULL
AS
BEGIN
	SELECT AssessmentTypeID, AssessmentFormat, CanLinkAQC FROM APP_AssessmentType
	WHERE AssessmentTypeID = @AssessmentTypeID
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Response_MultiList')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Response_MultiList] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Jon Edwards
-- Create date: 03/04/2013
-- Description:	Returns data from all child responses for selected parent response
-- Version:		4
-- =============================================
-- JE TFS 13-466: added RecordStatus column (used in AQC Multi Check)
-- JT TFS 13-612: Hide children which have been voided and cancelled.
-- jf tfs 18246  - added QuantityAccepted ,QuantityRejected
-- =============================================
ALTER PROCEDURE [dbo].[QRY_Response_MultiList]
@ResponseID int
AS
BEGIN

--get GUID for parent response
DECLARE @ParentGUID AS uniqueidentifier
SELECT	@ParentGUID = GUID
FROM	QMS_Response
WHERE	(ResponseID = @ResponseID)

--get data for all child responses of above parent
SELECT	ResponseID, Actual_Score, Actual_QAFlagID, RecordStatus, Comments,QuantityAccepted ,QuantityRejected 
FROM	QMS_Response
WHERE	(QMS_Response.ParentResponseGUID = @ParentGUID)
AND     (QMS_Response.RecordStatus < 180) -- Hide voided and cancelled checks.

END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_User_AdminList')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_User_AdminList] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 27/06/2008
-- Description:	Gets list of users for admin
-- Version:		8
-- =============================================
-- JE TFS 2677 added new UserLevel logic
-- MP 18/09/12 change to selection of avalable user level as not sure why QMS_User was included here
-- JT TFS 6623 added IsUserLockedOut column (based on logic in clsUserAdmin.IsUserLockedOut, and added SearchUserID
-- JT TFS 7115 Added begin/end and NOCOUNT options to see if they fixed slowdown.
-- JT TFS 8022 - Return GUID so that it can be passed to LogiXML
-- JT TFS 13-11810 - Include CustomerID in output.
-- AC TFS 1200 - Include Lookup_LocaleID in output
-- MP TFS 18442 - Return Inserted so it can be used by Intercom
-- =============================================
ALTER PROCEDURE [dbo].[QRY_User_AdminList] 
	@UserID int,
	@Company nvarchar(255) = NULL,
	@SearchUserID int = NULL
AS
BEGIN

	SET NOCOUNT ON 
	-- temp table to hold user levels
	DECLARE @AvailableUserLevels TABLE
	(
		UserLevelID int,
		UserLevel nvarchar(50),
		LevelOrder int
	)
	-- user level of selected User
	DECLARE @LevelOrder int
	-- match UserID to get LevelOrder
	SET @LevelOrder = (SELECT LevelOrder FROM APP_UserLevel INNER JOIN
							QMS_User ON APP_UserLevel.UserLevelID = QMS_User.UserLevel
						WHERE UserID = @UserID)

	IF @LevelOrder = 1
		-- insert available (i.e. lower) user levels into temp table then join on this in main query
		INSERT INTO @AvailableUserLevels (UserLevelID, UserLevel, LevelOrder)
		SELECT     UserLevelID, UserLevel, LevelOrder
		FROM         APP_UserLevel
		WHERE     (Hide = 0) AND (LevelOrder >= @LevelOrder)
	ELSE
		-- insert available (i.e. lower) user levels into temp table then join on this in main query
		INSERT INTO @AvailableUserLevels (UserLevelID, UserLevel, LevelOrder)
		SELECT     UserLevelID, UserLevel, LevelOrder
		FROM         APP_UserLevel
		WHERE     (Hide = 0) AND (LevelOrder > @LevelOrder)

	SET NOCOUNT OFF

	SELECT DISTINCT
		QMS_User.UserID, 
		QMS_User.FullName, 
		QMS_User.UserName, 
		QMS_User.Password, 
		QMS_User.Position, 
		QMS_User.Company, 
		QMS_User.EMail, 
		QMS_User.Mobile, 
		QMS_User.PIN, 
		QMS_User.LeftCompany, 
		QMS_User.UserLevel, 
		AvailableUserLevels.UserLevel AS Lookup_UserLevel, 
		QMS_User.LocaleID, 
		APP_CountryLocales.[Description] AS Lookup_LocaleID, 
		QMS_User.IsUserGroup, 
		QMS_User.ParentUserID, 
		Lookup_UserGroup.FullName AS Lookup_ParentUserID, 
		CAST(CASE	WHEN ISNULL(SupplierPermissions.NumPermissions, 0) > 1 THEN 0 
					WHEN ISNULL(SupplierPermissions.NumPermissions, 0) = 1 THEN SupplierID 
					ELSE NULL END AS int) AS SupplierID, 
		CAST(CASE	WHEN ISNULL(SupplierPermissions.NumPermissions, 0) > 1 THEN N'(Multiple)' 
					WHEN ISNULL(SupplierPermissions.NumPermissions, 0) = 1 THEN	ISNULL((	SELECT     SupplierName
																					FROM          PM_VW_Supplier
																					WHERE      (SupplierID = SupplierPermissions.SupplierID)), '(deleted supplier)')
					ELSE NULL END AS nvarchar) AS Lookup_SupplierID, 

		CAST(CASE	WHEN ISNULL(CustomerPermissions.NumPermissions, 0) > 1 THEN 0 
					WHEN ISNULL(CustomerPermissions.NumPermissions, 0) = 1 THEN CustomerID 
					ELSE NULL END AS int) AS CustomerID, 
		CAST(CASE	WHEN ISNULL(CustomerPermissions.NumPermissions, 0) > 1 THEN N'(Multiple)' 
					WHEN ISNULL(CustomerPermissions.NumPermissions, 0) = 1 THEN	ISNULL((	SELECT     CustomerName
																					FROM          PM_VW_Customer_Admin
																					WHERE      (CustomerID = CustomerPermissions.CustomerID)), '(deleted customer)') 
					ELSE NULL END AS nvarchar) AS Lookup_CustomerID, 
		CAST(OfficePermissions.NumPermissions AS nvarchar(100)) AS OfficeAccess, 
		CAST(MobilePermissions.NumPermissions AS nvarchar(100)) AS MobileAccess, 
		CAST(WebPermissions.NumPermissions AS nvarchar(100)) AS WebAccess, 
		CAST(SupplierPermissions.NumPermissions AS nvarchar(100)) AS SupplierAccess, 
		CAST(CustomerPermissions.NumPermissions AS nvarchar(100)) AS CustomerAccess, 
		CAST(LocationPermissions.NumPermissions AS nvarchar(100)) AS LocationAccess, 
		CAST(StockCodePermissions.NumPermissions AS nvarchar(100)) AS StockCodeAccess,
		CAST(CASE WHEN QMS_User.[Password] IS NULL THEN 1 ELSE 0 END as bit) Lookup_IsUserLockedOut,
		QMS_User.[GUID] AS Lookup_GUID,
		QMS_User.Inserted
	FROM         QMS_User INNER JOIN
						   @AvailableUserLevels AS AvailableUserLevels ON QMS_User.UserLevel = AvailableUserLevels.UserLevelID LEFT OUTER JOIN
							  (SELECT     UserID, FullName
								FROM          QMS_User AS User_Group
								WHERE      (RecordStatus < 201) AND (IsUserGroup = 1)) AS Lookup_UserGroup ON QMS_User.ParentUserID = Lookup_UserGroup.UserID LEFT OUTER JOIN
							  (SELECT     UserID, COUNT(UserPermissionID) AS NumPermissions
								FROM          QMS_UserPermissions AS StockCode_Permissions
								WHERE      (PermissionAllow = 1) AND (PermissionType = 104)
								GROUP BY UserID) AS StockCodePermissions ON QMS_User.UserID = StockCodePermissions.UserID LEFT OUTER JOIN
							  (SELECT     UserID, COUNT(UserPermissionID) AS NumPermissions
								FROM          QMS_UserPermissions AS Location_Permissions
								WHERE      (PermissionAllow = 1) AND (PermissionType = 103)
								GROUP BY UserID) AS LocationPermissions ON QMS_User.UserID = LocationPermissions.UserID LEFT OUTER JOIN
							  (SELECT     UserID, COUNT(UserPermissionID) AS NumPermissions, MIN(CAST(PermissionTitle AS int)) AS SupplierID
								FROM          QMS_UserPermissions AS Supplier_Permissions
								WHERE      (PermissionAllow = 1) AND (PermissionType = 101)
								GROUP BY UserID) AS SupplierPermissions ON QMS_User.UserID = SupplierPermissions.UserID LEFT OUTER JOIN
							  (SELECT     UserID, COUNT(UserPermissionID) AS NumPermissions, MIN(CAST(PermissionTitle AS int)) AS CustomerID
								FROM          QMS_UserPermissions AS Customer_Permissions
								WHERE      (PermissionAllow = 1) AND (PermissionType = 102)
								GROUP BY UserID) AS CustomerPermissions ON QMS_User.UserID = CustomerPermissions.UserID LEFT OUTER JOIN
							  (SELECT     Web_Permissions.UserID, COUNT(Web_Permissions.UserPermissionID) AS NumPermissions
								FROM          QMS_UserPermissions AS Web_Permissions INNER JOIN
													   APP_Menu AS Web_Menu ON CAST(Web_Permissions.PermissionTitle AS int) = Web_Menu.MenuID
								WHERE      (Web_Permissions.PermissionAllow = 1) AND (Web_Permissions.PermissionType = 0) AND (Web_Menu.AppID = 3)
								GROUP BY Web_Permissions.UserID) AS WebPermissions ON QMS_User.UserID = WebPermissions.UserID LEFT OUTER JOIN
							  (SELECT     Mobile_Permissions.UserID, COUNT(Mobile_Permissions.UserPermissionID) AS NumPermissions
								FROM          QMS_UserPermissions AS Mobile_Permissions INNER JOIN
													   APP_Menu AS Mobile_Menu ON CAST(Mobile_Permissions.PermissionTitle AS int) = Mobile_Menu.MenuID
								WHERE      (Mobile_Permissions.PermissionAllow = 1) AND (Mobile_Permissions.PermissionType = 0) AND (Mobile_Menu.AppID = 2)
								GROUP BY Mobile_Permissions.UserID) AS MobilePermissions ON QMS_User.UserID = MobilePermissions.UserID LEFT OUTER JOIN
							  (SELECT     Office_Permissions.UserID, COUNT(Office_Permissions.UserPermissionID) AS NumPermissions
								FROM          QMS_UserPermissions AS Office_Permissions INNER JOIN
													   APP_Menu AS Office_Menu ON CAST(Office_Permissions.PermissionTitle AS int) = Office_Menu.MenuID
								WHERE      (Office_Permissions.PermissionAllow = 1) AND (Office_Permissions.PermissionType = 0) AND (Office_Menu.AppID = 1)
								GROUP BY Office_Permissions.UserID) AS OfficePermissions ON QMS_User.UserID = OfficePermissions.UserID LEFT JOIN APP_CountryLocales ON
								QMS_User.LocaleID = APP_CountryLocales.CountryLocaleID
	WHERE     (QMS_User.RecordStatus < 201) 
	AND (QMS_User.Company = @Company OR @Company IS NULL)
	AND (QMS_User.UserID = @SearchUserID OR @SearchUserID IS NULL)
	ORDER BY QMS_User.IsUserGroup, QMS_User.FullName
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_User_CurrentAdmin')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_User_CurrentAdmin] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 17/03/2010
-- Description:	Gets current user for admin
-- Version:		3
-- =============================================
-- JT TFS 8022 - Return GUID so that it can be passed to LogiXML
-- MP TFS 18442 - Return Inserted and UserGroup so it can be used by Intercom
-- =============================================
ALTER PROCEDURE [dbo].[QRY_User_CurrentAdmin] 
	@UserID int
AS

SELECT     UserID, FullName, UserName, Password, Position, Company, EMail, Mobile, PIN, LeftCompany, UserLevel, IsUserGroup, ParentUserID, LocaleID, GUID,Inserted,
Lookup_ParentUserID = (SELECT FullName
								FROM          QMS_User AS User_Group
								WHERE      (RecordStatus < 201) AND (IsUserGroup = 1) AND UserID = CurrentUser.ParentUserID)  
FROM         QMS_User AS CurrentUser
WHERE     (RecordStatus < 201) AND (UserID = @UserID)
ORDER BY IsUserGroup

GO



PRINT 'Sorting sync procedures...'

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_AssessmentType')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_AssessmentType] AS SELECT ''stub version, to be replaced''')
GO
-- ===================================================
-- Author:		Jonathan Toolan
-- Create date:	21 Apr 2015
-- Description:	Imports APP_AssessmentType into mobile.
-- Version:		2
-- ===================================================
-- JT TFS 13-17398 - CanLinkAQC column added.
-- ===================================================
ALTER PROCEDURE [dbo].[SYNC_Import_AssessmentType] 
	@AssessmentTypeID int,
	@AssessmentType nvarchar(50),
	@ResourceName nvarchar(50),
	@ListIndex int,
	@Hide int,
	@CompleteActionType int,
	@CompleteAction nvarchar(255),
	@CompleteSuppressMsg bit,
	@ImmediateSupplierReport tinyint,
	@DailySupplierReport tinyint,
	@RequireSignOff bit,
	@ShowAssessmentAction bit,
	@ProcedureURL nvarchar(255) = NULL,
	@ValidateAttachment tinyint = NULL,
	@SaveActionType int = NULL,
	@SaveAction nvarchar(255) = NULL,
	@SaveSuppressMsg bit = 0,
	@QCActionActionType int = NULL,
	@QCActionAction nvarchar(255) = NULL,
	@QCActionSuppressMsg bit = 0,
	@ValidateHeaderSP nvarchar(50) = NULL,
	@AssessmentFormat tinyint = NULL,
	@EnableBackfill bit = 0,
	@StartAction TINYINT = NULL,
	@NewAssessmentAlert bit = NULL,
	@AllowCompletionWithNoAssessment BIT = NULL,
	@CanLinkAQC BIT = NULL,
	@Updated datetime,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

IF @AssessmentFormat IS NULL
	SET @AssessmentFormat = 0

IF @StartAction IS NULL
	SET @StartAction = 0
	
IF @NewAssessmentAlert IS NULL
	SET @NewAssessmentAlert = 0
	
IF @AllowCompletionWithNoAssessment IS NULL
	SET @AllowCompletionWithNoAssessment = 0

IF @CanLinkAQC IS NULL
	SET @CanLinkAQC = 0
	
IF NOT EXISTS(SELECT * FROM APP_AssessmentType WHERE (AssessmentTypeID = @AssessmentTypeID))
BEGIN --Append record
	SET IDENTITY_INSERT APP_AssessmentType ON
	INSERT INTO APP_AssessmentType
                      (AssessmentTypeID, AssessmentType, ResourceName, ListIndex, Hide, CompleteActionType, CompleteAction, CompleteSuppressMsg, ImmediateSupplierReport, 
                      DailySupplierReport, RequireSignOff, ShowAssessmentAction, ProcedureURL, ValidateAttachment, SaveActionType, SaveAction, SaveSuppressMsg, 
                      QCActionActionType, QCActionAction, QCActionSuppressMsg, ValidateHeaderSP, AssessmentFormat, EnableBackfill, StartAction, NewAssessmentAlert, 
                      AllowCompletionWithNoAssessment, CanLinkAQC, Updated, GUID)
	VALUES     (@AssessmentTypeID,@AssessmentType,@ResourceName,@ListIndex,@Hide,@CompleteActionType,@CompleteAction,@CompleteSuppressMsg,@ImmediateSupplierReport,
				@DailySupplierReport,@RequireSignOff,@ShowAssessmentAction,@ProcedureURL,@ValidateAttachment,@SaveActionType,@SaveAction,@SaveSuppressMsg,
				@QCActionActionType,@QCActionAction,@QCActionSuppressMsg,@ValidateHeaderSP,@AssessmentFormat,@EnableBackfill,@StartAction,@NewAssessmentAlert,
				@AllowCompletionWithNoAssessment, @CanLinkAQC, @Updated,@GUID)
	SET @InsertCount = @@rowcount
	SET IDENTITY_INSERT APP_AssessmentType OFF
END

ELSE
BEGIN --Update record
	UPDATE    APP_AssessmentType
	SET              AssessmentType = @AssessmentType, ResourceName = @ResourceName, ListIndex = @ListIndex, Hide = @Hide, CompleteActionType = @CompleteActionType, 
                      CompleteAction = @CompleteAction, CompleteSuppressMsg = @CompleteSuppressMsg, ImmediateSupplierReport = @ImmediateSupplierReport, 
                      DailySupplierReport = @DailySupplierReport, RequireSignOff = @RequireSignOff, ShowAssessmentAction = @ShowAssessmentAction, Updated = @Updated, 
                      ProcedureURL = @ProcedureURL, ValidateAttachment = @ValidateAttachment, SaveActionType = @SaveActionType, SaveAction = @SaveAction, 
                      SaveSuppressMsg = @SaveSuppressMsg, QCActionActionType = @QCActionActionType, QCActionAction = @QCActionAction, 
                      QCActionSuppressMsg = @QCActionSuppressMsg, ValidateHeaderSP = @ValidateHeaderSP, AssessmentFormat = @AssessmentFormat, 
                      EnableBackfill = @EnableBackfill, StartAction = @StartAction, NewAssessmentAlert = @NewAssessmentAlert, 
                      AllowCompletionWithNoAssessment = @AllowCompletionWithNoAssessment, CanLinkAQC = @CanLinkAQC
	WHERE     (AssessmentTypeID = @AssessmentTypeID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_Consignment')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_Consignment] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		jmf	
-- Create date: 21/4/15
-- Description:	Updates mobile data from the sync
-- Version:		1
-- =============================================
-- jf TFS 18595 added text1 and text2 to the import
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_PM_Consignment] 
	@ConsignmentID int,
	@SupplierID int,
	@OrderRef nvarchar(50),
	@OrderDate datetime,
	@DateRequired datetime,
	@E_PO nvarchar(50),
	@LocationID int,
	@OrderStatus int,
	@WatchList nvarchar(1),
	@E_POType NVARCHAR(10) = NULL,
	@Comments NVARCHAR(1000) = NULL,
	@CustomerID INT = NULL,
	@Hide BIT = NULL,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@Text1  nvarchar(100),
	@Text2 nvarchar(100),
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

SET @OrderDate = dbo.FNC_ConvertServerDate(@OrderDate)
SET @DateRequired = dbo.FNC_ConvertServerDate(@DateRequired)

IF @Hide IS NULL
	SET @Hide=0

IF NOT EXISTS(SELECT * FROM PM_Consignment WHERE (ConsignmentID = @ConsignmentID))
BEGIN --Append record
	IF @RecordStatus < 201 AND EXISTS(SELECT SupplierID FROM PM_Supplier WHERE (SupplierID = @SupplierID) OR @SupplierID IS NULL)
	BEGIN
		INSERT INTO PM_Consignment
                      (ConsignmentID, SupplierID, OrderRef, OrderDate, DateRequired, E_PO, LocationID, OrderStatus, WatchList, E_POType, Comments, CustomerID, Hide, RecordStatus, 
                      GUID,Text1,Text2)
		VALUES     (@ConsignmentID,@SupplierID,@OrderRef,@OrderDate,@DateRequired,@E_PO,@LocationID,@OrderStatus,@WatchList,@E_POType,@Comments,@CustomerID,@Hide,@RecordStatus,@GUID, @Text1,@Text2 )
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    PM_Consignment
	SET              SupplierID = @SupplierID, OrderRef = @OrderRef, OrderDate = @OrderDate, DateRequired = @DateRequired, E_PO = @E_PO, LocationID = @LocationID, 
                      OrderStatus = @OrderStatus, WatchList = @WatchList, E_POType = @E_POType, Comments = @Comments, CustomerID = @CustomerID, Hide = @Hide, 
                      RecordStatus = @RecordStatus,
					  Text1 = @Text1 , Text2 = @Text2 

	WHERE     (ConsignmentID = @ConsignmentID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_GoodsIntake')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_GoodsIntake] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		unknows
-- Create date: 18/12/2008
-- Description:	imports data
-- Version:		2
-- =============================================
-- jf tfs 18253 - added @PalletStockCodeID
-- =============================================

ALTER PROCEDURE [dbo].[SYNC_Import_PM_GoodsIntake] 
	@GoodsIntakeID int,
	@SupplierID int,
	@ConsignmentItemID int,
	@LocationID int,
	@ItemCount real,
	@UnitQuantity int,
	@PalletNo int,
	@NetWeight real = NULL,
	@DeliveryID int,
	@DateArrived datetime,
	@SupplierRef nvarchar(50),
	@Barcode nvarchar(50),
	@OriginalBarcode nvarchar(50) = NULL,
	@UserGroupID int,
	@HarvestDate datetime,
	@SupplierLotNo nvarchar(50),
	@Comments nvarchar(255),
	@UnitStockCodeID int = NULL,
	@E_Text1 nvarchar(50) = NULL,
	@E_Text2 nvarchar(50) = NULL,
	@E_Numeric1 int = NULL,
	@E_Numeric2 int = NULL,
	@E_DateTime1 datetime = NULL,
	@PalletID INT = NULL,
	@Certified BIT = NULL,
	@ArrivalTemp REAL = NULL,
	@E_Numeric3 REAL = NULL,
	@Updated DATETIME = NULL,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@PalletStockCodeID int,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

IF @Certified IS NULL
	SET @Certified = 0
	
IF NOT EXISTS(SELECT * FROM PM_GoodsIntake WHERE (GoodsIntakeID = @GoodsIntakeID))
BEGIN --Append record
	IF @RecordStatus < 201 AND EXISTS(SELECT ConsignmentID FROM PM_ConsignmentItems WHERE (ConsignmentItemID = @ConsignmentItemID))
	BEGIN
		INSERT INTO PM_GoodsIntake
                      (GoodsIntakeID, SupplierID, ConsignmentItemID, LocationID, ItemCount, UnitQuantity, PalletNo, NetWeight, DeliveryID, DateArrived, SupplierRef, SupplierLotNo, Comments, 
                      UserGroupID, HarvestDate, Barcode, UnitStockCodeID, OriginalBarcode, E_Text1, E_Text2, E_Numeric1, E_Numeric2, E_DateTime1, PalletID, Certified, ArrivalTemp, 
                      E_Numeric3, Updated, RecordStatus, GUID,PalletStockCodeID)
		VALUES     (@GoodsIntakeID,@SupplierID,@ConsignmentItemID,@LocationID,@ItemCount,@UnitQuantity,@PalletNo,@Netweight,@DeliveryID,@DateArrived,@SupplierRef,@SupplierLotNo,@Comments,@UserGroupID,@HarvestDate,@Barcode,@UnitStockCodeID,@OriginalBarcode,@E_Text1,@E_Text2,@E_Numeric1,@E_Numeric2,@E_DateTime1,@PalletID,@Certified,@ArrivalTemp,@E_Numeric3,@Updated,@RecordStatus,@GUID,@PalletStockCodeID)
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    PM_GoodsIntake
	SET              SupplierID = @SupplierID, ConsignmentItemID = @ConsignmentItemID, LocationID = @LocationID, DeliveryID = @DeliveryID, ItemCount = @ItemCount, 
                      UnitQuantity = @UnitQuantity, PalletNo = @PalletNo, NetWeight = @Netweight, DateArrived = @DateArrived, SupplierRef = @SupplierRef, Barcode = @Barcode, 
                      SupplierLotNo = @SupplierLotNo, Comments = @Comments, UserGroupID = @UserGroupID, HarvestDate = @HarvestDate, UnitStockCodeID = @UnitStockCodeID, 
                      OriginalBarcode = @OriginalBarcode, E_Text1 = @E_Text1, E_Text2 = @E_Text2, E_Numeric1 = @E_Numeric1, E_Numeric2 = @E_Numeric2, 
                      E_DateTime1 = @E_DateTime1, PalletID = @PalletID, Certified = @Certified, ArrivalTemp = @ArrivalTemp, E_Numeric3 = @E_Numeric3, Updated = @Updated, 
                      RecordStatus = @RecordStatus, PalletStockCodeID=@PalletStockCodeID
	WHERE     (GoodsIntakeID = @GoodsIntakeID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SYNC_Import_PM_ConsignmentItems')
	EXEC ('CREATE PROCEDURE [dbo].[SYNC_Import_PM_ConsignmentItems] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		jmf	
-- Create date: 21/4/15
-- Description:	Updates mobile data from the sync
-- Version:		1
-- =============================================
-- jf TFS 19430 added @VersionNo
-- =============================================
ALTER PROCEDURE [dbo].[SYNC_Import_PM_ConsignmentItems] 
	@ConsignmentItemID int,
	@ConsignmentID int,
	@StockCodeID int,
	@Quantity real,
	@UnitStockCodeID int,
	@UnitQuantity real,
	@QuantityAccepted real,
	@DepotDate datetime,
	@UnitPrice money,
	@Comments nvarchar(1000) = NULL,
	@DateRequired DATETIME = NULL,
	@E_POItem NVARCHAR(20) = NULL,
	@Hide BIT = NULL,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@VersionNo INT,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

IF @Hide  IS NULL
	SET @Hide = 0

IF NOT EXISTS(SELECT * FROM PM_ConsignmentItems WHERE (ConsignmentItemID = @ConsignmentItemID))
BEGIN --Append record
	IF @RecordStatus < 201 AND EXISTS(SELECT ConsignmentID FROM PM_Consignment WHERE (ConsignmentID = @ConsignmentID))
	BEGIN
		INSERT INTO PM_ConsignmentItems
                      (ConsignmentItemID, ConsignmentID, StockCodeID, Quantity, UnitStockCodeID, UnitQuantity, QuantityAccepted, DepotDate, UnitPrice, Comments, DateRequired, 
                      E_POItem, Hide, RecordStatus, GUID,VersionNo)
		VALUES     (@ConsignmentItemID,@ConsignmentID,@StockCodeID,@Quantity,@UnitStockCodeID,@UnitQuantity,@QuantityAccepted,@DepotDate,@UnitPrice,@Comments,@DateRequired,@E_POItem,@Hide,@RecordStatus,@GUID,@VersionNo)
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    PM_ConsignmentItems
	SET              StockCodeID = @StockCodeID, Quantity = @Quantity, UnitStockCodeID = @UnitStockCodeID, UnitQuantity = @UnitQuantity, QuantityAccepted = @QuantityAccepted, 
                      DepotDate = @DepotDate, UnitPrice = @UnitPrice, Comments = @Comments, DateRequired = @DateRequired, E_POItem = @E_POItem, Hide = @Hide, 
                      RecordStatus = @RecordStatus, VersionNo=@VersionNo
	WHERE     (ConsignmentItemID = @ConsignmentItemID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'APP_Temp_ReportFilter')
	EXEC ('CREATE PROCEDURE [dbo].[APP_Temp_ReportFilter] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		JToolan
-- Create date: 22/03/2012
-- Description:	Works out which ResponseIDs need to be put in the filter.
--              Can be used by any report.
-- Version:		18
-- =============================================
-- j.toolan 30-mar-2012: If @AssessmentTypeID_LIST is empty, then join all assessments
-- j.toolan 13 Apr 2012: Fixed bug with 2nd filter incorrectly clearing.
-- j.toolan 18 Apr 2012: Added Code to filter by stockcode where appropriate (renamed to ReportFilter)
-- JE 25 Apr 2012: made ReportFilterID1 optional, so can just filter by AssessmentType if necessary (TFS 3382)
-- j.toolan 6 July 2012: TFS 4013: Dynamic filtering added.
-- JE TFS 4740: removed GROUP BY for performance reasons
-- JE TFS 5037: corrected @ReportFilterID2 check as 2nd tier filter wasn't working
-- MP TFS 5289: changed date format used for custom filter functions
-- JT TFS 5396: changed code to allow commas in FilterTexts passed in as CSV. (replace "," with "&comma;" )
-- JT TFS 6689: FNC_CanUserDataWareHouse takes UserID parameter.
-- JT TFS 6689: FNC_ReportFilter_Response takes UserID parameter.
-- JT TFS 8117: Added offline filtering.
-- MP TFS 8227: Made temp table user specific and added performance logging
-- JE TFS 8274: Put result set of FNC_User_ResponseList into temp table before using it
-- JT TFS 13-667: Do not filter responses if the date range is too big.
-- JT TFS 13-1076: Search either QMS_Response or QMS_SupplierResponse, but not both.
-- JF TFS 2281 - if filter doesn't have a sourceid, this wasn't working
-- JT TFS 13-17467: Only include checks which are eligible candidates for the data warehouse.
-- =============================================
ALTER PROCEDURE APP_Temp_ReportFilter
	@UserID int,
	@DateFrom datetime,
	@DateTo datetime,
	@AssessmentTypeID_LIST nvarchar(255),

	@ReportFilterID1 int = NULL,
	@FilterID_LIST nvarchar(4000),
	@FilterText_LIST nvarchar(4000),
	@ReportFilterID2 int = NULL,
	@FilterID2 int = NULL,
	@FilterText2 nvarchar(255) = NULL,
	
	@Offline bit = NULL,
	@SearchLocalChecksIfOffline bit = 1 -- Use QMS_Response even if offline (default)
AS
BEGIN
	SET NOCOUNT ON
	
	DECLARE @DateCalled DATETIME
	SET @DateCalled = GETDATE()	
	IF @Offline IS NULL SELECT @Offline = CASE WHEN db_name() = 'GreenlightQC_Mobile' THEN 1 ELSE 0 END
	
	DECLARE @SearchOffline bit -- if this is set, then we search in QMS_SupplierResponse.
	SELECT @SearchOffline  = CASE WHEN @Offline = 1 AND @SearchLocalChecksIfOffline = 0 THEN 1 ELSE 0 END
		
	-- Do not filter responses if the date range is not specified
	DECLARE @performResponseFiltering bit 
	SELECT @performResponseFiltering = CASE WHEN @DateFrom <= '1 Jan 2001' and datediff(year, @DateFrom, @DateTo) >= 10 THEN 0 ELSE 1 END
	
	DELETE TEMP_ResponseFilter WHERE UserID = @UserID
	DELETE TEMP_StockCodeFilter WHERE UserID = @UserID

	-- If the first criteria is empty, but the second is not, swap them over.
	IF (LEN(@FilterID_LIST) = 0 AND LEN(@FilterText_LIST) = 0 -- first criteria is empty?!
	AND @ReportFilterID2 IS NOT NULL AND (@FilterID2 IS NOT NULL OR @FilterText2 IS NOT NULL)) -- but the second is not...
	BEGIN -- The great fairness swaparoo! (in two steps)
		SELECT	@ReportFilterID1 = @ReportFilterID2,
				@FilterID_LIST = CONVERT(nvarchar(4000), @FilterID2),
				@FilterText_LIST = @FilterText2
				
		SELECT @ReportFilterID2 = NULL, @FilterID2 = NULL, @FilterText2 = NULL
	END

	-- Is the second question correctly formulated? You must have an id or a text (or both) but not neither.
	-- JE TFS 5037 - corrected this as it was always setting @ReportFilterID2 to NULL for filters with no ID (i.e. text only)
	IF @ReportFilterID2 IS NOT NULL AND (NULLIF(@FilterID2, 0) IS NULL) AND (LEN(ISNULL(@FilterText2, '')) = 0)
	BEGIN
		SET @ReportFilterID2 = NULL
	END

	DECLARE @FilterItem TABLE (pos int not null, id int, txt nvarchar(255))
	INSERT @FilterItem (pos, id, txt)
	
	-- tfs 2281 - if filter doesn't have a sourceidm this wasn't working
	SELECT 	ISNULL(a.Position, b.Position) pos, CONVERT(int, ISNULL(a.Token,0)) id, replace(b.Token, '&comma;', ',') txt
	FROM dbo.FNC_SplitString(@FilterID_LIST, ',') a
	FULL JOIN dbo.FNC_SplitString(@FilterText_LIST, ',') b on a.Position = b.Position

	DECLARE @AssessmentType TABLE (id int not null)
	INSERT @AssessmentType (id) 
	SELECT CONVERT(int, Token) FROM dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',')
	INNER JOIN APP_AssessmentType ON CONVERT(int, Token) = AssessmentTypeID 
	IF NOT EXISTS (SELECT * FROM @AssessmentType) 
	BEGIN -- if we tried to join, and got nothing, that means that this report wants all non-hidden types.
		INSERT @AssessmentType (id) SELECT AssessmentTypeID FROM APP_AssessmentType WHERE Hide = 0
	END

	-- Do some custom filtering if it is set up. This acts like "AND" (restricting results)
	DECLARE @CustomFilterFunction nvarchar(50)
	SET @CustomFilterFunction = NULL
	SELECT @CustomFilterFunction = APP_ReportFilter.FilterFunction 
	FROM APP_ReportFilter 
	WHERE ReportFilterID = @ReportFilterID1
	
	DECLARE @customSql nvarchar(1000)
	SET @customSql = NULL
	CREATE TABLE #tmpCustomFilter (UserID INT, ResponseID int, GroupByText nvarchar(50))

	DECLARE @FilteredStockCode TABLE (id int not null)
	DECLARE @FilteredResponse TABLE (id int not null)
	WHILE EXISTS (SELECT * FROM @FilterItem)
	BEGIN
		DECLARE @pos int, @FilterID int, @FilterText nvarchar(255)
		SELECT @pos = pos,  @FilterID = id, @FilterText = txt
		FROM @FilterItem
		WHERE pos = (SELECT MIN(pos) FROM @FilterItem)

		IF @performResponseFiltering = 1
		BEGIN
			-- either the custom function runs, *OR* the generic one, *OR* the offline one, but not more than one.
			IF @SearchOffline = 1
			BEGIN
				INSERT @FilteredResponse (id)
				SELECT ResponseID 
				FROM dbo.FNC_ReportFilter_Response_Offline(@ReportFilterID1, @FilterID, @FilterText, @DateFrom, @DateTo, @UserID)
			END
			ELSE IF @CustomFilterFunction IS NOT NULL
			BEGIN
				SELECT @customSql = 'INSERT #tmpCustomFilter (UserID, ResponseID, GroupByText) SELECT ' + convert(nvarchar(10), @UserID) + ' AS UserID, ResponseID, GroupByText FROM dbo.[' + @CustomFilterFunction + ']' + 
									'(' + convert(nvarchar(10), @UserID) + ', ' +
									convert(nvarchar(30), @FilterID) + ', ' +
									'''' + convert(nvarchar(50), @FilterText) + ''', ' + 
									'''' + convert(nvarchar(30), @DateFrom, 13) + ''', ' +
									'''' + convert(nvarchar(30), @DateTo, 13) + ''');'
				
				PRINT @customSql
				
				IF @customSql IS NOT NULL
					EXECUTE (@customSql)
			END
			ELSE
			BEGIN
				INSERT @FilteredResponse (id)
				SELECT ResponseID 
				FROM dbo.FNC_ReportFilter_Response(@ReportFilterID1, @FilterID, @FilterText, @DateFrom, @DateTo, @UserID)
			END
		END
		
		INSERT @FilteredStockCode (id)
		SELECT StockCodeID
		FROM dbo.FNC_ReportFilter_StockCode(@ReportFilterID1, @FilterID, @FilterText, @DateFrom, @DateTo)
		
		DELETE @FilterItem WHERE pos = @pos
	END

	-- insert all our new custom filtered items (added to temp table in loop above)
	INSERT @FilteredResponse (id)
	SELECT ResponseID 
	FROM #tmpCustomFilter
	WHERE UserID = @UserID

	-- If there is another filter, it acts as an "AND" (restricting results returned), not an "OR" (expanding results returned). 
	IF @ReportFilterID2 IS NOT NULL
	BEGIN 
		IF @performResponseFiltering = 1
		BEGIN
			DECLARE @SecondFilteredResponse TABLE (id int)
			
			SELECT @CustomFilterFunction = APP_ReportFilter.FilterFunction 
			FROM APP_ReportFilter 
			WHERE ReportFilterID = @ReportFilterID2
		
			IF @SearchOffline = 1
			BEGIN
				INSERT @SecondFilteredResponse (id)
				SELECT ResponseID 
				FROM dbo.FNC_ReportFilter_Response_Offline(@ReportFilterID2, @FilterID2, @FilterText2, @DateFrom, @DateTo, @UserID)
			END 
			ELSE IF @CustomFilterFunction IS NOT NULL
			BEGIN
				DELETE #tmpCustomFilter WHERE UserID = @UserID --clear it out for second filter.
				
				SELECT @customSql = 'INSERT #tmpCustomFilter (UserID, ResponseID, GroupByText) SELECT ' + convert(nvarchar(10), @UserID) + ' AS UserID, ResponseID, GroupByText FROM dbo.[' + @CustomFilterFunction + ']' + 
									'(' + convert(nvarchar(10), @UserID) + ', ' +
									convert(nvarchar(30), @FilterID2) + ', ' +
									'''' + convert(nvarchar(50), @FilterText2) + ''', ' + 
									'''' + convert(nvarchar(30), @DateFrom, 13) + ''', ' +
									'''' + convert(nvarchar(30), @DateTo, 13) + ''');'

				IF @customSql IS NOT NULL
					EXECUTE (@customSql)
				
				INSERT @SecondFilteredResponse (id)
				SELECT ResponseID FROM #tmpCustomFilter WHERE UserID = @UserID
			END
			ELSE
			BEGIN
				INSERT @SecondFilteredResponse (id)
				SELECT ResponseID 
				FROM dbo.FNC_ReportFilter_Response (@ReportFilterID2, @FilterID2, @FilterText2, @DateFrom, @DateTo, @UserID)
			END
			
			DELETE @FilteredResponse 
			WHERE id NOT IN (
				SELECT id FROM @SecondFilteredResponse
			)
		END
		
		DELETE @FilteredStockCode 
		WHERE id NOT IN (
			SELECT StockCodeID 
			FROM dbo.FNC_ReportFilter_StockCode (@ReportFilterID2, @FilterID2, @FilterText2, @DateFrom, @DateTo)
		)
	END

	-- Remove all responses which are not suitable candidates for the data warehouse
	DELETE @FilteredResponse
	WHERE dbo.FNC_Response_ShouldIncludeInDataWarehouse(id) = 0


	IF @performResponseFiltering = 1
	BEGIN
		IF @SearchOffline = 1
		BEGIN
			IF @ReportFilterID1 IS NOT NULL
				INSERT TEMP_ResponseFilter (UserID, ResponseID)
				SELECT @UserID as UserID, r.ResponseID 
				FROM QMS_SupplierResponse r
				INNER JOIN @AssessmentType at ON r.AssessmentTypeID = at.id
				INNER JOIN @FilteredResponse fr ON fr.id = r.ResponseID
				WHERE EndDate BETWEEN @DateFrom AND @DateTo
				AND   r.ResponseID NOT IN (SELECT ResponseID FROM TEMP_ResponseFilter WHERE UserID = @UserID)
				GROUP BY r.ResponseID
			ELSE
				INSERT TEMP_ResponseFilter (UserID, ResponseID)
				SELECT @UserID as UserID, r.ResponseID 
				FROM QMS_SupplierResponse r 
				INNER JOIN @AssessmentType at ON r.AssessmentTypeID = at.id	
				WHERE EndDate BETWEEN @DateFrom AND @DateTo
				AND   r.ResponseID NOT IN (SELECT ResponseID FROM TEMP_ResponseFilter WHERE UserID = @UserID)
				GROUP BY r.ResponseID
		END
		ELSE
		BEGIN
			--JE TFS 82774 - temp table of responses user can view (moved from direct access in query to improve performance)
			IF nullif(object_id('tempdb..#tmpUserResponses'), 0) IS NOT NULL DROP TABLE #tmpUserResponses
			SELECT	@UserID AS UserID, ResponseID, ResponseStatus, QAFlagID
			INTO	#tmpUserResponses
			FROM	dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo)

			IF @ReportFilterID1 IS NOT NULL
				-- Only return responses that the user is allowed to see, filter by Assessment Type, and use filter
				INSERT TEMP_ResponseFilter (UserID, ResponseID)
				SELECT @UserID as UserID, rl.ResponseID
				FROM #tmpUserResponses AS rl
				INNER JOIN QMS_Response r ON rl.ResponseID = r.ResponseID 
				INNER JOIN @AssessmentType at ON r.AssessmentTypeID = at.id
				INNER JOIN @FilteredResponse fr ON fr.id = r.ResponseID
				WHERE rl.UserID = @UserID
				GROUP BY rl.ResponseID
			
			IF @ReportFilterID1 IS NULL
				-- Only return responses that the user is allowed to see, but there has been no filter specified, so only filter by Assessment Type (if specified)
				INSERT TEMP_ResponseFilter (UserID, ResponseID)
				SELECT @UserID as UserID, rl.ResponseID
				FROM #tmpUserResponses AS rl
				INNER JOIN QMS_Response r ON rl.ResponseID = r.ResponseID 
				INNER JOIN @AssessmentType at ON r.AssessmentTypeID = at.id
				WHERE rl.UserID = @UserID	
				GROUP BY rl.ResponseID
			
			DROP TABLE #tmpUserResponses
		END

	END
	-- Only return stock codes that the user is allowed to see
	INSERT TEMP_StockCodeFilter (UserID, StockCodeID)
	SELECT @UserID as UserID, fs.id
	FROM @FilteredStockCode fs 
	INNER JOIN FNC_User_StockCodeList(@UserID) sl ON fs.id = sl.StockCodeID 
	--GROUP BY fs.id --removed in TFS 4740 as this was slowing the query down a LOT on JS UAT
	
	DECLARE @MonitorEnabled TINYINT
	SELECT @MonitorEnabled = ISNULL(dbo.FNC_GetOptionValue(92),0)

	IF @MonitorEnabled = 1 --Log filter to QMS_PerformanceLog
	BEGIN
		DECLARE @ReportString NVARCHAR(max)
		SET @ReportString = 'APP_Temp_ReportFilter '
		SET @ReportString = @ReportString + '@UserID = ' + CAST(@UserID AS NVARCHAR(10))
		SET @ReportString = @ReportString + ', @DateFrom = ' + CAST(@DateFrom AS NVARCHAR(11))
		SET @ReportString = @ReportString + ', @DateTo = ' + CAST(@DateTo AS NVARCHAR(11))
		SET @ReportString = @ReportString + ', @AssessmentTypeID_LIST = ' + CASE WHEN LEN(@AssessmentTypeID_LIST)=0 THEN 'NULL' ELSE @AssessmentTypeID_LIST END
		IF @ReportFilterID1>0
		BEGIN
			SET @ReportString = @ReportString + ', @ReportFilterID1 = ' + CAST(@ReportFilterID1 AS NVARCHAR(10))
			SET @ReportString = @ReportString + ', @FilterID_LIST = ' + CASE WHEN LEN(@FilterID_LIST)=0 THEN 'NULL' ELSE @FilterID_LIST END
			SET @ReportString = @ReportString + ', @FilterText_LIST = ' + CASE WHEN LEN(@FilterText_LIST)=0 THEN 'NULL' ELSE @FilterText_LIST END
		END
		IF @ReportFilterID2>0
		BEGIN
			SET @ReportString = @ReportString + ', @ReportFilterID2 = ' + CAST(@ReportFilterID2 AS NVARCHAR(10))
			SET @ReportString = @ReportString + ', @FilterID2 = ' + CAST(@FilterID2 AS NVARCHAR(10))
			SET @ReportString = @ReportString + ', @FilterText2 = ' + CASE WHEN LEN(@FilterText2)=0 THEN 'NULL' ELSE @FilterText2 END
		END
		
		DECLARE @ResponseCount INT
		SELECT @ResponseCount = COUNT(ResponseID) FROM TEMP_ResponseFilter WHERE UserID = @UserID
		
		INSERT INTO dbo.QMS_PerformanceLog
				( Action ,
				  StartTime ,
				  EndTime ,
				  RecordsAffected
				)
		VALUES  ( @ReportString ,
				  @DateCalled ,
				  GETDATE() ,
				  @ResponseCount
				  )
	END

	SET NOCOUNT OFF
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_AssessmentType_Combo')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_AssessmentType_Combo] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 03/07/2008
-- Description:	Gets data to fill assessment type combo
-- Version: 2
-- =============================================
-- jf tfs 19352 German Translation - Scorecard Report pop up not translated
-- =============================================
alter  PROCEDURE [dbo].[QRY_AssessmentType_Combo] 
	@UserID int = null

AS

SELECT     AssessmentTypeID, 
--AssessmentType
ISNULL(dbo.FNC_ResourceString_User(APP_AssessmentType.ResourceName, @UserID), APP_AssessmentType.AssessmentType) AS AssessmentType

FROM         APP_AssessmentType
WHERE     (Hide = 0)
ORDER BY ListIndex

GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'RPT_DailySummary_FillSelected')
	EXEC ('CREATE PROCEDURE [dbo].[RPT_DailySummary_FillSelected] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: unknown
-- Description:	Gets data for Daily summary report header
-- Version:		6
-- =============================================
-- JE TFS 4675: added Assessment Types param
-- JE TFS 4777: added provision for two tier filtering
-- JE TFS 5040: removed Location filtering as two tier filtering now implemented
-- JE TFS 5379: reinstated join on TEMP_ResponseFilter
-- JT TFS 13-8538: Log ResponseIDs to DEBUG tables to determine source of issues with daily reports.
-- JT TFS 13-17467: Removed DEBUG tables after finding sourse of issues.
-- =============================================
ALTER PROCEDURE [dbo].[RPT_DailySummary_FillSelected] 
	@UserID int,
    @AssessmentTypeID_LIST nvarchar(100)
AS
BEGIN
	--Clear temp selected
	DELETE FROM TEMP_Selected
	WHERE     (UserID = @UserID)

	--Insert into temp selected
	INSERT INTO TEMP_Selected
						  (SelectedID, UserID)
	SELECT     QMS_Response.ResponseID, @UserID AS UserID
	FROM         QMS_Response INNER JOIN
						  TEMP_ResponseFilter ON QMS_Response.ResponseID = TEMP_ResponseFilter.ResponseID
	WHERE     (QMS_Response.ResponseStatus = 1) AND (TEMP_ResponseFilter.UserID = @UserID) AND
					(@AssessmentTypeID_LIST = '0' OR
						QMS_Response.AssessmentTypeID IN (SELECT	CAST(Token AS int) AS AssessmentTypeID
															FROM	dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',') AS SplitString_AssessmentType))

END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_CorrectiveAction')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_CorrectiveAction] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 01/08/2008
-- Description:	Saves corrective action
-- Version:		13
-- =============================================
-- j.toolan 21 Feb 2012: Added ReminderDate
-- j.toolan  7 Mar 2012: Reset NotifcationSent on 6 if AssignSupplierID set (only if status changes)
-- MP TFS 5873 - Made sure SourceObjectID updated so that correct links to response created
-- JE TFS 7087 - added CorrectiveActionTypeID to UPDATE statement
-- JE TFS 7877 - corrected resetting of NotifcationSent for Completed alerts
-- JE TFS 7836 - updated to save LocationID CA is assigned
-- JT TFS 13-7950 - Make sure that if CorrectiveActionTypeID is specified, and CorrectiveActionEscalationID is NOT, then set it.
-- JE TFS 13-12635: call new SAVE_CorrectiveActionUser SP to save permissions data to QMS_CorrectiveActionUser table
-- MP TFS 13-15377: excluded call to new SAVE_CorrectiveActionUser SP for mobile
-- AC TFS 6335: Changes the escalation if the corrective action type or notification user group is changed
-- PH TFS 13-19579: 06/05/2015 - Made compatible with WebChecks service/EF.  @CorrectiveActionID must have default (null or zero) because stripped out by EF when adding record and @CorrectiveActionID must be returned AS CorrectiveActionID.
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_CorrectiveAction]
	@CorrectiveActionID int = NULL,
	@CASourceID int,
	@SourceObjectID int,
	@CATitle nvarchar(50),
	@CASubTitle nvarchar(50),
	@CAReason nvarchar(1000),
	@CARequired nvarchar(1000),
	@CAStatusID int,
	@CorrectiveActionTypeID int,
	@CorrectiveActionEscalationID int,
	@NotificationGroupID int,
	@AssignUserID int,
	@DateOccurred datetime,
	@PriorityLevelID int,
	@DateLogged datetime,
	@DateDeadline datetime,
	@ActionTaken nvarchar(1000),
	@Comments nvarchar(1000),
	@DateCompleted datetime,
	@Completed_UserID int,
	@Completed_MachineName nvarchar(50),
	@DateSignedOff datetime,
	@SignOff_UserID int,
	@SignOff_MachineName nvarchar(50),
	@UserID int,
	@AssignSupplierID int,
	@ReminderDate datetime,
	@ReminderSent bit = NULL, -- This is not saved currently.
	@LocationID int
AS
BEGIN
	SET NOCOUNT ON

	-- BUG 7950 SP FIX
	SELECT @LocationID = NULLIF(@LocationID, 0) -- Do not allow zero for LocationID. It stops first new CA alert going out.

	DECLARE @DefaultCorrectiveActionEscalationID int
	SELECT @DefaultCorrectiveActionEscalationID = CorrectiveActionEscalationID 
	FROM QMS_CorrectiveActionEscalation 
	WHERE CorrectiveActionTypeID = @CorrectiveActionTypeID
	AND ListIndex = (	SELECT min(ListIndex) FROM QMS_CorrectiveActionEscalation 
						WHERE CorrectiveActionTypeID = @CorrectiveActionTypeID)
	-- END BUG 7950 fix

	IF ISNULL(@CorrectiveActionID,0)=0 --New record
	BEGIN
		INSERT INTO QMS_CorrectiveAction
						  (CASourceID, SourceObjectID, CATitle, CASubTitle, CAReason, CARequired, CAStatusID, CorrectiveActionTypeID, CorrectiveActionEscalationID, NotificationGroupID, 
						  AssignUserID, DateOccurred, PriorityLevelID, DateLogged, DateDeadline, Logged_UserID, Logged_MachineName, ActionTaken, Comments, DateCompleted, 
						  Completed_UserID, Completed_MachineName, AssignSupplierID, ReminderDate, LocationID)
		VALUES     (@CASourceID,@SourceObjectID,@CATitle,@CASubTitle,@CAReason,@CARequired,@CAStatusID,@CorrectiveActionTypeID,
					ISNULL(@CorrectiveActionEscalationID, @DefaultCorrectiveActionEscalationID),
					@NotificationGroupID,@AssignUserID,@DateOccurred,@PriorityLevelID,@DateLogged,@DateDeadline,@UserID,
						   HOST_NAME(),@ActionTaken,@Comments,@DateCompleted,@Completed_UserID,@Completed_MachineName,@AssignSupplierID, @ReminderDate, @LocationID)
	                      
		--Get new ID
		SELECT     @CorrectiveActionID = MAX(CorrectiveActionID)
		FROM         QMS_CorrectiveAction
	END
	ELSE --Update record
	BEGIN
		DECLARE @originalCAStatusID int
		SELECT	@originalCAStatusID = CAStatusID 
		FROM	QMS_CorrectiveAction
		WHERE	CorrectiveActionID = @CorrectiveActionID
		
		DECLARE @originalCorrectiveActionTypeID int
		DECLARE @originalNotificationGroupID int
		
		SELECT	@originalCorrectiveActionTypeID = CorrectiveActionTypeID, @originalNotificationGroupID = NotificationGroupID
		FROM	QMS_CorrectiveAction
		WHERE	CorrectiveActionID = @CorrectiveActionID
		
		-- Only update the escalation if the corrective action type or the notification user group has changed
		IF (@originalCorrectiveActionTypeID <> @CorrectiveActionTypeID OR @originalNotificationGroupID <> @NotificationGroupID)
		BEGIN
			SET @CorrectiveActionEscalationID = NULL
			SELECT @CorrectiveActionEscalationID = CorrectiveActionEscalationID
			FROM QMS_CorrectiveActionEscalation
			WHERE CorrectiveActionTypeId = @CorrectiveActionTypeId
			AND NotificationGroupId = @NotificationGroupId
		END

		UPDATE    QMS_CorrectiveAction
		SET              SourceObjectID = @SourceObjectID, CATitle = @CATitle, CASubTitle = @CASubTitle, CAReason = @CAReason, CARequired = @CARequired, 
							  CAStatusID = @CAStatusID, CorrectiveActionTypeID = @CorrectiveActionTypeID, NotificationGroupID = @NotificationGroupID, AssignUserID = @AssignUserID, DateOccurred = @DateOccurred, 
							  PriorityLevelID = @PriorityLevelID, DateDeadline = @DateDeadline, ActionTaken = @ActionTaken, Comments = @Comments, DateCompleted = @DateCompleted, 
							  Completed_UserID = @Completed_UserID, Completed_MachineName = @Completed_MachineName, DateSignedOff = @DateSignedOff, 
							  SignOff_UserID = @SignOff_UserID, SignOff_MachineName = @SignOff_MachineName, 
							  RecordStatus = CASE WHEN RecordStatus = 30 THEN 20 ELSE RecordStatus END, Updated = GETUTCDATE(), AssignSupplierID = @AssignSupplierID, 
							  ReminderDate = @ReminderDate, LocationID = @LocationID, CorrectiveActionEscalationID = @CorrectiveActionEscalationID
		WHERE     (CorrectiveActionID = @CorrectiveActionID)

		-- Only update notification flag if the status has changed.
		IF (@originalCAStatusID <> @CAStatusID)
		BEGIN
				--get Failure_NotificationGroupID for current CA escalation
			DECLARE @Failure_NotificationGroupID int 
			SELECT     @Failure_NotificationGroupID = Failure_NotificationGroupID
			FROM         QMS_CorrectiveActionEscalation
			WHERE     (CorrectiveActionEscalationID = @CorrectiveActionEscalationID)

			--if CA being set to Complete and a Failure_NotificationGroup has been set, reset NotificationGroup flag
			IF @CAStatusID = 4 --AND @Failure_NotificationGroupID IS NOT NULL --removed for TFS 7877 as this stops Completed alerts firing when no Failure_NotificationGroupID set
			BEGIN
				UPDATE	QMS_CorrectiveAction
				SET		NotificationSent = 0
				WHERE	(CorrectiveActionID = @CorrectiveActionID)
			END
			
				--if CA being set to Signed-off and AssignSupplierID has been set, reset NotificationGroup flag
			IF @CAStatusID IN (5, 6) AND @AssignSupplierID IS NOT NULL
			BEGIN
				UPDATE	QMS_CorrectiveAction
				SET		NotificationSent = 0
				WHERE	(CorrectiveActionID = @CorrectiveActionID)
			END
		END
	END
	SET NOCOUNT OFF

	--save data for CA to QMS_CorrectiveActionUser (should handle both new and updated CAs as @CorrectiveActionID is set either way)
    IF DB_NAME() LIKE 'GreenlightQC_Mobile%'
        BEGIN --Add current user to current corrective action
            IF NOT EXISTS ( SELECT  CorrectiveActionID
                            FROM    dbo.QMS_CorrectiveActionUser
                            WHERE   UserID = @UserID
                                    AND CorrectiveActionID = @CorrectiveActionID )
                INSERT  INTO dbo.QMS_CorrectiveActionUser
                        ( CorrectiveActionID, UserID )
                VALUES  ( @CorrectiveActionID, -- CorrectiveActionID - int
                          @UserID -- UserID - int
                          )
        END
    ELSE
        EXEC SAVE_CorrectiveActionUser @CorrectiveActionID
	

	SELECT @CorrectiveActionID AS CorrectiveActionID
END

GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_NotificationGroupUser')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_NotificationGroupUser] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 08/07/2008
-- Description:	Adds and edits notification users
-- Version:		3
-- =============================================
-- JE TFS 13-12639: update QMS_CorrectiveActionUser when group's users have been changed
-- JT TFS 13-16507: Full refresh has to be done of CA List when removing user, in case user could see that CA, but also assigned to it.
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_NotificationGroupUser]
	@NotificationGroupUserID int,	
	@NotificationGroupID int,
	@UserID int
AS
BEGIN
	SET NOCOUNT ON

	IF ISNULL(@NotificationGroupUserID,0)=0 --New record
	BEGIN
		INSERT INTO QMS_NotificationGroupUser
						  (NotificationGroupID, UserID)
		VALUES     (@NotificationGroupID,@UserID)
		--Get new ID
		SELECT     @NotificationGroupUserID = MAX(NotificationGroupUserID)
		FROM         QMS_NotificationGroupUser
	END
	ELSE --Update record
	BEGIN	
		UPDATE    QMS_NotificationGroupUser
		SET              UserID = @UserID, Updated = GETUTCDATE()
		WHERE     (NotificationGroupUserID = @NotificationGroupUserID)
	END

	-- JE TFS 13-12639: update CA assignments based on updates to notification groups
	-- JT TFS 13-16507: Full refresh has to be done when removing user, in case user could see that CA, but also assigned to it.
	EXEC SAVE_CorrectiveActionUser_ByUser @UserID = @UserID


	SET NOCOUNT OFF

	SELECT @NotificationGroupUserID
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_User')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_User] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 30/06/2008
-- Description:	Adds and edits user details
-- Version:		9
-- =============================================
-- J.Toolan 13 Feb 2012: Stopped code from adding more than one username
-- J.Toolan 8 Mar 2012: Added SHA2 password field to update/insert
-- MarkP 1 Jun 2012: Made sure UserPermissions.Updated is set
-- JToolan 12 Jun 2012: TFS 3905 - Stopped Password resetting on NULL entry.
-- JT TFS 6629 - Use UP_User_Password to write passwords.
-- JT TFS 13-11261 - Add new admin users to the AdminAlerts group (ignore existing users).
-- JT TFS 13-11810 - User can have their CustomerID changed when only one specified.
-- JT TFS 13-17956 - Creating a user or updating and changing the supplier should trigger a corrective action rebuild.
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_User] 
	@UserID int,
	@FullName nvarchar(255),
	@UserName nvarchar(255),
	@Password nvarchar(255) = NULL,
	@Position nvarchar(255),
	@Company nvarchar(255),
	@EMail nvarchar(100),
	@Mobile nvarchar(50),
	@PIN nvarchar(10),
	@LeftCompany bit,
	@UserLevel int,
	@LocaleID int,
	@IsUserGroup bit,
	@ParentUserID int,
	@SupplierID int = NULL,
	@CustomerID int = NULL,
	@Password_MD5 nvarchar(255) = NULL,
	@Password_SHA2 nvarchar(255) = NULL
AS
BEGIN 
	SET NOCOUNT ON

	DECLARE @originalSupplier TABLE (SupplierID int)
	INSERT @originalSupplier (SupplierID)
	SELECT  CAST(PermissionTitle AS int)
	FROM         QMS_UserPermissions
	WHERE	(PermissionType = 101) 
	AND		(PermissionAllow = 1)
	AND		(UserID = @UserID)

	DECLARE @IsCARebuildRequired bit
	SELECT @IsCARebuildRequired = CASE	WHEN ISNULL(@UserID,0) = 0 THEN 1 -- yes for new users.
										WHEN @SupplierID < 0 AND (SELECT count(*) FROM @originalSupplier) > 1 THEN 0 -- no if multiple suppliers already specified.
										WHEN (SELECT count(*) FROM @originalSupplier) > 1 THEN 1 -- used to have multiple - not any more. Zero or one now.
										WHEN EXISTS (SELECT * FROM @originalSupplier WHERE SupplierID = @SupplierID) THEN 0 -- no if supplier already correct.
										ELSE 1 -- yes - the supplier has changed.
										END

	IF ISNULL(@UserID,0)=0 --New user
	BEGIN
		IF NOT EXISTS (SELECT * FROM QMS_User WHERE RecordStatus < 201 AND UserName = @UserName COLLATE Latin1_General_ci_ai)
		BEGIN
			INSERT INTO QMS_User(FullName,	UserName,	Position,	EMail,	Mobile,		PIN,	LeftCompany,	UserLevel,	LocaleID,	IsUserGroup,	ParentUserID,	Company)
			VALUES				(@FullName,	@UserName,	@Position,	@EMail,	@Mobile,	@PIN,	@LeftCompany,	@UserLevel,	@LocaleID,	@IsUserGroup,	@ParentUserID,	@Company)
			--Get new UserID
			SELECT @UserID = SCOPE_IDENTITY()
		
			EXEC UP_User_Password @UserName, @Password, @Password_MD5, @Password_SHA2

			-- INSERT INTO ADMIN NOTIFICATION GROUP 11261

			DECLARE @NotificationGroupID int
			SELECT @NotificationGroupID = NotificationGroupID
			FROM QMS_NotificationGroup WHERE Sys_Group = 'AdminAlerts'

			INSERT QMS_NotificationGroupUser (NotificationGroupID, UserID, RecordStatus)
			SELECT @NotificationGroupID, UserID, 2
			FROM QMS_User 
			WHERE dbo.FNC_GetUserLevel(UserID) = 1 
			AND RecordStatus < 201
			AND UserID = @UserID
			AND NOT EXISTS (SELECT * FROM QMS_NotificationGroupUser 
							WHERE NotificationGroupID = @NotificationGroupID 
							AND UserID = QMS_User.UserID
							AND RecordStatus < 201)

			-- END INSERT INTO ADMIN NOTIFICATION GROUP 11261

		END
	END
	ELSE --Update user
	BEGIN
	-- Don't change the username to an existing other username. It violates the single username principle of logging in.
		IF EXISTS (SELECT * FROM QMS_User WHERE RecordStatus < 201 AND UserName = @UserName COLLATE Latin1_General_ci_ai AND UserID <> @UserID)
		BEGIN
			SET @UserID = 0 -- This should cause the save procedure to fail.
		END
		ELSE
		BEGIN -- Username is still unique on all undeleted records.
			--JE - update passwords table (TFS 973)
			IF @Password IS NOT NULL
			BEGIN
				EXEC UP_User_Password @UserName, @Password, @Password_MD5, @Password_SHA2
			END

			UPDATE    QMS_User
			SET			FullName = @FullName, UserName = @UserName, Position = @Position, EMail = @EMail, Mobile = @Mobile, PIN = @PIN, 
						LeftCompany = @LeftCompany, UserLevel = @UserLevel, LocaleID = @LocaleID, IsUserGroup = @IsUserGroup, ParentUserID = @ParentUserID, 
						Company = @Company, Updated = GETUTCDATE()
			WHERE     (UserID = @UserID)
		END
	END

	DECLARE @PermissionID int = NULL
	IF ISNULL(@SupplierID,0) > 0 AND ISNULL(@UserID,0) > 0
	BEGIN --Setup linked supplier
		SELECT     @PermissionID = MAX(UserPermissionID)
		FROM         QMS_UserPermissions
		WHERE     (PermissionType = 101) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) = @SupplierID)
		IF ISNULL(@PermissionID,0)=0 --Add permission
		BEGIN
			INSERT INTO QMS_UserPermissions (UserID, PermissionType, PermissionTitle, PermissionAllow)
			VALUES     (@UserID, 101,@SupplierID, 1)
		END
		ELSE
		BEGIN
			UPDATE	QMS_UserPermissions
			SET		PermissionAllow = 1, Updated = GETUTCDATE()
			WHERE	(UserPermissionID = @PermissionID) AND (PermissionAllow = 0)
		END
	
		--Remove any existing permissions
		UPDATE  QMS_UserPermissions
		SET		PermissionAllow = 0, Updated = GETUTCDATE()
		WHERE   (PermissionType = 101) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) <> @SupplierID) AND (PermissionAllow = 1)
	END


	-- Setup CustomerID Link
	SET @PermissionID = NULL -- in case it has a previous value
	IF ISNULL(@CustomerID,0) > 0 AND ISNULL(@UserID,0) > 0
	BEGIN --Setup linked customer
		SELECT     @PermissionID = MAX(UserPermissionID)
		FROM         QMS_UserPermissions
		WHERE     (PermissionType = 102) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) = @CustomerID)
		IF ISNULL(@PermissionID,0)=0 --Add permission
		BEGIN
			INSERT INTO QMS_UserPermissions (UserID, PermissionType, PermissionTitle, PermissionAllow)
			VALUES     (@UserID, 102,@CustomerID, 1)
		END
		ELSE
		BEGIN
			UPDATE	QMS_UserPermissions
			SET		PermissionAllow = 1, Updated = GETUTCDATE()
			WHERE	(UserPermissionID = @PermissionID) AND (PermissionAllow = 0)
		END
	
		--Remove any existing permissions
		UPDATE  QMS_UserPermissions
		SET		PermissionAllow = 0, Updated = GETUTCDATE()
		WHERE   (PermissionType = 102) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) <> @CustomerID) AND (PermissionAllow = 1)
	END

	IF @IsCARebuildRequired = 1
		EXEC SAVE_CorrectiveActionUser_ByUser @UserID

	SET NOCOUNT OFF

	SELECT @UserID
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_UserPermissions')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_UserPermissions] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 02/07/2008
-- Description:	Saves or deletes user permissions
-- Version:		8
-- =============================================
-- JT TFS 13-1791: Lookup UserPermissionID if not specified, and convert AppID to PermissionType.
-- JT TFS 13-4134: Added permissions for add/edit/delete for menu items added for mobile (AppID = 2).
-- JT TFS 13-4012: Added code to remove favourites of children as well as current user.
-- JE TFS 13-12638: update QMS_CorrectiveActionUser when permissions have been changed
-- JE TFS 13-13177: update Assigned column in QMS_CorrectiveActionUser
-- JT TFS 13-15105: Only update corrective action user list when datapermissions are changed, not favourites or menu permissions.
-- JT TFS 13-16507: Bug where assigned user can also see CA through permissions - row duplicated.
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_UserPermissions]
	@UserID int,
	@UserPermissionID int,
	@PermissionType int,
	@PermissionTitle nvarchar(255),
	@PermissionAllow bit,
	@ChangedBy int = NULL -- UserID of user who is changing this entry.
AS
BEGIN
	SET NOCOUNT ON
	IF @ChangedBy IS NULL SET @ChangedBy = @UserID

	-- If PermissionType is an AppID, then change it to be a PermissionType
	IF @PermissionType IN (0,1,2,3)
	BEGIN
		SELECT @PermissionType = 
			CASE	WHEN EXISTS (	SELECT * FROM APP_Menu 
									WHERE MenuID = convert(int, @PermissionTitle)
									AND ParentID IS NULL) 
					THEN 0 ELSE 1 END
		
		-- Remove any other permissions which link to this userpermission (favourites, homepage, reportfavourites)
		IF @PermissionAllow = 0
		BEGIN
			UPDATE QMS_UserPermissions
			SET PermissionAllow = 0,
				Updated = getutcdate(),
				Deleted = getutcdate(),
				Changed_UserID = @ChangedBy
			WHERE PermissionType IN (4, 20, 21)
			AND PermissionTitle = @PermissionTitle
			AND (	UserID = @UserID 
					OR 
					UserID IN (	SELECT UserID FROM QMS_User children
								WHERE ParentUserID = @UserID)
			)
			AND PermissionAllow <> 0 -- only update if it would change from 1 to 0.
		END
		
		-- Do a menu item check for mobile permissions (only on leaf items)
		IF EXISTS (SELECT * FROM APP_Menu 
					WHERE MenuID = convert(int, @PermissionTitle)
					AND AppID = 2)
		AND NOT EXISTS (SELECT * FROM APP_Menu
						WHERE ParentID = convert(int, @PermissionTitle)
						AND AppID = 2)
		BEGIN
			-- Ensure that three child permissions exist: add/edit/delete
			UPDATE QMS_UserPermissions
			SET PermissionAllow = @PermissionAllow,
				Updated = getutcdate(),
				Deleted = CASE WHEN @PermissionAllow = 0 THEN getutcdate() ELSE Deleted END,
				Changed_UserID = @ChangedBy
			WHERE PermissionType IN (11,12, 13)
			AND PermissionTitle = @PermissionTitle
			AND UserID = @UserID
			AND PermissionAllow <> @PermissionAllow
			
			INSERT QMS_UserPermissions (UserID, PermissionType, PermissionTitle, PermissionAllow, Changed_UserID)
			SELECT @UserID, PermissionType, @PermissionTitle, @PermissionAllow, @ChangedBy 
			FROM (SELECT 11 PermissionType UNION SELECT 12 UNION SELECT 13) as t
			WHERE NOT EXISTS (
				SELECT * FROM QMS_UserPermissions
				WHERE PermissionType = t.PermissionType
				AND PermissionTitle = @PermissionTitle
				AND UserID = @UserID
			)
		END
	END

	-- Modify this actual permission.
	IF @UserPermissionID = 0
	BEGIN
		-- Treat zero and one permissiontypes as identical.
		DECLARE @SearchType int
		SELECT @SearchType = CASE WHEN @PermissionType IN (0,1) THEN 0 ELSE @PermissionType END

		SELECT @UserPermissionID = UserPermissionID
		FROM QMS_UserPermissions
		WHERE UserID = @UserID 
		AND CASE WHEN PermissionType IN (0,1) THEN 0 ELSE PermissionType END = @SearchType 
		AND PermissionTitle = @PermissionTitle;
	END

	IF ISNULL(@UserPermissionID,0)=0 --New permission
	BEGIN
		DECLARE @UserPermissions TABLE( UserPermissionID int);

		INSERT INTO QMS_UserPermissions
					(UserID, PermissionType, PermissionTitle, PermissionAllow, Changed_UserID)
		OUTPUT INSERTED.UserPermissionID 
			INTO @UserPermissions 
		VALUES     (@UserID,@PermissionType,@PermissionTitle,@PermissionAllow, @ChangedBy)
		
		--Get new UserPermissionID
		SELECT     @UserPermissionID = MAX(UserPermissionID)
		FROM         @UserPermissions
	END
	ELSE
	BEGIN
		UPDATE  QMS_UserPermissions
		SET     PermissionType = @PermissionType, 
				PermissionTitle = @PermissionTitle, 
				PermissionAllow = @PermissionAllow, 
				Updated = GETUTCDATE(),
				-- only change deleted if allow is set to false.
				Deleted = CASE WHEN @PermissionAllow = 0 THEN getutcdate() ELSE Deleted END,
				Changed_UserID = @ChangedBy
		WHERE     (UserPermissionID = @UserPermissionID)
	END

	-- Only data permissions will change corrective action visibilities.
	IF @PermissionType >= 100
	BEGIN
		EXEC SAVE_CorrectiveActionUser_ByUser @UserID = @UserID
	END

	SET NOCOUNT OFF

	SELECT @UserPermissionID
END
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'UP_NotificationGroupUser_Delete')
	EXEC ('CREATE PROCEDURE [dbo].[UP_NotificationGroupUser_Delete] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 08/07/2008
-- Description:	Deletes notification user
-- Version:		3
-- =============================================
-- JE TFS 13-13183: update QMS_CorrectiveActionUser when a user is removed from a Notification Group
-- JT TFS 13-16507: Full refresh has to be done when removing user, in case user could see that CA, but also assigned to it.
-- =============================================
ALTER PROCEDURE [dbo].[UP_NotificationGroupUser_Delete]
	@NotificationGroupUserID int
AS
BEGIN
	UPDATE	QMS_NotificationGroupUser
	SET		RecordStatus = 201, Deleted = GETUTCDATE()
	WHERE	(NotificationGroupUserID = @NotificationGroupUserID)

	--get UserID for group membership we're removing
	DECLARE @UserID int
	SELECT	@UserID = UserID
	FROM	QMS_NotificationGroupUser
	WHERE	NotificationGroupUserID = @NotificationGroupUserID

	EXEC SAVE_CorrectiveActionUser_ByUser @UserID = @UserID
END
GO



PRINT 'Data migration tasks...'

PRINT 'Database updated successfully!'
GO
