-- =============================================
-- Author:		Jeremy Formby
-- Create date: 19/03/2015
-- Version:		0.1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 59
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO


--PRINT 'Inserting tables...'

--PRINT 'Updating tables...'

--PRINT 'Creating indexes...'

--PRINT 'Updating Views...'



--PRINT 'Dropping Views...'

--PRINT 'Updating User Defined Functions...'
--GO

--PRINT 'Updating Stored Procedures...'
--GO
IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Menu_ReportsForUser')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Menu_ReportsForUser] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Stephen Ford
-- Create date: 22.08.2013
-- Description:	Gets the reports menu items for a given user
-- Version:		4
-- =============================================
-- MP TFS 8723: Added distinct clause to ensure duplicate permissions are ignored
-- SF TFS 3812: Selcted PermissionTypes of 0 or 1 to bring in parent and child menu items
-- JT TFS 10279: Check that PermissionTitle is numeric before trying to cast it as int.
-- JT TFS 13-17677: PermissionTitle index bypasses check. Make sure that it can never be non-numeric before cast.
-- =============================================
ALTER PROCEDURE QRY_Menu_ReportsForUser
	@UserID int
AS
BEGIN
	SET NOCOUNT ON;
	DECLARE @AppID INT
	DECLARE @UserLevel INT
	DECLARE @UserIDForPermissions INT
	
	SELECT @AppId = 3

	SELECT     @UserLevel = ISNULL(User_Parent.UserLevel, QMS_User.UserLevel), @UserIDForPermissions = ISNULL(User_Parent.UserID, QMS_User.UserID)
	FROM         dbo.QMS_User LEFT OUTER JOIN
						  dbo.QMS_User AS User_Parent ON dbo.QMS_User.ParentUserID = User_Parent.UserID
	WHERE     (dbo.QMS_User.UserID = @UserID)

	SELECT DISTINCT 
                      APP_Menu.MenuID, APP_Menu.MenuIndex, APP_Menu.ParentID, ISNULL(dbo.FNC_ResourceString_User(APP_Menu.ResourceName, @UserID), 
                      APP_Menu.Description) AS MenuName, APP_Menu.IconName, APP_Menu.SeperatorBefore, APP_Menu.MenuAction, APP_Report.ReportDescription
	FROM         APP_Menu LEFT OUTER JOIN
                          (SELECT     CASE WHEN  ISNUMERIC(PermissionTitle) = 1 THEN PermissionTitle ELSE -1 END PermissionTitle, PermissionAllow
                            FROM          QMS_UserPermissions
                            WHERE      (UserID = @UserIDForPermissions) AND (PermissionType in (0,1) AND ISNUMERIC(PermissionTitle) = 1)) AS MenuPermissions ON 
                      APP_Menu.MenuID = CAST(MenuPermissions.PermissionTitle AS INT) LEFT OUTER JOIN
                      APP_Report ON APP_Menu.MenuAction = APP_Report.MenuAction
	WHERE     (APP_Menu.AppID = @AppID) AND (APP_Menu.Visible = 1) AND (@UserLevel = 1) AND (APP_Menu.ParentID = 199 OR
                      APP_Menu.ParentID IN
                          (SELECT     MenuID
                            FROM          APP_Menu
                            WHERE      (ParentID = 199))) OR
                      (APP_Menu.AppID = @AppID) AND (APP_Menu.Visible = 1) AND (@UserLevel <> 1) AND (APP_Menu.ParentID = 199 OR
                      APP_Menu.ParentID IN
                          (SELECT     MenuID
                            FROM          APP_Menu
                            WHERE      (ParentID = 199))) AND (MenuPermissions.PermissionAllow = 1) OR
                      (APP_Menu.MenuID = 199)
	ORDER BY APP_Menu.MenuIndex

    
END
GO


IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'SAVE_ErrorLog')
	EXEC ('CREATE PROCEDURE [dbo].[SAVE_ErrorLog] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author		:	MBS\Phil.Harding
-- Create date	:	10/04/2015
-- Description	:	Saves error log
-- Version		:	1
-- =============================================
-- PH TFS 13-17963 - For WebChecks to log errors
-- =============================================

ALTER PROCEDURE [dbo].[SAVE_ErrorLog]
@ErrorLogID int = NULL,
@ErrorSource nvarchar(255),
@ErrorDescription nvarchar(255),
@StackTrace  nvarchar(4000),
@AppName nvarchar(50),
@AppVersion nvarchar(50),
@Workstation nvarchar(50),
@LoggedUserID int,
@Occured datetime
AS

SET NOCOUNT ON

IF ISNULL(@ErrorLogID,0)=0 --New record
BEGIN
	INSERT INTO QMS_ErrorLog
		(ErrorSource, ErrorDescription, StackTrace, AppName, AppVersion, Workstation, LoggedUserID, Occured)
	VALUES     (@ErrorSource, @ErrorDescription, @StackTrace, @AppName, @AppVersion, @Workstation, @LoggedUserID, @Occured)
	--Get new ID
	SELECT     @ErrorLogID = SCOPE_IDENTITY()
END
ELSE --Update record
	UPDATE    QMS_ErrorLog
	SET              ErrorSource = @ErrorSource, ErrorDescription = @ErrorDescription, StackTrace = @StackTrace, AppName = @AppName,
		AppVersion = @AppVersion, Workstation = @Workstation, LoggedUserID = @LoggedUserID, Occured = @Occured
	WHERE     (ErrorLogID = @ErrorLogID)

SET NOCOUNT OFF

SELECT @ErrorLogID As ErrorLogID
GO

IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.ROUTINES WHERE ROUTINE_NAME = 'QRY_Assessment_GetGuidanceID')
	EXEC ('CREATE PROCEDURE [dbo].[QRY_Assessment_GetGuidanceID] AS SELECT ''stub version, to be replaced''')
GO
-- =============================================
-- Author:		Markp
-- Create date: 24/07/2008
-- Description:	Gets the GuidanceID for selected assessment
-- Version:		3
-- =============================================
-- JT TFS 13-6422: GuidanceID can be stored against an QMS_AssessmentTarget
-- JT TFS 13-18186: Link QMS_AssessmentTarget to QMS_Assessment through AssessmentID
-- =============================================
ALTER PROCEDURE [dbo].[QRY_Assessment_GetGuidanceID] 
	@AssessmentID int,
	@StockCodeID int = NULL
AS
BEGIN

	SET NOCOUNT ON
	DECLARE @GuidanceID int = NULL

	IF @StockCodeID IS NOT NULL
		SELECT @GuidanceID  = QMS_AssessmentTarget.GuidanceID 
		FROM QMS_Assessment
		INNER JOIN QMS_AssessmentTarget ON QMS_Assessment.AssessmentID = QMS_AssessmentTarget.AssessmentID 
		WHERE QMS_Assessment.AssessmentTargetTypeID = 1
		AND QMS_AssessmentTarget.RecordStatus < 201
		AND QMS_Assessment.RecordStatus < 201
		AND QMS_AssessmentTarget.AssessmentID = @AssessmentID 
		AND QMS_AssessmentTarget.SourceObjectID = @StockCodeID 

	IF @GuidanceID IS NULL
		SELECT     @GuidanceID = GuidanceID
		FROM         QMS_Assessment
		WHERE     (AssessmentID = @AssessmentID)

	SET NOCOUNT OFF
	SELECT @GuidanceID as GuidanceID
END
GO



--PRINT 'Updating sync procedures...'

--PRINT 'Data migration tasks...'

PRINT 'Database updated successfully!'
GO
