-- =============================================
-- Author:		Jon Edwards
-- Create date: 03/12/2014
-- Version:		0.1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 53
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO

--PRINT 'Inserting tables...'

PRINT 'Updating tables...'

IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_RPT_Warehouse_ResponseQuestion_RPT_Warehouse_Response]') AND parent_object_id = OBJECT_ID(N'[dbo].[RPT_Warehouse_ResponseQuestion]'))
ALTER TABLE [dbo].[RPT_Warehouse_ResponseQuestion] DROP CONSTRAINT [FK_RPT_Warehouse_ResponseQuestion_RPT_Warehouse_Response]
GO
IF  EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_RPT_Warehouse_ResponseQuestion_GUID]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[RPT_Warehouse_ResponseQuestion] DROP CONSTRAINT [DF_RPT_Warehouse_ResponseQuestion_GUID]
END

GO
/****** Object:  Table [dbo].[RPT_Warehouse_ResponseQuestion]    Script Date: 03/12/2014 10:57:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RPT_Warehouse_ResponseQuestion]') AND type in (N'U'))
DROP TABLE [dbo].[RPT_Warehouse_ResponseQuestion]
GO
/****** Object:  Table [dbo].[QMS_SupplierPermissions]    Script Date: 03/12/2014 10:57:54 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QMS_SupplierPermissions]') AND type in (N'U'))
DROP TABLE [dbo].[QMS_SupplierPermissions]
GO
/****** Object:  Table [dbo].[QMS_SupplierPermissions]    Script Date: 03/12/2014 10:57:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QMS_SupplierPermissions]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[QMS_SupplierPermissions](
	[SupplierPermissionID] [int] IDENTITY(1,1) NOT FOR REPLICATION NOT NULL,
	[SupplierID] [int] NULL,
	[PermissionType] [int] NULL,
	[PermissionSourceID] [int] NULL,
	[PermissionTitle] [nvarchar](255) NULL,
	[PermissionAllow] [bit] NOT NULL CONSTRAINT [DF_QMS_SupplierPermissions_PermissionAllow]  DEFAULT ((0)),
	[Updated] [datetime] NULL CONSTRAINT [DF_QMS_SupplierPermissions_Updated]  DEFAULT (getutcdate()),
	[Created] [bigint] NULL CONSTRAINT [DF_QMS_SupplierPermissions_Created]  DEFAULT (@@dbts+(1)),
	[RowVersion] [timestamp] NOT NULL,
	[GUID] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_QMS_SupplierPermissions_GUID]  DEFAULT (newid()),
	[UserGroupID] [int] NULL,
 CONSTRAINT [PK_QMS_SupplierPermissions] PRIMARY KEY CLUSTERED 
(
	[SupplierPermissionID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
/****** Object:  Table [dbo].[RPT_Warehouse_ResponseQuestion]    Script Date: 03/12/2014 10:57:54 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RPT_Warehouse_ResponseQuestion]') AND type in (N'U'))
BEGIN
CREATE TABLE [dbo].[RPT_Warehouse_ResponseQuestion](
	[ResponseQuestionID] [int] NOT NULL,
	[ResponseID] [int] NOT NULL,
	[QuestionID] [int] NOT NULL,
	[QuestionLevelID] [int] NULL,
	[Response_Numeric] [float] NULL,
	[QAFlagID] [int] NULL,
	[Score] [float] NULL,
	[Green_Constraint_Numeric_Min] [float] NULL,
	[Green_Constraint_Numeric_Max] [float] NULL,
	[UserID] [int] NULL,
	[RecordStatus] [tinyint] NULL,
	[Updated] [datetime] NULL,
	[GUID] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[AssessmentSection] [nvarchar](255) NULL,
 CONSTRAINT [PK_RPT_Warehouse_ResponseQuestion] PRIMARY KEY CLUSTERED 
(
	[ResponseQuestionID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]
END
GO
IF NOT EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[DF_RPT_Warehouse_ResponseQuestion_GUID]') AND type = 'D')
BEGIN
ALTER TABLE [dbo].[RPT_Warehouse_ResponseQuestion] ADD  CONSTRAINT [DF_RPT_Warehouse_ResponseQuestion_GUID]  DEFAULT (newid()) FOR [GUID]
END

GO
IF NOT EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_RPT_Warehouse_ResponseQuestion_RPT_Warehouse_Response]') AND parent_object_id = OBJECT_ID(N'[dbo].[RPT_Warehouse_ResponseQuestion]'))
ALTER TABLE [dbo].[RPT_Warehouse_ResponseQuestion]  WITH CHECK ADD  CONSTRAINT [FK_RPT_Warehouse_ResponseQuestion_RPT_Warehouse_Response] FOREIGN KEY([ResponseID])
REFERENCES [dbo].[RPT_Warehouse_Response] ([ResponseID])
GO
IF  EXISTS (SELECT * FROM sys.foreign_keys WHERE object_id = OBJECT_ID(N'[dbo].[FK_RPT_Warehouse_ResponseQuestion_RPT_Warehouse_Response]') AND parent_object_id = OBJECT_ID(N'[dbo].[RPT_Warehouse_ResponseQuestion]'))
ALTER TABLE [dbo].[RPT_Warehouse_ResponseQuestion] CHECK CONSTRAINT [FK_RPT_Warehouse_ResponseQuestion_RPT_Warehouse_Response]
GO

--PRINT 'Creating indexes...'

--PRINT 'Updating Views...'

--PRINT 'Dropping Views...'

PRINT 'Updating User Defined Functions...'

/****** Object:  UserDefinedFunction [dbo].[FNC_ResponseHeader_StockCodeID_Selected]    Script Date: 03/12/2014 11:04:57 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_ResponseHeader_StockCodeID_Selected]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[FNC_ResponseHeader_StockCodeID_Selected]
GO
/****** Object:  UserDefinedFunction [dbo].[FNC_ReportFilter_Response]    Script Date: 03/12/2014 11:04:57 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_ReportFilter_Response]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
DROP FUNCTION [dbo].[FNC_ReportFilter_Response]
GO
/****** Object:  UserDefinedFunction [dbo].[FNC_ReportFilter_Response]    Script Date: 03/12/2014 11:04:57 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_ReportFilter_Response]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =============================================
-- Author:		Markp
-- Create date: 06/07/2010
-- Description:	Gets filtered responses
-- Version:		18
-- =============================================
-- JE TFS 3208 - added PT filter
-- JE TFS 4006 - added Supplier Site filter
-- JE TFS 4301 - added PO filter
-- JE TFS 4302 - added Lot Number filter
-- JE TFS 4303 - added Pallet Number filter
-- JE TFS 4304 - added Depot Date filter
-- JE TFS 5113 - added Primary Supplier filter
-- JT TFS 5138 - added Store
-- JT TFS 5394 - added Variety
-- JE TFS 5905 - updated to make use of Reporting Warehouse table
-- JT TFS 6743: Only use warehouse if RPT_Warehouse_Response contains rows.
-- JT TFS 6689: FNC_CanUserDataWareHouse takes UserID parameter.
-- JT TFS 6689: FNC_ReportFilter_Response takes UserID parameter.
-- JT TFS 7707: Added generic datalookup. Set APP_ReportFilter.DataLookupID to search response headers for this DatalookupID
-- JE TFS 8459: added dedicated AQC check filters
-- JE TFS 8469: added Check ID filter
-- JE TFS 8315: added provision for multi select items in header (e.g. Country of Origin)
-- JMF TFS6552 - can now match where the datalookup is just a text lookup (ie no sourceID)
-- JE TFS 13-11253: updated filtering by PO to pick up DataLookupID = 5 OR 47 as both are used for PO
-- =============================================
CREATE FUNCTION [dbo].[FNC_ReportFilter_Response] 
(
	@ReportFilterID int,
	@FilterID int,
	@FilterText nvarchar(255),
	@DateFrom datetime,
	@DateTo datetime,
	@UserID int
)
RETURNS
@Response TABLE
(
	ResponseID int
)
AS

BEGIN

--get date reporting warehouse table last built
DECLARE @WarehouseBuildDate DATETIME
SET @WarehouseBuildDate = ( SELECT  Updated
                            FROM    APP_Config
                            WHERE   OptionID = 78
                          )

DECLARE @Filter_DataLookupID INT
SELECT  @Filter_DataLookupID = DataLookupID
FROM    APP_ReportFilter
WHERE   ReportFilterID = @ReportFilterID

IF @ReportFilterID = 1 --Supplier
    BEGIN
        IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
            AND @DateTo <= @WarehouseBuildDate --use warehouse table if built within specified date range
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  ResponseID
                    FROM    RPT_Warehouse_Response
                    WHERE   ( SupplierID = @FilterID )
                            AND ( EndDate BETWEEN @DateFrom AND @DateTo )
                            AND ( RecordStatus < 201 )
        ELSE
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  QMS_ResponseHeader.ResponseID
                    FROM    QMS_ResponseHeader
                            INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                            INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
                    WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                            AND ( QMS_AssessmentHeader.DataLookupID = 1 )
                            AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )
                            AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                                       AND    @DateTo )
                            AND ( QMS_Response.ResponseStatus = 1 )
                            AND ( QMS_Response.RecordStatus < 201 )
    END

IF @ReportFilterID = 2 --Stock code
    BEGIN
        IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
            AND @DateTo <= @WarehouseBuildDate --use warehouse table if built within specified date range
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  ResponseID
                    FROM    RPT_Warehouse_Response
                    WHERE   ( StockCodeID = @FilterID )
                            AND ( EndDate BETWEEN @DateFrom AND @DateTo )
                            AND ( RecordStatus < 201 )
        ELSE
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  FNC_ResponseHeader_StockCode.ResponseID
                    FROM    dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCode
                            INNER JOIN QMS_Response ON FNC_ResponseHeader_StockCode.ResponseID = QMS_Response.ResponseID
                    WHERE   ( FNC_ResponseHeader_StockCode.StockCodeID = @FilterID )
                            AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                                       AND    @DateTo )
                            AND ( QMS_Response.ResponseStatus = 1 )
                            AND ( QMS_Response.RecordStatus < 201 )
    END

IF @ReportFilterID = 3 --Stock area
    BEGIN
        IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
            AND @DateTo <= @WarehouseBuildDate --use warehouse table if built within specified date range
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  ResponseID
                    FROM    RPT_Warehouse_Response
                            INNER JOIN PM_VW_StockCode ON RPT_Warehouse_Response.StockCodeID = PM_VW_StockCode.StockCodeID
                    WHERE   ( PM_VW_StockCode.StockCodeArea = @FilterText )
                            AND ( EndDate BETWEEN @DateFrom AND @DateTo )
                            AND ( RPT_Warehouse_Response.RecordStatus < 201 )
        ELSE
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  FNC_ResponseHeader_StockCode.ResponseID
                    FROM    dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCode
                            INNER JOIN QMS_Response ON FNC_ResponseHeader_StockCode.ResponseID = QMS_Response.ResponseID
                            INNER JOIN PM_VW_StockCode ON FNC_ResponseHeader_StockCode.StockCodeID = PM_VW_StockCode.StockCodeID
                    WHERE   ( QMS_Response.EndDate BETWEEN @DateFrom
                                                   AND     @DateTo )
                            AND ( QMS_Response.ResponseStatus = 1 )
                            AND ( QMS_Response.RecordStatus < 201 )
                            AND ( PM_VW_StockCode.StockCodeArea = @FilterText )
    END

IF @ReportFilterID = 4 --Stock group
    BEGIN
        IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
            AND @DateTo <= @WarehouseBuildDate --use warehouse table if built within specified date range
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  ResponseID
                    FROM    RPT_Warehouse_Response
                            INNER JOIN PM_VW_StockCode ON RPT_Warehouse_Response.StockCodeID = PM_VW_StockCode.StockCodeID
                    WHERE   ( PM_VW_StockCode.StockCodeGroup = @FilterText )
                            AND ( EndDate BETWEEN @DateFrom AND @DateTo )
                            AND ( RPT_Warehouse_Response.RecordStatus < 201 )
        ELSE
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  FNC_ResponseHeader_StockCode.ResponseID
                    FROM    dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCode
                            INNER JOIN QMS_Response ON FNC_ResponseHeader_StockCode.ResponseID = QMS_Response.ResponseID
                            INNER JOIN PM_VW_StockCode ON FNC_ResponseHeader_StockCode.StockCodeID = PM_VW_StockCode.StockCodeID
                    WHERE   ( QMS_Response.EndDate BETWEEN @DateFrom
                                                   AND     @DateTo )
                            AND ( QMS_Response.ResponseStatus = 1 )
                            AND ( QMS_Response.RecordStatus < 201 )
                            AND ( PM_VW_StockCode.StockCodeGroup = @FilterText )
    END

IF @ReportFilterID = 5 --Stock sub-group
    BEGIN
        IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
            AND @DateTo <= @WarehouseBuildDate --use warehouse table if built within specified date range
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  ResponseID
                    FROM    RPT_Warehouse_Response
                            INNER JOIN PM_VW_StockCode ON RPT_Warehouse_Response.StockCodeID = PM_VW_StockCode.StockCodeID
                    WHERE   ( PM_VW_StockCode.StockCodeSubGroup = @FilterText )
                            AND ( EndDate BETWEEN @DateFrom AND @DateTo )
                            AND ( RPT_Warehouse_Response.RecordStatus < 201 )
        ELSE
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  FNC_ResponseHeader_StockCode.ResponseID
                    FROM    dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCode
                            INNER JOIN QMS_Response ON FNC_ResponseHeader_StockCode.ResponseID = QMS_Response.ResponseID
                            INNER JOIN PM_VW_StockCode ON FNC_ResponseHeader_StockCode.StockCodeID = PM_VW_StockCode.StockCodeID
                    WHERE   ( QMS_Response.EndDate BETWEEN @DateFrom
                                                   AND     @DateTo )
                            AND ( QMS_Response.ResponseStatus = 1 )
                            AND ( QMS_Response.RecordStatus < 201 )
                            AND ( PM_VW_StockCode.StockCodeSubGroup = @FilterText )
    END

IF @ReportFilterID = 6 --Location
    BEGIN
        IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
            AND @DateTo <= @WarehouseBuildDate --use warehouse table if built within specified date range
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  ResponseID
                    FROM    RPT_Warehouse_Response
                    WHERE   ( LocationID = @FilterID )
                            AND ( EndDate BETWEEN @DateFrom AND @DateTo )
                            AND ( RecordStatus < 201 )
        ELSE
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  QMS_ResponseHeader.ResponseID
                    FROM    QMS_ResponseHeader
                            INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                            INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
                    WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                            AND ( QMS_AssessmentHeader.DataLookupID = 4 )
                            AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )
                            AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                                       AND    @DateTo )
                            AND ( QMS_Response.ResponseStatus = 1 )
                            AND ( QMS_Response.RecordStatus < 201 )
    END

IF @ReportFilterID = 7 --National Buyer
    BEGIN
        IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
            AND @DateTo <= @WarehouseBuildDate --use warehouse table if built within specified date range
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  ResponseID
                    FROM    RPT_Warehouse_Response
                            INNER JOIN ( SELECT UserID ,
                                                CAST(PermissionTitle AS INT) AS StockCodeID
                                         FROM   QMS_UserPermissions AS UserPermissions
                                         WHERE  ( PermissionType = 104 )
                                                AND ( PermissionAllow = 1 )
                                       ) AS User_StockCode ON RPT_Warehouse_Response.StockCodeID = User_StockCode.StockCodeID
                    WHERE   ( User_StockCode.UserID = @FilterID )
                            AND ( EndDate BETWEEN @DateFrom AND @DateTo )
                            AND ( RecordStatus < 201 )
        ELSE
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  FNC_ResponseHeader_StockCode.ResponseID
                    FROM    dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCode
                            INNER JOIN QMS_Response ON FNC_ResponseHeader_StockCode.ResponseID = QMS_Response.ResponseID
                            INNER JOIN ( SELECT UserID ,
                                                CAST(PermissionTitle AS INT) AS StockCodeID
                                         FROM   QMS_UserPermissions AS UserPermissions
                                         WHERE  ( PermissionType = 104 )
                                                AND ( PermissionAllow = 1 )
                                       ) AS User_StockCode ON FNC_ResponseHeader_StockCode.StockCodeID = User_StockCode.StockCodeID
                    WHERE   ( QMS_Response.EndDate BETWEEN @DateFrom
                                                   AND     @DateTo )
                            AND ( QMS_Response.ResponseStatus = 1 )
                            AND ( QMS_Response.RecordStatus < 201 )
                            AND ( User_StockCode.UserID = @FilterID )
    END

IF @ReportFilterID = 8 --State Buyer
    BEGIN
        IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
            AND @DateTo <= @WarehouseBuildDate --use warehouse table if built within specified date range
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  RPT_Warehouse_Response.ResponseID
                    FROM    RPT_Warehouse_Response
                            INNER JOIN ( SELECT UserID ,
                                                CAST(PermissionTitle AS INT) AS StockCodeID
                                         FROM   QMS_UserPermissions AS UserPermissions
                                         WHERE  ( PermissionType = 104 )
                                                AND ( PermissionAllow = 1 )
                                       ) AS User_StockCode ON RPT_Warehouse_Response.StockCodeID = User_StockCode.StockCodeID
                            INNER JOIN ( SELECT QMS_ResponseHeader.ResponseID ,
                                                QMS_ResponseHeader.Header_SourceID AS LocationID
                                         FROM   QMS_ResponseHeader
                                                INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                                                INNER JOIN QMS_Response AS QMS_Response_1 ON QMS_ResponseHeader.ResponseID = QMS_Response_1.ResponseID
                                         WHERE  ( QMS_AssessmentHeader.DataTypeID = 9 )
                                                AND ( QMS_AssessmentHeader.DataLookupID = 4 )
                                                AND ( QMS_Response_1.EndDate BETWEEN @DateFrom
                                                              AND
                                                              @DateTo )
                                       ) AS Response_Location ON RPT_Warehouse_Response.ResponseID = Response_Location.ResponseID
                            INNER JOIN ( SELECT UserID ,
                                                CAST(PermissionTitle AS INT) AS LocationID
                                         FROM   QMS_UserPermissions
                                         WHERE  ( PermissionAllow = 1 )
                                                AND ( PermissionType = 103 )
                                       ) AS User_Location ON Response_Location.LocationID = User_Location.LocationID
                    WHERE   ( User_StockCode.UserID = @FilterID )
                            AND ( User_Location.UserID = @FilterID )
                            AND ( EndDate BETWEEN @DateFrom AND @DateTo )
                            AND ( RecordStatus < 201 )
        ELSE
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  QMS_Response.ResponseID
                    FROM    dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCode
                            INNER JOIN QMS_Response ON FNC_ResponseHeader_StockCode.ResponseID = QMS_Response.ResponseID
                            INNER JOIN ( SELECT UserID ,
                                                CAST(PermissionTitle AS INT) AS StockCodeID
                                         FROM   QMS_UserPermissions AS UserPermissions
                                         WHERE  ( PermissionType = 104 )
                                                AND ( PermissionAllow = 1 )
                                       ) AS User_StockCode ON FNC_ResponseHeader_StockCode.StockCodeID = User_StockCode.StockCodeID
                            INNER JOIN ( SELECT QMS_ResponseHeader.ResponseID ,
                                                QMS_ResponseHeader.Header_SourceID AS LocationID
                                         FROM   QMS_ResponseHeader
                                                INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                                                INNER JOIN QMS_Response AS QMS_Response_1 ON QMS_ResponseHeader.ResponseID = QMS_Response_1.ResponseID
                                         WHERE  ( QMS_AssessmentHeader.DataTypeID = 9 )
                                                AND ( QMS_AssessmentHeader.DataLookupID = 4 )
                                                AND ( QMS_Response_1.EndDate BETWEEN @DateFrom
                                                              AND
                                                              @DateTo )
                                       ) AS Response_Location ON QMS_Response.ResponseID = Response_Location.ResponseID
                            INNER JOIN ( SELECT UserID ,
                                                CAST(PermissionTitle AS INT) AS LocationID
                                         FROM   QMS_UserPermissions
                                         WHERE  ( PermissionAllow = 1 )
                                                AND ( PermissionType = 103 )
                                       ) AS User_Location ON Response_Location.LocationID = User_Location.LocationID
                    WHERE   ( QMS_Response.EndDate BETWEEN @DateFrom
                                                   AND     @DateTo )
                            AND ( QMS_Response.ResponseStatus = 1 )
                            AND ( QMS_Response.RecordStatus < 201 )
                            AND ( User_StockCode.UserID = @FilterID )
                            AND ( User_Location.UserID = @FilterID )
    END

IF @ReportFilterID = 9 --Harvest crew
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
            WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 29 )
                    AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

IF @ReportFilterID = 10 --Region
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT     DISTINCT
                    QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
                    LEFT OUTER JOIN PM_VW_Location ON QMS_ResponseHeader.Header_SourceID = PM_VW_Location.LocationID
            WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 4 )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )
                    AND ( PM_VW_Location.RegionID = @FilterID )
                    OR ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 34 )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )
                    AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )

IF @ReportFilterID = 11 --User
    BEGIN
        IF dbo.FNC_CanUseDataWarehouse(@UserID) = 1
            AND @DateTo <= @WarehouseBuildDate --use warehouse table if built within specified date range
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  ResponseID
                    FROM    RPT_Warehouse_Response
                    WHERE   ( UserID = @FilterID )
                            AND ( EndDate BETWEEN @DateFrom AND @DateTo )
                            AND ( RecordStatus < 201 )
        ELSE
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  ResponseID
                    FROM    QMS_Response
                    WHERE   ( EndDate BETWEEN @DateFrom AND @DateTo )
                            AND ( ResponseStatus = 1 )
                            AND ( RecordStatus < 201 )
                            AND ( UserID = @FilterID )
    END

--JE added in TFS 1945
IF @ReportFilterID = 12 --Customer
    BEGIN
        DECLARE @CustomerFilterMode TINYINT
        SELECT  @CustomerFilterMode = ISNULL(dbo.FNC_GetOptionValue(60), 0)
        IF @CustomerFilterMode = 0 --by header selection
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  QMS_ResponseHeader.ResponseID
                    FROM    QMS_ResponseHeader
                            INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                            INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
                    WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                            AND ( QMS_AssessmentHeader.DataLookupID = 3 )
                            AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )
                            AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                                       AND    @DateTo )
                            AND ( QMS_Response.ResponseStatus = 1 )
                            AND ( QMS_Response.RecordStatus < 201 )
        ELSE --by stock code
            INSERT  INTO @Response
                    ( ResponseID
                    )
                    SELECT  FNC_ResponseHeader_StockCode.ResponseID
                    FROM    dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCode
                            INNER JOIN QMS_Response ON FNC_ResponseHeader_StockCode.ResponseID = QMS_Response.ResponseID
                            INNER JOIN PM_VW_StockCode ON FNC_ResponseHeader_StockCode.StockCodeID = PM_VW_StockCode.StockCodeID
                    WHERE   ( QMS_Response.EndDate BETWEEN @DateFrom
                                                   AND     @DateTo )
                            AND ( QMS_Response.ResponseStatus = 1 )
                            AND ( QMS_Response.RecordStatus < 201 )
                            AND ( PM_VW_StockCode.CustomerID = @FilterID )
    END

--MP added for TFS 2072
IF @ReportFilterID = 13 --BU
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  FNC_ResponseHeader_StockCode.ResponseID
            FROM    dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCode
                    INNER JOIN QMS_Response ON FNC_ResponseHeader_StockCode.ResponseID = QMS_Response.ResponseID
                    INNER JOIN PM_VW_StockCode ON FNC_ResponseHeader_StockCode.StockCodeID = PM_VW_StockCode.StockCodeID
            WHERE   ( QMS_Response.EndDate BETWEEN @DateFrom
                                           AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )
                    AND ( PM_VW_StockCode.BusinessUnit = @FilterText )

IF @ReportFilterID = 14 --Business group
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  FNC_ResponseHeader_StockCode.ResponseID
            FROM    dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCode
                    INNER JOIN QMS_Response ON FNC_ResponseHeader_StockCode.ResponseID = QMS_Response.ResponseID
                    INNER JOIN PM_VW_StockCode ON FNC_ResponseHeader_StockCode.StockCodeID = PM_VW_StockCode.StockCodeID
            WHERE   ( QMS_Response.EndDate BETWEEN @DateFrom
                                           AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )
                    AND ( PM_VW_StockCode.BusinessGroup = @FilterText )

IF @ReportFilterID = 15 --Segment
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  FNC_ResponseHeader_StockCode.ResponseID
            FROM    dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCode
                    INNER JOIN QMS_Response ON FNC_ResponseHeader_StockCode.ResponseID = QMS_Response.ResponseID
                    INNER JOIN PM_VW_StockCode ON FNC_ResponseHeader_StockCode.StockCodeID = PM_VW_StockCode.StockCodeID
            WHERE   ( QMS_Response.EndDate BETWEEN @DateFrom
                                           AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )
                    AND ( PM_VW_StockCode.StockCodeSegment = @FilterText )

--JE TFS 3208
IF @ReportFilterID = 16 --Product Technologist
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  FNC_ResponseHeader_StockCode.ResponseID
            FROM    dbo.FNC_ResponseHeader_StockCodeID() AS FNC_ResponseHeader_StockCode
                    INNER JOIN QMS_Response ON FNC_ResponseHeader_StockCode.ResponseID = QMS_Response.ResponseID
                    INNER JOIN FNC_User_StockCodeList(@FilterID) AS User_StockCodeList ON FNC_ResponseHeader_StockCode.StockCodeID = User_StockCodeList.StockCodeID
            WHERE   ( QMS_Response.EndDate BETWEEN @DateFrom
                                           AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

--JE TFS 5113
IF @ReportFilterID = 17 --Primary Supplier
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT DISTINCT
                    QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN PM_VW_StockCodePack ON QMS_ResponseHeader.Header_SourceID = PM_VW_StockCodePack.StockCodeID
                    INNER JOIN PM_VW_Supplier ON PM_VW_StockCodePack.SupplierID = PM_VW_Supplier.SupplierID
            WHERE   ( QMS_AssessmentHeader.DataLookupID = 2 )
                    AND ( PM_VW_StockCodePack.PrimarySupplier = 1 )
                    AND ( PM_VW_Supplier.SupplierID = @FilterID )

--JE TFS 4006
IF @ReportFilterID = 18 --Supplier Site
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
            WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 53 )
                    AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

--JE TFS 4301
IF @ReportFilterID = 20 --PO
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
                    INNER JOIN PM_VW_Consignment ON QMS_ResponseHeader.Header_Text = PM_VW_Consignment.E_PO
            WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND (( QMS_AssessmentHeader.DataLookupID = 5 ) OR ( QMS_AssessmentHeader.DataLookupID = 47 )) --PO can reference two different lookups
                    AND ( PM_VW_Consignment.E_PO = @FilterText )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

--JE TFS 4303
IF @ReportFilterID = 21 --Pallet Number
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
                    INNER JOIN PM_VW_StockBatch ON QMS_ResponseHeader.Header_SourceID = PM_VW_StockBatch.StockBatchID
            WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 11 )
                    AND ( PM_VW_StockBatch.StockBatchID = @FilterID )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

--JE TFS 4304
IF @ReportFilterID = 22 --Depot Date
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
            WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 12 )
                    AND ( QMS_ResponseHeader.Header_Text = @FilterText )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

--JE TFS 4302
IF @ReportFilterID = 23 --Lot Number
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
                    INNER JOIN PM_VW_Delivery ON QMS_ResponseHeader.Header_SourceID = PM_VW_Delivery.DeliveryID
            WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 7 )
                    AND ( PM_VW_Delivery.DeliveryID = @FilterID )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

-- JT TFS 4927 : Store
IF @ReportFilterID = 24 -- Store
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
            WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 54 )
                    AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

-- JT TFS 5394 : Variety
IF @ReportFilterID = 25 -- Variety
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
            WHERE   ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 55 )
                    AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

IF @ReportFilterID = 28 --Stock Code (AQC)
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
            WHERE   ( QMS_AssessmentHeader.AssessmentTypeID = 16 )
                    AND ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 2 )
                    AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

IF @ReportFilterID = 29 --Supplier (AQC)
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
            WHERE   ( QMS_AssessmentHeader.AssessmentTypeID = 16 )
                    AND ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 1 )
                    AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

IF @ReportFilterID = 30 --Location (AQC)
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
            WHERE   ( QMS_AssessmentHeader.AssessmentTypeID = 16 )
                    AND ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 4 )
                    AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

IF @ReportFilterID = 31 --Grower (AQC)
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
            WHERE   ( QMS_AssessmentHeader.AssessmentTypeID = 16 )
                    AND ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = 29 )
                    AND ( QMS_ResponseHeader.Header_SourceID = @FilterID )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

IF @ReportFilterID = 32 --Check ID
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_Response.ResponseID
            FROM    QMS_Response
            WHERE   ( QMS_Response.ResponseID = @FilterID )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )

-- If the reportfilter added is just "look it up in the header, and translate reportfilterID to a datalookupID",
-- then populate APP_ReportFilter.DataLookupID and this section will be used automatically.
IF @Filter_DataLookupID IS NOT NULL
    INSERT  INTO @Response
            ( ResponseID
            )
            SELECT  QMS_ResponseHeader.ResponseID
            FROM    QMS_ResponseHeader
                    INNER JOIN QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID
                    INNER JOIN QMS_Response ON QMS_ResponseHeader.ResponseID = QMS_Response.ResponseID
                    LEFT OUTER JOIN QMS_ResponseHeaderMulti ON QMS_ResponseHeader.ResponseHeaderID = QMS_ResponseHeaderMulti.ResponseHeaderID
            WHERE   ( QMS_Response.ResponseStatus = 1 )
                    AND ( QMS_Response.RecordStatus < 201 )
                    AND ( QMS_AssessmentHeader.DataTypeID = 9 )
                    AND ( QMS_AssessmentHeader.DataLookupID = @Filter_DataLookupID )
--JE TFS 8315 - can now handle filtering multi select items in header
                    AND ( ( @FilterID = ( CASE WHEN QMS_ResponseHeader.Header_SourceID = -1
                                               THEN QMS_ResponseHeaderMulti.Multi_SourceID
                                               ELSE QMS_ResponseHeader.Header_SourceID
                                          END ) )
                          OR ( ISNULL(@FilterID, 0) < 1
                               AND @FilterText = ( CASE WHEN QMS_ResponseHeader.Header_Text = ''''
                                                        THEN QMS_ResponseHeaderMulti.Multi_Text
                                                        ELSE QMS_ResponseHeader.Header_Text
                                                   END )
                             )
--(@FilterText = (CASE WHEN QMS_ResponseHeader.Header_Text = '''' THEN QMS_ResponseHeaderMulti.Multi_Text  ELSE QMS_ResponseHeader.Header_Text END))
                        )
                    AND ( QMS_Response.EndDate BETWEEN @DateFrom
                                               AND     @DateTo )
                    AND NOT EXISTS ( SELECT ResponseID
                                     FROM   @Response
                                     WHERE  ResponseID = QMS_ResponseHeader.ResponseID ) -- Don''t add reponseIDs twice.

RETURN
END

' 
END

GO
/****** Object:  UserDefinedFunction [dbo].[FNC_ResponseHeader_StockCodeID_Selected]    Script Date: 03/12/2014 11:04:57 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FNC_ResponseHeader_StockCodeID_Selected]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Markp
-- Create date: 05/08/2009
-- Description:	Gets stock code id for responses
-- Version:		3
-- =============================================
-- JT TFS 7830 - Also link through raw stockcode datalookup
-- JT TFS 13-11718 - Remove double counting bug when linking stockcode to response from temp_selected table.
-- =============================================
CREATE FUNCTION [dbo].[FNC_ResponseHeader_StockCodeID_Selected] 
(
	@UserID int
)
RETURNS 
@ResponseHeader TABLE 
(
	ResponseID int,
	StockCodeID int
)
AS
BEGIN
	--Add header where stock code selected
	INSERT INTO @ResponseHeader (ResponseID, StockCodeID)
	SELECT     QMS_ResponseHeader.ResponseID, QMS_ResponseHeader.Header_SourceID
	FROM         QMS_ResponseHeader INNER JOIN
                      QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
                      TEMP_Selected ON QMS_ResponseHeader.ResponseID = TEMP_Selected.SelectedID
	WHERE     (QMS_ResponseHeader.Header_SourceID IS NOT NULL) AND (QMS_AssessmentHeader.DataTypeID = 9) AND 
                      (QMS_AssessmentHeader.DataLookupID IN (2, 35)) AND (TEMP_Selected.UserID = @UserID)


	--Add consignment item headers
	INSERT INTO @ResponseHeader (ResponseID, StockCodeID)
	SELECT     QMS_ResponseHeader.ResponseID, PM_VW_ConsignmentItems.StockCodeID
	FROM         QMS_ResponseHeader INNER JOIN
                      QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
                      PM_VW_ConsignmentItems ON QMS_ResponseHeader.Header_SourceID = PM_VW_ConsignmentItems.ConsignmentItemID INNER JOIN
                      TEMP_Selected ON QMS_ResponseHeader.ResponseID = TEMP_Selected.SelectedID
	WHERE     (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 6) AND (TEMP_Selected.UserID = @UserID)
	AND NOT EXISTS (SELECT 1 FROM @ResponseHeader 
					WHERE ResponseID = QMS_ResponseHeader.ResponseID 
					AND StockCodeID = PM_VW_ConsignmentItems.StockCodeID)
	
	--Add delivery item headers
	INSERT INTO @ResponseHeader (ResponseID, StockCodeID)
	SELECT     QMS_ResponseHeader.ResponseID, PM_VW_ConsignmentItems.StockCodeID
	FROM         QMS_ResponseHeader INNER JOIN
                      QMS_AssessmentHeader ON QMS_ResponseHeader.AssessmentHeaderID = QMS_AssessmentHeader.AssessmentHeaderID INNER JOIN
                      PM_VW_GoodsIntake ON QMS_ResponseHeader.Header_SourceID = PM_VW_GoodsIntake.GoodsIntakeID INNER JOIN
                      PM_VW_ConsignmentItems ON PM_VW_GoodsIntake.ConsignmentItemID = PM_VW_ConsignmentItems.ConsignmentItemID INNER JOIN
                      TEMP_Selected ON QMS_ResponseHeader.ResponseID = TEMP_Selected.SelectedID
	WHERE     (QMS_AssessmentHeader.DataTypeID = 9) AND (QMS_AssessmentHeader.DataLookupID = 8) AND (TEMP_Selected.UserID = @UserID)
	AND NOT EXISTS (SELECT 1 FROM @ResponseHeader 
					WHERE ResponseID = QMS_ResponseHeader.ResponseID 
					AND StockCodeID = PM_VW_ConsignmentItems.StockCodeID)

	RETURN 
END
' 
END

GO

PRINT 'Updating Stored Procedures...'

/****** Object:  StoredProcedure [dbo].[SAVE_User]    Script Date: 03/12/2014 11:09:13 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_User]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[SAVE_User]
GO
/****** Object:  StoredProcedure [dbo].[RPT_Response_Response]    Script Date: 03/12/2014 11:09:13 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RPT_Response_Response]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RPT_Response_Response]
GO
/****** Object:  StoredProcedure [dbo].[QRY_Response_PreviousList]    Script Date: 03/12/2014 11:09:13 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_Response_PreviousList]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_Response_PreviousList]
GO
/****** Object:  StoredProcedure [dbo].[QRY_Assessment_Select]    Script Date: 03/12/2014 11:09:13 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_Assessment_Select]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_Assessment_Select]
GO
/****** Object:  StoredProcedure [dbo].[QRY_Assessment_Select]    Script Date: 03/12/2014 11:09:13 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_Assessment_Select]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_Assessment_Select] AS' 
END
GO
-- =============================================      
-- Author:  Jonathan Toolan      
-- Create date: 14/02/2013     
-- Description: Gets an assessment  
-- Version:  4
-- =============================================      
-- JT TFS 5986 - Created  
-- JT TFS 8592 - Added AssessmentStatus
-- JT TFS 13-1729 - Added TempSpec
-- JT TFS 13-10128 - Added PrimaryUserGroupID
-- =============================================      
ALTER PROCEDURE [dbo].[QRY_Assessment_Select]    
	@UserID int = NULL,  
	@AssessmentID int = NULL      
AS      
    
SELECT		AssessmentID, AssessmentTypeID, AssessmentName, [Version],
			StockCodeID = (SELECT TOP 1 StockCodeID FROM dbo.FNC_Assessment_StockCodeID() WHERE AssessmentID = QMS_Assessment.AssessmentID),
			AssessmentStatusID,
			AssessmentStatus = (SELECT TOP 1 AssessmentStatus FROM APP_AssessmentStatus WHERE AssessmentStatusID = QMS_Assessment.AssessmentStatusID),
			TempSpec,
			PrimaryUserGroupID = (	SELECT TOP 1 UserGroupID FROM QMS_SupplierPermissions
									WHERE PermissionSourceID = (SELECT TOP 1 StockCodeID 
																FROM dbo.FNC_Assessment_StockCodeID() 
																WHERE AssessmentID = QMS_Assessment.AssessmentID))
FROM         QMS_Assessment
WHERE     (AssessmentID = @AssessmentID)

GO
/****** Object:  StoredProcedure [dbo].[QRY_Response_PreviousList]    Script Date: 03/12/2014 11:09:13 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_Response_PreviousList]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_Response_PreviousList] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 28/07/2008
-- Description:	Gets list of previous responses
-- Version:		17
-- =============================================
-- Jonathan Toolan: 25-Aug-2011 AssessmentTypeID linked from Response, not Assessment.
-- Jonathan Toolan: 26-Mar-2012 Location Added.
-- Jonathan Toolan: TFS 3211 Multiple AssessmentTypeID_LIST
-- JE TFS 6272 - added Child Check/Top Level Check functionality
-- JT TFS 7346 - Added AssessmentID filter parameter.
-- JT TFS 7989 - Added ExportSetupTable to this SP as an example, so that custom SPs can copy and modify more easily.
-- JT TFS 8130 - ShowOutstanding to switch between "outstanding" mode and "completed" mode.
-- JT TFS 8578 - Added generic filtering if applied.
-- JE TFS 13-466: added provision for AQC Multi assessment format
-- JT TFS 13-612: Added DisplayMode parameter to show multi-check children (default) or parents.
-- JE TFS 13-1621: amended setting of @multiCheckDisplay so parent checks only are shown when isViewQCChecksScreen
-- JE TFS 13-2537: amended so that 3:isQCActionsScreen shows Parent checks only
-- JF TFS 2880 - Ensure that Child checks are available in Office Web - View QC Checks. 
				--Basically if the Multicheck contains a Summary column, then I would expect the Parent check to be referenced/displayed in ALL views
				--If no Summary Column (majority of multicheck customers) � then the Child check should be referenced/displayed in ALL views
-- TFS 2955		Navigate to Tasks > QC Actions for an assessment type of Active Quality Chain,Expected outcome: I am expecting to see the Parent checks here, Actual outcome: I am seeing the Child Checks
-- JE TFS 13-9699: only show non-Approved child checks for AQC assessment type
-- JE TFS 13-11892: output column indicating what sort of multi check response  is (i.e. parent or child) for AQC
-- =============================================
ALTER PROCEDURE [dbo].[QRY_Response_PreviousList] 
    @AssessmentTypeID INT = NULL ,
    @AssessmentTypeID_LIST NVARCHAR(255) = NULL ,
    @DateFrom DATETIME ,
    @DateTo DATETIME ,
    @UserID INT ,
    @AssessmentID INT = NULL ,
    @ShowOutstanding BIT = 0 , -- 0: show completed checks only, 1: show outstanding checks only, NULL: show all checks regardless of ResponseStatus.
    @IsFilterApplied BIT = 0 ,
    @DisplayMode INT = NULL	
		-- 0 or NULL: not specified.
		-- 1:isPreviousChecksScreen
		-- 2:isViewQCChecksScreen
		-- 3:isQCActionsScreen
		-- 4:isQCCheckReport
AS 
    BEGIN
        SET NOCOUNT ON
    
-- If (isPreviousChecksScreen), then show parent checks (1), otherwise show children (2).
-- @multiCheckDisplay should match return value from dbo.FNC_Response_IsMultiCheck.

--FNC_Response_IsMultiCheck resilts
--0 -- Isn't multi-check at all.
--1 -- Is a parent multi-check
--2 -- Is a child multi-check
																				
        

--get Assessment Format
        DECLARE @AssessmentFormat INT
        SELECT  @AssessmentFormat = AssessmentFormat
        FROM    APP_AssessmentType
        WHERE   AssessmentTypeID = @AssessmentTypeID


		DECLARE @multiCheckDisplay INT;
        SELECT  @multiCheckDisplay = CASE WHEN ISNULL(@DisplayMode, 0) IN ( 1 ) 
										THEN  1    --show parent checks only for previouschecks screen
                                        ELSE (CASE WHEN @AssessmentFormat in (6,7) THEN 1 ELSE 2 END)  --show child checks for other modes unless assessment type in (6,7)
									END

        IF ( @AssessmentTypeID_LIST IS NULL ) 
            SET @AssessmentTypeID_LIST = CONVERT(NVARCHAR, @AssessmentTypeID)

--Clear temp table
        DELETE  FROM TEMP_Selected
        WHERE   ( UserID = @UserID )

--Fill temp table
        IF @IsFilterApplied = 0 
            BEGIN
                INSERT INTO TEMP_Selected
                      (SelectedID, UserID)
				SELECT     QMS_Response.ResponseID, @UserID AS UserID
				FROM         QMS_Response INNER JOIN
                      dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList ON 
                      QMS_Response.ResponseID = User_ResponseList.ResponseID INNER JOIN
                      dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',') AS SplitString ON QMS_Response.AssessmentTypeID = SplitString.Token

            END
        ELSE 
            BEGIN
                INSERT INTO TEMP_Selected
                      (SelectedID, UserID)
				SELECT     ResponseID, @UserID AS UserID
				FROM         TEMP_ResponseFilter
				WHERE     (UserID = @UserID)

            END

        SET NOCOUNT OFF

        IF @AssessmentTypeID_LIST = '2' --Arrival check
            BEGIN
                SELECT     QMS_Response.ResponseID, Attachments.NumAttachments, QMS_Assessment.AssessmentName, ResponseHeader.Supplier, ResponseHeader.StockCode, 
                      ResponseHeader.Location, QMS_Response.StartDate, QMS_Response.EndDate, QMS_Response.Actual_Score, QMS_Response.Actual_QAFlagID, QAFlag.QAFlag, 
                      QMS_Response.Override_QAFlagID, QAFlag_Override.QAFlag AS Override_QAFlag, QMS_Response.Offline_ResponseID, 
                      CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete, QMS_User.FullName
				FROM         QMS_Response INNER JOIN
                      TEMP_Selected ON QMS_Response.ResponseID = TEMP_Selected.SelectedID AND TEMP_Selected.UserID = @UserID INNER JOIN
                      --APP_AssessmentType ON APP_AssessmentType.AssessmentTypeID = QMS_Response.AssessmentTypeID INNER JOIN 
                      QMS_Assessment ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID INNER JOIN
                      QMS_User ON QMS_Response.UserID = QMS_User.UserID INNER JOIN
                      dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList ON 
                      QMS_Response.ResponseID = User_ResponseList.ResponseID LEFT OUTER JOIN
                      dbo.FNC_ResponseHeader() AS ResponseHeader ON QMS_Response.ResponseID = ResponseHeader.ResponseID LEFT OUTER JOIN
                          (SELECT     SourceObjectID AS ResponseID, COUNT(AttachmentID) AS NumAttachments
                            FROM          QMS_Attachment
                            WHERE      (AttachmentSourceID = 1) AND (RecordStatus < 201)
                            GROUP BY SourceObjectID) AS Attachments ON QMS_Response.ResponseID = Attachments.ResponseID LEFT OUTER JOIN
                          (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
                            FROM          APP_QAFlag) AS QAFlag_Override ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID LEFT OUTER JOIN
                          (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
                            FROM          APP_QAFlag AS APP_QAFlag_1) AS QAFlag ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
				WHERE     
				
					(QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND 
					(@AssessmentID = QMS_Response.AssessmentID OR @AssessmentID IS NULL) AND 
					(dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND 
					(@ShowOutstanding IS NULL) 
					OR                      
					(QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND 
					(@AssessmentID = QMS_Response.AssessmentID OR @AssessmentID IS NULL) AND 
					(dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND 
					(@ShowOutstanding = 1) AND 
                    (QMS_Response.ResponseStatus = 0) 
                    OR
                    (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND 
                    (@AssessmentID = QMS_Response.AssessmentID OR @AssessmentID IS NULL) AND 
                    (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND 
                    (@ShowOutstanding = 0) AND 
                    (QMS_Response.ResponseStatus <> 0)
                    
				ORDER BY QMS_Response.EndDate DESC
            END
        ELSE 
            IF @AssessmentTypeID_LIST IN ( '3', '4', '5' ) --Online/Label/Dispatch
                BEGIN
                    SELECT     QMS_Response.ResponseID, Attachments.NumAttachments, ResponseHeader.Customer, ResponseHeader.StockCode, ResponseHeader.Location, 
                      ResponseHeader.DepotDate AS [Depot date], QMS_Assessment.AssessmentName, QMS_Response.StartDate, QMS_Response.EndDate, 
                      QMS_Response.Actual_QAFlagID, QAFlag.QAFlag, QMS_Response.Override_QAFlagID, QAFlag_Override.QAFlag AS Override_QAFlag, 
                      QMS_Response.Offline_ResponseID, CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete, 
                      QMS_User.FullName
					FROM         QMS_Response INNER JOIN
                      TEMP_Selected ON QMS_Response.ResponseID = TEMP_Selected.SelectedID AND TEMP_Selected.UserID = @UserID INNER JOIN
                      --APP_AssessmentType ON APP_AssessmentType.AssessmentTypeID = QMS_Response.AssessmentTypeID INNER JOIN 
                      QMS_Assessment ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID INNER JOIN
                      QMS_User ON QMS_Response.UserID = QMS_User.UserID INNER JOIN
                      dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList ON 
                      QMS_Response.ResponseID = User_ResponseList.ResponseID LEFT OUTER JOIN
                      dbo.FNC_ResponseHeader() AS ResponseHeader ON QMS_Response.ResponseID = ResponseHeader.ResponseID LEFT OUTER JOIN
                          (SELECT     SourceObjectID AS ResponseID, COUNT(AttachmentID) AS NumAttachments
                            FROM          QMS_Attachment
                            WHERE      (AttachmentSourceID = 1) AND (RecordStatus < 201)
                            GROUP BY SourceObjectID) AS Attachments ON QMS_Response.ResponseID = Attachments.ResponseID LEFT OUTER JOIN
                          (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
                            FROM          APP_QAFlag) AS QAFlag_Override ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID LEFT OUTER JOIN
                          (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
                            FROM          APP_QAFlag) AS QAFlag ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
					WHERE     (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND (@AssessmentID = QMS_Response.AssessmentID OR
                      @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding IS NULL) OR
                      (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND (@AssessmentID = QMS_Response.AssessmentID OR
                      @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding = 1) AND 
                      (QMS_Response.ResponseStatus = 0) OR
                      (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND (@AssessmentID = QMS_Response.AssessmentID OR
                      @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding = 0) AND 
                      (QMS_Response.ResponseStatus <> 0)
					ORDER BY QMS_Response.EndDate DESC
                END
            ELSE 
                IF @AssessmentTypeID_LIST = '6' --Shelf life
                    BEGIN
                        SELECT     QMS_Response.ResponseID, Attachments.NumAttachments, ResponseHeader.Customer, ResponseHeader.StockCode, ResponseHeader.Location, 
							  ResponseHeader.AssessmentSubType AS [Test type], ResponseHeader.DepotDate AS [Depot date], QMS_Assessment.AssessmentName, QMS_Response.StartDate, 
							  QMS_Response.EndDate, QMS_Response.Actual_QAFlagID, QAFlag.QAFlag, QMS_Response.Override_QAFlagID, QAFlag_Override.QAFlag AS Override_QAFlag, 
							  QMS_Response.Offline_ResponseID, CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete, 
							  QMS_User.FullName
						FROM         QMS_Response INNER JOIN
							  TEMP_Selected ON QMS_Response.ResponseID = TEMP_Selected.SelectedID AND TEMP_Selected.UserID = @UserID INNER JOIN
							  --APP_AssessmentType ON APP_AssessmentType.AssessmentTypeID = QMS_Response.AssessmentTypeID INNER JOIN 
							  QMS_Assessment ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID INNER JOIN
							  QMS_User ON QMS_Response.UserID = QMS_User.UserID INNER JOIN
							  dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList ON 
							  QMS_Response.ResponseID = User_ResponseList.ResponseID LEFT OUTER JOIN
							  dbo.FNC_ResponseHeader() AS ResponseHeader ON QMS_Response.ResponseID = ResponseHeader.ResponseID LEFT OUTER JOIN
								  (SELECT     SourceObjectID AS ResponseID, COUNT(AttachmentID) AS NumAttachments
									FROM          QMS_Attachment
									WHERE      (AttachmentSourceID = 1) AND (RecordStatus < 201)
									GROUP BY SourceObjectID) AS Attachments ON QMS_Response.ResponseID = Attachments.ResponseID LEFT OUTER JOIN
								  (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
									FROM          APP_QAFlag) AS QAFlag_Override ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID LEFT OUTER JOIN
								  (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
									FROM          APP_QAFlag) AS QAFlag ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
						WHERE     (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND (@AssessmentID = QMS_Response.AssessmentID OR
							  @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding IS NULL) OR
							  (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND (@AssessmentID = QMS_Response.AssessmentID OR
							  @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding = 1) AND 
							  (QMS_Response.ResponseStatus = 0) OR
							  (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST)) AND (@AssessmentID = QMS_Response.AssessmentID OR
							  @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding = 0) AND 
							  (QMS_Response.ResponseStatus <> 0)
						ORDER BY QMS_Response.EndDate DESC
                    END
            ELSE 
                IF @AssessmentTypeID_LIST = '16' --Active Quality Chain
                    BEGIN
                        SELECT     QMS_Response.ResponseID, Attachments.NumAttachments, ResponseHeader.Customer, ResponseHeader.StockCode, ResponseHeader.Location, 
							  ResponseHeader.AssessmentSubType AS [Test type], ResponseHeader.DepotDate AS [Depot date], QMS_Assessment.AssessmentName, QMS_Response.StartDate, 
							  QMS_Response.EndDate, QMS_Response.Actual_QAFlagID, QAFlag.QAFlag, QMS_Response.Override_QAFlagID, QAFlag_Override.QAFlag AS Override_QAFlag, 
							  QMS_Response.Offline_ResponseID, CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) = 0 THEN 0 ELSE 1 END AS BIT) AS Complete, 
							  QMS_User.FullName, ISNULL(dbo.FNC_Response_IsApproved(QMS_Response.ResponseID), 0) AS IsApproved,
							  ISNULL(dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID), 0) AS MultiCheckLevel
						FROM         QMS_Response INNER JOIN
							  TEMP_Selected ON QMS_Response.ResponseID = TEMP_Selected.SelectedID AND TEMP_Selected.UserID = @UserID INNER JOIN
							  QMS_Assessment ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID INNER JOIN
							  QMS_User ON QMS_Response.UserID = QMS_User.UserID INNER JOIN
							  dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList ON 
							  QMS_Response.ResponseID = User_ResponseList.ResponseID LEFT OUTER JOIN
							  dbo.FNC_ResponseHeader() AS ResponseHeader ON QMS_Response.ResponseID = ResponseHeader.ResponseID LEFT OUTER JOIN
								  (SELECT     SourceObjectID AS ResponseID, COUNT(AttachmentID) AS NumAttachments
									FROM          QMS_Attachment
									WHERE      (AttachmentSourceID = 1) AND (RecordStatus < 201)
									GROUP BY SourceObjectID) AS Attachments ON QMS_Response.ResponseID = Attachments.ResponseID LEFT OUTER JOIN
								  (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
									FROM          APP_QAFlag) AS QAFlag_Override ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID LEFT OUTER JOIN
								  (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
									FROM          APP_QAFlag) AS QAFlag ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID
						WHERE (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST))
								AND (@AssessmentID = QMS_Response.AssessmentID OR @AssessmentID IS NULL)
								AND (@ShowOutstanding IS NULL) OR
							  (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST))
								AND (@AssessmentID = QMS_Response.AssessmentID OR @AssessmentID IS NULL)
								AND (@ShowOutstanding = 1)
								AND (QMS_Response.ResponseStatus = 0) OR
							  (QMS_Response.AssessmentTypeID = CONVERT(INT, @AssessmentTypeID_LIST))
								AND (@AssessmentID = QMS_Response.AssessmentID OR @AssessmentID IS NULL)
								AND (@ShowOutstanding = 0)
								AND (QMS_Response.ResponseStatus <> 0)
						ORDER BY QMS_Response.EndDate DESC
                    END
                ELSE 
                    BEGIN
                        SELECT     QMS_Response.ResponseID, Attachments.NumAttachments, QMS_Assessment.AssessmentName, ResponseHeader.Location, QMS_Response.StartDate, 
							  QMS_Response.EndDate, QMS_Response.Actual_Score, QMS_Response.Actual_QAFlagID, QAFlag.QAFlag, QMS_Response.Override_QAFlagID, 
							  QAFlag_Override.QAFlag AS Override_QAFlag, QMS_Response.Offline_ResponseID, CAST(CASE WHEN ISNULL(QMS_Response.ResponseStatus, 0) 
							  = 0 THEN 0 ELSE 1 END AS BIT) AS Complete, QMS_User.FullName
						FROM         QMS_Response INNER JOIN
							  TEMP_Selected ON QMS_Response.ResponseID = TEMP_Selected.SelectedID AND TEMP_Selected.UserID = @UserID INNER JOIN
							  --APP_AssessmentType ON APP_AssessmentType.AssessmentTypeID = QMS_Response.AssessmentTypeID INNER JOIN 
							  QMS_Assessment ON QMS_Response.AssessmentID = QMS_Assessment.AssessmentID INNER JOIN
							  QMS_User ON QMS_Response.UserID = QMS_User.UserID INNER JOIN
							  dbo.FNC_User_ResponseList(@UserID, @DateFrom, @DateTo) AS User_ResponseList ON 
							  QMS_Response.ResponseID = User_ResponseList.ResponseID LEFT OUTER JOIN
								  (SELECT     SourceObjectID AS ResponseID, COUNT(AttachmentID) AS NumAttachments
									FROM          QMS_Attachment
									WHERE      (AttachmentSourceID = 1) AND (RecordStatus < 201)
									GROUP BY SourceObjectID) AS Attachments ON QMS_Response.ResponseID = Attachments.ResponseID LEFT OUTER JOIN
								  (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
									FROM          APP_QAFlag) AS QAFlag_Override ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID LEFT OUTER JOIN
								  (SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag
									FROM          APP_QAFlag) AS QAFlag ON QMS_Response.Actual_QAFlagID = QAFlag.QAFlagID LEFT OUTER JOIN
							  dbo.FNC_ResponseHeader() AS ResponseHeader ON QMS_Response.ResponseID = ResponseHeader.ResponseID
						WHERE     (QMS_Response.AssessmentTypeID IN
								  (SELECT     CONVERT(INT, Token) AS Expr1
									FROM          dbo.FNC_SplitString(@AssessmentTypeID_LIST, ','))) AND (@AssessmentID = QMS_Response.AssessmentID OR
							  @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding IS NULL) OR
							  (QMS_Response.AssessmentTypeID IN
								  (SELECT     CONVERT(INT, Token) AS Expr1
									FROM          dbo.FNC_SplitString(@AssessmentTypeID_LIST, ','))) AND (@AssessmentID = QMS_Response.AssessmentID OR
							  @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding = 1) AND 
							  (QMS_Response.ResponseStatus = 0) OR
							  (QMS_Response.AssessmentTypeID IN
								  (SELECT     CONVERT(INT, Token) AS Expr1
									FROM          dbo.FNC_SplitString(@AssessmentTypeID_LIST, ','))) AND (@AssessmentID = QMS_Response.AssessmentID OR
							  @AssessmentID IS NULL) AND (dbo.FNC_Response_IsMultiCheck(QMS_Response.ResponseID) IN (0, @multiCheckDisplay)) AND (@ShowOutstanding = 0) AND 
							  (QMS_Response.ResponseStatus <> 0)
						ORDER BY QMS_Response.EndDate DESC
                    END

--get list of columns that need to be hidden in Excel export
--NOTE:		tableindex is important, and zero based. This export table is table 1 because it's the second table returned in the dataset
--		FixedColumns: These are returned in the main body. These should be fixed. Leave this as NULL to use default ones specified by front end.
--		StaticColumns: These are displayed underneath the compact text in the grid, and do not move, but are specific for each customer.
--		CyclicColumns: If this contains the word "REMAINING_COLUMNS", then it will also include any columns not specified in Fixed or Static.
-- NOTE:	leabing static and cyclic columns NULL will use first two columns not in the default fixed columns as "static", and other columns not in either fixed or static as "cyclic"
        SELECT  1 AS TableIndex ,
                CONVERT(BIT, 1) AS ExportSetupTable ,
                'Portrait/Landscape' AS Orientation ,
                'n/a' AS SheetName ,
                'n/a' AS HiddenColumns ,
                'n/a' AS FixedColumns ,
                'n/a' AS StaticColumns ,
                'n/a' AS CyclicColumns
        UNION
        SELECT  0 ,
                0 ,
                'Portrait' ,
                'View Checks' ,
                NULL ,
                NULL ,
                'Location,FullName' ,
                'REMAINING_COLUMNS'
        ORDER BY TableIndex ASC

    END

GO
/****** Object:  StoredProcedure [dbo].[RPT_Response_Response]    Script Date: 03/12/2014 11:09:13 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RPT_Response_Response]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RPT_Response_Response] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 11/09/2008
-- Description:	gets response items for response report
-- Version:		7
-- =============================================
-- J.Toolan 22/3/2012: Added FilterApplied flag to indicate that a report filter
--					   is in place and should be honoured
-- JE TFS 3916 - added QA Flag Back/Fore colour columns
-- JE TFS 8287 - changed join to APP_QAFlag to LEFT so checks with no flag will still be included in report
-- JE TFS 13-6542: added AppID to main query output
-- JT TFS 13-11338: Change ActualQAFlag for reporting purposes if APP_Config option set.
-- =============================================
ALTER PROCEDURE [dbo].[RPT_Response_Response]
	@UserID int,
	@ShowCA bit = 0,
	@ShowGuidance bit = 0,
	@FilterApplied bit = 0, -- If set, query checks TEMP_ResponseFilter
	@AppID int = 0 --only set when alerts service is creating report (AppID = 4)
AS
BEGIN
	SET NOCOUNT ON
	--set Override QAFlag option
	DECLARE @OverrideQAFlag bit
	SET @OverrideQAFlag = CAST(ISNULL(dbo.FNC_GetOptionValue(74),0) AS bit)

		--create temp table of QA Flag values to join on in main query
	IF nullif(object_id('tempdb..#tmpQAFlag'), 0) IS NOT NULL DROP TABLE #tmpQAFlag
	SELECT     QAFlagID, ISNULL(dbo.FNC_ResourceString_User(ResourceName, @UserID), QAFlag) AS QAFlag,
			QAFlagBackColour, QAFlagForeColour
	INTO #tmpQAFlag
	FROM         APP_QAFlag

	SET NOCOUNT OFF

	SELECT     QMS_Response.ResponseID, QMS_Assessment.AssessmentName, QMS_Assessment.Version, QMS_Response.AssessmentTypeID, APP_AssessmentType.AssessmentType, 
						  QMS_Response.StartDate, QMS_Response.EndDate, QMS_Response.Comments, QMS_Response.Recommended_Score, QMS_Response.Recommended_QAFlagID, QMS_Response.Actual_Score, 
						  QAFlag.QAFlagID AS Actual_QAFlagID, 
						  QAFlag.QAFlag AS Actual_QAFlag, 
						  QMS_User.FullName, QMS_User.EMail AS AssessorEmail, QMS_Response.Override_QAFlagID, 
						  QAFlag_Override.QAFlag AS Override_QAFlag, @ShowCA AS ShowCA, CorrectiveAction.CATitle, CorrectiveAction.CAReason, CorrectiveAction.CARequired, CorrectiveAction.CAStatus, 
						  CorrectiveAction.NotificationGroup, CorrectiveAction.PriorityLevel, CorrectiveAction.DateDeadline, @ShowGuidance AS ShowGuidance, QMS_Response.QuantityReceived, 
						  QMS_Response.QuantityChecked, QMS_Response.QuantityAccepted, QMS_Response.QuantityRejected, ISNULL(dbo.FNC_GetOptionValue(15), N'0') AS HideQAScore, 
						  QMS_Response.QuantityReplaced, QAFlag.QAFlagBackColour, QAFlag.QAFlagForeColour, @AppID AS AppID
	FROM         QMS_Assessment 
	INNER JOIN	QMS_Response ON QMS_Assessment.AssessmentID = QMS_Response.AssessmentID 
	INNER JOIN	TEMP_Selected ON QMS_Response.ResponseID = TEMP_Selected.SelectedID 
	INNER JOIN	APP_AssessmentType ON QMS_Response.AssessmentTypeID = APP_AssessmentType.AssessmentTypeID 
	LEFT OUTER JOIN	#tmpQAFlag AS QAFlag ON CASE WHEN @OverrideQAFlag = 0 THEN Actual_QAFlagID ELSE ISNULL(QMS_Response.Override_QAFlagID, QMS_Response.Actual_QAFlagID) END = QAFlag.QAFlagID 
	LEFT OUTER JOIN	#tmpQAFlag AS QAFlag_Override ON QMS_Response.Override_QAFlagID = QAFlag_Override.QAFlagID 
	LEFT OUTER JOIN    (SELECT     QMS_CorrectiveAction.SourceObjectID AS ResponseID, QMS_CorrectiveAction.CATitle, QMS_CorrectiveAction.CAReason, QMS_CorrectiveAction.CARequired, 
													   APP_CorrectiveActionStatus.CAStatus, QMS_NotificationGroup.NotificationGroup, APP_PriorityLevel.PriorityLevel, QMS_CorrectiveAction.DateDeadline
								FROM          QMS_CorrectiveAction INNER JOIN
													   APP_CorrectiveActionStatus ON QMS_CorrectiveAction.CAStatusID = APP_CorrectiveActionStatus.CAStatusID LEFT OUTER JOIN
													   APP_PriorityLevel ON QMS_CorrectiveAction.PriorityLevelID = APP_PriorityLevel.PriorityLevelID LEFT OUTER JOIN
													   QMS_NotificationGroup ON QMS_CorrectiveAction.NotificationGroupID = QMS_NotificationGroup.NotificationGroupID
								WHERE      (QMS_CorrectiveAction.CASourceID = 1) AND (QMS_CorrectiveAction.RecordStatus < 201)) AS CorrectiveAction ON 
						  QMS_Response.ResponseID = CorrectiveAction.ResponseID 
	LEFT OUTER JOIN	QMS_User ON QMS_Response.UserID = QMS_User.UserID 
	WHERE     (TEMP_Selected.UserID = @UserID) AND (@FilterApplied = 0) OR
						  (TEMP_Selected.UserID = @UserID) AND (QMS_Response.ResponseID IN
							  (SELECT     ResponseID
								FROM          TEMP_ResponseFilter
								WHERE      (UserID = @UserID)))
	ORDER BY QMS_Response.StartDate, QMS_Assessment.AssessmentName

END

GO
/****** Object:  StoredProcedure [dbo].[SAVE_User]    Script Date: 03/12/2014 11:09:13 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_User]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[SAVE_User] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 30/06/2008
-- Description:	Adds and edits user details
-- Version:		7
-- =============================================
-- J.Toolan 13 Feb 2012: Stopped code from adding more than one username
-- J.Toolan 8 Mar 2012: Added SHA2 password field to update/insert
-- MarkP 1 Jun 2012: Made sure UserPermissions.Updated is set
-- JToolan 12 Jun 2012: TFS 3905 - Stopped Password resetting on NULL entry.
-- JT TFS 6629 - Use UP_User_Password to write passwords.
-- JT TFS 13-11261 - Add new admin users to the AdminAlerts group (ignore existing users).
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_User] 
	@UserID int,
	@FullName nvarchar(255),
	@UserName nvarchar(255),
	@Password nvarchar(255) = NULL,
	@Position nvarchar(255),
	@Company nvarchar(255),
	@EMail nvarchar(100),
	@Mobile nvarchar(50),
	@PIN nvarchar(10),
	@LeftCompany bit,
	@UserLevel int,
	@LocaleID int,
	@IsUserGroup bit,
	@ParentUserID int,
	@SupplierID int = NULL,
	@Password_MD5 nvarchar(255) = NULL,
	@Password_SHA2 nvarchar(255) = NULL
AS

SET NOCOUNT ON

IF ISNULL(@UserID,0)=0 --New user
BEGIN
	IF NOT EXISTS (SELECT * FROM QMS_User WHERE RecordStatus < 201 AND UserName = @UserName COLLATE Latin1_General_ci_ai)
	BEGIN
		INSERT INTO QMS_User(FullName,	UserName,	Position,	EMail,	Mobile,		PIN,	LeftCompany,	UserLevel,	LocaleID,	IsUserGroup,	ParentUserID,	Company)
		VALUES				(@FullName,	@UserName,	@Position,	@EMail,	@Mobile,	@PIN,	@LeftCompany,	@UserLevel,	@LocaleID,	@IsUserGroup,	@ParentUserID,	@Company)
		--Get new UserID
		SELECT @UserID = SCOPE_IDENTITY()
		
		EXEC UP_User_Password @UserName, @Password, @Password_MD5, @Password_SHA2

		-- INSERT INTO ADMIN NOTIFICATION GROUP 11261

		DECLARE @NotificationGroupID int
		SELECT @NotificationGroupID = NotificationGroupID
		FROM QMS_NotificationGroup WHERE Sys_Group = 'AdminAlerts'

		INSERT QMS_NotificationGroupUser (NotificationGroupID, UserID, RecordStatus)
		SELECT @NotificationGroupID, UserID, 2
		FROM QMS_User 
		WHERE dbo.FNC_GetUserLevel(UserID) = 1 
		AND RecordStatus < 201
		AND UserID = @UserID
		AND NOT EXISTS (SELECT * FROM QMS_NotificationGroupUser 
						WHERE NotificationGroupID = @NotificationGroupID 
						AND UserID = QMS_User.UserID
						AND RecordStatus < 201)

		-- END INSERT INTO ADMIN NOTIFICATION GROUP 11261

	END
END
ELSE --Update user
BEGIN
-- Don't change the username to an existing other username. It violates the single username principle of logging in.
	IF EXISTS (SELECT * FROM QMS_User WHERE RecordStatus < 201 AND UserName = @UserName COLLATE Latin1_General_ci_ai AND UserID <> @UserID)
	BEGIN
		SET @UserID = 0 -- This should cause the save procedure to fail.
	END
	ELSE
	BEGIN -- Username is still unique on all undeleted records.
		--JE - update passwords table (TFS 973)
		IF @Password IS NOT NULL
		BEGIN
			EXEC UP_User_Password @UserName, @Password, @Password_MD5, @Password_SHA2
		END

		UPDATE    QMS_User
		SET			FullName = @FullName, UserName = @UserName, Position = @Position, EMail = @EMail, Mobile = @Mobile, PIN = @PIN, 
					LeftCompany = @LeftCompany, UserLevel = @UserLevel, LocaleID = @LocaleID, IsUserGroup = @IsUserGroup, ParentUserID = @ParentUserID, 
					Company = @Company, Updated = GETUTCDATE()
		WHERE     (UserID = @UserID)
	END
END
	
IF ISNULL(@SupplierID,0) > 0 AND ISNULL(@UserID,0) > 0
BEGIN --Setup linked supplier
	DECLARE @PermissionID int
	SELECT     @PermissionID = MAX(UserPermissionID)
	FROM         QMS_UserPermissions
	WHERE     (PermissionType = 101) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) = @SupplierID)
	IF ISNULL(@PermissionID,0)=0 --Add permission
	BEGIN
		INSERT INTO QMS_UserPermissions (UserID, PermissionType, PermissionTitle, PermissionAllow)
		VALUES     (@UserID, 101,@SupplierID, 1)
	END
	ELSE
	BEGIN
		UPDATE	QMS_UserPermissions
		SET		PermissionAllow = 1, Updated = GETUTCDATE()
		WHERE	(UserPermissionID = @PermissionID) AND (PermissionAllow = 0)
	END
	
	--Remove any existing permissions
	UPDATE  QMS_UserPermissions
	SET		PermissionAllow = 0, Updated = GETUTCDATE()
	WHERE   (PermissionType = 101) AND (UserID = @UserID) AND (CAST(PermissionTitle AS int) <> @SupplierID) AND (PermissionAllow = 1)
END

SET NOCOUNT OFF

SELECT @UserID

GO

PRINT 'Updating sync procedures...'

/****** Object:  StoredProcedure [dbo].[SYNC_Import_PM_StockBatchSource]    Script Date: 03/12/2014 11:10:59 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SYNC_Import_PM_StockBatchSource]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[SYNC_Import_PM_StockBatchSource]
GO
/****** Object:  StoredProcedure [dbo].[SYNC_Import_PM_StockBatchSource]    Script Date: 03/12/2014 11:10:59 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SYNC_Import_PM_StockBatchSource]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[SYNC_Import_PM_StockBatchSource] AS' 
END
GO

ALTER PROCEDURE [dbo].[SYNC_Import_PM_StockBatchSource] 
	@StockSourceID int,
	@StockBatchID int,
	@GoodsIntakeID int,
	@SourceBatchID int,
	@RecordStatus tinyint,
	@GUID uniqueidentifier,
	@Created bigint,
	@RowVersion timestamp,
	@InsertCount int = 0 OUTPUT,
	@UpdateCount int = 0 OUTPUT,
	@ReceivedAnchor bigint = 0 OUTPUT
AS

IF NOT EXISTS(SELECT * FROM PM_StockBatchSource WHERE (StockSourceID = @StockSourceID))
BEGIN --Append record
	IF @RecordStatus < 201
	BEGIN
		INSERT INTO PM_StockBatchSource
                      (StockSourceID, StockBatchID, GoodsIntakeID, SourceBatchID, RecordStatus, GUID)
		VALUES     (@StockSourceID,@StockBatchID,@GoodsIntakeID,@SourceBatchID,@RecordStatus,@GUID)
		SET @InsertCount = @@rowcount
	END
END

ELSE
BEGIN --Update record
	UPDATE    PM_StockBatchSource
	SET              RecordStatus = @RecordStatus, StockBatchID = @StockBatchID, GoodsIntakeID = @GoodsIntakeID, SourceBatchID = @SourceBatchID
	WHERE     (StockSourceID = @StockSourceID)
	SET @UpdateCount = @@rowcount
END

IF CAST(@RowVersion AS bigint) > @Created
	SET @ReceivedAnchor = CAST(@RowVersion AS bigint)
ELSE
	SET @ReceivedAnchor = @Created


GO

--PRINT 'Data migration tasks...'

PRINT 'Database updated successfully!'
GO
