-- =============================================
-- Author:		Jon Edwards
-- Create date: 14/10/2014
-- Version:		0.1
-- Description:	Updates GreenlightQC_Mobile database for Sprint 51
-- =============================================

SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO

PRINT 'Looking up ProduceManager db...'
GO

IF nullif(object_id('tempdb..#tmpPMDBName'), 0) IS NOT NULL DROP TABLE #tmpPMDBName

CREATE TABLE #tmpPMDBName (PMDBName NVARCHAR(255))

DECLARE @DBName nvarchar(50), @PMDBName NVARCHAR(50)
SET @DBName = DB_NAME() 

IF LEN(@DBName)>12 
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,13,LEN(@DBName)-11)
ELSE
	SELECT @PMDBName = name FROM sys.databases WHERE name = 'ProduceManager' + SUBSTRING(@DBName,5,LEN(@DBName)-3)

IF @PMDBName IS NOT NULL
BEGIN
	INSERT INTO #tmpPMDBName ( PMDBName ) VALUES  ( @PMDBName )
	--PRINT '***Need to replace ProduceManager references in views to db: ' + @PMDBName
	--INSERT INTO dbo.QMS_DeploymentErrorLog (ScriptName, UserName,DeploymentDate, ObjectName)
	--SELECT ScriptName, USER_NAME(), GETUTCDATE(), 'Need to replace ProduceManager references in views to db: ' + @PMDBName
	--FROM #tmpScriptName
END
GO

--PRINT 'Inserting tables...'

--PRINT 'Updating tables...'

--PRINT 'Creating indexes...'

--PRINT 'Updating Views...'

--PRINT 'Dropping Views...'

--PRINT 'Updating User Defined Functions...'

PRINT 'Updating Stored Procedures...'

/****** Object:  StoredProcedure [dbo].[SAVE_CorrectiveAction]    Script Date: 14/10/2014 12:59:12 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_CorrectiveAction]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[SAVE_CorrectiveAction]
GO
/****** Object:  StoredProcedure [dbo].[SAVE_AssessmentQuestion]    Script Date: 14/10/2014 12:59:12 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_AssessmentQuestion]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[SAVE_AssessmentQuestion]
GO
/****** Object:  StoredProcedure [dbo].[PM_QRY_StockCode_Hierarchy]    Script Date: 14/10/2014 12:59:12 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PM_QRY_StockCode_Hierarchy]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[PM_QRY_StockCode_Hierarchy]
GO
/****** Object:  StoredProcedure [dbo].[PM_QRY_StockCode_Hierarchy]    Script Date: 14/10/2014 12:59:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PM_QRY_StockCode_Hierarchy]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[PM_QRY_StockCode_Hierarchy] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 19/10/2009
-- Description:	Gets a stock code list grouped by group
-- Version:		4
-- =============================================
-- JE TFS 3196: added filtering by user's BusinessGroups and StockCodeSubGroups
-- MP TFS 7529: refactored to make procedure pickup permissions at stock code level
-- JT TFS 13-1791: Added searching and filtering, and only return X rows.
-- JE TFS 13-9631: filter out varieties
-- =============================================
ALTER PROCEDURE [dbo].[PM_QRY_StockCode_Hierarchy]
	@UserID int = NULL,
	@SearchText nvarchar(100) = NULL,
	@BusinessGroup nvarchar(100) = NULL,
	@StockCodeArea nvarchar(100) = NULL,
	@StockCodeGroup nvarchar(100) = NULL,
	@StockCodeSubGroup nvarchar(100) = NULL,
	@StockCodeSegment nvarchar(100) = NULL,
	@MaxRecords int = 100000
AS
	--Get grouping level
	DECLARE @StockCodeGroupLevel tinyint
	SET @StockCodeGroupLevel = ISNULL(dbo.FNC_GetOptionValue(64),0)
	
    SELECT  TOP (@MaxRecords) 
			PM_VW_StockCode.StockCodeID ,
            ISNULL(CASE WHEN @StockCodeGroupLevel = 1 THEN StockCodeSubGroup
                        WHEN @StockCodeGroupLevel = 2 THEN BusinessGroup
                        ELSE StockCodeGroup
                   END, N'(N/A)') AS StockCodeGroup ,
            DisplayText
    FROM    PM_VW_StockCode
            INNER JOIN dbo.FNC_User_StockCodeList(@UserID) AS User_StockCode ON dbo.PM_VW_StockCode.StockCodeID = User_StockCode.StockCodeID
    WHERE   ( Hide = 0 )
    AND (@SearchText IS NULL OR PM_VW_StockCode.DisplayText LIKE @SearchText)
	AND (@BusinessGroup IS NULL OR PM_VW_StockCode.BusinessGroup = @BusinessGroup)
	AND (@StockCodeArea IS NULL OR PM_VW_StockCode.StockCodeArea = @StockCodeArea)
	AND (@StockCodeGroup IS NULL OR PM_VW_StockCode.StockCodeGroup = @StockCodeGroup)
	AND (@StockCodeSubGroup IS NULL OR PM_VW_StockCode.StockCodeSubGroup = @StockCodeSubGroup)
	AND (@StockCodeSegment IS NULL OR PM_VW_StockCode.StockCodeSegment = @StockCodeSegment)
	AND (PM_VW_StockCode.StockTypeID <> 4)
    ORDER BY StockCodeGroup ,
            DisplayText

GO
/****** Object:  StoredProcedure [dbo].[SAVE_AssessmentQuestion]    Script Date: 14/10/2014 12:59:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_AssessmentQuestion]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[SAVE_AssessmentQuestion] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 09/07/2008
-- Description:	Save the assessment questions
-- Version:		11
-- =============================================
-- Jeremyf TFS 5057
-- JE TFS 5456 - added ListSamplesOnReport col
-- JT TFS 6621 - Added renumbering code.
-- JT TFS 6621 - Added code to change 0 to NULL for some old columns.
-- JT TFS 6621 - Only update assessment questions which have changed their number
-- JT TFS 6621 - Added check for recursion in case it slips by validation.
-- JT TFS 6957 - Removed identity column from temp table #tmpRenumbering
-- JT TFS 7153 - Sample_DataTypeID must be non-zero (NULL or valid number)
-- JT TFS 7979 - Keep OverallSortIndex and OverallQuestionNo up to date when updating.
-- JE TFS 7951 - added Multi_SampleSummaryID param (optional)
-- JT TFS 7920 - Do not allow 0 DataTypeID when saving.
-- JT TFS 7785 - Added GuidanceRequired column
-- JT TFS 8404 - All ID columns must not contain zero.
-- JE TFS 13-9479: force QuestionLevelID to default to 1 (None)
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_AssessmentQuestion] 
	@AssessmentQuestionID int,
	@AssessmentID int,
	@QuestionID int,
	@ParentQuestionID int,
	@QuestionNo tinyint,
	@DataTypeID int,
	@DataLookupID int,
	@CustomLookupID int,
	@QuestionLevelID int,
	@GuidanceID int,
	@HasSamples bit,
	@SampleSummaryID int,
	@Sample_DataTypeID int,
	@MinSampleCount int,
	@ResponseRequired bit,
	@ShortGuidance nvarchar(255),
	@ScoreCalculationID int,
	@ResponseFormula nvarchar(1000),
	@ScoreFormula nvarchar(1000),
	@InstrumentID int,
	@Hide bit,
	@UserID int,
	--JE added as part of TFS 1263
	@Acceptable_Numeric_Min int,
	@Acceptable_Numeric_Max int,
	--JE added in TFS 1414
	@LookupAssessmentQuestionID int,
	@LookupSampleSet tinyint,
	--MP added in task 1976
	@BackfillResponse bit = NULL,
	--MP added in task 3217
	@UpdateOverallQAFlag bit = NULL,
	@ChartQuestion bit = NULL,
	@HideFromReports bit = NULL,
	@ListSamplesOnReport bit = NULL,
	@Multi_SampleSummaryID int = NULL,
	@GuidanceRequired bit = 0
AS

SET NOCOUNT ON

-- Use NULL instead of zero for nullable columns ending in ID
SELECT @ParentQuestionID = NULLIF(@ParentQuestionID, 0),
		@CustomLookupID = NULLIF(@CustomLookupID, 0),
		@GuidanceID = NULLIF(@GuidanceID, 0),
		@SampleSummaryID = NULLIF(@SampleSummaryID, 0),
		@ScoreCalculationID = NULLIF(@ScoreCalculationID, 0),
        @Sample_DataTypeID = NULLIF(@Sample_DataTypeID, 0),
        @Multi_SampleSummaryID = NULLIF(@Multi_SampleSummaryID, 0),
        @DataTypeID = NULLIF(@DataTypeID, 0), -- bug 7920
		@DataLookupID = NULLIF(@DataLookupID, 0),
		@CustomLookupID = NULLIF(@CustomLookupID, 0),
		@QuestionLevelID = NULLIF(@QuestionLevelID, 0),
		@InstrumentID = NULLIF(@InstrumentID, 0),
		@LookupAssessmentQuestionID = NULLIF(@LookupAssessmentQuestionID, 0)
		
-- Convert some other parameters the other way NULL => 0
IF @BackfillResponse IS NULL 
	SET @BackfillResponse = 0

IF @UpdateOverallQAFlag IS NULL
	SET @UpdateOverallQAFlag = 0
	
IF @ChartQuestion IS NULL
	SET @ChartQuestion = 0
	
IF @HideFromReports IS NULL
	SET @HideFromReports = 0
	
IF @ListSamplesOnReport IS NULL
	 SET @ListSamplesOnReport = 0

--set Question Level to None (1) by default
IF @QuestionLevelID IS NULL
	SET @QuestionLevelID = 1

IF dbo.FNC_AssessmentQuestion_IsSafeFromRecursion(@AssessmentQuestionID, @ParentQuestionID) = 0
BEGIN
	RAISERROR('Recursive questions are not allowed', 11, 1)
	RETURN 0
END

-- Multiply all the temporary question numbers by two so that there is exactly one space in between each one. 
DECLARE @tmpRenumbering TABLE (
	AssessmentQuestionID int PRIMARY KEY,
	ParentQuestionID int,
	QuestionNo int
)

INSERT @tmpRenumbering (AssessmentQuestionID, ParentQuestionID, QuestionNo)
SELECT AssessmentQuestionID, 
		ParentQuestionID,
		QuestionNo = isnull(QuestionNo, 0) * 2
FROM QMS_AssessmentQuestion
WHERE AssessmentID = @AssessmentID 
AND RecordStatus < 201

-- The new (or updated) row will slot in between these rows, so assigning QuestionNo of 1 will result in the new row being first in the list, 3 the third, etc.
DECLARE @newQuestionNo int; SET @newQuestionNo = (@QuestionNo * 2) - 1

IF ISNULL(@AssessmentQuestionID,0)=0 --New record
BEGIN
	INSERT INTO QMS_AssessmentQuestion
                      (AssessmentID, QuestionID, ParentQuestionID, QuestionNo, DataTypeID, DataLookupID, CustomLookupID, QuestionLevelID, GuidanceID, HasSamples, 
                      SampleSummaryID, Sample_DataTypeID, MinSampleCount, ResponseRequired, ShortGuidance, ScoreCalculationID, ResponseFormula, ScoreFormula, InstrumentID, 
                      Acceptable_Numeric_Min, Acceptable_Numeric_Max, LookupAssessmentQuestionID, LookupSampleSet, BackfillResponse, UpdateOverallQAFlag, ChartQuestion, 
                      Hide, UserID, HideFromReports, ListSamplesOnReport, Multi_SampleSummaryID, GuidanceRequired)
	VALUES     (@AssessmentID,@QuestionID,@ParentQuestionID,@QuestionNo,@DataTypeID,@DataLookupID,@CustomLookupID,@QuestionLevelID,@GuidanceID,@HasSamples,@SampleSummaryID,
					@Sample_DataTypeID,@MinSampleCount,@ResponseRequired,@ShortGuidance,@ScoreCalculationID,@ResponseFormula,@ScoreFormula,@InstrumentID,
					@Acceptable_Numeric_Min,@Acceptable_Numeric_Max,@LookupAssessmentQuestionID,@LookupSampleSet,@BackfillResponse,@UpdateOverallQAFlag,@ChartQuestion,
					@Hide,@UserID,@HideFromReports,@ListSamplesOnReport,@Multi_SampleSummaryID, @GuidanceRequired )
	--Get new ID
	SELECT     @AssessmentQuestionID = MAX(AssessmentQuestionID)
	FROM         QMS_AssessmentQuestion
	
	INSERT @tmpRenumbering (AssessmentQuestionID, ParentQuestionID, QuestionNo)
	VALUES (@AssessmentQuestionID, @ParentQuestionID, @newQuestionNo)
	
END
ELSE --Update record
BEGIN
	UPDATE    QMS_AssessmentQuestion
	SET              QuestionID = @QuestionID, ParentQuestionID = @ParentQuestionID, QuestionNo = @QuestionNo, DataTypeID = @DataTypeID, DataLookupID = @DataLookupID, 
                      CustomLookupID = @CustomLookupID, QuestionLevelID = @QuestionLevelID, GuidanceID = @GuidanceID, HasSamples = @HasSamples, 
                      SampleSummaryID = @SampleSummaryID, Sample_DataTypeID = @Sample_DataTypeID, MinSampleCount = @MinSampleCount, 
                      ResponseRequired = @ResponseRequired, ShortGuidance = @ShortGuidance, ScoreCalculationID = @ScoreCalculationID, ResponseFormula = @ResponseFormula, 
                      ScoreFormula = @ScoreFormula, InstrumentID = @InstrumentID, Acceptable_Numeric_Min = @Acceptable_Numeric_Min, 
                      Acceptable_Numeric_Max = @Acceptable_Numeric_Max, LookupAssessmentQuestionID = @LookupAssessmentQuestionID, LookupSampleSet = @LookupSampleSet, 
                      BackfillResponse = @BackfillResponse, UpdateOverallQAFlag = @UpdateOverallQAFlag, ChartQuestion = @ChartQuestion, Hide = @Hide, UserID = @UserID, 
                      MachineName = HOST_NAME(), Updated = GETUTCDATE(), HideFromReports = @HideFromReports, ListSamplesOnReport = @ListSamplesOnReport,
                      Multi_SampleSummaryID = @Multi_SampleSummaryID,
                      GuidanceRequired = @GuidanceRequired 
	WHERE     (AssessmentQuestionID = @AssessmentQuestionID)
	
	UPDATE @tmpRenumbering
	SET QuestionNo = @newQuestionNo, 
		ParentQuestionID = @ParentQuestionID
	WHERE AssessmentQuestionID = @AssessmentQuestionID 
END

-- Renumbers the assessment questions (removes any empty spaces and only updates changed records)
UPDATE @tmpRenumbering
SET QuestionNo = renumbered.QuestionNo 
FROM 
(
	SELECT	AssessmentQuestionID, 
			QuestionNo = row_number() OVER (PARTITION BY ISNULL(ParentQuestionID, 0) ORDER BY ISNULL(QuestionNo, 0), AssessmentQuestionID)
	FROM @tmpRenumbering 
) AS renumbered
INNER JOIN @tmpRenumbering questions ON renumbered.AssessmentQuestionID = questions.AssessmentQuestionID 
WHERE renumbered.QuestionNo <> ISNULL(questions.QuestionNo, 0)

-- Update the assessment questions which have changed numbers as a result of moving this one.
UPDATE QMS_AssessmentQuestion
SET QuestionNo = convert(tinyint, CASE WHEN renumbered.QuestionNo > 255 THEN 255 ELSE renumbered.QuestionNo END),
	MachineName = HOST_NAME(), 
	Updated = GETUTCDATE()
FROM QMS_AssessmentQuestion
INNER JOIN @tmpRenumbering renumbered ON QMS_AssessmentQuestion.AssessmentQuestionID = renumbered.AssessmentQuestionID
WHERE renumbered.QuestionNo <> ISNULL(QMS_AssessmentQuestion.QuestionNo, 0) 

EXEC UP_AssessmentQuestion_Presort @AssessmentID = @AssessmentID 

SET NOCOUNT OFF

SELECT @AssessmentQuestionID


GO
/****** Object:  StoredProcedure [dbo].[SAVE_CorrectiveAction]    Script Date: 14/10/2014 12:59:12 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_CorrectiveAction]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[SAVE_CorrectiveAction] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 01/08/2008
-- Description:	Saves corrective action
-- Version:		9
-- =============================================
-- j.toolan 21 Feb 2012: Added ReminderDate
-- j.toolan  7 Mar 2012: Reset NotifcationSent on 6 if AssignSupplierID set (only if status changes)
-- MP TFS 5873 - Made sure SourceObjectID updated so that correct links to response created
-- JE TFS 7087 - added CorrectiveActionTypeID to UPDATE statement
-- JE TFS 7877 - corrected resetting of NotifcationSent for Completed alerts
-- JE TFS 7836 - updated to save LocationID CA is assigned
-- JT TFS 13-7950 - Make sure that if CorrectiveActionTypeID is specified, and CorrectiveActionEscalationID is NOT, then set it.
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_CorrectiveAction] 
	@CorrectiveActionID int,
	@CASourceID int,
	@SourceObjectID int,
	@CATitle nvarchar(50),
	@CASubTitle nvarchar(50),
	@CAReason nvarchar(1000),
	@CARequired nvarchar(1000),
	@CAStatusID int,
	@CorrectiveActionTypeID int,
	@CorrectiveActionEscalationID int,
	@NotificationGroupID int,
	@AssignUserID int,
	@DateOccurred datetime,
	@PriorityLevelID int,
	@DateLogged datetime,
	@DateDeadline datetime,
	@ActionTaken nvarchar(1000),
	@Comments nvarchar(1000),
	@DateCompleted datetime,
	@Completed_UserID int,
	@Completed_MachineName nvarchar(50),
	@DateSignedOff datetime,
	@SignOff_UserID int,
	@SignOff_MachineName nvarchar(50),
	@UserID int,
	@AssignSupplierID int,
	@ReminderDate datetime,
	@ReminderSent bit = NULL, -- This is not saved currently.
	@LocationID int
AS
BEGIN
	SET NOCOUNT ON

	-- BUG 7950 SP FIX
	SELECT @LocationID = NULLIF(@LocationID, 0) -- Do not allow zero for LocationID. It stops first new CA alert going out.

	DECLARE @DefaultCorrectiveActionEscalationID int
	SELECT @DefaultCorrectiveActionEscalationID = CorrectiveActionEscalationID 
	FROM QMS_CorrectiveActionEscalation 
	WHERE CorrectiveActionTypeID = @CorrectiveActionTypeID
	AND ListIndex = (	SELECT min(ListIndex) FROM QMS_CorrectiveActionEscalation 
						WHERE CorrectiveActionTypeID = @CorrectiveActionTypeID)
	-- END BUG 7950 fix

	IF ISNULL(@CorrectiveActionID,0)=0 --New record
	BEGIN
		INSERT INTO QMS_CorrectiveAction
						  (CASourceID, SourceObjectID, CATitle, CASubTitle, CAReason, CARequired, CAStatusID, CorrectiveActionTypeID, CorrectiveActionEscalationID, NotificationGroupID, 
						  AssignUserID, DateOccurred, PriorityLevelID, DateLogged, DateDeadline, Logged_UserID, Logged_MachineName, ActionTaken, Comments, DateCompleted, 
						  Completed_UserID, Completed_MachineName, AssignSupplierID, ReminderDate, LocationID)
		VALUES     (@CASourceID,@SourceObjectID,@CATitle,@CASubTitle,@CAReason,@CARequired,@CAStatusID,@CorrectiveActionTypeID,
					ISNULL(@CorrectiveActionEscalationID, @DefaultCorrectiveActionEscalationID),
					@NotificationGroupID,@AssignUserID,@DateOccurred,@PriorityLevelID,@DateLogged,@DateDeadline,@UserID,
						   HOST_NAME(),@ActionTaken,@Comments,@DateCompleted,@Completed_UserID,@Completed_MachineName,@AssignSupplierID, @ReminderDate, @LocationID)
	                      
		--Get new ID
		SELECT     @CorrectiveActionID = MAX(CorrectiveActionID)
		FROM         QMS_CorrectiveAction
	END
	ELSE --Update record
	BEGIN
		DECLARE @originalCAStatusID int
		SELECT	@originalCAStatusID = CAStatusID 
		FROM	QMS_CorrectiveAction
		WHERE	CorrectiveActionID = @CorrectiveActionID

		UPDATE    QMS_CorrectiveAction
		SET              SourceObjectID = @SourceObjectID, CATitle = @CATitle, CASubTitle = @CASubTitle, CAReason = @CAReason, CARequired = @CARequired, 
							  CAStatusID = @CAStatusID, CorrectiveActionTypeID = @CorrectiveActionTypeID, NotificationGroupID = @NotificationGroupID, AssignUserID = @AssignUserID, DateOccurred = @DateOccurred, 
							  PriorityLevelID = @PriorityLevelID, DateDeadline = @DateDeadline, ActionTaken = @ActionTaken, Comments = @Comments, DateCompleted = @DateCompleted, 
							  Completed_UserID = @Completed_UserID, Completed_MachineName = @Completed_MachineName, DateSignedOff = @DateSignedOff, 
							  SignOff_UserID = @SignOff_UserID, SignOff_MachineName = @SignOff_MachineName, 
							  RecordStatus = CASE WHEN RecordStatus = 30 THEN 20 ELSE RecordStatus END, Updated = GETUTCDATE(), AssignSupplierID = @AssignSupplierID, 
							  ReminderDate = @ReminderDate, LocationID = @LocationID
		WHERE     (CorrectiveActionID = @CorrectiveActionID)

		-- Only update notification flag if the status has changed.
		IF (@originalCAStatusID <> @CAStatusID)
		BEGIN
				--get Failure_NotificationGroupID for current CA escalation
			DECLARE @Failure_NotificationGroupID int 
			SELECT     @Failure_NotificationGroupID = Failure_NotificationGroupID
			FROM         QMS_CorrectiveActionEscalation
			WHERE     (CorrectiveActionEscalationID = @CorrectiveActionEscalationID)

			--if CA being set to Complete and a Failure_NotificationGroup has been set, reset NotificationGroup flag
			IF @CAStatusID = 4 --AND @Failure_NotificationGroupID IS NOT NULL --removed for TFS 7877 as this stops Completed alerts firing when no Failure_NotificationGroupID set
			BEGIN
				UPDATE	QMS_CorrectiveAction
				SET		NotificationSent = 0
				WHERE	(CorrectiveActionID = @CorrectiveActionID)
			END
			
				--if CA being set to Signed-off and AssignSupplierID has been set, reset NotificationGroup flag
			IF @CAStatusID IN (5, 6) AND @AssignSupplierID IS NOT NULL
			BEGIN
				UPDATE	QMS_CorrectiveAction
				SET		NotificationSent = 0
				WHERE	(CorrectiveActionID = @CorrectiveActionID)
			END
		END
	END
	SET NOCOUNT OFF

	SELECT @CorrectiveActionID
END

GO

/****** Object:  StoredProcedure [dbo].[SAVE_CustomLookup]    Script Date: 21/10/2014 09:16:16 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_CustomLookup]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[SAVE_CustomLookup]
GO
/****** Object:  StoredProcedure [dbo].[RPT_Specification_QuestionSub]    Script Date: 21/10/2014 09:16:16 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RPT_Specification_QuestionSub]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RPT_Specification_QuestionSub]
GO
/****** Object:  StoredProcedure [dbo].[RPT_DailySummary_FillSelected]    Script Date: 21/10/2014 09:16:16 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RPT_DailySummary_FillSelected]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[RPT_DailySummary_FillSelected]
GO
/****** Object:  StoredProcedure [dbo].[QRY_Menu_ReportsForUser]    Script Date: 21/10/2014 09:16:16 ******/
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_Menu_ReportsForUser]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[QRY_Menu_ReportsForUser]
GO
/****** Object:  StoredProcedure [dbo].[QRY_Menu_ReportsForUser]    Script Date: 21/10/2014 09:16:16 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[QRY_Menu_ReportsForUser]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[QRY_Menu_ReportsForUser] AS' 
END
GO
-- =============================================
-- Author:		Stephen Ford
-- Create date: 22.08.2013
-- Description:	Gets the reports menu items for
--              A given user
-- Version:		3
-- =============================================
-- MP TFS 8723: Added distinct clause to ensure duplicate permissions are ignored
-- SF TFS 3812: Selcted PermissionTypes of 0 or 1 to bring in parent and child menu items
-- JT TFS 10279: Check that PermissionTitle is numeric before trying to cast it as int.
-- =============================================
ALTER PROCEDURE [dbo].[QRY_Menu_ReportsForUser]
	@UserID int
AS
BEGIN
	SET NOCOUNT ON;
	DECLARE @AppID INT
	DECLARE @UserLevel INT
	DECLARE @UserIDForPermissions INT
	
	SELECT @AppId = 3

	SELECT     @UserLevel = ISNULL(User_Parent.UserLevel, QMS_User.UserLevel), @UserIDForPermissions = ISNULL(User_Parent.UserID, QMS_User.UserID)
	FROM         dbo.QMS_User LEFT OUTER JOIN
						  dbo.QMS_User AS User_Parent ON dbo.QMS_User.ParentUserID = User_Parent.UserID
	WHERE     (dbo.QMS_User.UserID = @UserID)

	SELECT DISTINCT 
                      APP_Menu.MenuID, APP_Menu.MenuIndex, APP_Menu.ParentID, ISNULL(dbo.FNC_ResourceString_User(APP_Menu.ResourceName, @UserID), 
                      APP_Menu.Description) AS MenuName, APP_Menu.IconName, APP_Menu.SeperatorBefore, APP_Menu.MenuAction, APP_Report.ReportDescription
	FROM         APP_Menu LEFT OUTER JOIN
                          (SELECT     PermissionTitle, PermissionAllow
                            FROM          QMS_UserPermissions
                            WHERE      (UserID = @UserIDForPermissions) AND (PermissionType in (0,1) AND ISNUMERIC(PermissionTitle) = 1)) AS MenuPermissions ON 
                      APP_Menu.MenuID = CAST(MenuPermissions.PermissionTitle AS INT) LEFT OUTER JOIN
                      APP_Report ON APP_Menu.MenuAction = APP_Report.MenuAction
	WHERE     (APP_Menu.AppID = @AppID) AND (APP_Menu.Visible = 1) AND (@UserLevel = 1) AND (APP_Menu.ParentID = 199 OR
                      APP_Menu.ParentID IN
                          (SELECT     MenuID
                            FROM          APP_Menu
                            WHERE      (ParentID = 199))) OR
                      (APP_Menu.AppID = @AppID) AND (APP_Menu.Visible = 1) AND (@UserLevel <> 1) AND (APP_Menu.ParentID = 199 OR
                      APP_Menu.ParentID IN
                          (SELECT     MenuID
                            FROM          APP_Menu
                            WHERE      (ParentID = 199))) AND (MenuPermissions.PermissionAllow = 1) OR
                      (APP_Menu.MenuID = 199)
	ORDER BY APP_Menu.MenuIndex

    
END

GO
/****** Object:  StoredProcedure [dbo].[RPT_DailySummary_FillSelected]    Script Date: 21/10/2014 09:16:16 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RPT_DailySummary_FillSelected]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RPT_DailySummary_FillSelected] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: unknown
-- Description:	Gets data for Daily summary report header
-- Version:		5
-- =============================================
-- JE TFS 4675: added Assessment Types param
-- JE TFS 4777: added provision for two tier filtering
-- JE TFS 5040: removed Location filtering as two tier filtering now implemented
-- JE TFS 5379: reinstated join on TEMP_ResponseFilter
-- JT TFS 13-8538: Log ResponseIDs to DEBUG tables to determine source of issues with daily reports.
-- =============================================
ALTER PROCEDURE [dbo].[RPT_DailySummary_FillSelected] 
	@UserID int,
    @AssessmentTypeID_LIST nvarchar(100)
AS
BEGIN
	--Clear temp selected
	DELETE FROM TEMP_Selected
	WHERE     (UserID = @UserID)

	--Insert into temp selected
	INSERT INTO TEMP_Selected
						  (SelectedID, UserID)
	SELECT     QMS_Response.ResponseID, @UserID AS UserID
	FROM         QMS_Response INNER JOIN
						  TEMP_ResponseFilter ON QMS_Response.ResponseID = TEMP_ResponseFilter.ResponseID
	WHERE     (QMS_Response.ResponseStatus = 1) AND (TEMP_ResponseFilter.UserID = @UserID) AND
					(@AssessmentTypeID_LIST = '0' OR
						QMS_Response.AssessmentTypeID IN (SELECT	CAST(Token AS int) AS AssessmentTypeID
															FROM	dbo.FNC_SplitString(@AssessmentTypeID_LIST, ',') AS SplitString_AssessmentType))

	SET NOCOUNT ON
	-- CAS-35175-S8P0X3
	IF NULLIF(object_id('DEBUG_TEMP_Selected'), 0) IS NOT NULL
	BEGIN
		INSERT DEBUG_TEMP_Selected (UniqueID, RunTime, UserID, SelectedID, SelectedText, SelectedValue, SelectedText2)
		SELECT convert(bigint, @@DBTS + 1), getutcdate(), UserID, SelectedID, SelectedText, SelectedValue, SelectedText2
		FROM TEMP_Selected 
		WHERE UserID = @UserID
	END
	IF NULLIF(object_id('DEBUG_TEMP_ResponseFilter'), 0) IS NOT NULL
	BEGIN
		INSERT DEBUG_TEMP_ResponseFilter (UniqueID, RunTime, UserID, ResponseID)
		SELECT convert(bigint, @@DBTS + 1), getutcdate(), UserID, ResponseID
		FROM TEMP_ResponseFilter 
		WHERE UserID = @UserID
	END
	IF NULLIF(object_id('DEBUG_TEMP_ResponseGroupBy'), 0) IS NOT NULL 
	BEGIN
		INSERT DEBUG_TEMP_ResponseGroupBy (UniqueID, RunTime, UserID, ResponseID, GroupByHeader, GroupByText)
		SELECT convert(bigint, @@DBTS + 1), getutcdate(), UserID, ResponseID, GroupByHeader, GroupByText
		FROM TEMP_ResponseGroupBy 
		WHERE UserID = @UserID
	END
	SET NOCOUNT OFF
END

GO
/****** Object:  StoredProcedure [dbo].[RPT_Specification_QuestionSub]    Script Date: 21/10/2014 09:16:16 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RPT_Specification_QuestionSub]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RPT_Specification_QuestionSub] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date:	Unknown
-- Description:	Gets Specification Question data
-- Version: 5
-- =============================================
-- JE TFS 4678: amended guidance subquery, so anything over 1850 characters is appended
-- JE TFS 4994: added QAS Flag colour columns
-- JE TFS 6121: changed join ConstraintAttachment so master spec attachments are included too
-- JF tfs10272 - ABP - Specification report oddities - limit size of ResponseFormula as it was spoiling the report
-- =============================================
ALTER PROCEDURE [dbo].[RPT_Specification_QuestionSub] 
	@AssessmentID int
AS
--declare @AssessmentID int = 2536
SELECT     QMS_AssessmentQuestion.AssessmentID, QMS_AssessmentQuestion.AssessmentQuestionID, 
                      CASE WHEN QMS_AssessmentQuestion.Hide = 1 THEN FNC_AssessmentQuestion_Sort.QuestionNumber + '*' ELSE FNC_AssessmentQuestion_Sort.QuestionNumber END
                       AS SortNumber, QMS_QuestionPool.Question, APP_DataType.DataType, APP_DataLookup.DataLookup, QMS_CustomLookup.LookupName AS CustomLookup, 
                      APP_QuestionLevel.QuestionLevel, CAST(CASE WHEN QMS_AssessmentQuestion.GuidanceID IS NULL THEN 0 ELSE 1 END AS bit) AS HasGuidance, 
                      QMS_Guidance.GuidanceDesc, QMS_Guidance.GuidanceString, QMS_AssessmentQuestion.ShortGuidance, QMS_Guidance.GuidanceURL, 
                      CASE WHEN LEN(QMS_Guidance.GuidanceURL) > 7 THEN CASE WHEN SUBSTRING(QMS_Guidance.GuidanceURL, 1, 7) 
                      = N'http://' THEN REPLACE(REPLACE(REPLACE(QMS_Guidance.GuidanceURL, 'http:', ''), '/', '\'), '%20', ' ') 
                      ELSE QMS_Guidance.GuidanceURL END ELSE QMS_Guidance.GuidanceURL END AS GuidanceUNC, Guidance_Attachments.NumAttachments, 
                      APP_QuestionScoreCalculation.ScoreCalculation, QMS_AssessmentQuestion.HasSamples, APP_SampleSummary.SampleSummary, 
                      QMS_AssessmentQuestion.ResponseRequired, QuestionConstraints.ConstraintText, QuestionConstraintGuidance.GreenGuidance, 
                      QuestionConstraintGuidance.AmberGuidance, QuestionConstraintGuidance.RedGuidance, ConstraintAttachment.Green_AttachmentTitle, 
                      ConstraintAttachment.Green_Attachment, ConstraintAttachment.Amber_AttachmentTitle, ConstraintAttachment.Amber_Attachment, 
                      ConstraintAttachment.Red_AttachmentTitle, ConstraintAttachment.Red_Attachment, 
					  case when len(QMS_AssessmentQuestion.ResponseFormula)>250 THEN left(QMS_AssessmentQuestion.ResponseFormula,250) + '...' ELSE QMS_AssessmentQuestion.ResponseFormula END as ResponseFormula, 
                      QMS_AssessmentQuestion.ScoreFormula, 
                      CASE WHEN QMS_AssessmentQuestion.Hide = 1 THEN FNC_AssessmentQuestion_Sort.QuestionNumber + '*: ' + QMS_QuestionPool.Question ELSE FNC_AssessmentQuestion_Sort.QuestionNumber
                       + ': ' + QMS_QuestionPool.Question END AS PDFBookmark,
                      --return QAS Flag colours as separate cols so these can be used to set text colours in report
				      (SELECT QAFlagBackColour FROM APP_QAFlag WHERE QAFlagID = 1) AS GreenBackColour,
					  (SELECT QAFlagBackColour FROM APP_QAFlag WHERE QAFlagID = 2) AS AmberBackColour,
					  (SELECT QAFlagBackColour FROM APP_QAFlag WHERE QAFlagID = 3) AS RedBackColour,
					  (SELECT QAFlagForeColour FROM APP_QAFlag WHERE QAFlagID = 1) AS GreenForeColour,
					  (SELECT QAFlagForeColour FROM APP_QAFlag WHERE QAFlagID = 2) AS AmberForeColour,
					  (SELECT QAFlagForeColour FROM APP_QAFlag WHERE QAFlagID = 3) AS RedForeColour
FROM         (SELECT     SourceObjectID AS GuidanceID, COUNT(AttachmentID) AS NumAttachments
                       FROM          QMS_Attachment
                       WHERE      (AttachmentSourceID = 3) AND (RecordStatus < 201)
                       GROUP BY SourceObjectID) AS Guidance_Attachments RIGHT OUTER JOIN
                      QMS_Guidance ON Guidance_Attachments.GuidanceID = QMS_Guidance.GuidanceID RIGHT OUTER JOIN
                      QMS_AssessmentQuestion INNER JOIN
                      dbo.FNC_AssessmentQuestion_Sort(@AssessmentID) AS FNC_AssessmentQuestion_Sort ON 
                      QMS_AssessmentQuestion.AssessmentQuestionID = FNC_AssessmentQuestion_Sort.AssessmentQuestionID INNER JOIN
                      QMS_QuestionPool ON QMS_AssessmentQuestion.QuestionID = QMS_QuestionPool.QuestionID LEFT OUTER JOIN
                      APP_QuestionScoreCalculation ON QMS_AssessmentQuestion.ScoreCalculationID = APP_QuestionScoreCalculation.ScoreCalculationID LEFT OUTER JOIN
                          (SELECT     AssessmentQuestionID,
                                                       (SELECT     AttachmentTitle
                                                         FROM          QMS_Attachment AS GreenTitle
                                                         WHERE      (AttachmentID = ConstraintGuidance.Green_AttachmentID)) AS Green_AttachmentTitle,
                                                       (SELECT     Attachment
                                                         FROM          QMS_Attachment AS GreenImage
                                                         WHERE      (AttachmentID = ConstraintGuidance.Green_AttachmentID)) AS Green_Attachment,
                                                       (SELECT     AttachmentTitle
                                                         FROM          QMS_Attachment AS AmberTitle
                                                         WHERE      (AttachmentID = ConstraintGuidance.Amber_AttachmentID)) AS Amber_AttachmentTitle,
                                                       (SELECT     Attachment
                                                         FROM          QMS_Attachment AS AmberImage
                                                         WHERE      (AttachmentID = ConstraintGuidance.Amber_AttachmentID)) AS Amber_Attachment,
                                                       (SELECT     AttachmentTitle
                                                         FROM          QMS_Attachment AS RedTitle
                                                         WHERE      (AttachmentID = ConstraintGuidance.Red_AttachmentID)) AS Red_AttachmentTitle,
                                                       (SELECT     Attachment
                                                         FROM          QMS_Attachment AS RedImage
                                                         WHERE      (AttachmentID = ConstraintGuidance.Red_AttachmentID)) AS Red_Attachment
                            FROM          dbo.FNC_Specification_ConstraintGuidance(@AssessmentID) AS ConstraintGuidance) AS ConstraintAttachment ON 
                      QMS_AssessmentQuestion.AssessmentQuestionID = ConstraintAttachment.AssessmentQuestionID OR
							--join on Sys_AssessmentQuestionID to get attachments from Master (if Master exists)
							QMS_AssessmentQuestion.Sys_AssessmentQuestionID = ConstraintAttachment.AssessmentQuestionID LEFT OUTER JOIN
                          (SELECT     ConstraintGuidance_1.AssessmentQuestionID, MAX(ConstraintGuidance_1.GreenGuidance) AS GreenGuidance, 
                                                   MAX(ConstraintGuidance_1.AmberGuidance) AS AmberGuidance, MAX(ConstraintGuidance_1.RedGuidance) AS RedGuidance
                            FROM          (SELECT     QMS_AssessmentQuestionConstraint.AssessmentQuestionID, 
                                                                           CASE WHEN QAFlagID = 1 THEN ISNULL(CAST(QMS_AssessmentQuestionConstraint.ShortGuidance AS nvarchar(4000)),
																					--check string length is less than 1450. Cut off end if not. 
																					CASE WHEN LEN(Constraint_Guidance.GuidanceString) < 1450 THEN Constraint_Guidance.GuidanceString
																						ELSE SUBSTRING(Constraint_Guidance.GuidanceString, 1, 1447) + '...' END)
																				ELSE NULL END AS GreenGuidance, 
                                                                           CASE WHEN QAFlagID = 2 THEN ISNULL(CAST(QMS_AssessmentQuestionConstraint.ShortGuidance AS nvarchar(4000)), 
																					--check string length is less than 1450. Cut off end if not. 
																					CASE WHEN LEN(Constraint_Guidance.GuidanceString) < 1450 THEN Constraint_Guidance.GuidanceString
																						ELSE SUBSTRING(Constraint_Guidance.GuidanceString, 1, 1447) + '...' END)
																				ELSE NULL END AS AmberGuidance, 
                                                                           CASE WHEN QAFlagID = 3 THEN ISNULL(CAST(QMS_AssessmentQuestionConstraint.ShortGuidance AS nvarchar(4000)), 
																					--check string length is less than 1450. Cut off end if not. 
																					CASE WHEN LEN(Constraint_Guidance.GuidanceString) < 1450 THEN Constraint_Guidance.GuidanceString
																						ELSE SUBSTRING(Constraint_Guidance.GuidanceString, 1, 1447) + '...' END)
																				ELSE NULL END AS RedGuidance
                                                    FROM          QMS_Guidance AS Constraint_Guidance RIGHT OUTER JOIN
                                                                           QMS_AssessmentQuestionConstraint ON Constraint_Guidance.GuidanceID = QMS_AssessmentQuestionConstraint.GuidanceID
                                                    WHERE      (QMS_AssessmentQuestionConstraint.RecordStatus < 201)) AS ConstraintGuidance_1 INNER JOIN
                                                   QMS_AssessmentQuestion AS QMS_AssessmentQuestion_1 ON 
                                                   ConstraintGuidance_1.AssessmentQuestionID = QMS_AssessmentQuestion_1.AssessmentQuestionID
                            WHERE      (QMS_AssessmentQuestion_1.AssessmentID = @AssessmentID) OR
                                                   (QMS_AssessmentQuestion_1.AssessmentID = @AssessmentID) OR
                                                   (QMS_AssessmentQuestion_1.AssessmentID = @AssessmentID)
                            GROUP BY ConstraintGuidance_1.AssessmentQuestionID
                            HAVING      (MAX(ConstraintGuidance_1.GreenGuidance) IS NOT NULL) OR
                                                   (MAX(ConstraintGuidance_1.AmberGuidance) IS NOT NULL) OR
                                                   (MAX(ConstraintGuidance_1.RedGuidance) IS NOT NULL)) AS QuestionConstraintGuidance ON 
                      QMS_AssessmentQuestion.AssessmentQuestionID = QuestionConstraintGuidance.AssessmentQuestionID LEFT OUTER JOIN
                      dbo.FNC_Specification_QuestionConstraints(@AssessmentID) AS QuestionConstraints ON 
                      QMS_AssessmentQuestion.AssessmentQuestionID = QuestionConstraints.AssessmentQuestionID LEFT OUTER JOIN
                      APP_SampleSummary ON QMS_AssessmentQuestion.SampleSummaryID = APP_SampleSummary.SampleSummaryID ON 
                      QMS_Guidance.GuidanceID = QMS_AssessmentQuestion.GuidanceID LEFT OUTER JOIN
                      APP_QuestionLevel ON QMS_AssessmentQuestion.QuestionLevelID = APP_QuestionLevel.QuestionLevelID LEFT OUTER JOIN
                      QMS_CustomLookup ON QMS_AssessmentQuestion.CustomLookupID = QMS_CustomLookup.CustomLookupID LEFT OUTER JOIN
                      APP_DataLookup ON QMS_AssessmentQuestion.DataLookupID = APP_DataLookup.DataLookupID LEFT OUTER JOIN
                      APP_DataType ON QMS_AssessmentQuestion.DataTypeID = APP_DataType.DataTypeID
WHERE     (QMS_AssessmentQuestion.AssessmentID = @AssessmentID) AND (QMS_AssessmentQuestion.RecordStatus < 201) AND (QMS_QuestionPool.RecordStatus < 201) 
                      AND (QMS_QuestionPool.Hide = 0)
ORDER BY FNC_AssessmentQuestion_Sort.SortIndex1, FNC_AssessmentQuestion_Sort.SortIndex2, FNC_AssessmentQuestion_Sort.SortIndex3, 
                      FNC_AssessmentQuestion_Sort.SortIndex4


GO
/****** Object:  StoredProcedure [dbo].[SAVE_CustomLookup]    Script Date: 21/10/2014 09:16:16 ******/
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SAVE_CustomLookup]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[SAVE_CustomLookup] AS' 
END
GO
-- =============================================
-- Author:		Markp
-- Create date: 08/07/2008
-- Description:	Adds and edits lookups
-- Version: 3
-- =============================================
-- JE TFS 8461 - updated to prevent edit of a lookup with existing child items
-- JE TFS 13-9811: allow lookup to be edited no Sys_Lookup specified 
-- =============================================
ALTER PROCEDURE [dbo].[SAVE_CustomLookup] 
	@CustomLookupID int,
	@LookupName nvarchar(50),
	@Hide bit,
	@UserID int
AS

SET NOCOUNT ON

IF ISNULL(@CustomLookupID,0)=0 --New record
BEGIN
	INSERT INTO QMS_CustomLookup
                      (LookupName, Hide, UserID)
	VALUES     (@LookupName,@Hide,@UserID)
	--Get new ID
	SELECT     @CustomLookupID = MAX(CustomLookupID)
	FROM         QMS_CustomLookup
END
ELSE --Update record
	BEGIN
		--check record we're trying to update has no Sys_Lookup value
		IF EXISTS (SELECT CustomLookupID FROM QMS_CustomLookup WHERE (QMS_CustomLookup.CustomLookupID = @CustomLookupID)
																AND (QMS_CustomLookup.RecordStatus < 201)
																AND (QMS_CustomLookup.Sys_Lookup IS NOT NULL))
			BEGIN
				RAISERROR('Cannot edit a lookup which has a Sys_Lookup value specified!', 11, 1)
				RETURN 0
			END
		ELSE
			UPDATE	QMS_CustomLookup
			SET		LookupName = @LookupName, Hide = @Hide, UserID = @UserID, MachineName = HOST_NAME(), Updated = GETUTCDATE()
			WHERE   (CustomLookupID = @CustomLookupID)
	END
SET NOCOUNT OFF

SELECT @CustomLookupID

GO

--PRINT 'Updating sync procedures...'

--PRINT 'Data migration tasks...'

PRINT 'Database updated successfully!'
GO
